Attribute VB_Name = "News_Fcns"
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     NEWSFCNS.BAS
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the NNTP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains addition functions of the sample application.
'
'------------------------------------------------------------

Option Explicit

'-------------------------------------------------------
Public Function BuildDatabase(NewDbName As String, ParamArray ObjScripts() As Variant) As Boolean
'-------------------------------------------------------
    Dim DB As Database                                  ' Database
    Dim RS As Recordset                                 ' Record set
    Dim SQL As Long                                     ' ObjScripts index variable
'-------------------------------------------------------
    If (Dir(NewDbName) <> "") Then Exit Function        ' Database already exists Exit
    
    On Error GoTo CleanUp                               ' Handle errors...
    Screen.MousePointer = vbHourglass
    
    Set DB = CreateDatabase(NewDbName, dbLangGeneral, dbVersion30)    ' Create new database

    For SQL = LBound(ObjScripts) To UBound(ObjScripts)  ' For each sql script parameter
        DB.Execute ObjScripts(SQL), dbSQLPassThrough    ' Execute sql script
    Next                                                ' Next parameter
'-------------------------------------------------------
CleanUp:                                                ' Clean up workspace...
'-------------------------------------------------------
    If Not (DB Is Nothing) Then DB.Close                ' Close database connection
    Set DB = Nothing                                    ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Function
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub DecodeMSG(Message As String, CmDlg As CommonDialog)
'-------------------------------------------------------
    Dim Fcn As Object
    Dim InData() As Byte
    Dim OutData() As Byte
    Dim LenMessage As Long
    Dim Done As Boolean
    Dim FileName As String
    Dim oFile As Long
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    Set Fcn = CreateObject("EncodeDecode.UUCode")
    
    LenMessage = Len(Message)
    InData = StrConv(Message, vbFromUnicode)
    ReDim OutData(LenMessage - 1) As Byte
    Call Fcn.MIMEDecodeStream(InData, OutData, Done)
    
    If Done Then
        CmDlg.DefaultExt = "*.*"
        CmDlg.InitDir = App.Path
        
        Screen.MousePointer = vbDefault
        CmDlg.ShowSave
        Screen.MousePointer = vbHourglass
        If ((CmDlg.CancelError) Or (CmDlg.FileName = "")) Then GoTo DoneDecoding

        oFile = FreeFile                                      ' Obtain next available file #
        Open CmDlg.FileName For Binary Access Write As #oFile ' Open output file
        
        Put #oFile, , OutData                                 ' Write Decoded data to output file
        Close #oFile
    End If
'-------------------------------------------------------
DoneDecoding:
'-------------------------------------------------------
    Set Fcn = Nothing
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddHeaderToList(List As ListView, Header As String, EventType As Long)
'-------------------------------------------------------
    Dim LenHeader As Long                           ' Length of header message...
    Dim NextLine As String                          ' Next line in header
    Dim Article As String                           ' Article number
    Dim Body As String                              ' Body value in nextline
    Dim SubBody As String                           ' Subset of body data
    Dim lnBegin As Long                             ' begin position of next line in header
    Dim lnEnd As Long                               ' end of line position in nextline
    Dim Pos As Long                                 ' position marker
    Static ExtraChunk As String
'-------------------------------------------------------
    If (ExtraChunk <> "") Then
        Header = ExtraChunk & Header
        ExtraChunk = ""
    End If
    
    LenHeader = Len(Header)                         ' Get length of entire header
    lnBegin = 1                                     ' Initialize begin of nextline position
    lnEnd = 1                                       ' Initialize end of nextline position
    
    On Error GoTo errorHandler                      ' Handle errors
    
    With List.ListItems                             ' Shorten ole references
        Do While (lnBegin < LenHeader)              ' While not at end of string
            lnEnd = InStr(lnBegin, Header, vbCrLf)  ' Look for end of line in buffer
            If (lnEnd > 0) Then                     ' Was end of line found
                NextLine = Mid(Header, lnBegin, lnEnd - lnBegin) ' Use entire line
            Else                                    ' Partial line was left over
                ExtraChunk = Mid(Header, lnBegin)   ' Save partial line for next batch
                Exit Do                             ' Exit loop
            End If
            If (NextLine = LASTLINE) Then           ' Is this the end of stream terminator
                EventType = eventDONE               ' Flag events processing as done
                Exit Do                             ' Exit loop
            End If
            
            Pos = InStr(1, NextLine, " ")           ' Look for end of article number
            Article = Mid(NextLine, 1, Pos - 1)     ' Parce out article number
            Body = Mid(NextLine, Pos + 1)           ' Parce out body of header line
            
            Select Case EventType                   ' Determine what kind of data is used
            Case eventGETARTICLESUBJECT             ' Body contains subject
                Call .Add(, ARTICLEKEY & Article, Article, icoNEWS, icoNEWS) ' Add article # to listview
                .Item(ARTICLEKEY & Article).SubItems(siSubject) = Body  ' Add subject to listview
            Case eventGETARTICLEFROM                ' Body contains from info
                .Item(ARTICLEKEY & Article).SubItems(siAuthor) = Body   ' Add from info to listview
            Case eventGETARTICLEDATE
            Case Else                               ' Unknown event
                Exit Sub                            ' Exit...
            End Select
            
            lnBegin = lnEnd + 2                     ' Move pointer to beginning of next line
        Loop                                        ' Get next line
    End With
    
    Exit Sub                                        ' Exit...
'-------------------------------------------------------
errorHandler:                                       ' Error handler
'-------------------------------------------------------
    Debug.Print Err.Number, Err.Description         ' Print debug info
    Debug.Print "Key Value:", "[" & ARTICLEKEY & Article & "]" ' Print extra info
    Resume Next                                     ' Continue...
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddGroupToTree(Tree As TreeView, NewsGroup As String)
'-------------------------------------------------------
    Dim Group As String
    Dim GroupDesc As String
    Dim SubGroup As String
    Dim FullSubGroup As String
    Dim Pos As Long
    Dim LenSTR As Long
    Dim NodeP As Node
    Dim oIcon As Long
    Dim cIcon As Long
'-------------------------------------------------------
    With Tree
        Set NodeP = .Nodes(1)                       ' Grab root node...
        If (NewsGroup = vbNullString) Then Exit Sub ' Validate group data...
        
        LenSTR = InStr(1, NewsGroup, vbTab) - 1     ' Search for end of group name
        If LenSTR < 1 Then LenSTR = InStr(1, NewsGroup, " ") - 1 ' Search for end of group name
        If LenSTR < 1 Then LenSTR = Len(NewsGroup)
        
        Group = Mid(NewsGroup, 1, LenSTR)           ' Extract group name only.
        GroupDesc = Trim(Mid(NewsGroup, LenSTR + 1))
        If (GroupDesc <> "") Then GroupDesc = " [" & GroupDesc & "]"
        
        On Error Resume Next                        ' Handle duplicate name entries...
        Pos = 1                                     ' Initialize position

        Do
            LenSTR = InStr(Pos, Group, ".") - Pos   ' Get end of subgroup name
            If LenSTR < 1 Then
                LenSTR = Len(Mid(Group, Pos))
                cIcon = icoNEWS
                oIcon = icoNEWS
            Else
                cIcon = icoCLOSEDFOLDER
                oIcon = icoOPENFOLDER
            End If
            
            SubGroup = Mid(Group, Pos, LenSTR)
            If (SubGroup = vbNullString) Then Exit Do ' Validate group data...
            FullSubGroup = Mid(Group, 1, LenSTR + Pos - 1)
            
            Set NodeP = .Nodes(FullSubGroup)
            If (NodeP.Key <> FullSubGroup) Then
                If (cIcon = icoNEWS) Then SubGroup = SubGroup & GroupDesc
                Set NodeP = .Nodes.Add(NodeP, tvwChild, FullSubGroup, SubGroup, cIcon, oIcon)
            ElseIf (FullSubGroup = Group) Then
                NodeP.Image = icoNEWS
                NodeP.SelectedImage = icoNEWS
            End If
            Pos = Pos + LenSTR + 1
        Loop Until (SubGroup = vbNullString)
    End With
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddGroupsToTree(Tree As TreeView, NewsGroupInfo As String)
'-------------------------------------------------------
    Dim FullGroup As String
    Dim grpPos As Long
    Dim LenGRP As Long
    Dim NodeP As Node
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    
    grpPos = 1                                          ' Position of first news group name...
    With Tree
        Do
            Set NodeP = .Nodes(1)                       ' Grab root node...
            LenGRP = InStr(grpPos, NewsGroupInfo, vbCrLf) - grpPos      ' Get length of group info
            If LenGRP < 1 Then LenGRP = Len(Mid(NewsGroupInfo, grpPos)) ' Validate length
            
            FullGroup = Mid(NewsGroupInfo, grpPos, LenGRP) ' Get group info
            If (FullGroup = vbNullString) Then Exit Do  ' Validate group data...
            
            Call AddGroupToTree(Tree, FullGroup)
            grpPos = grpPos + LenGRP + 2
        Loop Until (FullGroup = vbNullString)
    End With
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddGroupsToDatabase(DBName As String, NewsGroupInfo As String)
'-------------------------------------------------------
    Dim Group As String
    Dim FullGroup As String
    Dim GroupDesc As String
    Static ExtraData As String
    Dim grpPos As Long
    Dim LenSTR As Long
    Dim LenGRP As Long
    Dim DB As Database                                      ' Database object
    Dim RS As Recordset                                     ' Record set
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    grpPos = 1                                              ' Position of first news group name...
    On Error Resume Next
    
    Set DB = OpenDatabase(DBName)                           ' Open connection to database
    Set RS = DB.OpenRecordset("Groups", dbOpenTable, dbDenyRead + dbDenyWrite) ' Open resultset on table
    
    With RS
        Do
            If (ExtraData <> "") Then
                NewsGroupInfo = ExtraData & NewsGroupInfo   ' Use extra data saved from last session
                ExtraData = ""                              ' Clear extra data from variable
            End If
            
            LenGRP = InStr(grpPos, NewsGroupInfo, vbCr) - grpPos ' Get length of group info
            If (LenGRP < 1) Then
                ExtraData = Mid(NewsGroupInfo, grpPos)
                Exit Do
            End If
            
            FullGroup = Mid(NewsGroupInfo, grpPos, LenGRP)  ' Get group info
            If ((FullGroup = vbNullString) Or (FullGroup = ".")) Then
                Exit Do                                     ' Validate group data...
            End If
            
            LenSTR = InStr(1, FullGroup, vbTab) - 1         ' Search for end of group name
            If LenSTR < 1 Then LenSTR = InStr(1, FullGroup, " ") - 1 ' Search for end of group name
            If LenSTR < 1 Then LenSTR = Len(FullGroup)
            
            Group = Mid(FullGroup, 1, LenSTR)               ' Extract group name only.
            GroupDesc = " [" & Trim(Mid(FullGroup, LenSTR + 1)) & "]"
                    
            .AddNew                                         ' Insert new record
            .Fields(0) = Group
            .Fields(1) = GroupDesc
            .Update                                         ' Save changes.
            
            grpPos = grpPos + LenGRP + 2
        Loop Until (FullGroup = vbNullString)
    End With
    
    RS.Close                                                ' Close record set
    Set RS = Nothing                                        ' Destroy ole object reference
    DB.Close                                                ' Close database connection
    Set DB = Nothing                                        ' Destroy ole object reference
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddPersonalGroupToDatabase(DBName As String, PersonalGroup As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    
    On Error Resume Next                            ' Handle error in case Group already exists...
    Set DB = OpenDatabase(DBName)
    Set RS = DB.OpenRecordset("PersonalGroups", dbOpenTable) ' Open recordset...
    
    With RS
        .AddNew                                     ' Insert new record
        .Fields(0) = PersonalGroup                  ' Add Personal Group
        .Update                                     ' Save changes.
    End With
    
    RS.Close                                        ' Close record set
    Set RS = Nothing                                ' Destroy record set object
    DB.Close                                        ' Close database connection
    Set DB = Nothing                                ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddPersonalGroupsToTree(Tree As TreeView, DBName As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    
    On Error Resume Next                            ' Handle error in case Group already exists...
    Set DB = OpenDatabase(DBName)
    Set RS = DB.OpenRecordset("PersonalGroups", dbOpenTable) ' Open recordset...
    
    With RS
        Do While Not .EOF
            Call AddGroupToTree(Tree, .Fields(0))
            .MoveNext
        Loop
    End With
    
    RS.Close                                        ' Close record set
    Set RS = Nothing                                ' Destroy record set object
    DB.Close                                        ' Close database connection
    Set DB = Nothing                                ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------


'-------------------------------------------------------
Public Sub DeleteGroups(Tree As TreeView, DBName As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
    Dim Group As String                             ' Currently selected group
    Dim NodeP As Node                               ' Parent node
'-------------------------------------------------------
    'On Error Resume Next                            ' Handle error in case Group already exists...
    
    Group = Tree.SelectedItem.Key                   ' Get currently selected item
    If (Group = "") Or (Group = NEWSGROUPROOT) Then Exit Sub ' Valdiate node key
    
    Screen.MousePointer = vbHourglass
    
    '-------------------------------------------------------
    ' Delete group/s from database
    '-------------------------------------------------------
    Set DB = OpenDatabase(DBName)                   ' Open database
    
    DB.Execute "delete * from PersonalGroups where Name like '" & Group & "*'" ' Delete group/s
    
    DB.Close                                        ' Close database connection
    Set DB = Nothing                                ' Destory db object
    
    '-------------------------------------------------------
    ' Delete group/s from tree...
    '-------------------------------------------------------
    Tree.Nodes.Remove Group
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub PostMessage(NNTP As NNTP, PostName As String, PostEmail As String, NewsGroup As String, Subject As String, Body As String)
'-------------------------------------------------------
    Dim H As New DocHeadersCls
    Dim Name As String
    Dim Value As String
'-------------------------------------------------------
        
    Load frmPostMsg
    frmPostMsg.txtNewsGroup.Text = NewsGroup
    frmPostMsg.txtSubject.Text = Subject
    frmPostMsg.txtBody.Text = Body
    
    frmPostMsg.Show vbModal
    
    NewsGroup = frmPostMsg.txtNewsGroup.Text
    Subject = frmPostMsg.txtSubject.Text
    Body = frmPostMsg.txtBody.Text
    
    If (NewsGroup <> "") Then
    
        ' The following code sets a minimal NNTP Article
        ' header - these fields are taken from rfc1036
        H.Clear
        
        Name = "From"
        Value = PostName & " <" & PostEmail & ">"
        H.Add Name, Value
    
        Name = "Date"
        Value = Format(Date, "ddd, dd mmm yyyy") & " " & Format(Time, "hh:mm:ss") & " PST"
        H.Add Name, Value
        
        Name = "Newsgroups"
        Value = NewsGroup
        H.Add Name, Value
    
        Name = "Subject"
        Value = Subject
        H.Add Name, Value
    
        Name = "Message-ID"
        Value = "<" & Trim(Format(Date, "mmddyyyy")) & _
                      Trim(Format(Time, "hhmmss")) & _
                      PostEmail & ">"
        H.Add Name, Value
    
        Name = "Path"
        Value = NNTP.RemoteHost
        H.Add Name, Value
    
        NNTP.SendDoc , H, vbCrLf & Body & vbCrLf
    End If
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Sub ConnectToNewsServer(NNTP As NNTP, Name As String, Email As String, UserID As String, Password As String)
'-------------------------------------------------------
    Load frmNewsConnect                                 ' Load news group connnection dialog
    
    If (NNTP.RemoteHost <> "") Then frmNewsConnect.txtRemoteHost.Text = NNTP.RemoteHost
    frmNewsConnect.txtName.Text = Name
    frmNewsConnect.txtEmail.Text = Email
    frmNewsConnect.txtUserName.Text = UserID
    frmNewsConnect.txtPassword.Text = Password
    
    frmNewsConnect.Show vbModal                         ' Make it modal
    
    If (frmNewsConnect.txtRemoteHost.Text <> "") Then   ' Was data entered?
        If (NNTP.State = prcConnected) Then
            NNTP.Quit
            Do While (NNTP.State = prcConnected)
                DoEvents
            Loop
        End If
                    
        Name = frmNewsConnect.txtName.Text
        Email = frmNewsConnect.txtEmail.Text
        UserID = frmNewsConnect.txtUserName.Text
        Password = frmNewsConnect.txtPassword.Text
        NNTP.RemoteHost = frmNewsConnect.txtRemoteHost.Text ' Copy Remote Host Address
        NNTP.Connect                                    ' Connect to news server
    End If
    
    Unload frmNewsConnect                               ' Unload dialog
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

