Attribute VB_Name = "MailFunctions"
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     MAILFCNS.BAS
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the POP/SMTP control sample
'   application of the NetManage Inc. Internet Control Pack.
'   It contains library functions of the sample application.
'
'------------------------------------------------------------

Option Explicit

'-------------------------------------------------------
Public Function ParseMessage(msg As String, Group As String, Alias As String) As Boolean
'-------------------------------------------------------
    Dim strStart As Long                            ' start position of search string
    Dim strEnd As Long                              ' end position of search string
    Dim Body As String                              ' mail message body, string being searched for "Group" & "Alias"
'-------------------------------------------------------

    ' This code is expecting a message that will appear on the screen as:
    '
    '   <CR><LF>
    '   <CR><LF>
    '   <CR><LF>
    '   group_name<CR><LF>
    '   alias_name<CR><LF>
    '   .<CR><LF>
    '
    ' To generate such a message from this sample application, leave out the first blank line,
    ' <CR><LF>, and follow the remaining format.

    strStart = InStr(1, msg, vbCrLf & vbCrLf & vbCrLf) + 6      ' Search for body of mail message, assume headers are included...
    If (strStart > 6) Then                                      ' if body of message was found...
        strEnd = InStr(strStart, msg, vbCrLf & "." & vbCrLf) + 1 ' Search for end of body...
        If (strEnd > 0) Then                                    ' if found and body not empty
            Body = Mid(msg, strStart, strEnd - strStart + 1)    ' Copy body of message
            strEnd = InStr(1, Body, vbCrLf) - 1                 ' find end of first line
            If (strEnd > 0) Then                                ' if end of line found...
                Group = Mid(Body, 1, strEnd)                    ' extract group name
                strStart = strEnd + 3                           ' set pointer to next line
                strEnd = InStr(strStart, Body, vbCrLf) - 1      ' Find end of line
                If (strEnd > 0) Then                            ' if end of line found...
                    Alias = Mid(Body, strStart, strEnd - strStart + 1) ' extract alias from line
                    ParseMessage = True                         ' return success
                End If
            End If
        End If
    End If
'-------------------------------------------------------
End Function
'-------------------------------------------------------

'-------------------------------------------------------
Public Function BuildDatabase(NewDbName As String, ParamArray ObjScripts() As Variant) As Boolean
'-------------------------------------------------------
    Dim DB As Database                                  ' Database
    Dim RS As Recordset                                 ' Record set
    Dim SQL As Long                                     ' ObjScripts index variable
'-------------------------------------------------------
    If (Dir(NewDbName) <> "") Then Exit Function        ' Database already exists Exit
    
    On Error GoTo CleanUp                               ' Handle errors...
    Screen.MousePointer = vbHourglass
    
    Set DB = CreateDatabase(NewDbName, dbLangGeneral, dbVersion30)    ' Create new database

    For SQL = LBound(ObjScripts) To UBound(ObjScripts)  ' For each sql script parameter
        DB.Execute ObjScripts(SQL), dbSQLPassThrough    ' Execute sql script
    Next                                                ' Next parameter
'-------------------------------------------------------
CleanUp:                                                ' Clean up workspace...
'-------------------------------------------------------
    If Not (DB Is Nothing) Then DB.Close                ' Close database connection
    Set DB = Nothing                                    ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Function
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddAliasToDatabase(DBName As String, Group As String, Alias As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    
    On Error Resume Next                            ' Handle error in case Group already exists...
    Set DB = OpenDatabase(DBName)
    Set RS = DB.OpenRecordset("addresses", dbOpenTable) ' Open recordset...
    
    With RS
        .AddNew                                     ' Insert new record
        .Fields("groupname") = Group                ' Add Group
        .Fields("alias") = ""                       '
        .Update                                     ' Save changes.
        .AddNew                                     ' Insert new record
        .Fields("groupname") = Group                ' Add Group
        .Fields("alias") = Alias                    ' Add Alias
        .Update                                     ' Save changes.
    End With
    
    RS.Close                                        ' Close record set
    Set RS = Nothing                                ' Destroy record set object
    DB.Close                                        ' Close database connection
    Set DB = Nothing                                ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddAliasesToTree(Tree As TreeView, DBName As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
'-------------------------------------------------------
    Screen.MousePointer = vbHourglass
    On Error Resume Next                            ' Handle error in case Group already exists...
    
    Set DB = OpenDatabase(DBName)
    Set RS = DB.OpenRecordset("addresses", dbOpenTable) ' Open recordset...
    
    With RS
        Do While Not .EOF                           ' Get each alias from database
            Call AddAliasToTree(Tree, .Fields("groupname"), .Fields("alias")) ' Add alias to treeview
            .MoveNext                               ' Get next record from recordset
        Loop                                        ' continue...
    End With
    
    RS.Close                                        ' Close record set
    DB.Close                                        ' Close database connection
    Set RS = Nothing                                ' Destroy record set object
    Set DB = Nothing                                ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub AddAliasToTree(Tree As TreeView, Group As String, Alias As String)
'-------------------------------------------------------
    Dim NodeR As Node                               ' Root treeview node
    Dim NodeP As Node                               ' Parent treeview node
    Dim NodeC As Node                               ' Child treeview node
'-------------------------------------------------------
    With Tree
        Set NodeR = .Nodes(1)                       ' Grab root node...
        On Error Resume Next                        ' Handle duplicate name entries...
        
        Set NodeP = .Nodes(Group)                   ' Create reference to parent node
        If (NodeP Is Nothing) Then                  ' if parent node does not exist
            Set NodeP = .Nodes.Add(NodeR, tvwChild, _
                            Group, Group, icoGROUP) ' Create parent node
        End If
                
        If (Alias <> "") Then                       ' If Alias string is valid then...
            Set NodeC = .Nodes(Group & Alias)       ' Get node reference to alias
            If (NodeC Is Nothing) Then              ' If alias node does not exist...
                Set NodeC = .Nodes.Add(NodeP, tvwChild, Group & Alias, _
                                       Alias, icoALIAS) ' Add alias to treeview
            End If
        End If
    End With
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Public Sub DeleteAliases(Tree As TreeView, DBName As String)
'-------------------------------------------------------
    Dim DB As Database                              ' Database
    Dim RS As Recordset                             ' Record set
    Dim Group As String                             ' Email Group
    Dim Alias As String                             ' Email Alias
    Dim NodeC As Node                               ' Current node
'-------------------------------------------------------
    Set NodeC = Tree.SelectedItem                   ' Get currently selected node
    Group = NodeC.Key                               ' Get Node Key[groupname or groupname\alias]
    Alias = NodeC.Text                              ' Get Node Text[groupname or alias]
    If (Group = "") Or (Group = MAILGROUPROOT) Then Exit Sub ' Valdiate node key
    
    Screen.MousePointer = vbHourglass
    '-------------------------------------------------------
    ' Delete group\alias from database
    '-------------------------------------------------------
    Set DB = OpenDatabase(DBName)                   ' Open database
    
    If (Group = Alias) Then                         ' Node is group
        ' Delete group from database
        DB.Execute "delete * from addresses where groupname = """ & Group & """"
        Tree.Nodes.Remove Group                     ' Delete group/s from tree...
    Else                                            ' Node is alias only
        Group = NodeC.Parent.Text
        
        ' Delete alias from database
        DB.Execute "delete * from addresses where alias = """ & Alias & """" & _
                                        " and groupname = """ & Group & """"
        Tree.Nodes.Remove Group & Alias             ' Delete alias from tree...
    End If
    
    DB.Close                                        ' Close database connection
    Set DB = Nothing                                ' Destory db object
    
    Screen.MousePointer = vbDefault
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

