Attribute VB_Name = "tmpFunctions"
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     HTTPFCNS.BAS
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the HTTP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains library routines of the sample application.
'
'------------------------------------------------------------

Option Explicit

'------------------------------------------------------------
Public Function GetTempFileFromURL(URL As String, tmpName As String) As Boolean
'------------------------------------------------------------
    Dim tmpPath As String                               ' Windows temp path variable
    Dim lenPath As Long                                 ' length of path variable
    Dim pos As Long                                     ' search string position variable
    Dim rc As Long                                      ' function return code variable
'------------------------------------------------------------
    tmpPath = Space$(255)                               ' allocate 255 char string
    lenPath = Len(tmpPath)                              ' calc. length of string
    rc = GetTempPath(lenPath, tmpPath)                  ' get windows temp path
    
    If (rc < 2) Then Exit Function                      ' if temp path < 2 then path is invalid
    tmpPath = Left$(tmpPath, rc)                        ' trim actual path string from 255 char string
    
    If (Asc(Right$(tmpPath, 1)) = 0) Then tmpPath = Left$(tmpPath, rc - 1) ' Trim null terminator from path
    If (Right$(tmpPath, 1) <> "\") Then tmpPath = tmpPath & "\" ' Add directory separator if needed
    
    For pos = Len(URL) To 1 Step -1                     ' search URL string char. by char.
        If (Mid$(URL, pos, 1) = "/") Then               ' if URL separator is found then ...
            tmpName = tmpPath & Mid$(URL, pos + 1)      ' extract file name from URL
            Exit For                                    ' stop search
        End If
    Next                                                ' next char
    
    If ((tmpName <> tmpPath) And (Dir$(tmpName) <> "")) Then Exit Function ' handle file & path name errors...
    
    GetTempFileFromURL = True                           ' Return success
'------------------------------------------------------------
End Function
'------------------------------------------------------------

'------------------------------------------------------------
Public Sub ShellURLDoc(hWnd As Long, httpDocName As String)
'------------------------------------------------------------
    Dim rc As Long                                      ' Function return code variable
    Dim docPath As String                               ' receintly downloaded file path
    Dim docName As String                               ' receintly downloaded file name
    Dim pos As Long                                     ' search string position variable
'------------------------------------------------------------
    docName = Dir$(httpDocName)                         ' get file name if exists in path on drive
    If (docName <> "") Then                             ' if file exists...
        pos = InStr(1, httpDocName, docName) - 1        ' find position of file name in file path
        If (pos > 0) Then                               ' if file name found in path...
            docPath = Mid(httpDocName, 1, pos)          ' extract path only from string
            ' shell execute WIN95 & NT4 only
            rc = ShellExecute(hWnd, "open", httpDocName, 0, docPath, SW_SHOWDEFAULT)
        End If
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Public Sub AddURLDocToTree(Tree As TreeView, pNode As Node, Doc As String)
'------------------------------------------------------------
    Dim sURL As String                                  '
    Dim sURL2 As String                                 '
    Dim pURL As String                                  ' Parent url - base url???
    Dim URL As String                                   ' Current URL
    Dim uBegin As Long                                  ' begin url substring pointer
    Dim uEnd As Long                                    ' end url substring pointer
    Dim pos As Long                                     ' substring position pointer
'------------------------------------------------------------
    pURL = LCase$(pNode.Key)                            ' Get Parent URL...
    If ((Left$(Right$(pURL, 4), 1) = ".") Or _
        (Left$(Right$(pURL, 5), 1) = ".")) Then         ' If check if URL string has extention at the end
        For pos = Len(pURL) To 1 Step -1                ' Step through each char. starting from right
            If (Mid$(pURL, pos, 1) = "/") Then Exit For ' if separator found then finish
        Next
        pURL = Mid$(pURL, 1, pos)                       ' Extract parent URL...
    End If
    
    pos = InStr(8, pURL, "/") - 1                       ' Extract base URL (e.g. "http://www.netmanage.com")
    If (pos > 0) Then
        sURL = Mid(pURL, 1, pos)
    Else
        sURL = pURL
    End If
    
    Doc = LCase(Doc)                                    ' Copy http page to all lower case
    uBegin = 1                                          ' initialize search variables...
    uEnd = 0                                            '
    With Tree.Nodes
    Do                                                  ' do while more not at end of document
        If GetNextTagValue("href", Doc, uBegin, uEnd, URL) Then ' search for next href tag
            On Error Resume Next                        ' handle error for adding unique nodes to treeview
            
            pos = InStr(1, URL, ":")                    ' search for end of URL Protocol
            If (pos > 0) Then                           ' if URL Protocol exists...
                Select Case Mid$(URL, 1, (pos - 1))     ' determine URL Protocol
                Case "http"                             ' URL is an HTTP address, or a FILE name
                    pos = InStr(1, URL, "://")
                    If (pos > 0) Then
                    Call .Add(pNode, tvwChild, URL, URL, icoWEBPAGE) ' add url to treeview
                    Else
                    sURL2 = Mid(URL, 6) 'it's a relative path of current URL
                    Call .Add(pNode, tvwChild, sURL & sURL2, sURL2, icoWEBDOC) ' add url to treeview
                    End If
                Case "file"                     ' URL is an HTTP address, or a FILE name
                    Call .Add(pNode, tvwChild, URL, URL, icoWEBPAGE) ' add url to treeview
                Case "ftp"                              ' URL Protocol is an FTP address
                Case "mailto"                           ' URL Protocol is a MAIL address
                End Select
            Else                                        ' else assume URL is HTTP address only and not a document
                If (Left$(URL, 1) = "/") Then           ' if address is an incomplete address
                    Call .Add(pNode, tvwChild, sURL & URL, URL, icoWEBDOC) ' add BASE Address to URL, Add URL to treeview
                Else
                    Call .Add(pNode, tvwChild, pURL & URL, URL, icoWEBDOC) ' Add URL to treeview
                End If
            End If
        End If
        
        If Not ((uBegin > 1) And (uEnd > 0)) Then Exit Do ' while not at end of HTTP page...
    Loop Until URL = ""                                   ' Continue searching document for URL refs
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Public Function GetNextTagValue(Tag As String, Doc As String, uBegin As Long, uEnd As Long, URL As String) As Boolean
'------------------------------------------------------------
    uBegin = InStr(uBegin, Doc, Tag)                        ' Search for tag value
    If (uBegin > 0) Then                                    ' tag found...
        uBegin = InStr(uBegin, Doc, """") + 1               ' search for begin quote
        If (uBegin > 1) Then                                ' begin quote found...
            uEnd = InStr(uBegin, Doc, """") - 1             ' search for end quote
            If (uEnd > 0) Then                              ' end quote found
                URL = Mid$(Doc, uBegin, (uEnd - uBegin + 1)) ' Extract URL string from doc
                GetNextTagValue = True                      ' return success
                
                If (Right$(URL, 1) <> "/") Then             ' if url doesn't have url path separator then...
                    If ((Mid$(Right$(URL, 4), 1, 1) <> ".") And _
                        (Mid$(Right$(URL, 5), 1, 1) <> ".")) Then ' (determine OR guess) if url is a file or document, look for an extension
                        URL = URL & "/"                     ' add url path separator.
                    End If
                End If
            End If
        End If
    End If
'------------------------------------------------------------
End Function
'------------------------------------------------------------
