VERSION 4.00
Begin VB.Form frmTCP 
   Caption         =   "Simple TCP Client\Server"
   ClientHeight    =   3495
   ClientLeft      =   1125
   ClientTop       =   1755
   ClientWidth     =   4755
   Height          =   4185
   Icon            =   "frmTCP.frx":0000
   Left            =   1065
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   3495
   ScaleWidth      =   4755
   Top             =   1125
   Width           =   4875
   Begin VB.TextBox txtRemotePort 
      Height          =   285
      Left            =   2310
      TabIndex        =   3
      Text            =   "13"
      Top             =   240
      Width           =   945
   End
   Begin VB.TextBox txtLocalPort 
      Height          =   285
      Left            =   2310
      TabIndex        =   5
      Text            =   "701"
      Top             =   780
      Width           =   915
   End
   Begin VB.CommandButton cmdListen 
      Caption         =   "Listen"
      Height          =   315
      Left            =   3450
      TabIndex        =   8
      Top             =   780
      Width           =   1065
   End
   Begin VB.CommandButton cmdDisconnect 
      Caption         =   "Disconnect"
      Height          =   315
      Left            =   3450
      TabIndex        =   7
      Top             =   390
      Width           =   1065
   End
   Begin VB.TextBox txtOutput 
      Height          =   855
      Left            =   60
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      Top             =   2310
      Width           =   4635
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "Send Data"
      Height          =   285
      Left            =   60
      TabIndex        =   9
      Top             =   600
      Width           =   975
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Connect"
      Height          =   315
      Left            =   3450
      TabIndex        =   6
      Top             =   60
      Width           =   1065
   End
   Begin VB.TextBox txtInput 
      Height          =   855
      Left            =   60
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   11
      Top             =   1140
      Width           =   4635
   End
   Begin VB.TextBox txtRemoteHost 
      Height          =   285
      Left            =   60
      TabIndex        =   1
      Text            =   "127.0.0.1"
      Top             =   240
      Width           =   2145
   End
   Begin WINSOCKLib.TCP tcpServer 
      Left            =   1230
      Top             =   600
      _ExtentX        =   741
      _ExtentY        =   741
      RemoteHost      =   ""
      RemotePort      =   0
      LocalPort       =   0
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Remote Port:"
      Height          =   195
      Index           =   4
      Left            =   2310
      TabIndex        =   2
      Top             =   30
      Width           =   930
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Local Port:"
      Height          =   195
      Index           =   3
      Left            =   2310
      TabIndex        =   4
      Top             =   570
      Width           =   765
   End
   Begin VB.Label Status 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Closed"
      Height          =   255
      Left            =   60
      TabIndex        =   14
      Top             =   3210
      Width           =   4635
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Output:"
      Height          =   195
      Index           =   2
      Left            =   90
      TabIndex        =   12
      Top             =   2070
      Width           =   525
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Input:"
      Height          =   195
      Index           =   1
      Left            =   90
      TabIndex        =   10
      Top             =   930
      Width           =   405
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "RemoteHost:"
      Height          =   195
      Index           =   0
      Left            =   90
      TabIndex        =   0
      Top             =   30
      Width           =   930
   End
   Begin VB.Menu mClient 
      Caption         =   "Create Client..."
   End
End
Attribute VB_Name = "frmTCP"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     FRMTCP.FRM
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the TCP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains the main form of the sample application and the
'   form's associated code.
'
'------------------------------------------------------------

Option Explicit
Private Sub cmdConnect_Click()
    Status.Caption = ""                         ' Clear status
    If (tcpServer.State <> sckClosed) Then tcpServer.Close        ' If not closed then call close method to cleanup socket status
    tcpServer.Connect txtRemoteHost.Text, Val(txtRemotePort.Text) ' Connect to [Remote Host Address] [Remote Port]...
End Sub
Private Sub cmdDisconnect_Click()
    Status.Caption = "Closed"                   ' Update status
    tcpServer.Close                             ' Close socket connection
    
    cmdConnect.Enabled = True                   ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = False
    cmdListen.Enabled = True
    cmdSend.Enabled = False
End Sub
Private Sub cmdListen_Click()
    Status.Caption = "Listening"                 ' Update status, connection was accepted
    tcpServer.LocalPort = Val(txtLocalPort.Text) ' Set TCP Server's local port for listening
    tcpServer.Listen                             ' Start listening for connection requests...
    
    cmdConnect.Enabled = False                   ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = True
    cmdListen.Enabled = False
    cmdSend.Enabled = False
End Sub
Private Sub cmdSend_Click()
   tcpServer.SendData txtInput.Text             ' Send Input data to remote server
End Sub

Private Sub Form_Load()
    
    cmdConnect.Enabled = True                   ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = False
    cmdListen.Enabled = True
    cmdSend.Enabled = False

End Sub

Private Sub mClient_Click()
    Dim frm As New frmTCP                       ' Instance another form
    Load frm                                    ' Load form
    frm.Move Me.Left + 500, Me.Top + 500        ' Move form so it will display off to the side
    frm.Show                                    ' Show form
End Sub
Private Sub tcpServer_Close()
    Status.Caption = "Closed"                   ' Update status
    tcpServer.Close                             ' Call close method to cleanup any problems...
    
    cmdConnect.Enabled = True                   ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = False
    cmdListen.Enabled = True
    cmdSend.Enabled = False
End Sub
Private Sub tcpServer_Connect()
    Status.Caption = "Connected"                    ' Update status, connection was accepted
    txtRemotePort.Text = CStr(tcpServer.RemotePort) ' Display connected remote port
    txtLocalPort.Text = CStr(tcpServer.LocalPort)   ' Display dynamically allocated local port
    txtRemoteHost.Text = tcpServer.RemoteHost       ' Display remote host address
    
    cmdConnect.Enabled = False                      ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = True
    cmdListen.Enabled = False
    cmdSend.Enabled = True
End Sub
Private Sub tcpServer_ConnectionRequest(ByVal requestID As Long)
    If (tcpServer.State <> sckClosed) Then tcpServer.Close ' If not closed then call close method to cleanup socket status
    tcpServer.LocalPort = 0                         ' Set localport to dynamically get next available port
    tcpServer.Accept requestID                      ' Accept requested connection
    Status.Caption = "Connected"                    ' Update status as connected
    txtRemotePort.Text = CStr(tcpServer.RemotePort) ' Display connected remote port
    txtLocalPort.Text = CStr(tcpServer.LocalPort)   ' Display dynamically allocated local port
    txtRemoteHost.Text = tcpServer.RemoteHostIP     ' Display remote host address
    
    cmdConnect.Enabled = False                      ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = True
    cmdListen.Enabled = False
    cmdSend.Enabled = True
End Sub
Private Sub tcpServer_DataArrival(ByVal bytesTotal As Long)
    Dim Data As String                          ' Buffer for incomming data
    tcpServer.GetData Data                      ' Get data from socket
    txtOutput.Text = Data                       ' Put data in output box
End Sub
Private Sub tcpServer_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    Status.Caption = "Error:" & Description     ' Display error message
    tcpServer.Close                             ' Call close method to cleanup any problems...
    
    cmdConnect.Enabled = True                   ' Enable/Disable appropriate buttons
    cmdDisconnect.Enabled = False
    cmdListen.Enabled = True
    cmdSend.Enabled = False
End Sub
