VERSION 4.00
Begin VB.Form frmNNTP 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "NNTP Simple Net News Browser"
   ClientHeight    =   5790
   ClientLeft      =   840
   ClientTop       =   1200
   ClientWidth     =   8445
   Height          =   6195
   Icon            =   "frmNNTP.frx":0000
   Left            =   780
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   5790
   ScaleWidth      =   8445
   ShowInTaskbar   =   0   'False
   Top             =   855
   Width           =   8565
   Begin TabDlg.SSTab SSTab1 
      Height          =   5430
      Left            =   0
      TabIndex        =   17
      Top             =   30
      Width           =   8430
      _Version        =   65536
      _ExtentX        =   14880
      _ExtentY        =   9589
      _StockProps     =   15
      Caption         =   "Post Message"
      TabsPerRow      =   3
      Tab             =   2
      TabOrientation  =   0
      Tabs            =   3
      Style           =   1
      TabMaxWidth     =   0
      TabHeight       =   423
      TabCaption(0)   =   "Connect To News Server"
      Tab(0).ControlCount=   9
      Tab(0).ControlEnabled=   0   'False
      Tab(0).Control(0)=   "txtNewsserver"
      Tab(0).Control(1)=   "txtUser"
      Tab(0).Control(2)=   "txtPassword"
      Tab(0).Control(3)=   "cmdConnect"
      Tab(0).Control(4)=   "cmdDisconnect"
      Tab(0).Control(5)=   "NNTP"
      Tab(0).Control(6)=   "Label1(1)"
      Tab(0).Control(7)=   "Label1(2)"
      Tab(0).Control(8)=   "Label1(3)"
      TabCaption(1)   =   "Read News Groups"
      Tab(1).ControlCount=   8
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "txtOutput"
      Tab(1).Control(1)=   "txtNewsGroup"
      Tab(1).Control(2)=   "txtMessageID"
      Tab(1).Control(3)=   "cmdSelectGroup"
      Tab(1).Control(4)=   "cmdGetMessage"
      Tab(1).Control(5)=   "cmdListGroups"
      Tab(1).Control(6)=   "Label1(0)"
      Tab(1).Control(7)=   "Label1(6)"
      TabCaption(2)   =   "Post Message"
      Tab(2).ControlCount=   12
      Tab(2).ControlEnabled=   -1  'True
      Tab(2).Control(0)=   "Label1(8)"
      Tab(2).Control(1)=   "Label1(7)"
      Tab(2).Control(2)=   "Label1(5)"
      Tab(2).Control(3)=   "Label1(4)"
      Tab(2).Control(4)=   "txtGroup"
      Tab(2).Control(5)=   "txtMessage"
      Tab(2).Control(6)=   "txtSubject"
      Tab(2).Control(7)=   "cmdPost"
      Tab(2).Control(8)=   "txtEmailAddress"
      Tab(2).Control(9)=   "txtName"
      Tab(2).Control(10)=   "cmdPostFile"
      Tab(2).Control(11)=   "txtFileName"
      Begin VB.TextBox txtFileName 
         Height          =   288
         Left            =   5424
         TabIndex        =   29
         Top             =   336
         Width           =   2940
      End
      Begin VB.CommandButton cmdPostFile 
         Caption         =   "Post File->"
         Height          =   288
         Left            =   4440
         TabIndex        =   28
         Top             =   336
         Width           =   948
      End
      Begin VB.TextBox txtOutput 
         BeginProperty Font 
            name            =   "Courier New"
            charset         =   0
            weight          =   400
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   4368
         Left            =   -74952
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   8
         Top             =   996
         Width           =   8316
      End
      Begin VB.TextBox txtNewsGroup 
         Height          =   285
         Left            =   -73944
         TabIndex        =   6
         Top             =   312
         Width           =   1995
      End
      Begin VB.TextBox txtMessageID 
         Height          =   285
         Left            =   -73944
         TabIndex        =   7
         Top             =   660
         Width           =   1995
      End
      Begin VB.CommandButton cmdSelectGroup 
         Caption         =   "Select Group"
         Height          =   315
         Left            =   -71880
         TabIndex        =   9
         Top             =   312
         Width           =   1095
      End
      Begin VB.CommandButton cmdGetMessage 
         Caption         =   "Get Message"
         Height          =   315
         Left            =   -71880
         TabIndex        =   10
         Top             =   648
         Width           =   1095
      End
      Begin VB.CommandButton cmdListGroups 
         Caption         =   "List Groups"
         Height          =   315
         Left            =   -70752
         TabIndex        =   5
         Top             =   312
         Width           =   1095
      End
      Begin VB.TextBox txtName 
         Height          =   288
         Left            =   1320
         TabIndex        =   11
         Top             =   336
         Width           =   3060
      End
      Begin VB.TextBox txtEmailAddress 
         Height          =   288
         Left            =   1332
         TabIndex        =   12
         Top             =   636
         Width           =   3060
      End
      Begin VB.CommandButton cmdPost 
         Caption         =   "Post"
         Height          =   288
         Left            =   4440
         TabIndex        =   16
         Top             =   648
         Width           =   948
      End
      Begin VB.TextBox txtSubject 
         Height          =   288
         Left            =   1320
         TabIndex        =   14
         Top             =   1248
         Width           =   3084
      End
      Begin VB.TextBox txtMessage 
         BeginProperty Font 
            name            =   "Courier New"
            charset         =   0
            weight          =   400
            size            =   8.25
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   3852
         Left            =   48
         MultiLine       =   -1  'True
         ScrollBars      =   3  'Both
         TabIndex        =   15
         Top             =   1560
         Width           =   8340
      End
      Begin VB.TextBox txtGroup 
         Height          =   288
         Left            =   1332
         TabIndex        =   13
         Top             =   936
         Width           =   3060
      End
      Begin VB.TextBox txtNewsserver 
         Height          =   288
         Left            =   -73668
         TabIndex        =   0
         Top             =   336
         Width           =   2688
      End
      Begin VB.TextBox txtUser 
         Height          =   288
         Left            =   -73668
         TabIndex        =   1
         Top             =   636
         Width           =   2688
      End
      Begin VB.TextBox txtPassword 
         Height          =   288
         Left            =   -73668
         PasswordChar    =   "*"
         TabIndex        =   2
         Top             =   936
         Width           =   2688
      End
      Begin VB.CommandButton cmdConnect 
         Caption         =   "Connect"
         Height          =   315
         Left            =   -70896
         TabIndex        =   3
         Top             =   336
         Width           =   1095
      End
      Begin VB.CommandButton cmdDisconnect 
         Caption         =   "Disconnect"
         Height          =   315
         Left            =   -70896
         TabIndex        =   4
         Top             =   672
         Width           =   1095
      End
      Begin NNTPCTLib.NNTP NNTP 
         Left            =   -69660
         Top             =   330
         _ExtentX        =   741
         _ExtentY        =   741
         RemoteHost      =   "news"
         RemotePort      =   119
         ConnectTimeout  =   0
         RecvTimeout     =   0
         NotificationMode=   1
         LastUpdate      =   828656436
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "News Group:"
         Height          =   192
         Index           =   0
         Left            =   -74880
         TabIndex        =   27
         Top             =   360
         Width           =   936
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Message ID:"
         Height          =   192
         Index           =   6
         Left            =   -74880
         TabIndex        =   26
         Top             =   708
         Width           =   900
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Name:"
         Height          =   168
         Index           =   4
         Left            =   828
         TabIndex        =   25
         Top             =   372
         Width           =   492
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Email Address:"
         Height          =   168
         Index           =   5
         Left            =   204
         TabIndex        =   24
         Top             =   672
         Width           =   1128
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Subject:"
         Height          =   192
         Index           =   7
         Left            =   720
         TabIndex        =   23
         Top             =   1296
         Width           =   588
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "News Group:"
         Height          =   192
         Index           =   8
         Left            =   384
         TabIndex        =   22
         Top             =   960
         Width           =   936
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "News Server:"
         Height          =   192
         Index           =   1
         Left            =   -74688
         TabIndex        =   20
         Top             =   372
         Width           =   960
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "User Name:"
         Height          =   192
         Index           =   2
         Left            =   -74568
         TabIndex        =   19
         Top             =   672
         Width           =   840
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Password:"
         Height          =   192
         Index           =   3
         Left            =   -74448
         TabIndex        =   18
         Top             =   972
         Width           =   732
      End
   End
   Begin ComctlLib.StatusBar Status 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   21
      Top             =   5475
      Width           =   8445
      _Version        =   65536
      _ExtentX        =   14901
      _ExtentY        =   550
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      NumPanels       =   2
      i1              =   "frmNNTP.frx":030A
      i2              =   "frmNNTP.frx":0416
   End
End
Attribute VB_Name = "frmNNTP"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     FRMNNTP.FRM
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the NNTP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains the main form of the sample application and the
'   form's associated code.
'
'------------------------------------------------------------

Option Explicit

Public TRANSACTION As Long                          ' Used to store type of calling function.

' Function call transaction constants... Used to determine intent for data in DocOutput event...
Const transLISTGROUPS = 1                           ' ListGroups function call
Const transGETMESSAGE = 2                           ' GetArticleByArticleNumber function call
Const transGETARTICLEHEADERS = 3                    ' GetArticleHeaders function call...

Private Sub cmdConnect_Click()
    NNTP.Connect txtNewsserver.Text                 ' Connect to news server
End Sub
Private Sub cmdDisconnect_Click()
    NNTP.Quit                                       ' Disconnect from news server
End Sub
Private Sub cmdGetMessage_Click()
    TRANSACTION = transGETMESSAGE                   ' Set transaction value, used in DocOutput event
    NNTP.GetArticleByArticleNumber CStr(txtMessageID.Text) ' Get news article by number
End Sub
Private Sub cmdListGroups_Click()
    TRANSACTION = transLISTGROUPS                   ' Set transaction value, used in DocOutput event
    NNTP.ListGroups                                 ' Get complete list of news groups from server
End Sub                                             ' -can be quite large

'-------------------------------------------------------
Private Sub cmdPost_Click()
'-------------------------------------------------------
    Dim H As New DocHeadersCls                         ' DocHeaders collection
    Dim Content As String                           ' Contents of message...
    Dim Name As String                              ' Header name
    Dim Value As String                             ' Header value
'-------------------------------------------------------
    ' The following code creates the minimal headers required
    ' for an NNTP Article - these fields are defined in rfc1036
    H.Clear                                         ' Clear headers collection
    
    Name = "From"                                   ' From - MIME Type
    Value = txtName.Text & " <" & txtEmailAddress.Text & ">" ' "User Name <emailname>"
    H.Add Name, Value                               ' Add to collection

    Name = "Date"                                   ' Date - MIME Type
    Value = Format(Date, "ddd, dd mmm yyyy ") & _
            Format(Time, "hh:mm:ss") & " PST"       ' Format date value
    H.Add Name, Value                               ' Add to collection
    
    Name = "Newsgroups"                             ' Newsgroups - MIME Type
    Value = txtGroup.Text                           ' Get group name
    H.Add Name, Value                               ' Add to collection

    Name = "Subject"                                ' Subject - MIME Type
    Value = txtSubject.Text                         ' Copy subject...
    H.Add Name, Value                               ' Add to collection

    Name = "Message-ID"                             ' Message-ID - MIME Type
    Value = "<" & Trim(Format(Date, "mmddyyyy")) & _
                  Trim(Format(Time, "hhmmss")) & _
                  txtEmailAddress.Text & ">"        ' "<some unique-id & emailaddress>
    H.Add Name, Value                               ' Add to collection

    Name = "Path"                                   ' Path - MIME Type
    Value = NNTP.RemoteHost                         ' Use remotehost name\address
    H.Add Name, Value                               ' Add to collection
    
    Content = vbCrLf & txtMessage.Text & vbCrLf     ' Wrap message content with CrLf's(REQUIRED!)
    NNTP.SendDoc , H, Content                       ' Send document
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

'-------------------------------------------------------
Private Sub cmdPostFile_Click()
'-------------------------------------------------------
    Dim H As New DocHeadersCls                      ' DocHeaders collection
    Dim Name As String                              ' Header name
    Dim Value As String                             ' Header value
'-------------------------------------------------------
    ' The following code creates the minimal headers required
    ' for an NNTP Article - these fields are defined in rfc1036
    H.Clear                                         ' Clear headers collection
    
    Name = "From"                                   ' From - MIME Type
    Value = txtName.Text & " <" & txtEmailAddress.Text & ">" ' "User Name <emailname>"
    H.Add Name, Value                               ' Add to collection

    Name = "Date"                                   ' Date - MIME Type
    Value = Format(Date, "ddd, dd mmm yyyy ") & _
            Format(Time, "hh:mm:ss") & " PST"       ' Format date value
    H.Add Name, Value                               ' Add to collection
    
    Name = "Newsgroups"                             ' Newsgroups - MIME Type
    Value = txtGroup.Text                           ' Get group name
    H.Add Name, Value                               ' Add to collection

    Name = "Subject"                                ' Subject - MIME Type
    Value = txtSubject.Text                         ' Copy subject...
    H.Add Name, Value                               ' Add to collection

    Name = "Message-ID"                             ' Message-ID - MIME Type
    Value = "<" & Trim(Format(Date, "mmddyyyy")) & _
                  Trim(Format(Time, "hhmmss")) & _
                  txtEmailAddress.Text & ">"        ' "<some unique-id & emailaddress>
    H.Add Name, Value                               ' Add to collection

    Name = "Path"                                   ' Path - MIME Type
    Value = NNTP.RemoteHost                         ' Use remotehost name\address
    H.Add Name, Value                               ' Add to collection

    NNTP.SendDoc , H, , txtFileName.Text            ' Post document to NNTP Server...
'-------------------------------------------------------
End Sub
'-------------------------------------------------------

Private Sub cmdSelectGroup_Click()
    NNTP.SelectGroup txtNewsGroup.Text              ' Select current group
End Sub
Private Sub NNTP_AuthenticateRequest(UserId As String, Password As String)
    UserId = txtUser.Text                           ' News server requires authentication
    Password = txtPassword.Text                     ' Set UserId & Password in Output variables...
End Sub
Private Sub NNTP_AuthenticateResponse(ByVal Authenticated As Boolean)
    Dim answer As String                            ' Message box variable
    
    If Not Authenticated Then answer = "not "       ' Determine if authentication was successful
    MsgBox "Connection to " & NNTP.RemoteHost & " was " & answer & "authenticated." ' Display answer
End Sub
Private Sub NNTP_DocInput(ByVal DocInput As DocInput)
    Debug.Print "Bytes Sent:[" & _
                CStr(DocInput.BytesTransferred) & "] of [" & _
                CStr(DocInput.BytesTotal) & "]"     ' Display upload progress...
End Sub
Private Sub NNTP_Error(Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
    Debug.Print "Error: " & Description
End Sub

Private Sub NNTP_SelectGroup(ByVal groupName As String, ByVal firstMessage As Long, ByVal lastMessage As Long, ByVal msgCount As Long)
    Call NNTP.GetArticleHeaders("Subject", _
                                Trim$(Str$(firstMessage)), _
                                Trim$(Str$(lastMessage))) ' Get article numbers and subjects from 1st to last messages.
End Sub
Private Sub NNTP_StateChanged(ByVal State As Integer)
    Status.Panels(1).Text = NNTP.StateString        ' Update status panel with current state of connection
End Sub
Private Sub NNTP_ProtocolStateChanged(ByVal ProtocolState As Integer)
    Status.Panels(2).Text = NNTP.ProtocolStateString ' Update status panel with current protocol state of connection
End Sub
' --------------------------------------------------------
Private Sub NNTP_DocOutput(ByVal DocOutput As DocOutput)
' --------------------------------------------------------
    Dim Data As String                              ' Inbound data variable
    Dim Hdr As Object                               ' Header object
' --------------------------------------------------------
    Select Case DocOutput.State                     ' Determine current state of data transaction
    Case icDocBegin                                 ' [Begin download...]
        txtOutput.Text = ""                         ' Clear output-text box
    Case icDocHeaders                               ' [Headers arriving...]
        For Each Hdr In DocOutput.Headers           ' For each header in headers collection
            Debug.Print Hdr.Name, Hdr.Value         ' Debug info...
            
            Select Case LCase(Hdr.Name)             ' Determine type of header...
            Case "subject"                          ' "Subject"-MIME header type
                txtSubject.Text = Hdr.Value         ' Display Subject data
            Case "from"                             ' "From"-MIME header type
                txtName.Text = Hdr.Value            ' Display From data
                txtEmailAddress.Text = Hdr.Value    ' Display From data
            Case "newsgroups"                       ' "Newsgrouops"-MIME header type
                txtGroup.Text = Hdr.Value           ' Display Newsgroups data
            Case Else
            End Select
        Next                                        ' Get Next Header
    Case icDocData                                  ' [Incoming Data...]
        DocOutput.GetData Data                      ' Get data from DocOutput object...
        
        Select Case TRANSACTION                     ' Determine which function call fired this event...
        Case transLISTGROUPS                        ' ...ListGroups
            txtOutput.Text = txtOutput.Text & Data
        Case transGETMESSAGE                        ' ...GetArticleByArticleNumber
            txtOutput.Text = txtOutput.Text & Data
        Case transGETARTICLEHEADERS                 ' ...GetArticleHeaders
            txtOutput.Text = txtOutput.Text & Data  ' Retrieving message headers for current group...
        Case Else
        End Select
    Case icDocEnd                                   ' [Done with DocOutput transaction...]
    Case icDocError                                 ' [Error in DocOutput transaction...]
    Case icDocNone
    End Select
' --------------------------------------------------------
End Sub
' --------------------------------------------------------
