VERSION 4.00
Begin VB.Form frmHTTPExplorer 
   Caption         =   "Internet HTTP Explorer"
   ClientHeight    =   6825
   ClientLeft      =   1080
   ClientTop       =   1485
   ClientWidth     =   9015
   Height          =   7230
   Icon            =   "frmHTTP.frx":0000
   Left            =   1020
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   6825
   ScaleWidth      =   9015
   Top             =   1140
   Width           =   9135
   Begin VB.Timer tmrIcons 
      Left            =   9090
      Top             =   300
   End
   Begin VB.PictureBox SizeBar 
      BorderStyle     =   0  'None
      Height          =   6075
      Left            =   4320
      MousePointer    =   9  'Size W E
      ScaleHeight     =   6075
      ScaleWidth      =   30
      TabIndex        =   3
      Top             =   390
      Width           =   30
   End
   Begin HTTPCTLib.HTTP HTTP 
      Left            =   9090
      Top             =   750
      _ExtentX        =   741
      _ExtentY        =   741
      RemoteHost      =   "127.0.0.1"
      RemotePort      =   80
      ConnectTimeout  =   0
      RecvTimeout     =   0
      NotificationMode=   1
      Document        =   ""
      Method          =   1
   End
   Begin VB.Image picFlag 
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Left            =   8610
      Picture         =   "frmHTTP.frx":0442
      Stretch         =   -1  'True
      Top             =   0
      Width           =   420
   End
   Begin PicClip.PictureClip Flags 
      Left            =   9120
      Top             =   2370
      _Version        =   65536
      _ExtentX        =   11456
      _ExtentY        =   661
      _StockProps     =   0
      Cols            =   18
      Picture         =   "frmHTTP.frx":0B40
   End
   Begin RichtextLib.RichTextBox txtHTTP 
      Height          =   5745
      Left            =   4350
      TabIndex        =   5
      Top             =   690
      Width           =   4635
      _Version        =   65536
      _ExtentX        =   8176
      _ExtentY        =   10134
      _StockProps     =   69
      BackColor       =   -2147483643
      ScrollBars      =   3
      TextRTF         =   $"frmHTTP.frx":3A26
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   4350
      TabIndex        =   4
      Top             =   390
      Width           =   4665
   End
   Begin ComctlLib.ImageList imgIcons 
      Left            =   9090
      Top             =   1740
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   4
      i1              =   "frmHTTP.frx":3B05
      i2              =   "frmHTTP.frx":3FFC
      i3              =   "frmHTTP.frx":44F3
      i4              =   "frmHTTP.frx":49EA
   End
   Begin ComctlLib.ImageList imgTools 
      Left            =   9090
      Top             =   1140
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   1
      i1              =   "frmHTTP.frx":4EE1
   End
   Begin ComctlLib.TreeView Tree 
      Height          =   6075
      Left            =   0
      TabIndex        =   2
      Top             =   390
      Width           =   4305
      _Version        =   65536
      _ExtentX        =   7594
      _ExtentY        =   10716
      _StockProps     =   196
      Appearance      =   1
      HideSelection   =   0   'False
      ImageList       =   "imgIcons"
      Indentation     =   441
      LabelEdit       =   1
      PathSeparator   =   "\"
      Style           =   7
   End
   Begin ComctlLib.StatusBar Status 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   0
      Top             =   6480
      Width           =   9015
      _Version        =   65536
      _ExtentX        =   15901
      _ExtentY        =   609
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      _timers         =   2
      NumPanels       =   4
      i1              =   "frmHTTP.frx":52A0
      i2              =   "frmHTTP.frx":538F
      i3              =   "frmHTTP.frx":549B
      i4              =   "frmHTTP.frx":55EB
   End
   Begin ComctlLib.Toolbar Tools 
      Height          =   390
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   8565
      _Version        =   65536
      _ExtentX        =   15108
      _ExtentY        =   688
      _StockProps     =   96
      ImageList       =   "imgTools"
      NumButtons      =   2
      i1              =   "frmHTTP.frx":573B
      i2              =   "frmHTTP.frx":58DA
      AlignSet        =   -1  'True
   End
End
Attribute VB_Name = "frmHTTPExplorer"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     FRMHTTP.FRM
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the HTTP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains the main form of the sample application and the
'   form's associated code.
'
'------------------------------------------------------------

Option Explicit
Public CurrentNode As Node                              ' Currently selected treeview node
Public CurrentURL As String                             ' Current url in currently selected treeview node
Public httpDoc As String                                ' httpDocument url
Public httpDocName As String                            ' httpDocument name

Private Sub Form_Load()
    Set CurrentNode = Tree.Nodes.Add(, , HTTPROOT, HTTPROOT, icoWORLDWIDEWEB) ' Set default current node
End Sub

'------------------------------------------------------------
Private Sub Form_Resize()
'------------------------------------------------------------
    Dim W As Long                                           ' width variable
    Dim H As Long                                           ' heighth variable
'------------------------------------------------------------
    picFlag.Left = Me.ScaleWidth - picFlag.Width            ' position status flag
    Tools.Width = picFlag.Left                              ' position toolbar
    H = Abs(Me.ScaleHeight - Status.Height - Tools.Height)  ' calc height of controls
    Tree.Height = H                                         ' set treeview height
    SizeBar.Height = H                                      ' set sizebar height
    W = Abs(Me.ScaleWidth - SizeBar.Left - SizeBar.Width)   ' calc width of controls
    lblStatus.Width = W                                     ' set lable width
    With txtHTTP
        .Move .Left, .Top, W, Abs(H - .Top + lblStatus.Top) ' size http output text box
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub HTTP_DocOutput(ByVal DocOutput As DocOutput)
'------------------------------------------------------------
    Dim URL As String                                   ' HTTP URL
    Dim EXT As String                                   ' HTTP file extension
    Dim cNode As Node                                   ' child node
    Dim vData As Variant                                ' variant DocOuput data
'------------------------------------------------------------
    Select Case DocOutput.State                         ' Determine current state of DocOuptut download
    Case icDocBegin                                     ' Beginning download
        Screen.MousePointer = vbHourglass
        httpDoc = ""                                    ' Clear output data variable
        tmrIcons.Interval = 200                         ' Update timer funciton to animate download UI
    Case icDocHeaders                                   ' Document MIME-headers downloading...
    Case icDocData                                      ' Document data downloading...
        Debug.Print "Bytes: " & Str$(DocOutput.BytesTransferred) & "/" & _
                                Str$(DocOutput.BytesTotal) ' Debug\display bytes downloading...
        
        If (httpDocName = "") Then                      ' if not downloading to a binary file...
            DocOutput.GetData vData                     ' get data from DocOutput data stream
            httpDoc = httpDoc & vData                   ' append current data to document variable
        End If
    Case icDocEnd                                       ' End of data download
        If ((httpDocName = "") And (httpDoc <> "")) Then ' if not downloading to a binary file...
            txtHTTP.Text = httpDoc                      ' display http document contents...
            On Error Resume Next                        ' handle treeview node errors...
            Set cNode = Tree.Nodes.Add(Tree.Nodes(1).Key, tvwChild, _
                        CurrentURL, CurrentURL, icoWEBDOC) ' add new URL node to treeview
            If (cNode Is Nothing) Then Set cNode = Tree.Nodes(CurrentURL) ' if add failed then get current node
            cNode.Expanded = True                       ' expand current node
            
            If (cNode.Children = 0) Then                ' if no children available
                Call AddURLDocToTree(Tree, cNode, httpDoc) ' add url's to treeview
            End If
        End If
        httpDoc = ""                                    ' clear document contents variable
        tmrIcons.Interval = 0                           ' halt download animations
        Screen.MousePointer = vbDefault
    Case Else
        httpDoc = ""                                    ' clear document contents variable
        httpDocName = ""                                ' clear document download name
        tmrIcons.Interval = 0                           ' halt download animations
        Screen.MousePointer = vbDefault
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub HTTP_ProtocolStateChanged(ByVal ProtocolState As Integer)
    Status.Panels(2).Text = HTTP.ProtocolStateString ' Update protocol state status
End Sub
Private Sub HTTP_StateChanged(ByVal State As Integer)
    Status.Panels(1).Text = HTTP.StateString         ' Update state status
End Sub

'------------------------------------------------------------
Private Sub SizeBar_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'------------------------------------------------------------
    If (Button = vbLeftButton) Then                 ' If Left Button Down
        SizeBar.Left = SizeBar.Left + X             ' Move Size Bar
        Me.Refresh                                  ' Refresh improves appearence
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'------------------------------------------------------------
    Dim L As Long, W As Long, SW As Long            ' size and position variables
    Dim L2 As Long, W2 As Long                      ' secondary size and postion variables
'------------------------------------------------------------
    With SizeBar
        L = .Left                                   ' Get left position
        W = .Width                                  ' Get width
        SW = Me.ScaleWidth                          ' get current forms scalewidth, excluding border
        
        If (L < W) Then                             ' Outside Left Of Window
            L = W                                   ' Fix Position
            .Left = L                               ' Adjust sizebar position
        ElseIf (L > SW) Then                        ' Outside Right Of Window
            L = SW - W                              ' Fix Position
            .Left = L                               ' Adjust sizebar position
        End If
        
        Tree.Width = Abs(L - Tree.Left)             ' Resize TreeView Width
        L2 = L + W                                  ' calc left position of controls
        W2 = Abs(SW - L - W)                        ' calc width of controls
        
        lblStatus.Move L2, lblStatus.Top, W2        ' resize\position status label
        txtHTTP.Move L2, txtHTTP.Top, W2            ' resize\position textbox
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub tmrIcons_Timer()
' Animate picture box...
'------------------------------------------------------------
    Static pic As Long                                  ' static picture index variable
'------------------------------------------------------------
    picFlag.Picture = Flags.GraphicCell(pic)            ' get current picture from PicClip control
    picFlag.Refresh                                     ' refresh picture display
    pic = (pic + 1) Mod Flags.Cols                      ' increment picture index...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Tools_ButtonClick(ByVal Button As Button)
'------------------------------------------------------------
    Dim URL As String                                   ' HTTP URL string variable
    Dim defURL As String                                ' input msg box default - URL string...
    Dim msg As String                                   ' input msg box body string
    Dim Title As String                                 ' input msg box title
'------------------------------------------------------------
    Select Case Button.Index                            ' determine toolbar button pressed
    Case btnGLOBESEARCH                                 ' Global Search\ Add URL button
        msg = "Please enter a valid URL address..."
        Title = "Explore a new internet address..."
        defURL = "http://www.netmanage.com/"
        URL = InputBox(msg, Title, defURL)              ' Get URL from user input
        
        If (URL <> "") Then                             ' If URL was entered...
            URL = LCase$(URL)                           ' set all char.s to lowercase
            If (Left$(URL, 7) <> "http://") Then URL = "http://" & URL ' Add http:// address prefix if necessary
            If (Right$(URL, 1) <> "/") Then URL = URL & "/" ' add url address separator if necessary
            
            CurrentURL = URL                            ' save url to public variable
            HTTP.GetDoc CurrentURL                      ' retreive document
        End If
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Tree_NodeClick(ByVal Node As Node)
'------------------------------------------------------------
    Dim EXT As String                               ' URL file name extension
'------------------------------------------------------------
    If ((Node <> CurrentNode) And (Node.Key <> HTTPROOT)) Then ' Validate node in event...
        Set CurrentNode = Node                      ' save node to public variable
        CurrentURL = LCase(Node.Key)                ' save URL to public variable
        lblStatus.Caption = CurrentURL              ' Update url address in caption
        
        If (Left$(Right$(CurrentURL, 4), 1) = ".") Then EXT = Right$(CurrentURL, 3) ' get extension from URL
        
        Select Case EXT                             ' Determine document type in extension...
        Case "zip", "exe", "txt", "doc", _
             "gif", "jpg", "avi", "wav"             ' Download extentions...
            Call GetTempFileFromURL(CurrentURL, httpDocName) ' Create new local file name in temp dir...
            
            HTTP.GetDoc CurrentURL, , httpDocName   ' download doc into local temp directory
            Do While ((HTTP.DocOutput.State = icDocBegin) Or _
                      (HTTP.DocOutput.State = icDocData) Or _
                      (HTTP.DocOutput.State = icDocHeaders)) ' wait for download to complete
                DoEvents                            ' free process time to the UI
            Loop
            
            Load frmConfirm                         ' Load file download confirmation form
            frmConfirm.lblFileName.Caption = "" & "(" & UCase(EXT) & ")" ' Update UI info
            frmConfirm.Show vbModal                 ' Show modal form and wait for User response
            
            Select Case frmConfirm.Tag              ' User response was saved into tag property of form, determine response...
            Case CStr(vbOK)                         ' OK run file...
                Call ShellURLDoc(Me.hWnd, httpDocName) ' Run document as executable or related file type
            Case CStr(vbCancel)                     ' Download canceled...
            Case Else                               ' Save file as... requested.
                If (Dir$(frmConfirm.Tag) <> "") Then Kill frmConfirm.Tag ' delete file if exists...
                Name httpDocName As frmConfirm.Tag  ' rename temp file to saved file name
            End Select
            httpDocName = ""                        ' clear document download name...
            Unload frmConfirm                       ' unload confirm download dialog
        Case Else
            On Error Resume Next
            HTTP.GetDoc CurrentURL                  ' Get HTTP document, for display only...
        End Select
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

