VERSION 4.00
Begin VB.Form FTPExplorer 
   Caption         =   "Universal Internet Explorer"
   ClientHeight    =   5370
   ClientLeft      =   1365
   ClientTop       =   1845
   ClientWidth     =   9885
   Height          =   6060
   Icon            =   "Explorer.frx":0000
   Left            =   1305
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   5370
   ScaleWidth      =   9885
   Top             =   1215
   Width           =   10005
   Begin VB.CommandButton SizeBar 
      Height          =   4425
      Left            =   4230
      MousePointer    =   9  'Size W E
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   660
      Width           =   76
   End
   Begin FTPCTLib.FTP FTP 
      Index           =   0
      Left            =   10200
      Top             =   360
      _ExtentX        =   741
      _ExtentY        =   741
      RemoteHost      =   "127.0.0.1"
      RemotePort      =   21
      ConnectTimeout  =   0
      RecvTimeout     =   0
      NotificationMode=   0
      UserId          =   ""
      Password        =   ""
      AppendToFile    =   -1  'True
      ListItemNotify  =   -1  'True
      RemoteFile      =   ""
   End
   Begin VB.Label lFiles 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Contents"
      Height          =   255
      Left            =   4290
      TabIndex        =   0
      Top             =   390
      UseMnemonic     =   0   'False
      Width           =   5595
   End
   Begin VB.Label lFolders 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "All Folders"
      Height          =   255
      Left            =   0
      TabIndex        =   5
      Top             =   390
      Width           =   4275
   End
   Begin ComctlLib.ImageList tvImagesLarge 
      Left            =   10140
      Top             =   1890
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      NumImages       =   15
      i1              =   "Explorer.frx":27A2
      i2              =   "Explorer.frx":2B61
      i3              =   "Explorer.frx":2F20
      i4              =   "Explorer.frx":32DF
      i5              =   "Explorer.frx":369E
      i6              =   "Explorer.frx":3A5D
      i7              =   "Explorer.frx":3E1C
      i8              =   "Explorer.frx":41DB
      i9              =   "Explorer.frx":4D4A
      i10             =   "Explorer.frx":75A1
      i11             =   "Explorer.frx":7961
      i12             =   "Explorer.frx":7D21
      i13             =   "Explorer.frx":80E1
      i14             =   "Explorer.frx":84A1
      i15             =   "Explorer.frx":8861
   End
   Begin ComctlLib.ImageList tvImagesSmall 
      Left            =   10140
      Top             =   1320
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      NumImages       =   15
      i1              =   "Explorer.frx":8C21
      i2              =   "Explorer.frx":8FE0
      i3              =   "Explorer.frx":939F
      i4              =   "Explorer.frx":975E
      i5              =   "Explorer.frx":9B1D
      i6              =   "Explorer.frx":9EDC
      i7              =   "Explorer.frx":A29B
      i8              =   "Explorer.frx":A65A
      i9              =   "Explorer.frx":B1C9
      i10             =   "Explorer.frx":DA20
      i11             =   "Explorer.frx":DDE0
      i12             =   "Explorer.frx":E1A0
      i13             =   "Explorer.frx":E560
      i14             =   "Explorer.frx":E920
      i15             =   "Explorer.frx":ECE0
   End
   Begin ComctlLib.ImageList tbButtons 
      Left            =   10140
      Top             =   750
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   14
      i1              =   "Explorer.frx":F0A0
      i2              =   "Explorer.frx":F257
      i3              =   "Explorer.frx":F40E
      i4              =   "Explorer.frx":F5C5
      i5              =   "Explorer.frx":F77C
      i6              =   "Explorer.frx":F933
      i7              =   "Explorer.frx":FAEA
      i8              =   "Explorer.frx":FCA1
      i9              =   "Explorer.frx":FE58
      i10             =   "Explorer.frx":10097
      i11             =   "Explorer.frx":1024F
      i12             =   "Explorer.frx":10407
      i13             =   "Explorer.frx":105BF
      i14             =   "Explorer.frx":10777
   End
   Begin ComctlLib.Toolbar Tools 
      Align           =   1  'Align Top
      Height          =   390
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   9885
      _Version        =   65536
      _ExtentX        =   17436
      _ExtentY        =   688
      _StockProps     =   96
      ImageList       =   "tbButtons"
      NumButtons      =   20
      i1              =   "Explorer.frx":1092F
      i2              =   "Explorer.frx":10ACE
      i3              =   "Explorer.frx":10C79
      i4              =   "Explorer.frx":10E24
      i5              =   "Explorer.frx":10FC3
      i6              =   "Explorer.frx":1116E
      i7              =   "Explorer.frx":1131D
      i8              =   "Explorer.frx":114BC
      i9              =   "Explorer.frx":1167B
      i10             =   "Explorer.frx":1183E
      i11             =   "Explorer.frx":11A02
      i12             =   "Explorer.frx":11BA2
      i13             =   "Explorer.frx":11D6A
      i14             =   "Explorer.frx":11F0A
      i15             =   "Explorer.frx":120CE
      i16             =   "Explorer.frx":12296
      i17             =   "Explorer.frx":12436
      i18             =   "Explorer.frx":125DE
      i19             =   "Explorer.frx":12786
      i20             =   "Explorer.frx":1292A
      AlignSet        =   -1  'True
      Wrappable       =   0   'False
   End
   Begin ComctlLib.StatusBar Status 
      Align           =   2  'Align Bottom
      Height          =   300
      Left            =   0
      TabIndex        =   2
      Top             =   5070
      Width           =   9885
      _Version        =   65536
      _ExtentX        =   17436
      _ExtentY        =   529
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      _timers         =   2
      NumPanels       =   4
      i1              =   "Explorer.frx":12AEC
      i2              =   "Explorer.frx":12BF8
      i3              =   "Explorer.frx":12D04
      i4              =   "Explorer.frx":12E54
   End
   Begin ComctlLib.TreeView PathTree 
      DragIcon        =   "Explorer.frx":12FA4
      Height          =   4425
      Left            =   0
      TabIndex        =   1
      Top             =   660
      Width           =   4275
      _Version        =   65536
      _ExtentX        =   7541
      _ExtentY        =   7805
      _StockProps     =   196
      Appearance      =   1
      HideSelection   =   0   'False
      ImageList       =   "tvImagesSmall"
      Indentation     =   176
      LabelEdit       =   1
      PathSeparator   =   "\"
      Sorted          =   -1  'True
      Style           =   7
   End
   Begin ComctlLib.ListView FileList 
      DragIcon        =   "Explorer.frx":133E6
      Height          =   4425
      Left            =   4290
      TabIndex        =   3
      Top             =   660
      Width           =   5595
      _Version        =   65536
      _ExtentX        =   9869
      _ExtentY        =   7805
      _StockProps     =   205
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      Appearance      =   1
      Arrange         =   2
      Icons           =   "tvImagesLarge"
      MultiSelect     =   -1  'True
      SmallIcons      =   "tvImagesSmall"
      Sorted          =   -1  'True
      SortOrder       =   -1  'True
      SortKey         =   2
      View            =   3
      NumItems        =   5
      i1              =   "Explorer.frx":13828
      i2              =   "Explorer.frx":138D2
      i3              =   "Explorer.frx":1397C
      i4              =   "Explorer.frx":13A26
      i5              =   "Explorer.frx":13AD4
   End
   Begin VB.Menu mFile 
      Caption         =   "&File"
      Begin VB.Menu fNew 
         Caption         =   "&New"
         Enabled         =   0   'False
         Begin VB.Menu mFolder 
            Caption         =   "&Folder"
         End
      End
      Begin VB.Menu m_1 
         Caption         =   "-"
      End
      Begin VB.Menu mDelete 
         Caption         =   "&Delete"
         Enabled         =   0   'False
      End
      Begin VB.Menu mRename 
         Caption         =   "&Rename"
         Enabled         =   0   'False
      End
      Begin VB.Menu m_2 
         Caption         =   "-"
      End
      Begin VB.Menu mOpen 
         Caption         =   "&Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mClose 
         Caption         =   "&Close"
      End
   End
   Begin VB.Menu mEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mCopy 
         Caption         =   "&Copy"
      End
      Begin VB.Menu mPaste 
         Caption         =   "&Paste"
      End
   End
   Begin VB.Menu mView 
      Caption         =   "&View"
      Begin VB.Menu mLargeIcons 
         Caption         =   "Lar&ge Icons"
      End
      Begin VB.Menu mSmallIcons 
         Caption         =   "S&mall Icons"
      End
      Begin VB.Menu mList 
         Caption         =   "&List"
      End
      Begin VB.Menu mDetails 
         Caption         =   "&Details"
      End
      Begin VB.Menu m_3 
         Caption         =   "-"
      End
      Begin VB.Menu mRefresh 
         Caption         =   "&Refresh"
      End
   End
   Begin VB.Menu mTools 
      Caption         =   "&Tools"
      Begin VB.Menu mConnect 
         Caption         =   "&Connect"
         Begin VB.Menu mConNetworkDrive 
            Caption         =   "&Network Drive..."
         End
         Begin VB.Menu mConUNCPath 
            Caption         =   "&UNC Path..."
         End
         Begin VB.Menu mConFTPServer 
            Caption         =   "&FTP Server..."
         End
      End
      Begin VB.Menu mDisconnect 
         Caption         =   "&Disconnect"
         Begin VB.Menu mDisNetworkDrive 
            Caption         =   "&Network Drive..."
         End
         Begin VB.Menu mDisUNCPath 
            Caption         =   "&UNC Path...."
         End
         Begin VB.Menu mDisFTPServer 
            Caption         =   "&FTP Server..."
         End
      End
   End
   Begin VB.Menu mHelp 
      Caption         =   "&Help"
      Begin VB.Menu mHelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "FTPExplorer"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'------------------------------------------------------------
' Copyright  (c) 1996 NetManage Inc. -  All rights reserved
'
' File:     EXPLORER.FRM
'
' Date:     21 May 1996
'
' Description:
'
'           This file is part of the FTP control sample app-
'   lication of the NetManage Inc. Internet Control Pack.  It
'   contains the main form of the sample application and the
'   form's associated code.
'
'------------------------------------------------------------

Option Explicit

Dim FTPCallBack() As Integer                                ' FTP Control CallBack Var
Dim RefreshFlag As Boolean                                  ' TreeView Refresh Flag
Dim CurrentNode As Node

'------------------------------------------------------------
Private Sub RemoveFTPNode(Index As Integer)
'------------------------------------------------------------
    Dim NodeX As Node                                       ' Node Variable
    
    On Error GoTo NoSuchNode
    
    ' Copy Node Root...
    Set NodeX = PathTree.Nodes.Item(Me.Tag & ntINRCHILD & Format$(Index, FMTINDEX) & FTPROOTDIR)
    
    Call PathTree_NodeClick(NodeX.Parent)                   ' Change Focus To Parent Node...
    Call PathTree.Nodes.Remove(NodeX.Key)                   ' Remove FTP Node From Tree...
    
NoSuchNode:

    Unload FTP(Index)                                       ' Remove Control From Array
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FileList_AfterLabelEdit(Cancel As Integer, NewString As String)
'------------------------------------------------------------
    Dim OldKey As String                                    ' Preserves Selected Key's Name
'------------------------------------------------------------
    OldKey = FileList.SelectedItem.Key                      ' Save Key Value
    
    ' Attempt To Rename File
    If vRenameFile(FileList.SelectedItem, NewString, FTP, FTPCallBack, RefreshFlag) Then
        ' Is Refresh Flag Set
        If RefreshFlag Then
            ' Force PathTree Refresh
            Call PathTree_NodeClick(PathTree.Nodes.Item(OldKey).Parent)
        End If
    Else
        Cancel = True                                       ' Cancel Label Edit
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FileList_ColumnClick(ByVal ColumnHeader As ColumnHeader)
'------------------------------------------------------------
    FileList.Sorted = True                                  ' Enable Sorting Of The FileList
    If (FileList.SortKey = ColumnHeader.Index - 1) Then     ' If User Clicked On Selected Column Header
        If (FileList.SortOrder = lvwAscending) Then         ' Switch Sorting Direction
            FileList.SortOrder = lvwDescending
        Else
            FileList.SortOrder = lvwAscending
        End If
    Else                                                    ' Else User Clicked On A Different Column Header
        FileList.SortKey = ColumnHeader.Index - 1           ' So, Sort The File List By The New Column
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FileList_DblClick()
'------------------------------------------------------------
    ' Handle Error In Case Clicked Node Is Not A Valid Directory
    On Error Resume Next
    
    ' Get FileList Item And Force Click On It's Twin PathTree Node
    Call PathTree_NodeClick(PathTree.Nodes.Item(FileList.SelectedItem.Key))
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FileList_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
'------------------------------------------------------------
    If (Button = vbRightButton) Then                        ' Where The Right Mouse Button Is Pressed...
        If Not FileList.HitTest(1, y) Is Nothing Then       ' ...Highlight Any FileList Item Under The Cursor
            FileList.SelectedItem = FileList.HitTest(1, y)
        End If
    
        Me.PopupMenu mEdit                                  ' ...And Popup The Cut/Paste Menu
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_Load()
'------------------------------------------------------------
    Dim fCaption As String                                  ' Form's Caption
    Dim NodeX As Node                                       ' TreeView Node
    Dim cNode As Node                                       ' TreeView Node
'------------------------------------------------------------
    If App.PrevInstance Then                                ' If FTPExplorer Is Already Running...
        fCaption = App.title
        Me.Caption = ""
        App.title = ""
        AppActivate fCaption                                ' ...Activate Previous Instance
        SendKeys "^o", True
        End                                                 ' ...And Terminate This One
    Else
        ReDim FTPCallBack(0)                                ' Initialize Array Size
        ReDim AppCLIPBOARD(0)                               ' Initialize ClipBoard Array
        RefreshFlag = False                                 ' Set Refresh Default
        gUniqueID = gUniqueID + 1                           ' Increment Unique ID Counter
        Me.Tag = Format$(gUniqueID, FMTUID)                 ' Give Form A Unique ID
        
        ' Create DeskTop Node
        Set NodeX = PathTree.Nodes.Add(, , Me.Tag & ntDESKTOP & NULLIDX & NTRDESKTOP, NTRDESKTOP, TDESKTOP)
        
        ' Create My Computer Node
        Set cNode = PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER, NTRMYCOMPUTER, TMYCOMPUTER)
        Call LoadLocalDrives(PathTree, cNode)               ' Load Root Information For All Connected Drives (A:-Z:)
        
        ' Create Network UNC Node
        Call PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntNETWORK & NULLIDX & NTRNETWORK, NTRNETWORK, TNETDRIVE)
        
        ' Create Internet TCP
        Call PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntINTERNET & NULLIDX & NTRINTERNET, NTRINTERNET, TINTERNET)
        
        PathTree.Nodes(1).Expanded = True                   ' Force TreeView Root To Open
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
'------------------------------------------------------------
    Dim fc As FTP                                           ' FTP Control Instance
'------------------------------------------------------------
    On Error Resume Next                                    ' Ignore Errors
        
    For Each fc In FTP                                      ' For Each FTP Connection
        If (fc.Index > 0) Then                              ' Except The First Control Instance
            If (fc.State = prcConnected) Then               ' If It Is Connected
                fc.Quit                                     ' Disconnect It
            End If
        End If
    Next                                                    ' Next Connection
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_Resize()
'------------------------------------------------------------
    Dim h As Long
'------------------------------------------------------------
    h = Me.ScaleHeight - Status.Height - PathTree.Top       ' Get Lists Height
    If (h < 2) Then h = 2                                   ' Handle Height Error
    
    ' Resize TreeView Control
    PathTree.Move PathTree.Left, PathTree.Top, PathTree.Width, h
    
    ' Resize TreeView Label Width
    lFolders.Move PathTree.Left, lFolders.Top, PathTree.Width
    
    ' Resize Size Bar
    SizeBar.Move Abs(PathTree.Width - (SizeBar.Width \ 2)), PathTree.Top, SizeBar.Width, PathTree.Height
    
    ' ReSize ListView Control
    FileList.Move PathTree.Width, FileList.Top, Abs(ScaleWidth - PathTree.Width), PathTree.Height
    
    ' Resize ListView Label Width
    lFiles.Move FileList.Left, lFiles.Top, FileList.Width
    
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_DeleteDir(Index As Integer)
'------------------------------------------------------------
    FTPCallBack(Index) = FTPSUCCESS                         ' Set CallBack Status
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_DelFile(Index As Integer)
'------------------------------------------------------------
    FTPCallBack(Index) = FTPSUCCESS                         ' Set CallBack Status
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_DocInput(Index As Integer, ByVal DocInput As DocInput)
'------------------------------------------------------------
    Select Case DocInput.State
    Case icDocBegin
        Debug.Print "DocIN:Begin"
        FTP(Index).Tag = ""
    Case icDocData
        Debug.Print "DocIN:Data[" & Format(DocInput.BytesTransferred) & "] [" & _
                                    Format(DocInput.BytesTotal) & "]"
    Case icDocEnd
        Debug.Print "DocIN:End"
        FTPCallBack(Index) = FTPSUCCESS                     ' Set CallBack Status
    Case icDocError
        Debug.Print "DocIN:Error"
        FTPCallBack(Index) = FTPERROR                       ' Set CallBack Status
    Case icDocHeaders
        Debug.Print "DocIN:Headers"
    Case icDocNone
    Case Else
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_DocOutput(Index As Integer, ByVal DocOutput As DocOutput)
'------------------------------------------------------------
    Dim Data As String
    Dim length As Long
'------------------------------------------------------------

    Select Case DocOutput.State
    Case icDocBegin
        Debug.Print "DocOUT:Begin", DocOutput.filename
        FTP(Index).Tag = ""                                 ' Reset Receive Buffer
    Case icDocData
        Select Case FTP(Index).Operation
        Case ftpFile
        Case ftpList, ftpNameList
            Call DocOutput.GetData(Data)                    ' Get Data Block
            length = Len(Data)                              ' Get Length Of Received Block
            FTP(Index).Tag = FTP(Index).Tag & Data          ' Append Block To Receive Buffer
        End Select
        
        Debug.Print "DocOUT:Data[" & Format(DocOutput.BytesTransferred) & "] [" & _
                                     Format(DocOutput.BytesTotal) & "]"
    Case icDocEnd
        Debug.Print "DocOUT:End"
        FTPCallBack(Index) = FTPSUCCESS                     ' Set CallBack Status
    Case icDocError
        Debug.Print "DocOUT:Error"
        FTPCallBack(Index) = FTPERROR                       ' Set CallBack Status
    Case icDocHeaders
        Debug.Print "DocOUT:Headers", DocOutput.Headers.Count
    Case icDocNone
    Case Else
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_Error(Index As Integer, Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
'------------------------------------------------------------
    Dim er As icError
'------------------------------------------------------------
                                                            ' Display This Error
    Debug.Print "[================================================]"
    Debug.Print "FTP connection to " & FTP(Index).RemoteHost & " generated the following error:"
    Debug.Print "     Number: " & Number
    Debug.Print "      Scode: " & Hex$(Scode)
    Debug.Print "     Source: " & Source
    Debug.Print "Description: " & Description
    Debug.Print "[================================================]"

    For Each er In FTP(Index).Errors                        ' Display Error Stack
        Debug.Print "icError - Code:[" & Format(er.Code, "0") & "] "; _
                              "Type:[" & er.Type & "] "; _
                              "Description:[" & er.Description & "]"
    Next
    Debug.Print "[================================================]"

    FTP(Index).Errors.Clear                                 ' Clear Error Stack
    
    FTPCallBack(Index) = FTPERROR                           ' Return FTP CallBack Error...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_ListItem(Index As Integer, ByVal Item As FTPDirItem)
'------------------------------------------------------------
'    Debug.Print Item.Detail                                 ' Show Each Directory Entry Received
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_ProtocolStateChanged(Index As Integer, ByVal ProtocolState As Integer)
'------------------------------------------------------------
    Dim msg As String
    
    Select Case ProtocolState
    Case ftpBase
        msg = "Protocol: Base"
    Case ftpTransaction
        msg = "Protocol: Transaction"
    Case ftpAuthentication
        msg = "Protocol: Authorization"
    Case Else
    End Select
    
    Status.Panels(2).Text = msg                             ' Inform User Of Protocol Changes
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_Reinitialize(Index As Integer)
'------------------------------------------------------------
    FTPCallBack(Index) = FTPSUCCESS                         ' Set CallBack Status
    Debug.Print "Reinitialize", FTP(Index).ReplyString
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_StateChanged(Index As Integer, ByVal State As Integer)
'------------------------------------------------------------
    Status.Panels(1).Text = FTP(Index).StateString          ' Notify User Of State Change
    
    Select Case State
    Case prcDisconnected
        Call RemoveFTPNode(Index)                           ' Clean Up Tree...
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_Status(Index As Integer)
'------------------------------------------------------------
    ' Respond To Query About Control's State
    Status.Panels.Item(1).Text = "FTP Status [" & FTP(Index).ReplyString & "]"
    Debug.Print Status.Panels.Item(1).Text
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FTP_Timeout(Index As Integer, ByVal event As Integer, Continue As Boolean)
'------------------------------------------------------------
    Dim rc As Long
    rc = MsgBox(FTP(Index).Reply & "Would you like to remain connected?", _
                vbQuestion & vbYesNo, _
                "FTP Session Time Out")                     ' Notify User Of Timeout...
    
    FTP(Index).Continue = (rc = vbYes)
    If (rc = vbYes) Then
        FTP(Index).Reinitialize                             ' ReInitialize Connection...
    Else
        Call RemoveFTPNode(Index)                           ' Clean Up Tree...
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mClose_Click()
'------------------------------------------------------------
    Unload Me                                               ' Start App Shutdown
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mConFTPServer_Click()
'------------------------------------------------------------
    Dim Inst As Long                                        ' Instance Index Variable
    
    Inst = InstanceFTP(FTP, FTPCallBack)                    ' Create New FTP Control Instance
    Call AddFTPConnection(FTP(Inst), PathTree, Me)          ' Show FTP Connect Dialog And Connect
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mConNetworkDrive_Click()
'------------------------------------------------------------
    ' Show Network Connect Common Dialog
    If (ERROR_SUCCESS = WNetConnectionDialog(Me.hwnd, RESOURCETYPE_DISK)) Then
        ' ReLoad LocalDrive Information...
        Call LoadLocalDrives(PathTree, PathTree.Nodes.Item(Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER))
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mConUNCPath_Click()
'------------------------------------------------------------
    ' Prompt User To Add UNC Path...
    Call AddUNCPath(PathTree)
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mCopy_Click()
'------------------------------------------------------------
    Dim sItem As ListItem
    Dim i As Long
    
    ' Activated From FileList
    If Me.ActiveControl Is FileList Then                ' Clicked Over FileList
        If Not FileList.SelectedItem Is Nothing Then    ' Is Anything Selected
            Call FillClipBoard(FileList, AppCLIPBOARD)  ' Fill ClipBoard With All Selected Items...
            Exit Sub                                    ' Exit
        End If                                          ' OtherWise Drop Down...
    End If                                              ' Otherwise Drop Down...
    
    ' Activate From PathTree
    If Not PathTree.SelectedItem Is Nothing Then        ' Is PathTree Item Selected...
        ReDim AppCLIPBOARD(0)                           ' Resize ClipBoard Array
        AppCLIPBOARD(0) = PathTree.SelectedItem.Key     ' Copy Selected Object
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mDetails_Click()
'------------------------------------------------------------
    FileList.View = lvwReport                               ' Change File List View - Details, List, Small Icons
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mDisFTPServer_Click()
'------------------------------------------------------------
    ' Disconnect From FTP Servers...
    Call RemoveFTPConnection(PathTree, PathTree.Nodes.Item(Me.Tag & ntINTERNET & NULLIDX & NTRINTERNET), FTP)
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mDisNetworkDrive_Click()
'------------------------------------------------------------
    ' Show Network Disconnect Common Dialog
    If (ERROR_SUCCESS = WNetDisconnectDialog(Me.hwnd, RESOURCETYPE_DISK)) Then
        ' ReLoad LocalDrive Information...
        Call LoadLocalDrives(PathTree, PathTree.Nodes.Item(Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER))
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mDisUNCPath_Click()
'------------------------------------------------------------
    ' Call Function To Remove UNC Path Conntctions
    Call RemoveUNCPath(PathTree, PathTree.Nodes.Item(Me.Tag & ntNETWORK & NULLIDX & NTRNETWORK))
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mEdit_Click()
'------------------------------------------------------------
    Dim sItem As ListItem
    
    mCopy.Enabled = False                                   ' Default To Disabled
    mPaste.Enabled = False
    
    ' If We Have A Place To Paste To
    If (Me.ActiveControl Is PathTree) Or _
       (Me.ActiveControl Is FileList) Then
       
        ' Enable PASTE
        mPaste.Enabled = Not (AppCLIPBOARD(0) = "")
        
        ' If Something Is Selected...
        If Not Me.ActiveControl.SelectedItem Is Nothing Then
        
            ' ...In PathTree
            If Me.ActiveControl Is PathTree Then
                ' Enable COPY
                mCopy.Enabled = Me.ActiveControl.SelectedItem.Selected
                
            ' ...Or In FileList
            ElseIf Me.ActiveControl Is FileList Then
                ' Enable COPY
                For Each sItem In Me.ActiveControl.ListItems
                    If sItem.Selected Then mCopy.Enabled = True
                Next
            End If
            
        End If
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mHelpAbout_Click()
'------------------------------------------------------------
    ExpAbout.Show
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mLargeIcons_Click()
'------------------------------------------------------------
    FileList.View = lvwIcon                                 ' Change File List View - Large Icons
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mList_Click()
'------------------------------------------------------------
    FileList.View = lvwList                                 ' Change File List View - List, Small Icons
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mOpen_Click()
'------------------------------------------------------------
    Dim x As New FTPExplorer                        ' Explorer Form Variable
    x.Show                                          ' Open New Form Instance
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mPaste_Click()
'------------------------------------------------------------
    Dim dKey As String                                      ' Destination Node
    Dim i As Long                                           ' Loop Variable...
    
    ' If Activated From FileList
    If Me.ActiveControl Is FileList Then                    ' Clicked Over FileList
        If Not FileList.SelectedItem Is Nothing Then        ' Is Anything Selected
            dKey = FileList.SelectedItem.Key                ' Copy Selected Object
        End If
    End If
    
    ' Activated From PathTree
    If ((Not PathTree.SelectedItem Is Nothing) Or (dKey = "")) Then
        dKey = PathTree.SelectedItem.Key                    ' Copy Selected Object
    End If
    
    For i = LBound(AppCLIPBOARD) To UBound(AppCLIPBOARD)        ' For Each File Refer
        Call vCopyFile(AppCLIPBOARD(i), dKey, FTP, FTPCallBack) ' Copy Files
    Next                                                        ' Next File
    
    RefreshFlag = True                                      ' Notify PathTree To Refresh
    Call PathTree_NodeClick(CurrentNode)                    ' Refresh FileList...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mRefresh_Click()
'------------------------------------------------------------
    RefreshFlag = True                                      ' Notify PathTree To Refresh
    Call PathTree_NodeClick(CurrentNode)                    ' Refresh FileList...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub mSmallIcons_Click()
'------------------------------------------------------------
    FileList.View = lvwSmallIcon                            ' Change File List View - Small Icons
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub PathTree_AfterLabelEdit(Cancel As Integer, NewString As String)
'------------------------------------------------------------
    ' Attempt To Rename File... Determine Cancel Status...
    Cancel = Not vRenameFile(PathTree.SelectedItem, NewString, FTP, FTPCallBack, RefreshFlag)
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub PathTree_BeforeLabelEdit(Cancel As Integer)
'------------------------------------------------------------
    Dim NodeType As String
'------------------------------------------------------------
    NodeType = Mid(PathTree.SelectedItem.Key, (NODEFORMIDLEN + 1), NODEIDLEN) ' Extract Node Type...
    
    Select Case NodeType
    Case ntMCCHILD, ntNWCHILD                       ' My Computer Or UNC Network Child
    Case ntINCHILD                                  ' Internet TCP Child Connection
    Case Else
        Cancel = True                               ' Cancel The Edit...
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub PathTree_Expand(ByVal Node As Node)
'------------------------------------------------------------
    Call PathTree_NodeClick(Node)                       ' Force File List Repaint...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub PathTree_NodeClick(ByVal Node As Node)
'------------------------------------------------------------
    Dim NodeType As String                          ' Describes Tree View Node Type
    Dim CurPath As String                           ' Node's Current Path
    Dim Idx As Long                                 ' FTP Control Index
    Dim rc As Long                                  ' Function Call Return Code....
    Dim msg As String                               ' Protocol State Message
    Static LastNode As Node                         ' Remembers Last Node Touched...
'------------------------------------------------------------
    Set CurrentNode = Node
    
    If Not (LastNode Is Nothing) Then               ' Is This First Time?
        If (LastNode.Key = Node.Key) And (Not RefreshFlag) Then ' Is Same Node and Not Refreshing
            Exit Sub                                ' Don't Refresh...
        End If
    End If
    
    Node.Selected = True                            ' ReSelect Node
    NodeType = Mid(Node.Key, (NODEFORMIDLEN + 1), NODEIDLEN) ' Extract Node Type...
    CurPath = Mid(Node.Key, (NODEPREFIXLEN + NODEFTPIDXLEN + 1)) ' Extract Path From Node
    
    Select Case NodeType
    Case ntINCHILD, ntINRCHILD                      ' Internet Root, Child
        CurPath = CurPath & "/"                     ' Append FTP Path Sepparator To Path
    End Select
        
    lFiles.Caption = "Contents of '" & CurPath & "'" ' Update Caption
    Idx = CLng(Mid(Node.Key, (NODEPREFIXLEN + 1), NODEFTPIDXLEN)) ' Extract FTP Control Index ID...
    
    On Error Resume Next                            ' Handle Error If Node Is Deleted
    If Not (LastNode Is Nothing) Then               ' If Not First Node To Touch...
        Select Case LastNode.Image
        Case TFOLDEROPEN                            ' If Folder Is Open...
            LastNode.Image = TFOLDERCLOSED          ' ...Close Folder
        Case TSHORTCUTOPEN                          ' If ShortCut Is Open
            LastNode.Image = TSHORTCUTCLOSED        ' ...Close ShortCut
        End Select
    End If
    
    Set LastNode = Node                             ' Save Current Node As Last Node
    Select Case Node.Image                          ' Determine Image Status
    Case TFOLDERCLOSED                              ' If Folder Is Closed...
        Node.Image = TFOLDEROPEN                    ' ...Open Folder
    Case TSHORTCUTCLOSED                            ' If ShortCut Is Closed...
        Node.Image = TSHORTCUTOPEN                  ' ...Open ShortCut
    End Select
    
    FileList.ListItems.Clear                        ' Clear File ListBox...
    
    Me.Refresh                                      ' Repaint Window...
    Screen.MousePointer = vbHourglass               ' Set Mouse Pointer HourGlass
        
    Select Case NodeType                            ' Determine Node Type...
    '------------------------------------------------------------
    Case ntMYCOMPUTER                               ' My Computer Node...
    '------------------------------------------------------------
        Status.Panels(1).Text = ""                  ' FTP State Irrelevant Here
        Status.Panels(2).Text = ""                  ' FTP Protocol State Irrelevant Here
        Call LoadLocalDrives(PathTree, Node)        ' ReLoad Root Information...
        Screen.MousePointer = vbDefault             ' Reset Mouse Pointer
        Exit Sub                                    ' Exit
    '------------------------------------------------------------
    Case ntMCCHILD, ntMCRCHILD, ntNWCHILD, ntNWRCHILD ' My Computer, UNC -  Root, Child
        Status.Panels(1).Text = ""                  ' FTP State Irrelevant Here
        Status.Panels(2).Text = ""                  ' FTP Protocol State Irrelevant Here
    '------------------------------------------------------------
    Case ntINCHILD, ntINRCHILD                      ' Internet Root - Child
    '------------------------------------------------------------
        Status.Panels(1).Text = FTP(Idx).StateString  ' Notify User Of State Change
        Select Case FTP(Idx).ProtocolState            ' Inform User Of Protocol Changes
        Case ftpBase
            msg = "Protocol: Base"
        Case ftpTransaction
            msg = "Protocol: Transaction"
        Case ftpAuthentication
            msg = "Protocol: Authorization"
        Case Else
        End Select
        Status.Panels(2).Text = msg
        
        FTPCallBack(Idx) = ftpList                  ' Set FTP List Request Status...
        
        ' There are two means of collecting the entries in an ftp directory listing.
        ' The first means is to process each directory entry as it is received by
        ' enabling ListItem events of the FTP instance and processing each entry as
        ' it is received.  The second method is to gather the entire directory list
        ' in the DocOutput event of the FTP instance and then extract the entries
        ' from that list after it has all been received.  This sample implements both
        ' methods, sending ListItem event results to Debug.Print as they are received
        ' and translating the whole list for display from the DocOutput event in the
        ' GetDirs() and GetFiles() procedures called below.
        
        FTP(Idx).ListItemNotify = True              ' Enable ListItem Events
        FTP(Idx).List CurPath                       ' Get Directory Listing...
        
        Do While (FTPCallBack(Idx) = ftpList)       ' Wait For List Response
            DoEvents                                ' Jump Up And Down On The Message Queue
        Loop                                        ' Go Check Status
                
        If (FTPCallBack(Idx) = FTPERROR) Then Exit Sub ' Exit On Error...
    '------------------------------------------------------------
    Case Else
    '------------------------------------------------------------
        Screen.MousePointer = vbDefault             ' Reset Mouse Pointer
        Exit Sub                                    ' Exit Don't Process Any Further
    '------------------------------------------------------------
    End Select
    '------------------------------------------------------------
        
    Call SendMessage(PathTree.hwnd, WM_SETREDRAW, REDRAWOFF, 0) ' Turn PathTree Paint On
    Call GetDirs(PathTree, Node, FTP(Idx), RefreshFlag)         ' Get Directory Lists
    Call SendMessage(PathTree.hwnd, WM_SETREDRAW, REDRAWON, 0)  ' Turn PathTree Paint On
    PathTree.Refresh                                            ' Repaint PathTree
    
    Call SendMessage(FileList.hwnd, WM_SETREDRAW, REDRAWOFF, 0) ' Turn FileList Paint Off
    Call GetFiles(FileList, Node, FTP(Idx))                     ' Get Files/Info...
    Call SendMessage(FileList.hwnd, WM_SETREDRAW, REDRAWON, 0)  ' Turn FileList Paint On
    
    RefreshFlag = False                             ' Reset RefreshFlag
    
    Screen.MousePointer = vbDefault                 ' Reset Mouse Pointer
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
'------------------------------------------------------------
    If ((Button = vbLeftButton)) Then                   ' If Left Button Down
        SizeBar.Left = SizeBar.Left + x                 ' Move Size Bar
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
'------------------------------------------------------------
    Dim Bdr As Long                                     ' Border Width...
'------------------------------------------------------------
    Bdr = SizeBar.Width \ 2                             ' Border Width 1\2 Of SizeBar Width
    
    ' Check Position Of SizeBar And Fix If OutSide Of Window...
    If (SizeBar.Left < SizeBar.Width) Then              ' Outside Left Of Window
        SizeBar.Left = 1                                ' Fix Position
    ElseIf (SizeBar.Left > Me.ScaleWidth) Then          ' Outside Right Of Window
        SizeBar.Left = Me.ScaleWidth - SizeBar.Width    ' Fix Position
    End If
    
    PathTree.Width = Abs(SizeBar.Left + Bdr)            ' Resize TreeView Width
    lFolders.Width = PathTree.Width                     ' Resize TreeView Label Width
    
    ' ReSize ListView Control
    FileList.Move PathTree.Width, FileList.Top, Abs(Me.ScaleWidth - PathTree.Width)
    
    ' Resize ListView Label Width
    lFiles.Move FileList.Left, lFiles.Top, FileList.Width
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Tools_ButtonClick(ByVal Button As Button)
'------------------------------------------------------------
    Dim rc As Long
    Dim PrevNode As Node
'------------------------------------------------------------
    Select Case Button.Image
    Case TBPREVIOUS                                 ' Traverse Up The Tree One Notch...
        Set PrevNode = PathTree.SelectedItem.Parent ' Copy Parent Node...
        
        If Not (PrevNode Is Nothing) Then           ' If Not First Node To Touch...
            Call PathTree_NodeClick(PrevNode)       ' Traverse The Node Tree...
            PrevNode.Selected = True                ' Select Node
        End If
        PathTree.SetFocus                           ' Set Focus TreeView Control
    Case TBNEW                                      ' Open A New Window...
        Call mOpen_Click
    Case TBNETCONNECT                               ' Connect To Network Drive
        Me.PopupMenu mConnect, , vbPopupMenuRightButton
    Case TBTBNETDISCONNECT                          ' Disconnect From Network Drive
        Me.PopupMenu mDisconnect, , vbPopupMenuRightButton
    Case TBCUT                                      '
        ' Unimplemented
    Case TBCOPY                                     '
        ' Unimplemented
    Case TBPASTE                                    '
        ' Unimplemented
    Case TBUNDODELETE                               '
        ' Unimplemented
    Case TBDELETE                                   ' Delete Current File Or Directory
        ' Unimplemented
    Case TBPROPERTIES                               '
        ' Unimplemented
    Case TBVIEWLARGEICONS                           ' Change File List View - Large Icons
        FileList.View = lvwIcon
    Case TBVIEWSMALLICONS                           ' Change File List View - Small Icons
        FileList.View = lvwSmallIcon
    Case TBVIEWLIST                                 ' Change File List View - List, Small Icons
        FileList.View = lvwList
    Case TBVIEWDETAILS                              ' Change File List View - Details, List, Small Icons
        FileList.View = lvwReport
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

