/* Update OS/2 client systems to the current version of IBM AntiVirus/2  */
/* if they are not already updated.  If the date of the IBMAVSH.COM      */
/* file has changed on the server, do a full re-install.  If a response  */
/* file named IBMAV.RSP is present on the server, the install program    */
/* will use it.  If the date of the file IBMAVSH.COM hasn't changed,     */
/* just update the various data files.  All administrators have to do    */
/* is copy the updated files into the "execution directory" on the       */
/* server.  Note that, if you erase a data file in the execution         */
/* directory, it will be erased from the home directory of *alll*        */
/* client PCs !  Refer to the IBM AntiVirus Administrator's Guide        */
/* for more information.                                                 */

'@echo off'

/* Get the arguments - the Home Directory and the Execution Directory. */

arg HomeDir ExecutionDir
HomeDir      = strip(HomeDir)
ExecutionDir = strip(ExecutionDir)

/* Make sure the REXX utility function SysFileTree is available. */

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Invoke the install program or just update files, as appropriate. */

if changed('IBMAVSH.COM') then do
   if exist(ExecutionDir'IBMAV.RSP') then
      ExecutionDir'INSTALL /R='ExecutionDir'IBMAV.RSP'
   else
      ExecutionDir'INSTALL /AUTO'
end
else do
   call update 'VIRSIG.LST'
   call update 'SHSIG.LST'
   call update 'DTSIG.LST'
   call update 'VERV.VDB'
   call update 'LOCAL.MSG'
   call update 'ADDENDA.LST'
end
return
/* If filename is different in the home and execution directories, */
/* then copy filename from the execution directory to the home     */
/* directory.  If filename does not exist in the execution         */
/* directory, erase it from the home directory.                    */

update: procedure expose ExecutionDir HomeDir
   arg filename
   if changed(filename) then
      do
         if exist(ExecutionDir||filename) then
            'COPY' ExecutionDir||filename  HomeDir||filename
         else
            'ERASE' HomeDir||filename
      end
   return

/* Return 1 if filename has the same date and time in the home   */
/* and execution directories.  Return 0 otherwise.               */

changed: procedure expose ExecutionDir HomeDir
   arg filename
   rc = ( filedate(HomeDir||filename)         <>  ,
          filedate(ExecutionDir||filename) )
   return rc

/* Return the date and time stamps of filespec. */
/* Return null if filespec does not exist.      */

filedate: procedure
   arg filespec
   if exist(filespec) then
      do
         call  SysFileTree  filespec, results, 'F'
         call  stream  filespec, 'c', 'close'
         parse var results.1 datestamp timestamp .
         rc = datestamp || timestamp
      end
   else rc = ''
   return rc

/* Return 1 if filespec exists, 0 otherwise. */

exist: procedure
   arg filespec
   rc = lines(filespec)
   call  stream  filespec, 'c', 'close'
   return rc
