/* Installation Program for Lotus Phone Notes 2.0 Execution Machine (OS/2) */
/* trace ?r */
ECHO OFF
'Cls'

/* set up the function to call */
call RxFuncAdd 'SysFileSearch', 'RexxUtil', 'SysFileSearch'

parse arg  sdrv  tdrv  notesdir

if sdrv = "" | tdrv = "" | notesdir = "" then
      call  instructions

/* Check for valid input  */
fname = sdrv || '\pnotes.exe'
retc = SysFileSearch(' ', fname, 'junk.', 'C')
if retc = 3  then
        call error

/* verify and switch to the target Notes data directory */
dirname = tdrv || notesdir
rc = directory(dirname)
if rc = "" then
        call error

/* See if there's a PNOTES directory */
dirname = tdrv || notesdir || '\PNOTES'
rc = directory(dirname)
if rc = dirname then do
        say
        say ''
        say 'A \PNOTES subdirectory already exists off of the Notes data directory.'
        say
        say 'WARNING: If you continue with this installation all files in \PNOTES will'
        say '      be deleted.'
        say
        say 'Enter [Y]es to delete and continue or [N]o to halt installation'
        parse upper pull resp
        if resp = "Y" then
                'del ' || tdrv || notesdir || "\pnotes\* /N"
        else call error
end

dirname = tdrv || notesdir
rc = directory(dirname)

/* make the \DOC and \PNOTES subdirs */
/* See if there's a DOC directory */
dirname = tdrv || notesdir || '\DOC'
rc = directory(dirname)
if rc != dirname then 
        'md doc'

dirname = tdrv || notesdir
rc = directory(dirname)

'md pnotes'
'md doc'
'cd pnotes'
'md sampapps'
'cd sampapps'
'md security'
'md faxback'
'md helpdesk'
'md autoatt'
'md hrbenefi'

/* See if there's already a PNOTES template */
fname =  tdrv || notesdir || "\pnotes.ntf"
retc = SysFileSearch(' ', fname, 'junk.', 'C')
if retc = 0  then do
        say 
        say ''
        say 'A Phone Notes development template (PNOTES.NTF) already exists in '
        say '     your Notes data directory.'
        say
        say 'Enter [Y]es to overwrite and continue or [N]o to halt installation'
        parse upper pull resp
        if resp = "Y" then
                'del ' || tdrv || notesdir || "\pnotes.ntf"
        else call error
end

say 'Installing Phone Notes Development Template (PNOTES.NTF) from ' || sdrv || ' to ' ||  tdrv || notesdir
say 'Please wait . . .'
say ''

dirname = tdrv || notesdir
currdir = directory(dirname)
if currdur != dirname then
        call error

sdrv || '\pnotes -o'

fname = tdrv || notesdir || "\readmepn.txt"
retc = SysFileSearch(' ', fname, 'junk.', 'C')
if retc = 0  then do
        say
        say ''
        say 'A Phone Notes release notes file (READMEPN.TXT) already exists in  '
        say '     your Notes data directory.'
        say
        say 'Enter [Y]es to overwrite and continue or [N]o to halt installation'
        parse upper pull resp
        if resp = "Y" then
                'del ' || tdrv || notesdir || "\readmepn.txt"
        else call error
end

say 'Installing READMEPN.TXT from ' || sdrv || ' to ' ||  tdrv || notesdir
say 'Please wait . . .'
say ''

/* Put the stuff into the Notes data directory */
'copy ' || sdrv || '\readmepn.txt ' tdrv || notesdir || '\readmepn.txt'


/* Put the stuff into the \DOC dir */
dirname = tdrv || notesdir || '\DOC'
currdir = directory(dirname)
if currdur != dirname then
        call error

fname = tdrv || notesdir || "\DOC\pnotedoc.nsf"
retc = SysFileSearch(' ', fname, 'junk.', 'C')
if retc = 0  then do
        say
        say ''
        say 'A Phone Notes documentation database (PNOTEDOC.NSF) already exists in  '
        say '     the \DOC subdirectory of your Notes data directory.'
        say
        say 'Enter [Y]es to overwrite and continue or [N]o to halt installation'
        parse upper pull resp
        if resp = "Y" then
                'del ' || tdrv || notesdir || "\DOC\pnotedoc.nsf"
        else call error
end

say 'Installing Phone Notes documentation database (PNOTEDOC.NSF) from ' || sdrv || ' to ' ||  tdrv || notesdir || '\DOC'
say 'Please wait . . .'
say ''

sdrv || '\pnotedoc -o'

/* Put the stuff into the \PNOTES dir */
dirname = tdrv || notesdir || '\PNOTES'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing Phone Person Name and View'
say 'Please wait . . .'
say ''
sdrv || '\pnames -o'

dirname = tdrv || notesdir || '\PNOTES\sampapps\security'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing Security Sample Application'
say 'Please wait . . .'
say ''

sdrv || '\security -o'

say 'Please insert Disk 1 and press enter to continue'
say ''
parse pull

dirname = tdrv || notesdir || '\PNOTES\sampapps\faxback'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing Faxback Sample Application'
say 'Please wait . . .'
say ''
sdrv || '\faxback -o'

dirname = tdrv || notesdir || '\PNOTES\sampapps\helpdesk'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing Helpdesk Sample Application'
say 'Please wait . . .'
say ''

sdrv || '\helpdesk -o'

say 'Please insert Disk 2 and press enter to continue'
say ''
parse pull

dirname = tdrv || notesdir || '\PNOTES\sampapps\autoatt'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing Auto Attendant Sample Application'
say 'Please wait . . .'
say ''

sdrv || '\autoatt -o'

say 'Please insert Disk 3 and press enter to continue'
say ''
parse pull

dirname = tdrv || notesdir || '\PNOTES\sampapps\hrbenefi'
currdir = directory(dirname)
if currdur != dirname then
        call error

say 'Installing HR Benefits Sample Application'
say 'Please wait . . .'
say ''

sdrv || '\hrbenefi -o'

call success
exit

/* Subroutines */
Instructions:
'cls'
say
say 'Ŀ'
say '    Lotus Phone Notes 2.0 Execution Machine ( OS/2 ) Install        '
say '      Copyright (C) 1993, 1995 Lotus Development Corporation        '
say '                        All rights reserved.                        '
say 'Ĵ'
say '    This program will install the Phone Notes Application           '
say '    development template to your Notes data directory.  It          '
say '    will then install the documentation database to the             '
say '    \DOC subdirectory off the Notes data directory.  Finally,       '
say '    the sample applications, read me file, and phone person         '
say '    form and view are installed to the \PNOTES subdirectory off     '
say '    the Notes data directory.                                       '
say '                                                                    '
say '    To complete the installation 3 parameters must be specified.    '
say '                                                                    '
say '    EXEOS2  source-drv  target-drv  notes-data-directory            '
say '                                                                    '
say '    Example:                                                        '
say '                                                                    '
say '    EXEOS2 a: c: \notes\data                                        '
say '                                                                    '
say '    The notes data directory can be determined by locating the      '
say '    "Directory=" statement in the NOTES.INI file.                   '
say ''
exit
return


error:
'cls'
say
say 'Ŀ'
say '    Lotus Phone Notes 2.0 Execution Machine ( OS/2 ) Install        '
say '      Copyright (C) 1993, 1995 Lotus Development Corporation        '
say '                        All rights reserved.                        '
say 'Ĵ'
say '                The installation was not successful.                '
say '                                                                    '
say '    Possible reasons:                                               '
say '         The directory ' || tdrv || notesdir || ' may not exist.'
say '         The drive specified: ' || sdrv || ' does not contain the install disk.'
say '         The installation was stopped because a file by the same   '
say '          name already exists, and the user elected not to          '
say '          overwrite it.                                             '
say '         Parameters to the installation program were not properly  '
say '          specified.  Run EXEOS2 again for instructions on use      '
say '         Check to see if the disk is full, and clear               '
say '          some space if necessary.                                  '
say '         Access to the target disk may be read-only.               '
say '         Consider the possibility of a disk error.                 '
say ''
exit

success:
'Cls'
say
say 'Ŀ'
say '    Lotus Phone Notes 2.0 Execution Machine ( OS/2 ) Install        '
say '      Copyright (C) 1993, 1995 Lotus Development Corporation        '
say '                        All rights reserved.                        '
say 'Ĵ'
say '                                                                    '
say '                                                                    '
say '    Phone Notes Release 2.0 has been successfully installed.        '
say '                                                                    '
say '    Please review the Release Notes file (READMEPN.TXT) that        '
say '    has been installed in your notes data directory.                '
say '                                                                    '
say '    To start developing with Phone Notes, start Notes and create    '
say '    a new database using the "Phone Notes Appl Template 2.0"        '
say '                                                                    '
say '                                                                    '
say '                                                                    '
say ''
say
say 'Enter [Y]es to view READMEPN.TXT or [N]o to exit installation program.'
parse upper pull resp
        if resp = "Y" then
                'e  ' ||  tdrv || notesdir || '\readmepn.txt'
return
