# tty.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.



package TtyMode;

BEGIN { &main::Require("tty.nls");      import tty_nls; }





sub main'TtyMode {
	local($Mode) = @_;
	local($raw) = "raw";
	local($raw_min0) = "raw_min0";
	local($cooked) = "cooked";
	local($zero, $one, $four);

	# Save the previous tty mode, only try once
	if (!$OldTtySaved) {
		$OldTty = `$System'stty -g`;
		chop($OldTty);
		if ($?) {
			print "$txt{'Cant_save'}\n";
			$OldTty = "";
		};
		$OldTtySaved = 1;
	}

	# Note: AIX needs different values to represent "1" and "0"
	# for setting "min" and "time" (they are the ascii character
	# which have 1 and 0 as their code value).
	$zero = ($ENV{'LARCH'} =~ /^ibmpow/i) ? '\^@' : '0';
	$one =  ($ENV{'LARCH'} =~ /^ibmpow/i) ? '\^A' : '1';
	$four = ($ENV{'LARCH'} =~ /^ibmpow/i) ? '\^D' : '4';


	if ($Mode =~ /^$raw$/i && $mode ne $raw) {
		
		# Set stty mode at first execution, so we can read one
		# character at a time from stdin
		# non-canonical input, no echo, check for INTR and QUIT,
		# map <carrage return> to <new line>, enable reading of
		# one character at a time

		system(
		  "$System'stty -icanon -echo isig icrnl min $one time $zero");
		$mode = $raw;
		return;
	}
	if ($Mode =~ /^$raw_min0$/i && $mode ne $raw_min0) {
		        system(
          "$System'stty -icanon -echo isig icrnl min $zero time $zero");
        $mode = $raw_min0;
        return;
    }
	if ($Mode =~ /$cooked/i && $mode ne $cooked) {

		# Restore to our version of canonical input
		# Here we are setting min to 4 and time to 0

		system(
		  "$System'stty icanon echo isig icrnl min $four time $zero");
		$mode = $cooked;
		return;
	}
}


sub main'TtyModeRestore {
	if ( $OldTtySaved && $OldTty ) {
		&main'System("$System'stty '$OldTty'");
	} else {
		&main'TtyMode("cooked");
	}
}

package main;

1;
