# syscmd.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.



package System;

BEGIN { &main::Require("syscmd.nls");  import syscmd_nls; }
BEGIN { &main::Require("MiscUtil.pl"); import MiscUtil; }
BEGIN { &main::Require("PathUtil.pl"); import PathUtil; }


sub main::Syscmd_Init {
	local( $cmdlist_ref, $notfoundlist_ref ) = @_;

	local( @path ) = qw (
		/usr/bin
		/bin
		/usr/ucb/bin
		/usr/ccs/bin
		/usr/ucb
		/usr/sbin
		/sbin
	);
	local( $cmd, $platcmd, $pathd, %cmdhash );

	push( @path, split(':', $ENV{'PATH'}) );

	CMD: foreach $cmd (@{$cmdlist_ref}) {
		
		# A little cheesy, but check for platform-specific commands here
		# The System package var name remains what was called for
		#
		if ( $cmd eq "rsh" ) {
			if ($ENV{'LARCH_NOREV'} eq "hppa") {
				$platcmd = "remsh";
			} else {
				$platcmd = "rsh";
			}
		} else {
			$platcmd = $cmd;
		}

		foreach $pathdir (@path) {
			if (-x "$pathdir/$platcmd") {
				$cmdhash{$cmd} = "$pathdir/$platcmd";
				next CMD;
			}
		}
		push( @{$notfoundlist_ref}, $platcmd );
	}
	
	if ($ENV{'NI_DBG_SYSCMD'}) {
		&DumpArray(0, @{$notfoundlist_ref});
		&DumpHash(0, %cmdhash);
		$foo=<STDIN>;
	}

	%cmdhash || return 0;

	foreach $cmd (keys(%cmdhash)) {
		eval( "\$System::$cmd = \"$cmdhash{$cmd}\"" );
	}

	return (scalar(@{$notfoundlist_ref}) ? 0 : 1);
}
			

sub main'System {
        local(@command) = @_;
        local($") = " ";
        local($[) = 0;
        local($com, $errmsg);
 
        if (!open(COMMAND, "(@command) 2>&1 |")) {
			print "$txt{'syscmd_error:'} $txt{'cant_execute'}@{command}$txt{'.'}\n";
           return(0);
        }
        $errmsg = 0;
        while (<COMMAND>) {
                $errmsg = 1 if (/error/i);
                print "\n\t$_";
        }
        close(COMMAND);
        if ($? && !$errmsg) {
			print "$txt{'syscmd_error:'} $txt{'cmd_failed'}$txt{'.'}\n";
        }
        return($? ? 0 : 1);
}

1;
