# RmtUtil.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;

package RmtUtil;

&main::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(
	RmtCmd
	RmtMkdir
	RmtLuname
	RmtCmdfile
);

BEGIN { &main::Require("RmtUtil.nls"); import RmtUtil_nls; }



sub RmtCmd {
    local( $host, $cmd, $retval_ref, $cmdout_ref, $error_ref ) = @_;

	# $host			the remote host on which to execute the command
	# $cmd			the command to execute (as in "rsh foohost <cmd>")
	# $retval_ref	ref to scalar to contain the exit status of $cmd
	#					>>>on the remote host<<<
	# $cmdout_ref	ref to scalar to contain the stdout & stderr of $cmd
	# $error_ref	ref to scalar to contain error messages of this function
	#					not to be confused with stderr of $cmd
	#
	# returns		success or failure of invoking the remote command
	#					like rsh - not the status of the remote cmd
 
    local( *RSH, @out, *TMPCMD, $rshcmd, @tmplist, $shell, $tmpout );
    local( $tmpcmd ) = "$ni_tmpcmd.$$";

    undef $$error_ref;

	$tmpout = `$System::rsh $host "uname" 2>&1`;
	chomp( $tmpout );
	if ($tmpout eq "HP-UX") {
		$tmpout = `$System::rsh $host "/usr/bin/ls /usr/old/bin/sh" 2>&1`;
		chomp( $tmpout );
		if ($tmpout eq "/usr/old/bin/sh") {
			$shell = "/usr/old/bin/sh";
		} else {
			$shell = "sh";
		}
	} else {
		$shell = "sh";
	}

    $cmd .= "\nret=\$\?\nsleep 1\necho \$ret\n";
 
    if ( ! open( TMPCMD, ">$tmpcmd" ) ) {
		$$error_ref = "$txt{'unable_tmpcmd'} $tmpcmd";
		return 0;
	}
    print TMPCMD $cmd;
    close( TMPCMD );

	# a "2>&1" here actually LOSES stderr !
	# $rshcmd = " <$tmpcmd $System::rsh $host $shell 2>&1";
	#
    $rshcmd = " <$tmpcmd $System::rsh $host $shell";
 
    $$cmdout_ref = `$rshcmd`;
    if ($?) {
        $$error_ref = "$txt{'unable_rsh'}\n";
        unlink( $tmpcmd );
        return 0;
    }

    chomp( $$cmdout_ref );
    @tmplist = split( '\n', $$cmdout_ref );
    $$retval_ref = pop(@tmplist);
    $$cmdout_ref = join( "\n", @tmplist );
    $$cmdout_ref .= "\n";
 
    $ENV{'NI_NODEL'} || unlink( $tmpcmd );
 
    return 1;
}


sub RmtMkdir {
    local( $host, $dir, $error_ref, $islocal ) = @_;
 
    local( $rcmdret, $rcmdout );
	local( $cmd );

	if ($islocal) {
		$cmd = "(umask 022; $System::mkdir -p $dir 2>&1)";
	} else {
		$cmd = "(umask 022; mkdir -p $dir 2>&1)";
	}

	undef $$error_ref;

	if ( $islocal ) {
		(-d $dir) && return 1;
        if ( system( $cmd ) ) {
            $$error_ref = "$txt{'cant_mkdir'} ${dir}$txt{'.'}\n";
            return 0;
        }
		return 1;
    }

    &RmtCmd( $host, "sh -c \"cd $dir\" 2>&1", \$rcmdret, \$rcmdout, $error_ref ) ||
        return 0;
 
    if ( $rcmdret ) {
        &RmtCmd(    $host,
					$cmd,
                    \$rcmdret, \$rcmdout,
                    $error_ref ) ||
            return 0;
        if ( $rcmdret ) {
            $$error_ref = "$txt{'Unable_create_dir'} $dir$txt{':'}\n$rcmdout";
            return 0;
        }
    }
	return 1;
}


sub RmtLuname {
	local( $host, $arch_ref, $major_ref, $minor_ref, $error_ref, $islocal ) = @_;

	local( $retval, $luname_out, $dummycmdout, $dummyerr );
	local( $fail ) = 0;

	if ($islocal) {
		$luname_out = `$ENV{'LUNAME'} -q`;
		if ($?) {
			$$error_ref = "$txt{'unable_luname'}\n";
			return 0;
		}
	} else {

		if (system(
			"$System::rcp $ENV{'LUNAME'} $host:/tmp/luname.$$ >/dev/null 2>&1")) {

			$$error_ref = "$txt{'unable_rcp_luname'}\n";
			return 0;
		}

		if ( ! &RmtCmd(	$host, 
						"/tmp/luname.$$ -q", 
						\$retval, 
						\$luname_out, 
						$error_ref ) ) {
			$$error_ref = "$txt{'unable_luname'}\n";
			$fail = 1;
		}
		if ($retval) {
			$$error_ref = "$txt{'fail_luname'}\n$$error_ref";
			$fail = 1;
		}
		
		$ENV{'NI_NODEL'} || &RmtCmd(
			$host,
			"rm -f /tmp/luname.$$", 
			\$retval, 
			\$dummycmdout, 
			\$dummyerr );

		$fail && (return 0);
	}

	chomp( $luname_out );

	$$arch_ref = ($luname_out =~ /^(.+)\|.+\|.+$/)[0];
	$$major_ref = ($luname_out =~ /^.+\|(.+)\|.+$/)[0];
	$$minor_ref = ($luname_out =~ /^.+\|.+\|(.+)$/)[0];


	return 1;
}


sub RmtCmdfile {
	local( $host, $cmdfile, $retval_ref, $cmdout_ref, $error_ref )= @_;

	# remote copy $cmdfile to $host, and run via sh
	# return status & stdout via $retval_ref & $cmdout_ref

	local( $fail ) = 0;

	undef $$retval_ref;
	undef $$cmdout_ref;
	undef $$error_ref;

	if ( system( 
			"$System::rcp $cmdfile $host:$cmdfile >/dev/null 2>&1")) {
		$$error_ref = "$txt{'unable_rcp_cmdfile'} $cmdfile\n";
		return 0;
	}

	if ( ! &RmtCmd( $host,
					"sh $cmdfile 2>&1",
					$retval_ref,
					$cmdout_ref,
					$error_ref ) ) {
		$fail = 1;
	}

	&RmtCmd( $host, "test -f $cmdfile && rm -f $cmdfile", \$dummy, \$dummy, \$dummy );

	return ( ! $fail );
}

1;
