# More.pm

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;
package More;

BEGIN { &main::Require("More.nls"); import More_nls; }

BEGIN { &main::Require("MiscUtil.pl"); import MiscUtil; }
BEGIN { &main::Require("tty.pl"); import TtyMode; }


#
local( *READFH, *WRITEFH );

sub new {
    local( $class, $lines, $wait_indent ) = @_;
 
    my $self = {};
    bless $self;

	# config
	#
	$self->{'num_screenlines'}		= $lines;
	$self->{'num_overlap'}			= 2;
	$self->{'waitmsg_indent'}		= $wait_indent ? $wait_indent : 0;

	# state
	#
	$self->{'num_toprint'}		= 	$self->{'num_screenlines'} - 
									( $self->{'num_overlap'} + 1 );
	$self->{'flag_beginscroll'} = 1;
	$self->{'count_thusfar'} 	= 0;

	return $self->Init();
}


sub Init {
	local( $self ) = @_;

	pipe( READFH, WRITEFH ) || return undef;

	if ($self->{'child'} = fork()) {
		# parent - writer
		$ENV{'NI_DEBUG_MORE'} && print "More child is $self->{'child'}\n";

		close( READFH );
		$self->{'parent'} = 1;
		select( WRITEFH );
		$| = 1;

		return $self;

	} elsif (defined $self->{'child'}) {
		# child - reader
	
		close( WRITEFH );
		while (<READFH>) {
			$self->Print( $_ );
		}
		close( READFH );

		exit 0;

	} else {
		return undef;
	}
}


sub Reset {
	local( $self ) = @_;
	$self->{'flag_beginscroll'} = 1;
	$self->{'count_thusfar'}    = 0;
}


sub Print {
	local( $self, $toprint ) = @_;

	local( @lines, $line, $ret );
	local( $trailing_newlines ) = 0;
	local( $oldfh ) = select( STDOUT ); 
	$| = 1;
	
	local( $num_toprint ) = $self->{'flag_beginscroll'} ?
							$self->{'num_screenlines'} - 1 :
							$self->{'num_toprint'};

	if ( defined( $self->{'parent'} ) ) {
		print WRITEFH $toprint;
		return 1;
	}

	# chomp doesn't always seem to get multiple trailing
	while ($ret=chomp($toprint)) {
		$trailing_newlines += $ret;;
	}

	@lines = split( /\n/, $toprint );

	while (defined($line = shift(@lines))) {
		print $line;
		if (@lines) {
			print "\n";
			++$self->{'num_thusfar'};
			if ( $self->{'num_thusfar'} == $num_toprint ) {
				$self->{'flag_beginscroll'} = 0;
				$self->{'num_thusfar'} = 0;
				$self->Wait();
			}
		}
	}

	while ($trailing_newlines--) {
		print "\n";
		++$self->{'num_thusfar'};
		if ( $self->{'num_thusfar'} == $num_toprint ) {
			$self->{'flag_beginscroll'} = 0;
			$self->{'num_thusfar'} = 0;
			$self->Wait();
		}
	}

	select( $oldfh );
}


sub Wait {
	local( $self ) = @_;

	local( $waitmsglen ) = length( $txt{'continue'} );
	local( $c );

	print $txt{'continue'};

	# This works on hppa100, sunspa54, ibmpow41, & solx8654
	# This is necessary rather than a normal read because of
	# what appears to be a bug in hp.  If blocked on a read here while
	# some other process finishes with which there was a pipe in this
	# process, the read would block indefinately.
	#
	&main::TtyMode("raw_min0");
	&WaitStdinReady();

	&main::TtyMode("raw");
	read( STDIN, $c, 1 );

	print "\b" x $waitmsglen;
	print " "  x $waitmsglen;
	print "\b" x $waitmsglen;
}


sub Close {
	local( $self ) = @_;

	local( $ret );

	$ENV{'NI_DEBUG_MORE'} && print "about to close WRITEFH\n";
	close( WRITEFH );

	$ENV{'NI_DEBUG_MORE'} && print "about to waitpid on $self->{'child'}\n";
	$ret = waitpid( $self->{'child'}, 0 );
	$ENV{'NI_DEBUG_MORE'} && print "waitpid on $self->{'child'}: $ret\n";

	undef $self->{'parent'};
	undef $self->{'child'};

	return 1;
}


1;
