require 5.000;

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package MiscUtil;

&main::Require("Exporter.pm");
@ISA = (Exporter);
@EXPORT = qw(	IsMember 
				DumpArray DumpHash DumpScalar DumpRef
				ListBoolInclude ListBoolOrderInclude UpdateHash
				WaitStdinReady Nap IndentText
				AddItemToArrayHash StringListIsEqual
				PrintIndented LengthOfLastLine IndentAfterFirstLine
				ParseDfOutput
);
				


$level_indent = 4;

sub IsMember {
	local( $element, @list ) = @_;

	return( grep( /^$element$/, @list ) );
}


sub DumpArray {
	local( $indent, @array ) = @_;

	print "Array:\n";

	$indent += $level_indent;

	foreach (@array) {
		if ( ref($_) ) {
			&DumpRef( $indent, $_ );
		} else {
			&Indent( $indent );
			print ">$_<\n";
		}
	}
}


sub DumpHash {
	local( $indent, %hash ) = @_;

    print "Hash:\n";


	foreach (keys(%hash)) {
		&Indent( $indent );
		print "key: >$_<\n";

		if ( ref($hash{$_}) ) {
            &DumpRef( $indent+5, $hash{$_} );
        } else {
            &Indent( $indent+5 );
			print ">$hash{$_}<\n";
		}

	}
}


sub DumpScalar {
	local($level, $scalar) = @_;

	&LevelIndent( $level );
    print "Scalar:\n";

	if (ref($scalar)) {
		&DumpRef( $level+1, $scalar );
	} else {
		&LevelIndent( $level );
		print "$scalar\n";
	}
}
		

sub DumpRef {
	local( $indent, $ref ) = @_;

	&Indent( $indent );

	$indent += $level_indent;

	if (ref($ref) eq "SCALAR") {
		print "(Scalar Ref) ";
		&DumpScalar( $indent, $$ref );
 
	} elsif (ref($ref) eq "ARRAY") {
		print "(Array Ref) ";
		&DumpArray( $indent, @$ref );
 
	} elsif (ref($ref) eq "HASH") {
		print "(Hash Ref) ";
		&DumpHash( $indent, %$ref );
 
	} else {
		print "(Undetermined Reference Type)\n";
	}
}

sub LevelIndent {
	local($level) = @_;

	print " " x ($level * $level_indent);
}

sub Indent {
	local($indent) = @_;
	print " " x $indent;
}


sub ListBoolInclude {
	local( $listref, $member, $boolval ) = @_;

	if ($boolval) {
		if ( ! grep( /^$member$/, @$listref ) ) {
			push( @$listref, $member );
		}
	} else {
		if ( grep( /^$member$/, @$listref ) ) {
			for (0..$#{$listref}) {
				if ( ${$listref}[$_] eq $member ) {
					splice( @$listref, $_, 1 );
				}
			}
		}
	}
}

sub ListBoolOrderInclude {
	local( $listref, $member, $boolval, $orderlistref ) = @_;

	local( @newlist ) = ();

	foreach $i (@{$orderlistref}) {
		if ($member eq $i) {
			$boolval && push( @newlist, $member );
		} elsif ( grep( /^$i$/, @$listref ) ) {
			push( @newlist, $i );
		}
	}

	@$listref = @newlist;
}


sub UpdateHash {
	local( $dsthash, $srchash ) = @_;

	foreach $key (keys(%$srchash)) {
		$dsthash->{$key} = $srchash->{$key};
	}
}


sub WaitStdinReady {
    local($rin) = "";
    local($nfd);
    vec($rin, fileno(STDIN), 1) = 1;
    return $nfd = select($rin,undef,undef,undef);
}
 

sub Nap {
    local( $time ) = @_;
    select(undef, undef, undef, $time );
}


sub IndentText {
    local( $indent, $text ) = @_;
 
    local( @lines, $tmp );
	local( $trailing_newlines ) = 0;
	local( $newtext ) = "";
 
	# chomp doesn't seem to always chomp > 1 as doc'd
	#
	while ( $tmp = chomp( $text ) ) {
		$trailing_newlines += $tmp;
	}

    @lines = split('\n', $text);
    while (@lines) {
        $_ = shift(@lines);
		$newtext .= " " x $indent;
		$newtext .= $_;
        (@lines) && ($newtext .= "\n");
    }
	$newtext .= "\n" x $trailing_newlines;
}


sub AddItemToArrayHash {
	local( $hashref, $key, $item ) = @_;

	if ( ref($hashref->{$key}) ne "ARRAY" ) {
		$hashref->{$key} = [];
	}

	push( @{$hashref->{$key}}, $item );
}


sub StringListIsEqual {
	local( $listref1, $listref2 ) = @_;

	(scalar(@{$listref1}) != scalar(@{$listref2})) && return 0;

	for ($i=0; $i<scalar(@{$listref1}); $i++) {
		(${$listref1}[$i] ne ${$listref2}[$i]) && return 0;
	}

	return 1;
}


sub PrintIndented {
	local( $indent, $toprint ) = @_;
	
	local( @lines, $trailing_newlines );

	$trailing_newlines = chomp( $toprint );
	@lines = split('\n', $toprint);
	while (@lines) {
		$_ = shift(@lines);
		print " " x $indent;
		print;
		(@lines) && print "\n";
    }
	print "\n" x $trailing_newlines;
}


sub IndentAfterFirstLine {
	local( $indent, $text ) = @_;

	local( $line, @lines, $trailing_newlines, $tmp );
	local( $newtext ) = "";

    while ( $tmp = chomp( $text ) ) {
        $trailing_newlines += $tmp;
    }
    @lines = split('\n', $text);
	$newtext = shift(@lines);
	(@lines) && ($newtext .= "\n");
    while (@lines) {
        $line = shift(@lines);
        $newtext .= " " x $indent;
        $newtext .= $line;
        (@lines) && ($newtext .= "\n");
    }
    $newtext .=  "\n" x $trailing_newlines;
}


sub LengthOfLastLine {
	local( $text ) = @_;

	(chomp( $text ) > 1 ) && return 0;

	local( @lines ) = split( '\n', $text );

	return length($lines[$#lines]);
}


sub ParseDfOutput {
	local( $dfout, $os_arch, $os_major, $os_minor ) = @_;

	# Presently parsing df based only on arch.  If future os revs still
	# work, great, otherwise we'll need to be more sensitive here.
	# This is based on sunspa54, sunx8654, ibmpow41, hppa100

	# presuming the df was on a single filesystem, and looks something like:
	#
	#
	# sunspa54:
	# /usr/sbin/df -k .
	# Filesystem            kbytes    used   avail capacity  Mounted on
	# /dev/dsk/c0t3d0s5     396975  288653   68632    81%    /opt
 	#
	# sunx8654:
	# /usr/sbin/df -k .
	# Filesystem            kbytes    used   avail capacity  Mounted on
	# /dev/dsk/c0t0d0s0      28703   21900    3933    85%    /
 	#
	# ibmpow41:
	# /usr/bin/df -k .
	# Filesystem    1024-blocks      Free %Used    Iused %Iused Mounted on
	# /dev/hd4             8192      3912   53%     1273    32% /
 	#
	# hppa100:
	# /usr/bin/df -k .
	# /                 (/dev/dsk/c0t6d0       ) :   768494 total allocated Kb
	#                                                 57669 free allocated Kb
	#                                                710825 used allocated Kb
	#                                                    92 % allocation used

	#print "dfout>\n$dfout<\n";

	if ($os_arch =~ /^sun/) {

		return (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[3];

	} elsif ($os_arch eq "ibmpow") {

		return (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[2];

	} elsif ($os_arch eq "hppa") {

		return (split( /[ \t\n]+/, (split( /^/, $dfout ))[1] ))[1];
	}

	return undef;
}



package main;
1;
