

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.

require 5.000;

package InstData;
BEGIN { &main::Require("InstData.nls");	import InstData_nls; }


BEGIN { &main::Require("MiscUtil.pl");	import MiscUtil; }
BEGIN { &main::Require("Toc.pm"); import Toc; }
BEGIN { &main::Require("Scfg.pm"); import Scfg; }
BEGIN { &main::Require("RmtUtil.pl"); import RmtUtil; }
BEGIN { &main::Require("PrmptUsr.pl"); import PrmptUsr; }
BEGIN { &main::Require("tty.pl"); }



sub new {
	local($class) = @_;

	my $self = {};
	bless $self;

	# user/menu data
	#
	%$self = (
				'usr_destspectype'		=> "",
				'usr_single_hostname'	=> "",
				'usr_hostlist_fname'	=> "",
				'usr_install_type'		=> "",
				'usr_destpath'			=> "",
				'usr_userid'			=> "",
				'usr_groupid'			=> ""
	);
	#
	# "usr_array_data" identifies those user data items which
	# are lists; needed by SetUserData
	#
	@{$self->{'usr_list_data'}} = qw( usr_prodopts usr_platforms );
	@{$self->{'usr_prodopts'}}			= ();
	@{$self->{'usr_platforms'}}			= ();

	# internal data
	#
	@{$self->{'dest_hosts'}}		= ();
	%{$self->{'hostsbylineno'}}		= ();
	%{$self->{'ipbyhosts'}}			= ();
	%{$self->{'destcfgrecs'}}		= ();
	$self->{'error'}				= "";
    $self->{'cfg_file'}             = "";
	$self->{'dist'}					= "";
	$self->{'arcroot'}				= "";
	$self->{'defsfile'}				= "";
	$self->{'validate_logfile'}		= $validate_logfile;
	$self->{'install_datfile'}		= "";
	#
	# validation status
	#
	$self->{'validate_occurred'}	= 0;
    $self->{'validate_errors'}		= 0;
    $self->{'validate_warnings'}	= 0;
	$self->{'validate_logtext'}		= "";
	$self->{'validate_summary_msg'}	= "";

	#
	# the toc obj reference is here only for convienance
	# and only the ref is considered part of this instance data
	#
	$self->{'Toc'}					= "";
	# for toc
	$self->{'top_optset'}			= "";
	$self->{'tocfile'}				= "";
	$self->{'tagfile'}				= "";
	# from toc
	$self->{'top_optset_rev'}		= "";
	$self->{'top_optset_desc'}		= "";
	$self->{'top_optset_inst_banner'}		= "";
	$self->{'top_optset_insthelp_banner'}	= "";
    @{$self->{'prodopts'}}          = ();
    @{$self->{'platforms'}}         = ();

	return $self;
}


sub Init {
	local($self) = @_;

	local( @tmp, $a, $b, $c, $d );


	$self->{'Toc'} = new Toc ();

	if ( ! $self->{'Toc'}->Init( $self->{'tocfile'}, $self->{'tagfile'} ) ) {
		$self->{'error'} = $self->{'Toc'}->GetError();
		return 0;
	}

	@{$self->{'prodopts'}}	= $self->{'Toc'}->GetOptions(
		$self->{'top_optset'}, $self->{'top_optset_rev'} );

	@{$self->{'platforms'}}	= $self->{'Toc'}->GetPlatforms(
		$self->{'top_optset'}, $self->{'top_optset_rev'} );

	$self->{'top_optset_desc'} = $self->{'Toc'}->GetOptsetText( 
		$self->{'top_optset'}, $self->{'top_optset_rev'}, "desc" );

	$self->{'top_optset_inst_banner'} = $self->{'Toc'}->GetOptsetText( 
		$self->{'top_optset'}, $self->{'top_optset_rev'}, "install_banner" );

	$self->{'top_optset_insthelp_banner'} = $self->{'Toc'}->GetOptsetText( 
		$self->{'top_optset'}, $self->{'top_optset_rev'}, "installhelp_banner" );


	$self->{'local_hostname'} = `$System::hostname`;
	chomp( $self->{'local_hostname'} );
	if ( ! (@tmp=gethostbyname( $self->{'local_hostname'} )) ) {
		$self->{'error'} = "$txt{'ERROR:'} $txt{'unable_resolve_local'}\n";
		return 0;
	}
	($a,$b,$c,$d) = unpack('C4', ($tmp[4])[0]);
	$self->{'local_ip'} = "$a.$b.$c.$d";

	
	$self->{'install_datfile'} = 
		"." .
		$self->{'top_optset'} .
		$self->{'top_optset_rev'} .
		".dat";

	return 1;
}


sub Dump {
	local($self) = @_;

	print "Dumping InstData instance\n";

	print "user/menu data:\n";
	foreach (qw(usr_bool_localinst usr_bool_rmtinst usr_hostlist_fname usr_destpath usr_userid usr_groupid)) {
		printf( "%16s: %s\n", $_, $self->{$_} );
	}
	print "usr_prodopts:\n";
	&DumpArray( @{$self->{'usr_prodopts'}} );
	print "usr_platforms:\n";
	&DumpArray( @{$self->{'usr_platforms'}} );
	
	print "internal data:\n";
	foreach (qw(error)) {
		printf( "%16s: %s\n", $_, $self->{$_} );
    }
	foreach (qw(hostlist)) {
		print "$_:\n";
		&DumpArray( @{$self->{$_}} );
	}

    print "toc data:\n";
    foreach (qw(top_optset top_optset_desc tocfile tagfile top_optset_rev)) {
        printf( "%16s: %s\n", $_, $self->{$_} );
    }
    foreach (qw(prodopts platforms arcfiles)) {
        print "$_:\n";
        &DumpArray( @{$self->{$_}} );
	}
}


sub Dupe {
	local($self) = @_;

	local($newself) = new InstData ();

	$self->CopyTo( $newself );

	return $newself;
}

sub CopyTo {
	local($self, $target) = @_;

    foreach (keys(%$self)) {
        if ( ref($self->{$_}) eq "ARRAY" ) {
            @{$target->{$_}} = @{$self->{$_}};
        } elsif ( ref($self->{$_}) eq "HASH" ) {
            %{$target->{$_}} = %{$self->{$_}};
        } else {
            $target->{$_} = $self->{$_};
        }
    }
}


sub GenInstallCfgFile {
    local($self) = @_;
 
    local(*CFGFILE, @list, $host);
 
    if ( ! $self->{'cfg_file'} ) {
        $self->{'cfg_file'} = "/tmp/instcfg.$$";
    }
 
    if ( ! open( CFGFILE, ">$self->{'cfg_file'}" ) ) {
        $self->{'error'} =
            "$txt{'Cant_open_for'} $txt{'writing'} " .
            "$txt{'file'} $self->{'cfg_file'}$txt{':'}\n" .
            "$!\n";
        return 0;
    }

	# required header
	#
    printf( CFGFILE "%s=%s\n", "optset",		$self->{'top_optset'} );
    printf( CFGFILE "%s=%s\n", "optsetrev", 	$self->{'top_optset_rev'} );
	printf( CFGFILE "%s=%s\n", "insttype",	$self->{'usr_install_type'} );
    printf( CFGFILE "%s=%s\n", "arcroot",		$self->{'arcroot'} );
    printf( CFGFILE "%s=%s\n\n", "custom",
		$self->{'Toc'}->HasCustom( 
			$self->{'top_optset'}, $self->{'top_optset_rev'} ) );
 
	# optional header
	#
    printf( CFGFILE "%s=%s\n", "dest",      $self->{'usr_destpath'} );
	print CFGFILE "prodopts=";
	@list = @{$self->{'usr_prodopts'}};
	while (@list) {
		printf( CFGFILE "%s", shift(@list) );
		@list && print CFGFILE ",";
	}
	print CFGFILE "\n";
    printf( CFGFILE "%s=%s\n", "user",      $self->{'usr_userid'} );
    printf( CFGFILE "%s=%s\n", "group",     $self->{'usr_groupid'} );

	# per-host records
	#
	foreach $host (@{$self->{'dest_hosts'}}) {
		print CFGFILE "\nhost=$host\n";

		print CFGFILE "arch=$self->{'destcfgrecs'}->{$host}->{'os_arch'}\n";

		print CFGFILE "platforms=";
		@list = @{$self->{'destcfgrecs'}->{$host}->{'platforms'}};
		while (@list) {
			printf( CFGFILE "%s", shift(@list) );
			@list && print CFGFILE ",";
		}
		print CFGFILE "\n";

		# optional per-host data
		if ($self->{'destcfgrecs'}->{$host}->{'status'}) {
			print CFGFILE "status=$self->{'destcfgrecs'}->{$host}->{'status'}\n";
		}
		if ($self->{'destcfgrecs'}->{$host}->{'message'}) {
			print CFGFILE 
				"message=$self->{'destcfgrecs'}->{$host}->{'message'}\n";
		}
		if ($self->IsHostLocal( $host )) {
			print CFGFILE
				"islocal=1\n";
		}
	}

    if ( ! close( CFGFILE ) ) {
        $self->{'error'} =
            "$txt{'Error'} $txt{'while'} $txt{'creating'} $txt{'file'} " .
            "$self->{'cfg_file'}$txt{':'}\n$!\n";
        return 0;
    } else {
        return 1;
    }
}


sub GenDestConfigRecord {
	local( $self, $host ) = @_;

	local( $cfgrecref, $pfm, $arch, $major, $minor, $error );

	
	# (re-)generate the dest config record for $host
	#   (${$self->{'destcfgrecs'}}{$host})
	#
	# Fills-in the following:
	#						if err or warn; presumes null initially
	#						presumes null initially
	#	$os_arch
	#	$os_major
	#	$os_minor

    #
    $cfgrecref = ${$self->{'destcfgrecs'}}{$host};

	# add os info
	#
	if ( ! &RmtLuname( 
			$host, 
			\$arch, 
			\$major, 
			\$minor, 
			\$error,
			$self->IsHostLocal( $host ) ) ) {
		$cfgrecref->{'message'} = "$txt{'pseudopfm_error'}: $error";
		$cfgrecref->{'status'} = "err";
		return 0;
	} else {
		$cfgrecref->{'os_arch'}  = $arch;
		$cfgrecref->{'os_major'} = $major;
		$cfgrecref->{'os_minor'} = $minor;
	}

	# add platform support info
	#
	if ($self->{'usr_install_type'} eq "runable") {

		# do that crazy pseudo-platform thing

		$tmppfm = $self->{'Toc'}->GetClosestPlatform( 
			$self->{'top_optset'},
			$self->{'top_optset_rev'},
			$arch,
			$major,
			$minor,
			\$error );

		if ($tmppfm) {
		
			# menu does not support >1 for "runable", but anyway...
			if ( ! &IsMember( $tmppfm, @{$cfgrecref->{'platforms'}} ) ) {
				push( @{$cfgrecref->{'platforms'}}, $tmppfm );
			}

			if ($error) {
                $cfgrecref->{'message'} = $error;
				$cfgrecref->{'status'} = "warn";
           	}
		} else {

			$cfgrecref->{'message'} = $error;
			$cfgrecref->{'status'} = "err";
		}

	} else {

		# generate dest config record for installation type fileserver
		#
		foreach $pfm (@{$self->{'usr_platforms'}}) {
			# add it to @{$cfgrecref->{'platforms'}}, if not already
			if ( ! &IsMember( $pfm, @{$cfgrecref->{'platforms'}} ) ) {
				push( @{$cfgrecref->{'platforms'}}, $pfm );
			}
		}
	}

	# add total size (in k) of filesets to be installed
	#
	$cfgrecref->{'size'} = $self->{'Toc'}->GetTotalSize(
		$self->{'top_optset'},
		$self->{'top_optset_rev'},
		$self->{'usr_prodopts'},
		$cfgrecref->{'platforms'} );

	return ($cfgrecref->{'status'} ? 0 : 1);
}


sub ValidateGeneralConfig {
    local( $self, $msgout_ref ) = @_;

	# check for errors in the config that aren't dest specific:
	#	destpath
	#   owner user
	#   owner group
	#   at least one subset to install
	#   if fileserver, at least one platform


	local( $ok ) = 1;
	local( @tmplist ) = qw( 
		usr_destpath
		usr_userid
		usr_groupid 
	);

	$$msgout_ref = "";

	foreach (@tmplist) {
		if ( ($self->{$_} =~ /\s/) || ($self->{$_} =~ /^$/) ) {
			$ok = 0;
			$$msgout_ref .= &IndentAfterFirstLine(
				length("$txt{'ERROR:'} "),
				"$txt{'ERROR:'} $txt{ ${_} . '_err' }\n" );
		}
	}

	if ( ! ($self->{'usr_destpath'} =~ /^\//)) {
		$ok = 0;
		$$msgout_ref .= "$txt{'ERROR:'} $txt{'usr_destpath_not_abs'}\n";
	}

	
	if ( ! $self->{'Toc'}->GetReqdFsetList( 
				$self->{'top_optset'}, $self->{'top_optset_rev'} ) ) {
		if ( ! @{$self->{'usr_prodopts'}} ) {
			$ok = 0;
			$$msgout_ref .= "$txt{'ERROR:'} $txt{'no_opts_slctd'}\n";
		}
	}

	
	if ( $self->{'usr_install_type'} eq "fileserver" ) {
		if ( ! @{$self->{'usr_platforms'}} ) {
			$ok = 0;
			$$msgout_ref .= &IndentAfterFirstLine(
				length("$txt{'ERROR:'} "),
				"$txt{'ERROR:'} $txt{'no_plats_slctd'}\n" );
		}
	}

	return $ok;

}


sub ValidateDestConfigs {
	local(	$self,		
			$more,					# in:  the screen "more" thing 
									#      being used for the screen
			$msgout_ref,			# out: output text that was sent to more
			$flag_warnings_ref,		# out: at least one dest had warnings
			$flag_errors_ref		# out: at least one dest had errors
	 ) = @_;

	# validates user selections for each @{$self->{'dest_hosts'}}
	#
	# re-generates ${$self->{'destcfgrecs'}}{$host} records
	#	


	local( $host, $ret, $out, $error, $tmpout, $cfgrecref, $text );
	local( $tmpcmd, $tmpret, $tmpout, $tmperr );
	local( $destvalscript_fname, *DESTVALSCRIPT, $dummy );
	local( $installdat, $dfout, $disk_avail, $disk_alreadyinstalled );
	local( $newdisk_needed );
	local( $validation_msg_indent ) = 2;

	$$msgout_ref = "";


	# clear any existing set of config records
	#
	defined( $self->{'destcfgrecs'} ) && undef( $self->{'destcfgrecs'} );
	$self->{'destcfgrecs'} = {};

	# prepare the sh file which will be used for per-dest validation
	#
	$destvalscript_fname = "$nlsdata{'nidestvalscript'}.$$";
	if ( ! open( DESTVALSCRIPT, ">$destvalscript_fname" ) ) {
		$$flag_errors_ref = 1;
		$text = "$txt{'ERROR:'} $txt{'unable_gen_valscript'}$txt{'.'}\n";
		$more->Print( $text );
		$$msgout_ref .= $text;
		return 0;
	}
	print DESTVALSCRIPT $self->GenDestValScript();
	if ( ! close(DESTVALSCRIPT) ) {
		$$flag_errors_ref = 1;
		$text = "$txt{'ERROR:'} $txt{'unable_gen_valscript'}$txt{'.'}\n";
		$more->Print( $text );
		$$msgout_ref .= $text;
		unlink( $destvalscript_fname );
		return 0;
	}


	# load custom file, if available,
	# for later calling pre-install validation
	#
	if ($self->{'Toc'}->HasCustom(
            $self->{'top_optset'}, $self->{'top_optset_rev'} )) {
		&main::Require( "custom.pl" );
		import Custom;
	}
	
	# for custom preval
	$ENV{'NI_DEST'} = $self->{'usr_destpath'};

	foreach $host (@{$self->{'dest_hosts'}}) {

		# for custom preval
		$ENV{'NI_HOST'} = $host;
		$ENV{'NI_HOSTISLOCAL'} = $self->IsHostLocal( $host );

		# create new config record hash for this dest
		#
		$cfgrecref = ${$self->{'destcfgrecs'}}{$host} = {};

		# output status msg - starting validation for this dest
		#
		$text = "$txt{'Validating'} ${host}$txt{'...'}\n";
		$more->Print( $text );
		$$msgout_ref .= $text;

		# check root-equivalency for remote dest hosts
		#
		if ( ! $self->IsHostLocal( $host ) ) {
			&RmtCmd(
				$host,
				"echo LaLaLa.$$",
				\$ret,
				\$out,
				\$error );
			chomp( $out );
			if ( $out ne "LaLaLa.$$" ) {
				# err: root-equivalency
				#
				$$flag_errors_ref = 1;
				$cfgrecref->{'status'} = "err";
				$text =
                    "$txt{'ERROR:'}\n" .
                    "$txt{'Unable_remote_on'} $host$txt{'.'}\n" .
                    "$txt{'Ensure_root_equiv'} $ENV{'NI_LOCALHOSTNAME'}" .
                    "$txt{')'}$txt{'.'}\n\n";
				$text =  &IndentAfterFirstLine(
					$validation_msg_indent, $text );
				$more->Print( $text );
				$$msgout_ref .= $text;
				next;
			}
		}

		if ( ! $self->GenDestConfigRecord( $host ) ) {
			if ($cfgrecref->{'status'} eq "warn") {
				$$flag_warnings_ref = 1;
				$text = &IndentAfterFirstLine(
					$validation_msg_indent,
					"$txt{'WARNING:'}\n$cfgrecref->{'message'}\n" );
				$more->Print( $text );
				$$msgout_ref .= $text;
			}
			if ($cfgrecref->{'status'} eq "err") {
				$$flag_errors_ref = 1;
				$text = &IndentAfterFirstLine(
					$validation_msg_indent,
					"$txt{'ERROR:'}\n$cfgrecref->{'message'}\n" );
				$more->Print( $text );
				$$msgout_ref .= $text;
				next;
			}
		}


        #
        if (defined( &Custom_PreValidate )) {
			local( @warnings, @errs, @backendwarn, @backendmsg );
            $ret = &Custom_PreValidate(
				\@warnings,
				\@errs,
				\@backendwarn,
				\@backendmsg,
                $self->{'usr_install_type'},
				$self->{'usr_destpath'},
				$self->{'top_optset_rev'},
				$cfgrecref->{'os_arch'});
 
			# the return status of &Custom_PreValidate() is expected to be:
			#	0: no errs or warnings
			#	1: errors which preclude further validation
			#	2: errors which do not preclude further validation
			#	3: warnings and/or msgs only
			#
			if ($ret) {
				$text = "";
				foreach (@warnings) {
					$$flag_warnings_ref = 1;
					$text .= &IndentAfterFirstLine(
						$validation_msg_indent,
						"$txt{'WARNING:'}\n$_" );
				}
				foreach (@backendwarn) {
					$$flag_warnings_ref = 1;
					$cfgrecref->{'status'} = "warn";
					$cfgrecref->{'message'} .= $_;
				}
				foreach (@backendmsg) {
					$cfgrecref->{'message'} .= $_;
				}
				foreach (@errs) {
					$$flag_errors_ref = 1;
					$cfgrecref->{'status'} = "err";
					$text .= &IndentAfterFirstLine(
						$validation_msg_indent,
						"$txt{'ERROR:'}\n$_" );
				}
				$more->Print( $text );
				$$msgout_ref .= $text;

				if ($ret==1) {
					$more->Print("\n");
					$$msgout_ref .= "\n";
					next;
				}
			}
        }



		# do per-dest validation using shell script 
		#
		if ( ! $self->IsHostLocal( $host ) ) {
			if ( system("$System::rcp $destvalscript_fname $host:$destvalscript_fname") ) {
				$$flag_errors_ref = 1;
				$cfgrecref->{'status'} = "err";
				$text = "$txt{'ERROR:'}\n$txt{'unable_gen_valscript'} " .
					"$destvalscript_fname\n" .
					"$txt{'on_remote_host'} ${host}$txt{'.'}\n";
				$text = &IndentAfterFirstLine( $validation_msg_indent, $text );
				$more->Print( $text );
				$$msgout_ref .= $text;
				next;
			}

			if ( ! &RmtCmd(	
					$host,
					"sh $destvalscript_fname " .
						"$host " .
						"$self->{'usr_destpath'} " .
						"$self->{'usr_userid'} " .
						"$self->{'usr_groupid'} " .
						"$cfgrecref->{'os_arch'} " .
						"$cfgrecref->{'os_major'} " .
						"$cfgrecref->{'os_minor'} " .
						"$self->{'install_datfile'}",
					\$tmpret, 
					\$tmpout, 
					\$tmperr ) ) {
				$$flag_errors_ref = 1;
				$cfgrecref->{'status'} = "err";
				$text = "$txt{'ERROR:'}\n$tmperr";
				$text = &IndentAfterFirstLine( $validation_msg_indent, $text );
				$more->Print( $text );
				$$msgout_ref .= $text;
				next;
			}

			$ENV{'NI_NODEL'} ||
				&RmtCmd(
					$host,
					"rm -f $destvalscript_fname",
					\$dummy,
					\$dummy,
					\$dummy );
		} else {

			$tmpcmd = 
				"sh $destvalscript_fname " .
					"$host " .
					"$self->{'usr_destpath'} " .
					"$self->{'usr_userid'} " .
					"$self->{'usr_groupid'} " .
					"$cfgrecref->{'os_arch'} " .
					"$cfgrecref->{'os_major'} " .
					"$cfgrecref->{'os_minor'} " .
					"$self->{'install_datfile'}";
			$tmpout = `$tmpcmd`;
			$tmpret = ($? >> 8);
		}

		$text = $self->MungeOutputOfDestValScript( 
			$validation_msg_indent, $tmpout, \$dfout, \$installdat );
	
		# the return status of $destvalscript_fname is expected to be:
		#	0: no errs or warnings
		#	1: errors which preclude further validation
		#	2: errors which do not preclude further validation
		#	3: warnings only
		#
		if ( $tmpret ) {
			if (($tmpret==1) || ($tmpret==2)) {
				$$flag_errors_ref = 1;
				$cfgrecref->{'status'} = "err";
			} elsif ($tmpret == 3) {
				$$flag_warnings_ref = 1;
				$cfgrecref->{'message'} .= $text;
				$cfgrecref->{'status'} = "warn";
			}

			$more->Print( $text );
			$$msgout_ref .= $text;

			if ($tmpret == 1) {
				$more->Print("\n");
				$$msgout_ref .= "\n";
				next;
			}
		}


		if ($ENV{'NI_DEBUG_INSTALLDAT'} && ($installdat)) {
			$more->Print("installdat:\n");
			$more->Print($installdat);
			$more->Print("-----\n\n");
		}

		# check disk space, using $dfout from the val script 
		#

		$disk_alreadyinstalled = 
			$self->ParseInstallDat( 
				$installdat,
				$cfgrecref->{'platforms'} );
		
		$disk_avail = &ParseDfOutput( 
			$dfout, 
			$cfgrecref->{'os_arch'},
			$cfgrecref->{'os_major'},
			$cfgrecref->{'os_minor'} );

		$newdisk_needed = $cfgrecref->{'size'} - $disk_alreadyinstalled;

		if ($ENV{'NI_DEBUG_DISKSPACE'}) {
			$more->Print("space needed:     " . $cfgrecref->{'size'} . "\n");
			$more->Print("space already:    " . $disk_alreadyinstalled . "\n");
			$more->Print("new space needed: " . $newdisk_needed . "\n");
			$more->Print("space avail:      " . $disk_avail . "\n");
		}

		if ( $disk_avail < $newdisk_needed ) {
			$$flag_errors_ref = 1;
			$cfgrecref->{'status'} = "err";
			$text = 
				"$txt{'ERROR:'}\n" .
				"$txt{'no_space_1'} $newdisk_needed" .
					"$txt{'k_bytes_new_space'}\n" .
				"$txt{'no_space_2'} ${disk_avail}$txt{'k_bytes'} " .
					"$txt{'no_space_3'}\n\n";

			$text = &IndentAfterFirstLine( $validation_msg_indent, $text );

			$more->Print($text);
			$$msgout_ref .= $text;
			next;
		}
		

		$text = "";
		if ($cfgrecref->{'status'} eq "warn") {
			$text = &IndentText( 
				$validation_msg_indent, 
				"$txt{'Otherwise_Ok.'}\n\n" );
		} elsif ( ! $cfgrecref->{'status'} )  {
			$text = &IndentText( $validation_msg_indent, "$txt{'Ok.'}\n\n");
		} else {
			$text = "\n";
		}

		if ($text) {
			$more->Print( $text );
			$$msgout_ref .= $text;
		}

	} # foreach $host

	$ENV{'NI_NODEL'} || unlink( $destvalscript_fname );

}



sub ReadDefaultsFile {
	local( $self ) = @_;

	local( @cfgitem_scalars, @cfgitem_arrays, @cfgkeys, %cfghash, $item );
	local( @tmp );
	local( $defcfg ) = new Scfg ();

	$defcfg->InitFromFile( $self->{'defsfile'} ) || return 0;

	$self->ClearValidationData();

	@cfgitem_scalars = qw(
		usr_destspectype
		usr_single_hostname
		usr_hostlist_fname
		usr_install_type
		usr_destpath
		usr_userid
		usr_groupid
    );

	@cfgitem_arrays = qw(
		usr_prodopts
		usr_platforms
	);

	@cfgkeys = (@cfgitem_scalars, @cfgitem_arrays);

	if ( ! $defcfg->ParseKeys( \@cfgkeys, [], \%cfghash ) ) {
		&main::TtyModeRestore();
		print "$txt{'cfgfile_readerr'}\n";
		exit 1;
	}

	foreach $item (@cfgitem_scalars) {
		$self->{$item} = ${$cfghash{$item}}[0];
	}

	foreach $item (@cfgitem_arrays) {
		@{$self->{$item}} = @{$cfghash{$item}};
	}

	foreach $platform (@{$self->{'usr_platforms'}}) {
		if (&IsMember( $platform, @{$self->{'platforms'}} )) {
			push( @tmp, $platform );
		}
	}
	@{$self->{'usr_platforms'}} = @tmp;

	return 1;
}


sub WriteDefaultsFile {
	local( $self ) = @_;

	local( @cfgitem_scalars, @cfgitem_arrays, $item, $val, @tmplist );
	local( *CFGFILE );

	@cfgitem_scalars = qw(
		usr_destspectype
		usr_single_hostname
        usr_hostlist_fname
		usr_install_type
        usr_destpath
        usr_userid
        usr_groupid
    );
 
    @cfgitem_arrays = qw(
        usr_prodopts
        usr_platforms
    );
 
    @cfgkeys = (@cfgkey_scalars, @cfgkey_arrays);

	open( CFGFILE, ">$self->{'defsfile'}" ) || return 0;

	foreach $item (@cfgitem_scalars) {
		if ( $item eq "usr_single_hostname" ) {
			if ( $self->IsHostLocal( $self->{'usr_single_hostname'} ) ) {
				print CFGFILE "${item}=\n";
			} else {
				print CFGFILE "${item}=$self->{$item}\n";
			}
			next;
		}

		print CFGFILE "${item}=$self->{$item}\n";
	}

	foreach $item (@cfgitem_arrays) {
		print CFGFILE "${item}=";
		@tmplist = @{$self->{$item}};
		while ($val = shift( @tmplist )) {
			print CFGFILE "$val";
			@tmplist && print CFGFILE ",";
		}
		print CFGFILE "\n";
	}

	close( CFGFILE );

	return 1;
}


sub LoadHostList {
	local( $self, $msg_ref ) = @_;

	# load hostnames from file if specified, or single dest
	# verify syntax
	# $$msgref gets set to nice little list, or error 
	# return status

	local( $tmp, *HOSTFILE );



	$self->{'error'} = "";
	$$msg_ref = "";
	undef( @{$self->{'dest_hosts'}} );
	undef( %{$self->{'hostsbylineno'}} );

	# single specified hostname
	#
	if ($self->{'usr_destspectype'} eq "single") {
		$tmp = $self->{'usr_single_hostname'};
		$tmp =~ s/^\s+//;
		$tmp =~ s/\s+$//;
		if (($tmp =~ /\s/) || ($tmp =~ /^$/)) {
			$$msg_ref = 
				"\n$txt{'ERROR:'}\n" .
				"$txt{'singlehost_err_p1'} " .
				"$txt{'('}$txt{'\"'}$self->{'usr_single_hostname'}" .
				"$txt{'\"'}$txt{')'}\n" .
				"$txt{'singlehost_err_p2'}\n";

			return 0;
		}

		@{$self->{'dest_hosts'}} = $tmp;
		return 1;
	}

	# hostlist
	#
	$tmp = $self->{'usr_hostlist_fname'};
	if (($tmp =~ /\s/) || ($tmp =~ /^$/)) {
		$$msg_ref =
			"\n$txt{'ERROR:'}\n" .
			"$txt{'hostlist_fname_err'}\n";
		return 0;
	}
	if ( ( ! -T $self->{'usr_hostlist_fname'} ) ||
		( ! open( HOSTFILE, "<$self->{'usr_hostlist_fname'}" ) ) )  {
		$$msg_ref =
			"\n$txt{'ERROR:'}\n" .
			"$txt{'Unable_hostfile'}$self->{'usr_hostlist_fname'}" .
			"$txt{'.'}\n";

		return 0;
	}
 
    while (<HOSTFILE>) {
        chomp;
        $tmp = $_;
        s/\#.*$//;
        s/^\s+//;
        s/\s+$//;
        /^$/ && next;
        if (/\s/) {
			$$msg_ref .= "  $.$txt{':'} $txt{'\"'}$tmp$txt{'\"'}\n";
        } else {
            $self->{'hostsbylineno'}->{$.} = $_;
 
            push( @{$self->{'dest_hosts'}}, $_ );
        }
    }
    close( HOSTFILE );

	# deal with embedded whitespace errors already caught
	#
	if ($$msg_ref) {
		$$msg_ref = 
			"\n$txt{'ERROR:'}\n" .
			"$txt{'hostlist_err1'}\n" .
			"$$msg_ref";
		undef( @{$self->{'dest_hosts'}} );
		return 0;
	}

	# deal empty hostlist
	#
	if ( ! @{$self->{'dest_hosts'}} ) {
		$$msg_ref =
			"\n$txt{'ERROR:'}\n" .
			"$txt{'no_hosts'}\n";	
		return 0;
	}

	# generate message listing hosts from file
	#
	$$msg_ref = "$txt{'list_hosts'}\n";
	foreach (@{$self->{'dest_hosts'}}) {
		$$msg_ref .= "$_\n";
	}

	return 1;
}


sub GenSummary {
	local( $self ) = @_;


	local( $outtext, @list, $tmp );

	local( $fmt_data1 ) = "%-" . $nlsdata{'summarize_data_col'} . "s%s\n";
	local( $fmt_data2 ) = " "  x $nlsdata{'summarize_data_col'} . "%s\n";


	$outtext = "$smztxt{'hdr'}";

	# this is specifically for webpub beta
	#
	$outtext .= "$smztxt{'host2'} $self->{'usr_single_hostname'}\n";
	return $outtext;


	# the rest is not used by web pub beta

	if ( $self->{'usr_destspectype'} eq "single" ) {
		$outtext .= sprintf(	$fmt_data1, 
								$smztxt{'host'}, 
								$self->{'usr_single_hostname'} );
	} else { 
		$tmp = $smztxt{'hostlist'};
		if ( $tmp =~ /\n/ ) {
			@list = split( '\n', $tmp );
			$tmp = pop( @list );
			foreach (@list) {
				$outtext .= "$_\n";
			}
		}
		$outtext .= sprintf(	$fmt_data1, 
								$tmp,
								$self->{'usr_hostlist_fname'} );
	}

	$outtext .= sprintf(	$fmt_data1,
							$smztxt{'dest'},
							$self->{'usr_destpath'} );
	
	$outtext .= "\n";

	$outtext .= sprintf(	$fmt_data1,
							$smztxt{'insttype'},
							$smztxt{ $self->{'usr_install_type'} } );
 
    if ($self->{'usr_install_type'} eq "fileserver") {
        @list = ();
        foreach (@{$self->{'usr_platforms'}}) {
			push( @list, 
				$self->{'Toc'}->GetOptsetPlatformText(
					$self->{'top_optset'},
					$self->{'top_optset_rev'},
					$_,
					"desc" )
			);

        }
        $outtext .= sprintf(    $fmt_data1,
                                $smztxt{'platspec'},
                                shift( @list ) );
        foreach (@list) {
            $outtext .= sprintf( $fmt_data2, $_ );
        }
    }

	$outtext .= "\n";

	@list = ();
	foreach (@{$self->{'usr_prodopts'}}) {
		push( @list, 
			$self->{'Toc'}->GetFilesetText(
				$_, 
				$self->{'top_optset_rev'},
				"desc" )
		);
	}
	$outtext .= sprintf(	$fmt_data1,
							$smztxt{'prodopts'},
							shift( @list ) );
	foreach (@list) {
			$outtext .= sprintf( $fmt_data2, $_ );
	}

	$outtext .= sprintf(	$fmt_data1,
							$smztxt{'user'},
							$self->{'usr_userid'} );

	$outtext .= sprintf(	$fmt_data1,
							$smztxt{'group'},
							$self->{'usr_groupid'} );

	return $outtext;
}


sub SetUserData {
	local( $self, $item, $data ) = @_;

	# set "$self->{'usr_blah'}" user data
	# presume data is scalar unless item is in $usr_list_data

	if (&IsMember( $item, @{$self->{'usr_list_data'}} )) {
		@{$self->{$item}} = @{$data};
	} else {
		$self->{$item} = $data;
	}

	$self->ClearValidationData();
}


sub ClearValidationData {
	local( $self ) = @_;

	$self->{'validate_occurred'}    = 0;
    $self->{'validate_errors'}      = 0;
    $self->{'validate_warnings'}    = 0;
	$self->{'validate_logtext'}		= "";
	$self->{'validate_summary_msg'}	= "";

	defined( $self->{'destcfgrecs'} ) && undef( $self->{'destcfgrecs'} );
}


sub numerically {
	$a <=> $b;
}


sub MungeOutputOfDestValScript {
	local( $self, $indent, $text, $dfout_ref, $installdat_ref ) = @_;

	# Breaks $text into "paragraphs",
	# runs each through &IndentAfterFirstLine(),
	# then puts them back together without blank lines.
	# Also pull out the df output which is a paragraph whose firstline is 
	# DF=
	# If it contains the strings "FAILURE", set the dfout ref to null, and
	# and an appropriate err msg output msg text.

	local( $line, @paragraphs, $i, $j, $tmp, $outtext );
	local( $installdat_flag, $dfout_flag );

	$ENV{'NI_DEBUG_MUNGEVALOUT'} && print "text>\n$text\n<\n";

	$outtext			= "";
	$$dfout_ref			= "";
	$$installdat_ref	= "";

	$i = $dfout_flag = $installdat_flag = 0;
	$tmp = "";
	foreach $line (split(/^/, $text)) {

		$ENV{'NI_DEBUG_MUNGEVALOUT'} && print "line: $line";


		if ( $line =~ /^$/ ) {
			if ($dfout_flag) {
				$$dfout_ref = $tmp;
				if ($$dfout_ref =~ /FAILURE/) {
					$$dfout_ref =~ s/FAILURE//;
					$paragraphs[$i] = 
						"$txt{'destval_unable_df'}\n" .
						"$$dfout_ref";
					++$i;
					$$dfout_ref = "";
				}

				$dfout_flag = 0;
				$tmp = "";
				next;
			} elsif ($installdat_flag) {
				$$installdat_ref = $tmp;
				$installdat_flag = 0;
				$tmp = "";
				next;
			} else {
				$paragraphs[$i] = $tmp;
				++$i;
				$tmp = "";
				next;
			}
		}
		
		if ($line =~ /^DF=/) {
			$dfout_flag = 1;

		} elsif ($line =~ /^INSTALLDAT=/) {
			$installdat_flag = 1;

		} else {
			chomp( $line );
			$tmp .= "$line\n";
		}
	}

	$ENV{'NI_DEBUG_MUNGEVALOUT'} && print "i: $i\n";
	for $j (0..$i) {
		$ENV{'NI_DEBUG_MUNGEVALOUT'} && print "paragraph $j: $paragraphs[$j]";
		$outtext .= &IndentAfterFirstLine( $indent, $paragraphs[$j] );
	}

	return $outtext;
}


sub GenDestValScript {
	local( $self ) = @_;

	# the return status of the validation script is expected to be:
	#   0: no errs or warnings
	#   1: errors which preclude further validation
	#   2: errors which do not preclude further validation
	#   3: warnings only

	return <<"EOD";

HOST=\$1
DESTDIR=\$2
USER=\$3
GROUP=\$4
OSARCH=\$5
OSMAJOR=\$6
OSMINOR=\$7
INSTALLDATFILE=\$8

EXIT_STATUS=0

Exit() {
	rm -rf \$TESTDIR/\$TEMPDIR >/dev/null 2>&1
	exit \$1
}


if [ -d \$DESTDIR ]; then
	TESTDIR=\$DESTDIR
	TMPSTAT="destdir"
else
	NEXTCOMP=\$DESTDIR
	TESTDIR=`dirname \$DESTDIR`
	while [ ! -d \$TESTDIR -a \$TESTDIR != '/' ]; do
		NEXTCOMP=`basename \$TESTDIR`
		TESTDIR=`dirname \$TESTDIR`
	done
	TMPSTAT="ancestor"
fi

echo "cd \$TESTDIR" | sh >/dev/null 2>&1
if [ \$? -ne 0 ]; then

	case \$TMPSTAT in

		# err: destdir exists, but we can't cd there
		#
		"destdir")
			cat <<-EOD
				$txt{'destval_existdest_unable_cd'}

			EOD
			;;

		# err: destdir does not exist, and we can't cd to it's closest
		# existing component dir
		#
		"ancestor")
			cat <<-EOD
				$txt{'destval_unable_cd_to_comp'}

			EOD
			;;
	esac

	exit 1
fi

cd \$TESTDIR >/dev/null 2>&1

if [ \$TMPSTAT = "ancestor" ]; then
	if [ -h \$NEXTCOMP ]; then
		cat <<-EOD
			$txt{'destval_comp_is_link'}

		EOD
		exit 1
	fi
	if [ -f \$NEXTCOMP ]; then
		cat <<-EOD
			$txt{'destval_comp_is_file'}

		EOD
		exit 1
	fi

	TEMPDIR=\$NEXTCOMP
else
	TEMPDIR="`basename \$0`.tmp.\$\$"
fi

mkdir \$TEMPDIR >/dev/null 2>&1
if [ \$? -ne 0 ]; then

	if [ \$TMPSTAT = "ancestor" ]; then

		# err: would not be able to mkdir destdir
		#
		cat <<-EOD
			$txt{'destval_unable_mkdir'}

		EOD
		exit 1

	else
		
		# err: would not be able to write in destdir
		#
		cat <<-EOD
			$txt{'destval_unable_write'}

		EOD
		exit 1
	fi
fi



#
#
echo "DF="
case \$OSARCH in
	sun*)	/usr/sbin/df -k .	;;
	ibmpow)	/usr/bin/df -k .	;;
	hppa)	/usr/bin/df -k .	;;
esac
if [ \$? -ne 0 ]; then
	EXIT_STATUS=1
	echo "FAILURE"
fi

echo ""

if [ -f \$INSTALLDATFILE ]; then
	echo "INSTALLDAT="
	/usr/bin/cat \$INSTALLDATFILE
	echo ""
fi


Exit \$EXIT_STATUS
EOD
}


sub SetIpByHostsHash {
	local( $self, $ipbyhostshash_ref ) = @_;

	%{$self->{'ipbyhosts'}} = %{$ipbyhostshash_ref};
}


sub IsHostLocal {
	local( $self, $host ) = @_;

	#print "IsHostLocal:\n";
	#print "host:            >$host<\n";
	#print "local_ip:        >$self->{'local_ip'}<\n";
	#print "ipbyhosts entry: >$self->{'ipbyhosts'}->{$host}<\n\n";

	if (%{$self->{'ipbyhosts'}}) {
		return $self->{'ipbyhosts'}->{$host} eq $self->{'local_ip'};
	}

	(@tmp=gethostbyname( $host )) || return 0;
    ($a,$b,$c,$d) = unpack('C4', ($tmp[4])[0]);
    $ip = "$a.$b.$c.$d";

	return $ip eq $self->{'local_ip'};

}


sub ParseInstallDat {
	local( $self, $installdat, $platformlist_ref ) = @_;

	local( $space_used ) = 0;
	local( $fset, $platform );
	local( %redundhash ) = ();
	local( @archiveslist ) = ();

	$installdat || return $space_used;

	foreach $line (split(/^/, $installdat)) {
		$line =~ s/^\s+//;
		$line =~ s/\s+$//;
		($line =~ /^$/) && next;
		($line =~ /^#/) && next;
		($line =~ /^install/) && next;

		$_ = $line;
		($fset, $platform) = split();

		$platform || ($platform = "common");

		if ( ! ${$redundhash{$fset}}{$platform} ) {
			
			if ( ref($redundhash{$fset}) != "HASH" ) {
				$redundhash{$fset} = {};
			}

			${$redundhash{$fset}}{$platform} = 
				$self->{'Toc'}->GetFilesetSize(
					$fset, $self->{'top_optset_rev'}, $platform );
		}
	}

	
	$self->{'Toc'}->GetOptPlatformArchivesList( 
		$self->{'top_optset'},
		$self->{'top_optset_rev'},
		$self->{'usr_prodopts'},
		$platformlist_ref,
		\@archiveslist );


	foreach (@archiveslist) {
		$platform = $_->{'platform_tag'};
		$platform || ($platform = "common");

		$fset = $_->{'prodopt_tag'};

		if (${$redundhash{$fset}}{$platform}) {
			$space_used += ${$redundhash{$fset}}{$platform};
		}
	}

	return $space_used;
}


sub GenStatusHostList {
	local( $self, $status ) = @_;

	local( @list ) = ();

	foreach (keys(%{$self->{'destcfgrecs'}})) {
		if ($self->{'destcfgrecs'}->{$_}->{'status'} eq $status) {
			push( @list, $_ );
		}
	}

	return sort(@list);
}


1;
