# InstBE.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;

$SIG{'INT'} = $SIG{'QUIT'} = $SIG{'TERM'} = 'IGNORE';

BEGIN { eval <<'EOD'
require "cd.pl";
EOD
}
BEGIN { eval <<'EOD'
require "CD.PL";
EOD
}
BEGIN { eval <<'EOD'
require "CD.PL;1";
EOD
}
BEGIN { eval <<'EOD'
require "cd.pl;1";
EOD
}

BEGIN { &main::Require("InstBE.nls");	import InstBE_nls; }

#
BEGIN { 
	&main::Require("syscmd.pl");

	# we'll presume that these have already been checked-for 
	# in the front-end, and appropriate warnings were issued
	# if rcp or rsh not found

	# the entire set used in install.pl is reproduced here
	# as we must now init for everything InstBE calls, also.
	# we also throw in the "optional" commands (rsh & rcp)
	@cmds = qw(
        mv rm mkdir stty uname date hostname clear touch tar chown
        chgrp cat chmod sh rsh rcp
	);

	&main::Syscmd_Init( \@cmds, [] );
}

BEGIN { &main::Require("Toc.pm");       import Toc; }
BEGIN { &main::Require("Scfg.pm");		import Scfg; }
BEGIN { &main::Require("MiscUtil.pl");	import MiscUtil; }
BEGIN { &main::Require("RmtUtil.pl");	import RmtUtil; }




local( $tocfile, $toctagfile );
local( $error, @cfglist );
local( $ret ) = 0;
local( $errcount, $warncount, $okcount );
$errcount = $warncount = $okcount = 0;

local( $Toc ) = new Toc ();

$cfgfile = $ARGV[0];

$tocfile = $ENV{'NI_TOCFILE'};
$toctagfile = $ENV{'NI_TOCTAGFILE'};

$errlogbase = $ni_errlog;
$msgindent1 = 2;

$| = 1;

if ( ! &ParseCfgFile( $cfgfile, \@cfglist, \%cfghdr, \$error ) ) {
	print $error;
	exit 1;
}
if ($ENV{'NIBE_DEBUG'}) {
	print "Dumping backend cfglist from parsed install config file...\n";
	&DumpArray( 0, @cfglist );
	print "Continue...\n";
	$foo=<STDIN>;
}


#
$nibe_optset		= $cfghdr{'optset'};
$nibe_optsetrev 	= $cfghdr{'optsetrev'};
$nibe_arcroot		= $cfghdr{'arcroot'};
$nibe_insttype		= $cfghdr{'insttype'};
$nibe_customflag	= $cfghdr{'custom'};
#
$nibe_sysdate		= $ENV{'NI_SYSDATE'};

if ( ! $Toc->Init($tocfile, $toctagfile) ) {
	print $Toc->{'error'};
	exit 1;
}


#
if ($nibe_customflag) {
	&main::Require( "custom.pl" );
	import Custom;
}


foreach $destcfgref (@cfglist) {
	$destcfg_host 		= ${$destcfgref->{'host'}}[0];
	$destcfg_arch 		= ${$destcfgref->{'arch'}}[0];
	$destcfg_dest 		= ${$destcfgref->{'dest'}}[0];
	$destcfg_user 		= ${$destcfgref->{'user'}}[0];
	$destcfg_group 		= ${$destcfgref->{'group'}}[0];
	@destcfg_platforms 	= @{$destcfgref->{'platforms'}};
	@destcfg_prodopts 	= @{$destcfgref->{'prodopts'}};
	$destcfg_status		= ${$destcfgref->{'status'}}[0];
	$destcfg_message	= ${$destcfgref->{'message'}}[0];
	$destcfg_islocal	= ${$destcfgref->{'islocal'}}[0];

	if ($destcfg_status eq "err") {
		print "$txt{'Not'} $txt{'installing'} $txt{'to_host'} $destcfg_host\n";
		if ($destcfg_message) {
			print "$txt{'Reason:'} $destcfg_message\n";
		}
		print "\n";
		next;
	}

	print "$txt{'Installing'} $txt{'to_host'} $destcfg_host\n";
	if ($destcfg_status eq "warn") {
		print "$txt{'WARNING:'} $destcfg_message\n";
		++$warncount;
	} else {
		$destcfg_message && &PrintText( "$destcfg_message\n\n", $msgindent1 );
	}


	$ret = &Install(	
			$destcfg_dest, 
			$destcfg_user, 
			$destcfg_group, 
			\@destcfg_prodopts,
			\@destcfg_platforms,
			$destcfg_host,
			$destcfg_arch,
			$destcfg_islocal,
			$Toc );
	
	( ! $ret ) && ++$errcount;
	( $ret eq "warn" ) && ++$warncount;

	if ( $ret ) {
		print 	"$txt{'Completed'} $txt{'installation'} $txt{'to_host'} " .
				"$destcfg_host$txt{'.'}\n";
	} else {
		print	"$txt{'ERROR:'} $txt{'Unsuccesful'} $txt{'installing'} " .
				"$txt{'to_host'} $destcfg_host$txt{'.'}\n";
	}
	print "\n";
}

print "\n";
if ($errcount) {
	print "$txt{'errors'}\n\n";
} else {
	print "$txt{'The_install_ok'}";
	$warncount && print "$txt{'with_warnings'}";
	print "\n\n";
}

($errcount+$warncount) && print "$txt{'Please_review'}\n\n";

exit (($errcount+$warncount) ? 1 : 0);


#############################################################################

sub ParseCfgFile {
	local( 	$cfgfile, 
			$cfglist_ref, 
			$cfghdr_ref,
			$error_ref ) = @_;

	local( $cfgfile_scfg ) = new Scfg();
	local( %tmphash ) = {};
	local( %ongoinghash ) = {};
	local( $newhashref, $key );

	# fields which must be present at the beginning of the cfg file
	#
	local( @cfg_header ) = qw( 
		optset 
		optsetrev 
		arcroot
		insttype
		custom
	);

	# fields required for each install record
	#
	local( @rec_req ) = qw(
		host
	);

	# fields which may be present for each record, but are optional if 
	# set previously in the cfg file - their values "carry"
	# There is provision for setting these prior to the first record.
	#
	local( @rec_opt1 ) = qw(
		arch
        dest
        prodopts
        platforms
        user
        group
    );

	# fields which are optional for each record
	# their values do not carry
	#
	local( @rec_opt2 ) = qw(
		status
		message
		islocal
	);

		
	if ( ! $cfgfile_scfg->InitFromFile( $cfgfile ) ) {
		$$error_ref = $cfgfile_scfg->{'error'};
		return 0;
	}

	# get the required header
	#
	$cfgfile_scfg->ParseKeys( \@cfg_header, [], \%tmphash, $error_ref )
		|| return 0;
	$cfghdr_ref->{'optset'} 		= ${$tmphash{'optset'}}[0];
	$cfghdr_ref->{'optsetrev'}		= ${$tmphash{'optsetrev'}}[0];
	$cfghdr_ref->{'arcroot'}		= ${$tmphash{'arcroot'}}[0];
	$cfghdr_ref->{'insttype'}		= ${$tmphash{'insttype'}}[0];
	$cfghdr_ref->{'custom'}			= ${$tmphash{'custom'}}[0];

	# allow that the "optional" per-host fields may be set for ongoing use
	# before the first host record
	#
	$cfgfile_scfg->ParseKeys( [], \@rec_opt1, \%ongoinghash, $error_ref ) 
		|| return 0;

	# get the first record, and check we've gotten all fields by now
	#
	$cfgfile_scfg->ParseKeys( \@rec_req, [], \%tmphash, $error_ref )
		|| return 0;
	&UpdateHash( \%ongoinghash, \%tmphash );
	$cfgfile_scfg->ParseKeys( [], [(@rec_opt1,@rec_opt2)], \%tmphash, $error_ref )
		|| return 0;
	&UpdateHash( \%ongoinghash, \%tmphash );
	foreach (@rec_opt1) {
		if ( ! defined( $ongoinghash{$_} ) ) {
			$$error_ref = "$txt{'missing_fields'}\n";
			return 0;
		}
	}
	$newhash_ref = {};
	%$newhash_ref = %ongoinghash;
	push( @$cfglist_ref, $newhash_ref );
	foreach $key (keys(%ongoinghash)) {
		grep( /$key/, @rec_opt2 ) && delete($ongoinghash{$key});
	}

	# get the rest of the records, any of which may only be "host" fields
	#
	while (1) {
		if ( ! $cfgfile_scfg->ParseKeys(
			\@rec_req,
			[],
			\%tmphash,
			$error_ref ))
		{
			if ($$error_ref eq "EOD") {
				$$error_ref = "";
				last;
			} else {
				last;
			}
		}
			
		&UpdateHash( \%ongoinghash, \%tmphash );
		$cfgfile_scfg->ParseKeys( 
				[], 
				[(@rec_opt1,@rec_opt2)],
				\%tmphash, 
				$error_ref ) || return 0;
		&UpdateHash( \%ongoinghash, \%tmphash );
    	$newhash_ref = {};
	    %$newhash_ref = %ongoinghash;
	    push( @$cfglist_ref, $newhash_ref );
		foreach $key (keys(%ongoinghash)) {
			grep( /$key/, @rec_opt2 ) && delete($ongoinghash{$key}); 
		}
	}

	return $$error_ref ? 0 : 1;
}


sub Install {
	local( 	$dest, 
            $user, 
            $group, 
			$prodopts_ref,
			$platforms_ref,
			$host,
			$arch,
			$islocal,
			$toc ) = @_;

	# return value is:
	# 0			error (not successful)
	# 1			oki-doki
	# "warn"	successful, but with a warning

	local( $optdata, $file, $error, $errlog, $acv );
	local( $cmd, $cmdout, $cmdret, $dummy, $retval );
	local( $rmttmpcmd_name ) = "/tmp/nibe_installtmp.$$";
	local( *RMTTMPCMD );
	local( @optdatalist, @tmplist );
	local( $error ) = "";
	local( $ret ) = 1;

	$errlog = "${errlogbase}.${host}.$$";

	# set some env vars which may be used by custom processing
	#
	$ENV{'NI_HOSTISLOCAL'}	= $islocal;
	$ENV{'NI_HOST'}			= $host;
	$ENV{'NI_DEST'}			= $dest;


	# now get the option data list, oh yah
	# a list of hashrefs, each describing a prod/platform option
	# and containing a list of corresponding archive files, and stuff
	# 	$prodopt_tag
	# 	$prodopt_desc
	# 	$platform_tag
	# 	$platform_desc
	# 	\@archives
	#
	if ( ! $toc->GetOptPlatformArchivesList(
			$nibe_optset,
			$nibe_optsetrev,
			$prodopts_ref,
			$platforms_ref,
			\@optdatalist ) ) {
		print "$txt{'ERROR:'} $txt{'failed_acvlist'} $toc->{'error'}\n\n";
		return 0;
	}

	if ($ENV{'NIBE_DEBUG'}) {
		print "Dumping optdatalist from GetOptPlatformArchivesList...\n";
		&DumpArray( 0, @optdatalist );
		print "Continue...\n";
		$foo=<STDIN>;
	}


	# ensure dest dir and .install installdata dir exist
	#
	if ( ! &RmtMkdir( $host, "$dest/.install", \$error, $islocal ) ) {
		&PrintText( $error, ($msgindent1*2) );
		return 0;
	}

	if ($islocal) {

		# change dir to the dest
		#
		if ( ! chdir( $dest ) ) {
			&PrintText( "$txt{'cant_chdir_to'} ${dest}$txt{'.'}\n",
				($msgindent1*2) );
			return 0;
		}
	} else {

		# create locally the remote install command file
		#
	    if ( ! open( RMTTMPCMD, ">$rmttmpcmd_name" ) ) {
			&PrintText( "$txt{'unable_create_rmt'} $txt{'(local_copy)'}$txt{'.'}",
				($msgindent1*2) );
			return 0;
		}
		print RMTTMPCMD &GenRmtInstCmd();
		close( RMTTMPCMD );
	}

	# enter one-pass loop that errors may drop out and do cleanup
	#
	while ( 1 ) {

		# copy the remote install command file to the remote host
		#
		if ( (! $islocal) &&
				 system("$System::rcp $rmttmpcmd_name $host:$rmttmpcmd_name") ) {
			&PrintText( "$txt{'unable_create_rmt'}$txt{'.'}\n", ($msgindent1*2) );
			$ret = 0;
			last;
		}

		foreach $optdata (@optdatalist) {
			
			$usermsg =
				"$txt{'Installing'} " .
				"$txt{'doublequote'}$optdata->{'prodopt_desc'}$txt{'doublequote'} ";
				if ($optdata->{'platform_tag'}) {
					$usermsg .= "$txt{'for'} $optdata->{'platform_desc'}";
				}
			$usermsg .= "\n";
	        &PrintText( $usermsg, $msgindent1 );
 
	        @acvlist = @{$optdata->{'archives'}};
	        foreach $acv (@acvlist) {

				$file = 
					&main::CdFilePath( $nibe_arcroot, $acv, "escape_semicolon");
				$file_for_test =
					&main::CdFilePath( $nibe_arcroot, $acv );
				if ( ! ( -r $file_for_test && -s $file_for_test && -f $file_for_test ) ) {
					&PrintText(	"$txt{'unable_archive'}\n" .
									"$nibe_arcroot/$acv$txt{'.'}\n", 
								($msgindent1*2) );
					$ret = 0;
					last;
				}

				if ($islocal) {
		            $cmd = "$System::tar xvf $file 2>&1";
		            $cmdout = "$cmd\n" . `$cmd`;
		            if ( $? ) {
		                &GenErrorLog( $errlog, $cmdout, ($msgindent1*2) );
						$ret = 0;
						last;
		            }
				} else {
					$cmd = "(dd if=$file | $System::rsh $host \"sh $rmttmpcmd_name \") 2>&1";

					$cmdret = $cmdout = `$cmd`;

					if ($ENV{'NIBE_RMT_DEBUG'}) {
						print "*** BEGIN NIBE_RMT_DEBUG ***\n";
						print "cmd:>\n$cmd\n<\n";
						print "raw out:>\n$cmdret<\n";
						print "*** END NIBE_RMT_DEBUG ***\n";
					}

					if ( $? ) {
						&PrintText( "$txt{'unable_rsh'}\n", ($msgindent1*2) );
						$ret = 0;
						last;
					}
					@tmplist = split('\n', $cmdout);
					$cmdret = $tmplist[$#tmplist];
					chomp( $cmdret );
					if ( $cmdret ) {
						&GenErrorLog( $errlog, $cmdout, ($msgindent1*2) );
						$ret = 0;
						last;
					}
				}
				$ret || last;
			}
			$ret || last;
		}
		$ret || last;

		# if not root, do no post-install processing
	    if ($ENV{'NI_NOTROOT'}) {
			print "doin' no post-processing.\n";
			last;
		}


				



		# if available, do custom post-processing
		#
		undef $error;
        if (($nibe_insttype eq "runable") && defined(&Custom_PostProc)) {
			$ret = &Custom_PostProc( \$error, $arch );
			if ( ! $ret ) {
				$error = "$txt{'ERROR:'} $error";
				&PrintText( $error, $msgindent1, "noindent_firstline" );
				last;
			} elsif ( $ret eq "warn" ) {
				$error = "$txt{'WARNING:'} $error";
				&PrintText( $error, $msgindent1, "noindent_firstline" );
			} elsif ($error) {
				&PrintText( "\n", $msgindent1 );
				&PrintText( $error, $msgindent1 );
			}
		}


		# do installation signature & history files
		# here only if no errors so far
		#
		&DoSigfile( $dest, \@optdatalist, $Toc, $islocal ) || ($ret = 0);
		&DoHistfile( $dest, $Toc, $islocal ) || ($ret = 0);


		last;
	} # one-pass loop


	# cleanup
	#
	if ( (! $islocal) && (! $ENV{'NI_NODEL'}) ) {
		#system("$System::rsh $host rm $rmttmpcmd_name");
		&RmtCmd(    $host,  
					"rm -f $rmttmpcmd_name 2>&1",   
					\$dummy,
					\$dummy,
					\$dummy );  
		( -f $rmttmpcmd_name ) && unlink( $rmttmpcmd_name );
	}


	return $ret;
}


sub SetOwnershipLocal {
	local( $topdir, $user, $group, $error_ref ) = @_;

	local( $cmd );

	undef $$error_ref;

	$cmd = "cd $topdir; $System::chown -R $user . 2>&1";
    $$error_ref = "$cmd\n" . `$cmd`;
	$? && return 0;

    $cmd = "cd $topdir; $System::chgrp -R $group . 2>&1";
    $$error_ref = "$cmd\n" . `$cmd`;
	$? && return 0;

	undef $$error_ref;
	return 1;
}


sub SetOwnershipRemote {
	local( $host, $topdir, $user, $group, $error_ref ) = @_;

	local( $rcmdret, $rcmdout );

	&RmtCmd( $host,
		"(cd $topdir; chown -R $user . 2>&1)",
		\$rcmdret, \$rcmdout,
		$error_ref ) || return 0;

	if ( $rcmdret ) {
		$$error_ref = $rcmdout;
		return 0
	}
 
	&RmtCmd( $host,
		"(cd $topdir; chgrp -R $group . 2>&1)",
		\$rcmdret, \$rcmdout,
		$error_ref ) || return 0;

	if ( $rcmdret ) {
		$$error_ref = $rcmdout;
		return 0;
	}

	return 1;
}


sub GenErrorLog {
	local( $file, $error, $indent ) = @_;

	local( *ERRLOG );

	&PrintText( "$txt{'An_error_blah'}\n", $indent );
	if ( open( ERRLOG, ">$file" ) ) {
		&PrintText( "$txt{'See'} ${file}\n\n", $indent );
		print ERRLOG "$error";
		close( ERRLOG );
		return 1;
	} else {
		PrintText( "$txt{'couldnt_errlog'}\n\n", $indent );
		return 0;
	}
}


sub GenRmtInstCmd {
	
	local( $rmtinstcmd ) = <<"EOD";
if [ ! -d $dest -o ! -r $dest -o ! -x $dest ]; then
    echo "$txt{'cant_chdir_to'} $dest\\n1"
    exit 1
fi
 
cd $dest
 
touch .\$\$ >/dev/null 2>&1
if [ \$\? -ne 0 ]; then
    echo "$txt{'cannot_write_in'} $dest\\n1"
    exit 1
fi
rm .\$\$
 
sleep 1

cat - | tar xvf -
ret=\$\?
 
echo ""
sleep 2
 
echo \$ret
exit
 
EOD

	return $rmtinstcmd;
}


sub PrintText {
	local( $text, $indent, $special ) = @_;

    local( @lines, $trailing_newlines, $tmp );
 
	$trailing_newlines = 0;
	while( $tmp = chomp( $text ) ) {
		$trailing_newlines += $tmp;
	}
    @lines = split('\n', $text);
	if ( $special eq "noindent_firstline" ) {
		print shift(@lines);
		(@lines) && print "\n";
	}
    while (@lines) {
        $_ = shift(@lines);
        print " " x $indent;
        print;
        (@lines) && print "\n";
    }
    print "\n" x $trailing_newlines;
}


sub DoSigfile {
	local( $dest, $optdatalist_ref, $toc, $islocal ) = @_;

    local( $sigfile_text, $sigfile_tmpfname, $sigfile_pname );
	local( *SIGFILETMP, $optdata, $rmtret );
	local( $ret ) = 1;


	$sigfile_tmpfname	= "/tmp/ni_tmpsig.$$";
	$sigfile_pname		= "$dest/.${nibe_optset}${nibe_optsetrev}.dat";


	$sigfile_text = sprintf( "%-10s %-10s %-10s  # %s\n",
		"install",
		$toc->{'distrev'},
		$nibe_insttype,
		$nibe_sysdate );

	foreach $optdata (@$optdatalist_ref) {
		$sigfile_text .= sprintf( "%-10s %-10s\n", 
			$optdata->{'prodopt_tag'},
			$optdata->{'platform_tag'} );
	}


	if ( ! open( SIGFILETMP, ">$sigfile_tmpfname" ) ) {
		&PrintText( 
			"$txt{'ERROR:'} $txt{'unable_tmpsig'} " .
				"$sigfile_tmpfname$txt{'.'}",
			$msgindent1, "noindent_firstline" );
		return 0;
	}
	print SIGFILETMP $sigfile_text;
	if ( ! close( SIGFILETMP ) ) {
		&PrintText( 
			"$txt{'ERROR:'} $txt{'unable_tmpsig'} " .
				"$sigfile_tmpfname$txt{'.'}",
			$msgindent1, "noindent_firstline" );
		return 0;
	}
			

	if ( $islocal ) {
		$cmd = 
			"$System::cat $sigfile_tmpfname >> $sigfile_pname 2>&1";
		if ( system( $cmd ) ) {
			$ret = 0;
		} else {
			chmod( 0444, $sigfile_pname );
		}
	} else {
		$cmd = 
			"$System::rcp $sigfile_tmpfname " .
			"$host:$sigfile_tmpfname >/dev/null 2>&1";
		if ( system( $cmd ) ) {
			$ret = 0;
		} else {
			$ret = &RmtCmd(
				$host,
				"cat $sigfile_tmpfname >> $sigfile_pname",
				\$rmtret,
				\$dummy,
				\$dummy );
			if ( (! $ret) || ($rmtret) ) {
				$ret = 0;
			} else {
				&RmtCmd( 
					$host, 
					"chmod 0444 $sigfile_pname", 
					\$dummy,
					\$dummy,
					\$dummy );
			}
			&RmtCmd(
				$host,
				"rm -f $sigfile_tmpfname",
				\$dummy,
				\$dummy,
				\$dummy );
		}
	}
	if ( ! $ret ) {
		&PrintText(
			"$txt{'ERROR:'} $txt{'unable_sigfile'}\n", 
			$msgindent1, "noindent_firstline" );
	}

    $ENV{'NI_NODEL'} || unlink( $sigfile_tmpfname );

	return $ret;

}


sub DoHistfile {
	local( $dest, $toc, $islocal ) = @_;

    local( $histfile_text, $histfile_tmpfname, $histfile_pname );
	local( *HISTFILETMP, $rmtret );
	local( $ret ) = 1;


	$histfile_tmpfname	= "/tmp/ni_tmphist.$$";
	$histfile_pname		= "$dest/.install/history";


	$histfile_text = sprintf( "%-10s %-10s %-5s %-5s # %s\n",
		${nibe_optset},
		${nibe_optsetrev},
		$toc->{'disttype'},
		$toc->{'distrev'},
		$nibe_sysdate );

	if ( ! open( HISTFILETMP, ">$histfile_tmpfname" ) ) {
		&PrintText( 
			"$txt{'ERROR:'} $txt{'unable_tmphist'} " .
				"$histfile_tmpfname$txt{'.'}",
			$msgindent1, "noindent_firstline" );
		return 0;
	}
	print HISTFILETMP $histfile_text;
	if ( ! close( HISTFILETMP ) ) {
		&PrintText( 
			"$txt{'ERROR:'} $txt{'unable_tmphist'} " .
				"$histfile$txt{'.'}",
			$msgindent1, "noindent_firstline" );
		return 0;
	}
			

	if ( $islocal ) {
		$cmd = 
			"$System::cat $histfile_tmpfname >> $histfile_pname 2>&1";
		if ( system( $cmd ) ) {
			$ret = 0;
		} else {
			chmod( 0444, $histfile_pname );
		}
	} else {
		$cmd = 
			"$System::rcp $histfile_tmpfname " .
			"$host:$histfile_tmpfname >/dev/null 2>&1";
		if ( system( $cmd ) ) {
			$ret = 0;
		} else {
			$ret = &RmtCmd(
				$host,
				"cat $histfile_tmpfname >> $histfile_pname",
				\$rmtret,
				\$dummy,
				\$dummy );
			if ( (! $ret) || ($rmtret) ) {
				$ret = 0;
			} else {
				&RmtCmd( 
					$host, 
					"chmod 0444 $histfile_pname", 
					\$dummy,
					\$dummy,
					\$dummy );
			}
			&RmtCmd(
				$host,
				"rm -f $histfile_tmpfname",
				\$dummy,
				\$dummy,
				\$dummy );
		}
	}
	if ( ! $ret ) {
		&PrintText(
			"$txt{'ERROR:'} $txt{'unable_histfile'}\n", 
			$msgindent1, "noindent_firstline" );
	}

    $ENV{'NI_NODEL'} || unlink( $histfile_tmpfname );

	return $ret;
}
