# install.pl


## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


require 5.000;

$SIG{'INT'} = $SIG{'QUIT'} = $SIG{'TERM'} = 'IGNORE';

#
BEGIN { eval <<'EOD'
require "cd.pl";
EOD
}
BEGIN { eval <<'EOD'
require "CD.PL";
EOD
}
BEGIN { eval <<'EOD'
require "CD.PL;1";
EOD
}


&Require( "install.ph" );
BEGIN { &main::Require("install.nls"); import install_nls; }

#
BEGIN {
	&main::Require("syscmd.pl");

	@reqcmds = qw(
		mv rm mkdir env stty uname date hostname clear touch tar chown
		chgrp cat chmod sh
	);
	@optcmds = qw( rcp rsh );
	@notfound = ();

	if ( ! &main::Syscmd_Init( \@reqcmds, \@notfound ) ) {
		print "$txt{'ERROR:'} $txt{'syscmd1'}\n";
		foreach (@notfound) {
			print "  $_\n";
		}
		print "$txt{'syscmd2'}\n\n";
		exit 0;
	}

	if ( ! &main::Syscmd_Init( \@optcmds, \@notfound ) ) {
		print "$txt{'WARNING:'} $txt{'syscmd1'}\n";
		foreach (@notfound) {
			print "  $_\n";
		}
		print "$txt{'syscmd3'}\n";
		$foo=<STDIN>;
	}
}


chdir( $DistDir );

BEGIN { &main::Require("InstData.pm"); 	import InstData; }
BEGIN { &main::Require("Toc.pm"); 		import Toc; }
BEGIN { &main::Require("More.pm"); 		import More; }
BEGIN { &main::Require("MiscUtil.pl");	import MiscUtil; }
BEGIN { &main::Require("PrmptUsr.pl");	import PrmptUsr; }
BEGIN { &main::Require("tty.pl"); }

BEGIN { &main::Require("NIIS.pm");		import NIIS; }

local( $instdata )	= new InstData ();

$| = 1;


#
$instdata->{'top_optset'} 		= $TopOptset;
$instdata->{'top_optset_rev'}	= $TopOptSetRev;
$instdata->{'defsfile'}			= $DefaultsFile;

#
$instdata->{'tocfile'}			= &main::CdFilePath( $DistDir, $TocFile );
$instdata->{'tagfile'}			= &main::CdFilePath( $DistDir, $TocTagFile );
$instdata->{'dist'}				= $DistDir;
$instdata->{'arcroot'}			= &main::CdFilePath( "$DistDir", "$ArcDir");


#
$tmp = &main::CdFilePath( 
			"$instdata->{'arcroot'}", 
			"$instdata->{'top_optset'}/$instdata->{'top_optset_rev'}" );
push( @INC, "$tmp" );
$tmp = &main::CdFilePath(
			"$tmp",
			"nls/$ENV{'LLANG'}" );
push( @INC, "$tmp" );
#
#
$ENV{'PERL5LIB'} = join( ':', @INC );


if ( ! $instdata->Init() ) {
	print $instdata->{'error'};
	exit 1;
}


#
$ENV{'NI_TOCFILE'} = $instdata->{'tocfile'};
$ENV{'NI_TOCTAGFILE'} = $instdata->{'tagfile'};


$ENV{'NI_DEBUG_TOC'} && $instdata->{'Toc'}->Dump();

#
if ( ! $ENV{'NI_NOTROOT'} ) {
	if ( $> ) {
		print "\n$txt{'Error:'} ";
		print "$txt{'must_be_root'}\n\n";
		exit 1;
	}
}


local( $rows, $cols );
&CheckTerminalSize( \$rows, \$cols ) || exit 1;


$ENV{'NI_LOCALHOSTNAME'} = $instdata->{'local_hostname'};

if ( ! $instdata->ReadDefaultsFile() ) {
	$instdata->SetUserData( 'usr_destspectype',   $UsrDefs{'destspectype'} );
	$instdata->SetUserData( 'usr_destpath',		  $UsrDefs{'destpath'} );
	$instdata->SetUserData( 'usr_hostlist_fname', $UsrDefs{'hostlist_fname'} );
	$instdata->SetUserData( 'usr_userid',         $UsrDefs{'userid'} );
	$instdata->SetUserData( 'usr_groupid',        $UsrDefs{'groupid'} );
	$instdata->SetUserData( 'usr_prodopts',       $instdata->{'prodopts'} );
	$instdata->SetUserData( 'usr_platforms',      $instdata->{'platforms'} );
	$instdata->SetUserData( 'usr_install_type',   "runable" );
}
if ( ! $instdata->{'usr_single_hostname'} ) {
	$instdata->SetUserData( 'usr_single_hostname', $ENV{'NI_LOCALHOSTNAME'} );
}

local( $interview ) = new NIIS ( $rows, $cols, $instdata );
while ( ! ($ret = $interview->DoChain( $instdata )) ) { ; }
$ENV{'NI_SAVEDEFS'} && $instdata->WriteDefaultsFile();
&main::TtyModeRestore();
($ret == 2) || system("$System::clear");
exit 0;



sub NotImpl {
	local($tag) = @_;

	print "\n$tag is not implemented. Press Return.";
	read(STDIN, $c, 1);
}


sub DoInstall {
	local( $instdata ) = @_;

	local( *LOGFILE, $origfh, $tmp );
	local( $scrn_txt, $log_txt, $summary_txt, $tmp );
	local( $validate_flag_warnings, $validate_flag_errors );

	local( $final_prompt ) = 1;

	local( $more );


	if ( ! ($more = new More ($ENV{'NI_LINES'})) ) {
		&TellError( "$txt{'unable_more'}\n" );
		return 0;
	}

    system($System::clear);

	if ( ! open( LOGFILE, ">>$nlsdata{'install_logfile'}" ) ) {
		&TellError( "$txt{'Cant_logfile'} $nlsdata{'install_logfile'}\n" );
		return 0;
	}
	$origfh = select(LOGFILE); $| = 1;
	select($origfh);  $| = 1;

    $ret = 0;
    while (1) {

		$tmp = `$System::date`;
		@tmp = localtime();
		
		$ENV{'NI_SYSDATE'} = $tmp;
		chomp( $ENV{'NI_SYSDATE'} );
		$ENV{'NI_TIMESTR'} = sprintf( "%02d%02d%02d.%02d%02d",
			$tmp[5], $tmp[4]+1, $tmp[3], $tmp[2], $tmp[1] );

		$scrn_txt = $txt{'hdr_char1'} x $nlsdata{'sepline1_len'};
		$scrn_txt .= "\n$txt{'hdr_char1'} ";
		$scrn_txt .= "$txt{'begin_msg'}$txt{'sep_str1'}";
		$scrn_txt .= "$instdata->{'top_optset_desc'}\n";
		$scrn_txt .= "$txt{'hdr_char1'} $ENV{'NI_SYSDATE'}\n";
		$scrn_txt .= "\n\n";

		$summary_txt = $instdata->GenSummary() . "\n";
		$scrn_txt .= $summary_txt;

		$more->Print( $scrn_txt );
	
		$log_txt = "$scrn_txt\n";


		&ValidateForInstall(
			$instdata, 
			$summary_txt,
			$more,
			\$validate_flag_warnings,
			\$validate_flag_errors        )  || last;

		local( @hostlist_err, @hostlist_warn, @hostlist_ok );
		@hostlist_err	= $instdata->GenStatusHostList( "err" );
		@hostlist_warn	= $instdata->GenStatusHostList( "warn" );
		@hostlist_ok	= $instdata->GenStatusHostList( "" );


		if ( @hostlist_err && ! (@hostlist_warn || @hostlist_ok) ) {
			$txt = 
			$more->Print(
				"$txt{'inst_cant_because_errs'}\n\n" .
				"$txt{'please_correct'}\n\n" );
			last;
		}

		if ( @hostlist_err && (@hostlist_warn || @hostlist_ok) ) {
			$txt = "$txt{'some_errs'}\n";
			$more->Print($txt);
			$log_txt .= $txt;
			foreach (@hostlist_err) {
				$txt = "    $_\n";
				$more->Print($txt);
				$log_txt .= $txt;
			}
			$txt = "$txt{'some_errs_2'}\n\n";
			$more->Print($txt);
			$log_txt .= $txt;
		}


		if ( ! (@hostlist_err || @hostlist_warn) ) {
			$txt = "$txt{'inst_can'}\n\n";
			$more->Print($txt);
			$log_txt .= $txt;
		}

		$final_prompt = 0;
		$more->Close();
		$tmp = &PromptContAbort("$txt{'inst_abort'}");
		if ( ! $more->Init() ) {
			&TellError( "$txt{'unable_more'}\n" );
			last;
		}
		$more->Print( "\n" );
		if ($tmp) {
			$txt = "$txt{'inst_proceeding'}\n\n";
			$log_txt .= $txt;
		} else {
			last;
		}

		print LOGFILE $log_txt;
		$log_txt = "";

		if ( ! $instdata->GenInstallCfgFile() ) {
			print LOGFILE "$instdata->{'error'}\n";
			&TellError( "$instdata->{'error'}" );
			last;
		}


		$cmd = "$Perl " . &main::CdFilePath( $DistDir, $InstallBackend,
			"escape_semicolon" ) .
			" $instdata->{'cfg_file'}";

		if ( ! open( BACKEND, "$cmd 2>&1 |") ) {
			$scrn_txt = "$txt{'Cant_backend'}$txt{':'}\n$cmd\n";
			print LOGFILE $scrn_txt;
			&TellError( $scrn_txt );
			last;
		}

		while (<BACKEND>) {
			$more->Print( $_ );
			print LOGFILE $_;
		}

		$scrn_txt = "$txt{'end_msg'}$txt{'sep_str1'}";
		$scrn_txt .= `$System::date`;
		$scrn_txt .= "$txt{'hdr_char1'}\n";
		$scrn_txt .= $txt{'hdr_char1'} x $nlsdata{'sepline1_len'};
		$scrn_txt .= "\n\n";

		$more->Print( $scrn_txt );
		print LOGFILE $scrn_txt;

		$more->Print( "$txt{'saved_log'} $nlsdata{'install_logfile'}\n" );

		$ret = 2;
		last;

	} # one-pass loop

	$ret && ($final_prompt = 0);

	if ( $final_prompt ) {
		$more->Print("$txt{'Press...'}");
		$more->Close();
		&GetMenuKey( "\033", "\011" );
	} else {
		$more->Close();
	}

	close( LOGFILE );
	close( BACKEND );

	$ENV{'NI_NODEL'} || unlink( $instdata->{'cfg_file'} );

	return $ret;
}


		sub TellError {
			local( $error ) = @_;

			local( $dummy );

			&main::TtyMode("cooked");
			print "$txt{'Error:'}\n";
			print $error;
			print "\n$txt{'Press...'}";
			$dummy = <STDIN>;
		}


		sub CheckTerminalSize {
			local( $rows_ref, $cols_ref ) = @_;

			local( $stty_out );

			if ( ($LArch =~ /^sun/) || ($LArch =~ /^hp/) ){
				$stty_out = `$System::env LANG=C $System::stty -a`;
				($$rows_ref) = ($stty_out =~ /$nlsdata{'sttyout_rows'}\s*\S+\s*([0-9]+)/);
				($$cols_ref) = ($stty_out =~ /$nlsdata{'sttyout_columns'}\s*\S+\s*([0-9]+)/);
			} elsif ($LArch =~ /^ibm/) {
				$stty_out = `$System::env LANG=C $System::stty -a`;
				@fields = split(/ /, $stty_out);
				foreach $item (@fields) {
					$item =~ tr/A-Z/a-z/;
					if ($item =~ /^rows/) {
						($$rows_ref) = $last;
					}
					elsif ($item =~ /^columns/) {
						($$cols_ref) = $last;
					}
					else {
					}
					$last = $item;
				}
			} else {
				$$rows_ref = $$cols_ref = 0;
			}

			if ( $$rows_ref && $$cols_ref ) {
				if ( ($$rows_ref < $MinTermLines) || ($$cols_ref <$MinTermColumns) ) {
					print "\n$txt{'Error:'} " .
						"$txt{'Minimum_term'} $MinTermColumns $txt{'columns_by'} " .
						"$MinTermLines $txt{'rows.'}\n" .
						"$txt{'Please_term_blah'}$txt{'.'}\n\n";
					return 0;
				} else {
					$ENV{'NI_LINES'}   = $$rows_ref;
					$ENV{'NI_COLUMNS'} = $$cols_ref;
					return 1;
				}
			}

			$$rows_ref = $ENV{$nlsdata{'envvar_lines_1'}};
			$$cols_ref = $ENV{$nlsdata{'envvar_cols_1'}};

			if ( ($$rows_ref < $MinTermLines) || ($$cols_ref <$MinTermColumns) ) {
				print "\n$txt{'Error:'} " .
					"$txt{'Minimum_term'} $MinTermColumns $txt{'columns_by'} " .
					"$MinTermLines $txt{'rows.'}\n" .
					"$txt{'Please_term_blah'}$txt{','}\n" .
					"$txt{'env_vars'} $Envvar_Columns $txt{'and'} " .
					"$Envvar_Lines $txt{'set_correctly'}$txt{'.'}\n" .
					"$txt{'resize'}\n\n";
				return 0;
			}

			$ENV{'NI_LINES'}   = $$rows_ref;
			$ENV{'NI_COLUMNS'} = $$cols_ref;

			return 1;
		}



sub ValidateForInstall {
	local(	$instdata, 			# in: the data to validate
			$summary_txt,		# in: already done cfg summary; for log
			$more,				# in: the more thingy already 
			$flag_warnings_ref,	# out
			$flag_errors_ref	# out
	) = @_;


	local( $scrn_txt, $log_txt, *LOGFILE, $tmpmsg, $tmpret );
	local( $abort ) = 0;
	local( $fail )	= 0;

	$$flag_warnings_ref = $$flag_errors_ref = 0;
		
	while (1) {

		$log_txt = 
			$txt{'hdr_char1'} x $nlsdata{'sepline1_len'} .
			"\n$txt{'hdr_char1'}\n" .
			"$txt{'begin_val'}$txt{'sep_str1'}" .
			"$ENV{'NI_SYSDATE'}\n" .
			"\n\n" .
			"$summary_txt";

		$tmpret = $instdata->LoadHostList( \$tmpmsg );
		$log_txt .= $tmpmsg;
		$more->Print( $tmpmsg );
		if ( ! $tmpret) {
			$$flag_errors_ref = 1;
			$fail = 1;
			last;
		}

		$more->Print( "\n$txt{'about_to_validate'}\n\n" );
		$log_txt .= "\n";
		$more->Close();
		if ( ! &PromptContAbort("$txt{'cont_abort'}") ) {
			$final_prompt = 0;
			$abort = 1;
			last;
		}
		if ( ! $more->Init() ) {
			&TellError( "$txt{'unable_more'}\n" );
			$fail = 1;
		}


		$scrn_txt = "\n$txt{'validating_hostnames'}\n";
		$more->Print( $scrn_txt );
		$log_txt .= $scrn_txt;
		if ( ! &ValidateHostNames( $instdata, \$tmpmsg ) ) {
			$tmpmsg = "$txt{'ERROR:'}\n$tmpmsg";
			$log_txt .= "$tmpmsg";
			$more->Print( $tmpmsg );
			$$flag_errors_ref = 1;
			$fail = 1;
			last;
		}
		$scrn_txt = "$txt{'Ok.'}\n\n";
		$more->Print( $scrn_txt );
		$log_txt .= $scrn_txt;


		$scrn_txt = "$txt{'validating_gen_cfg'}\n";
		$more->Print( $scrn_txt );
		$log_txt .= $scrn_txt;
		if ( ! $instdata->ValidateGeneralConfig( \$tmpmsg ) ) {
			$log_txt .= "$tmpmsg";
			$more->Print( $tmpmsg );
			$$flag_errors_ref = 1;
			$fail = 1;
			last;
		}
		$scrn_txt = "$txt{'Ok.'}\n\n";
		$more->Print( $scrn_txt );
		$log_txt .= $scrn_txt;


		$instdata->ValidateDestConfigs( 
			$more, 
			\$tmpmsg, 
			$flag_warnings_ref,
			$flag_errors_ref );
		$log_txt .= $tmpmsg;

		last;

	} # one-pass loop

	$abort && return 0;

    $scrn_txt = "\n";
    if ($$flag_errors_ref && $$flag_warnings_ref) {
        $scrn_txt .= "$txt{'val_errs_warns'}\n";
    } elsif ($$flag_errors_ref) {
        $scrn_txt .= "$txt{'val_errs'}\n";
    } elsif ($$flag_warnings_ref) {
        $scrn_txt .= "$txt{'val_warns'}\n";
    } else {
        $scrn_txt .= "$txt{'val_success'}\n";
    }
    $log_txt .= $scrn_txt;
    $more->Print( $scrn_txt );
 
	$log_txt .= "\n$txt{'end_val'}$txt{'sep_str1'}";
	$log_txt .= `$System::date`;
	$log_txt .= "$txt{'hdr_char1'}\n";
	$log_txt .= $txt{'hdr_char1'} x $nlsdata{'sepline1_len'} . "\n";;

	if ( open( LOGFILE, ">$nlsdata{'validate_logfile'}" ) ) {
		print LOGFILE $log_txt;
		if ( close( LOGFILE ) ) {
			$scrn_txt =
				"$txt{'wrote_validate_log'} " .
				"$nlsdata{'validate_logfile'}\n";
		} else {
			$scrn_txt =
				"$txt{'cant_validate_log'} " .
				"$nlsdata{'validate_logfile'}\n";
		}
	} else {
		$scrn_txt =
			"$txt{'cant_validate_log'} " .
			"$nlsdata{'validate_logfile'}\n";
	}

	$more->Print( "\n$scrn_txt\n" );

	return ( ! $fail );
}


sub ValidateHostNames {
	local( $instdata, $msgout_ref ) = @_;



	local( $lineno, %linenosbyip, @ip_orderlist, $ip, @tmp, $host, %ipbyhosts );


	$$msgout_ref = "";

	if ($instdata->{'usr_destspectype'} eq "single") {
		$host = $instdata->{'usr_single_hostname'};
		if ( ! (@tmp=gethostbyname( $host )) ) {
			$$msgout_ref = "$txt{'\"'}$host$txt{'\"'} $txt{'bad_host_p2'}\n";
			return 0;
		}
		($a,$b,$c,$d) = unpack('C4', ($tmp[4])[0]);
		$ip = "$a.$b.$c.$d";
		$ipbyhosts{$host} = $ip;
		$instdata->SetIpByHostsHash( \%ipbyhosts );

		return 1;
	}


	foreach $lineno (sort numerically keys(%{$instdata->{'hostsbylineno'}})) {
		
		if ( @tmp=gethostbyname($instdata->{'hostsbylineno'}->{$lineno}) ) {

			($a,$b,$c,$d) = unpack('C4', ($tmp[4])[0]);
			$ip = "$a.$b.$c.$d";
				
			(! $linenosbyip{$ip}) && push( @ip_orderlist, $ip );
			&AddItemToArrayHash(
				\%linenosbyip,
				$ip,
				$lineno );

			$ipbyhosts{$instdata->{'hostsbylineno'}->{$lineno}} = $ip;
			
		} else {
				
			$$msgout_ref .=
				"$txt{'\"'}$instdata->{'hostsbylineno'}->{$lineno}$txt{'\"'} " .
				"$txt{'(line'} $lineno $txt{'in_list)'} $txt{'bad_host_p2'}\n";
		}
	}

	foreach $ip (@ip_orderlist) {
		if (scalar(@{$linenosbyip{$ip}}) > 1) {
			$$msgout_ref .= "$txt{'same_addr'}\n";
			foreach $lineno (@{$linenosbyip{$ip}}) {
				$$msgout_ref .=
					"  $txt{'\"'}$instdata->{'hostsbylineno'}->{$lineno}" .
					"$txt{'\"'} " .
					"$txt{'(line'} $lineno $txt{'in_list)'}$txt{'.'}\n";
			}
		}
	}

	if ($$msgout_ref) {
		$$msgout_ref = "$txt{'list_errors'}\n" . $$msgout_ref;
		return 0;
	}

	$instdata->SetIpByHostsHash( \%ipbyhosts );

	return 1;
}


sub numerically {
    $a <=> $b;
}

	
1;
