# custom.pl

## Copyright (c) 1996, Lotus Development Corporation.
## All Rights Reserved.


package Custom;
@ISA = (Exporter);
@EXPORT = qw( Custom_PostProc Custom_PreValidate );

BEGIN { &main::Require("custom.nls"); import Custom_nls; }

BEGIN { &main::Require("RmtUtil.pl"); import RmtUtil; }

$LinkPoint = "/opt/lotus";
$TmpCmd = "/tmp/nicproc.$$";

#


sub Custom_PreValidate {
	local( 
		$warnings_ref, 
		$errs_ref, 
		$backendwarn_ref, 
		$backendmsg_ref, 
		$insttype, 
		$destpath, 
		$rev,
		$arch
	 ) = @_;

	# in:	$insttype			the installation type
	#		$destpath			installation destination path
	#		$rev				installation product rev (per toc)
	#		$arch				arch of system being installed to
	#
	# out:	$warnings_ref		ref to array for warning strings
	#		$errs_ref			ref to array for error strings
	#		$backendwarn_ref	ref to array for backend warning strings
	#		$backendmsg_ref		ref to array for backend message strings
	#
	# ret:	0					no errs
	#		1					errors which preclude further validation
	#		2					errors which do not preclude further validation
	#		3					warnings and/or msgs, but no errs


	local( $tmpcmdfile ) = "/tmp/nipreval.$$";
	local( $script, *TMPCMD, $scriptout, $err );
	local( $ret ) = 0;

	$script = &GenPreValidateScript( $insttype, $destpath, $rev, $arch );

	if ( ! open( TMPCMD, ">$tmpcmdfile" ) ) {
		pushd( @$errs_ref, "$txt{'Unable_tmpcmd'} $tmpcmdfile\n" );
		return 1;
	}
	print TMPCMD $script;

	while (1) { # a one-pass loop that we can drop-out and cleanup
		if ( ! close( TMPCMD ) ) {
			pushd( @$errs_ref, "$txt{'Unable_tmpcmd'} $tmpcmdfile\n" );
			$ret = 1;
			last;
		}

		if ( $ENV{'NI_HOSTISLOCAL'} ) {
			$scriptout = `<$tmpcmdfile sh`;
			$ret = ( $? >> 8 );
		} else {
			if ( ! &RmtCmdfile( $ENV{'NI_HOST'}, $tmpcmdfile,
						\$ret,
						\$scriptout,
						\$err ) ) {
				$ret = 1;
				push( @$errs_ref, $err );
				last;
			}
		}


		# "parse" script output into warning & err messages
		#
		local( @out, $mode, $msg, $ref );
		@out = split( '\n', $scriptout );
		foreach (@out) {
			if (	($_ eq "warn")		|| 
					($_ eq "err")		|| 
					($_ eq "bewarn")	||
					($_ eq "bemsg")
			) {
				if ($mode) {
					($mode eq "warn")	&& ($ref = $warnings_ref);
					($mode eq "err")	&& ($ref = $errs_ref);
					($mode eq "bewarn")	&& ($ref = $backendwarn_ref);
					($mode eq "bemsg")	&& ($ref = $backendmsg_ref);
					push( @$ref, $msg );
				}
				$msg = "";
				$mode = $_;
			} else {
				$msg .= $_ . "\n";
			}
		}
		if ($mode) {
			($mode eq "warn")	&& ($ref = $warnings_ref);
			($mode eq "err")	&& ($ref = $errs_ref);
			($mode eq "bewarn")	&& ($ref = $backendwarn_ref);
			($mode eq "bemsg")	&& ($ref = $backendmsg_ref);
			push( @$ref, $msg );
		}


		last;
	} # one-pass loop
		

	if ( ! $ENV{'NI_NODEL'} ) {
		(-f $tmpcmdfile) && unlink( $tmpcmdfile );
	}

	return $ret;
}


sub GenPreValidateScript {
	local( $insttype, $destpath, $rev, $arch ) = @_;

	local($ls)		= "/usr/bin/ls";
	local($sed)		= "/usr/bin/sed";
	local($rm)		= "/usr/bin/rm";
	local($pwd)		= "/usr/bin/pwd";

	return <<"EOD";


[ -n \"\$NI_DBG_CUSTPREVAL\" ] && set -x


check_writeable () {
	DIR=\$1
	echo \"cd \$DIR\" | sh >/dev/null 2>&1
	[ \$\? -ne 0 ] && return 0
	TMP=\"niwchk.\$\$\"
	cd \$DIR
	touch \$TMP >/dev/null 2>&1
	[ \$\? -ne 0 ] && return 0
	$rm \$TMP
	return 1
}


check_lsoutput () {
	TMP=\$\*
	[ -z \"\$TMP\" ] && return 0
	ISTHERE=1
	for i in \$TMP; do
		if [ \! -f \$i -a \! -h \$i ]; then
			ISTHERE=0
		fi
	done

	return \$ISTHERE
}


fatalcheck_v3 () {
	# check for notes v3 sig files in current dir
	TMP=`$ls .nts* 2>&1`
	check_lsoutput \$TMP
	if [ \$\? -ne 0 ]; then
		echo \"err\"
		echo \"$txt{'v3_exists1'}\${THISDIR}$txt{'.'}\"
		exit 1
	fi
}


check_thisv4 () {
	# check for sig files of this rev notes v4 in current dir
	TMP=`$ls .notes${rev}.dat 2>&1`
	check_lsoutput \$TMP
	if [ \$\? -ne 0 ]; then
		if [ \"\$1\" \!= \"nomsg\" ]; then
			echo \"warn\"
			echo \"$txt{'thisv4_exists1'}\${THISDIR}\"

			# message to be displayed by backend installaing notes
			echo \"bemsg\"
			echo \"$txt{'thisv4_exists_bewarn'}\"
		fi

		return 3
	else
		return 0
	fi
}


fatalcheck_otherv4 () {
	# check for sig files in the form of, but except for, the current
	TMP=`$ls .notes*.dat 2>&1`
	TMP=`echo \$TMP | $sed -e \'s/\\.notes${rev}\\.dat//\' 2>&1`
	check_lsoutput \$TMP
	if [ \$\? -ne 0 ]; then
		echo \"err\"
		echo \"$txt{'otherv4_exists'}\${THISDIR}$txt{'.'}\"

		exit 1
	fi
}


fatalcheck_any () {
	# check for any files in current dir
	TMP=`$ls -a 2>&1`
	TMP2=\"\"
	for i in \$TMP; do
		[ \$i \!= \'.\' -a \$i \!= \'..\' ] && TMP2=\"\$TMP2 \$i\"
	done
	check_lsoutput \$TMP2
	if [ \$\? -ne 0 ]; then
		echo \"err\"
		echo \"$txt{'somethingelse_exists1'}\${THISDIR}$txt{'somethingelse_exists2'}\"

		exit 1
	fi
}

OK=1
if [ -d "/opt/lotus" ]; then
	cd /opt/lotus
	TMP=`$ls .notes4*.dat 2>&1`
	check_lsoutput \$TMP
	[ \$\? -eq 0 ] && OK=0
	[ \! -f "/opt/lotus/notes/latest/$arch/server/" ] && OK=0
else 
	OK=0
fi
if [ \$OK -eq 0 ]; then
	echo \"err\"
	echo \"$txt{'nor4server1'}\"
	exit 1
fi
exit 0

	


if [ \"$insttype\" = \"fileserver\" ]; then
	# don't care about /opt/lotus for fileserver
	if [ \! -d $destpath ]; then
		exit 0
	fi
	cd $destpath
	THISDIR=$destpath

	fatalcheck_v3

	check_thisv4
	[ \$\? -eq 3 ] && THISALREADY=1

	fatalcheck_otherv4

	[ -z \"\$THISALREADY\" ] && fatalcheck_any

	[ -n \"\$THISALREADY\" ] && exit 3
	exit 0
fi


if [ \"$insttype\" = \"runable\" ]; then
	
	if [ -d /opt/lotus ]; then
		cd /opt/lotus
		THISDIR=\"/opt/lotus\"
		REALDIR_OL=`$pwd`

		fatalcheck_v3

		check_thisv4 nomsg
		[ \$\? -eq 3 ] && THISALREADY=1

		fatalcheck_otherv4

		[ -z \"\$THISALREADY\" ] && fatalcheck_any
	fi

	if [ -d $destpath ]; then
		cd $destpath
		THISDIR=\"$destpath\"
		REALDIR_DP=`$pwd`
	
		if [ \"\$REALDIR_OL\" = \$REALDIR_DP ]; then
			OLISDEST=1
			if [ -n \"\$THISALREADY\" ]; then
				check_thisv4
			fi
		else

			if [ -n \"\$THISALREADY\" ]; then
				echo \"err\"
				echo \"$txt{'thisv4_ol_exists'}\"
				exit 1
			fi

			check_thisv4
			[ \$\? -eq 3 ] && THISALREADY=1

			fatalcheck_otherv4

			[ -z \"\$THISALREADY\" ] && fatalcheck_any
		fi

	else
		if [ -n \"\$THISALREADY\" ]; then
			echo \"err\"
			echo \"$txt{'thisv4_ol_exists'}\"
			exit 1
		fi
	fi

	# check if we can create /opt/lotus (link or dir) if necessary
	#
	if [ -z \"\$OLISDEST\" ]; then
		if [ -d \"/opt\" ]; then
			check_writeable \"/opt\"
			if [ \$\? -eq 0 ]; then
				echo \"err\"
				echo \"$txt{'cant_ol1'}/opt$txt{'cant_ol2'}\"
				exit 1
			fi
		else
			check_writeable \"/\"
			if [ \$\? -eq 0 ]; then
				echo \"err\"
				echo \"$txt{'cant_ol1'}/$txt{'cant_ol2'}\"
				exit 1
			fi
		fi
	fi

	# check that we can do /opt/vim/lib/<ARCH> stuff
	#
	if [ -r \"/opt/vim/lib/$arch\" -o -h \"/opt/vim/lib/$arch\" ]; then
		check_writeable \"/opt/vim/lib\"
		if [ \$\? -ne 0 ]; then
			WARN=1
			echo \"warn\"
			echo \"$txt{'vim4'}${arch}$txt{'vim5'}\"
		else 
			echo \"err\"
			echo \"$txt{'vim4'}${arch}$txt{'vim6'}\"
			exit 1
		fi
	else
		if [ -d \"/opt/vim/lib\" ]; then
			check_writeable \"/opt/vim/lib\"
			if [ \$\? -eq 0 ]; then
				echo \"err\"
				echo \"$txt{'vim1'}${arch}$txt{'vim2'}/opt/vim/lib$txt{'vim3'}\"
				exit 1
			fi
		elif [ -d \"/opt/vim\" ]; then
			check_writeable \"/opt/vim\"
			if [ \$\? -eq 0 ]; then
				echo \"err\"
				echo \"$txt{'vim1'}${arch}$txt{'vim2'}/opt/vim$txt{'vim3'}\"
				exit 1
			fi
		fi
	fi
fi

[ -n \"\$THISALREADY\" -o -n \"\$WARN\" ] && exit 3
exit 0
EOD
}



sub Custom_PostProc {
	local( $msg_ref, $arch ) = @_;
	undef $$msg_ref;

	# return status is expected to be:
	# 0			error occured
	# 1			oki-doki no problem its cool
	# "warn"	consider the modified $$msg_ref to be a warning

	local( $out, *TMPCMD, $cmdret, $cmdout );
	local( $script );
	local( $ret ) = 1;


	$script = &GenPostProcScript($arch);

	if ( ! open( TMPCMD, ">$TmpCmd" ) ) {
		$$msg_ref = "$txt{'Unable_tmpcmd'} $TmpCmd\n";
		return 0;
	}
	print TMPCMD $script;

	while (1) { # a one-pass loop that we can drop-out and cleanup
		if ( ! close( TMPCMD ) ) {
			$$msg_ref = "$txt{'Unable_tmpcmd'} $TmpCmd\n"; 
			$ret = 0;
			last;
		}

		if ( $ENV{'NI_HOSTISLOCAL'} ) {
			$$msg_ref = `<$TmpCmd sh`;
			$ret = ( $? >> 8 );
			if ($ret == 2) {
				$ret = "warn";
			} else {
				$ret = $ret ? 0 : 1;
			}
			last;
		} else {
			if ( ! &RmtCmdfile( $ENV{'NI_HOST'}, $TmpCmd,
						\$cmdret,
						\$cmdout,
						$msg_ref ) ) {
				$ret = 0;
				last;
			}
			$$msg_ref = $cmdout;
			if ($cmdret == 2) {
				$ret = "warn";
			} else {
				$ret = $cmdret ? 0 : 1;
			}
			last;
		}

		last;
	}

	if ( ! $ENV{'NI_NODEL'} ) {
		(-f $TmpCmd ) && unlink( $TmpCmd );
	}

	return $ret;
}


sub GenPostProcScript {
	local( $arch ) = @_;

	local($cat)		= "/usr/bin/cat";
	local($chown)	= "/usr/bin/chown";
	local($chgrp)	= "/usr/bin/chgrp";
	local($expr)	= "/usr/bin/expr";
	local($ls)		= "/usr/bin/ls";

	return <<"EOD";

LISTALL=/opt/lotus/.install/iwp/4000/list.all
TESTFILE=/opt/lotus/notes/latest/$arch/server

if [ \! -r \$LISTALL ]; then
	echo \"$txt{'invlist1'} \$LISTALL\"
	exit 1
fi

if [ \! -f \$TESTFILE ]; then
	echo \"$txt{'testfile1'} \$TESTFILE\"
	exit 1
fi

lsout=`$ls -l \$TESTFILE`
user=`$expr "\$lsout" : '[^ ]*[ ]*[^ ]*[ ]*\\([^ ]*\\)'`
group=`$expr "\$lsout" : '[^ ]*[ ]*[^ ]*[ ]*[^ ]*[ ]*\\([^ ]*\\)'`

for i in `$cat \$LISTALL`; do
	file=/opt/lotus/\$i
	if [ -f \$file -o -d \$file ]; then
		 $chown \$user \$file
		 $chgrp \$group \$file
	fi
done

exit 0
EOD
}
