// Filename: MAG.CPP
// Magazine inventory program for adding and displaying
// a bookstore's magazines.
#include <iostream.h>
#include <ctype.h>
#include <stdio.h>

struct magInfo
   { char title[25];
     char pub[25];
     int month;
     int year;
     int stockCopies;
     int orderCopies;
     float price;
   };

magInfo fillMags(magInfo mag);
void printMags(magInfo mags[], int magCtr);

void main()
{
   magInfo mags[200];
   int magCtr=0;            // Number of magazine titles.
   char ans;

   do
   {                      // Assumes there is
                          // at least one magazine filled.
      mags[magCtr] = fillMags(mags[magCtr]);
      cout << "Do you want to enter another magazine? ";
      fflush(stdin);
      ans = getchar();
      fflush(stdin);           // Discards carriage return.
      if (toupper(ans) == 'Y')
        { magCtr++; }
        } while (toupper(ans) == 'Y');
      printMags(mags, magCtr);
      return;               // Returns to operating system.
}

void printMags(magInfo mags[], int magCtr)
{
   int i;
   for (i=0; i<=magCtr; i++)
     { cout << "\n\nMagazine " << (i+1) << ":\n";// Adjusts for
                                             // subscript.
       cout << "\nTitle: " << mags[i].title << "\n";
       cout << "\tPublisher: " << mags[i].pub << "\n";
       cout << "\tPub.  Month: " << mags[i].month << "\n";
       cout << "\tPub.  Year: " << mags[i].year << "\n";
       cout << "\tIn-stock: " << mags[i].stockCopies << "\n";
       cout << "\tOn order: " << mags[i].orderCopies << "\n";
       cout << "\tPrice: " << mags[i].price << "\n";
     }
   return;
}

magInfo fillMags(magInfo mag)
{
   puts("\n\nWhat is the title? ");
   gets(mag.title);
   puts("Who is the publisher? ");
   gets(mag.pub);
   puts("What is the month (1, 2, ..., 12)? ");
   cin >> mag.month;
   puts("What is the year? ");
   cin >> mag.year;
   puts("How many copies in stock? ");
   cin >> mag.stockCopies;
   puts("How many copies on order? ");
   cin >> mag.orderCopies;
   puts("How much is the magazine? ");
   cin >> mag.price;
   return (mag);
}
