// Filename: IN.CPP
// Program that builds an input string array using get().

#include <fstream.h>
void get_in_str(char str[], int len);

const int MAX=25;  // Size of character array to be typed.

void main()
{
   char input_str[MAX];   // Keyboard input fills this.
   cout << "What is your full name? ";
   get_in_str(input_str, MAX);   // String from keyboard
   cout << "After return, your name is " << input_str << "\n";
   return;
}

//**********************************************************
// The following function requires a string and the maximum
// length of the string be passed to it.  It accepts input
// from the keyboard, and sends keyboard input in the string.
// On return, the calling routine has access to the string.
//**********************************************************

void get_in_str(char str[ ], int len)
{
   int i = 0;   // index
   char input_char;   // character typed

   cin.get(input_char);   // Get next character in string.
   while (i < (len - 1) && (input_char != '\n'))
     {
       str[i] = input_char;  // Build string a character
       i++;                  // at a time.
       cin.get(input_char);  // Receive next character in string.
     }
   str[i] = '\0';   // Make the char array a string.
   return;
}

