// Filename: DSINV.CPP
// Data-entry program for a disk drive company.
#include <iostream.h>
#include <stdlib.h>
#include <iomanip.h>
#include <stdio.h>

struct inventory            // Global structure definition.
{
   long int storage;
   int accessTime;
   char vendorCode;
   float cost;
   float price;
};              // No structure variables defined globally.

void dispMenu(void);
struct inventory enterData();
void seeData(inventory disk[125], int numItems);

void main()
{
   inventory disk[125];   // Local array of structures.
   int ans;
   int numItems=0;               // Number of total items
                                       // in the inventory.

   do
     {
        do
         { dispMenu();    // Display menu of user choices.
           cin >> ans;               // Get user's request.
         } while ((ans<1) || (ans>3));

         switch (ans)
      { case (1): { disk[numItems] = enterData(); // Enter
                                                // disk data.
                 numItems++;   // Increment number of items.
                 break; }
        case (2): { seeData(disk, numItems);  // Display
                                              // disk data.
                 break; }
        default : { break; }
      }
      }  while (ans!=3);           // Quit program
                                   // when user is done.
     return;
}

void dispMenu(void)
{

   cout << "\n\n*** Disk Drive Inventory System ***\n\n";
   cout << "Do you want to:\n\n";
   cout << "\t1.  Enter new item in inventory\n\n";
   cout << "\t2.  See inventory data\n\n";
   cout << "\t3.  Exit the program\n\n";
   cout << "What is your choice? ";
   return;
}

inventory enterData()
{
   inventory diskItem;   // Local variable to fill
                                 // with input.

   cout << "\n\nWhat is the next drive's storage in bytes? ";
   cin >> diskItem.storage;
   cout << "What is the drive's access time in ms? ";
   cin >> diskItem.accessTime;
   cout << "What is the drive's vendor code (A, B, C, or D)? ";
   fflush(stdin);  // Discard input buffer
                   // before accepting character.
   diskItem.vendorCode = getchar();
   getchar();  // Discard carriage return
   cout << "What is the drive's cost? ";
   cin >> diskItem.cost;
   cout << "What is the drive's price? ";
   cin >> diskItem.price;

   return (diskItem);
}

void seeData(inventory disk[125], int numItems)
{
   int ctr;
   cout << "\n\nHere is the inventory listing:\n\n";
   for (ctr=0;ctr<numItems;ctr++)
      {
      cout << "Storage: " << disk[ctr].storage << "\t";
      cout << "Access time: " << disk[ctr].accessTime << "\n";
      cout << "Vendor code: " << disk[ctr].vendorCode << "\t";
      cout << setprecision(2);
      cout << "Cost: $" << disk[ctr].cost << "\t";
      cout << "Price: $" << disk[ctr].price << "\n";
      }
   return;
}

