Attribute VB_Name = "QuickPakDeclares"
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Prodecl.bas
'
' Copyright 1996, Crescent Division of Progress Software.
'
' Version 4.10.000
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 16/32-bit QuickPak Professional common defines and declares
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
DefLng A-Z

Global Const G_AV_MAXDIMS = 60
Global Const G_AV_USEBOUNDS = &H40                          'If TRUE verify all action is within safearray bounds.
Global Const G_AV_MAJROW = &H80                             'If TRUE use Row Major, IF FALSE (default) use Column Major.
Global Const G_AV_COLMAJ = G_AV_USEBOUNDS                   '(i,j) (i+1,j) (i+2,j) (i+3,j) (i,j+1) (i+1,j+1) (i+2,j+1) (i+3,j+1)
Global Const G_AV_ROWMAJ = G_AV_USEBOUNDS Or G_AV_MAJROW    '(i,j) (i,j+1) (i,j+2) (i,j+3) (i+1,j) (i+1,j+1) (i+1,j+2) (i+1,j+3)

Global Const G_MAX_DIR = 256                                'max. length of path component
Global Const G_MAX_DRIVE = 3                                'max. length of drive component
Global Const G_MAX_EXT = 256                                'max. length of extension component
Global Const G_MAX_FNAME = 256                              'max. length of file name component
Global Const G_MAX_PATH = 260                               'max. length of full pathname

Global Const CSSORT_CASE = True
Global Const CSSORT_NOCASE = False
Global Const CSSORT_ASCEND = 0                                          'for Sorts
Global Const CSSORT_DESCEND = -1                                'for Sorts
Global Const CSSORT_FOREWARD = 0                                        'for Searchs & Finds
Global Const CSSORT_BACKWARD = -1                                       'for Searchs & Finds

'---- SizeCode values for the various data types
Global Const SORT_STR = 0                                       'Fixed Length Strings
Global Const SORT_I2 = -1                                       'Integer
Global Const SORT_I4 = -2                                       'Long Integer
Global Const SORT_R4 = -3                                       'Single Precision
Global Const SORT_R8 = -4                                       'Double Precision
Global Const SORT_I8 = -5                                       'Currency
Global Const SORT_R4f = -6                                      'Fuzzy Single Precision
Global Const SORT_R8f = -7                                      'Fuzzy Double Precision
Global Const SORT_VAR = -8                                      'Variant
Global Const SORT_BSTR = -9                                     'Variable Length Strings in Type
Global Const SORT_HLSTRarray = -10                              'Variable Length String Array

'---- These are used by the HotKey Test/Demo
Global Const VK_NUMPAD0 = &H60
Global Const VK_NUMPAD1 = &H61
Global Const VK_NUMPAD2 = &H62
Global Const VK_NUMPAD3 = &H63
Global Const VK_NUMPAD4 = &H64
Global Const VK_NUMPAD5 = &H65
Global Const VK_NUMPAD6 = &H66
Global Const VK_NUMPAD7 = &H67
Global Const VK_NUMPAD8 = &H68
Global Const VK_NUMPAD9 = &H69

'---- Logical Font
Global Const LF_FACESIZE = 32
Global Const LF_FULLFACESIZE = 64

'---- Error Handling
Global G_QPErrorPause As Long

'---- Type structure for use with fnAV
Public Type tagAV
  PPSA    As Long
  NumDims As Long
  SCODE   As Long
  Flags   As Long
  Subscripts(1 To G_AV_MAXDIMS) As Long
End Type

'---- Type structure for use with FileInfo
Public Type tagFileInfo
  year    As Integer
  month   As Integer
  day     As Integer
  hour    As Integer
  minute  As Integer
  second  As Integer
  size    As Long
  wSizeHi As Long
  Attrib  As Long
End Type

'---- Type structure for use with KeySort
Public Type tagKeySort
  Offset    As Long
  SizeCode  As Long
  Direction As Long                                                     'BOOL but this is better for 32-bit internals
  CaseSense As Long                                                     'BOOL but this is better for 32-bit internals
End Type

'---- Type structure for use with ReadDirT
Public Type tagReadDirT
  name As String * G_MAX_DIR
End Type

'---- Type structure for use with ReadFileT
Public Type tagReadFileT
  name As String * G_MAX_FNAME
End Type

'---- Type structure for use with ReadFileX
Public Type tagReadFileX
  basename  As String * 8
  extension As String * 3
  longname  As String * G_MAX_PATH
  year      As Long
  month     As Long
  day       As Long
  hour      As Long
  minute    As Long
  second    As Long
  size      As Long
  wSizeHi   As Long
  Attrib    As Long
End Type

Public Type COLORREF
    red As Byte
    green As Byte
    blue As Byte
    reserved As Byte
End Type





Declare Sub SysFreeString Lib "OLE2DISP.DLL" (ByVal bstr As String)






'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 32-bit QuickPak Professional defines and declares
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' 32-bit constants, declares, defines

#If Win32 Then

 '---- Type structure for use with CSEnumFonts
Type TextMetric
  tmHeight           As Long
  tmAscent           As Long
  tmDescent          As Long
  tmInternalLeading  As Long
  tmExternalLeading  As Long
  tmAveCharWidth     As Long
  tmMaxCharWidth     As Long
  tmWeight           As Long
  tmOverhang         As Long
  tmDigitizedAspectX As Long
  tmDigitizedAspectY As Long
  tmFirstChar        As String * 1
  tmLastChar         As String * 1
  tmDefaultChar      As String * 1
  tmBreakChar        As String * 1
  tmItalic           As Byte
  tmUnderlined       As Byte
  tmStruckOut        As Byte
  tmPitchAndFamily   As Byte
  tmCharSet          As Byte
End Type

Type LogFont
  lfHeight           As Long
  lfWidth            As Long
  lfEscapement       As Long
  lfOrientation      As Long
  lfWeight           As Long
  lfItalic           As Byte
  lfUnderline        As Byte
  lfStrikeOut        As Byte
  lfCharSet          As Byte
  lfOutPrecision     As Byte
  lfClipPrecision    As Byte
  lfQuality          As Byte
  lfPitchAndFamily   As Byte
  lfFaceName         As String * LF_FACESIZE
End Type

'---- 32-bit Standard Windows structure... used with GenFrame
Public Type RECT
  left   As Long
  top    As Long
  right  As Long
  bottom As Long
End Type

'---- QuickPak QPRO32.DLL Functions
Public Declare Function AddIncr Lib "QPRO32.DLL" (ByVal Current As Long, ByVal AddValue As Long) As Long
Public Declare Function AddUSI Lib "QPRO32.DLL" (ByVal L1 As Long, ByVal L2 As Long) As Long
Public Declare Function AltKey Lib "QPRO32.DLL" () As Long
Public Declare Function ASCII Lib "QPRO32.DLL" (ByVal Character As String) As Long
    
Public Declare Function Bin2Num Lib "QPRO32.DLL" (ByVal Binary As String) As Long
Public Declare Function BiosSel Lib "QPRO32.DLL" (ByVal Segment As Integer) As Integer
Public Declare Function BitGet0 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitGet1 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitPack0 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long, ByVal NewBits As Long) As Long
Public Declare Function BitPack1 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long, ByVal NewBits As Long) As Long
Public Declare Function BitSet0 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long, ByVal BOOL As Long) As Long
Public Declare Function BitSet1 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long, ByVal BOOL As Long) As Long
Public Declare Function BitSetT0 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitSetT1 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitUnPack0 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long) As Long
Public Declare Function BitUnPack1 Lib "QPRO32.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long) As Long
Public Declare Function Blanks Lib "QPRO32.DLL" (ByVal Work As String) As Long
    
Public Declare Function CapsLock Lib "QPRO32.DLL" () As Long
Public Declare Function CBFindString Lib "QPRO32.DLL" (Ctl As Control, ByVal Start As Long, ByVal Search As String, ByVal bSelect As Long) As Long
Public Declare Function Compact Lib "QPRO32.DLL" (ByVal Work As String) As String
Public Declare Function Compare Lib "QPRO32.DLL" (ByVal varptrA As Long, ByVal varptrB As Long, ByVal NumBytes As Long) As Long
Public Declare Function CompareT Lib "QPRO32.DLL" (ByRef Type1 As Any, ByRef Type2 As Any, ByVal NumBytes As Long) As Long
Public Declare Function ControlHWND Lib "QPRO32.DLL" Alias "ControlHwnd" (Ctl As Control) As Long
Public Declare Function CreateAK Lib "QPRO32.DLL" (ByVal hwnd As Long) As Long
Public Declare Function CreateHK Lib "QPRO32.DLL" (ByVal VKCode As Long, ByVal Mask As Long, ByVal hwnd As Long, ByVal UserVK As Long) As Long
Public Declare Function CSEnumFonts Lib "QPRO32.DLL" (ByVal bFill As Long, ByVal hdc As Long, ByVal FaceName As String, ByRef FontType As tagAV, ByRef LogFont As tagAV, ByRef TextMetric As tagAV) As Long
Public Declare Function CSGetAttr Lib "QPRO32.DLL" (ByVal FileName As String) As Long
Public Declare Function CSMaximum Lib "QPRO32.DLL" (ByRef Value1 As Variant, ByRef Value2 As Variant) As Variant
Public Declare Function CSMinimum Lib "QPRO32.DLL" (ByRef Value1 As Variant, ByRef Value2 As Variant) As Variant
Public Declare Function CSNull Lib "QPRO32.DLL" (ByVal Work As String) As Long
Public Declare Function CtlName2Ndx Lib "QPRO32.DLL" (Ctl As Control, ByVal str As String) As Integer
Public Declare Function CtrlKey Lib "QPRO32.DLL" () As Long
Public Declare Function CVC Lib "QPRO32.DLL" (ByVal bstrCurrency As String) As Currency
Public Declare Function CVD Lib "QPRO32.DLL" (ByVal bstrDouble As String) As Double
Public Declare Function CVDMBF Lib "QPRO32.DLL" (ByVal bstrDoubleMBF As String) As Double
Public Declare Function CVI Lib "QPRO32.DLL" (ByVal bstrInt As String) As Integer
Public Declare Function CVL Lib "QPRO32.DLL" (ByVal bstrLong As String) As Long
Public Declare Function CVS Lib "QPRO32.DLL" (ByVal bstrSingle As String) As Single
Public Declare Function CVSMBF Lib "QPRO32.DLL" (ByVal bstrSingleMBF As String) As Single
    
Public Declare Function Date2Num Lib "QPRO32.DLL" (ByVal strDate As String) As Long
Public Declare Function DayName Lib "QPRO32.DLL" (ByVal enumDay As Long) As String
Public Declare Function DCount Lib "QPRO32.DLL" (ByVal DirSpec As String) As Long
Public Declare Function DiskRoom Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function DiskSize Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function DoCode2Num Lib "QPRO32.DLL" (ByVal SizeCode As Long) As Long
Public Declare Function DOSError Lib "QPRO32.DLL" () As Long
Public Declare Function DOSVer Lib "QPRO32.DLL" () As Long

Public Declare Function EDate2Num Lib "QPRO32.DLL" (ByVal strDate As String) As Long
Public Declare Function ENum2Date Lib "QPRO32.DLL" (ByVal numDate As Long) As String
Public Declare Function EnumWins Lib "QPRO32.DLL" (ByVal flag As Long, ByRef AV As tagAV) As Long
Public Declare Function ErrorMsg Lib "QPRO32.DLL" (ByVal ErrNo As Long) As String
Public Declare Function ExeName Lib "QPRO32.DLL" () As String
Public Declare Function Exist Lib "QPRO32.DLL" (ByVal FileSpec As String) As Long

Public Declare Function Factorial Lib "QPRO32.DLL" (ByVal n As Long) As Double
Public Declare Function Far2Str Lib "QPRO32.DLL" (ByVal LPZSTR As Long) As String
Public Declare Function FCount Lib "QPRO32.DLL" (ByVal FileSpec As String) As Long
Public Declare Function FEof Lib "QPRO32.DLL" (ByVal Handle As Long) As Long
Public Declare Function FileSize Lib "QPRO32.DLL" (ByVal FileName As String) As Long
Public Declare Function FindExact Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String) ' Sub
Public Declare Function FindExactB Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String) ' Sub
Public Declare Function FindLast Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long) As Long
Public Declare Function FindV Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal Search As Variant) As Long
Public Declare Function FindV2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal Search As Variant) As Long
Public Declare Function FindVB Lib "QPRO32.DLL" (Array As Variant, NumEls As Variant, Search As Variant) As Long
Public Declare Function FindVB2 Lib "QPRO32.DLL" (Array As Variant, NumEls As Variant, Search As Variant) As Long
Public Declare Function FLInput Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal BUFFER As String) As String
Public Declare Function FLoc Lib "QPRO32.DLL" (ByVal Handle As Long) As Long
Public Declare Function FLof Lib "QPRO32.DLL" (ByVal Handle As Long) As Long
Public Declare Function fnAV Lib "QPRO32.DLL" (ByRef Array() As Any, ParamArray SubScriptsVector()) As tagAV
Public Declare Function fnAVFlags Lib "QPRO32.DLL" (ByVal AVFLAGS As Long, ByRef Array() As Any, ParamArray SubScriptsVector()) As tagAV
Public Declare Function FOpen Lib "QPRO32.DLL" Alias "CSFOpen" (ByVal FileName As String, ByRef Handle As Long)             ' Sub
Public Declare Function FOpenAll Lib "QPRO32.DLL" (ByVal FileName As String, ByVal AccessMode As Long, ByVal ShareMode As Long, ByRef Handle As Long)                   ' Sub
Public Declare Function FOpenS Lib "QPRO32.DLL" (ByVal FileName As String, ByRef Handle As Long)                ' Sub
Public Declare Function Fre Lib "QPRO32.DLL" (ByVal Code As Long) As Long
Public Declare Function FUsing Lib "QPRO32.DLL" (ByVal Number As String, ByVal Image As String) As String

Public Declare Function GetBit Lib "QPRO32.DLL" (ByVal Flags As String, ByVal Element As Long) As Long
Public Declare Function GetCPU Lib "QPRO32.DLL" () As Integer
Public Declare Function GetDir Lib "QPRO32.DLL" (ByVal DriveLetter As String) As String
Public Declare Function GetDrive Lib "QPRO32.DLL" () As Long
Public Declare Function GetHResult Lib "QPRO32.DLL" () As Long
Public Declare Function GetSysDate Lib "QPRO32.DLL" (ByRef month As Integer, ByRef day As Integer, ByRef year As Integer) As Integer
Public Declare Function GetSystemResources Lib "QPRO32.DLL" () As Long
Public Declare Function GetVol Lib "QPRO32.DLL" (ByVal DriveLetter As String) As String
Public Declare Function GoodDrive Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function Hctl2Ndx Lib "QPRO32.DLL" (Ctl As Control) As Integer
Public Declare Function HiWord Lib "QPRO32.DLL" (ByVal L As Long) As Long
Public Declare Function Hwnd2Ndx Lib "QPRO32.DLL" (ByVal hwnd As Long) As Integer

Public Declare Function IMaxC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function InCount Lib "QPRO32.DLL" (ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function InCount2 Lib "QPRO32.DLL" (ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function InCountTbl Lib "QPRO32.DLL" (ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function Inp Lib "QPRO32.DLL" (ByVal port As Integer) As Byte
Public Declare Function Inp2 Lib "QPRO32.DLL" (ByVal port As Integer) As Integer
Public Declare Function InstrTbl Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTbl2 Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTblB Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTblB2 Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long

Public Declare Function LastDrive Lib "QPRO32.DLL" () As Long
Public Declare Function LBFindString Lib "QPRO32.DLL" (Ctl As Control, ByVal Start As Long, ByVal Search As String, ByVal bSelect As Long) As Long
Public Declare Function LBGetSelCount Lib "QPRO32.DLL" (Ctl As Control) As Long
Public Declare Function LBGetTopIndex Lib "QPRO32.DLL" (Ctl As Control) As Long
Public Declare Function LineCount Lib "QPRO32.DLL" (ByVal FileName As String, ByVal Buf As String) As Long
Public Declare Function LockFile Lib "QPRO32.DLL" Alias "CSLockFile" (ByVal Handle As Long, ByVal Offset As Long, ByVal Length As Long)                 ' Sub
Public Declare Function LongestStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function LongestFLen Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function LoWord Lib "QPRO32.DLL" (ByVal L As Long) As Long
Public Declare Function LpStr Lib "QPRO32.DLL" Alias "lpStr" (ByVal str As String) As Long
    
Public Declare Function MakeLong Lib "QPRO32.DLL" (ByVal LoWord As Integer, ByVal HiWord As Integer) As Long
Public Declare Function MathChip Lib "QPRO32.DLL" () As Long
Public Declare Function MaxC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Currency
Public Declare Function MaxD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Double
Public Declare Function MaxI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Integer
Public Declare Function MaxInt Lib "QPRO32.DLL" (ByVal Value1 As Integer, ByVal Value2 As Integer) As Integer
Public Declare Function MaxL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function MaxLong Lib "QPRO32.DLL" (ByVal Value1 As Long, ByVal Value2 As Long) As Long
Public Declare Function MaxS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Single
Public Declare Function MidChar Lib "QPRO32.DLL" (ByVal CharStr As String, ByVal Position As Long) As Long
Public Declare Function MinC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Currency
Public Declare Function MinD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Double
Public Declare Function MinI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Integer
Public Declare Function MinInt Lib "QPRO32.DLL" (ByVal Value1 As Integer, ByVal Value2 As Integer) As Integer
Public Declare Function MinL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function MinLong Lib "QPRO32.DLL" (ByVal Value1 As Long, ByVal Value2 As Long) As Long
Public Declare Function MinS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Single
Public Declare Function MKC Lib "QPRO32.DLL" (ByVal Num As Currency) As String
Public Declare Function MKD Lib "QPRO32.DLL" (ByVal Num As Double) As String
Public Declare Function MKDMBF Lib "QPRO32.DLL" (ByVal Num As Double) As String
Public Declare Function MKI Lib "QPRO32.DLL" (ByVal Num As Integer) As String
Public Declare Function MKL Lib "QPRO32.DLL" (ByVal Num As Long) As String
Public Declare Function MKS Lib "QPRO32.DLL" (ByVal Num As Single) As String
Public Declare Function MKSMBF Lib "QPRO32.DLL" (ByVal Num As Single) As String
Public Declare Function ModeInfo Lib "QPRO32.DLL" () As String
Public Declare Function MonthName Lib "QPRO32.DLL" (ByVal month As Long) As String

Public Declare Function Ndx2CtlName Lib "QPRO32.DLL" (Ctl As Control, ByVal Ndx As Integer) As String
Public Declare Function NotInstr Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function Num2Bin Lib "QPRO32.DLL" (ByVal Number As Long) As String
Public Declare Function Num2Bin2 Lib "QPRO32.DLL" (ByVal Number As Long) As String
Public Declare Function Num2Date Lib "QPRO32.DLL" (ByVal nDate As Long) As String
Public Declare Function Num2Day Lib "QPRO32.DLL" (ByVal nDate As Long) As Long
Public Declare Function Num2Time Lib "QPRO32.DLL" (ByVal nTime As Long) As String
Public Declare Function NumLock Lib "QPRO32.DLL" () As Long

Public Declare Function OF_ErrMsg Lib "QPRO32.DLL" (ByVal ErrNo As Long) As String

Public Declare Function ParseString Lib "QPRO32.DLL" (ByRef CurPos As Long, ByVal Work As String, ByVal DelimTableStr As String) As String
Public Declare Function Peek1 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpByte As Byte) As Long
Public Declare Function Peek2 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpWord As Integer) As Long
Public Declare Function Peek4 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpDWord As Long) As Long
Public Declare Function Play Lib "QPRO32.DLL" (ByVal Tune As String) As Long
Public Declare Function PMatch Lib "QPRO32.DLL" (ByVal Work As String) As Long
Public Declare Function Power Lib "QPRO32.DLL" (ByVal nBase As Integer, ByVal nExponent As Integer) As Long
Public Declare Function Power2 Lib "QPRO32.DLL" (ByVal n As Integer) As Long
Public Declare Function PRNReady Lib "QPRO32.DLL" (ByVal lptNo As Long) As Long
    
Public Declare Function QInstr Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstr2 Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstrB Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstrB2 Lib "QPRO32.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QPGetHwndControl Lib "QPRO32.DLL" (ByVal hwnd As Long) As Long
Public Declare Function QPHex Lib "QPRO32.DLL" (ByRef Value As Long, ByVal Digits As Long) As String
Public Declare Function QPLen Lib "QPRO32.DLL" (ByVal Work As String) As Long
Public Declare Function QPLTrim Lib "QPRO32.DLL" () As String
Public Declare Function QPRTrim Lib "QPRO32.DLL" (ByVal Work As String) As String
Public Declare Function QPSegAdr Lib "QPRO32.DLL" (ByRef Data As Any) As Long
Public Declare Function QPTrim Lib "QPRO32.DLL" (ByVal Work As String) As String
Public Declare Function QPUSI Lib "QPRO32.DLL" (ByVal i As Long) As Long
Public Declare Function QPWeekDay Lib "QPRO32.DLL" (ByVal strDate As String) As Long

Public Declare Function ReadTest Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function Removable Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function Sadd Lib "QPRO32.DLL" (ByVal Variable As String) As Long
Public Declare Function ScrollLock Lib "QPRO32.DLL" () As Long
Public Declare Function ScrolLock Lib "QPRO32.DLL" () As Long
Public Declare Function Search Lib "QPRO32.DLL" (ByRef Anum As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByRef Found As Long, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal SizeCode As Long) As Long
Public Declare Function SearchT Lib "QPRO32.DLL" (ByRef Audt As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal ElSize As Long, ByVal MemberOff As Long, ByVal MemberSize As Long) As Long
Public Declare Function SearchT2 Lib "QPRO32.DLL" (ByRef Audt As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal ElSize As Long, ByVal MemberOff As Long, ByVal MemberSize As Long) As Long
Public Declare Function SendCtrlMsg Lib "QPRO32.DLL" (Ctl As Control, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function SerError Lib "QPRO32.DLL" (ByVal ErrNo As Long) ' Sub
Public Declare Function ShiftIL Lib "QPRO32.DLL" (ByVal Value As Integer, ByVal Shift As Long) As Integer
Public Declare Function ShiftIR Lib "QPRO32.DLL" (ByVal Value As Integer, ByVal Shift As Long) As Integer
Public Declare Function ShiftKey Lib "QPRO32.DLL" () As Long
Public Declare Function ShiftLL Lib "QPRO32.DLL" (ByVal Value As Long, ByVal Shift As Long) As Long
Public Declare Function ShiftLR Lib "QPRO32.DLL" (ByVal Value As Long, ByVal Shift As Long) As Long
Public Declare Function Sound Lib "QPRO32.DLL" (ByVal Frequency As Long, ByVal Duration As Long) As Long
Public Declare Function Soundex Lib "QPRO32.DLL" (ByVal text As String) As String
Public Declare Function SPropOff Lib "QPRO32.DLL" (Ctl As Control, ByVal usIProp As Long) As Integer
Public Declare Function SysDir Lib "QPRO32.DLL" () As String
    
Public Declare Function Time2Num Lib "QPRO32.DLL" (ByVal strTime As String) As Long
Public Declare Function Times2 Lib "QPRO32.DLL" (ByVal L As Long) As Long
Public Declare Function Trapint Lib "QPRO32.DLL" (ByVal L As Long, ByVal Lo As Long, ByVal Hi As Long) As Long
Public Declare Function TrimZStr Lib "QPRO32.DLL" (ByVal Work As String) As String

Public Declare Function UnLockFile Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Offset As Long, ByVal Length As Long)                  ' Sub

Public Declare Function Valid Lib "QPRO32.DLL" (ByVal FileName As String) As Long
Public Declare Function VarPtr Lib "QPRO32.DLL" (ByRef Variable As Any) As Long
Public Declare Function VarPtr32 Lib "QPRO32.DLL" Alias "Near32" () As Long
Public Declare Function VarSeg Lib "QPRO32.DLL" (ByRef Variable As Any) As Long

Public Declare Function WhichError Lib "QPRO32.DLL" () As Long
Public Declare Function WinDir Lib "QPRO32.DLL" () As String
Public Declare Function WinVer Lib "QPRO32.DLL" () As Long
Public Declare Function WriteTest Lib "QPRO32.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function XDialog2Pixel Lib "QPRO32.DLL" (ByVal xDialog As Long) As Long
Public Declare Function XDialog2Twp Lib "QPRO32.DLL" (ByVal xDialog As Long) As Long
Public Declare Function XPixel2Dialog Lib "QPRO32.DLL" (ByVal xPixel As Long) As Long
Public Declare Function XPixel2Twp Lib "QPRO32.DLL" (ByVal xPixel As Long) As Long
Public Declare Function XTwp2Dialog Lib "QPRO32.DLL" (ByVal xTwip As Long) As Long
Public Declare Function XTwp2Pixel Lib "QPRO32.DLL" (ByVal Twip As Long) As Long

Public Declare Function YDialog2Pixel Lib "QPRO32.DLL" (ByVal yDialog As Long) As Long
Public Declare Function YDialog2Twp Lib "QPRO32.DLL" (ByVal yDialog As Long) As Long
Public Declare Function YPixel2Dialog Lib "QPRO32.DLL" (ByVal yPixel As Long) As Long
Public Declare Function YPixel2Twp Lib "QPRO32.DLL" (ByVal yPixel As Long) As Long
Public Declare Function YTwp2Dialog Lib "QPRO32.DLL" (ByVal yTwip As Long) As Long
Public Declare Function YTwp2Pixel Lib "QPRO32.DLL" (ByVal Twip As Long) As Long
    
'---- QuickPak Subroutines
Public Declare Sub AddInt Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal Value As Integer, ByVal NumEls As Long)
Public Declare Sub AddLong Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal Value As Long, ByVal NumEls As Long)
Public Declare Sub AllKeyExit Lib "QPRO32.DLL" ()
Public Declare Sub Array2CB Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub Array2List Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub ArrayISortNum Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal MemberSize As Long) ' Sub
Public Declare Sub ArrayISortStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)              ' Sub
Public Declare Sub ArrayISortTyp Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArrayISortVar Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortNum Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal MbrSiz As Long)
Public Declare Sub ArraySortStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortTyp Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortVar Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
    
Public Declare Sub BCopy Lib "QPRO32.DLL" (ByRef UdtSource As Any, ByRef UDTDest As Any, ByVal NumBytes As Long, ByVal bDirection As Long)
Public Declare Sub BCopyT Lib "QPRO32.DLL" (ByRef UdtSource As Any, ByRef UDTDest As Any, ByVal ElSize As Long, ByVal NumEls As Long)
    
Public Declare Sub CapsOff Lib "QPRO32.DLL" ()
Public Declare Sub CapsOn Lib "QPRO32.DLL" ()
Public Declare Sub CB2Array Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub CB2File Lib "QPRO32.DLL" (Ctl As Control, ByVal FileName As String, ByVal bAppend As Long)
Public Declare Sub CBResetContent Lib "QPRO32.DLL" (Ctl As Control)
Public Declare Sub CDir Lib "QPRO32.DLL" (ByVal NewDir As String)
Public Declare Sub ClipFile Lib "QPRO32.DLL" (ByVal FileName As String, ByVal NewLength As Long)
Public Declare Sub CSSetAttr Lib "QPRO32.DLL" (ByVal FileName As String, ByVal attr As Long)
Public Declare Sub CtlFrame Lib "QPRO32.DLL" (ByVal ControlHWND As Long, ByVal FrameEffect As Long, ByVal SunColor As Long, ByVal ShadowColor As Long, ByVal BorderWidth As Long, ByVal BorderStyle As Long)
    
Public Declare Sub DeleteStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub DeleteT Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub DiskInfo Lib "QPRO32.DLL" (ByVal DriveLetter As String, ByRef BytesPerSector As Long, ByRef SectorsPerCluster As Long, ByRef FreeClusters As Long, ByRef TotalClusters As Long)

Public Declare Sub Encrypt Lib "QPRO32.DLL" (ByVal Work As String, ByVal Password As String)
Public Declare Sub Encrypt2 Lib "QPRO32.DLL" (ByVal Work As String, ByVal Password As String)
Public Declare Sub FClose Lib "QPRO32.DLL" (ByVal Handle As Long)
Public Declare Sub FCopy Lib "QPRO32.DLL" (ByVal Sfile As String, ByVal Dfile As String, ByRef ErrCode As Long)
Public Declare Sub FCreate Lib "QPRO32.DLL" (ByVal FileName As String)
Public Declare Sub FFlush Lib "QPRO32.DLL" (ByVal Handle As Long)
Public Declare Sub FGet Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Destination As String)
Public Declare Sub FGetA Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub FGetAH Lib "QPRO32.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Function FGetR Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Destination As String, ByVal RecNum As Long) As String
Public Declare Sub FGetRT Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal RecNum As Long, ByVal NumBytes As Long)
Public Declare Sub FGetRTA Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal RecNum As Long, ByVal NumBytes As Long, ByVal NumRecs As Long)
Public Declare Sub FGetT Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal NumBytes As Long)
Public Declare Sub File2CB Lib "QPRO32.DLL" (Ctl As Control, ByVal FileName As String)
Public Declare Sub File2List Lib "QPRO32.DLL" (Ctl As Control, ByVal FileName As String)
Public Declare Sub FileInfo Lib "QPRO32.DLL" (ByVal FileName As String, ByRef TypeVar As tagFileInfo)
Public Declare Sub Fill2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Fill4 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Fill8 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Find Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub Find2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindB Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindB2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindT Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindT2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindTB Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindTB2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FloppyType Lib "QPRO32.DLL" (ByRef FloppyA As Long, ByRef FloppyB As Long)
Public Declare Sub FPut Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Source As String)
Public Declare Sub FPutA Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub FPutAH Lib "QPRO32.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub FPutR Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Source As String, ByVal RecNum As Long)
Public Declare Sub FPutRT Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal RecNum As Long, ByVal RecSize As Long)
Public Declare Sub FPutRTA Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal RecNum As Long, ByVal RecSize As Long, ByVal NumRecs As Long)
Public Declare Sub FPutT Lib "QPRO32.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal NumBytes As Long)
Public Declare Sub FSeek Lib "QPRO32.DLL" (ByVal Handle As Long, ByVal Location As Long)
Public Declare Sub FStamp Lib "QPRO32.DLL" (ByVal FileName As String, ByVal NewTime As String, ByVal NewDate As String)

Public Declare Sub GenFrame Lib "QPRO32.DLL" (ByRef lpRect As RECT, ByVal hdc As Long, ByVal wstyle As Long, ByVal SunColor As Long, ByVal shadow As Long, ByVal BorderWidth As Long, ByVal FrameStyle As Long)                 ' Sub
Public Declare Sub GetEquip Lib "QPRO32.DLL" (ByRef Floppies As Integer, ByRef Parallels As Integer, ByRef Serials As Integer)
Public Declare Sub GetEquip2 Lib "QPRO32.DLL" (ByRef Floppies As Integer, ByRef Parallels As Integer, ByRef Serials As Integer)

Public Declare Sub HotKeyExit Lib "QPRO32.DLL" ()

Public Declare Sub InitIndex Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub InitInt Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal StartValue As Integer, ByVal NumEls As Long)
Public Declare Sub InitLong Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal StartValue As Long, ByVal NumEls As Long)
Public Declare Sub InsertStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef InsStr As String, ByVal NumEls As Long)
Public Declare Sub InsertT Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub ISortC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortStr2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortT Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long)
Public Declare Sub ISortT2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long)
Public Declare Sub ISortV Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortV2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)

Public Declare Sub KeySort Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByRef KeyInfoArray As tagAV, ByVal NumKeys As Long)
Public Declare Sub KillAK Lib "QPRO32.DLL" (ByVal hwnd As Long)
Public Declare Sub KillDir Lib "QPRO32.DLL" (ByVal DirName As String)
Public Declare Sub KillFile Lib "QPRO32.DLL" (ByVal FileName As String)
Public Declare Sub KillHK Lib "QPRO32.DLL" (ByVal hwnd As Long)

Public Declare Sub LBGetSelection Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub LBResetContent Lib "QPRO32.DLL" (Ctl As Control)
Public Declare Sub LBSetTabStops Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub List2Array Lib "QPRO32.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub List2File Lib "QPRO32.DLL" (Ctl As Control, ByVal FileName As String, ByVal bAppend As Long)
Public Declare Sub LowAscii Lib "QPRO32.DLL" (ByVal Work As String)
Public Declare Sub Lower Lib "QPRO32.DLL" (ByVal Work As String)
Public Declare Sub LowerTbl Lib "QPRO32.DLL" (ByVal Work As String, ByVal CharTable As String)
    
Public Declare Sub MakeDir Lib "QPRO32.DLL" (ByVal DirName As String)
Public Declare Sub MonoPrint Lib "QPRO32.DLL" (ByVal str As String, ByVal row As Long, ByVal column As Long, ByVal attr As Long)

Public Declare Sub NameDir Lib "QPRO32.DLL" (ByVal OlsName As String, ByVal NewName As String)
Public Declare Sub NameFile Lib "QPRO32.DLL" (ByVal OlsName As String, ByVal NewName As String)
Public Declare Sub NumOff Lib "QPRO32.DLL" ()
Public Declare Sub NumOn Lib "QPRO32.DLL" ()

Public Declare Sub Open255 Lib "QPRO32.DLL" (ByVal NumFiles As Long)
Public Declare Sub Out Lib "QPRO32.DLL" (ByVal port As Integer, ByVal byteval As Byte)
Public Declare Sub Out2 Lib "QPRO32.DLL" (ByVal port As Integer, ByVal byteval As Byte)

Public Declare Sub Poke1 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpByte As Long, ByVal I1 As Byte)
Public Declare Sub Poke2 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpWord As Long, ByVal i2 As Integer)
Public Declare Sub Poke4 Lib "QPRO32.DLL" (ByVal Segment As Integer, ByVal lpDWord As Long, ByVal i4 As Long)
Public Declare Sub ProperName Lib "QPRO32.DLL" (ByVal Work As String)
Public Declare Sub PutVol Lib "QPRO32.DLL" (ByVal DriveLetter As String, ByVal VolLabel As String)

Public Declare Sub QBLoad Lib "QPRO32.DLL" (ByVal FileName As String, ByRef AV As tagAV)
Public Declare Sub QBSave Lib "QPRO32.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub QProVer Lib "QPRO32.DLL" ()

Public Declare Sub ReadDir Lib "QPRO32.DLL" (ByRef AV As tagAV)
Public Declare Sub ReadDirT Lib "QPRO32.DLL" (ByVal DirSpec As String, ByRef AV As tagAV)
Public Declare Sub ReadFile Lib "QPRO32.DLL" Alias "CSReadFile" (ByRef AV As tagAV)
Public Declare Sub ReadFileI Lib "QPRO32.DLL" (ByRef AV As tagAV)
Public Declare Sub ReadFileT Lib "QPRO32.DLL" (ByVal FileSpec As String, ByRef AV As tagAV)
Public Declare Sub ReadFileX Lib "QPRO32.DLL" (ByVal FileSpec As String, ByRef DirSize As Long, ByRef tagReadFileX As tagAV)
Public Declare Sub RemCtrl Lib "QPRO32.DLL" (ByVal Work As String, ByVal CharNew As String)
Public Declare Sub ReplaceChar Lib "QPRO32.DLL" (ByVal CharStr As String, ByVal CharOld As String, ByVal CharNew As String)
Public Declare Sub ReplaceChar2 Lib "QPRO32.DLL" (ByVal CharStr As String, ByVal CharOld As String, ByVal CharNew As String)

Public Declare Sub ScrollOff Lib "QPRO32.DLL" ()
Public Declare Sub ScrollOn Lib "QPRO32.DLL" ()
Public Declare Sub Sequence Lib "QPRO32.DLL" (ByVal Work As String)
Public Declare Sub SetBit Lib "QPRO32.DLL" (ByVal Flags As String, ByVal Element As Long, ByVal BOOL As Long)
Public Declare Sub SetDrive Lib "QPRO32.DLL" (ByVal DriveLetter As String)
Public Declare Sub SetError Lib "QPRO32.DLL" (ByVal ErrorNumber As Long)
Public Declare Sub SortC Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortD Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortI Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortL Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortS Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortStr Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortStr2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortT Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long) ' Sub
Public Declare Sub SortT2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long) ' Sub
Public Declare Sub SortV Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortV2 Lib "QPRO32.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SplitColor Lib "QPRO32.DLL" (ByRef red As Byte, ByRef green As Byte, ByRef blue As Byte, ByVal RGB As Long)
Public Declare Sub Swap Lib "QPRO32.DLL" (ByRef A As Any, ByRef B As Any, ByVal NumBytes As Long)
Public Declare Sub SysTime Lib "QPRO32.DLL" (ByRef strTime As String)

Public Declare Sub Translate Lib "QPRO32.DLL" (ByVal Work As String)

Public Declare Sub Upper Lib "QPRO32.DLL" (ByVal Work As String)
Public Declare Sub UpperTbl Lib "QPRO32.DLL" (ByVal Work As String, ByVal CharTable As String)

#Else

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' 16-bit QuickPak Professional defines and declares
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'---- 16-bit type structure for use with CSEnumFonts
Type TextMetric
  tmHeight           As Integer
  tmAscent           As Integer
  tmDescent          As Integer
  tmInternalLeading  As Integer
  tmExternalLeading  As Integer
  tmAveCharWidth     As Integer
  tmMaxCharWidth     As Integer
  tmWeight           As Integer
  tmOverhang         As Integer
  tmDigitizedAspectX As Integer
  tmDigitizedAspectY As Integer
  tmFirstChar        As String * 1
  tmLastChar         As String * 1
  tmDefaultChar      As String * 1
  tmBreakChar        As String * 1
  tmItalic           As Byte
  tmUnderlined       As Byte
  tmStruckOut        As Byte
  tmPitchAndFamily   As Byte
  tmCharSet          As Byte
End Type

Type LogFont
  lfHeight           As Integer
  lfWidth            As Integer
  lfEscapement       As Integer
  lfOrientation      As Integer
  lfWeight           As Integer
  lfItalic           As Byte
  lfUnderline        As Byte
  lfStrikeOut        As Byte
  lfCharSet          As Byte
  lfOutPrecision     As Byte
  lfClipPrecision    As Byte
  lfQuality          As Byte
  lfPitchAndFamily   As Byte
  lfFaceName         As String * LF_FACESIZE
End Type

'---- 16-bit Standard Windows structure... used with GenFrame
Public Type RECT
  left   As Integer
  top    As Integer
  right  As Integer
  bottom As Integer
End Type

'---- QuickPak 16-bit Functions
Public Declare Function AddIncr Lib "QPRO16.DLL" (ByVal Current As Long, ByVal AddValue As Long) As Long
Public Declare Function AddUSI Lib "QPRO16.DLL" (ByVal L1 As Long, ByVal L2 As Long) As Long
Public Declare Function AltKey Lib "QPRO16.DLL" () As Long
Public Declare Function AppName Lib "QPRO16.DLL" () As String
Public Declare Function ASCII Lib "QPRO16.DLL" (ByVal Character As String) As Long
    
Public Declare Function Bin2Num Lib "QPRO16.DLL" (ByVal Binary As String) As Long
Public Declare Function BiosSel Lib "QPRO16.DLL" (ByVal Segment As Integer) As Integer
Public Declare Function BitGet0 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitGet1 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitPack0 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long, ByVal NewBits As Long) As Long
Public Declare Function BitPack1 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long, ByVal NewBits As Long) As Long
Public Declare Function BitSet0 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long, ByVal BOOL As Long) As Long
Public Declare Function BitSet1 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long, ByVal BOOL As Long) As Long
Public Declare Function BitSetT0 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitSetT1 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal Bit As Long) As Long
Public Declare Function BitUnPack0 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long) As Long
Public Declare Function BitUnPack1 Lib "QPRO16.DLL" (ByRef Flags As Any, ByVal StartBit As Long, ByVal NumBits As Long) As Long
Public Declare Function Blanks Lib "QPRO16.DLL" (ByVal Work As String) As Long
    
Public Declare Function CapsLock Lib "QPRO16.DLL" () As Long
Public Declare Function CBFindString Lib "QPRO16.DLL" (Ctl As Control, ByVal Start As Long, ByVal Search As String, ByVal bSelect As Long) As Long
Public Declare Function Compact Lib "QPRO16.DLL" (ByVal Work As String) As String
Public Declare Function Compare Lib "QPRO16.DLL" (ByVal varptrA As Long, ByVal varptrB As Long, ByVal NumBytes As Long) As Long
Public Declare Function CompareT Lib "QPRO16.DLL" (ByRef Type1 As Any, ByRef Type2 As Any, ByVal NumBytes As Long) As Long
Public Declare Function ControlHWND Lib "QPRO16.DLL" Alias "ControlHwnd" (Ctl As Control) As Long
Public Declare Function CreateAK Lib "QPRO16.DLL" (ByVal hwnd As Long) As Long
Public Declare Function CreateHK Lib "QPRO16.DLL" (ByVal VKCode As Long, ByVal Mask As Long, ByVal hwnd As Long, ByVal UserVK As Long) As Long
Public Declare Function CSEnumFonts Lib "QPRO16.DLL" (ByVal bFill As Long, ByVal hdc As Integer, ByVal FaceName As String, ByRef FontType As tagAV, ByRef LogFont As tagAV, ByRef TextMetric As tagAV) As Long
Public Declare Function CSGetAttr Lib "QPRO16.DLL" (ByVal FileName As String) As Long
Public Declare Function CSMaximum Lib "QPRO16.DLL" (ByRef Value1 As Variant, ByRef Value2 As Variant) As Variant
Public Declare Function CSMinimum Lib "QPRO16.DLL" (ByRef Value1 As Variant, ByRef Value2 As Variant) As Variant
Public Declare Function CSNull Lib "QPRO16.DLL" (ByVal Work As String) As Long
Public Declare Function CtlName2Ndx Lib "QPRO16.DLL" (Ctl As Control, ByVal str As String) As Integer
Public Declare Function CtrlKey Lib "QPRO16.DLL" () As Long
Public Declare Function CVC Lib "QPRO16.DLL" (ByVal bstrCurrency As String) As Currency
Public Declare Function CVD Lib "QPRO16.DLL" (ByVal bstrDouble As String) As Double
Public Declare Function CVDMBF Lib "QPRO16.DLL" (ByVal bstrDoubleMBF As String) As Double
Public Declare Function CVI Lib "QPRO16.DLL" (ByVal bstrInt As String) As Integer
Public Declare Function CVL Lib "QPRO16.DLL" (ByVal bstrLong As String) As Long
Public Declare Function CVS Lib "QPRO16.DLL" (ByVal bstrSingle As String) As Single
Public Declare Function CVSMBF Lib "QPRO16.DLL" (ByVal bstrSingleMBF As String) As Single
    
Public Declare Function Date2Num Lib "QPRO16.DLL" (ByVal strDate As String) As Long
Public Declare Function DayName Lib "QPRO16.DLL" (ByVal enumDay As Long) As String
Public Declare Function DCount Lib "QPRO16.DLL" (ByVal DirSpec As String) As Long
Public Declare Function DiskRoom Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function DiskSize Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function DoCode2Num Lib "QPRO16.DLL" (ByVal SizeCode As Long) As Long
Public Declare Function DOSError Lib "QPRO16.DLL" () As Long
Public Declare Function DOSVer Lib "QPRO16.DLL" () As Long

Public Declare Function EDate2Num Lib "QPRO16.DLL" (ByVal strDate As String) As Long
Public Declare Function ENum2Date Lib "QPRO16.DLL" (ByVal numDate As Long) As String
Public Declare Function EnumWins Lib "QPRO16.DLL" (ByVal flag As Long, ByRef AV As tagAV) As Long
Public Declare Function ErrorMsg Lib "QPRO16.DLL" (ByVal ErrNo As Long) As String
Public Declare Function ExeName Lib "QPRO16.DLL" () As String
Public Declare Function Exist Lib "QPRO16.DLL" (ByVal FileSpec As String) As Long

Public Declare Function Factorial Lib "QPRO16.DLL" (ByVal n As Long) As Double
Public Declare Function Far2Str Lib "QPRO16.DLL" (ByVal LPZSTR As Long) As String
Public Declare Function FCount Lib "QPRO16.DLL" (ByVal FileSpec As String) As Long
Public Declare Function FEof Lib "QPRO16.DLL" (ByVal Handle As Long) As Long
Public Declare Function FileSize Lib "QPRO16.DLL" (ByVal FileName As String) As Long
Public Declare Function FindExact Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String) ' Sub
Public Declare Function FindExactB Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String) ' Sub
Public Declare Function FindLast Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long) As Long
Public Declare Function FindV Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal Search As Variant) As Long
Public Declare Function FindV2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal Search As Variant) As Long
Public Declare Function FindVB Lib "QPRO16.DLL" (Array As Variant, NumEls As Variant, Search As Variant) As Long
Public Declare Function FindVB2 Lib "QPRO16.DLL" (Array As Variant, NumEls As Variant, Search As Variant) As Long
Public Declare Function FLInput Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal BUFFER As String) As String
Public Declare Function FLoc Lib "QPRO16.DLL" (ByVal Handle As Long) As Long
Public Declare Function FLof Lib "QPRO16.DLL" (ByVal Handle As Long) As Long
Public Declare Function fnAV Lib "QPRO16.DLL" (ByRef Array() As Any, ParamArray SubScriptsVector()) As tagAV
Public Declare Function fnAVFlags Lib "QPRO16.DLL" (ByVal AVFLAGS As Long, ByRef Array() As Any, ParamArray SubScriptsVector()) As tagAV
Public Declare Function FOpen Lib "QPRO16.DLL" Alias "CSFOpen" (ByVal FileName As String, ByRef Handle As Long)             ' Sub
Public Declare Function FOpenAll Lib "QPRO16.DLL" (ByVal FileName As String, ByVal AccessMode As Long, ByVal ShareMode As Long, ByRef Handle As Long)                   ' Sub
Public Declare Function FOpenS Lib "QPRO16.DLL" (ByVal FileName As String, ByRef Handle As Long)                ' Sub
Public Declare Function Fre Lib "QPRO16.DLL" (ByVal Code As Long) As Long
Public Declare Function FUsing Lib "QPRO16.DLL" (ByVal Number As String, ByVal Image As String) As String

Public Declare Function GetBit Lib "QPRO16.DLL" (ByVal Flags As String, ByVal Element As Long) As Long
Public Declare Function GetCPU Lib "QPRO16.DLL" () As Integer
Public Declare Function GetDir Lib "QPRO16.DLL" (ByVal DriveLetter As String) As String
Public Declare Function GetDrive Lib "QPRO16.DLL" () As Long
Public Declare Function GetHResult Lib "QPRO16.DLL" () As Long
Public Declare Function GetSysDate Lib "QPRO16.DLL" (ByRef month As Integer, ByRef day As Integer, ByRef year As Integer) As Integer
Public Declare Function GetSystemResources Lib "QPRO16.DLL" () As Long
Public Declare Function GetVol Lib "QPRO16.DLL" (ByVal DriveLetter As String) As String
Public Declare Function GoodDrive Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function Hctl2Ndx Lib "QPRO16.DLL" (Ctl As Control) As Integer
Public Declare Function HiWord Lib "QPRO16.DLL" (ByVal L As Long) As Long
Public Declare Function Hwnd2Ndx Lib "QPRO16.DLL" (ByVal hwnd As Long) As Integer

Public Declare Function IMaxC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMaxS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function IMinS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function InCount Lib "QPRO16.DLL" (ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function InCount2 Lib "QPRO16.DLL" (ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function InCountTbl Lib "QPRO16.DLL" (ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function Inp Lib "QPRO16.DLL" (ByVal port As Integer) As Byte
Public Declare Function Inp2 Lib "QPRO16.DLL" (ByVal port As Integer) As Integer
Public Declare Function InstrTbl Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTbl2 Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTblB Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function InstrTblB2 Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long

Public Declare Function LastDrive Lib "QPRO16.DLL" () As Long
Public Declare Function LBFindString Lib "QPRO16.DLL" (Ctl As Control, ByVal Start As Long, ByVal Search As String, ByVal bSelect As Long) As Long
Public Declare Function LBGetSelCount Lib "QPRO16.DLL" (Ctl As Control) As Long
Public Declare Function LBGetTopIndex Lib "QPRO16.DLL" (Ctl As Control) As Long
Public Declare Function LineCount Lib "QPRO16.DLL" (ByVal FileName As String, ByVal Buf As String) As Long
Public Declare Function LockFile Lib "QPRO16.DLL" Alias "CSLockFile" (ByVal Handle As Long, ByVal Offset As Long, ByVal Length As Long)                 ' Sub
Public Declare Function LongestStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function LongestFLen Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function LoWord Lib "QPRO16.DLL" (ByVal L As Long) As Long
Public Declare Function LpStr Lib "QPRO16.DLL" (ByVal str As String) As Long
    
Public Declare Function MakeLong Lib "QPRO16.DLL" (ByVal LoWord As Integer, ByVal HiWord As Integer) As Long
Public Declare Function MathChip Lib "QPRO16.DLL" () As Long
Public Declare Function MaxC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Currency
Public Declare Function MaxD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Double
Public Declare Function MaxI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Integer
Public Declare Function MaxInt Lib "QPRO16.DLL" (ByVal Value1 As Integer, ByVal Value2 As Integer) As Integer
Public Declare Function MaxL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function MaxLong Lib "QPRO16.DLL" (ByVal Value1 As Long, ByVal Value2 As Long) As Long
Public Declare Function MaxS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Single
Public Declare Function MidChar Lib "QPRO16.DLL" (ByVal CharStr As String, ByVal Position As Long) As Long
Public Declare Function MinC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Currency
Public Declare Function MinD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Double
Public Declare Function MinI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Integer
Public Declare Function MinInt Lib "QPRO16.DLL" (ByVal Value1 As Integer, ByVal Value2 As Integer) As Integer
Public Declare Function MinL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Long
Public Declare Function MinLong Lib "QPRO16.DLL" (ByVal Value1 As Long, ByVal Value2 As Long) As Long
Public Declare Function MinS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long) As Single
Public Declare Function MKC Lib "QPRO16.DLL" (ByVal Num As Currency) As String
Public Declare Function MKD Lib "QPRO16.DLL" (ByVal Num As Double) As String
Public Declare Function MKDMBF Lib "QPRO16.DLL" (ByVal Num As Double) As String
Public Declare Function MKI Lib "QPRO16.DLL" (ByVal Num As Integer) As String
Public Declare Function MKL Lib "QPRO16.DLL" (ByVal Num As Long) As String
Public Declare Function MKS Lib "QPRO16.DLL" (ByVal Num As Single) As String
Public Declare Function MKSMBF Lib "QPRO16.DLL" (ByVal Num As Single) As String
Public Declare Function ModeInfo Lib "QPRO16.DLL" () As String
Public Declare Function MonthName Lib "QPRO16.DLL" (ByVal month As Long) As String

Public Declare Function Ndx2CtlName Lib "QPRO16.DLL" (Ctl As Control, ByVal Ndx As Integer) As String
Public Declare Function NetDrive Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function NetName Lib "QPRO16.DLL" () As String
Public Declare Function NetType Lib "QPRO16.DLL" () As Long
Public Declare Function NetTypeName Lib "QPRO16.DLL" () As String
Public Declare Function NotInstr Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal TableStr As String) As Long
Public Declare Function Num2Bin Lib "QPRO16.DLL" (ByVal Number As Long) As String
Public Declare Function Num2Bin2 Lib "QPRO16.DLL" (ByVal Number As Long) As String
Public Declare Function Num2Date Lib "QPRO16.DLL" (ByVal nDate As Long) As String
Public Declare Function Num2Day Lib "QPRO16.DLL" (ByVal nDate As Long) As Long
Public Declare Function Num2Time Lib "QPRO16.DLL" (ByVal nTime As Long) As String
Public Declare Function NumLock Lib "QPRO16.DLL" () As Long

Public Declare Function OF_ErrMsg Lib "QPRO16.DLL" (ByVal ErrNo As Long) As String

Public Declare Function ParseString Lib "QPRO16.DLL" (ByRef CurPos As Long, ByVal Work As String, ByVal DelimTableStr As String) As String
Public Declare Function Peek1 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpByte As Byte) As Long
Public Declare Function Peek2 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpWord As Integer) As Long
Public Declare Function Peek4 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpDWord As Long) As Long
Public Declare Function Play Lib "QPRO16.DLL" (ByVal Tune As String) As Long
Public Declare Function PMatch Lib "QPRO16.DLL" (ByVal Work As String) As Long
Public Declare Function Power Lib "QPRO16.DLL" (ByVal nBase As Integer, ByVal nExponent As Integer) As Long
Public Declare Function Power2 Lib "QPRO16.DLL" (ByVal n As Integer) As Long
Public Declare Function PRNReady Lib "QPRO16.DLL" (ByVal lptNo As Long) As Long
    
Public Declare Function QInstr Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstr2 Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstrB Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QInstrB2 Lib "QPRO16.DLL" (ByVal Start As Long, ByVal Work As String, ByVal SubStr As String) As Long
Public Declare Function QPGetHwndControl Lib "QPRO16.DLL" (ByVal hwnd As Long) As Long
Public Declare Function QPHex Lib "QPRO16.DLL" (ByRef Value As Long, ByVal Digits As Long) As String
Public Declare Function QPLen Lib "QPRO16.DLL" (ByVal Work As String) As Long
Public Declare Function QPLTrim Lib "QPRO16.DLL" () As String
Public Declare Function QPRTrim Lib "QPRO16.DLL" (ByVal Work As String) As String
Public Declare Function QPSegAdr Lib "QPRO16.DLL" (ByRef Data As Any) As Long
Public Declare Function QPTrim Lib "QPRO16.DLL" (ByVal Work As String) As String
Public Declare Function QPUSI Lib "QPRO16.DLL" (ByVal i As Long) As Long
Public Declare Function QPWeekDay Lib "QPRO16.DLL" (ByVal strDate As String) As Long

Public Declare Function ReadTest Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long
Public Declare Function Removable Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function Sadd Lib "QPRO16.DLL" (ByVal Variable As String) As Long
Public Declare Function ScrollLock Lib "QPRO16.DLL" () As Long
Public Declare Function ScrolLock Lib "QPRO16.DLL" () As Long
Public Declare Function Search Lib "QPRO16.DLL" (ByRef Anum As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByRef Found As Long, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal SizeCode As Long) As Long
Public Declare Function SearchT Lib "QPRO16.DLL" (ByRef Audt As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal ElSize As Long, ByVal MemberOff As Long, ByVal MemberSize As Long) As Long
Public Declare Function SearchT2 Lib "QPRO16.DLL" (ByRef Audt As tagAV, ByVal NumEls As Long, ByRef Match As Any, ByVal bDirection As Long, ByVal MatchCode As Long, ByVal ElSize As Long, ByVal MemberOff As Long, ByVal MemberSize As Long) As Long
Public Declare Function SendCtrlMsg Lib "QPRO16.DLL" (Ctl As Control, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Public Declare Function SerError Lib "QPRO16.DLL" (ByVal ErrNo As Long) ' Sub
Public Declare Function ShiftIL Lib "QPRO16.DLL" (ByVal Value As Integer, ByVal Shift As Long) As Integer
Public Declare Function ShiftIR Lib "QPRO16.DLL" (ByVal Value As Integer, ByVal Shift As Long) As Integer
Public Declare Function ShiftKey Lib "QPRO16.DLL" () As Long
Public Declare Function ShiftLL Lib "QPRO16.DLL" (ByVal Value As Long, ByVal Shift As Long) As Long
Public Declare Function ShiftLR Lib "QPRO16.DLL" (ByVal Value As Long, ByVal Shift As Long) As Long
Public Declare Function Sound Lib "QPRO16.DLL" (ByVal Frequency As Long, ByVal Duration As Long) As Long
Public Declare Function Soundex Lib "QPRO16.DLL" (ByVal text As String) As String
Public Declare Function SPropOff Lib "QPRO16.DLL" (Ctl As Control, ByVal usIProp As Long) As Integer
Public Declare Function SysDir Lib "QPRO16.DLL" () As String
    
Public Declare Function Time2Num Lib "QPRO16.DLL" (ByVal strTime As String) As Long
Public Declare Function Times2 Lib "QPRO16.DLL" (ByVal L As Long) As Long
Public Declare Function Trapint Lib "QPRO16.DLL" (ByVal L As Long, ByVal Lo As Long, ByVal Hi As Long) As Long
Public Declare Function TrimZStr Lib "QPRO16.DLL" (ByVal Work As String) As String

Public Declare Function UnLockFile Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Offset As Long, ByVal Length As Long)                  ' Sub

Public Declare Function Valid Lib "QPRO16.DLL" (ByVal FileName As String) As Long
Public Declare Function VarPtr Lib "QPRO16.DLL" (ByRef Variable As Any) As Integer
Public Declare Function VarPtr32 Lib "QPRO16.DLL" Alias "Near32" () As Long
Public Declare Function VarSeg Lib "QPRO16.DLL" (ByRef Variable As Any) As Integer

Public Declare Function WhichError Lib "QPRO16.DLL" () As Long
Public Declare Function WinDir Lib "QPRO16.DLL" () As String
Public Declare Function WinVer Lib "QPRO16.DLL" () As Long
Public Declare Function WriteTest Lib "QPRO16.DLL" (ByVal DriveLetter As String) As Long

Public Declare Function XDialog2Pixel Lib "QPRO16.DLL" (ByVal xDialog As Long) As Long
Public Declare Function XDialog2Twp Lib "QPRO16.DLL" (ByVal xDialog As Long) As Long
Public Declare Function XPixel2Dialog Lib "QPRO16.DLL" (ByVal xPixel As Long) As Long
Public Declare Function XPixel2Twp Lib "QPRO16.DLL" (ByVal xPixel As Long) As Long
Public Declare Function XTwp2Dialog Lib "QPRO16.DLL" (ByVal xTwip As Long) As Long
Public Declare Function XTwp2Pixel Lib "QPRO16.DLL" (ByVal Twip As Long) As Long

Public Declare Function YDialog2Pixel Lib "QPRO16.DLL" (ByVal yDialog As Long) As Long
Public Declare Function YDialog2Twp Lib "QPRO16.DLL" (ByVal yDialog As Long) As Long
Public Declare Function YPixel2Dialog Lib "QPRO16.DLL" (ByVal yPixel As Long) As Long
Public Declare Function YPixel2Twp Lib "QPRO16.DLL" (ByVal yPixel As Long) As Long
Public Declare Function YTwp2Dialog Lib "QPRO16.DLL" (ByVal yTwip As Long) As Long
Public Declare Function YTwp2Pixel Lib "QPRO16.DLL" (ByVal Twip As Long) As Long
    
'---- QuickPak 16-bit Subroutines
Public Declare Sub AddInt Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal Value As Integer, ByVal NumEls As Long)
Public Declare Sub AddLong Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal Value As Long, ByVal NumEls As Long)
Public Declare Sub AllKeyExit Lib "QPRO16.DLL" ()
Public Declare Sub Array2CB Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub Array2List Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub ArrayISortNum Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal MemberSize As Long) ' Sub
Public Declare Sub ArrayISortStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)              ' Sub
Public Declare Sub ArrayISortTyp Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArrayISortVar Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortNum Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal MbrSiz As Long)
Public Declare Sub ArraySortStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortTyp Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long, ByVal CaseSensitive As Long)
Public Declare Sub ArraySortVar Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal CaseSensitive As Long)
    
Public Declare Sub BCopy Lib "QPRO16.DLL" (ByVal wSelSource As Integer, ByVal wOffSource As Integer, ByVal wSelDest As Integer, ByVal wOffDest As Integer, ByVal NumBytes As Long, ByVal bDirection As Long)
Public Declare Sub BCopyT Lib "QPRO16.DLL" (ByRef UdtSource As Any, ByRef UDTDest As Any, ByVal ElSize As Long, ByVal NumEls As Long)
    
Public Declare Sub CapsOff Lib "QPRO16.DLL" ()
Public Declare Sub CapsOn Lib "QPRO16.DLL" ()
Public Declare Sub CB2Array Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub CB2File Lib "QPRO16.DLL" (Ctl As Control, ByVal FileName As String, ByVal bAppend As Long)
Public Declare Sub CBResetContent Lib "QPRO16.DLL" (Ctl As Control)
Public Declare Sub CDir Lib "QPRO16.DLL" (ByVal NewDir As String)
Public Declare Sub ClipFile Lib "QPRO16.DLL" (ByVal FileName As String, ByVal NewLength As Long)
Public Declare Sub CSSetAttr Lib "QPRO16.DLL" (ByVal FileName As String, ByVal attr As Long)
Public Declare Sub CtlFrame Lib "QPRO16.DLL" (ByVal ControlHWND As Long, ByVal FrameEffect As Long, ByVal SunColor As Long, ByVal ShadowColor As Long, ByVal BorderWidth As Long, ByVal BorderStyle As Long)
    
Public Declare Sub DeleteStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub DeleteT Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub DiskInfo Lib "QPRO16.DLL" (ByVal DriveLetter As String, ByRef BytesPerSector As Long, ByRef SectorsPerCluster As Long, ByRef FreeClusters As Long, ByRef TotalClusters As Long)

Public Declare Sub Encrypt Lib "QPRO16.DLL" (ByVal Work As String, ByVal Password As String)
Public Declare Sub Encrypt2 Lib "QPRO16.DLL" (ByVal Work As String, ByVal Password As String)
Public Declare Sub FClose Lib "QPRO16.DLL" (ByVal Handle As Long)
Public Declare Sub FCopy Lib "QPRO16.DLL" (ByVal Sfile As String, ByVal Dfile As String, ByRef ErrCode As Long)
Public Declare Sub FCreate Lib "QPRO16.DLL" (ByVal FileName As String)
Public Declare Sub FFlush Lib "QPRO16.DLL" (ByVal Handle As Long)
Public Declare Sub FGet Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Destination As String)
Public Declare Sub FGetA Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub FGetAH Lib "QPRO16.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Function FGetR Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Destination As String, ByVal RecNum As Long) As String
Public Declare Sub FGetRT Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal RecNum As Long, ByVal NumBytes As Long)
Public Declare Sub FGetRTA Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal RecNum As Long, ByVal NumBytes As Long, ByVal NumRecs As Long)
Public Declare Sub FGetT Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Destination As Any, ByVal NumBytes As Long)
Public Declare Sub File2CB Lib "QPRO16.DLL" (Ctl As Control, ByVal FileName As String)
Public Declare Sub File2List Lib "QPRO16.DLL" (Ctl As Control, ByVal FileName As String)
Public Declare Sub FileInfo Lib "QPRO16.DLL" (ByVal FileName As String, ByRef TypeVar As tagFileInfo)
Public Declare Sub Fill2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Fill4 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Fill8 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef Value As Any, ByVal NumEls As Long)
Public Declare Sub Find Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub Find2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindB Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindB2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindT Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindT2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindTB Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FindTB2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByRef NumEls As Long, ByRef Search As String)
Public Declare Sub FloppyType Lib "QPRO16.DLL" (ByRef FloppyA As Long, ByRef FloppyB As Long)
Public Declare Sub FPut Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Source As String)
Public Declare Sub FPutA Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub FPutAH Lib "QPRO16.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub FPutR Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Source As String, ByVal RecNum As Long)
Public Declare Sub FPutRT Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal RecNum As Long, ByVal RecSize As Long)
Public Declare Sub FPutRTA Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal RecNum As Long, ByVal RecSize As Long, ByVal NumRecs As Long)
Public Declare Sub FPutT Lib "QPRO16.DLL" (ByVal Handle As Long, ByRef Source As Any, ByVal NumBytes As Long)
Public Declare Sub FSeek Lib "QPRO16.DLL" (ByVal Handle As Long, ByVal Location As Long)
Public Declare Sub FStamp Lib "QPRO16.DLL" (ByVal FileName As String, ByVal NewTime As String, ByVal NewDate As String)

Public Declare Sub GenFrame Lib "QPRO16.DLL" (ByRef lpRect As RECT, ByVal hdc As Long, ByVal wstyle As Long, ByVal SunColor As Long, ByVal shadow As Long, ByVal BorderWidth As Long, ByVal FrameStyle As Long)                 ' Sub
Public Declare Sub GetEquip Lib "QPRO16.DLL" (ByRef Floppies As Integer, ByRef Parallels As Integer, ByRef Serials As Integer)
Public Declare Sub GetEquip2 Lib "QPRO16.DLL" (ByRef Floppies As Integer, ByRef Parallels As Integer, ByRef Serials As Integer)

Public Declare Sub HotKeyExit Lib "QPRO16.DLL" ()

Public Declare Sub InitIndex Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub InitInt Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal StartValue As Integer, ByVal NumEls As Long)
Public Declare Sub InitLong Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal StartValue As Long, ByVal NumEls As Long)
Public Declare Sub InsertStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef InsStr As String, ByVal NumEls As Long)
Public Declare Sub InsertT Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal ElSize As Long, ByVal NumEls As Long)
Public Declare Sub ISortC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortStr2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortT Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long)
Public Declare Sub ISortT2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long)
Public Declare Sub ISortV Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub ISortV2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByRef AVindex As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)

Public Declare Sub KeySort Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByRef KeyInfoArray As tagAV, ByVal NumKeys As Long)
Public Declare Sub KillAK Lib "QPRO16.DLL" (ByVal hwnd As Long)
Public Declare Sub KillDir Lib "QPRO16.DLL" (ByVal DirName As String)
Public Declare Sub KillFile Lib "QPRO16.DLL" (ByVal FileName As String)
Public Declare Sub KillHK Lib "QPRO16.DLL" (ByVal hwnd As Long)

Public Declare Sub LBGetSelection Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub LBResetContent Lib "QPRO16.DLL" (Ctl As Control)
Public Declare Sub LBSetTabStops Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub List2Array Lib "QPRO16.DLL" (Ctl As Control, ByRef AV As tagAV, ByVal NumEls As Long)
Public Declare Sub List2File Lib "QPRO16.DLL" (Ctl As Control, ByVal FileName As String, ByVal bAppend As Long)
Public Declare Sub LowAscii Lib "QPRO16.DLL" (ByVal Work As String)
Public Declare Sub Lower Lib "QPRO16.DLL" (ByVal Work As String)
Public Declare Sub LowerTbl Lib "QPRO16.DLL" (ByVal Work As String, ByVal CharTable As String)
    
Public Declare Sub MakeDir Lib "QPRO16.DLL" (ByVal DirName As String)
Public Declare Sub MonoPrint Lib "QPRO16.DLL" (ByVal str As String, ByVal row As Long, ByVal column As Long, ByVal attr As Long)

Public Declare Sub NameDir Lib "QPRO16.DLL" (ByVal OlsName As String, ByVal NewName As String)
Public Declare Sub NameFile Lib "QPRO16.DLL" (ByVal OlsName As String, ByVal NewName As String)
Public Declare Sub NumOff Lib "QPRO16.DLL" ()
Public Declare Sub NumOn Lib "QPRO16.DLL" ()

Public Declare Sub Open255 Lib "QPRO16.DLL" (ByVal NumFiles As Long)
Public Declare Sub Out Lib "QPRO16.DLL" (ByVal port As Integer, ByVal byteval As Byte)
Public Declare Sub Out2 Lib "QPRO16.DLL" (ByVal port As Integer, ByVal byteval As Byte)

Public Declare Sub Poke1 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpByte As Long, ByVal I1 As Byte)
Public Declare Sub Poke2 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpWord As Long, ByVal i2 As Integer)
Public Declare Sub Poke4 Lib "QPRO16.DLL" (ByVal Segment As Integer, ByVal lpDWord As Long, ByVal i4 As Long)
Public Declare Sub ProperName Lib "QPRO16.DLL" (ByVal Work As String)
Public Declare Sub PutVol Lib "QPRO16.DLL" (ByVal DriveLetter As String, ByVal VolLabel As String)

Public Declare Sub QBLoad Lib "QPRO16.DLL" (ByVal FileName As String, ByRef AV As tagAV)
Public Declare Sub QBSave Lib "QPRO16.DLL" (ByVal FileName As String, ByRef AV As tagAV, ByVal NumBytes As Long)
Public Declare Sub QProVer Lib "QPRO16.DLL" ()

Public Declare Sub ReadDir Lib "QPRO16.DLL" (ByRef AV As tagAV)
Public Declare Sub ReadDirT Lib "QPRO16.DLL" (ByVal DirSpec As String, ByRef AV As tagAV)
Public Declare Sub ReadFile Lib "QPRO16.DLL" Alias "CSReadFile" (ByRef AV As tagAV)
Public Declare Sub ReadFileI Lib "QPRO16.DLL" (ByRef AV As tagAV)
Public Declare Sub ReadFileT Lib "QPRO16.DLL" (ByVal FileSpec As String, ByRef AV As tagAV)
Public Declare Sub ReadFileX Lib "QPRO16.DLL" (ByVal FileSpec As String, ByRef DirSize As Long, ByRef tagReadFileX As tagAV)
Public Declare Sub ReadSect Lib "QPRO16.DLL" (ByVal DriveLetter As String, ByVal Destination As String, ByVal SectorNum As Long)
Public Declare Sub RemCtrl Lib "QPRO16.DLL" (ByVal Work As String, ByVal CharNew As String)
Public Declare Sub ReplaceChar Lib "QPRO16.DLL" (ByVal CharStr As String, ByVal CharOld As String, ByVal CharNew As String)
Public Declare Sub ReplaceChar2 Lib "QPRO16.DLL" (ByVal CharStr As String, ByVal CharOld As String, ByVal CharNew As String)

Public Declare Sub ScrollOff Lib "QPRO16.DLL" ()
Public Declare Sub ScrollOn Lib "QPRO16.DLL" ()
Public Declare Sub Sequence Lib "QPRO16.DLL" (ByVal Work As String)
Public Declare Sub SetBit Lib "QPRO16.DLL" (ByVal Flags As String, ByVal Element As Long, ByVal BOOL As Long)
Public Declare Sub SetDrive Lib "QPRO16.DLL" (ByVal DriveLetter As String)
Public Declare Sub SetError Lib "QPRO16.DLL" (ByVal ErrorNumber As Long)
Public Declare Sub SortC Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortD Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortI Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortL Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortS Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortStr Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortStr2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortT Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long) ' Sub
Public Declare Sub SortT2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long, ByVal ElSize As Long, ByVal MbrOff As Long, ByVal MbrSiz As Long) ' Sub
Public Declare Sub SortV Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SortV2 Lib "QPRO16.DLL" (ByRef AV As tagAV, ByVal NumEls As Long, ByVal bDirection As Long)
Public Declare Sub SplitColor Lib "QPRO16.DLL" (ByRef red As Byte, ByRef green As Byte, ByRef blue As Byte, ByVal RGB As Long)
Public Declare Sub Swap Lib "QPRO16.DLL" (ByRef A As Any, ByRef B As Any, ByVal NumBytes As Long)
Public Declare Sub SysTime Lib "QPRO16.DLL" (ByRef strTime As String)

Public Declare Sub Translate Lib "QPRO16.DLL" (ByVal Work As String)

Public Declare Sub Upper Lib "QPRO16.DLL" (ByVal Work As String)
Public Declare Sub UpperTbl Lib "QPRO16.DLL" (ByVal Work As String, ByVal CharTable As String)

Public Declare Sub WriteSect Lib "QPRO16.DLL" (ByVal DriveLetter As String, ByVal Source As String, ByVal SectorNum As Long)
Public Declare Sub WriteSect2 Lib "QPRO16.DLL" (ByVal DriveLetter As String, ByVal Source As String, ByVal SectorNum As Long)

#End If ' 16-bit constants, declares, defines



