#define MAXCOLORS 256

#ifndef d_word
 #define d_word unsigned long
#endif
#ifndef word
 #define word unsigned int
#endif
#ifndef byte
 #define byte unsigned char
#endif

#ifndef PALETTE_TIMER
 #define PALETTE_TIMER 250
#endif

#include <sys\timeb.h>

struct timeb time_pointer;
d_word old_palette_timer, palette_timer=0, max_palette_timer=PALETTE_TIMER;
byte palette[768];
byte palette_flag=OFF;

byte read_palette(char *filename)
{
 char buf[80];
 size_t itemsread;
 FILE *file;

 sprintf(buf,"%s%s.pal",path,filename);

 if ((file=fopen(buf,"rb"))==NULL)
 {
  printf("Unable to open %s for read.\n",buf);
  return (FAILURE);
 }
 itemsread=fread(palette,3,MAXCOLORS,file);
 fclose(file);

 return(SUCCESS);
}

byte write_palette(char *filename)
{
 size_t itemswritten;
 FILE *file;
 char buf[80];

 sprintf(buf,"%s%s.pal",path,filename);

 if ((file=fopen(buf,"wb"))==NULL)
 {
  printf("Unable to open palette file for write.");
  return (FAILURE);
 }
 itemswritten=fwrite(palette,3,MAXCOLORS,file);
 fclose(file);
 return(SUCCESS);
}

void set_palette(void)
{
 union REGS regs;
 struct SREGS segs;

 char *pal=palette;

 regs.h.ah=0x10;
 regs.h.al=0x12;

 regs.x.bx=0;               // First color
 regs.x.cx=256;             // Number of colors
 segs.es=FP_SEG(pal);
 regs.x.dx=FP_OFF(pal);

 _asm
 {
		cli                     /* clear interrupts */
		mov       dx,03DAh      /* wait for vert. retrace */
  start:
		in        al,dx
		and       al,08h
		jnz       start
  mid:
		in        al,dx
		and       al,08h
		jz        mid

		sti                     /* restore interrupts */
 }

 palette_flag=ON;                       /* so mouse won't interrupt */
 int86x(0x10,&regs,&regs,&segs);
 palette_flag=OFF;                      /* re-enable mouse (see mouse.h) */
}

void palette_switch(byte start, byte amount)
{
 union REGS regs;
 struct SREGS segs;
 int a, b;
 byte tmp_col[3];
 char *pal=palette;

 /* wait PALETTE_DELAY milliseconds before rotating palette */

 old_palette_timer=(d_word)(time_pointer.time*1000+time_pointer.millitm);
 ftime(&time_pointer);
 palette_timer+=(d_word)((time_pointer.time*1000+time_pointer.millitm)
	       -old_palette_timer);

 if (palette_timer>=max_palette_timer)
  max_palette_timer=(d_word)(palette_timer+PALETTE_TIMER);
 else return;

 /* rotate the palette */

 for (a=start;a<start+amount;a+=4)
 {
  memcpy(tmp_col,&palette[a*3+0],3);

  for (b=0;b<3;b++)
  {
   memcpy(&palette[(a+b)*3],&palette[(a+b+1)*3],3);
  }

  memcpy(&palette[(a+3)*3],tmp_col,3);
 }

 /* set up the registers now for the palette setting interrupt */

  regs.h.ah=0x10;
  regs.h.al=0x12;

  regs.x.bx=start;               // First color
  regs.x.cx=amount;             // Number of colors
  segs.es=FP_SEG(pal);
  regs.x.dx=FP_OFF(pal)+start*3;

 _asm
 {
		cli
		mov       dx,03DAh              /* wait for vert. retrace */
  begin:
		in        al,dx
		and       al,08h
		jnz       begin
  mid:
		in        al,dx
		and       al,08h
		jz        mid

		sti
 }

 palette_flag=ON;                       /* disable the mouse */
 set_palette();
// int86x(0x10,&regs,&regs,&segs);
 palette_flag=OFF;                      /* re-enable mouse (see mouse.h) */
}

void adjust_palette(byte shift)
{
 word a, b;

 for (a=0;a<768;a++)
  palette[a]=palette[a]>>shift;
}


