#ifndef DOSH
 #include <dos.h>
#endif

#ifndef GRAPHH
 #include <graph.h>
#endif

#ifndef STDIOH
 #include <stdio.h>
#endif

#ifndef NORMAL
 #define NORMAL 1
 #define MASK 2
#endif

#ifndef NO
 #define NO 0
 #define YES 1
#endif

#define MOUSE_ON 1
#define MOUSE_OFF 2

#define MOUSE_CURSOR_X_SIZE 16
#define MOUSE_CURSOR_Y_SIZE 16
#define MOUSE_CURSOR_SIZE MOUSE_CURSOR_X_SIZE*MOUSE_CURSOR_Y_SIZE

#define MOUSE_CLICK_DELAY 50 /* in milliseconds */

word mouse_x, mouse_y;
byte mouse_1, mouse_2, mouse_3;
word mouse_status;
byte mouse_flag=OFF;
byte mouse_click=NO;

word old_mouse_offset,
     old_mouse_segment,
     old_mouse_mask;

byte huge *mouse_cursor,
	  *mouse_background;

d_word old_mouse_timer, mouse_timer=0, max_mouse_timer=MOUSE_CLICK_DELAY;


/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void set_mouse(short value)
{
 union REGS inregs, outregs;

 inregs.h.ah=0;
 inregs.h.al=(char)value;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void restrict_mouse(short x1,short y1,short x2,short y2)
{
 union REGS inregs, outregs;

 inregs.x.ax=7;                   // Set X limits
 inregs.x.cx=x1*2;
 inregs.x.dx=x2*2;
 int86(0x33,&inregs,&outregs);

 inregs.x.ax=8;                   // Set Y limits
 inregs.x.cx=y1;
 inregs.x.dx=y2;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void position_mouse(short x, short y)
{
 union REGS inregs, outregs;

 inregs.x.ax=4;                   // Move to X, Y
 inregs.x.cx=x*2;
 inregs.x.dx=y;
 int86(0x33,&inregs,&outregs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void interrupt mouse_handler(void)
{
 union REGS inregs;

 _asm
 {
  push    ds

  mov     al,[palette_flag]
  dec     al
  jz      end

  mov     ax,3
  int     0x33
  shr     cx,1
  mov     [mouse_x],cx
  shl     cx,1
  mov     [mouse_y],dx

  mov     ax,bx
  mov     [mouse_status],bx
  and     ax,0x0001
  mov     [mouse_1],al

  and     ax,0x0002
  mov     [mouse_3],al

  and     ax,0x0004
  mov     [mouse_2],al

  mov     ax,4
  int     0x33

  end:
  pop     ds
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void install_mouse_handler(void)
{
 union REGS inregs, outregs;
 struct SREGS segs;

 word func_off, func_seg;

 _asm
 {
  mov     [func_off],OFFSET mouse_handler
  mov     [func_seg],SEG mouse_handler
 }

 inregs.x.ax=0x14;
 inregs.x.cx=127;
 inregs.x.dx=func_off;
 segs.es=func_seg;
 int86x(0x33,&inregs,&outregs,&segs);
 old_mouse_segment=segs.es;
 old_mouse_offset=outregs.x.dx;
 old_mouse_mask=outregs.x.cx;
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void remove_mouse_handler(void)
{
 union REGS inregs, outregs;
 struct SREGS segs;

 inregs.x.ax=0x14;
 inregs.x.dx=old_mouse_offset;
 segs.es=old_mouse_segment;
 inregs.x.cx=old_mouse_mask;
 int86x(0x33,&inregs,&outregs,&segs);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void read_mouse(void)
{
 union REGS inregs, outregs;

 inregs.h.ah=0;
 inregs.h.al=3;
 inregs.x.bx=0;
 inregs.x.cx=0;
 inregs.x.dx=0;
 int86(0x33,&inregs,&outregs);

 mouse_x=outregs.x.cx/2;
 mouse_y=outregs.x.dx;
 mouse_1=(char)outregs.x.bx&0x01;
 outregs.x.bx>>=1;
 mouse_2=(char)outregs.x.bx&0x01;
 outregs.x.bx>>=1;
 mouse_3=(char)outregs.x.bx&0x01;
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void refresh_mouse(void)
{
 get_image(mouse_x,mouse_y,mouse_background,MOUSE_CURSOR_X_SIZE,
					    MOUSE_CURSOR_Y_SIZE);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hide_mouse(void)
{
 put_image(mouse_x,mouse_y,mouse_background,MOUSE_CURSOR_X_SIZE,
					     MOUSE_CURSOR_Y_SIZE,
					     NORMAL);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_mouse(void)
{
 put_image(mouse_x,mouse_y,mouse_cursor,MOUSE_CURSOR_X_SIZE,
					MOUSE_CURSOR_Y_SIZE,
					MASK);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_mouse(void)
{
 refresh_mouse();
 show_mouse();
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_mouse(void)
{
 mouse_cursor=(byte huge *)halloc((long)256,1);
 if (mouse_cursor==NULL)
 {
  printf("error allocating mouse cursor\n");
  return(FAILURE);
 }
 mouse_background=(byte huge *)halloc((long)256,1);
 if (mouse_background==NULL)
 {
  printf("error allocating mouse background\n");
  return(FAILURE);
 }
 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_mouse(void)
{
 if (mouse_cursor!=NULL) hfree(mouse_cursor);
 if (mouse_background!=NULL) hfree(mouse_background);
}

