/* 
   FLEETSTREET Install - script

   JUST RUN IT
   */

fleetver = '0.95'

/* Scripts */
Scripts.Count = 7
Scripts.1.Name = 'ROT13'
Scripts.1.File = 'rot13.frx'
Scripts.2.Name = 'Message Box'
Scripts.2.File = 'mbox.frx'
Scripts.3.Name = 'Nodelist lookup'
Scripts.3.File = 'lookup.frx'
Scripts.4.Name = 'Nodelist lookup 2'
Scripts.4.File = 'lookup2.frx'
Scripts.5.Name = 'UU Encode'
Scripts.5.File = 'uuencode.frx'
Scripts.6.Name = 'UU Decode'
Scripts.6.File = 'uudecode.frx'
Scripts.7.Name = 'Check area'
Scripts.7.File = 'chkarea.frx'

/* Files */
Files.0 = 12
Files.1 = 'FltStrt.exe'
Files.2 = 'EDITWIN.DLL'
Files.3 = 'FLTV7.DLL'
Files.4 = 'LAYOUTS.DLL'
Files.5 = 'msgview.DLL'
Files.6 = 'hmsg.DLL'
Files.7 = 'statline.DLL'
Files.8 = 'clrsel.DLL'
Files.9 = 'fltrun.DLL'
Files.10= 'mlist.DLL'
Files.11= 'printmsg.DLL'
Files.12= 'fleetcom.exe'

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call SysCls

Signal On Halt Name SignalHandler

CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '

/* get defaults
    */
Lang    =       Prompt( 'Sprache/Language (D/E)          [E]:', 'E',        'DE' )
SrcDir  = Directory()
IF Lang='D' THEN
      DestDir = Prompt( 'Zielverzeichnis          ['||SrcDir||']:', SrcDir, ''   )
   ELSE
      DestDir = Prompt( 'Target directory         ['||SrcDir||']:', SrcDir, ''   )
IF Lang='D' THEN
      Cr_Obj  = Prompt( 'WPS-Objekt erzeugen? (J/N)      [J]:', 'J',        'JN' )
   ELSE
      Cr_Obj  = Prompt( 'Create WPS object (Y/N)         [Y]:', 'Y',        'YN' )


/* correct pathnames
    */
IF RIGHT( SrcDir,  1) = '\' THEN
    SrcDir  = LEFT(SrcDir,  LENGTH(SrcDir) -1)
IF RIGHT( DestDir, 1) = '\' THEN
    DestDir = LEFT(DestDir, LENGTH(DestDir)-1)


/* All OK ?
    */
CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '
SAY '                                                             '
IF Lang='D' THEN
      SAY ' Sprache                : Deutsch'
   ELSE
      SAY ' Language               : English'
IF Lang='D' THEN
      SAY ' Quellverzeichnis       : 'SrcDir
   ELSE
      SAY ' Source Directory       : 'SrcDir
IF Lang='D' THEN
      SAY ' Zielverzeichnis        : 'DestDir
   ELSE
      SAY ' Installation Directory : 'DestDir
IF Lang='D' THEN
      SAY ' WPS-Objekt erzeugen    : 'Cr_Obj
   ELSE
      SAY ' create WPS object      : 'Cr_Obj
SAY
SAY
IF Lang='D' THEN
   reply = Prompt( 'In Ordnung? (J/N)   [J]:', 'J', 'JN', )
ELSE
   reply = Prompt( 'Correct? (Y/N)  [Y]:', 'Y', 'YN', )

IF reply = 'N' THEN
   EXIT


CALL SysCls
SAY 'ͻ'
SAY '                                                           '
SAY '                FleetStreet Installation                   '
SAY '                                                           '
SAY 'ͼ'
SAY '                                                             '
SAY '                                                             '

/* check destination directory
    */
Call SysFileTree DestDir, Dirs, 'D'

/* Directory nicht da  */
If Dirs.0 = '0' & Lang = 'D' THEN DO
   SAY 'Das Verzeichnis "'DestDir'" existiert nicht.'
   SAY
   answer = Prompt( 'Verzeichnis erstellen? (J/N)       [J]:', 'J', 'JN', )
   SAY
   IF answer = 'J' THEN DO
      SAY 'Erzeuge Verzeichnis 'DestDir' ....'
      rc = SysMkDir( DestDir )
      IF rc = 0 THEN
         SAY 'Das Verzeichnis "'DestDir'" wurde erzeugt.'
      ELSE DO
         SAY 'Fehler beim Erzeugen von "'DestDir'". Abbruch der Installation'
         EXIT
         END
      END /* do if answer */
    ELSE
      EXIT
END /* if dirs.0 */

If Dirs.0 = '0' & Lang = 'E' THEN DO
   SAY 'The "'DestDir'" directory does not exist on your hard drive.'
   SAY
   answer = Prompt( 'create directory? (Y/N)       [Y]:', 'Y', 'YN', )
   SAY
   IF answer = 'Y' THEN DO
      SAY 'Creating 'DestDir' ...'
      rc = SysMkDir( DestDir )
      IF rc = 0 THEN
         SAY 'The directory "'DestDir'" was created successfully.'
      ELSE DO
         SAY 'The directory "'DestDir'" could not be created. Exiting installation'
         EXIT
         END
      END /* do */
   ELSE
      EXIT
End /* if dirs.0 */



/* correct pathnames for copy
    */
SrcDir  = SrcDir||'\'
DestDir = DestDir||'\'
RexxDir = DestDir||'Scripts'

if translate(SrcDir) <> translate(DestDir) then
   do
   do i= 1 to Files.0
      CALL FileCopy SrcDir||Files.i  DestDir||Files.i
   end

   call SysMkDir RexxDir

   do i= 1 to Scripts.Count
      CALL FileCopy SrcDir||Scripts.i.File RexxDir||'\'||Scripts.i.File
      CALL SysIni DestDir||'SCRIPTS.INI', '#'||i, 'File', RexxDir||'\'||Scripts.i.File
      CALL SysIni DestDir||'SCRIPTS.INI', '#'||i, 'Name', Scripts.i.Name
   end
   end

IF Lang = 'D' THEN DO
   CALL FileCopy SrcDir||'german.hlp'    DestDir||'FltStrt.hlp'
   CALL FileCopy SrcDir||'german.lng'    DestDir||'FleetLng.dll'
   CALL FileCopy SrcDir||'readme.txt'    DestDir||'"ReadMe"'
   CALL FileCopy SrcDir||'whatsnew.txt'  DestDir||'"WhatsNew"'
   CALL FileCopy SrcDir||'register.txt'  DestDir||'"Register"'
   END
ELSE DO
   CALL FileCopy SrcDir||'english.hlp'   DestDir||'FltStrt.hlp'
   CALL FileCopy SrcDir||'english.lng'   DestDir||'FleetLng.dll'
   CALL FileCopy SrcDir||'readme.eng'    DestDir||'"ReadMe"'
   CALL FileCopy SrcDir||'whatsnew.eng'  DestDir||'"WhatsNew"'
   CALL FileCopy SrcDir||'register.eng'  DestDir||'"Register"'
   END


/* Program objekt erstellen ? */
CALL SysCls
IF Cr_Obj = 'Y' | Cr_Obj = 'J' THEN
   IF Lang = 'D' THEN DO
      IF \SysCreateObject( "WPFolder",  "FleetStreet^Beta" fleetver, "<WP_DESKTOP>" ,,
         "OBJECTID=<FleetFldr>" , "R") THEN DO
         SAY "Fehler beim Erzeugen des Ordners"
         EXIT
         END
      IF \SysCreateObject( "WPProgram", "FleetStreet", "<FleetFldr>",,
         "OBJECTID=<FleetPRG>;EXENAME="||DestDir||"\FltStrt.exe;STARTUPDIR="||DestDir, "R" ) THEN DO
         SAY "Fehler beim Erzeugen des Programmobjekts"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "ReadMe" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"ReadMe;OBJECTID=<FleetRdm>", "R" ) THEN DO
         SAY "Fehler beim Erzeugen des 1. Readme-Objekts"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "WhatsNew" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"WhatsNew;OBJECTID=<FleetNewRdm>", "R" ) THEN DO
         SAY "Fehler beim Erzeugen des 2. Readme-Objekts"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "Register" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"Register;OBJECTID=<FleetRegister>", "R" ) THEN DO
         SAY "Fehler beim Erzeugen des 3. Readme-Objekts"
         EXIT
         END
      END
   ELSE DO                                  /* english version */
      IF \SysCreateObject( "WPFolder",  "FleetStreet^Beta" fleetver, "<WP_DESKTOP>" ,,
         "OBJECTID=<FleetFldr>" , "R") THEN DO
         SAY "Error creating Folder"
         EXIT
         END
      IF \SysCreateObject( "WPProgram", "FleetStreet", "<FleetFldr>",,
         "OBJECTID=<FleetPRG>;EXENAME="||DestDir||"\FltStrt.exe;STARTUPDIR="||DestDir, "R" ) THEN DO
         SAY "Error creating program object"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "ReadMe" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"ReadMe;OBJECTID=<FleetRdm>", "R" ) THEN DO
         SAY "Error creating 1st readme object"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "WhatsNew" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"WhatsNew;OBJECTID=<FleetNewRdm>", "R" ) THEN DO
         SAY "Error creating 2nd readme object"
         EXIT
         END
      IF \SysCreateObject( "WPShadow", "Register" , "<FleetFldr>",,
         "SHADOWID="||DestDir||"Register;OBJECTID=<FleetRegister>", "R" ) THEN DO
         SAY "Error creating 3rd readme object"
         EXIT
         END
      END

'@chkdll'
CALL SysCls
if rc <> 0 then do
   if Lang = 'D' then do
      Say center('Achtung!', 78)
      Say ''
      Say ' Die Datei MSGAPI32.DLL wurde nicht gefunden. Stellen Sie sicher,'
      Say ' da die DLL beim Start von FleetStreet geladen werden kann. Die'
      Say ' DLL mu dazu im FleetStreet-Verzeichnis stehen oder in einem'
      Say ' anderen Verzeichnis, das im LIBPATH eingetragen ist. FleetStreet'
      Say ' ist ohne diese DLL nicht lauffhig.'
      Say ''
      Say 'Bitte Enter drcken.'
      Pull ConfirmIt
      end
   else do
      Say center('Warning!', 78)
      Say ''
      Say ' The file MSGAPI32.DLL could not be found. Make sure that this'
      Say ' DLL can be loaded when starting FleetStreet. The DLL must be'
      Say ' located in the FleetStreet directory or in one of the directories'
      Say ' listed in LIBPATH. FleetStreet will not run without this DLL.'
      Say ''
      Say 'Press Enter to continue.'
      Pull ConfirmIt
      end
   END

CALL SysCls
IF Lang = 'D' THEN DO
   Say 'ͻ'
   Say '                                                           '
   Say '   Die Installation von FleetStreet ist fertig.            '
   Say '                                                           '
   Say '   Fr neueste Infos lesen Sie die Dateien "ReadMe",       '
   Say '   und "WhatsNew".                                         '
   Say '                                                           '
   Say 'ͼ'
   END  /* Do */
ELSE DO
   Say 'ͻ'
   Say '                                                      '
   Say '   FleetStreet installation is complete               '
   Say '                                                      '
   Say '   For latest information read the files "ReadMe",    '
   Say '   and "WhatsNew".                                    '
   Say '                                                      '
   Say 'ͼ'
   END
Exit


/* 
   FileCopy
    */
   FileCopy:
   PARSE ARG SrcFile DestFile

       IF Lang = 'D' THEN
          SAY 'Kopiere 'SrcFile' nach 'DestFile
       ELSE
          SAY 'Copying 'SrcFile' to 'DestFile
       '@Copy' SrcFile DestFile '>NUL'
       if rc \= 0 Then Do
          SAY 'Warning! 'SrcFile' could not be copied properly. PRESS YOUR FAVOURITE <ANY-KEY>'
          Pull ConfirmIt
          End
       Return


/* 
   Prompt
    */
   Prompt:
   PARSE Arg PrText, DefVal,  PossVal

       PARSE VALUE SysCurPos() WITH Row .             /* position of cursor   */
       PARSE VALUE SysTextScreenSize() WITH NumRows . /* screen size          */
       IF Row = NumRows - 1 THEN Row = Row - 1        /* end of screen?       */
       Col = Length(PrText) + 2                       /* input                */
       DO UNTIL answer \= ''
          CALL SysCurPos Row, 1
          SAY PrText                                  /* show input           */
          CALL SysCurPos Row, Col
          PARSE PULL answer
          IF answer = '' THEN
             answer = DefVal
          IF PossVal \= '' THEN DO                    /* accept all inputs    */
             answer = TRANSLATE(answer)
             IF POS(answer,PossVal) = 0 THEN          /* if PossVal is empty  */
                answer = ''
             END
       END /* until */
    RETURN answer


/* 
   SignalHandler
    */
SignalHandler:
Call SysCls
Exit
