#include windows.sh
#include dialog.sh

#define  CtrlQ_E  1001
#define  CtrlQ_X  1002
#define  CtrlQ_R  1003
#define  CtrlQ_C  1004
#define  CtrlQ_S  1005
#define  CtrlQ_D  1006
#define  CtrlQ_B  1007
#define  CtrlQ_K  1008
#define  CtrlQ_P  1009
#define  CtrlQ_L  1010
#define  CtrlQ_F  1011
#define  CtrlQ_A  1012
#define  CtrlQ_Y	1013

#define  CtrlK_D  1101
#define  CtrlK_Q  1102
#define  CtrlK_S  1103
#define  CtrlK_X  1104
#define  CtrlK_J  1105
#define  CtrlK_R  1106
#define  CtrlK_K  1107
#define  CtrlK_B  1108
#define  CtrlK_C  1109
#define  CtrlK_V  1110
#define  CtrlK_W  1111
#define  CtrlK_Y  1112
#define  CtrlK_H  1113
#define  CtrlK_P  1114

#define  CtrlO_C  1201
#define  CtrlO_W  1202
#define  CtrlO_R  1203
#define  CtrlO_L  1204
#define  CtrlO_X  1205
#define  CtrlO_G  1206


macro_file WORDSTAR;
/******************************************************************************
														MULTI-EDIT MACRO FILE

Name:		WORDSTAR

Description:  This macro file contains macros to emulate a subset of common
							Wordstar key commands.  It is not our intention to completely
							mimic Wordstar, but to provide a less painful transition from
							Wordstar to Multi-Edit.

WORDSTAR				- Initializes the editor for Wordstar emulation
WS_PROCESS_KEY1 - Used by other Wordstar emulation macros
CTRLQ						- Traps <CtrlQ> and process the second keystroke
CTRLK						- Traps <CtrlK> and process the second keystroke
CTRLO						- Traps <CtrlO> and process the second keystroke
CTRLW						- Performs Wordstar-like scroll down
CTRLZ						- Performs Wordstar-like scroll up
DELWORDR				- Delete word right
HOMEKEY					- Special processing for the home key
ENDKEY					- Special processing for the end key
RIGHTMAR				- Sets right margin
LEFTMAR					- Sets left margin
RESETMAR				- Resets margin
INDENT					- Performs Wordstar like indent
UNDENT					- Performs Wordstar like undent
WSHELP					- Calls the Wordstar help
WSINSTALL				- Used to configure the Wordstar keymap.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*****************************************************************************/

macro WORDSTAR {
/*******************************************************************************
															MULTI-EDIT MACRO

Name:		WORDSTAR

Description:  Initializes the editor for Wordstar emulation

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	Right_Margin = 80;
	Set_Global_Int('Margin_Released',FALSE);
	Set_Global_Int('Left_Margin',1);
	Set_Global_Int('Right_Margin',Right_Margin);
	Set_Global_Int('Name_La',0);
	Set_Global_Int('Stat_La',0);
	Word_Delimits = ' .,:;!?';
	Indent_Style = 0;
	Goto_Col(1);
	Set_Indent_Level;

#ifdef FOR_DEMO

Set_Global_Str('@KEYMAP_NAME@','KN=WORDSTARFN=WORDSTAR');
Make_message("Wordstar keymap enabled.  Press <F1> for help.");

// Default key assignments
MACRO_TO_KEY(<CtrlK>,'WORDSTAR^CtrlK ',EDIT);
MACRO_TO_KEY(<CtrlO>,'WORDSTAR^CtrlO ',EDIT);
MACRO_TO_KEY(<CtrlQ>,'WORDSTAR^CtrlQ ',EDIT);
MACRO_TO_KEY(<AltIns>,'MEHELP^ScreenMrk ',ALL);
MACRO_TO_KEY(<MEVENT2>,'MOUSE^MOUSEEVENT2 ',EDIT);
MACRO_TO_KEY(<MEVENT>,'MOUSE^MOUEVENT ',EDIT);
MACRO_TO_KEY(<ShftMEVENT>,'MOUSE^CUA_Shft_Button ',EDIT);
MACRO_TO_KEY(<CtrlMEVENT>,'MOUSE^MOUSE_BLOCK_OP /BT=1',EDIT);
MACRO_TO_KEY(<AltMEVENT>,'MOUSE^MOUSE_BLOCK_OP /BT=2',EDIT);
MACRO_TO_KEY(<ShftMEVENT2>,'MOUSE^MOUSE_SEARCH ',EDIT);
MACRO_TO_KEY(<CtrlMEVENT2>,'MOUSE^MOUSE_SEARCH /D=1',EDIT);
MACRO_TO_KEY(<AltENTER>,'MEUTIL3^USER ',EDIT);
Set_Global_Str('!MIM_KEY1', '<AltENTER>');
MACRO_TO_KEY(<F1>,'WORDSTAR^WSHELP ',EDIT);
FLABEL('Help',1,EDIT);
MACRO_TO_KEY(<AltH>,'USERIN^MAINHELP ',EDIT);
MACRO_TO_KEY(<F2>,'MEMENUS ',EDIT);
FLABEL('Menu',2,EDIT);
Set_Global_Str('!MM_KEY', '<F2>');
MACRO_TO_KEY(<ESC>,'MEMENUS ',EDIT);
MACRO_TO_KEY(<F3>,'MEUTIL1^SAVEFILE ',EDIT);
FLABEL('Save',3,EDIT);
Set_Global_Str('!FM_KEY4', '<F3>');
MACRO_TO_KEY(<CtrlF3>,'MEUTIL1^SAVEBLCK ',EDIT);
FLABEL('SaveBl',23,EDIT);
Set_Global_Str('!FM_KEY8', '<CtrlF3>');
MACRO_TO_KEY(<ShftF3>,'MEUTIL1^LOADFILE ',EDIT);
FLABEL('Load',13,EDIT);
Set_Global_Str('!FM_KEY2', '<ShftF3>');
MACRO_TO_KEY(<F6>,'MEUTIL2^SEARCH ',EDIT);
FLABEL('Search',6,EDIT);
Set_Global_Str('!SRM_KEY1', '<F6>');
MACRO_TO_KEY(<ShftF6>,'MEUTIL2^S_REPL ',EDIT);
FLABEL('S/Repl',16,EDIT);
Set_Global_Str('!SRM_KEY2', '<ShftF6>');
MACRO_TO_KEY(<CtrlF6>,'MEUTIL2^REPSRCH ',EDIT);
FLABEL('NxtSrc',26,EDIT);
Set_Global_Str('!SRM_KEY3', '<CtrlF6>');
MACRO_TO_KEY(<CtrlL>,'MEUTIL2^REPSRCH ',EDIT);
MACRO_TO_KEY(<AltF>,'MEUTIL2^FS ',EDIT);
Set_Global_Str('!SRM_KEY5', '<AltF>');
MACRO_TO_KEY(<AltG>,'MEUTIL2^FS /N',EDIT);
Set_Global_Str('!SRM_KEY6', '<AltG>');
MACRO_TO_KEY(<AltShftF>,'MEUTIL2^FS /M=1',EDIT);
Set_Global_Str('!SRM_KEY7', '<AltShftF>');
MACRO_TO_KEY(<ShftF7>,'MEUTIL2^MCOLBLCK ',EDIT);
FLABEL('BegCol',17,EDIT);
Set_Global_Str('!BM_KEY16', '<ShftF7>');
MACRO_TO_KEY(<F7>,'MEUTIL2^MSTRBLCK ',EDIT);
FLABEL('BegBlk',7,EDIT);
Set_Global_Str('!BM_KEY17', '<F7>');
MACRO_TO_KEY(<CtrlF9>,'MEUTIL2^BLOCKOFF ',EDIT);
FLABEL('BlkOff',29,EDIT);
Set_Global_Str('!BM_KEY18', '<CtrlF9>');
MACRO_TO_KEY(<AltU>,'MEUTIL2^UNDBLK ',EDIT);
Set_Global_Str('!BM_KEY8', '<AltU>');
MACRO_TO_KEY(<AltI>,'MEUTIL2^INDBLK ',EDIT);
Set_Global_Str('!BM_KEY7', '<AltI>');
MACRO_TO_KEY(<F9>,'MEUTIL2^BLOCKOP /BT=0',EDIT);
FLABEL('CopyBl',9,EDIT);
Set_Global_Str('!BM_KEY1', '<F9>');
MACRO_TO_KEY(<F10>,'MEUTIL2^BLOCKOP /BT=1',EDIT);
FLABEL('MoveBl',10,EDIT);
Set_Global_Str('!BM_KEY2', '<F10>');
MACRO_TO_KEY(<CtrlF10>,'MEUTIL2^BLOCKOP /BT=2',EDIT);
FLABEL('DelBl',30,EDIT);
Set_Global_Str('!BM_KEY3', '<CtrlF10>');
MACRO_TO_KEY(<ShftF9>,'MEUTIL2^BLOCKOP /BT=3',EDIT);
FLABEL('WnCopy',19,EDIT);
Set_Global_Str('!BM_KEY10', '<ShftF9>');
MACRO_TO_KEY(<ShftF10>,'MEUTIL2^BLOCKOP /BT=4',EDIT);
FLABEL('WnMove',20,EDIT);
Set_Global_Str('!BM_KEY11', '<ShftF10>');
MACRO_TO_KEY(<GREY->,'MEUTIL2^CUT /M',EDIT);
Set_Global_Str('!CPM_KEY2', '<GREY->');
MACRO_TO_KEY(<GreyENTER>,'MEUTIL2^PASTE ',EDIT);
Set_Global_Str('!CPM_KEY5', '<GreyENTER>');
MACRO_TO_KEY(<GREY+>,'MEUTIL2^CUT ',EDIT);
Set_Global_Str('!CPM_KEY1', '<GREY+>');
MACRO_TO_KEY(<CtrlGREY->,'MEUTIL2^CUT /M /A',EDIT);
Set_Global_Str('!CPM_KEY4', '<CtrlGREY->');
MACRO_TO_KEY(<CtrlGREY+>,'MEUTIL2^CUT /A',EDIT);
Set_Global_Str('!CPM_KEY3', '<CtrlGREY+>');
MACRO_TO_KEY(<CtrlF5>,'WINDOW^WINOP /T=8',EDIT);
FLABEL('Zoom',25,EDIT);
Set_Global_Str('!WM_KEY12', '<CtrlF5>');
MACRO_TO_KEY(<CtrlGREY/>,'WINDOW^WINOP /T=1',EDIT);
Set_Global_Str('!WM_KEY2', '<CtrlGREY/>');
MACRO_TO_KEY(<ScrollLockOn>,'WINDOW^WINOP /T=5',EDIT);
Set_Global_Str('!WM_KEY11', '<ScrollLockOn>');
MACRO_TO_KEY(<AltF1>,'WINDOW^WINOP /T=3',EDIT);
FLABEL('WinLst',31,EDIT);
Set_Global_Str('!WM_KEY4', '<AltF1>');
MACRO_TO_KEY(<AltW>,'WINDOW^ADJACENT_WIN ',EDIT);
Set_Global_Str('!WM_KEY8', '<AltW>');
MACRO_TO_KEY(<ShftF1>,'WINDOW^NEXTWIN ',EDIT);
FLABEL('NxtWin',11,EDIT);
Set_Global_Str('!WM_KEY6', '<ShftF1>');
MACRO_TO_KEY(<CtrlF1>,'WINDOW^LASTWIN ',EDIT);
FLABEL('LstWin',21,EDIT);
Set_Global_Str('!WM_KEY7', '<CtrlF1>');
CMD_TO_KEY(<DEL>,DEL_CHAR,EDIT);
CMD_TO_KEY(<CtrlG>,DEL_CHAR,EDIT);
MACRO_TO_KEY(<AltD>,'DELEOL ',EDIT);
MACRO_TO_KEY(<ShftDEL>,'DELWORD ',EDIT);
MACRO_TO_KEY(<CtrlT>,'WORDSTAR^DELWORDR ',EDIT);
CMD_TO_KEY(<BS>,BACK_SPACE,EDIT);
CMD_TO_KEY(<CtrlH>,BACK_SPACE,EDIT);
MACRO_TO_KEY(<CtrlBS>,'BSWORD ',EDIT);
CMD_TO_KEY(<ShftF8>,DEL_LINE,EDIT);
FLABEL('DelLin',18,EDIT);
CMD_TO_KEY(<CtrlY>,DEL_LINE,EDIT);
CMD_TO_KEY(<CtrlF7>,UNDO,EDIT);
FLABEL('UNDO',27,EDIT);
Set_Global_Str('!TXM_KEY1', '<CtrlF7>');
CMD_TO_KEY(<CtrlENTER>,UNDO,EDIT);
CMD_TO_KEY(<CtrlDEL>,REDO,EDIT);
Set_Global_Str('!TXM_KEY2', '<CtrlDEL>');
MACRO_TO_KEY(<END>,'END /T=300',EDIT);
MACRO_TO_KEY(<HOME>,'HOME /T=300',EDIT);
CMD_TO_KEY(<LF>,LEFT,EDIT);
CMD_TO_KEY(<CtrlS>,LEFT,EDIT);
CMD_TO_KEY(<RT>,RIGHT,EDIT);
CMD_TO_KEY(<CtrlD>,RIGHT,EDIT);
CMD_TO_KEY(<UP>,UP,EDIT);
CMD_TO_KEY(<CtrlE>,UP,EDIT);
CMD_TO_KEY(<DN>,DOWN,EDIT);
CMD_TO_KEY(<CtrlX>,DOWN,EDIT);
MACRO_TO_KEY(<HOME>,'WORDSTAR^HOMEKEY ',EDIT);
MACRO_TO_KEY(<END>,'WORDSTAR^ENDKEY ',EDIT);
CMD_TO_KEY(<PgUp>,PAGE_UP,EDIT);
CMD_TO_KEY(<CtrlR>,PAGE_UP,EDIT);
CMD_TO_KEY(<PgDn>,PAGE_DOWN,EDIT);
CMD_TO_KEY(<CtrlC>,PAGE_DOWN,EDIT);
CMD_TO_KEY(<CtrlHome>,TOF,EDIT);
CMD_TO_KEY(<CtrlEnd>,EOF,EDIT);
CMD_TO_KEY(<CtrlPgDn>,NEXT_PAGE_BREAK,EDIT);
Set_Global_Str('!NEXT_PB_KEY', '<CtrlPgDn>');
CMD_TO_KEY(<CtrlPgUp>,LAST_PAGE_BREAK,EDIT);
Set_Global_Str('!LAST_PB_KEY', '<CtrlPgUp>');
CMD_TO_KEY(<CtrlLF>,WORD_LEFT,EDIT);
CMD_TO_KEY(<CtrlA>,WORD_LEFT,EDIT);
CMD_TO_KEY(<CtrlRT>,WORD_RIGHT,EDIT);
CMD_TO_KEY(<CtrlF>,WORD_RIGHT,EDIT);
MACRO_TO_KEY(<CtrlZ>,'WORDSTAR^CTRLZ ',EDIT);
MACRO_TO_KEY(<CtrlW>,'WORDSTAR^CTRLW ',EDIT);
MACRO_TO_KEY(<AltF8>,'GOTOLINE ',EDIT);
FLABEL('GotoLn',38,EDIT);
Set_Global_Str('!CRSM_KEY7', '<AltF8>');
CMD_TO_KEY(<TAB>,TAB_RIGHT,EDIT);
CMD_TO_KEY(<CtrlI>,TAB_RIGHT,EDIT);
CMD_TO_KEY(<ShftTAB>,TAB_LEFT,EDIT);
CMD_TO_KEY(<F4>,INDENT,EDIT);
FLABEL('Indent',4,EDIT);
Set_Global_Str('!IND_KEY', '<F4>');
CMD_TO_KEY(<ShftF4>,UNDENT,EDIT);
FLABEL('Undent',14,EDIT);
Set_Global_Str('!UND_KEY', '<ShftF4>');
MACRO_TO_KEY(<F5>,'TEXT^MARKPOS ',EDIT);
FLABEL('Mark',5,EDIT);
Set_Global_Str('!CRSM_KEY1', '<F5>');
MACRO_TO_KEY(<ShftF5>,'TEXT^GOTOMARK ',EDIT);
FLABEL('GotoMk',15,EDIT);
Set_Global_Str('!CRSM_KEY2', '<ShftF5>');
MACRO_TO_KEY(<AltR>,'TEXT^REFORMAT ',EDIT);
Set_Global_Str('!TXM_KEY11', '<AltR>');
MACRO_TO_KEY(<CtrlB>,'TEXT^REFORMAT ',EDIT);
MACRO_TO_KEY(<AltJ>,'TEXT^JUSTIFY ',EDIT);
Set_Global_Str('!TXM_KEY12', '<AltJ>');
MACRO_TO_KEY(<ShftF2>,'DATETIME ',EDIT);
FLABEL('DatTim',12,EDIT);
Set_Global_Str('!TXM_KEY8', '<ShftF2>');
MACRO_TO_KEY(<ENTER>,'CR ',EDIT);
MACRO_TO_KEY(<CtrlN>,'CR ',EDIT);
MACRO_TO_KEY(<INS>,'INSTGL ',EDIT);
MACRO_TO_KEY(<CtrlV>,'INSTGL ',EDIT);
MACRO_TO_KEY(<F8>,'MEUTIL1^RUNMAC ',EDIT);
FLABEL('RunMac',8,EDIT);
Set_Global_Str('!MCM_KEY1', '<F8>');
CMD_TO_KEY(<AltF10>,KEY_RECORD,EDIT);
FLABEL('Record',40,EDIT);
Set_Global_Str('!RECORD_KEY', '<AltF10>');
CMD_TO_KEY(<AltF10>,KEY_RECORD,DOS_SHELL);
FLABEL('Record',40,DOS_SHELL);
MACRO_TO_KEY(<AltN>,'NOTEBOOK ',ALL);
MACRO_TO_KEY(<AltV>,'VCS ',EDIT);
Set_Global_Str('!VCS_KEY1', '<AltV>');
MACRO_TO_KEY(<AltP>,'DB /F=PHONE.DB/SRP=1',EDIT);
MACRO_TO_KEY(<AltQ>,'EXIT /NP=1',EDIT);
MACRO_TO_KEY(<AltA>,'SUPPORT^ASCII ',ALL);
Set_Global_Str('!MIM_KEY10', '<AltA>');
MACRO_TO_KEY(<AltF5>,'SUPPORT^ASCII ',EDIT);
FLABEL('ASCII',35,EDIT);
Set_Global_Str('!MIM_KEY10', '<AltF5>');
MACRO_TO_KEY(<AltA>,'SUPPORT^ASCII ',EDIT);
MACRO_TO_KEY(<AltF4>,'SUPPORT^CONDENSE ',EDIT);
FLABEL('Condns',34,EDIT);
Set_Global_Str('!MIM_KEY11', '<AltF4>');
MACRO_TO_KEY(<CtrlF4>,'DIRSHELL^DIRSHELL ',EDIT);
FLABEL('DIR',24,EDIT);
Set_Global_Str('!FM_KEY10', '<CtrlF4>');
MACRO_TO_KEY(<AltF3>,'MEUTIL1^SHELLDOS ',EDIT);
FLABEL('runDOS',33,EDIT);
Set_Global_Str('!MIM_KEY12', '<AltF3>');
MACRO_TO_KEY(<CtrlF8>,'LANGUAGE^COMPILE ',EDIT);
FLABEL('Compil',28,EDIT);
Set_Global_Str('!MIM_KEY4', '<CtrlF8>');
MACRO_TO_KEY(<CtrlF2>,'LANGUAGE^CMPERROR ',EDIT);
FLABEL('NxtErr',22,EDIT);
Set_Global_Str('!MIM_KEY5', '<CtrlF2>');
MACRO_TO_KEY(<AltE>,'LANGUAGE^CMPERROR ',EDIT);
MACRO_TO_KEY(<AltF9>,'LANGUAGE^TEMPLATE ',EDIT);
FLABEL('Templt',39,EDIT);
Set_Global_Str('!MIM_KEY6', '<AltF9>');
MACRO_TO_KEY(<AltT>,'LANGUAGE^TEMPLATE ',EDIT);
MACRO_TO_KEY(<AltF6>,'LANGUAGE^MATCH ',EDIT);
FLABEL('Match',36,EDIT);
Set_Global_Str('!MIM_KEY7', '<AltF6>');
MACRO_TO_KEY(<AltM>,'LANGUAGE^MATCH ',EDIT);
MACRO_TO_KEY(<AltF2>,'CALC ',EDIT);
FLABEL('Calc',32,EDIT);
Set_Global_Str('!MIM_KEY9', '<AltF2>');
MACRO_TO_KEY(<AltC>,'DOCUMENT^FCMD ',EDIT);
Set_Global_Str('!LM_KEY10', '<AltC>');
MACRO_TO_KEY(<AltL>,'SUPPORT^LINEDRAW ',EDIT);
Set_Global_Str('!MIM_KEY13', '<AltL>');
MACRO_TO_KEY(<AltX>,'EXIT^EXIT ',EDIT);
Set_Global_Str('!FM_KEY11', '<AltX>');
MACRO_TO_KEY(<AltK>,'SETUP^KEYCODE ',EDIT);
MACRO_TO_KEY(<AltZ>,'XZOOM ',EDIT);
Set_Global_Str('!TOG_SCR_FORM', '<AltZ>');
MACRO_TO_KEY(<AltS>,'SPELL^SPELL ',EDIT);
Set_Global_Str('!MIM_KEY16', '<AltS>');
MACRO_TO_KEY(<AltP>,'DB /F=PHONE.DB',EDIT);

if (global_int('!EVgDialectId')) {
	RM("EV_");
	RM('EVINIT');  // INIT EVOLVE IF IT WAS ENABLED BEFORE
}
#endif // FOR_DEMO

}

void WS_S ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    goto_col(1);
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    Save_File;
    /* If you want to be prompted, which is not the way Wordstar does it, replace
    the above line with this one.
    RM('MEUTIL1^SAVEFILE');
    */
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('s');
    else
      text('S');
  }
}

void WS_X ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('BotWin');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('EXIT /NP=1');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    RM('ResetMar');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('x');
    else
      text('X');
  }
}

void WS_Y ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    /* Delete to EOL */
    RM('DELEOL');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    /* Delete block */
    RM('MEUTIL2^BLOCKOP /BT=2');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('y');
    else
      text('Y');
  }
}

void WS_D ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    /* Move to end of line or column 80 whichever is less */
    RM('EOL_OR_80');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('SAVE_RELOAD');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('d');
    else
      text('D');
  }
}

void WS_E ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('TopWin');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('e');
    else
      text('E');
  }
}

void WS_L ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('SPELL');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    RM('LeftMar');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('l');
    else
      text('L');
  }
}

void WS_R ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    Tof;
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('MEUTIL1^Splice');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    RM('RightMar');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('r');
    else
      text('R');
  }
}

void WS_C ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    Eof;
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('MEUTIL2^BLOCKOP /BT=0');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    RM('TEXT^Center');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('c');
    else
      text('C');
  }
}

void WS_F ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('Meutil2^Search');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('f');
    else
      text('F');
  }
}

void WS_A ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('Meutil2^S_Repl');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('a');
    else
      text('A');
  }
}

void WS_P ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    Undo;
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('MEUTIL3^Print');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('p');
    else
      text('P');
  }
}

void WS_B ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('TOPBLOCK');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    Make_Message('Stream Block marking on.  Press Block End to stop.');
    Str_Block_Begin;
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('b');
    else
      text('B');
  }
}

void WS_K ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    if ( block_stat )
    {
      RM('ENDBLOCK');
    }
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    if ( block_stat )
    {
			Make_Message('Block marked.');
			Block_End;
    }
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('k');
    else
      text('K');
  }
}

void WS_Q ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('EXIT');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('q');
    else
      text('Q');
  }
}

void WS_J ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('DELFILE');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('j');
    else
      text('J');
  }
}

void WS_H ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    Make_Message('Block turned off (hidden).');
    Block_Off;
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('h');
    else
      text('H');
  }
}

void WS_V ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('MEUTIL2^BLOCKOP /BT=1');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('v');
    else
      text('V');
  }
}

void WS_W ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54B )  //Ctrl + K
  {
    RM('MEUTIL1^SaveBlck');
  }
  else if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    Wrap_Stat = NOT(Wrap_Stat);
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('w');
    else
      text('W');
  }
}

void WS_G ();
{
  if ( make_word(prev_key1, prev_key2) == 0x54F )  //Ctrl + O
  {
    RM('Indent');
  }
  else {
    if ((key2 == 1) && !(0x01 & GetKeyState(VK_CAPITAL)))
      text('g');
    else
      text('G');
  }
}

void WS_DEL ();
{
  if ( make_word(prev_key1, prev_key2) == 0x551 )  //Ctrl + Q
  {
    RM('DEL_TO_HOME');
  }
  else {
    del_char;
  }
}

int CtrlProc (int &retval, int window, message, wparam, lparam, str parms) {
  int rv = 0;
  switch ( message )
  {
    case WM_ACTIVATE :
    {
      if ( !wparam )
      {
        PostMessage(window, WM_CLOSE, 0, 0);
        break;
      }
    }
    case WM_COMMAND :
    {
      switch ( wparam )
      {
//*******************Control Q stuff************************************
        case  CtrlQ_F :
          DestroyWindow(window);
          RM('search');
          retval = 0;
          return (rv);
        case  CtrlQ_A :
          DestroyWindow(window);
          RM('s_repl');
          retval = 0;
          return (rv);
        case  CtrlQ_E :
          DestroyWindow(window);
          RM('TopWin');
          retval = 0;
          return (rv);
        case  CtrlQ_X :
          DestroyWindow(window);
          RM('BotWin');
          retval = 0;
          return (rv);
        case  CtrlQ_R :
          DestroyWindow(window);
          Tof;
          retval = 0;
          return (rv);
        case  CtrlQ_C :
          DestroyWindow(window);
          Eof;
          retval = 0;
          return (rv);
        case  CtrlQ_S :
          DestroyWindow(window);
          goto_col(1);
          retval = 0;
          return (rv);
        case  CtrlQ_D :
          DestroyWindow(window);
          RM('EOL_OR_80');
          retval = 0;
          return (rv);
        case  CtrlQ_B :
          DestroyWindow(window);
          RM('TOPBLOCK');
          retval = 0;
          return (rv);
        case  CtrlQ_K :
          DestroyWindow(window);
          RM('ENDBLOCK');
          retval = 0;
          return (rv);
        case  CtrlQ_P :
          DestroyWindow(window);
          Undo;
          retval = 0;
          return (rv);
        case  CtrlQ_L :
          DestroyWindow(window);
          RM('SPELL');
          retval = 0;
          return (rv);
				case CtrlQ_Y :
          DestroyWindow(window);
					Rm( "DelEol" );
          retval = 0;
          return (rv);
					break;
 //*************************Control K Stuff*********************************
        case  CtrlK_D :
          DestroyWindow(window);
          RM('SAVE_RELOAD');
          retval = 0;
          return (rv);
        case  CtrlK_Q :
          DestroyWindow(window);
          RM('EXIT');
          retval = 0;
          return (rv);
        case  CtrlK_S :
          DestroyWindow(window);
          Save_File;
          retval = 0;
          return (rv);
        case  CtrlK_X :
          DestroyWindow(window);
          RM('EXIT /NP=1');
          retval = 0;
          return (rv);
        case  CtrlK_J :
          DestroyWindow(window);
          RM('DELFILE');
          retval = 0;
          return (rv);
        case  CtrlK_R :
          DestroyWindow(window);
          RM('MEUTIL1^Splice');
          retval = 0;
          return (rv);
        case  CtrlK_K :
          DestroyWindow(window);
          if ( block_stat )
          {
            Make_Message('Block marked.');
            Block_End;
          }
          retval = 0;
          return (rv);
        case  CtrlK_B :
          DestroyWindow(window);
          Make_Message('Stream Block marking on.  Press Block End to stop.');
          Str_Block_Begin;
          retval = 0;
          return (rv);
        case  CtrlK_C :
          DestroyWindow(window);
          RM('MEUTIL2^BLOCKOP /BT=0');
          retval = 0;
          return (rv);
        case  CtrlK_V :
          DestroyWindow(window);
          RM('MEUTIL2^BLOCKOP /BT=1');
          retval = 0;
          return (rv);
        case  CtrlK_W :
          DestroyWindow(window);
          RM('MEUTIL1^SaveBlck');
          retval = 0;
          return (rv);
        case  CtrlK_Y :
          DestroyWindow(window);
          RM('MEUTIL2^BLOCKOP /BT=2');
          retval = 0;
          return (rv);
        case  CtrlK_H :
          DestroyWindow(window);
          Make_Message('Block turned off (hidden).');
          Block_Off;
          retval = 0;
          return (rv);
        case  CtrlK_P :
          DestroyWindow(window);
          RM('MEUTIL3^Print');
          retval = 0;
          return (rv);
//***********************Control O stuff*************************
        case  CtrlO_C :
          DestroyWindow(window);
          RM('TEXT^Center');
          retval = 0;
          return (rv);
        case  CtrlO_W :
          DestroyWindow(window);
          Wrap_Stat = NOT(Wrap_Stat);
          retval = 0;
          return (rv);
        case  CtrlO_R :
          DestroyWindow(window);
          RM('RightMar');
          retval = 0;
          return (rv);
        case  CtrlO_L :
          DestroyWindow(window);
          RM('LeftMar');
          retval = 0;
          return (rv);
        case  CtrlO_X :
          DestroyWindow(window);
          RM('ResetMar');
          retval = 0;
          return (rv);
        case  CtrlO_G :
          DestroyWindow(window);
          RM('Indent');
          retval = 0;
          return (rv);
      }
      break;
    }
    case WM_CLOSE :
    {
      DestroyWindow(window);
      retval = 0;
      return (1);
    }
  }
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}

macro CTRLQ {

  if (Global_Int('@WS_CTRL_HLP_OFF@')) {
    Make_Message('Ctrl + Q');
  } else {
    int dlg;
    DlgCreate(dlg);
    DlgAddCtrl( dlg, Dlg_PushButton, '&E - Top of Screen    ', 1, 1, 25, 0, CtrlQ_E, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&X - Bottom of Screen ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_X, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&R - Beginning of File', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_R, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&C - End of File      ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_C, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&S - Beginning of Line', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_S, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&F - Find             ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_F, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&Y - Delete to EOL    ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_Y, DLGF_Es_Left, "");

    DlgAddCtrl( dlg, Dlg_PushButton, '&D - End of Line      ', 28, 1, 25, 0, CtrlQ_D, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&B - Top of Block     ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_B, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&K - End of Block     ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_K, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&P - Undo             ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_P, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&L - Spell Checker    ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_L, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&A - Find and Replace ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlQ_A, 0, "");

    DlgExecute( dlg, CtrlQ_E, 'Ctrl + Q', '', '/HOOK=CtrlProc', DLG_Modeless | DLG_NoParDisable);
    //DlgExecute(dlg, 0, 'Ctrl + Q', '', '', 0);
    //DlgKill(dlg);
    Make_Message('Ctrl + Q');
  }

}

macro CTRLK {
	str FName[128];

  if (Global_Int('@WS_CTRL_HLP_OFF@')) {
    Make_Message('Ctrl + K');
  } else {
    int dlg;
    DlgCreate(dlg);
    DlgAddCtrl( dlg, Dlg_PushButton, '&D - Save - Done      ', 1, 1, 25, 0, CtrlK_D, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&Q - Quit             ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_Q, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&S - Save File        ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_S, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&X - Save and Quit    ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_X, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&J - Delete File      ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_J, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&R - Merge File       ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_R, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&K - Mark Block End   ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_K, 0, "");

    DlgAddCtrl( dlg, Dlg_PushButton, '&B - Mark Block Begin ', 28, 1, 25, 0, CtrlK_B, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&C - Copy Block       ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_C, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&V - Move Block       ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_V, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&W - Save Block       ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_W, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&Y - Delete Block     ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_Y, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&H - Hide Block       ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_H, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&P - Print            ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlK_P, 0, "");

    DlgExecute( dlg, CtrlK_D, 'Ctrl + K', '', '/HOOK=CtrlProc', DLG_Modeless | DLG_NoParDisable);
  }
}

macro CTRLO {

  if (Global_Int('@WS_CTRL_HLP_OFF@')) {
    Make_Message('Ctrl + O');
  } else {
    int dlg;
    DlgCreate(dlg);
    DlgAddCtrl( dlg, Dlg_PushButton, '&C - Center Line      ', 1, 1, 25, 0, CtrlO_C, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&W - Word Wrap Toggle ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlO_W, DLGF_Es_Left, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&R - Right Margin     ', 1, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlO_R, DLGF_Es_Left, "");

    DlgAddCtrl( dlg, Dlg_PushButton, '&L - Left Margin      ', 28, 1, 25, 0, CtrlO_L, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&X - Margin Release   ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlO_X, 0, "");
    DlgAddCtrl( dlg, Dlg_PushButton, '&G - Indent           ', Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 15), 25, 0, CtrlO_G, 0, "");

    DlgExecute( dlg, CtrlO_C, 'Ctrl + O', '', '/HOOK=CtrlProc', DLG_Modeless | DLG_NoParDisable);
    Make_Message('Ctrl + O');
  }

}

macro CTRLW {
	Push_Undo;
  if (c_line > Win_CHeight) {
    RM('ScrollDn');
  } else {
    make_message('Top of File is Visible');
  }
	Pop_Undo;
}

macro CTRLZ {
	Push_Undo;
	RM('ScrollUp');
  //if (WhereY > (Win_Y1 + 1)) {
  //  Up;
  //}
	Pop_Undo;
}

macro DELWORDR {
	str Temp_Line;
	Messages = FALSE;
	Push_Undo;
	if (Cur_Char == ' ') {
		while(  Cur_Char == ' '  ) {
			Del_Char;
		}
		Goto Macro_Exit;
	}
	if (XPos(Cur_Char,'.,:;!?',1)) {
		Del_Char;
		Goto Macro_Exit;
	}
	while ((XPos(Cur_Char,' .,:;!?',1) == 0) & (NOT(At_Eol) | NOT(At_Eof))) {
		if (NOT(At_Eol & (Cur_Char == char(255)))) {
			Del_Char;
		} else {
			Down;
			Temp_Line = Get_Line;
			Del_Line;
			Up;
			Eol;
			Mark_Pos;
			Text(Temp_Line);
			Goto_Mark;
			Goto Macro_Exit;
		}
	}
	if (XPos(Cur_Char,'.,:;!?',1)) {
		Del_Char;
	}
Macro_Exit:
	Pop_Undo;
	Refresh = TRUE;
	Messages = TRUE;
}

macro HOMEKEY {
	Push_Undo;
	if (Global_Int('WS_Mode')) {
		RM('^TopWin');
		Goto_Col(1);
	} else {
		if (C_Col != 1) {
			Goto_Col(1);
		} else {
			RM('^TopWin');
			Goto_Col(1);
		}
	}
	Pop_Undo;
}

macro ENDKEY {
	Push_Undo;
	if (Global_Int('WS_Mode')) {
		RM('^BotWin');
		if (At_Eol) {
			Eol;
		}
	} else {
		if (!(At_Eol)) {
			Eol;
		} else {
			RM('^BotWin');
			if (At_Eol) {
				Eol;
			}
		}
	}
	Pop_Undo;
}

macro RIGHTMAR {
	int J2,J3;

	Set_Global_Int('!W_IINT_1',Right_Margin);
	Create_Global_Str('!W_IPARM_1','/TP=1/C=1/L=1/W=3/H=WP/T=RIGHT MARGIN COLUMN NUMER (<ESC> for cursor column)?/MIN=1/MAX=254');
	RM( 'USERIN^DATA_IN /PRE=!W_/#=1/T=RIGHT MARGIN/X=8/Y=3');
	if (Return_int) {
		J2 = Global_Int('!W_IINT_1');
	} else {
		J2 = C_Col;
	}
	Set_Global_Int('!W_IINT_1',0);
	J3 = Pos('R',Format_Line);
	if (J3 == 0) {
		J3 = Pos('r',Format_Line);
	}
	if (J3 != 0) {
		Format_Line = Str_Del(Format_Line,J3,1);
		Format_Line = Str_Ins(' ',Format_Line,J3);
	}
	Format_Line = Str_Del(Format_Line,J2,1);
	Format_Line = Str_Ins('R',Format_Line,J2);
	Right_Margin = J2;
	Set_Global_Int('Right_Margin',J2);
}

macro LEFTMAR {
	int J2;
	Push_Undo;

	Set_Global_Int('!W_IINT_1',Indent_Level);
	Create_Global_Str('!W_IPARM_1','/TP=1/C=1/L=1/W=3/H=WP/T=LEFT MARGIN COLUMN NUMER (<ESC> for cursor column)?/MIN=1/MAX=254');
	RM( 'USERIN^DATA_IN /PRE=!W_/#=1/T=LEFT MARGIN/X=8/Y=3');
	if (Return_int) {
		J2 = Global_Int('!W_IINT_1');
		Refresh = FALSE;
		Messages = FALSE;
		Mark_Pos;
		Goto_Col(J2);
		Set_Indent_Level;
		Goto_Mark;
		Messages = True;
		Refresh = TRUE;
	} else {
		Set_Indent_Level;
		J2 = C_Col;
	}
	Set_Global_Int('!W_IINT_1',0);

	Set_Global_Int('Left_Margin',J2);
	Pop_Undo;
}

macro RESETMAR {
	Refresh = FALSE;
	Messages = FALSE;
	Mark_Pos;
	if (NOT(Global_Int('Margin_Released'))) {
		Set_Global_Int('Margin_Released',TRUE);
		Right_Margin = 254;
		Goto_Col(1);
	} else {
		Set_Global_Int('Margin_Released',FALSE);
		Goto_Col(Global_Int('Left_Margin'));
		Right_Margin = Global_Int('Right_Margin');
	}
	Set_Indent_Level;
	Goto_Mark;
	Refresh = TRUE;
	Redraw;
	Messages = TRUE;
}

macro INDENT {
	Indent;
	Set_Global_Int('Left_Margin',C_Col);
}

macro UNDENT {
	Undent;
	Set_Global_Int('Left_Margin',C_Col);
}

macro WSHELP {
 // help('WORDSTAR^*');
}


macro WSInstall {
	Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $02);
	Set_Global_Str('@KEYMAP_NAME@','KN=WORDSTARFN=WORDSTAR');
}

macro EOL_OR_80
{
  Refresh = FALSE;
  Push_Undo;
  Eol;
  if (C_Col > 80) {
    Goto_Col(1);
    Goto_Col(80);
  }
  Pop_Undo;
  Refresh = TRUE;
  Redraw;
}


macro SAVE_RELOAD
{
  RM('MEUTIL1^SAVEFILE');
  if (Return_Int == 1) {
    RM('MEUTIL1^LOADFILE');
  }
}


macro DELFILE
{
  str FName = '';
  Create_Global_Str('!W_ISTR_1','');
  Create_Global_Str('!W_IPARM_1','/C=0/L=1/W=60/ML=80/H=/T=');
  RM( 'USERIN^DATA_IN /PRE=!W_/#=1/T=NAME OF FILE TO DELETE?/X=3/Y=4');
  if (Return_Int) {
    FName = Global_Str('!W_ISTR_1');
    if (File_Exists(FName)) {
      Del_File(FName);
      if (Error_Level) {
        RM('MEERROR');
      } else {
        Make_Message(Caps(FName) + ' Deleted.');
      }
    } else {
      RM('MEERROR^MessageBox /B=1/T=ERROR/M=FILE ' + Caps(FName) + ' NOT FOUND!');
    }
  }
  Set_Global_Str('!W_ISTR_1','');
}
