//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)7 VERS.S, 21-Nov-95,23:06:06, LDH"

macro_file VERS;
/******************************************************************************
                             Multi-Edit Macro File
                               29-Mar-95  13:14

  This macro is the specific interface code for the VCS pakcage Versions 1.1 by
  StarBase Corporation.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

#include DIALOG.SH
#include WINEXEC.SH
#include IDEXE.SH
#include METOOLS.SH
#include DBTOOLS.SH
#include DB.SH
#include VCS.SH

#ifdef   _DEBUG_
  #include DBUG.SH                      // Dbug macros
  #include SPRINTF.SH
#endif

#ifdef  _BETA_
  #define _VERS_VER   "7.01(0.10b)"
#else
  #define _VERS_VER   "7.01(0.10b)"
#endif

prototype Vers {
  int  VersExec( str CmdLine, int Show_Win, int Chg_Dir );
  str  VersXlate( str Path, str FName, str LFile );
  str  VersExt( str FName );
  int  VersChkLib( str Path, str FName, int Pm );
  str  VersGetFName( str LibFile );
  int  VersChkLock( );
  str  VersLookup( str FName, str Field1, str Field2 );
  str  VersCfgFile( str FName, str Param );
  void VersParseErr( );
  str  VersGetUser( );
}

global {
  str g_VersCfg				"!VersCfg";				// Contains the command/setup options
  str g_VersLUT				"!VersLUT";				// Contains the LOOKUP data record
}

macro Vers Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:16

  Name    : Vers

  Function: Checks that the GET executable is found and initilizes VERS
            support.

  Syntax  : Rm( "Vers /I" );

  Entry   : /I              - Initialize the system if checks pass.

  Exit    : Return_Int
              False         - VERS support not installed and checks failed.
              True          - VERS support installed and checks passed.

            gstr !vcsVerStr   - "VERS " + macro version number.
            gstr !vcsRevStr   - macro revision number.
            gstr !vcsDoLogin  - False.

  Globals : str !vcsVerStr  - Returns the string "VERS " + macro version no.
            str !vcsRevStr  - Returns the macro revision number.
            str !vcsDoLogin - Set True to enable changing username and passwd.

  Macros  : int VcsChkVer
            mac PathSearch

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

//+++keyword+++ "@(#)%v %n, %f, %w"
  str Rev_Id = "@(#)7 VERS.S, 21-Nov-95,23:06:06, LDH";
  str Cmd = Copy( _GET_CMDL, 1, XPos( " ", _GET_CMDL, 1 ) - 1 );
  str BDir = _BDIR_CMDL;

  // Check for get command EXE file
  if ( Svl( BDir ) ) {
    BDir += ";";
  }
  Return_Str = ExecSearchPath( Cmd, BDir + "<%PATH>" );
  Return_Int = ( Return_Str != "" );
  if ( Return_Int ) {
    if ( VcsChkVer( _VERS_VER ) ) {
      if ( XPos( "/I", MParm_Str, 1 ) ) {  // Initialize?
        vcsDoLogin = False;             // Disable change user ID menu item
      }
    }
    else {
      Error_Level = 9011;               // Set version error
    }
  }
  else {
    Error_Level = 9010;                 // Set no EXE found error
  }
  vcsVerStr = "VERS " + _VERS_VER;
  vcsRevStr = Rev_Id;

}  // Vers

macro VersView Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:16

  Name    : VersView

  Function: The VERS specific view macro to view the changes to the current
						work file compared to the latest revision in the archive.

  Syntax  : Rm( "VersView" );

  Entry   : gstr !vcsFName  - Filename of file to compare
            gint !vcsLibFnd - Set True if archive found.

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals : str !vcsFName   - The work file name.
            int !vcsLibFnd  - The archive found status (True = found).
            str !vcsDlgMsg  - The dialog message when calling VcsGetLib.
            str !vcsMsg     - The status line message when exec is run.
            str !versCfg    - The VERS specific command/setup options.
            str !vcsName    - The vcs temp file name.


  Macros  : int  VcsGetLib
            int  VersExec
            mac  CDiff
            void VcsViewWinDlg

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );
  str TFName = TempFileName( FName );

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(VERS) VIEW Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "VERS archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Working;
    if ( Switch_File( vcsFName ) ) {
      if ( File_Changed ) {
        Rm( "SaveFile /NP=1" );
      }
    }
    if ( File_Exists( TFName ) ) {
      Set_File_Attr( _VCS3_TMP, 0 );
      Del_File( _VCS3_TMP );
      Rename_File( TFName, _VCS3_TMP );
      Frn = True;
    }
    vcsMsg = "Viewing changes made to \"" + FName + "\"...";
    vcsDlgMsg = "(VERS) VIEW Command Line.";
    if ( Return_Int = VersExec( _VIEW_CMDL, _DISP_WIN, _DO_CD ) ) {
      if ( Global_Int( "!UseCDiff" ) ) {
        Rm( "CDiff /F=" + TFName + "/D=" + str( !_CDIF ) );
      }
      else {
        Rm( "Fc /F=" + TFName + "/S=" + Str( _CDIF * 6 ) );
      }
      if ( Return_Int == 1 ) {
        vcsMsg = "Files the same.";
      }
      else {
        vcsMsg = "CDiff complete.";
      }
      Set_File_Attr( TFName, 0 );
      Del_File( TFName );
      Return_Int = True;
    }
    if ( Frn ) {
      Rename_File( _VCS3_TMP, TFName );
    }
  }
}  // VersView

macro VersList Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:17

  Name    : VersList

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(VERS) LIST Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "VERS archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    vcsMsg = "Listing versions of \"" + Truncate_Path( vcsFName ) + "\"...";
    vcsDlgMsg = "(VERS) LIST Command Line.";
    if ( Return_Int = VersExec( _LIST_CMDL, _DISP_WIN, False ) ) {  // No vcs errors
      if ( Switch_File( vcsName ) ) {
        Return_Int = False;
        Error_Level = 0;
        Load_File( vcsName );
        if ( !Error_Level ) {
          VcsViewWinDlg( "(VERS) Versions of " + Truncate_Path( vcsFName ),
              100, 18, "BT_VCS_109", hc_vcs_List );
          vcsMsg = "VERS LIST command complete.";
          Return_Int = True;
        }
      }
    }
  }
}  // VersList

macro VersLock Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:19

  Name    : VersLock

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str FName = Truncate_Path( vcsFName );

  int Frn = False;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(VERS) LOCK Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "VERS archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    if ( Return_Int = !VersChkLock( ) ) {
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Locking \"" + vcsFName + "\"...";
      vcsDlgMsg = "(VERS) LOCK Command Line.";
      Return_Int = VersExec( _LOCK_CMDL, _DISP_WIN, _DO_CD );
      if ( Frn ) {
        if ( Return_Int ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        else {
          int Sel = Error_Level;

          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
    }
  }
}  // VersLock

macro VersGet Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:20

  Name    : VersGet

  Function:

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error

  Globals :

  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str FName = Truncate_Path( vcsFName );
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );

  int Fw = 0;
  int Frn = False;
  int Sel;

  if ( !vcsLibFnd ) {
    vcsDlgMsg = "(VERS) " + Cmd + " Archive File Path.";
    if ( !vcsLibFnd = VcsGetLib( vcsFName ) ) {
      vcsMsg = "VERS archive file for \"" + FName + "\" not found.";
      Error_Level = 3002;
      Return_Int = False;
    }
  }
  if ( vcsLibFnd ) {
    Return_Int = True;
    if ( Cmd == "GET" ) {
      Return_Int = !VersChkLock( );
      Vcs_Cmd = _GET_CMDL;
    }
    else {
      Vcs_Cmd = _BROWSE_CMDL;
    }
    if ( Return_Int ) {
      if ( Caps( File_Name ) == Caps( vcsFName ) ) {
        Frn = True;
      }
      else if ( Switch_File( vcsFName ) ) {
        Frn = True;
      }
      if ( Frn ) {
        if ( !Read_Only || vcsDF || ( Truncate_Path( File_Name ) != FName ) ) {
          Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
              " Already loaded, OVERWRITE? /BL= ARE YOU SURE? " );
        }
        if ( Return_Int ) {
          Fw = Window_Id;
          VcsPushPos( );
          Erase_Window;
        }
      }
      else if ( File_Exists( vcsFName ) ) {
        Rm( "Verify /H=" + hc_vcs_Verify + "/T=" + vcsFName +
            " Already exists, OVERWRITE? /BL= ARE YOU SURE? " );
      }
    }
    if ( Return_Int ) {
      Frn = False;
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( _VCS3_TMP, 0 );
        Del_File( _VCS3_TMP );
        Rename_File( vcsFName, _VCS3_TMP );
        Frn = True;
      }
      vcsMsg = "Retrieving \"" + vcsFName + "\"...";
      vcsDlgMsg = "(VERS) " + Cmd + " Command Line.";
      if ( Return_Int = VersExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
        if ( Frn ) {
          Sel = Error_Level;
          Set_File_Attr( _VCS3_TMP, 0 );
          Del_File( _VCS3_TMP );
          Error_Level = Sel;
        }
      }
      else {                            // error, restore file
        if ( Frn ) {
          Rename_File( _VCS3_TMP, vcsFName );
        }
        if ( Switch_Win_Id( Fw ) ) {
          Sel = Error_Level;
          Error_Level = 0;
          Load_File( vcsFName );
          if ( !Error_Level ) {
            Rm( "ExtSetup" );
          }
          VcsPopPos( True );
          Error_Level = Sel;
          Return_Int = False;
        }
      }
    }
  }
}  // VersGet

macro VersPut Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:20

  Name    : VersPut

  Function: The VERS specific CREATE/PUT/UNLOCK commands.

  Syntax  :

  Entry   :

  Exit    : Return_Int
              True          - No Error
              False         - ( Error_Level == 0 ) Cancelled
                              ( Error_Level != 0 ) Error
  Globals :

  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str Vcs_Cmd[ 128 ];
  str Cmd[ 20 ] = Parse_Str( "/C=", MParm_Str );
  str FName[ 12 ] = Truncate_Path( vcsFName );

  int Sel;
  int Fw = 0;
  int Ow = 0;
  int Get_Cmt = False;

  Return_Int = True;
  if ( vcsChkMod != "V" ) {
    Return_Int = !VersChkLock( );
  }
  if ( Return_Int ) {
    if ( Caps( File_Name ) == Caps( vcsFName ) ) {
      Fw = Window_Id;
    }
    else if ( Switch_File( vcsFName ) ) {
      Fw = Window_Id;
    }
    if ( Fw ) {
      VcsPushPos( );
    }
    if ( vcsChkMod == "V" ) {
      if ( Window_Id == Fw ) {
        Erase_Window;
      }
      if ( File_Exists( vcsFName ) ) {
        Set_File_Attr( vcsFName, 0 );
        Del_File( vcsFName );
      }
    }
    else {
      if ( !vcsLibFnd ) {
        vcsDlgMsg = "(VERS) " + Cmd + " Archive File Path.";
        vcsLibFnd = VcsGetLib( vcsFName );
        Return_Int = !Error_Level;
        Error_Level = 0;
      }
      if ( Return_Int ) {
        if ( Cmd == "PUT" ) {
          Get_Cmt = True;
          if ( !vcsLibFnd ) {
            Cmd = "CREATE";
          }
          if ( !Fw ) {
            Ow = Window_Id;
            Switch_Window( Window_Count );
            Create_Window;
            Load_File( vcsFName );
            Fw = Window_Id;
          }
        }
        switch ( Cmd ) {
          case "CREATE":
            Vcs_Cmd = _CREATE_CMDL;
            vcsMsg = "Creating \"" + Get_Path( vcsAFile ) + FName + "\" ...";
            vcsDlgMsg = "(VERS) Describe \"" + FName + "\".";
            break;

          case "PUT":
            Vcs_Cmd = _PUT_CMDL;
            vcsMsg = "Storing \"" + FName + "\" in \"" + Get_Path( vcsAFile ) +
                FName + "\"...";
            vcsDlgMsg = "(VERS) Describe changes to \"" + FName + "\".";
            break;

          case "UNLOCK":
            Vcs_Cmd = _UNLOCK_CMDL;
            vcsMsg = "Unlocking \"" + Get_Path( vcsAFile ) + FName + "\"...";
            break;
        }
        if ( Get_Cmt ) {
          Return_Int = VcsGetCmt( True, False );
        }
        if ( Return_Int ) {
          if ( Fw ) {
            Erase_Window;
          }
          vcsDlgMsg = "(VERS) " + Cmd + " Command Line.";
          if ( Return_Int = VersExec( Vcs_Cmd, _DISP_WIN, _DO_CD ) ) {
            if ( File_Exists( vcsFName ) ) {
              if ( _DEL_SRC ) {
                Sel = Error_Level;
                Set_File_Attr( vcsFName, 0 );
                Del_File( vcsFName );
                Error_Level = Sel;
              }
            }
            if ( Ow ) {
              Delete_Window;
              Switch_Win_Id( Ow );
            }
          }
          else {                        // error, reload file
            if ( Switch_Win_Id( Fw ) ) {
              Sel = Error_Level;
              Error_Level = 0;
              Load_File( vcsFName );
              if ( Error_Level == 0 ) {
                if ( Get_Cmt && vcsChgFlg ) {
                  VcsPutCmt( False );
                }
                Rm( "ExtSetup" );
              }
              Get_Cmt = True;
              if ( Ow ) {
                Delete_Window;
                Switch_Win_Id( Ow );
                Get_Cmt = False;
              }
              VcsPopPos( Get_Cmt );
              Error_Level = Sel;
              Return_Int = False;
            }
          }
        }
      }
    }
  }
}  // VersPut

int VersExec( str CmdLine, int Show_Win, int Chg_Dir ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:24

  Name    : VersExec

  Function: Execute the VERS command in cmdline.

  Syntax  : Pass = VersExec( CmdLine, Show_Win, Chg_Dir, Use_Cmd );

  Entry   : str CmdLine
            int Show_Win
            int Chg_Dir
            gstr !vcsFName
            gstr !vcsAFile
            gint !vcsSNCL

  Exit    : int
              True            - No Error.
              False           - ( Error_Level == 0 ) Cancelled
                                ( Error_Level = Error number ) Error
                gstr !vcsMsg  - Error message  ( Only when Error_Level != 0 )

            gstr !vcsDlgMsg   - Cleared.

  Globals : str !vcsFName   - Contains the work file name.
            str !vcsAFile   - Contains the archive file name.
            int !vcsSNCL    - Flag to not show cmdline dialog ( True ).
            str !vcsCfg     - Contains the main vcs config options.
            str !vcsMsg     - Contains the status line message.
            str !vcsName    - Contains the vcs temp file name.
            str !vcsDlgMsg  - Contains the show cmdline dialog message.

  Macros  : str VersXlate
            int VcsEditStrDlg
            int ExecProg

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  int Result = True;
	int Flags = _ep_flags_NoBypass | _ep_flags_NoSavFile;

  str Cmd = Get_Path( Copy( CmdLine, 1, XPos( " ", CmdLine, 1 ) - 1 ) );
  str BDir = _BDIR_CMDL;

  if ( Svl( Cmd ) == 0 ) {
    if ( Svl( BDir ) ) {
      if ( Copy( BDir, Svl( BDir ), 1 ) != "\\" ) {
        BDir += "\\";
      }
      CmdLine = BDir + CmdLine;
    }
  }
  CmdLine = VersXlate( CmdLine, vcsFName, vcsAFile );
  Error_Level = 0;
  if ( vcsSNCL ) {
    if ( Check_Key && ( ( Key1 == 27 ) && ( Key2 == 1 ) ) ) {
      Result = False;
    }
  }
  else if ( _SHOW_CMD ) {
    Result = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Result ) {
    Set_File_Attr( vcsName, 0 );
    Del_File( vcsName );                // Erase tmp capture file
    Result = False;
    Working;
    Make_Message( vcsMsg );
    Error_Level = ExecProg( CmdLine, vcsPrjDir, vcsName, vcsName, Flags );
    switch ( Error_Level ) {

      case _Exec_Abort :
        Error_Level = 0;
        break;

      case _Exec_Error :
        Error_Level = ExecErrorCode;
        break;

      case _Exec_Success :
        Error_Level = 0;
        switch ( ExecId ) {

          case _Exe_Id_Windows :
            VersParseErr( );

          case _Exe_Id_Dos :
          case _Exe_Id_Os2 :
					case _Exe_Id_Nt :
            Error_Level = ExecReturnCode;
            if ( Error_Level == 0 ) {
              Result = True;
              break;
            }

          default :
            Error_Level += 9000;
        }
    }
  }
  vcsDlgMsg = "";
  return ( Result );

}  // VersExec

str VersXlate(
        str Path = Return_Str,
        str FName = Parse_Str( "/F=", MParm_Str ),
        str LPath = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:26

  Name    : VersXlate

  Function: Place holder for adding code to implement any VERS specific
            tranlation metacommands. Calls VcsXlate to finish the translations.

  Syntax  : Path = VersXlate( Path, FName, LPath );

  Entry   : str Path            - The string to be translated.
            str FName           - The work file name.
            str LPath           - The VERS archive path.

  Exit    : str ( Return_Str )  - The expanded command line.

  Globals : none

  Macros  : str VcsXlate

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  return ( VcsXlate( Path, FName, LPath ) );

}  // VersXlate

str VersExt( str FName = Parse_Str( "/F=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:27

  Name    : VersExt

  Function: Takes a filename extension and converts it to the equivalent VERS
            extension.

  Syntax  : VersExt( str FName );

  Entry   : str FName     - Filename for which the extension is translated.

  Exit    : str           - The vcs file extension based upon LIBEXT.

  Globals : none.

  Macros  : none.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  return ( Get_Extension( FName ) );

}  // VersExt

int VersChkLib(
        str Path = Parse_Str( "/P=", MParm_Str ),
        str FName = Parse_Str( "/F=", MParm_Str ),
        int Pm = Parse_Int( "/M=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:27

  Name    : VersChkLib

  Function: Search "Path" for the VERS archive for "FName" based upon "Pm".

  Syntax  : LibFnd = VersChkLib( Path, FName, Pm );

  Entry   : gstr !vcsID - The name of the currently selected vcs package.
            str  Path   - Contains the search path.
            str  FName  - The filename for which to find archive.
            int  Pm     - Path Mode.
              -2        - Check for and return archive file only.
              -1        - Check for and return archive file,
                          iff no file return 1st lib path.
               0        - Return full archive path.
              +#        - Return # directory from archive path.

  Exit    : int ( gint !vcsRInt )
              #                 - File was found in # path.
                gstr !vcsAFile  - The found archive filename or path.
              0                 - File NOT found.
                gstr !vcsAFile  - The archive path based upon pm.
                                  ( Not set if Pm == -2 ).

  Globals : str !vcsID    - The name of the currently selected vcs package.
            int !vcsRInt  - The return integer.
            str !vcsAFile - The found archive filename or path.

  Macros  : int VcsGetPath

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  vcsRInt = False;
  if ( ( Path == _LIB_PATH ) && ( _DO_CD == 2 ) ) {
    Path = "<LOOKUP>";
  }
  return ( vcsRInt = VcsGetPath( Path, FName, VersExt( FName ), Pm ) );

}  // VersChkLib

str VersGetFName( str LibFile = Parse_Str( "/P=", MParm_Str ) ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:27

  Name    : VersGetFName

  Function: Returns the work file name extracted from the archive "LibFile" or
            "" when archive doesn't exist.

  Syntax  : FName = VersGetFName( LibFile );

  Entry   : str LibFile           - archive file name

  Exit    : str ( gstr !vcsRStr ) - The workfile_name or "".

  Globals : str !vcsRStr          - The return string.

  Macros  : none

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  vcsRStr = LibFile;
  return ( vcsRStr );

}  // VersGetFName

int VersChkLock( ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:28

  Name    : VersChkLock

  Function: Check to see if a archive file is locked.

            Note: The VERS support doesn't support this at this time, thus it
                  always returns False (not locked).

  Syntax  : Locked = VersChkLock( );

  Entry   : none.

  Exit    : int
              True      - Archive file locked.
              False     - Archive file not locked.

  Globals : none.

  Macros  : none.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  return ( False );

}  // VersChkLock

macro VersDir Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Sep-94  01:30

  Name    : VersDir

  Function: Displays directory listing of VERS archive files.  Allows user to
            select a file to be retrieved for modification, viewing only, or
            listing the version history.

  Syntax  : Rm( "VersDir /C=Cmd/RC" );

  Entry   : /C=str        - Command to execute ( ie GET, BROWSE or LIST ).
            /RC           - Repeat command until <ESC>.

  Exit    : none.

  Globals : none.

  Macros  : mac VcsFile

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str User = VersGetUser( );

  VcsGetPath( _LIB_PATH, FExpand( "*.*" ), "", 1 );
  VcsFileDlg( "(VERS) Archive Files", vcsAFile + "*.*", User );

}  // VersDir

macro VersIActive Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:29

  Name    : VersIActive

  Function: Runs the "menu command line" that is contained in "!versCfg" global
            variable.

  Syntax  : Rm( "VersIActive" );

  Entry   : none.

  Exit    : none.

  Globals : str !versCfg - Contains the commands/setup options for VERS.

  Macros  : int WinExecAndWait

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str CmdLine = _MENU_CMDL;
  str Cmd = Get_Path( Copy( CmdLine, 1, XPos( " ", CmdLine, 1 ) - 1 ) );
  str BDir = _BDIR_CMDL;

  if ( Svl( Cmd ) == 0 ) {
    if ( Svl( BDir ) ) {
      if ( Copy( BDir, Svl( BDir ), 1 ) != "\\" ) {
        BDir += "\\";
      }
      CmdLine = BDir + CmdLine;
    }
  }
  if ( _SHOW_CMD ) {
    vcsDlgMsg = "(VERS) Run Interactive Command Line";
    Return_Int = VcsEditStrDlg( vcsDlgMsg, CmdLine, False );
  }
  if ( Return_Int ) {
//    WinExecAndWait( CmdLine, "", _EP_Flags_DontWait, "", "" );
		ExecProg( CmdLine, "", "", "", _EP_Flags_DontWait | _EP_Flags_SkipExec );
  }
}  // VersIActive

macro VersLogin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:30

  Name    : VersLogin

  Function: Check if a user is logged in ( Not supported in VERS ).

  Syntax  : Rm( "VersLogin" );

  Entry   : none.

  Exit    : none.

  Globals : none.

  Macros  : none.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

}  // VersLogin

macro VersAdminPrj Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:30

  Name    : VersAdminPrj

  Function: Create, edit and delete entries in the user's administer project
            database for VERS.

  Syntax  : Rm( "VersAdminPrj" );

  Entry   : none.

  Exit    : none.

  Globals : str !versLUT - The contents of the current db record.

  Macros  : mac VersChkAdmin

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  g_VersLUT = "";                          // clear global lookup variable
  DB( _VCS_DB, "VERS.VAD", "MEWHDRS.DB", "VCSVAD.HDR",
      "(VERS) Associate Directories",
      "(VERS) Associate Directories Setup",
      "!VAD", 0,
      "/BMP=BT_VCS_102/NDF=1/PRE=!VAD/H=" + hc_vcs_Admin +
          "/DIRB=1/CP=New File Directory:/MOVE=1/MACRO=VersChkAdmin" );

}  // VersAdminPrj

str VersLookup(
        str FName = Parse_str( "/F=", MParm_Str ),
        str Field1 = Parse_Str( "/F1=", MParm_Str ),
        str Field2 = Parse_Str( "/F2=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:30

  Name    : VersLookup

  Function: Returns the string in "Field2" of the VERS administer project
            database when the directory of "FName" matches a string in
            "Field1".

  Syntax  : Str_Val = VersLookup( FName, Field1, Field2 );

  Entry   : str FName  - The filename to extract the directory name from.
            str Field1 - The field name of the field to match the directory to.
            str Field2 - The field name fo the field to return the string from.

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match or Field2 empty.
              [Field2]    - Contents of Field2 when match found.

            gstr !versLUT  - Contains the found record.

  Globals : str !vcsRStr  - The return string.
            str !versLUT   - The contents of the matched db record.

  Macros  : int DbGetRecord

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  int Result = True;

  vcsRStr = "";
  FName = Caps( Get_Path( FName ) );
  if ( FName != Parse_Str( "\x7F" + Field1 + "=", g_VersLUT ) ) {

    int Cnt = 0;
    int OrgWin = Window_Id;
    int TRefresh = Refresh;
    int Flags = _dbf_NoDelWin | _dbf_NoSwitchWin;

    str ADField = "\x7F" + "AD=";
    str DbName = _VCS_DB;
    str TStr;
    str SFName = FName;

    Result = False;
    Refresh = False;
    g_VersLUT = "";
    while ( DbGetRecord( DbName, "VERS.VAD", Field1, FName, Cnt, Flags, "" ) ==
        _NoError ) {
      if ( g_VersLUT != "" ) {
        TStr =  Parse_Str( ADField, g_VersLUT ) + ";" +
            Parse_Str( ADField, FName );
        Return_Str = ADField;
        Rm( "ChngParm /G=!VersLUT/P=" + TStr );
      }
      else {
        g_VersLUT = FName;
        if ( Field1 == "AD" ) {
          break;
        }
      }
      Flags =  _dbf_NoDelWin | _dbf_NoSwitchWin | _sf_Position;
      FName = SFName;
      DbName = "";
      Result = True;
    }
    Switch_Win_Id( OrgWin );
    Refresh = TRefresh;
  }
  if ( Result ) {
    vcsRStr = Parse_Str( "\x7F" + Field2 + "=", g_VersLUT );
    if ( Field1 == "AD" ) {
      g_VersLUT = "";
    }
  }
  return ( vcsRStr );

}  // VersLookup

str VersCfgFile(
        str FName = Parse_Str( "/F=", MParm_Str ),
        str Param = Parse_Str( "/P=", MParm_Str )
    ) Trans2 {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:31

  Name    : VersCfgFile

  Function: Parse and return the value for Param from the VERS.RC file.
            (Note: this function currently uses the <LOOKUP> function until the
            code is actually written and tested to parse the VERS.RC file)

  Syntax  : Str_Val = VersCfgFile( FName, Param );

  Entry   : str FName   - The filename to extract the directory name from
            str Param   - The parameter to parse for the return string

  Exit    : str ( gstr !vcsRStr )
              ""          - Empty string if no match
              [Param]     - Contents of Param from config file when match found

  Globals : str !vcsRStr  - The return string
            str !versCfg

  Macros  : str VersLookUp
            str VersGetUser

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  vcsRStr = "";
  switch ( Param ) {
    case "ARCDIR" :
      vcsRStr = VersLookup( FName, "FD", "AD" );
      break;

    case "ARCEXT" :
      vcsRStr = _LIB_EXT;
      break;

    case "USER" :
      vcsRStr = VersGetUser( );
      break;

    case "WORKDIR" :
      vcsRStr = VersLookup( FName, "FD", "WD" );
      break;
  }
  return ( vcsRStr );

}  // VersCfgFile

macro VersChkAdmin Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:32

  Name    : VersChkAdmin

  Function: Called by the AdminPrj dialog to capitialize, check and update all
            directories to end with a \ when saving the data in the dialog.

  Syntax  : Called only by the DB macro when in the AdminPrj dialog.

  Entry   : Values passed by the DB macro.

  Exit    : updated data.

  Globals : none.

  Macros  : none.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  if ( Parse_Int( "/P=", MParm_Str ) != 0 ) {

    str GStr = Parse_Str( "/GLO=", MParm_Str );
    str TStr = Caps( Global_Str( GStr ) );

    int Len = Svl( TStr );
    int Jx = 1;

    while ( Jx < Len ) {
      if ( ( Jx = XPos( "\x7F", TStr, ++Jx ) ) == 0 ) {
        Jx = Len + 1;
      }
      if ( Pos( Copy( TStr, Jx - 2, 1 ), "=" ) == 0 ) {
        if ( Pos( Copy( TStr, Jx - 1, 1 ), ";>\\" ) == 0 ) {
          TStr = Str_Ins( "\\", TStr, Jx );
          Len = Svl( TStr );
        }
      }
    }
    Jx = 1;
    while ( Jx = XPos( ";", TStr, Jx ) ) {
      if ( Copy( TStr, Jx - 1, 1 ) != "\\" ) {
        TStr = Str_Ins( "\\", TStr, Jx );
      }
      ++Jx;
    }
    Set_Global_Str( GStr, TStr );
  }
}  // VersChkAdmin

void VersParseErr( ) Trans {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:32

  Name    : VersParseErr

  Function: Used to parse the captured file from a Windows executable.
            Note: Currently no Windows programs for VERS to support.

  Syntax  : VersParseErr( );

  Entry   : None.

  Exit    : gint ExecReturnCode - The error code for the executed windows program

  Globals : int ExecReturnCode

  Macros  : None.

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  ExecReturnCode = 100;                 // Return error not supported yet

}  // VersParseErr

str VersGetUser( ) {
/******************************************************************************
                               Multi-Edit Macro
                               29-Mar-95  13:32

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/

  str Result = Get_Environment( "VersionsFullName" );

  if ( Result == "" ) {
    Result = _VCS_USERID;
  }
  return ( Result );

}  // VersGetUser
