/*******************************************************************************
														MULTI_EDIT MACRO FILE

Name: USERIN  <-  USERIN2

Description:  - - Included by USERIN.S - -
							Most of the general purpose user input routines.

SPECCHAR        - Changes untypeable character into the |xx convention.
VALCHAR         - Changes the |xx back to a character.
STRSRC          - Formats strings to be used in macro source code generators.
CHNGPARM        - Changes a single slash type parameter(/) in a global string.
GLOBALVARLIST   - Creates a menu of global pseudo-array elements.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/


macro SPECCHAR TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  SPECCHAR

DESCRIPTION:  This is a general purpose string manipulator that changes
certain "unprintable" characters to the Multi-Edit macro language ASCII
Character representation for the purpose of displaying them in prompts.  The
string is passed to this macro via the standard ME parameter passing
convention, and the result is returned in Return_Str.  This macro now simply
executes the function _SpecChar, which is in USERIN1.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	return_str = _SpecChar( mparm_Str );
}


macro VALCHAR TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  VALCHAR

DESCRIPTION:  This is a general purpose string manipulator that changes
any occurance of the '|' character, indicating the presence of a numeric
representation of an ASCII character and converting it to that character.
The string is passed to this macro via the standard ME parameter passing
convention, and the result is returned in Return_Str.  This now simply calls
 _ValChar in userin1.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	return_str = _ValChar( mparm_str );
}

macro STRSRC TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  STRSRC

DESCRIPTION:  This is a general purpose string manipulator that changes
any occurance of a "|" or a "'" character, which was entered by a user in a
prompt, so that the part of the setup that saves the settings by generating
macro source code will be able to generate string literals properly.
The string is passed to this macro via the standard ME parameter passing
convention, and the result is returned in Return_Str

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str Tstr;
	int JX,Jy;
	TStr = MParm_Str;
	jx = 1;
CHECKQ:
	jx = XPOS('''',TStr,jx);
	if(  jx != 0  ) {
		TStr = Str_Ins('''',TStr,jx);
		jx = jx + 2;
		goto CHECKQ;
	}

	/* Create double bars */
	jx = 1;
CHECKQ2:
	jx = XPOS('||',TStr,jx);
	if(  jx != 0  ) {
		if(  (JX == Length(TStr)) |
			 (XPOS(Copy(TStr,jx+1,1),'0123456789|',1) == 0)  ) {
			TStr = Str_Ins('||',TStr,jx);
		}
		jx = jx + 2;
		goto CHECKQ2;
	}
	Return_Str = Tstr;
	RM('SPECCHAR '+ Return_Str);
}

macro CHNGPARM TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

DESCRIPTION:
This macro is designed to change any "/X=" type parameter in any global string.
It should work for any parameter delimiters.  If the parameter does not exist
in the string, it will add it to the end of the string.

/G=           The global string name
Return_Str    The parameter syntax(Because this is a "/x=" type of parameter,
it cannot be a part of MParm_Str(it would be impossible to parse out unless we
used different parameter delimiters, which would be inconsistent)
/P=           The new parameter

Example:

	Set_Global_Str("TEST","/X=1/Y=2/Z=3");
	Return_Str = "/Y=";
	RM("CHNGPARM /G=TEST/P=10");

Global_Str("TEST") will now be: "/X=1/Y=10/Z=3"

As this macro is not particularly efficient, it should only be used in cases
of extremely long strings of parameters where only one parameter is being
changed and complete rebuilding of the string would take longer.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str g_name[20] = Parse_Str('/G=',MParm_Str),
			g_str[max_line_length] = Global_Str(g_name);

	Return_Int = XPos(Return_Str,G_Str,1);
	if (Return_Int) {
		var_remove_str(return_str,g_str);
	} else {
		Return_Int = svl(g_str) + 1;
	}

	Set_Global_Str(g_name,
				str_ins(return_str + parse_str("/P=",Mparm_str),g_str,return_int));
}

macro GLOBALVARLIST TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  GLOBALVARLIST

DESCRIPTION:  Creates a menu of global string "array elements".  This is
							assuming the use of globals as pseudo arrays by having the last
							part of the global name numeric characters and therefore can be
							referenced sequentially using a counter.
								Example:
									Global_Str('TEST1');
									Global_Str('TEST2');
									Global_Str('TEST3');
							In the above example, "TEST" would be considered the base, and 1,
							2, and 3 would be the value of the index to reference each element.

PARAMETERS:
							/G= The base name of the globals
							/#= The amount of elements
							/SC=n the starting cursor pos (default = 1);

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  old_win, jx, old_refresh, count, reverse ;
	str  gstr[20], event_str[20] ;

	old_win = window_id;
	old_refresh = refresh;
	refresh = FALSE;
	switch_window( window_count );
	create_window;
	window_attr = $80;
	count = parse_int('/#=', mparm_str);
	gstr = parse_str('/G=',mparm_str);
	reverse = parse_int('/REV=', mparm_str);
	if(  reverse  ) {
		jx = count;
	} else {
		jx = 1;
	}
	while(  c_line <= count  ) {
		put_line( global_str( gstr + str(jx) ) );
		if(  reverse  ) {
			--jx;
		} else {
			++jx;
		}
		down;
	}
	tof;
	goto_line(parse_int('/SC=', mparm_str));
	event_str = str(global_int('MENU_LEVEL')) + 'GV';
	set_global_str(event_str + 'IPARM_1', '/DC=1/TP=15/L=0/C=1/MW=29/WIN=' + str(cur_window));
	RM( 'DATA_IN /T=HISTORY/#=1/A=2/PRE=' + event_str +
			'/X=' + parse_str('/X=', mparm_str) + '/Y=' + parse_str('/Y=', mparm_str) +
			'/H=' + parse_str('/H=', mparm_str)
		);
	refresh = false;
	return_str = get_line;
	delete_window;
	switch_win_id( old_win );
	refresh = old_refresh;
}

macro DELETEITEM TRANS2 {
/*******************************************************************************
																MULTI_EDIT MACRO

NAME:  DELETEITEM

DESCRIPTION: Performs a "shuffle" of global variables used as arrays to fill
in the gap caused by the deletion of a single element.

PARAMETERS:
						/G= The name of the "base" of the global variable.
						/#= The total amount of array elements.
						/T= The type of global 0=string 1=integer.
						Return_Int the starting point to begin shuffling.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  jx, count, type ;
	str  gstr[20] ;
	gstr = parse_str('/G=', mparm_str);
	count = parse_int('/#=', mparm_str);
	type = parse_int('/T=', mparm_str);
	jx = return_int;
	while(  jx <= count  ) {
		if(  type == 0  ) {
			set_global_str( gstr + str(jx), global_str( gstr + str(jx + 1)));
		} else {
			set_global_int( gstr + str(jx), global_int( gstr + str(jx + 1)));
		}
		++jx;
	}
	return_int = count - 1;
}