// $Header: /MeWin/Src/UPDATE.S 23    3/05/96 14:15 Dan $

macro_file UPDATE;

#include METOOLS.SH
#include DBTOOLS.SH
#include MEW.SH
#include MENUS.SH
#include DIALOG.SH
#include WINDOWS.SH
#include FPROMPT.SH
#include WINEXEC.SH
#include MEWLIB.SH
#include MEW_BTN.SH
#include STDDLGS.SH
#include UPDATE.SH

#ifdef _DEBUG_
  #include MSGLOG.SH
#endif

void Update( str FName[ 128 ] = Parse_Str( "/F=", MParm_Str ) )
/******************************************************************************
															 Multi-Edit Macro
															 27-Jan-95  14:49

	Name    :
	Function:
	Syntax  :
	Entry   :
	Exit    :
	Globals :
	Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int TBackups = Backups;
	int CmdMapWin = 0;
	int SrcWin = 0;
	int DelSrcFile = False;
	int DbFWin = 0;
	int DelDbFile = True;
	int LogWin = 0;
	int DelLogWin = True;
	int LogWinNo;
	int Result;

	int DotFunc;
	int DotQuit = False;
	int DotStop = 0;
	int DefFlags;
	int Flags;
	int Jx;
	int Update;
	int WCmdIndex = 0;
	int DbRec;
	int MLevel;
	int MWCmd;
	int TWCmd;
	int FCreate = False;
	int DotIfRc = 0;
	int RcTrue = False;
	int LogLine = 0;
	int BaseErr = _BaseErr_DbTools;
	int DefLogStat = g_InsLogOn;
	int BtnNo;
	int BWCmd;

	int hDlg;

	str DbFile[ 128 ] = WCmdMapName;
	str DbPage[ 80 ] = "";
	str DbData[ Max_Line_Length ];
	str DbSection;
	str DbCmd[ 1024 ];
	str DbMenu;
	str TStr[ Max_Line_Length ];
	str CmdLine[ Max_Line_Length ];
	str TField;
	str DotCmd;
	str DbFields;
	str Exclude;
	str WCmdStr = _db_Delimit + _db_cmd_WCmd + "=";
	str Msg;
	str LogMsg[ Max_Line_Length ];
	str TbxName[ 80 ] = "";
	str WrkDir = "";

	struct TWCmds WCmdsList;
	struct TMenus MenuStr;
	struct IfArray IfRc;
  struct TMsg WinMsg;

	if ( Svl ( FName ) == 0 ) {
		goto Exit;
	}
	Refresh = False;
	Backups = 0x81;
	Result = DbGetFile( DbFile );         // Load default CmdMap file
	CmdMapWin = Window_Id;
	DbFWin = Window_Id;

	// Create Output dialog
	hDlg = OutputDlgCreate( "Update", "", "", 80, 2, 0 );

	DelSrcFile = DbGetFile( FName );      // Load script file
	FName = File_Name;
	SrcWin = Window_Id;
	if ( Error_Level == 0 ) {
		// Create log file
		DelLogWin = DbGetFile( Truncate_Extension( FName ) + ".LOG" );
		Eof;
		LogWin = Window_Id;
		LogWinNo = Cur_Window;
		Error_Level = 0;
		if ( C_Line > 1 ) {
			LogLine = C_Line + 1;
		}
		Goto_Line( ++LogLine );
		LogMsg = "*** Start Log " + Date + " " + Time + " ***" ;
		Put_Line( LogMsg );
		Goto_Col( 1 );
		if ( !g_InsLogOn ) {
			File_Changed = False;
		}
		WCmdsList.Entries = 0;
		call SetDefaults;
		Switch_Win_Id( SrcWin );
		Tof;
		while ( !At_Eof && !DotQuit ) {
      CmdLine = Get_Line( );
      Tabs_To_Spaces( CmdLine );
      CmdLine = Remove_Space( CmdLine );
			Down;
			Goto_Col( 1 );
      if ( Copy( CmdLine, 1, 1 ) == ";" ) {	// Line comment
				continue;
			}
			if ( Jx = XPos( " ", CmdLine, 1 ) ) {
				DotCmd = Caps( Copy( CmdLine, 1, Jx - 1 ) );
				CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
			}
			else {
				DotCmd = Caps( CmdLine );
				if ( DotCmd == "" ) {		// Blank line are treated as line comments
					continue;
				}
			}
			if ( Copy( DotCmd, 1, 2 ) == "/*" ) {  // Start block comment
				++DotStop;
				continue;
			}
			if ( DotStop ) {
				if ( Copy( DotCmd, 1, 2 ) == "*/" ) {  // End block comment
					--DotStop;
				}
				continue;
			}
			if ( ( DotCmd == "IFRC" ) && ( !DotIfRc || RcTrue ) ) {
				IfRc.Active[ DotIfRc ] = RcTrue;
				++DotIfRc;
				RcTrue = False;
				if ( Jx = XPos( " ", CmdLine, 1 ) ) {
					DotCmd = Caps( Copy( CmdLine, 1, Jx - 1 ) );
					CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
					if ( Val( Jx, CmdLine ) == 0 ) {
						switch ( DotCmd ) {
							case "==" :
								if ( Result == Jx ) {
									RcTrue = True;
								}
								break;

							case "<" :
								if ( Result < Jx ) {
									RcTrue = True;
								}
								break;

							case ">" :
								if ( Result > Jx ) {
									RcTrue = True;
								}
								break;

							case "<=" :
								if ( Result <= Jx ) {
									RcTrue = True;
								}
								break;

							case ">=" :
								if ( Result >= Jx ) {
									RcTrue = True;
								}
								break;

							case "!=" :
								if ( Result != Jx ) {
									RcTrue = True;
								}
						}
					}
				}
				continue;
			}
			if ( DotIfRc ) {
				if ( DotCmd == "ELSE" ) {
					RcTrue = !RcTrue;
					continue;
				}
				else if ( DotCmd == "ENDIF" ) {
					--DotIfRc;
					RcTrue = IfRc.Active[ DotIfRc ];
					continue;
				}
				if ( !RcTrue ) {
					continue;
				}
			}
			BaseErr = _BaseErr_DbTools;
			Result = _NoError;
			switch ( DotCmd ) {
				case "QUIT" :                   // Quit processing script
					DotQuit = True;
					continue;
					break;

				case 'GSTR' :                   // Set global string variable
				case 'GINT' :                   // Set global integer variable
					if ( CmdLine != "" ) {
						if ( Jx = XPos( ' ', CmdLine, 1 ) ) {
							TField= Copy( CmdLine, 1, Jx - 1 );
//              TField = TranslateCmdLine( TField, "" );
							TStr = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
//              TStr = TranslateCmdLine( TStr, "" );
						}
						else {
							TField = CmdLine;
							TStr = '';
						}
						if ( DotCmd == 'GSTR' ) {
							Set_Global_Str( TField, TStr );
							break;
						}
						if ( !Val( Jx, TStr ) ) {
							Set_Global_Int( TField, Jx );
						}
					}
					break;

				case 'LOADMAC' :                // Load macro file
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						CmdLine = TranslateCmdLine( CmdLine, "" );
						LogMsg = 'Loading Macro ' + CmdLine;
						call WriteMsg;
						Load_Macro_File( CmdLine );
						Result = Error_Level;
						call WriteLogMsg;
					}
					break;

				case 'RUNMAC' :                 // Run macro
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						CmdLine = TranslateCmdLine( CmdLine, "" );
						Rm( CmdLine );
						Result = Return_Int;
						if ( Window_Id != SrcWin ) {
							Switch_Win_Id( SrcWin );
						}
						Refresh = False;
					}
					break;

				case 'COMPILE' :
					Result = _ErrorNoFile;
					if ( CmdLine != "" ) {
						CmdLine = TranslateCmdLine( CmdLine, "" );
						TField = "";
						if ( Copy( CmdLine, 1, 1 ) == "@" ) {
							CmdLine = Copy( CmdLine, 2, Svl( CmdLine ) - 1 );
							TField = "-L ";
						}
						LogMsg = "Compiling Macro " + CmdLine;
						call WriteMsg;
						if ( File_Exists( CmdLine ) == 1 ) {
							if ( g_InstallDir != "" ) {
								TStr = ";" + g_InstallDir;
							}
							else {
								TStr = "";
							}

              TStr = "CMACWIN.EXE -PMAC -ISRC" + TStr +
									" -O" + Truncate_Path( TempFileName( "MEERR.TMP" ) ) +
									" -WE " + TField + CmdLine ;
              Result = WinExecAndWait( TStr, Me_Path, _EP_Flags_NoBypass, "",
									"" );
						}
						call WriteLogMsg;
					}
					break;

				case 'EXEC' :
					Result = _ErrorNoFile;
					if ( CmdLine != "" ) {
						TStr = TempFileName( "MEERR.TMP" );
						CmdLine = TranslateCmdLine( CmdLine, "" );
						LogMsg = "Executing Program " + CmdLine;
						call WriteMsg;
						Result = ExecProg( CmdLine, WrkDir, TStr, TStr, _EP_Flags_NoBypass );
						call WriteLogMsg;
					}
					break;

				case 'MKDIR' :
				case 'MD' :
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						CmdLine = RemoveTrailingSlash(TranslateCmdLine( CmdLine, '' ));
						LogMsg = 'Making directory ' + CmdLine;
						call WriteMsg;
						Result = MkDir( CmdLine );
						BaseErr = _BaseErr_File;
						call WriteLogMsg;
					}
					break;

// 				case "RMDIR" :
// 				case "RD" :
// 					Result = _ErrorNoFile;
// 					if ( Svl( CmdLine ) == 0 ) {
// 						CmdLine = TranslateCmdLine( CmdLine, "" );
// 						if ( Copy( CmdLine, Svl( CmdLine ), 1 ) == "\\" ) {
// 							CmdLine = Copy( CmdLine, 1, Svl( CmdLine ) - 1 );
// 						}
// 						LogMsg = "Removing directory " + CmdLine;
// 						call WriteMsg;
// 						Result = RmDir( CmdLine );
// 						BaseErr = _BaseErr_File;
// 						call WriteLogMsg;
// 					}
// 					break;

				case 'COPYFILE' :
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						Jx = XPos( ' ', CmdLine, 1 );
						if ( Jx ) {
							TStr = Copy( CmdLine, 1, Jx - 1 );
              TStr = TranslateCmdLine( TStr, '' );
							CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
              CmdLine = TranslateCmdLine( CmdLine, '' );
							Working;
							LogMsg = 'Copying ' + TStr + ' -> ' + CmdLine;
							call WriteMsg;
							Result = Copy_File( TStr, CmdLine, False );
							BaseErr = _BaseErr_File;
							call WriteLogMsg;
						}
					}
					break;

				case 'DELFILE' :
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						CmdLine = TranslateCmdLine( CmdLine, '' );
						LogMsg = 'Deleting ' + CmdLine;
						call WriteMsg;
						Del_File( CmdLine );
						Result = Error_Level;
						BaseErr = _BaseErr_File;
						call WriteLogMsg;
					}
					break;

				case 'RENFILE' :
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						Jx = XPos( ' ', CmdLine, 1 );
						if ( Jx ) {
							TStr = Copy( CmdLine, 1, Jx - 1 );
              TStr = TranslateCmdLine( TStr, '' );
							CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
              CmdLine = TranslateCmdLine( CmdLine, '' );
							LogMsg = 'Rename ' + TStr + ' -> ' + CmdLine;
							call WriteMsg;
							Result = Rename_File( TStr, CmdLine );
							BaseErr = _BaseErr_File;
							call WriteLogMsg;
						}
					}
					break;

				case 'LOADFILE' :
					Result = _ErrorNoFile;
					if ( CmdLine != '' ) {
						Return_Str = TranslateCmdLine( CmdLine, '' );
						Rm( 'LdFiles /CW=2' );
						Result = Error_Level;
						if ( Window_Id != SrcWin ) {
							OrgWin = Window_Id;
							Switch_Win_Id( SrcWin );
						}
						Refresh = False;
					}
					break;

				case "REGDLL" :
					Result = _ErrorNoFile;
					if ( CmdLine != "" ) {
						CmdLine = TranslateCmdLine( CmdLine, "" );
						LogMsg = 'Registering DLL ' + CmdLine;
						call WriteMsg;
						if ( File_Exists( Me_Path + CmdLine + ".DLL" ) == 1 ) {
							Jx = MEW_RegisterDLL( CmdLine );
							if ( Jx ) {
								RegisterMEWResource( Jx );
							}
							Result = _NoError;
						}
						call WriteLogMsg;
					}
					break;

				case "DELPAGE" :
					Result = _ErrorNoDbPage;
					if ( CmdLine != "" ) {
						CmdLine = TranslateCmdLine( CmdLine, '' );
						LogMsg = 'Deleting Page ' + CmdLine;
						call WriteMsg;
						Flags = DefFlags;
						Result = DbDelPage( DbFile, CmdLine, Flags );
						call WriteLogMsg;
					}
					break;

				case 'DAT' :
					Flags = DefFlags;
					TField = '';
					TStr = '';
					if ( Jx = XPos( '=', CmdLine, 1 ) ) {
						TField = Copy( CmdLine, 1, Jx );
						TStr = Parse_Str( TField, CmdLine );
						TField = Copy( CmdLine, 2, Jx - 2 );
					}
					LogMsg = Msg + DbPage + ' Data - ' + TStr;
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							if ( Jx = XPos( '=', DbData, 1 ) ) {
								TField = Copy( DbData, 1, Jx );
								TStr = Parse_Str( TField, DbData );
								TField = Copy( DbData, 2, Jx - 2 );
							}
							Result = DbPutRecord( DbFile, DbPage, TField, TStr, DbRec, Flags,
									DbFields, CmdLine );
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update );
								Msg = 'Adding ';
								if ( XPos( TField, TStr, 1 ) ) {
									LogMsg = ' - ' + TStr;
								}
							}
							break;

						case _dbu_Func_Delete :
							Result = DbDelRecord( DbFile, DbPage, TField, TStr, DbRec, Flags,
									'' );
							CmdLine = '';
							DbRec = 0;
							LogMsg = ' - ' + TStr;
							break;
					}
					call WriteLogMsg;
					DbData = CmdLine;
					break;  // Dat


				case 'SEC' :
					DbCmd = '';
					DefFlags &= 0xFFFF ^ _sf_Position;
					Jx = XPos( '=', CmdLine, 1 );
					if ( Jx ) {
						CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
					}
					Flags = DefFlags;
					TStr = DbSection;
					LogMsg = Msg + 'Section - ' + CmdLine;
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							Result = DbPutCmdSection( DbFile, TStr, Flags, CmdLine );
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update );
								Msg = 'Adding ';
								if ( TStr != DbSection ) {
									LogMsg = ' - ' + TStr;
								}
							}
							break;

						case _dbu_Func_Delete :
							Result = DbDelCmdSection( DbFile, CmdLine, Flags );
							LogMsg = ' - ' + CmdLine;
							CmdLine = '';
							break;
					}
					call WriteLogMsg;
					DbSection = CmdLine;
					break;  // Sec

				case 'CMD' :
					TStr = DbCmd;
					Flags = DefFlags;
					LogMsg = Msg + DbSection + ' Cmd - ' +
							Parse_Str( _db_Delimit + _db_cmd_Name + '=', CmdLine );
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							WCmdsList.Old[ WCmdIndex ] = Parse_Int( WCmdStr, CmdLine );
							Result = DbPutCmd( DbFile, DbSection, DbCmd, Flags, CmdLine,
									DbFields );
							if ( Result <= _NoError ) {
								WCmdsList.New[ WCmdIndex ] = Flags;
								++WCmdIndex;
								WCmdsList.Entries = WCmdIndex;
							}
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update |
										_sf_Position );
								if ( DbCmd != TStr ) {
									LogMsg = ' - ' + DbCmd;
								}
								TStr = '';
								DbUpdateFields( CmdLine, WCmdStr + Str( Flags ), WCmdStr );
								Msg = 'Adding ';
							}
							break;

						case _dbu_Func_Delete :
							Result = DbDelCmd( DbFile, DbSection, CmdLine, Flags );
							LogMsg = ' - ' + CmdLine;
							CmdLine = '';
							break;
					}
					call WriteLogMsg;
					DbCmd = CmdLine;
					if ( TStr != '' ) {
						DefFlags |= _sf_Position;
					}
					break;  // Cmd

				case 'MNU' :
					TWCmd = Parse_Int( WCmdStr, CmdLine );
					Flags = DefFlags;
					if ( TWCmd && ( TWCmd != _db_mnu_SepWCmd ) ) {
						for ( Jx = 0; Jx < WCmdsList.Entries; ++Jx ) {
							if ( TWCmd == WCmdsList.Old[ Jx ] ) {
								TWCmd = WCmdsList.New[ Jx ];
								DbUpdateFields( CmdLine, WCmdStr + Str( TWCmd ), WCmdStr );
								break;
							}
						}
					}
					DbRec2Menu( LogMsg, TWCmd, Jx, CmdLine );
          for ( Jx = TWCmd - 1; Jx > 0; --Jx ) {
						switch ( Jx ) {
							case 1 :
								TStr = MenuStr.Menu1;
								break;

							case 2 :
								TStr = MenuStr.Menu2;
								break;

							case 3 :
								TStr = MenuStr.Menu3;
								break;
						}
						if ( TStr != '' ) {
							LogMsg = TStr + ' - ' + LogMsg;
						}
					}
					LogMsg = Msg + DbPage + ' Menu - ' + LogMsg;
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							Result = DbPutMenu( DbFile, DbPage, MenuStr, MLevel, MWCmd, Flags,
									CmdLine );
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update );
								CmdLine = '';
								Msg = 'Adding ';
							}
							break;

						case _dbu_Func_Delete :
							MWCmd = Parse_Int( _db_Delimit + _db_mnu_WCmd + '=', CmdLine );
							Result = DbDelMenu( DbFile, DbPage, MenuStr, MLevel, MWCmd, Flags );
							CmdLine = '';
							break;
					}
					call WriteLogMsg;
					if ( Result == _NoError ) {
						DbRec2Menu( TStr, MLevel, MWCmd, CmdLine );
						if ( MWCmd == _db_mnu_SepWCmd ) {
							TStr = '';
							MLevel = 1;
							MWCmd = 0;
						}
						switch ( MLevel ) {
							case 1 :
								MenuStr.Menu1 = TStr;
								break;

							case 2 :
								MenuStr.Menu2 = TStr;
								break;

							case 3 :
								MenuStr.Menu3 = TStr;
								break;

							case 4 :
								MenuStr.Menu4 = TStr;
								break;
						}
					}
					MWCmd = 0;
					break;  // Mnu

				case 'TBX' :
					call SetBtnDefaults;
					Flags = DefFlags;
					TStr = Parse_Str( _db_Delimit + _db_tbx_BoxId + "=", CmdLine );
					LogMsg = Msg + 'ToolBox - ' + TStr;
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							Result = DbPutToolBox( DbFile, TbxName, Flags, CmdLine, DbFields );
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update );
								Msg = 'Adding ';
								if ( TbxName != '' ) {
									LogMsg = ' - ' + TbxName;
								}
							}
							break;

						case _dbu_Func_Delete :
							Result = DbDelToolBox( DbFile, TStr, Flags );
							LogMsg = ' - ' + TStr;
							CmdLine = '';
							break;
					}
					call WriteLogMsg;
					TbxName = Parse_Str( _db_Delimit + _db_tbx_BoxId + "=", CmdLine );
					break;  // Tbx

				case 'BTN' :
					Flags = DefFlags;
					TStr = TbxName;
					TWCmd = Parse_Int( _db_Delimit + _db_tbb_WCmd + '=', CmdLine );
					if ( TWCmd && ( TWCmd != _db_mnu_SepWCmd ) ) {
						for ( Jx = 0; Jx < WCmdsList.Entries; ++Jx ) {
							if ( TWCmd == WCmdsList.Old[ Jx ] ) {
								TWCmd = WCmdsList.New[ Jx ];
								break;
							}
						}
					}
					LogMsg = Msg + TbxName + ' Button - ' + Str( TWCmd );
					call WriteMsg;
					switch ( DotFunc ) {
						case _dbu_Func_Add :
							Result = DbPutTBButton( DbFile, TStr, BWCmd, BtnNo, Flags,
									TWCmd );
							if ( DefFlags & ( _dbf_ReplaceRec | _dbf_Update ) ) {
								DefFlags &= 0xFFFF ^ ( _dbf_ReplaceRec | _dbf_Update );
								Msg = 'Adding ';
								LogMsg = ' - ' + Str( BWCmd );
							}
							break;

						case _dbu_Func_Delete :
							Result = DbDelTBButton( DbFile, TStr, TWCmd, BtnNo, Flags );
							LogMsg = ' - ' + Str( TWCmd );
							TWCmd = 0;
							BtnNo = 0;
							break;
					}
					call WriteLogMsg;
					BWCmd = TWCmd;
					break;  // Btn

				case 'SET' :
					if ( Jx = XPos( ' ', CmdLine, 1 ) ) {
						DotCmd = Caps( Copy( CmdLine, 1, Jx - 1 ) );
						CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
					}
					else {
						DotCmd = Caps( CmdLine );
						CmdLine = '';
					}
					if ( ( Update = ( DotCmd == 'UPDATE' ) ) ||
							( DotCmd == 'REPLACE' ) ) {
						DotFunc = _dbu_Func_Add;
						DefFlags |= _dbf_ReplaceRec;
						if ( Update ) {
							DefFlags |= _dbf_Update;
							Msg = 'Updating ';
						}
						else {
							Msg = 'Replacing ';
						}
						if ( Jx = XPos( ' ', CmdLine, 1 ) ) {
							DotCmd = Caps( Copy( CmdLine, 1, Jx - 1 ) );
							CmdLine = Copy( CmdLine, Jx + 1, Svl( CmdLine ) - Jx );
						}
						else {
							DotCmd = Caps( CmdLine );
							CmdLine = '';
						}
					}
					switch ( DotCmd ) {
						case 'CREATE' :
							if ( Caps( CmdLine ) == 'TRUE' ) {
								DefFlags |= _dbf_CreatePage;
								FCreate = True;
							}
							else {
								DefFlags &= 0xFFFF ^ _dbf_CreatePage;
								FCreate = False;
							}
							break;

						case 'INSERT' :
							if ( Caps( CmdLine ) == 'BEFORE' ) {
								DefFlags |= _dbf_InsertBefore;
							}
							else {
								DefFlags &= 0xFFFF ^ _dbf_InsertBefore;
							}
							break;

						case 'DUPS' :
							if ( Caps( CmdLine ) == 'TRUE' ) {
								DefFlags &= 0xFFFF ^ _dbf_NoDups;
							}
							else {
								DefFlags |= _dbf_NoDups;
							}
							break;

						case 'FUNC' :
							if ( Caps( CmdLine ) == 'DELETE' ) {
								DotFunc = _dbu_Func_Delete;
								Msg = 'Deleting ';
							}
							else {
								DotFunc = _dbu_Func_Add;
								Msg = 'Adding ';
							}
							DbRec = 0;
							BtnNo = 0;
							break;

						case 'LOG' :
							if ( Caps( Copy( CmdLine, 1, 3 ) ) == "MSG" ) {
								LogMsg = Copy( CmdLine, 5, Svl( CmdLine ) - 4 );
								call WriteMsg;
							}
							else {
								switch ( Caps( CmdLine ) ) {
									case 'RESET' :
										g_InsLogOn = DefLogStat;
										break;

									case 'ON' :
										g_InsLogOn = True;
										break;

									default:
										g_InsLogOn = False;
								}
							}
							break;

						case 'WRKDIR' :
							WrkDir = TranslateCmdLine( CmdLine, "" );
							break;

						case 'FILE' :
							Result = _ErrorNoFile;
							CmdLine = TranslateCmdLine( CmdLine, "" );
							if ( CmdLine == '' ) {
								CmdLine = WCmdMapName + ".DB";
							}
							if ( CmdLine != DbFile ) {
								if ( DbFWin != CmdMapWin ) {
									if ( Switch_Win_Id( DbFWin ) ) {
										if ( DelDbFile ) {
											DbToolsExit( _NoError, 0, CmdMapWin );
										}
										else {
											if ( File_Changed ) {
												Save_File;
											}
										}
									}
								}
								DbFile = CmdLine;
								LogMsg = 'Opening ' + DbFile;
								call WriteMsg;
								DelDbFile = DbGetFile( DbFile );
								if ( Error_Level && !FCreate && DelDbFile ) {
									Delete_Window;
									DbFile = WCmdMapName;
									DbFWin = CmdMapWin;
									Result = _ErrorNoFile;
								}
								else {
									DbFWin = Window_Id;
									Result = _NoError;
								}
								call WriteLogMsg;
								Switch_Win_Id( SrcWin );
							}
							break;

						case 'PAGE' :
							DbPage = TranslateCmdLine( CmdLine, "" );
							call SetDefaults;
							break;

						case 'FIELDS' :
							if ( CmdLine == '' ) {
								Exclude = '';
								DbFields = '';
							}
							else {
								Exclude = '/' + Caps( Copy( CmdLine, 1, 1 ) );
								if ( Exclude != '/X' ) {
									Exclude = '';
								}
								DbFields = Exclude + '/F=' + Copy( CmdLine, 3, Svl( CmdLine ) - 2 );
							}
							break;

						case 'RECNO' :
							Val( DbRec, CmdLine );
							DbData = '';
							break;

						case 'DAT' :
							DbData = CmdLine;
							DefFlags &= 0xFFFF ^ _sf_Position;
							break;

						case 'SEC' :
							DbSection = CmdLine;
							DbCmd = '';
							DefFlags &= 0xFFFF ^ _sf_Position;
							break;

						case 'CMD' :
							DbCmd = CmdLine;
							DefFlags &= 0xFFFF ^ _sf_Position;
							break;

						case 'MNU' :
							MWCmd = Parse_Int( '/WCMD=', CmdLine );
							MLevel = Parse_Int( '/IN=', CmdLine );
							MenuStr.Menu1 = Parse_Str( '/1=', CmdLine );
							MenuStr.Menu2 = Parse_Str( '/2=', CmdLine );
							MenuStr.Menu3 = Parse_Str( '/3=', CmdLine );
							MenuStr.Menu4 = Parse_Str( '/4=', CmdLine );
							DefFlags &= 0xFFFF ^ _sf_Position;
							break;

						case 'TBX' :
							TbxName = CmdLine;
// 							call SetTbxDefaults;
							call SetBtnDefaults;
							break;

						case 'BTNNO' :
							Val( BtnNo, CmdLine );
							BWCmd = 0;
							break;

						case 'BTN' :
							Val( BWCmd, CmdLine );
							DefFlags &= 0xFFFF ^ _sf_Position;
							break;

						case "ENDMAC" :
							if ( Svl( CmdLine ) != 0 ) {
								if ( Length( g_InsEndMac ) ) {
									g_InsEndMac += ";";
								}
								g_InsEndMac += TranslateCmdLine( CmdLine, "" );
							}
							break;
					}
					break;  // Set

				default:
					LogMsg = "Unknown command " + DotCmd;
					call WriteMsg;
			}
		}
	}
	Error_Level = 0;
	if ( DbFWin != CmdMapWin ) {          // Save DB file if not current CmdMap
		if ( Switch_Win_Id( DbFWin ) ) {
			if ( DelDbFile ) {
				DbToolsExit( _NoError, 0, CmdMapWin );
			}
			else {
				if ( File_Changed ) {
					Save_File;
				}
			}
		}
	}
	if ( Switch_Win_Id( CmdMapWin ) ) {   // Save and rebuild CmdMap
		if ( File_Changed ) {
			Save_File;
			OutputDlgMessage( hDlg, "Rebuilding CmdMap and Menus... Please Wait" );
			RebuildWCmds( );
      CmdMapWin = 0;
		}
	}
	if ( Switch_Win_Id( LogWin ) ) {      // Save Log file
		if ( File_Changed ) {
			Backups = 0;
			Save_File;
		}
		if ( DelLogWin ) {
			Delete_Window;
		}
	}
	if ( Switch_Win_Id( SrcWin ) ) {
		if ( DelSrcFile ) {
			Delete_Window;
		}
	}
	Switch_Win_Id( OrgWin );
  if ( !CmdMapWin ) {
    Rm( "WinOp /T=15" );
  }
	Backups = TBackups;
	Refresh = TRefresh;

Exit:
	// Kill output message dialog
	OutputDlgKill( hDlg );
	return ( );


SetDefaults:
	DbRec = 0;
	DbData= '';

	DbSection = '';
	DbCmd = '';

	MWCmd = 0;
	MLevel = 0;
	MenuStr.Menu1 = '';
	MenuStr.Menu2 = '';
	MenuStr.Menu3 = '';
	MenuStr.Menu4 = '';

	DbFields = '';
	Exclude = '';

// SetTbxDefaults:
	DotFunc = _dbu_Func_Add;
	Msg = 'Adding ';

SetBtnDefaults:
	BtnNo = 0;
	BWCmd = 0;

	DefFlags = _sf_ErrorNoRec | _dbf_NoDups | _dbf_NoDelWin;
	ret;


WriteMsg:
	// Write message to output dialog
	OutputDlgMessage( hDlg, LogMsg + "..." );
	if ( g_InsLogOn ) {
		Put_Line_To_Win( LogMsg, ++LogLine, LogWinNo, False );
	}
	LogMsg = '';
	ret;


WriteLogMsg:
	if ( g_InsLogOn ) {
		if ( ( Result < 1 ) && ( LogMsg != '' ) ) {
			Put_Line_To_Win( LogMsg, ++LogLine, LogWinNo, False );
		}
		if ( Result ) {
			LogMsg = '  Error: ';
			switch ( Result + BaseErr ) {
				case -1 :
					LogMsg = '  Duplicate Key';
					if ( Switch_Win_Id( DbFWin ) ) {
						Put_Line_To_Win( LogMsg, ++LogLine, LogWinNo, False );
						LogMsg = '  ' + Get_Line;
						Switch_Win_Id( SrcWin );
					}
					break;

				case 1 :
				case 3002 :
					LogMsg += 'File not found';
					break;

				case 2 :
					LogMsg += 'DbPage not found';
					break;

				case 3 :
					LogMsg += 'Record not found';
					break;

				case 4 :
					LogMsg += 'Already exists';
					break;

				case 3005 :
					LogMsg += 'Access denied';
					break;

				default:
					LogMsg += 'Result=' + Str( Result );
			}
			Put_Line_To_Win( LogMsg, ++LogLine, LogWinNo, False );
		}
		LogMsg = '';
	}
	ret;

}  // Update

int InsGetFile( str CopyFile, str LoadFile, int &Load, int DoCopy )
/******************************************************************************
															 Multi-Edit Macro
															 01-Mar-95  17:19

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
	int Result = _ErrorNoFile;
	int TRefresh = Refresh;
	int FileExisted = False;

	if ( CopyFile != "" ) {
		if ( File_Exists( CopyFile ) == 1 ) {
			if ( LoadFile == "" ) {
				LoadFile = Me_Path + "INSTALL\\" + Truncate_Path( CopyFile );
			}
			FileExisted = File_Exists( LoadFile ) == 1;
      if ( DoCopy || !FileExisted ) {
        Result = Copy_File( CopyFile, LoadFile, False );
      }
      else {
        Result = !( FileExisted == 1 );
      }
    }
	}
	if ( Load ) {
		if ( File_Exists( LoadFile ) ) {
			Load_File( LoadFile );
			if ( Error_Level == 0 ) {
				Result = _NoError;
			}
			Error_Level = 0;
      Read_Only = False;
		}
	}
	Refresh = TRefresh;
	Load = FileExisted;
	return ( Result );

}  // InsGetFile

void UpdateDlls( ) dump
/******************************************************************************
															 Multi-Edit Macro
															 09-May-95  13:12

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int CfgWin;
	int Flags;
	int Jx;
	int DelFile;

	str DbFile = "MECONFIG";
	str TStr;

	Refresh = False;
	TStr = "Installed Packages";
	Jx = 0;
	Flags = _dbf_ReplaceRec | _dbf_NoDelWin | _dbf_NoSwitchWin;
	DbPutRecord( DbFile, "PACKAGES.DB", "@\xFE", TStr, Jx, Flags, "",
			"\x7F" + "@\xFE=" + TStr );

	Flags = 0;
	DbGetPage( DbFile, "UPDATEDLL.DB", Flags, Jx );
	if ( Jx ) {
		Goto_Line( Flags );
		while ( Jx-- ) {
			TStr = Get_Line( );
			Down;
			DelFile = Parse_Int( "\x7F" + "DEL=", TStr );
			TStr = Parse_Str( "\x7F" + "DLL=", TStr );
			if ( Svl( TStr ) ) {
				if ( Get_Extension( TStr ) == "" ) {
					TStr += ".DLL";
				}
				if ( DelFile ) {
					TStr = Me_Path + TStr;
				}
				else {
					TStr = Me_Path + "INSTALL\\" + TStr;
					if ( File_Exists( TStr ) == 1  ) {
						Copy_File( TStr, Me_Path + Truncate_Path( TStr ), False );
					}
				}
				Del_File( TStr );
			}
		}
	}
	Flags = _dbf_SaveFile | _dbf_NoDelWin;
	DbDelPage( DbFile, "UPDATEDLL.DB", Flags );
	Switch_Win_Id( OrgWin );
	Refresh = TRefresh;

}  // UpdateDlls

void InsCopyDlls( str DllList, int DoCopy )
/******************************************************************************
															 Multi-Edit Macro
															 08-May-95  23:24

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
	int Jx;
	int R;
	int Flags;

	str TStr;
	str Line;
	str DbFile = "MECONFIG";
	str DllFile;

	if ( Svl( DllList ) != 0 ) {
		DllList = TranslateCmdLine( DllList, "" );
		while ( Svl( DllList ) != 0 ) {
			Jx = XPos( ";", DllList, 1 );
			if ( Jx == 0 ) {
				Jx = Svl( DllList ) + 1;
			}
			if ( Jx > 1 ) {
				TStr = Copy( DllList, 1, Jx - 1 );
				if ( Get_Extension( TStr ) == "" ) {
					TStr += ".DLL";
				}
				DllFile = TStr;
				if ( DoCopy ) {
					if ( Copy_File( g_SrcDir + TStr, Me_Path + TStr, False ) != 0 ) {
						Copy_File( g_SrcDir + TStr, Me_Path + "INSTALL\\" + TStr, False );
						R = 0;
						Flags = _dbf_Update | _dbf_CreatePage | _dbf_NoDelWin |
								_dbf_NoSwitchWin;
						Line = "\x7F" + "DLL=" + TStr;
						DbPutRecord( DbFile, "UPDATEDLL.DB", "DLL", TStr, R, Flags, "",
								Line );

						TStr = "Installed Packages";
						R = 0;
						Flags = _dbf_Update | _dbf_CreatePage | _dbf_NoDelWin |
								_dbf_InsertBefore | _dbf_SaveFile;
						Line = "\x7F" + "@\xFE=" + TStr + "\x7F" + "INIT=UPDATE^UpdateDlls" +
								"\x7F" + "EN=1";
						DbPutRecord( DbFile, "PACKAGES.DB", "@\xFE", TStr, R, Flags, "",
								Line );
						g_InsMEWRestart = True;
					}
				}
				// Register DLL File
				if ( File_Exists( Me_Path + DllFile ) == 1 ) {
					R = MEW_RegisterDLL( Truncate_Extension( DllFile ) );
					if ( R ) {
						RegisterMEWResource( R );
					}
				}
			}
			DllList = Str_Del( DllList, 1, Jx );
		}
	}
}  // InsCopyDlls

int InsQueryDlg( str Pkg ) trans2
/******************************************************************************
                               Multi-Edit Macro
                               20-Feb-96  10:27

  Function: Dialog used to prompt for cmdmap or full install.
  Entry   : str Pkg       - The name of the package being installed
  Exit    : int
              id_std_Yes      - Cmdmap only install
              id_std_No       - Full install
              id_std_Cancel   - Cancel install

               Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  int Dlg;
  int CtrlId   = 100;
  int Width    = 46;
  int Jx       = 0;
	int Jy;
  int MsgX     = 9;
  int MsgY     = dlg_Units | dlg_Units_HLine;
  int MsgLines = 0;

	str TStr;
  str HelpCtx = "";
  str Title = "Add-On Package Installation";
  str Msg = "The \"" + Pkg + "\" package has been previously installed." +
        "\\n\\nCmdmap Install will install/update only the command map." +
        "\\nFull Install will install/update the complete package.";

  DlgCreate( Dlg );
  DlgAddCtrl( Dlg, dlg_Icon, "IC_EXCLAMATION",
      1, dlg_Units | dlg_Units_HLine,
			0, 0,
      CtrlId, 0, "" );

	Jy = 1;
	while ( Jx = XPos( "\\n", Msg, Jy ) ) {
		TStr = Copy( Msg, Jy, Jx - Jy );
		++MsgLines;
  	DlgAddCtrl( Dlg, dlg_Static, TStr,
      	MsgX, MsgY,
				0, 0,
      	CtrlId, 0 , "" );

		Jy = Jx + 2;
    MsgY += dlg_Units_QLine * 3;
		Jx = Svl( TStr );
    if ( Jx > ( Width - 4 ) ) {
      Width = Jx + ( Jx / 4 );
		}
	}
	TStr = Copy( Msg, Jy, Svl( Msg ) );
	++MsgLines;
  DlgAddCtrl( Dlg, dlg_Static, TStr,
      MsgX, MsgY,
			0, 0,
      CtrlId, 0 , "" );

	Jx = Svl( TStr );
  if ( Jx > ( Width - 4 ) ) {
    Width = Jx + ( Jx / 4 );
	}
	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			MsgX - 1, dlg_Units | dlg_Units_HLine,
      Width, MsgLines - ( MsgLines / 4 ),
			++CtrlId, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Cmdmap Install",
      8, 2 + MsgLines - ( MsgLines / 4 ),
      18, 0,
      id_std_Yes, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Full Install",
      dlg_PosOffset + 18 + 2, dlg_PosOffset + 0,
      14, 0,
      id_std_No, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Cancel",
      dlg_PosOffset + 14 + 2, dlg_PosOffset + 0,
      dlg_StanBtnWidth, 0,
      id_std_Cancel, 0, "/R=0" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      8 + Width - dlg_StanBtnWidth, dlg_PosOffset + 0,
      dlg_StanBtnWidth, 0,
      id_std_Help, 0, "/R=2" );
  Return_Int = DlgExecute( Dlg, id_std_Yes, Title, HelpCtx, "", 0 );
  DlgKill( Dlg );

  return ( Return_Int );

}  // InsQueryDlg

int InstallMsgProc(
      int &RetVal,
      int Window,
      int Message,
      int WParam,
      int LParam,
      str Parms
) no_break
/******************************************************************************
															 Multi-Edit Macro
															 01-Mar-95  16:04

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
  int Dlg = Parse_Int( "/DLG=", Parms);
  int hLstWin = GetDlgItem( Window, id_ins_PkgLst );
	int hSrcDir = GetDlgItem( Window, id_ins_SrcDir );
//   int MaxItems = SendMessage( hPWin, lb_GetCount, 0, 0 );
  int Flags;
  int Jx;
	int DoInstall;
	int FullInstall;

	str Line;
	str TStr;
	str CmdInsFile;
	str Pkg;

  if ( Message == wm_Command ) {
    switch( WParam ) {
			case id_ins_SrcDir :
        switch ( LParam >> 16 ) {
					case en_SetFocus :
						g_SrcDirChanged = False;
						break;

          case en_Change :
						if ( g_SrcDirChanged == 0 ) {
    					SetDefaultButton( Window, id_ins_RescanBtn );
  						EnableWindow( GetDlgItem( Window, id_ins_InstallBtn ), False );
							g_SrcDirChanged = True;
						}
            break;

          case en_KillFocus :
						if ( g_SrcDirChanged ) {
							GetDlgItemText( Window, id_ins_SrcDir, TStr, 80 );
							if ( Svl( TStr ) == 1 ) {
								TStr += ":\\";
							}
							else if ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) {
								TStr += "\\";
							}
							SetDlgItemText( Window, id_ins_SrcDir, TStr );
						}
						break;
				}
				break;

			case id_ins_InsDir :
				switch ( LParam >> 16 ) {
					case en_KillFocus :
						GetDlgItemText( Window, id_ins_InsDir, TStr, 80 );
						if ( Svl( TStr ) == 1 ) {
							TStr += ":\\";
						}
						else if ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) {
							TStr += "\\";
						}
						SetDlgItemText( Window, id_ins_InsDir, TStr );
						break;
				}
				break;

			case id_ins_BrowseBtn :
				GetWindowText( hSrcDir, TStr, 80 );
				if ( SelectDirectory( Window, TStr, "Select source directory",
						"", 0 ) ) {
					SetWindowText( hSrcDir, TStr);
				}

			case dlg_WCmd_Init :
				call RebuildLst;
				if ( g_AutoStart ) {
					PostMessage( Window, wm_Command, id_ins_InstallBtn, 0 );
				}
				return( True );

			case id_ins_RescanBtn :
				call RebuildLst;
				return ( True );

			case 998 :
				WParam = GetDefaultButton( Window );
				if ( WParam ) {
					PostMessage( Window, wm_Command, WParam, LParam );
				}
				return( True );

			case id_ins_InstallBtn :
				DoInstall = True;
				FullInstall = True;
				GetDlgItemText( Window, id_ins_InsDir, TStr, 80 );  // Get Install Dir
				if ( Svl( TStr ) == 1 ) {
					TStr += ":";
				}
				else if ( Copy( TStr, Svl( TStr ), 1 ) == "\\" ) {
					TStr = Copy( TStr, 1, Svl( TStr ) - 1 );
				}
				g_InstallDir = Caps( TStr );
				Line = Get_Line( );
				Pkg = Parse_Str( "\x7F" + "P=", Line );
				// Check for commands installation file
				SetDlgItemText( Window, id_ins_HlpLine,	"Please wait..." );
				TStr = Caps( Parse_Str( "\x7F" + "CF=", Line ) );
        CmdInsFile = TStr;
				if ( Svl( TStr ) != 0 ) {
					DoInstall = False;      			// Set to not install
        	SetDlgItemText( Window, id_ins_MsgLine, "Copying " + TStr );
					Jx = False;
          if ( InsGetFile( g_SrcDir + TStr, "", Jx, False ) == _NoError ) {
						FullInstall = False;				// Set to install commands only
						TStr = Pkg;
						if ( Jx ) {
              Jx = InsQueryDlg( Pkg );
							if ( Jx == id_std_Yes ) {
								DoInstall = True;       // Set to install
								Line = TStr;
							}
							else if ( Jx == id_std_No ) {
								DoInstall = True;       // Set to install
								FullInstall = True;
							}
							else {
								TStr = "Installation aborted";
								Line = "Select Product to Install or Close";
							}
              ProcessMsgQueue( 10 );
						}
						else {
							DoInstall = True;
							FullInstall = True;
						}
					}
				}
				if ( DoInstall && FullInstall ) {
          // Copy command update file
					if ( Svl( CmdInsFile ) != 0 ) {
            Jx = False;
            InsGetFile( g_SrcDir + CmdInsFile, "", Jx, True );
          }
					// Copy uninstall dat file
					TStr = Caps( Parse_Str( "\x7F" + "U=", Line ) );
        	SetDlgItemText( Window, id_ins_MsgLine, "Copying " + TStr );
					Jx = False;
          InsGetFile( g_SrcDir + TStr, "", Jx, True );
					// Copy main install dat file
					TStr = Caps( Parse_Str( "\x7F" + "F=", Line ) );
        	SetDlgItemText( Window, id_ins_MsgLine, "Copying " + TStr );
					Jx = False;
          DoInstall = ( InsGetFile( g_SrcDir + TStr, "", Jx, True ) == _NoError );
					if ( DoInstall && ( File_Exists( g_InstallDir ) != 2 ) ) {
						Jx = VerifyDlg( "Directory \"" + g_InstallDir + "\" does not exist!" +
								"\\nCreate?", "Add-On Package Installation", "", 0, 0 );

						DoInstall = ( Jx == id_std_Yes );
						if ( DoInstall ) {
							DoInstall = ( MkDir( g_InstallDir ) == 0 );
						}
						else {
							TStr = "Directory " + g_InstallDir + " does not exist";
							Line = "Create it and retry";
							FullInstall = False;
						}
            ProcessMsgQueue( 10 );
					}
				}
				if ( DoInstall ) {
					g_InstallDir += "\\";
					// Copy and register DLL files
          InsCopyDlls( Parse_Str( "\x7F" + "DLL=", Get_Line( ) ), FullInstall );
//          EnableWindow( Window, False );
					if ( FullInstall ) {
        		SetDlgItemText( Window, id_ins_MsgLine, "Installing " + Pkg );
						TStr = Get_Path( g_InsLstFile ) + TStr;
						Update( TStr );
						Del_File( TStr );
					}
					if ( Svl( CmdInsFile ) != 0 ) {
						SetDlgItemText( Window, id_ins_MsgLine, "Installing " + Pkg +
								" cmds" );
						TStr = Get_Path( g_InsLstFile ) + CmdInsFile;
						Update( TStr );
//						Del_file( TStr );
					}
					Switch_Win_Id( g_InsLstWin );
					TStr = Get_Line( ) + "\x7F" + "CM=1";
					Put_Line( TStr );
					Line = "\x7F" + "PKG=" + Parse_Str( "\x7F" + "P=", TStr ) +
							"\x7F" + "VER=" + Parse_Str( "\x7F" + "V=", TStr ) +
							"\x7F" + "DLL=" + Parse_Str( "\x7F" + "DLL=", TStr ) +
							"\x7F" + "INIT=" + Parse_Str( "\x7F" + "I=", TStr ) +
							"\x7F" + "DELS=" + Parse_Str( "\x7F" + "U=", TStr ) +
							"\x7F" + "UPD=" + Parse_Str( "\x7F" + "CF=", TStr ) +
							"\x7F" + "DIR=" + g_InstallDir + "\x7F" + "EN=1";
					TStr = Pkg;
					Jx = 0;
					Flags = _dbf_Update | _dbf_SaveFile | _dbf_CreatePage |
							_dbf_NoDelWin;
					DbPutRecord( "MECONFIG", "PACKAGES.DB", "PKG", TStr, Jx, Flags, "",
							Line );
					TStr = "Installation complete";
					Line = "Select Product to Install or Close";
				}
				else if ( FullInstall ) {
					TStr = "Install file " + g_SrcDir + TStr + " not found";
					Line = "Insert disk in " + Copy( g_SrcDir, 1, 3 ) + " and try again";
				}
        SetDlgItemText( Window, id_ins_MsgLine, TStr );
				SetDlgItemText( Window, id_ins_HlpLine,	Line );
				Switch_Win_Id( g_InsLstWin );
//        EnableWindow( Window, True );
				SetFocus( hLstWin );
				call SetInsDir;
				if ( g_AutoStart ) {
					PostMessage( Window, wm_Command, id_std_Close, 0 );
				}
				return ( True );

			case id_ins_PkgLst :
        switch ( LParam >> 16 ) {
          case lbn_SelChange :
						call SetInsDir;
            break;

          case lbn_SetFocus :
  					Jx = SendMessage( hLstWin, lb_GetCount, 0, 0 );
						if ( Jx == 0 ) {
							SetDefaultButton( Window, id_ins_RescanBtn );
  						EnableWindow( GetDlgItem( Window, id_ins_InstallBtn ), False );
  						EnableWindow( GetDlgItem( Window, id_ins_ViewDocBtn ), False );
  						EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
							SetFocus( hSrcDir );
						}
						else {
  						EnableWindow( GetDlgItem( Window, id_ins_InstallBtn ), True );
							SetDefaultButton( Window, id_ins_InstallBtn );
						}
						break;
        }
				break;

			case id_ins_LogChk :
        g_InsLogOn = SendMessage( GetDlgItem( Window, id_ins_LogChk ),
						bm_GetCheck, 0, 0 );
        SetFocus( hLstWin );
				break;

			case id_ins_ViewDocBtn :
				TStr = Parse_Str( "\x7F" + "R=",  Get_Line( ) );
				TStr = g_SrcDir + TStr;
				Make_Message( TStr );
				if ( File_Exists( TStr ) == 1 ) {
					ViewFileDlg( TStr, "", "", "", 0, 0 );
					TStr = "Done viewing documentation";
				}
				else {
  				EnableWindow( GetDlgItem( Window, id_ins_ViewDocBtn ), False );
					TStr = Truncate_Path( TStr ) + " not found";
				}
  			SetDlgItemText( Window, id_ins_MsgLine, TStr );
				SetFocus( hLstWin );
				return ( True );

			case id_ins_ViewLogBtn :
				if ( File_Exists( g_InsLogFile ) == 1 ) {
					ViewFileDlg( g_InsLogFile, "", "", "", 0, 0 );
					TStr = "Done viewing log";
				}
				else {
  				EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
					TStr = Truncate_Path( g_InsLogFile ) + " not found";
				}
  			SetDlgItemText( Window, id_ins_MsgLine, TStr );
				SetFocus( hLstWin );
				return ( True );
    }
  }
  return ( DlgMessageProc( RetVal, Window, Message, WParam, LParam, Parms ) );

RebuildLst:
	GetWindowText( hSrcDir, TStr, 80 );
	if ( Svl( TStr ) == 1 ) {
		TStr += ":\\";
	}
	else if ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) {
		TStr += "\\";
	}
	g_SrcDir = Caps( TStr );
	TStr = "Scanning " + g_SrcDir;
  SetDlgItemText( Window, id_ins_MsgLine, TStr );
	SetDlgItemText( Window, id_ins_HlpLine,	"Please wait..." );
	TStr = g_SrcDir + Truncate_Path( g_InsLstFile );
	Jx = True;
  if ( InsGetFile( "", TStr, Jx, False ) == _NoError ) {
    SendMessage( hLstWin, wm_SetRedraw, 0, 0 );
    SendMessage( hLstWin, lb_ResetContent, 0, 0 );
		Jx = 0;
		while ( !At_Eof ) {
    	SendMessage( hLstWin, lb_AddString, 0, 0 );
			Down;
			++Jx;
		}
    SendMessage( hLstWin, lb_AddString, 0, 0 );
    SendMessage( hLstWin, wm_SetRedraw, 1, 0 );
    SendMessage( hLstWin, lb_DeleteString, 0, 0 );
		Tof;
		call SetInsDir;
    SendMessage( hLstWin, lb_SetCurSel, C_Line - 1, 0 );
		TStr = "Found install list";
		Line = "Select Product to Install";
	}
	else {
		SendMessage( hLstWin, lb_ResetContent, 0, 0 );
		SetDefaultButton( Window, id_ins_RescanBtn );
		TStr = "No install list found";
		Line = "Browse or insert disk in " + Copy( g_SrcDir, 1, 3 ) + " and Rescan";
	}
	SetFocus( hLstWin );
  SetDlgItemText( Window, id_ins_MsgLine, TStr );
	SetDlgItemText( Window, id_ins_HlpLine,	Line );
	ret;


SetInsDir:
	while ( !At_Eof && !XPos( "\x7F" + "P=", Get_Line, 1 ) ) {
		Down;
	}
	Line = Get_Line( );
	TStr = Caps( Parse_Str( "\x7F" + "D=", Line ) );
	if ( Svl( TStr ) == 0 ) {
		TStr = Me_Path;
	}
	if ( XPos( "<", TStr, 1 ) ) {
		TStr = TranslateCmdLine( TStr, "" );
	}
	if ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) {
		TStr += "\\";
	}
	g_InstallDir = TStr;
	DlgSetStr( Dlg, id_ins_InsDir, TStr );
  SetDlgItemText( Window, id_ins_InsDir, TStr );

	TStr = Parse_Str( "\x7F" + "R=",  Line );
	Jx = 0;
	if ( Svl( TStr ) != 0 ) {
		TStr = g_SrcDir + TStr;
		Jx = ( File_Exists( TStr ) == 1 );
	}
  EnableWindow( GetDlgItem( Window, id_ins_ViewDocBtn ), Jx );

	TStr = Truncate_Extension( Parse_Str( "\x7F" + "F=", Line ) );
	Jx = 0;
	g_InsLogFile = "";
	if ( Svl( TStr ) != 0 ) {
		TStr = Me_Path + "INSTALL\\" + TStr + ".LOG";
		Jx = ( File_Exists( TStr ) == 1 );
		g_InsLogFile = TStr;
	}
  EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), Jx );
	ret;

}  // InstallMsgProc

void Install(
			str FName[ 128 ] = Parse_Str( "/F=", MParm_Str ),
      int AutoStart = Parse_Int( "/A=", MParm_Str )
)
/******************************************************************************
															 Multi-Edit Macro
															 28-Feb-95  15:39

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
  int Ow = Window_Id;
  int Srf = Refresh;
	int TErrorMode = SetErrorMode( True );
  int Dlg;
  int X;
  int Y;
  int CtrlId = 100;
	int Result;
	int Height = 6;
	int LstWidth = 40;
	int BtnX;
	int LstX;

	str TStr;
	str Title = "Add-On Package Installation";

  Refresh = False;
	if ( Global_Int( "&BtnOnRight" ) ) {
		LstX = 1;
		BtnX = LstWidth + 4;
	}
	else {
		BtnX = 1;
		LstX = _ins_BtnWidth + 2;
	}
	g_AutoStart = AutoStart;
	g_SrcDir = Get_Path( FName );
	FName = Truncate_Path( FName );
	if ( Svl( FName ) == 0 ) {
		FName = "INSTALL.LST";
	}
  Switch_Window( Window_Count );        // Create install list window
  Create_Window;
  g_InsLstWin = Window_Id;
  Window_Attr = 0x81;
	g_InsLstFile = Me_Path + "INSTALL\\" + FName;
	if ( Length( g_SrcDir ) == 0 ) {
		g_SrcDir = "A:\\";
	}
	g_InstallDir = Me_Path;

	TStr = Get_Path( g_InsLstFile );
	if ( File_Exists( TStr ) != 2 ) {
		TStr = Copy( TStr, 1, Svl( TStr ) - 1 );
		Result = MkDir( TStr );
	}
	Error_Level = 0;
	g_InsLogOn = True;

  DlgCreate( Dlg);

  DlgAddCtrl( Dlg, dlg_BitmapStatic, "BT_VCS_100",
      4, dlg_Units | dlg_Units_HLine,
			0, 0,
      CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			_ins_BtnWidth + 3, dlg_Units | dlg_Units_QLine,
			41, 2,
			++CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 1, dlg_PosOffset + 0,
			39, 0,
			id_ins_MsgLine, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 0, dlg_PosOffset + 1,
			39, 0,
			id_ins_HlpLine, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "&Source Dir",
			1, dlg_PosOffset | dlg_Units | dlg_Units_Line_Half,
			0, 0,
			++CtrlId, 0, "" );
	DlgAddCtrl( Dlg, dlg_Text, g_SrcDir,
			dlg_PosOffset + _ins_BtnWidth + 2, dlg_PosOffset + 0,
			30, 0,
			id_ins_SrcDir, dlgf_es_Uppercase, "/ML=80" );

	DlgAddCtrl( Dlg, dlg_PushButton, "&Browse",
			dlg_PosOffset + 31, dlg_NegOffset | dlg_Units + 1,
			10, 0,
			id_ins_BrowseBtn, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "Install &Dir",
			1, dlg_PosOffset | dlg_Units_5QLines + 1,
			0, 0,
			++CtrlId, 0, "" );
	DlgAddCtrl( Dlg, dlg_Text, g_InstallDir,
			dlg_PosOffset + _ins_BtnWidth + 2, dlg_PosOffset + 0,
			41, 0,
			id_ins_InsDir, dlgf_es_Uppercase, "/ML=128" );

  Switch_Win_Id( g_InsLstWin );
  DlgAddCtrl( Dlg, dlg_GroupBox, "&Products",
      LstX, dlg_PosOffset | dlg_Units_5QLines - 1,
      LstWidth + 2, Height + 1,
      ++CtrlId, 0, "" );
  DlgAddCtrl( Dlg, dlg_ListBox, "\x7F" + "CM=/T=4/W=15/H=15" +
					"\x7F" + "P=/W=29/IS=1" + "\x7F" + "V=/W=7",
      dlg_PosOffset + 1, dlg_PosOffset | dlg_Units_3QLines,
      LstWidth, Height,
      id_ins_PkgLst, 0, "/INCO=1/WIN=" + str( Cur_Window ) );
	DlgGetXY( Dlg, id_ins_PkgLst, X, Y );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Rescan",
      BtnX, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_ins_RescanBtn, dlgf_DefButton, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "&View Doc",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_3HLines,
			_ins_BtnWidth, 0,
			id_ins_ViewDocBtn, dlgf_Disable, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "View &Log",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_5QLines,
			_ins_BtnWidth, 0,
			id_ins_ViewLogBtn, dlgf_Disable, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Install",
      1, dlg_Units | Y + ( dlg_Units_HLine * ( ( Height * 2 ) + 1 ) ),
      _ins_BtnWidth, 0,
      id_ins_InstallBtn, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Close",
      dlg_PosOffset + _ins_BtnWidth + 1, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_std_Close, 0, "/R=0" );
  DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      dlg_PosOffset + 30, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_std_Help, 0, "/R=2" );

	DlgAddCtrl( Dlg, dlg_CheckBox, "L&og Install",
			dlg_NegOffset + 16, dlg_PosOffset | dlg_Units + 1,
			0, 0,
			id_ins_LogChk, 0, "" );
	DlgSetInt( Dlg, id_ins_LogChk, g_InsLogOn );

  Result = DlgExecute( Dlg, id_ins_PkgLst, Title, "", "/RPOS=InsDlgPos" +
			"/HOOK=InstallMsgProc", 0 );
  DlgKill( Dlg );

  if ( Switch_Win_Id( g_InsLstWin ) ) {
    Delete_Window;
  }
	SetErrorMode( TErrorMode );
	g_SrcDirChanged = False;
	g_InsLstFile = "";
	g_InsLstWin = 0;
	g_InsLogOn = False;
  Switch_Win_Id( Ow );
  Refresh = Srf;
	TStr = g_InsEndMac;
	if ( Svl( TStr ) != 0 ) {							// Run End Macros
		TStr = TranslateCmdLine( TStr, "" );
		while ( Svl( TStr ) != 0 ) {
			X = XPos( ";", TStr, 1 );
			if ( X == 0 ) {
				X = Svl( TStr ) + 1;
			}
			if ( X > 1 ) {
				Rm( Copy( TStr, 1, X - 1 ) );
			}
			TStr = Str_Del( TStr, 1, X );
		}
	}
	if ( g_InsMEWRestart ) {
    MsgDlg( "You will need to restart MEW to use" +
        "\\nthe new DLL files.", Title, "", 1 );
	}
	g_SrcDir = "";
	g_InstallDir = "";
	g_InsEndMac	= "";
	g_InsLogFile = "";
	g_InsMEWRestart = 0;
	g_AutoStart = 0;

}  // Install

void InsDelDlls( str DllList )
/******************************************************************************
															 Multi-Edit Macro
															 08-May-95  23:24

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/
{
	int Jx;
	int R;
	int Flags;

	str TStr;
	str Line;
	str DbFile = "MECONFIG";

	if ( Svl( DllList ) != 0 ) {
		DllList = TranslateCmdLine( DllList, "" );
		while ( Svl( DllList ) != 0 ) {
			Jx = XPos( ";", DllList, 1 );
			if ( Jx == 0 ) {
				Jx = Svl( DllList ) + 1;
			}
			if ( Jx > 1 ) {
				TStr = Copy( DllList, 1, Jx - 1 );
				if ( Get_Extension( TStr ) == "" ) {
					TStr += ".DLL";
				}
				R = 0;
				Flags = _dbf_Update | _dbf_CreatePage | _dbf_NoDelWin |
						_dbf_NoSwitchWin;
				Line = "\x7F" + "DLL=" + TStr + "\x7F" + "DEL=1";
				DbPutRecord( DbFile, "UPDATEDLL.DB", "DLL", TStr, R, Flags, "", Line );

				TStr = "Installed Packages";
				R = 0;
				Flags = _dbf_Update | _dbf_CreatePage | _dbf_NoDelWin |
						_dbf_InsertBefore | _dbf_SaveFile;
				Line = "\x7F" + "@\xFE=" + TStr + "\x7F" + "INIT=UPDATE^UpdateDlls" +
						"\x7F" + "EN=1";
				DbPutRecord( DbFile, "PACKAGES.DB", "@\xFE", TStr, R, Flags, "",
						Line );
				g_InsMEWRestart = True;
			}
			DllList = Str_Del( DllList, 1, Jx );
		}
	}
}  // InsDelDlls

int EnablePackage(
			str PackageName = Parse_Str( "/P=", MParm_Str ),
      int Enable      = Parse_Int( "/E=", MParm_Str )
)
/******************************************************************************
															 Multi-Edit Macro
															 28-Dec-95  10:48

	Function: Enable/disable and installed add-on package

	Entry   : str PackageName	- The registered addon package name
						int Enable			- True to enable, False to disable the package

	Exit    : int
							_NoError					- Success, PackageName was updated
							_ErrorNoFile      - Failure, "MECONFIG.DB" not found
							_ErrorNoDbPage    - Failure, "PACKAGES" not found in "MECONFIG.DB"
							_ErrorNoDbRecord  - Failure, no record matching PackageName found

							 Copyright (C) 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
	int OrgWin 		 = Window_Id;
	int SavRefresh = Refresh;
	int FirstRec 	 = 0;
	int Flags;
	int Result;
	int Jx;

	Refresh = False;
	Flags = _sf_FirstField | _dbf_NoDelWin | _dbf_NoSwitchWin;
	Result = DbGetRecord( "MECONFIG", "PACKAGES.DB", "PKG", PackageName, FirstRec,
			Flags, "" );

	if ( Result == _NoError ) {
		Jx = XPos( "\x7F" + "EN=", PackageName, 1 );
		PackageName = Copy( PackageName, 1, Jx - 1 ) + "\x7F" + "EN=" + Str( Enable );
		Flags = _dbf_ReplaceRec | _dbf_NoDelWin | _dbf_SaveFile;
		Result = DbPutRecord( "", "PACKAGES.DB", "PKG", PackageName, FirstRec,
				Flags, "", PackageName );
	}
	Switch_Win_Id( OrgWin );
	Refresh = SavRefresh;
	return ( Result );

}  // EnablePackage

int UninstallMsgProc(
      int &RetVal,
      int Window,
      int Message,
      int WParam,
      int LParam,
      str Parms
) no_break
/******************************************************************************
															 Multi-Edit Macro
															 31-Mar-95  12:38

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
  int Dlg = Parse_Int( "/DLG=", Parms);
  int hLstWin = GetDlgItem( Window, id_ins_PkgLst );
//   int MaxItems = SendMessage( hPWin, lb_GetCount, 0, 0 );
  int Flags = True;
  int Jx;

	str Line;
	str TStr;
	str DbFile = "MECONFIG";

  if ( Message == wm_Command ) {
    switch( WParam ) {
			case dlg_WCmd_Init :
			case id_ins_RescanBtn :
				call RebuildLst;
				return ( True );

			case 998 :
				WParam = GetDefaultButton( Window );
				if ( WParam ) {
					PostMessage( Window, wm_Command, WParam, LParam );
				}
				return( True );

			case id_ins_RmCmdsBtn :
				Flags = False;

			case id_ins_InstallBtn :
				Line = Get_Line( );
				TStr = g_InsLstFile + Caps( Parse_Str( "\x7F" + "DELS=", Line ) );
				Line = Parse_Str( "\x7F" + "PKG=", Line );
				Jx = VerifyDlg( "About to uninstall \"" + Line + "\"!\\nContinue?",
						"Manage Add-On Packages", "", 0, 0 );
        RedrawWindow( Frame_Handle, 0, 0, rdw_AllChildren | rdw_UpdateNow );
				if ( Jx == id_std_Yes ) {
					if ( File_Exists( TStr ) == 1 ) {
        		SetDlgItemText( Window, id_ins_MsgLine, "Uninstalling " + Line );
						SetDlgItemText( Window, id_ins_HlpLine,	"Please wait..." );
//            EnableWindow( Window, False );
						Update( TStr );
						if ( Flags ) {
							Del_File( TStr );
              TStr = g_InsLstFile + Parse_Str( "\x7F" + "UPD=", Get_Line( ) );
              Del_File( TStr );
						}
// 						RmDir( g_InstallDir );
						Switch_Win_Id( g_InsLstWin );
					}
					TStr = Get_Line( ) + "\x7F" + "CM=1";
					Put_Line( TStr );
					InsDelDlls( Parse_Str( "\x7F" + "DLL=", TStr ) );
					if ( Flags ) {
						Jx = 0;
						Flags = _dbf_SaveFile | _dbf_NoDelWin;
						DbDelRecord( DbFile, "PACKAGES.DB", "PKG", Line, Jx, Flags, "" );
					}
					TStr = "Uninstall complete";
				}
				else {
					TStr = "Uninstall aborted";
				}
				Line = "Select another Product or Close";
        SetDlgItemText( Window, id_ins_MsgLine, TStr );
				SetDlgItemText( Window, id_ins_HlpLine,	Line );
				Switch_Win_Id( g_InsLstWin );
//        EnableWindow( Window, True );
				SetFocus( hLstWin );
				call SetInsDir;
				return ( True );

			case id_ins_PkgLst :
        switch ( LParam >> 16 ) {
          case lbn_SelChange :
						call SetInsDir;
            break;

          case lbn_SetFocus :
  					Jx = SendMessage( hLstWin, lb_GetCount, 0, 0 );
						if ( Jx == 0 ) {
  						EnableWindow( GetDlgItem( Window, id_ins_InstallBtn ), False );
  						EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
  						EnableWindow( GetDlgItem( Window, id_ins_DelLogBtn ), False );
							EnableWindow( GetDlgItem( Window, id_ins_EnableBtn ), False );
							EnableWindow( GetDlgItem( Window, id_ins_RmCmdsBtn ), False );
						}
						else {
							EnableWindow( GetDlgItem( Window, id_ins_EnableBtn ), True );
  						EnableWindow( GetDlgItem( Window, id_ins_InstallBtn ), True );
							EnableWindow( GetDlgItem( Window, id_ins_RmCmdsBtn ), True );
						}
						break;
        }
				break;

			case id_ins_LogChk :
        g_InsLogOn = SendMessage( GetDlgItem( Window, id_ins_LogChk ),
						bm_GetCheck, 0, 0 );
        SetFocus( hLstWin );
				break;

			case id_ins_ViewLogBtn :
				if ( File_Exists( g_InsLogFile ) == 1 ) {
					ViewFileDlg( g_InsLogFile, "", "", "", 0, 0 );
					TStr = "Done viewing log";
				}
				else {
  				EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
  				EnableWindow( GetDlgItem( Window, id_ins_DelLogBtn ), False );
					TStr = Truncate_Path( g_InsLogFile ) + " not found";
				}
  			SetDlgItemText( Window, id_ins_MsgLine, TStr );
				SetFocus( hLstWin );
				return ( True );

			case id_ins_DelLogBtn :
				if ( File_Exists( g_InsLogFile ) == 1 ) {
					Del_File( g_InsLogFile );
					TStr = "Log file deleted";
				}
				else {
  				EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
  				EnableWindow( GetDlgItem( Window, id_ins_DelLogBtn ), False );
					TStr = Truncate_Path( g_InsLogFile ) + " not found";
				}
  			EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), False );
  			EnableWindow( GetDlgItem( Window, id_ins_DelLogBtn ), False );
  			SetDlgItemText( Window, id_ins_MsgLine, TStr );
        SetFocus( hLstWin );
				return ( True );

			case id_ins_EnableBtn :

				int Enable;

				Line = Get_Line( );
				Jx = XPos( "\x7F" + "EN=", Line, 1 );
				Enable = Parse_Int( "\x7F" + "EN=", Line );
				Line = Copy( Line, 1, Jx - 1 );
				Line += "\x7F" + "EN=" + Str( !Enable );
				Jx = C_Line;
				Flags = _dbf_ReplaceRec | _dbf_NoDelWin;
				DbPutRecord( "MECONFIG.DB", "PACKAGES.DB", "", TStr, Jx, Flags, "",
						Line );
				if ( Enable ) {
					TStr = "En&able";
  				SetDlgItemText( Window, id_ins_EnableBtn, TStr );
					TStr = "-";
				}
				else {
					TStr = "Dis&able";
  				SetDlgItemText( Window, id_ins_EnableBtn, TStr );
					TStr = "+";
				}
				Put_Line( Line + "\x7F" + "ON=" + TStr );
        SetFocus( hLstWin );
				return ( True );
    }
  }
  return ( DlgMessageProc( RetVal, Window, Message, WParam, LParam, Parms ) );

RebuildLst:
	TStr = "Scanning for installed packages";
	SetDlgItemText( Window, id_ins_MsgLine, TStr );
	SetDlgItemText( Window, id_ins_HlpLine,	"Please wait..." );
	Flags = 0;
	DbGetPage( "MECONFIG.DB", "PACKAGES.DB", Flags, Jx );

	int CfgWin = Cur_Window;

	Switch_Win_Id( g_InsLstWin );
	if ( Jx ) {
    SendMessage( hLstWin, wm_SetRedraw, 0, 0 );
    SendMessage( hLstWin, lb_ResetContent, 0, 0 );
		Erase_Window;
		while ( Jx ) {
			Line = Get_Line_From_Win( Flags++, CfgWin );
			if ( Parse_Int( "\x7F" + "EN=", Line ) ) {
				Line += "\x7F" + "ON=+";
			}
			else {
				Line += "\x7F" + "ON=-";
			}
			Put_Line( Line );
    	SendMessage( hLstWin, lb_AddString, 0, 0 );
			Down;
			--Jx;
		}
    SendMessage( hLstWin, lb_AddString, 0, 0 );
    SendMessage( hLstWin, wm_SetRedraw, 1, 0 );
    SendMessage( hLstWin, lb_DeleteString, 0, 0 );
		Tof;
		call SetInsDir;
    SendMessage( hLstWin, lb_SetCurSel, C_Line - 1, 0 );
		TStr = "Found installed packages";
		Line = "Select Product to Uninstall";
	}
	else {
		SendMessage( hLstWin, lb_ResetContent, 0, 0 );
		SendDlgItemMessage( Window, id_ins_InstallBtn, bm_SetStyle, bs_Pushbutton,
				True );
		SendDlgItemMessage( Window, id_ins_RescanBtn, bm_SetStyle, bs_DefPushbutton,
				True );
		TStr = "No packages installed";
		Line = "Close to Exit";
	}
	SetFocus( hLstWin );
	SetDlgItemText( Window, id_ins_MsgLine, TStr );
	SetDlgItemText( Window, id_ins_HlpLine,	Line );
	ret;


SetInsDir:
	while ( !At_Eof && !XPos( "\x7F" + "PKG=", Get_Line, 1 ) ) {
		Down;
	}
	Line = Get_Line( );
	TStr = Caps( Parse_Str( "\x7F" + "DIR=", Line ) );
	if ( XPos( "<", TStr, 1 ) ) {
		TStr = TranslateCmdLine( TStr, "" );
	}
	if ( Svl( TStr ) && ( Copy( TStr, Svl( TStr ), 1 ) != "\\" ) ) {
		TStr += "\\";
	}
	g_InstallDir = TStr;
	DlgSetStr( Dlg, id_ins_InsDir, TStr );
  SetDlgItemText( Window, id_ins_InsDir, TStr );

	TStr = Truncate_Extension( Parse_Str( "\x7F" + "DELS=", Line ) );
	Jx = 0;
	g_InsLogFile = "";
	if ( Svl( TStr ) != 0 ) {
		TStr = Me_Path + "INSTALL\\" + TStr + ".LOG";
		Jx = ( File_Exists( TStr ) == 1 );
		g_InsLogFile = TStr;
	}
  EnableWindow( GetDlgItem( Window, id_ins_ViewLogBtn ), Jx );
	EnableWindow( GetDlgItem( Window, id_ins_DelLogBtn ), Jx );
	EnableWindow( GetDlgItem( Window, id_ins_EnableBtn ), True );
	if ( Parse_Int( "\x7F" + "EN=", Line ) == 1 ) {
		TStr = "Dis&able";
	}
	else {
		TStr = "En&able";
	}
  SetDlgItemText( Window, id_ins_EnableBtn, TStr );
	ret;

}  // UninstallMsgProc

void Uninstall( )
/******************************************************************************
															 Multi-Edit Macro
															 31-Mar-95  12:38

  Name    :
  Function:
  Syntax  :
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectics, Inc.
********************************************************************( ldh )***/
{
  int Ow = Window_Id;
  int Srf = Refresh;
  int Dlg;
  int X;
  int Y;
  int CtrlId = 100;
	int Result;
	int Height = 6;
	int LstWidth = 40;
	int BtnX;
	int LstX;

	str TStr;
	str Title = "Manage Add-On Packages";

  Refresh = False;
	if ( Global_Int( "&BtnOnRight" ) ) {
		LstX = 1;
		BtnX = LstWidth + 4;
	}
	else {
		BtnX = 1;
		LstX = _ins_BtnWidth + 2;
	}
  Switch_Window( Window_Count );        // Create install list window
  Create_Window;
  g_InsLstWin = Window_Id;
  Window_Attr = 0x81;
	g_InsLstFile = Me_Path + "INSTALL\\";
	g_InstallDir = "";

	TStr = Get_Path( g_InsLstFile );
	if ( File_Exists( TStr ) != 2 ) {
		TStr = Copy( TStr, 1, Svl( TStr ) - 1 );
		Result = MkDir( TStr );
	}
	Error_Level = 0;
	g_InsLogOn = True;

  DlgCreate( Dlg);

  DlgAddCtrl( Dlg, dlg_BitmapStatic, "BT_VCS_100",
      4, dlg_Units | dlg_Units_HLine,
			0, 0,
      CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			_ins_BtnWidth + 3, dlg_Units | dlg_Units_QLine,
			41, 2,
			++CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 1, dlg_PosOffset + 0,
			39, 0,
			id_ins_MsgLine, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 0, dlg_PosOffset + 1,
			39, 0,
			id_ins_HlpLine, 0, "" );

	DlgAddCtrl( Dlg, dlg_Static, "Installed in",
			1, dlg_PosOffset | dlg_Units | dlg_Units_Line_Half,
			0, 0,
			++CtrlId, 0, "" );
	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			_ins_BtnWidth + 3, dlg_PosOffset + 0,
			41, 1,
			++CtrlId, 0, "" );
	DlgAddCtrl( Dlg, dlg_Static, "",
			dlg_PosOffset + 1, dlg_PosOffset + 0,
			39, 0,
			id_ins_InsDir, 0, "" );

  Switch_Win_Id( g_InsLstWin );
  DlgAddCtrl( Dlg, dlg_GroupBox, "&Products",
//      dlg_NegOffset + 2, dlg_PosOffset | dlg_Units_5QLines - 1,
      LstX, dlg_PosOffset | dlg_Units_5QLines - 1,
      LstWidth + 2, Height + 1,
      ++CtrlId, 0, "" );
  DlgAddCtrl( Dlg, dlg_ListBox, "\x7F" + "CM=/T=4/W=15/H=15" +
					"\x7F" + "ON=/W=2" + "\x7F" + "PKG=/W=27/IS=1" + "\x7F" + "VER=/W=7",
      dlg_PosOffset + 1, dlg_PosOffset | dlg_Units_3QLines,
      LstWidth, Height,
      id_ins_PkgLst, 0, "/INCO=1/WIN=" + str( Cur_Window ) );
	DlgGetXY( Dlg, id_ins_PkgLst, X, Y );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Rescan",
      BtnX, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_ins_RescanBtn, dlgf_DefButton, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "&View Log",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_5QLines,
			_ins_BtnWidth, 0,
			id_ins_ViewLogBtn, dlgf_Disable, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "Del &Log",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_5QLines,
			_ins_BtnWidth, 0,
			id_ins_DelLogBtn, dlgf_Disable, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "Dis&able",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_5QLines,
			_ins_BtnWidth, 0,
			id_ins_EnableBtn, dlgf_Disable, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "Rm &Cmds",
			dlg_PosOffset + 0, dlg_PosOffset | dlg_Units_5QLines,
			_ins_BtnWidth, 0,
			id_ins_RmCmdsBtn, dlgf_Disable, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "&Uninstall",
      1, dlg_Units | Y + ( dlg_Units_HLine * ( ( Height * 2 ) + 1 ) ),
      _ins_BtnWidth, 0,
      id_ins_InstallBtn, 0, "" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Close",
      dlg_PosOffset + _ins_BtnWidth + 1, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_std_Close, 0, "/R=0" );
  DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
      dlg_PosOffset + 30, dlg_PosOffset + 0,
      _ins_BtnWidth, 0,
      id_std_Help, 0, "/R=2" );

	DlgAddCtrl( Dlg, dlg_CheckBox, "L&og Uninstall",
			dlg_NegOffset + 17, dlg_PosOffset | dlg_Units + 1,
			0, 0,
			id_ins_LogChk, 0, "" );
	DlgSetInt( Dlg, id_ins_LogChk, g_InsLogOn );

  Result = DlgExecute( Dlg, id_ins_PkgLst, Title, '', "/RPOS=UnInsDlgPos" +
			"/HOOK=UninstallMsgProc", 0 );
  DlgKill( Dlg );

  if ( Switch_Win_Id( g_InsLstWin ) ) {
    Delete_Window;
  }
	if ( DbGetFile( "MECONFIG.DB" ) == _NoError )	{
		if ( File_Changed ) {
			Save_File;
		}
	}
	g_InsLstFile = "";
	g_InsLstWin = 0;
	g_InsLogOn = False;
  Switch_Win_Id( Ow );
  Refresh = Srf;
	TStr = g_InsEndMac;
	if ( Svl( TStr ) != 0 ) {							// Run End Macros
		TStr = TranslateCmdLine( TStr, "" );
		while ( Svl( TStr ) != 0 ) {
			X = XPos( ";", TStr, 1 );
			if ( X == 0 ) {
				X = Svl( TStr ) + 1;
			}
			if ( X > 1 ) {
				Rm( Copy( TStr, 1, X - 1 ) );
			}
			TStr = Str_Del( TStr, 1, X );
		}
	}
	if ( g_InsMEWRestart ) {
    MsgDlg( "You will need to restart MEW before you" +
        "\\nreinstall an Addon Package.", Title, "", 1 );
	}
	g_InstallDir = "";
	g_InsLogFile = "";
	g_InsEndMac	 = "";
	g_InsMEWRestart = 0;

}  // Uninstall
