macro_file TEXT;

#include metools.sh
#ifdef Windows
	#include DIALOG.SH
	#include WINDOWS.SH
	#include MEWHELP.SH
	#include STDDLGS.SH
	#include MEWLIB.SH
	#include MEW.SH

  #define MAXSIZE_BOOKMARK  128   // Can be increased up to 254

  #define HCBOOKMARKS         "BOOKMARKS"
  #define RETRAND_HELPLINK    "RETRIEVE RANDOM ACCESS MARK"
	#define SETRAND_HELPLINK		"SET RANDOM ACCESS MARK"
	#define CLRRAND_HELPLINK		"CLEAR RANDOM ACCESS MARK"
	#define CHANGECASE_HELPLINK "CHANGING CASE"


	#define _GBMGlobal			"!GBookMark_"
	#define _BMGlobal				"!BookMark_"

	#define _bm_Set			0
	#define _bm_Get			1
	#define _bm_Clear		2

	global {
		int g_hBookMarkDlg		"!hBookMarkDlg";
		int g_BookMarkBuf			"!BookMarkBuf";
		int g_GlobalBookMarks	"GlobalBookMarks";
	}

	prototype TEXT {
    int RandomMarkDlg   ( int Type, int GlobalMarks, str HelpCtx );
    int SetRandomMark   ( int BookMark, int GlobalMarks, str Label );
    int GetRandomMark   ( int BookMark, int GlobalMarks );
    int ClearRandomMark ( int BookMark, int GlobalMarks );
	}

#endif

/****************************MULTI-EDIT MACRO FILE******************************

CHNGCHARCASE      - Changes a single character from upper to lower
CHNGCASE					- Changes the case of a line, word, or block
TEXTSORT					- Sorts lines of text
CENTER						- Centers a line
OPENLN						- Insert a blank line while in overwrite mode
REFORMAT					- Reformats a paragraph
JUSTIFY						- Justifies a paragraph
UNJUSTIF					- Unjustifies a paragraph
RULER							- Displays a character ruler at the cursor position
END_OF_PARAGRAPH	- Finds the end of the current paragraph
NEXT_PARAGRAPH		- Finds the beginning of the next paragraph
MARKPOS						- Mark a position using the stack bookmarks
GOTOMARK					- Return to a mark on the stack
SET_MARK					- Mark a position using random marks
GET_MARK					- Return to a random mark
CLR_MARK          - Clear one random access mark or all random access marks
BOOKMARKS					- Allows a label to be set with a random access mark.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

void ChangeCharCase( ) trans2 {

	int SavRefresh 		= Refresh;
	int SavInsertMode = Insert_Mode;

	char TChar = Cur_Char;

	Push_Undo;
	Insert_Mode = True;
	Refresh = False;
	TChar = Translate( Cur_Char, "", "" );
	if ( TChar != Cur_Char ) {
		Del_Char;
		Text( TChar );
	}
	else {
		Right;
	}
	while ( At_Eol && !At_Eof) {
		Down;
		Goto_Col( 1 );
	}
	Redraw;
	Pop_Undo;
	Refresh = SavRefresh;
	Insert_Mode = SavInsertMode;

}  // ChangeCharCase


macro CHNGCASE TRANS2 {
/********************************MULTI-EDIT MACRO******************************

Name:  CHNGCASE

Description:  Changes the case of a block of text.

Parameters:  /U=1			Uppercase
							 =0			Lowercase
						 /T=0			Line
							 =1			Word
							 =2			Block

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  jx, tc, ti, casetype, blocktype,
			 tb1, tbs, tb2, tbl1, tbl2, tbc1, tbc2,
			 tpb = persistent_blocks;
	str  tstr ;

	push_undo;
	refresh = false;
	ti = insert_mode;
	insert_mode = true;
	casetype = parse_int('/U=', mparm_str);
	blocktype = parse_int('/T=', mparm_str);

	if(  blocktype == 0  ) {
		if(  casetype  ) {
			put_line( caps(get_line));
		} else {
			put_line( lower(get_line));
		}
	}
	if(  blocktype == 1  ) {
		if(  not(at_eol) & (xpos(cur_char,word_delimits,1) != 0)  ) {
			word_right;
		} else {
			if(  c_col > 1  ) {
				left;
				if(  xpos(cur_char,word_delimits,1)  ) {
					right;
				} else {
					right;
					word_left;
				}
			}
		}
		tc = c_col;
		tstr = get_word(word_delimits);
		if(  casetype  ) {
			tstr = caps(tstr);
		} else {
			tstr = lower(tstr);
		}

		goto_col(tc);
		del_chars( svl(tstr) );
		text( tstr );
	}
	if(  (block_stat != 0) & (blocktype == 2)  ) {
		persistent_blocks = TRUE;
		block_end;
		tbl1 = block_line1; tbl2 = block_line2;
		tbc1 = block_col1; tbc2 = block_col2;
		tbs = block_stat;
		mark_pos;
		jx = block_line1;
		while(  jx <= tbl2  ) {
			goto_line(jx);
			if(  tbs == 1  ) {
				if(  casetype  ) {
					put_line( caps(get_line));
				} else {
					put_line( lower(get_line));
				}
			}
			if(  tbs == 2  ) {
				goto_col(tbc1);
				tstr = copy(get_line, tbc1, tbc2 - tbc1 + 1);
				del_chars( svl(tstr) );
				if(  casetype  ) {
					tstr = caps(tstr);
				} else {
					tstr = lower(tstr);
				}
				text( tstr );
			}
			if(  tbs == 3  ) {
				goto_col(1);
				tb1 = 1;
				tstr = get_line;
				tb2 = svl( tstr );
				if(  jx == tbl1  ) {
					 goto_col(tbc1);
					 tb1 = tbc1;
				}
				if(  jx == tbl2  ) {
					tb2 = tbc2;
				}
				del_chars( tb2 - tb1 + 1);
				tstr = copy( tstr, tb1, tb2 - tb1 + 1);
				if(  casetype  ) {
					tstr = caps(tstr);
				} else {
					tstr = lower(tstr);
				}
				text(tstr);
			}
			++jx;
			down;
		}
		if(  tbs == 3  ) {
			goto_line(tbl1);
			goto_col(tbc1);
			str_block_begin;
			goto_line(tbl2);
			goto_col(tbc2 + 1);
			block_end;
		}
		goto_mark;
	}
	insert_mode = ti;
	pop_undo;
	persistent_blocks = tpb;
	redraw;
}

macro TEXTSORT TRANS2 {
/********************************MULTI-EDIT MACRO******************************

Name:	TextSort

Description:	Sorts lines of text.

Parameters:		/C=nn			Starting column of sort field.
							/L=nn			# of characters in sort field.
							/CASE			Ignore case of field.
							/D				Sort in descending order.
							/B				Sort the marked line block.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  tw, old_block_stat,
					 descending,
					 caps_on, sl, el,
					 c,
					 l,
					 tpb = persistent_blocks;
					 ;

		persistent_blocks = TRUE;
		push_undo;
		tw = wrap_stat;
		wrap_stat = false;
		insert_mode = true;
		refresh = false;
		working;
		mark_pos;
		old_block_stat = 0;
		Descending = xpos( '/D', MParm_Str, 1 ) == 0;
		Caps_On = Xpos( '/CASE', MParm_Str, 1 ) != 0;
		c = parse_int( '/C=', MParm_Str );
		l = parse_int( '/L=', MParm_Str );
		if(  c == 0  ) {
			c = 1;
		}
		if(  l == 0  ) {
			l = max_line_length;
		}

		if(  xpos( '/B', MParm_Str, 1 ) != 0  ) {
		 /* if(  Block_Stat != 1  ) {
				Make_Message( 'No line block marked.');
				goto exit;
			}*/
			old_block_stat = block_stat;
			sl = block_line1;
			el = block_line2;
			block_off;
		} else {
			eof;
			sl = 1;
			el = c_line;
			tof;
		}
		Make_Message( 'Sorting...' );
		qsort_lines( sl, el, descending, c, l, caps_on );
		Make_Message( 'Text sorted.');


exit:
		if(  old_block_stat > 0  ) {
			goto_line(sl);
			block_begin;
			goto_line(el);
			block_end;
		}
		wrap_stat = tw;
		pop_undo;
		refresh = true;
		goto_mark;
		persistent_blocks = tpb;

}

macro CENTER TRANS2 {
/********************************************************************************
																MULTI-EDIT MACRO

Name: CENTER

Description: Centers the line the cursor is on between column 1 and the right
							margin.


							 (C) Copyright 1991 by American Cybernetics, Inc.
********************************************************************************/

	int jx,oim=Insert_Mode;
	str tstr;
	refresh = false;
	Goto_Col(1);
	Push_Undo;
	Insert_Mode = True;
/* Delete leading spaces */
	while(  NOT(At_EOL) & (XPOS(Cur_Char,'|255|9|32',1) != 0)  ) {
		Del_Char;
	}
/* Store line into variable */
	Tstr = Shorten_Str(Get_Line);
	jx = Svl(Tstr);
	if(  jx > 0  ) {
		jx = (Right_Margin / 2) - (jx / 2);
/* Blank out existing line */
		Put_line('');
		Goto_Col(jx);
/* Put line at new position.  Works with tabs as spaces, or tabs. */
		Text(TStr);
	}
	redraw;
	Pop_Undo;
	Insert_mode=oim;
}


macro OPENLN TRANS2 {
/********************************************************************************
																MULTI-EDIT MACRO

Name: openln

Description: Opens a line below the current line, without moving the cursor.

							 (C) Copyright 1991 by American Cybernetics, Inc.
********************************************************************************/

	int  temp_ins ;
	push_undo;
	temp_ins = insert_mode;
	insert_mode = true;
	Mark_Pos;
	CR;
	Goto_Mark;
	Make_Message('Line opened.');
	insert_mode = temp_ins;
	pop_undo;
}

macro REFORMAT TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	REFORMAT

Description: Reformats the current paragraph from the current cursor position
						 down.

Parameters:
									/RC=n		1 = Restore Cursor position when done

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	if (read_only) {
		RM("MESSAGEBOX /B=2/T=Error/M=Can't reformat a paragraph in a read-only window!");
	} else {
		Push_Undo;
		Word_Wrap_Line( TRUE, Parse_Int('/RC=',MParm_Str) != 0);
		Pop_Undo;
		Make_Message('Paragraph reformatted.');
	}
}

macro JUSTIFY TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	JUSTIFY

Description: Justifies the current paragraph from the current cursor position
						 down.

Parameters:
									/RC=n		1 = Restore Cursor position when done

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  jx,jy,rr,jk, ti, tw, OldRefresh = Refresh,
					rc = Parse_Int('/RC=',Mparm_Str) ;

	push_undo;
	tw = wrap_stat;
	wrap_stat = false;
	ti = insert_mode;
	insert_mode = true;
	refresh = false;
	if(  Right_Margin > 132  ) {
		Make_Message('Right Margin too big.');
		Goto Exit2;
	}
	Make_Message('Justifying paragraph...');
	if(  (rc)  ) {
		Mark_Pos;
	}
	Working;
MAIN_LOOP:
	down;
	goto_col(1);
	if(  AT_EOL  ) {
		goto EXIT;
	}
	if(  Xpos(page_str,get_line,1)  ) {
		goto exit;
	}
	up;
M2:
	first_word;
/* remove trailing spaces */
	put_line( Shorten_Str(Get_Line) );
	jx = 0;

/* Count existing spaces */
SPACE_LOOP:
	if(  cur_char == ' '  ) {
		jx = jx + 1;
	}
	right;
	if(  NOT( AT_EOL )  ) {
		goto space_loop;
	}
	eol;
	left;
	jy = Right_Margin - c_col;
	if(  (jy <= 0) | (jX <= 0)  ) {
		goto NEXT_LINE;
	}
	rr = jx / jy;
	first_word;
	jx = 0;
	jk = 0;
/* Add in extra spaces until desired line length is reached */
	while(  NOT( AT_EOL )  ) {
		if(  cur_char == ' '  ) {
			jx = jx + 1;
			if(  jx >= rr  ) {
				if(  jk < jy  ) {
					jk = jk + 1;
					text(' ');
					right;
				}
				jx = 0;
			}
		}
		right;
	}

/* Repeat until at end of paragraph */
	if(  c_col > Right_Margin  ) {
		goto NEXT_LINE;
	}
	GOTO M2;
NEXT_LINE:
	down;
	eol;
	if(  c_col == 1  ) {
		goto EXIT;
	}
	if(  hard_cr != ''  ) {
		if(  xpos(hard_cr, get_line, 1)  ) {
			goto EXIT;
		}
	}

	GOTO MAIN_LOOP;

EXIT:
/* Move back to origninal position or to next paragraph */
	if(  (rc)  ) {
		Goto_Mark;
	} else {
		while ((get_line == "") && (!at_eof)) {
			Down;
		}
		first_word;
	}
	Make_Message('Paragraph justified.');
EXIT2:
	refresh = OldRefresh;
	wrap_stat = tw;
	pop_undo;
	redraw;
	insert_mode = ti;
}

macro UNJUSTIF TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	UNJUSTIF

Description: Unjustifies the current paragraph from the current cursor position
						 down.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	int  tw, OldRefresh = refresh;
	push_undo;
	tw = wrap_stat;
	wrap_stat = false;

	mark_pos;
	refresh = false;

	Make_Message('Unjustifying paragraph...');
	Working;
main_loop:
	first_word;
/* Check for end of paragraph */
	if(  AT_EOL  ) {
		goto EXIT;
	}
	if(  hard_cr != ''  ) {
		if(  xpos(hard_cr, get_line, 1)  ) {
			goto EXIT;
		}
	}
	while(  NOT( AT_EOL )  ) {
/* Skip over end of sentences, etc. */
		if(  pos(cur_char,'.!?:')  ) {
			right;
			right;
		}
/* Otherwise, remove occurances of more than one space */
		if(  cur_char == ' '  ) {
			right;
			while(  cur_char == ' '  ) {
				del_char;
			}
		}
		right;
	}
	down;
	goto Main_Loop;
EXIT:
	Make_Message('Paragraph Unjustified...');
	wrap_stat = tw;
	pop_undo;
	refresh = OldRefresh;
	goto_mark;
	redraw;

}

#ifndef Windows
macro RULER TRANS2 {
/********************************MULTI-EDIT MACRO******************************

Name: RULER

Description:  Puts up a character ruler at the cursor position.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	str  tstr, tstr2 ;
	int  jx, jy, jl, jk, old_col, t_line, offset, omm, ptr_removed ;
	refresh = TRUE;
	call calc_offset;
	redraw;
	old_col = c_col;
	tstr = '';
	tstr2 = '';
	jx = 0;
	jy = 1;
	jl = 0;
	while(  jx < 254  ) {
		tstr = tstr + str(jy);
		++jx;
		++jy;
		if(  jy == 10  ) {
			++jx;
			jy = 1;
			tstr = tstr + '0';
			++jl;
			tstr2 = tstr2 + copy('', 1,10 - length(str(jl))) + str(jl);
		}
	}
	omm = mouse_mode;
	ptr_removed = FALSE;
	make_message('Use |27|26 arrow keys, <HOME> and <END> to move.  Exit<ESC>.');
	set_virtual_display;
loop:
	call put_ruler;
	update_virtual_display;
	while(  NOT(check_key)  ) {
		Mou_Check_Status;
		if(  ((Mou_Last_Status & 1) == 0)  ) {
			mouse_mode = omm;
			if(  ptr_removed  ) {
				--ptr_removed;
				mou_set_pos( wherex, wherey );
				mou_draw_ptr;
			}
		}
	}
	if(  key1 == 27  ) {
		goto exit;
	}
	if(  key1 == 0  ) {
		if(  (key2 == 245) | (key2 == 251)  ) {
			goto exit;
		} else if(  (key2 == 250)  ) {
			if(  (mou_last_x > win_x1) & (mou_last_x < win_x2) &
						(mou_last_y == wherey)  ) {
				RM('MouseInWindow');
				if(  return_int  ) {
					mouse_mode = TRUE;
					mou_reset;
					mou_remove_ptr;
					++ptr_removed;
				}
			}
		} else if(  (c_col < max_line_length) & ((key2 == 77) | (key2 == 243))  ) {
			right;
		} else if(  (c_col > 1) & ((key2 == 75) | (key2 == 242))  ) {
			left;
		} else if(  (key2 == 72) | (key2 == 141)   ) {
			up;
			call calc_offset;
			redraw;
		} else if(  (key2 == 80) | (key2 == 145)  ) {
			down;
			call calc_offset;
			redraw;
		} else if(  (key2 == 116) & (old_col < max_line_length)  ) {
			if(  (c_col < 2048)  ) {
				right;
			}
			++old_col;
			redraw;
		} else if(  (key2 == 115) & (old_col > 1)  ) {
			if(  c_col > 1  ) {
				left;
			}
			--old_col;
			redraw;
		} else if(  key2 == 71  ) {
			goto_col(old_col);
		} else if(  key2 == 79  ) {
			eol;
		}
	}
	goto loop;

calc_offset:
	if(  c_row < 3  ) {
		offset = 1;
	} else {
		offset = -2;
	}
	ret;

put_ruler:
	jy = c_col - (wherex - win_x1);
	jk = 1;
	if(  old_col <= jy  ) {
		jk = jy - old_col + 2;
	}
	jx = old_col - jy;
	if(  jx < 1  ) {
		jx = 1;
	}

	jl = win_x2 - (win_x1 + jx);

	write( copy(tstr2, jk, jl), win_x1 + jx, wherey + offset, 0, h_color );
	write( copy(tstr, jk, jl), win_x1 + jx, wherey + offset + 1, 0, h_color );
	ret;

no_room:
	Make_Message('No room in window for ruler.');
	goto exit2;
exit:
	make_message('Ruler done.');
exit2:
	reset_virtual_display;
	while(  ptr_removed > 0  ) {
		--ptr_removed;
		mou_set_pos( wherex, wherey );
		mou_draw_ptr;
	}
	mouse_mode = omm;
	redraw;
}
#else
int CheckRuler ()
{
  return (RulerStatus(cur_window));
}
/*******************************************************************************
  Ruler - 9/6/95 3:22PM
  Toggle the Ruler on/off for the current window

 by John K. Perona, Copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
#define file_meerr  (user_id + "MEERR.TMP")

void Ruler(win = parse_int("/WIN=", mparm_str)  )
{
  int jx;
  int t_win = cur_window;
  int t_refresh = refresh;

  refresh = False;
  if ( g_DefaultAllRuler && (win == 0) )
  {
    for ( jx = 1; jx <= Window_Count; jx++ )
    {
      switch_window (jx);
      if ( truncate_path (file_name) != file_meerr)
      {
        if ( window_handle && (RulerStatus(jx) == 0))
        {
          break;
        }
      }
    }
    if ( jx == (Window_Count + 1) )
    {
      for (jx = 1; jx <= Window_Count; jx++  )
      {
        switch_window (jx);
        if ( truncate_path (file_name) != file_meerr)
        {
          if (window_handle && (RulerStatus(jx) != 0))
          {
            RulerOff (jx);
          }
        }
      }
    }
    else
    {
      for (jx = 1; jx <= Window_Count; jx++  )
      {
        switch_window (jx);
        if ( truncate_path (file_name) != file_meerr)
        {
          if ( Window_handle && (RulerStatus(jx) == 0))
          {
            RulerOn (jx);
          }
        }
      }
    }
  }
  else
  {
    if ( win == 0 )
    {
      win = cur_window;
    }

    if ( RulerStatus (win) == 0 )
    {
      RulerOn  (win);
    } else {
      RulerOff (win);
    }
  }
  refresh = t_refresh;
  switch_window (t_win);
} // Ruler

/*******************************************************************************
  Set_Ruler_Zero - 9/8/95 2:06PM

 by John K. Perona, Copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void Set_Ruler_Zero( win = parse_int("/WIN=", mparm_str),
                     ps = parse_int("/POS=", mparm_str) )
{
  if ( win == 0 )
  {
    win = cur_window;
  }
  if ( ps == 0 )
  {
    ps = c_col;
  }
  RulerZero (win, ps);
} // Set_Ruler_Zero
#endif

macro END_OF_PARAGRAPH trans2 {
/********************************MULTI-EDIT MACRO******************************

Name: END_OF_PARAGRAPH

Description:  Finds the end of the current paragraph.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
  int first_word_col = 0;

	Refresh = FALSE;
LOOP:
  if(first_word_col != 0)
  {
    if(word_wrap_style & 2)
    {
      first_word;
      if( c_col != first_word_col)
      {
        up;
        eol;
        goto exit;
      }
    }
  }
	if(  (copy(get_line, 1, length(page_str)) == page_str)  ) {
		goto EXIT;
	}
	EOL;
	if(  (c_col == 1) | (At_EOF)  ) {
		goto EXIT;
	}
	LEFT;
	if(  cur_char == Hard_CR  ) {
		goto exit;
	}
  first_word;
  first_word_col = c_col;
	DOWN;
	GOTO LOOP;
EXIT:
}

macro NEXT_PARAGRAPH trans2 {
/********************************MULTI-EDIT MACRO******************************

Name: NEXT_PARAGRAPH

Description:  Finds the beginning of the next paragraph.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	RM( 'End_Of_Paragraph' );
	Refresh = FALSE;
LOOP:
	DOWN;
	First_Word;
	if(  (cur_char == Hard_Cr) | (At_EOL) |
			(copy(get_line, 1, length(page_str)) == page_str)  ) {
		if(  Not(At_EOF)  ) {
			Goto LOOP;
		}
	}
}


macro MARKPOS trans2 {
/********************************MULTI-EDIT MACRO******************************

Name: MARKPOS

Description:  Just acts as an interface to the macro function MARK_POS.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	mark_pos;
	make_message('Position marked.');
 // display_line;
}

macro GOTOMARK trans2 {
/********************************MULTI-EDIT MACRO******************************

Name: GOTOMARK

Description:  Just acts as an interface to the macro function GOTO_MARK.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	if( mark_stack_count == 0 ) {
		make_message('No markers on stack.');
	} else {
		goto_mark;
		make_message('Position retrieved.');
	}
}

#ifdef Windows
macro Set_Mark trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Description:	Uses the new random access marker stack to set 10 markers.
				If SET_MARK is executed without parameters, the user is prompted
				to press a number key (0-9, 0=10) to specify the marker #.  If a
				value of 1-10 is passed as a parameter, then the specified mark
				is set without prompting the user.

Parameters:		MParm_Str can contain 1-10 to denote setting that particular mark.

							(C) Copyright 1991-95 by American Cybernetics, Inc.
*******************************************************************************/

	int BookMark = 0;

	Val( BookMark, MParm_Str );
	SetRandomMark( BookMark, 0, "" );
	Return_Int = 100;

}  // Set_Mark

macro Get_Mark no_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Description:	Uses the new random access marker stack to retrieve 10 markers.
						If Get_Mark is executed without parameters, the user is prompted
						to press a number key (0-9, 0=10) to specify the marker #.  If a
						value of 1-10 is passed as a parameter, then the specified mark
						is retrieved without prompting the user.

Parameters:		MParm_Str can contain 1-10 to denote going directly to the mark.

							(C) Copyright 1991-95 by American Cybernetics, Inc.
*******************************************************************************/

	int BookMark = 0;

	Val( BookMark, MParm_Str );
	GetRandomMark( BookMark, 0 );
	Return_Int = 100;

}  // Get_Mark

macro Clr_Mark no_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Description:  Uses the new random access marker stack to clear 10 markers.
						If CLR_MARK is executed without parameters, the user is prompted
						to press a number key (0-9, 0=10) to specify the marker #.  If a
						value of 1-10 is passed as a parameter, then the specified mark
						is cleared without prompting the user.  Will also have the ability
						to clear all the markers.

Parameters:		MParm_Str can contain 1-10 to denote clearing that particular mark.
							Use 100 to clear all marks.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int BookMark = 0;

	Val( BookMark, MParm_Str );
	ClearRandomMark( BookMark, 0 );
	Return_Int = 100;

}  // Clr_Mark

int RandomMarkDlg( int Type, int GlobalMarks, str HelpCtx ) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-95  22:57

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int ActiveWinId  = Window_Id;
	int SavRefresh	 = Refresh;
	int Dlg;
	int Jx;
	int Bc;
	int Jk;
	int Line;
	int Position;
	int Row;
	int Offset;
	int DefaultBtn = 2;
	int DisableBtn = 0;
	int BookMark	 = 0;

	str Title = " Random Access Mark";
	str TStr	 = "Set  Get  Clear";

	if ( GlobalMarks ) {
		Title = " Global" + Title;
	}
	Title = Remove_Space( Copy( TStr, ( Type * 5 ) + 1, 5 ) ) + Title;

	Refresh = False;
	DlgCreate( Dlg );

	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			Dlg_PosOffset, Dlg_PosOffset + (Dlg_Units | 12),
			61, DLG_Units | 15,
			1010, 0, "" );

	for ( Jk = 1; Jk <= 9; ++Jk ) {
		Jx = True;
		if ( GlobalMarks == 1 ) {
			Jx = Global_Int( _GBMGlobal + Str( Jk ) );
			if ( !Switch_Win_Id( Jx ) ) {
				Jx = False;
				Line = 0;
			}
		}
		if ( Jx ) {
			Get_Mark_Record( Jk, 2, Line, Position, Row, Offset );
		}
		if ( Line > 0 ) {
			DisableBtn = 0;
			DlgAddCtrl( Dlg, dlg_BitmapStatic, "CHKMRK0",
					3 + ( 6 * ( Jk -  1 ) ), 1,
					0, 0,
					200 + Jk, 0, "" );
		}
		else {
			switch ( Type ) {
				case _bm_Set :
					if ( DefaultBtn == 2 ) {
						DefaultBtn = Jk + 100;
					}
					break;

					case _bm_Get :
					case _bm_Clear :
						DisableBtn = dlgf_Disable;
						break;
			}
		}
		DlgAddCtrl( Dlg, dlg_PushButton, "&" + Str( Jk ),
				2 + ( 6 * ( Jk -  1 ) ), 2,
				4, 0,
				100 + Jk, DisableBtn, "/R=" + Str( Jk + 100 ) );
	}
	Jk = 10;
	Jx = True;
	if ( GlobalMarks == 1 ) {
		Jx = Global_Int( _GBMGlobal + Str( Jk ) );
		if ( !Switch_Win_Id( Jx ) ) {
			Jx = False;
			Line = 0;
		}
	}
	if ( Jx ) {
		Get_Mark_Record( Jk, 2, Line, Position, Row, Offset );
	}
	if ( Line > 0 ) {
		DisableBtn = 0;
		DlgAddCtrl( Dlg, DLG_BitmapStatic, "CHKMRK0",
				3 + ( 6 * ( Jk -  1 ) ), 1,
				0, 0,
				200 + Jk, 0, "" );
	}
	else {
		switch ( Type ) {
			case _bm_Set :
				if ( DefaultBtn == 2 ) {
					DefaultBtn = Jk + 100;
				}
				break;

				case _bm_Get :
				case _bm_Clear :
					DisableBtn = dlgf_Disable;
					break;
		}
	}
	DlgAddCtrl( Dlg, dlg_PushButton, "1&0",
			2 + ( 6 * ( Jk - 1 ) ), 2,
			4, 0,
			100 + Jk, DisableBtn, "/R=" + Str( Jk + 100 ) );

	DlgAddCtrl( Dlg, dlg_PushButton, "Cancel",
			5, 4,
			dlg_StanBtnWidth, 0,
			2, 0, "/R=0" );

	if ( Type == _bm_Clear ) {
		DlgAddCtrl( Dlg, dlg_PushButton, "Clear &All",
				dlg_PosOffset + dlg_StanBtnWidth + 2, dlg_PosOffset + 0,
				0, 0,
				1000, 0, "/R=200" );
	}

	DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
			48, dlg_PosOffset + 0,
			dlg_StanBtnWidth, 0,
			3, 0, "/R=2" );

	Return_Int = DlgExecute( Dlg, DefaultBtn, Title, HelpCtx, "", 0 );
	DlgKill( Dlg );

	if ( Return_Int > 0 ) {
		BookMark = Return_Int - 100;
	}
	Switch_Win_Id( ActiveWinId );
	Refresh = SavRefresh;
	return ( BookMark );

}  // RandomMarkDlg

int SetRandomMark(
			int BookMark 		= Parse_Int( "/B=", MParm_Str ),
			int GlobalMarks	= Parse_Int( "/M=", MParm_Str ),
			str Label		 		= Parse_Str( "/L=", MParm_Str )
) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-95  18:36

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int ActiveWinId  = Window_Id;
	int SavRefresh	 = Refresh;
	int SavTabExpand = Tab_Expand;
	int Jx;

	if ( GlobalMarks == 0 ) {
		GlobalMarks = g_GlobalBookMarks;
	}
	if ( BookMark == 0 ) {
		BookMark = RandomMarkDlg( _bm_Set, GlobalMarks, SETRAND_HELPLINK );
	}
	if ( ( BookMark > 0 ) && ( BookMark < 11 ) ) {
		Refresh = False;
		// Get label
		if ( Svl( Label ) == 0 ) {
			Tab_Expand = False;
			Label = Remove_Space( Get_Line( ) );
			if ( Svl( Label ) > 30 ) {
				Label = Copy( Label, 1, 30 );
			}
			Tab_Expand = SavTabExpand;
		}
		if ( GlobalMarks == 1) {
			Jx = Global_Int( _GBMGlobal + Str( BookMark ) );
			if ( Jx ) {
				Set_Global_Int( _GBMGlobal + Str( BookMark ), 0 );
				if ( Switch_Win_Id( Jx ) ) {
					Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( BookMark ), "" );
					Set_Mark_Record( BookMark, 2, 0, 0, 0, 0 );
				}
			}
		}
		Switch_Win_Id( ActiveWinId );
		Set_Mark( BookMark );
		if ( GlobalMarks == 1 ) {
			if ( BriefMode ) {
				Rm( "BRIEF^BrFindBuffer /ID=1/B=" + Str( Buffer_Id ) );
				Set_Global_Int( _GBMGlobal + Str( BookMark ), Return_Int );
			}
			else {
				Set_Global_Int( _GBMGlobal + Str( BookMark ), Window_Id );
			}
			Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( BookMark ),
					"G" + Label );
		}
		else {
			Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( BookMark ),
					" " + Label );
		}
		Make_Message( "Bookmark #" + Str( BookMark ) + " set." );
		Refresh = SavRefresh;
		Redraw;
	}
	return ( Return_Int = BookMark );

}  // Set_Mark

int GetRandomMark(
			int BookMark 		= Parse_Int( "/B=", MParm_Str ),
			int GlobalMarks	= Parse_Int( "/M=", MParm_Str ),
) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 15-Sep-95  23:26

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int ActiveWinId  = Window_Id;
	int SavRefresh	 = Refresh;
	int SavTabExpand = Tab_Expand;
	int BufferId;
	int Jx;

	if ( GlobalMarks == 0 ) {
		GlobalMarks = g_GlobalBookMarks;
	}
	if ( BookMark == 0 ) {
		BookMark = RandomMarkDlg( _bm_Get, GlobalMarks, RETRAND_HELPLINK );
	}
	if ( ( BookMark > 0 ) && ( BookMark < 11 ) ) {
		Refresh = False;
		if ( GlobalMarks == 1 ) {
			Jx = Global_Int( _GBMGlobal + Str( BookMark ) );
			if ( Switch_Win_Id( Jx ) ) {
				Rm( "Select_Window /BM=1/VIS=1" );
			}
		}
		Get_Mark( BookMark );
		Make_Message( "Bookmark #" + Str( BookMark ) + " retrieved." );
		Refresh = SavRefresh;
		Redraw;
	}
	return ( Return_Int = BookMark );

}  // GetRandomMark

int ClearRandomMark(
			int BookMark 		= Parse_Int( "/B=", MParm_Str ),
			int GlobalMarks	= Parse_Int( "/M=", MParm_Str ),
) trans2 {
/******************************************************************************
															 Multi-Edit Macro
															 16-Sep-95  00:53

  Function:
  Entry   :
  Exit    :
  Globals :
  Macros  :

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int ActiveWinId  = Window_Id;
	int SavRefresh	 = Refresh;
	int SavTabExpand = Tab_Expand;
	int Jx;
	int Jy;

	if ( GlobalMarks == 0 ) {
		GlobalMarks = g_GlobalBookMarks;
	}
	if ( BookMark == 0 ) {
		BookMark = RandomMarkDlg( _bm_Clear, GlobalMarks, CLRRAND_HELPLINK );
	}
	if ( ( BookMark > 0 ) && ( BookMark < 11 ) ) {
		if ( GlobalMarks == 1 ) {
			Refresh = False;
			Jx = Global_Int( _GBMGlobal + Str( BookMark ) );
			Set_Global_Int( _GBMGlobal + Str( BookMark ), 0 );
			if ( Switch_Win_Id( Jx ) ) {
				Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( BookMark ), "" );
				Set_Mark_Record( BookMark, 2, 0, 0, 0, 0 );
				Switch_Win_Id( ActiveWinId );
			}
			Refresh = SavRefresh;
			Redraw;
		}
		else {
			Set_Mark_Record( BookMark, 2, 0, 0, 0, 0 );
			Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( BookMark ), "" );
		}
		Make_Message( "Bookmark #" + Str( BookMark ) + " cleared." );
	}
	else if ( BookMark == 100 ) {
		Refresh = False;
		if ( GlobalMarks == 1 ) {
			for ( Jy = 1; Jy < 11; ++Jy ) {
				Jx = Global_Int( _GBMGlobal + Str( Jy ) );
				Set_Global_Int( _GBMGlobal + Str( Jy ), 0 );
				if ( Switch_Win_Id( Jx ) ) {
					Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jy ), "" );
					Set_Mark_Record( Jy, 2, 0, 0, 0, 0 );
				}
			}
			Switch_Win_Id( ActiveWinId );
		}
		else {
			for ( Jy = 1; Jy < 11; ++Jy ) {
				Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jy ), "" );
				Set_Mark_Record( Jy, 2, 0, 0, 0, 0 );
			}
		}
		Make_Message( "All bookmarks cleared." );
		Refresh = SavRefresh;
		Redraw;
	}
	return ( Return_Int = BookMark );

}  // ClearRandomMark

	#define id_bkm_Text				1000
	#define id_bkm_Text1			1001
	#define id_bkm_Text2			1002
	#define id_bkm_Text3			1003
	#define id_bkm_Text4			1004
	#define id_bkm_Text5			1005
	#define id_bkm_Text6			1006
	#define id_bkm_Text7			1007
	#define id_bkm_Text8			1008
	#define id_bkm_Text9			1009
	#define id_bkm_Text10			1010

	#define id_bkm_CheckBox  	1100
	#define id_bkm_CheckBox1  1101
	#define id_bkm_CheckBox2  1102
	#define id_bkm_CheckBox3  1103
	#define id_bkm_CheckBox4  1104
	#define id_bkm_CheckBox5  1105
	#define id_bkm_CheckBox6  1106
	#define id_bkm_CheckBox7  1107
	#define id_bkm_CheckBox8  1108
	#define id_bkm_CheckBox9  1109
	#define id_bkm_CheckBox10	1110

	#define id_bkm_GlobalCB		1200

	#define id_bkm_Btn				2100
	#define id_bkm_Btn1				2101
	#define id_bkm_Btn2				2102
	#define id_bkm_Btn3				2103
	#define id_bkm_Btn4				2104
	#define id_bkm_Btn5				2105
	#define id_bkm_Btn6				2106
	#define id_bkm_Btn7				2107
	#define id_bkm_Btn8				2108
	#define id_bkm_Btn9				2109
	#define id_bkm_Btn10			2110

	#define id_bkm_Close			2000
	#define id_bkm_ClearAll  	2005

void BookMarks( ) trans2 {
/*******************************************************************************
																 MULTI-EDIT MACRO

Name:   BOOKMARKS

Description:  This macro displays a dialog with the ability to set 10
					"Bookmarks". Each bookmarks is numbered 1- 10.  The default label or
					text for each marker will be the first 30 characters of the line in
					which the cursor is in, from the position of the cursor.  The cursor
					return to the position it was prior setting of the bookmark.  Leading
					and trailing space will be removed.  The label for each button may be
					changed to any text up to the 30 character limit by typing in the new
					text.  A default text box has the initial focus but the markers may
					be set randomly.  The CLOSE button is set and can be activated by
					pressing the CR.

TO USE:   Have the cursor at the position to mark and start this macro.  Or
					alternatively, start the macro, select the main window and move the
					cursor to the point to be marked.  If the cursor is on text to be
					used for the text box, press the CHECKBOX to 'x' it and the text will
					be displayed.  You can type in the text you wish, then select the
					CHECKBOX.

					To change the text in a marker that already has been set, select the
					marker then click on the CHECKBOX.  This will remove the marker and
					the contents.  Then reset it as above.

					To retrieve a location, click the numbered MARKER button of the
					position to go to.

					The BOOKMARKS dialog will remain on screen until it is closed.  Only
					one occurrence of this dialog may run at one time

					The CLEAR ALL removes all markers, text, and the global markers text..

					This dialog is MODELESS so it can be started, and the file can be
					scanned manually to set the point to set.

Parameters:   None.

							 (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	 // If already open switch to it so only one occurrence.
	if ( g_hBookMarkDlg != 0 ) {
		SetActiveWindow( g_hBookMarkDlg );
		return( );
	}

	int TRefresh 		= Refresh;
	int ActiveWinId = Window_Id;
	int jx, bc, jk, line, position, row, col, offset;
	int Dlg;
	int YPos = 0;
	int Default_Button = 2;
	int CtrlId = 100;
	int TextWid = 37;
	int BtnX;
	int TextX;
	int SelBtnX;
	int CBoxX;
	int FrameX;

	str Label;

	Refresh = False;
	if ( Global_Int( "&BtnOnRight" ) ) {
		FrameX = 1;
		TextX = FrameX + 1;
		CBoxX = TextX + TextWid + 1;
		SelBtnX = CBoxX + 4;
		BtnX = SelBtnX + 6;
	}
	else {
		BtnX = 1;
		FrameX = dlg_StanBtnWidth + 2;
		SelBtnX = FrameX + 1;
		CBoxX = SelBtnX + 5;
		TextX = CBoxX + 4;
	}
	DlgCreate( Dlg );
	g_BookMarkBuf = Buffer_Id;
	// Check to see if buttons 1 thru 9 are used
	for ( Jk = 1; Jk < 10; ++Jk ) {
		Jx = True;
		if ( g_GlobalBookMarks ) {
			Jx = Global_Int( _GBMGlobal + Str( Jk ) );
			if ( !Switch_Win_Id( Jx ) ) {
				Jx = False;
				Line = 0;
				Label = "";
			}
		}
		if ( Jx ) {
			Get_Mark_Record( Jk, 2, Line, Position, Row, Offset );
			// Set the text box with the 'label'
			if ( Line == 0 ) {
				Label = "";
				Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ), "" );
			}
			else {
        Label = Copy( Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ) ), 2, MAXSIZE_BOOKMARK );
			}
		}
		// Draw the numbered push buttons.
		DlgAddCtrl( Dlg, dlg_PushButton, "&" + Str( Jk ),
				SelBtnX, Dlg_PosOffset + YPos,
				4, 0,
				id_bkm_Btn + Jk, 0, "" );
		// Add the check box
		DlgAddCtrl( Dlg, dlg_Checkbox, "",
				CBoxX, dlg_PosOffSet + 0,
				0, 0,
				id_bkm_CheckBox + Jk, 0, "" );
		if ( Line > 0 ) {             // if button is used, put a check mark next to that number
			DlgSetInt( Dlg, id_bkm_CheckBox + Jk, 1);
		}
		else if ( Default_Button == 2 ) {
			Default_Button = Jk + id_bkm_Text;   // else make that text box the default.
		}
		// Draw the text boxes for each button 1 thru 9
		DlgAddCtrl( Dlg, dlg_Text, Label,
				TextX, Dlg_PosOffset + 0,
				TextWid, Dlg_Units,
        id_bkm_Text + Jk, 0, "/M=" + str (MAXSIZE_BOOKMARK));

		YPos = ( Dlg_Units | 15 );      // calc for the position of the next button
	}
	Jk = 10;
	Jx = True;
	if ( g_GlobalBookMarks ) {
		Jx = Global_Int( _GBMGlobal + Str( Jk ) );
		if ( !Switch_Win_Id( Jx ) ) {
			Jx = False;
			Line = 0;
			Label = "";
		}
	}
	if ( Jx ) {
		Get_Mark_Record( Jk, 2, Line, Position, Row, Offset );
		// Set the text box with the 'label'
		if ( Line == 0 ) {
			Label = "";
			Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ), "" );
		}
		else {
      Label = Copy( Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ) ), 2, MAXSIZE_BOOKMARK);
		}
	}
	// Draw the numbered push buttons.
	DlgAddCtrl( Dlg, dlg_PushButton, "1&0",
			SelBtnX, Dlg_PosOffset + YPos,
			4, 0,
			id_bkm_Btn + Jk, 0, "" );
	// Draw the text boxes for each button 1 thru 9
	DlgAddCtrl( Dlg, dlg_Text, Label,
			TextX, Dlg_PosOffset,
			TextWid, Dlg_Units,
			id_bkm_Text + Jk, 0, "" );
	// Add the check box
	DlgAddCtrl( Dlg, dlg_Checkbox, "",
			CBoxX, dlg_PosOffSet,
			0, 0,
			id_bkm_CheckBox + Jk, 0, "" );
	if ( Line > 0 ) {             // if button is used, put a check mark next to that number
		DlgSetInt( Dlg, id_bkm_CheckBox + Jk, 1);
	}
	else if ( Default_Button == 2 ) {
		Default_Button = Jk + id_bkm_Text;   // else make that text box the default.
	}
	// Finish puting the rest of the controls for the dialog box.
	DlgAddCtrl( Dlg, dlg_CheckBox, "&Enable Global BookMarks",
			FrameX + 1, dlg_PosOffset + 2,
			0, 0,
			id_bkm_GlobalCB, 0, "" );
	DlgSetInt( Dlg, id_bkm_GlobalCB, g_GlobalBookMarks == True );

	DlgAddCtrl( Dlg, dlg_BlackFrame, "",
			FrameX, 1,
			TextWid + 11, Dlg_PosOffset + (Dlg_Units | 150 ),
			CtrlId, 0, "" );

	DlgAddCtrl( Dlg, Dlg_BitmapStatic, "BT_SR_116",
			BtnX + 3, 2,
			5, 5,
			++CtrlId, 0, "" );

	DlgAddCtrl( Dlg, dlg_PushButton, "Clear &All",
			BtnX, 10,
			dlg_StanBtnWidth, 0,
			id_bkm_ClearAll, 0, "/R=5" );

	DlgAddCtrl( Dlg, dlg_PushButton, "Close",
			dlg_PosOffset + 0, dlg_PosOffset + dlg_Units_3HLines,
			dlg_StanBtnWidth, 0,
			id_bkm_Close, Dlgf_DefButton, "/R=0" );

	DlgAddCtrl( Dlg, dlg_PushButton, "&Help",
			dlg_PosOffset, dlg_PosOffset + dlg_Units_5QLines,
			dlg_StanBtnWidth, 0,
			3, 0, "/R=2");

	Return_Int = DlgExecute( Dlg, Default_Button, "Bookmarks", hcBookmarks,
      "/RPOS=BookMarkPos/HOOK=SetMarkProc", dlg_Modeless | Dlg_Nopardisable );

	Switch_Win_Id( ActiveWinId );
	Refresh = TRefresh;

}  // BookMarks

int SetMarkProc( int &retval, int dlg, int message, int wparam, int lparam, str parms ) no_break
{
	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int TTab_Expand = Tab_Expand;
	int Line;
	int Col;
	int Row;
	int Offset;
	int Result;
	int Jk;
	int Jx;

	str Label;
	str GStr = _BMGlobal + Str( Buffer_Id );

	if ( Message == wm_NEWACTIVEMDI ) {
		goto Check_Active;
	}
	switch ( Message ) {
		case wm_ACTIVATE :
			if ( WParam  ) {

Check_Active:
				if ( g_BookMarkBuf != Buffer_Id ) {
					call UpdateBook;
				}
			}
			break;

    case WM_DESTROY :
			g_hBookMarkDlg = 0;
			break;

    case WM_SYSCOMMAND :
      if ( WParam == SC_CLOSE ) {
				DestroyWindow( Dlg );
			}
			break;

		case wm_COMMAND :
			switch ( WParam ) {
				case DLG_Wcmd_Init :
					g_hBookMarkDlg = Dlg;
					break;

        case ID_BKM_CLOSE :                // CLOSE Button
					Make_Message( "Bookmarks closed" );
					RetVal = 0;
					DestroyWindow( Dlg );
					return ( True );
					break;

        case ID_BKM_CLEARALL :                // CLEAR ALL bookmarks button
					ClearRandomMark( 100, 0 );
					for ( Jk = 1; Jk < 11; ++Jk) {
						SendDlgItemMessage( Dlg, id_bkm_CheckBox + Jk, bm_SetCheck, 0, 0 );
						SetDlgItemText( Dlg, id_bkm_Text + Jk, "" );
					}
					return( True );
					break;

				// Check to see if any of the MARKER buttons was pushed.
        case ID_BKM_BTN1 :
        case ID_BKM_BTN2 :
        case ID_BKM_BTN3 :
        case ID_BKM_BTN4 :
        case ID_BKM_BTN5 :
        case ID_BKM_BTN6 :
        case ID_BKM_BTN7 :
        case ID_BKM_BTN8 :
        case ID_BKM_BTN9 :
        case ID_BKM_BTN10 :
          Jk = WParam - ID_BKM_BTN;     // If it was, get which one
					GetRandomMark( Jk, 0 );
					SetFocus( Dlg );
					break;

				// Check to see if a CHECKBOX was activated and process.
				case id_bkm_CheckBox1 :
				case id_bkm_CheckBox2 :
				case id_bkm_CheckBox3 :
				case id_bkm_CheckBox4 :
				case id_bkm_CheckBox5 :
				case id_bkm_CheckBox6 :
				case id_bkm_CheckBox7 :
				case id_bkm_CheckBox8 :
				case id_bkm_CheckBox9 :
				case id_bkm_CheckBox10 :
					//Strip of the code and get single digit to see which one activated.
					Jk = WParam - id_bkm_CheckBox;
					// Now get the state of that CHECKBOX
					Jx = SendDlgItemMessage( dlg, id_bkm_CheckBox + Jk, bm_GetState, 0, 0);
					// If clicked, check the state being set.
					Jx &= 0x0003;
					if ( Jx == 1 ) {        // One means active.
						// Get whatever text is in the text box, if any, and put into the var LABEL.
            GetDlgItemText( Dlg, id_bkm_Text + Jk, Label, MAXSIZE_BOOKMARK );
						if ( Svl( Label ) == 0 ) {
							// Label is blank, make a label.
							Tab_Expand = False;
							Label = Remove_Space( Get_Line( ) );
              if ( Svl( Label ) > MAXSIZE_BOOKMARK ) {
                Label = Copy( Label, 1, MAXSIZE_BOOKMARK );
							}
							Tab_Expand = TTab_Expand;
							SetDlgItemText( Dlg, id_bkm_Text + Jk, Label );
						}
						SetRandomMark( Jk, 0, Label );
					}
					else {
						 // Else the checkbox was cleared so clear the mark and text box.
						SetDlgItemText( Dlg, id_bkm_Text + Jk, "" );
						SendDlgItemMessage( Dlg, id_bkm_CheckBox + Jk, bm_SetCheck, 0, 0 );
						ClearRandomMark( Jk, 0 );
					}
					break;

				case id_bkm_GlobalCB :
					g_GlobalBookMarks = SendMessage( GetDlgItem( Dlg, id_bkm_GlobalCB ),
						bm_GetCheck, 0, 0 );
					call UpdateBook;
					SetFocus( Dlg );
					break;
			}
	}
	return( DlgMessageProc( RetVal, Dlg, Message, WParam, LParam, Parms ) );


UpdateBook:
	Refresh = False;
	// Reset to the current window
	g_BookMarkBuf = Buffer_Id;
	// Check to see if buttons 1 thru 10 are used
	for ( Jk = 1; Jk < 11; ++Jk ) {
		// First clear out the dialog box text and check mark
		SetDlgItemText( Dlg, id_bkm_Text + Jk, "" );
		SendDlgItemMessage( Dlg, id_bkm_CheckBox + Jk, bm_SetCheck, 0, 0 );
		// Now see if this window has any previous marks and text set.
		if ( g_GlobalBookMarks ) {
			Jx = Global_Int( _GBMGlobal + Str( Jk ) );
			if ( !Switch_Win_Id( Jx ) ) {
				continue;
			}
		}
		Label = Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ) );
		if ( Svl( Label ) != 0 ) {
      Label = Copy( Label, 2, MAXSIZE_BOOKMARK );
		}
		Get_Mark_Record( Jk, 2, Line, Col, Row, Offset );
		// get it if button is used, put a check mark next to that number
		if ( Line > 0 ) {
			SetDlgItemText( Dlg, id_bkm_Text + Jk, Label);
			SendDlgItemMessage( Dlg, id_bkm_CheckBox + Jk, bm_SetCheck, 1, 0 );
		}
		else {
			// Clear global
			Set_Global_Str( _BMGlobal + Str( Buffer_Id ) + Str( Jk ), "" );
		}
	}
	Switch_Win_Id( OrgWin );
	Refresh = TRefresh;
	ret;

}  // SetMarkProc

#else
macro SET_MARK trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:		SET_MARK

Description:	Uses the new random access marker stack to set 10 markers.
				If SET_MARK is executed without parameters, the user is prompted
				to press a number key (0-9, 0=10) to specify the marker #.  If a
				value of 1-10 is passed as a parameter, then the specified mark
				is set without prompting the user.

Parameters:		MParm_Str can contain 1-10 to denote going directly to the mark.
							If the entire MParm_Str does not contain numeric characters, this
							option will not work, and the menu will be invoked.  Under these
							circumstances, the following parameters are expected:
							/X=		The X coordinate for the menu
							/X=		The X coordinate for the menu
							/BC=	The amount of boxes which need to be killed upon exit

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  jx, bc, jk, line, position, row, offset;
	int	 menu = menu_create;

		/* If a numeric parameter was passed then use it, and bypass
		 the prompting */
	if(  Val(jx, MParm_Str) == 0  ) {
		if(  (jx > 0) & (jx < 11)  ) {
			goto do_set;
		}
	}
	for( jk = 1; jk <= 9; ++jk ) {
		get_mark_record( jk, 2, line, position, row, offset );
		if ( line <= 0 ) {
			menu_set_item( menu, jk, ' ' + str( jk ) + ' ', '', '', 0, 0, 0 );
		}
		else {
			menu_set_item( menu, jk, '|175' + str( jk ) + ' ', '', '', 0, 0, 0 );
		}
	}
	get_mark_record( 10, 2, line, position, row, offset );
	if ( line <= 0 ) {
		menu_set_item( menu, 10, ' 0 ', '', '', 0, 0, 0 );
	}
	else {
		menu_set_item( menu, 10, "\xAF\x30 ", '', '', 0, 0, 0 );
	}
//	menu_set_item( menu, 10, ' 0 ', '', '', (line <= 0), 0, 0 );
	return_int = menu;
	RM('USERIN^TOPMENU /HN=1/#=10/H=PMRANDOM/L=Select marker # to set/X=' +
							parse_str('/X=', mparm_str) +
							'/Y=' + parse_str('/Y=', mparm_str) );

/*	RM('USERIN^XMENU /B=1/L=Select marker # to set/X=' + parse_str('/X=', mparm_str) +
							'/Y=' + parse_str('/Y=', mparm_str) +
																	 '/M=1 (PMRANDOM)2 ()3 ()4 ()5 ()6 ()7 ()8 ()9 ()0 ()');
*/
	if(  return_int <= 0  ) {
		goto exit;
	}
	jx = return_int;
	return_int = 100;
do_set:
	bc = parse_int('/BC=', mparm_str);
	while(  box_count > bc  ) {
		kill_box;
	}
	set_mark( jx );
	make_message('Marker #' + str(jx) + ' set.' );
exit:
	menu_delete( menu );
}

macro GET_MARK no_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:		GET_MARK

Description:	Uses the new random access marker stack to retrieve 10 markers.
						If GET_MARK is executed without parameters, the user is prompted
						to press a number key (0-9, 0=10) to specify the marker #.  If a
						value of 1-10 is passed as a parameter, then the specified mark
						is retrieved without prompting the user.

Parameters:		MParm_Str can contain 1-10 to denote setting that particular mark.
							If the entire MParm_Str does not contain numeric characters, this
							option will not work, and the menu will be invoked.  Under these
							circumstances, the following parameters are expected:
							/X=		The X coordinate for the menu
							/X=		The X coordinate for the menu
							/BC=	The amount of boxes which need to be killed upon exit

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int  jx, bc,
			 menu = menu_create,
			 line, offset, row, position,
			 jk
			 ;

		/* If a numeric parameter was passed then use it, and bypass
		 the prompting */
	if(  Val(jx, MParm_Str) == 0  ) {
		if(  (jx > 0) & (jx < 11)  ) {
			goto do_get;
		}
	}
	for( jk = 1; jk <= 9; ++jk ) {
		get_mark_record( jk, 2, line, position, row, offset );
		if ( line <= 0 ) {
			menu_set_item( menu, jk, ' ' + str( jk ) + ' ', '', '', 1, 0, 0 );
		}
		else {
			menu_set_item( menu, jk, '|175' + str( jk ) + ' ', '', '', 0, 0, 0 );
		}
	}
	get_mark_record( 10, 2, line, position, row, offset );
	if ( line <= 0 ) {
		menu_set_item( menu, 10, ' 0 ', '', '', 1, 0, 0 );
	}
	else {
		menu_set_item( menu, 10, "\xAF\x30 ", '', '', 0, 0, 0 );
	}
//	menu_set_item( menu, 10, ' 0 ', '', '', (line <= 0), 0, 0 );
	return_int = menu;
	RM('USERIN^TOPMENU /HN=1/#=10/H=PMRANDOM/L=Select marker # to retrieve/X=' +
							parse_str('/X=', mparm_str) +
							'/Y=' + parse_str('/Y=', mparm_str) );
	if(  return_int <= 0  ) {
		goto exit;
	}
	jx = return_int;
	return_int = 100;
do_get:
	bc = parse_int('/BC=', mparm_str);
	while(  box_count > bc  ) {
		kill_box;
	}
	get_mark( jx );
	make_message('Marker #' + str(jx) + ' retrieved.' );
exit:
	menu_delete( menu );
}
#endif



// --------------------  C A S E   C O N V E R S I O N -----------------

// Save this as chngcase.sh or in text.sh
//prototype chngcase
//{
//  void ChangeCase(int nBackCompat, nDirection, nTextType);
//  void ChangeCaseStdDlg();
//  void ChangeCaseBtnDlg();
//  void CCPushBtnDlg();
//}


/******************* Multi-Edit STRING Local Macro Function *****************

 NAME:        Get_Alpha_Word

 DESCRIPTION: Get the next word that contains alphabetic characters
							limit scan within the currently marked block

 PARAMETERS:  int tbl1, tbl2, tbc1, tbc2 - marked block boundaries

 RETURNS:     str, the next word containing alpha chars

*****************************10-03-94 08:17am*******************************/
str Get_Alpha_Word(int tbl1, tbl2, tbc1, tbc2);
{
	str tstr  = '';
	str tstr2 = '';

	str cmpstr1, cmpstr2;

	int currcol, i, jz, valid_alphabetic;

	str addl_word_delimits = '1234567890-~+=';

	int ll, jl, keep_scanning;

mark_pos;
	jl = tbl1;
	keep_scanning = False;

	while ( jl <= tbl2 )
	{
		goto_line(jl);
		if ( (jl == tbl1) || (block_stat == 2) )
		{
			goto_col(tbc1);
		}
		else
		{
			goto_col(1);
		}

		// skip any leading non-alphas
		forward_till_not(word_delimits+addl_word_delimits);
		if ( (block_stat == 2) && (c_col > tbc2) )
		{

		}
		else
		if (!at_eol)
		{
			tstr = get_word(word_delimits);
			if ( (c_col > tbc2) && (block_stat == 2) )
			{
				tstr = copy(tstr,1,(c_col-tbc2));
			}

			if ( block_stat )
			{
				cmpstr1 = tstr;
				if ( !at_eol )
				{
					break; // the while loop
				}
			}
			else
			{
				break;
			}

		}
		jl++;
	}

// ---- scan for next word in block, starting at last line and col

	while ( jl <= tbl2 )
	{
		// skip any leading non-alphas
		forward_till_not(word_delimits+addl_word_delimits);

		if (!at_eol)
		{
			currcol = c_col;
			tstr2 = get_word(word_delimits);
			if ( (c_col > tbc2) && (block_stat) )
			{
				if ( (jl == tbl2) || (block_stat == 2) )
				{
					tstr2 = copy(tstr2,1,(tbc2-currcol+1));
				}
			}

			if ( block_stat )
			{
				cmpstr2 = tstr2;
				break; // the while loop
			}
			else
			{
				break;
			}

		}

		jl++;
	}


goto_mark;
	if ( block_stat )
	{
		tstr = cmpstr1+cmpstr2;
	}
	return (tstr);
}




/******************** Multi-Edit VOID Macro Function ************************

 NAME:        ChangeCase

 DESCRIPTION: Changes the case of a word, line, or block of text

 PARAMETERS:

		Function arguments:

			if  nBackCompat == 0   use new style of changing case

							nDirection  = 1     convert word/block to lowercase
							nTextType   = ?

							nDirection  = 2     convert word/block to upper Case
							nTextType   = ?     for either word or block
																	depending on block_stat

							nDirection  = 3     convert word/block to proper case
							nTextType   = ?

							nDirection  = 4     convert word/block to inverted case
							nTextType   = ?     (toggle case)

							nDirection  = 0     text is scanned to determine
							nTextType   = ?     most likely conversion
																	(lower to upper to proper)
																	(upper to proper to lower)
																	(proper to lower to upper)





			if nBackCompat == 1:       Backwards compatible with TEXT^CHNGCASE,

							nDirection  = 0    to lower
													= 1    to upper

							nTextType   = 0    line
													= 1    word
													= 2    block

			if nBackCompat == nDirection == 0 nTextType == 0



 -- or --


		Command-line arguments:

			if /B == 0                 new style

							/U           = 0    word/block is scanned to determine
							/T           = ?    most likely conversion
																	(lower to upper to proper)
																	(upper to proper to lower)
																	(proper to lower to upper)


							/U            = 1   word/block is converted to lowercase
							/T            = ?

							/U            = 2   word/block is converted to uppercase
							/T            = ?   (ignored)

							/U            = 3   word/block is converted to proper case
							/T            = ?

							/U            = 4   case of word/block is toggled
							/T            = ?






		 if /B == 1:          backwards compatible with text^chngcase

							/U          = 0   Lowercase
													= 1   Uppercase


							/T          = 0   Line
													= 1   Word
													= 2   Block




 RETURNS:      (void)

							 NOTE: return_str and return_int are preserved


 COMMENTS:

		new style of changing case:

							- if a block is marked, then the text within the block
								is case-converted.
								NOTE: the block remains marked.

							- if there is no block mark, then the nearest word to the
								cursor position (within 1 character) is case-converted,
								otherwise, no case conversion is performed

							- the word (or first word in block) is scanned for current
								case.  case conversions are done by this method:

									if lower, convert to upper
									if upper, convert to proper
									if proper, convert to lower


*****************************09-30-94 11:43am*******************************/
void ChangeCase
(
	int nBackCompat= parse_int('/B=',mparm_str),
	int nDirection = parse_int('/U=',mparm_str),
	int nTextType  = parse_int('/T=',mparm_str)
)
{
	int  jx, tc, ti, tl, casetype, blocktype,
			 tb1, tbs, tb2, tbl1, tbl2, tbc1, tbc2,
			 tpb = persistent_blocks;
	str  tstr ;
	str  cctstr,cctstr2,cctstr3;

	int jz,asval,lx,lcb,lsb;

	int sv_x = c_col;
	int sv_y = c_line;
	int t_x, t_x2;

	int sv_refresh = refresh;
	int sv_return_int = return_int;
	str sv_return_str = return_str;

	str copyresult;
	str prevchar;
	str newchar;

	int force_proper;
	int force_lower;
	int force_upper;
	int force_toggle;

	push_undo;
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */    refresh = false;
	ti = insert_mode;
	insert_mode = true;


	cctstr = '';


	if ( nBackCompat )                // Old style
	{
		RM( 'TEXT^CHNGCASE '+
					'/U='+str(nDirection) +
					'/T='+str(nTextType)
			 );

	}
	else                              // New Style of changing case
	{

		force_lower  = (nDirection == 1);
		force_upper  = (nDirection == 2);
		force_proper = (nDirection == 3);
		force_toggle = (nDirection == 4);


		if ( block_stat )
		{
			persistent_blocks = TRUE;
			block_end;
			make_message('');
			tbl1 = block_line1; tbl2 = block_line2;
			tbc1 = block_col1; tbc2 = block_col2;
			tbs = block_stat;
			mark_pos;
			jx = block_line1;

			mark_pos;
			if ( tbs == 1 )
				goto_col(1);

			cctstr = Get_Alpha_Word(tbl1,tbl2,tbc1,tbc2);
			if ( cctstr == '' )
				goto ccexit;

			if ( force_lower )
				return_int = 1;
			else if ( force_upper )
				return_int = 2;
			else if ( force_proper )
				return_int = 3;
			else if ( force_toggle )
			{
				return_int = 4;
			}
			else
				call cc_GetDirection;

			nDirection = return_int;
			goto_mark;

			working;
			while(  jx <= tbl2  ) {
				goto_line(jx);

				if(  tbs == 1  )                  // line
				{
					switch ( nDirection )
					{
						case 1 :        // lower
							put_line( lower(get_line));
							break;
						case 2 :        // upper
							Put_Line( caps(get_line));
							break;
						case 3 :        // proper
							cctstr = '';
							cctstr2 = get_line;
							goto_col(1);
							while ( !at_eol )
							{
								tstr = get_word(word_delimits);
								if ( svl(tstr) )
								{
									tstr = caps(str_char(tstr,1))+lower(str_del(tstr,1,1));
									tl = svl(tstr);
									if ( tl > 1 )
									{
										for ( lx = 2; lx < tl; lx++ )
										{
											if ( str_char(tstr,lx) == '_' )
											{
												tstr = copy( tstr, 1, lx)+
																caps( str_char( tstr, lx+1))+
																copy( tstr, lx+2, tl-lx-1);
											}
										}
									}
								}
								else
								{
									t_x = c_col;
									word_right;
									tstr += Copy(cctstr2,t_x,c_col-t_x);
								}
								cctstr += tstr;
							}
							put_line(cctstr);
							break;

						Case 4 :  // Toggle Case, line

							 goto_col(1);
							 insert_mode = false;  // OVERWRITE
							 while ( !at_eol )
							 {
									forward_till_not(word_delimits + '|255');
									if ( ( ascii(cur_char) > 96 ) &&
										 ( ascii(cur_char) < 123)
										 )
									{
										 text(caps(cur_char));
									}

									else if ( ( ascii(cur_char) > 64 ) &&
													 ( ascii(cur_char) < 91)
												)
									{
										 TEXT(LOWER(CUR_char));
									}
									else
									{
										 right; // let it go
									}

							 }
							 insert_mode = True;
							 break;
					}
				}

				else if(  tbs == 2  )                  // column
				{
					goto_col(tbc1);
					cctstr3 = get_line;
					forward_till_not('|255|9 ');  // Skip  over leading white space
					tb1 = c_col;
					tstr = copy(get_line, tb1, tbc2 - tb1 + 1);
					lcb = svl(tstr);
					mark_pos;
					switch ( nDirection )
					{
						case 1 :
							tstr = lower(tstr);
							break;
						case 2 :
							tstr = caps(tstr);
							break;
						case 3 :        // proper
							cctstr = '';
							cctstr2 = '';

							while ( c_col <= tbc2 )
							{
								newchar = cur_char;
								if ( c_col == tbc1 )
								{
									mark_pos;


									left;
									if ( c_line == jx )
									{
										prevchar = cur_char;
										if ( !xpos(prevchar,word_delimits+' 1234567890-~+=',1) )
										{
											newchar = lower(newchar);
										}
										else
										{
											newchar = caps(newchar);
										}
									}
									else
									{
										newchar = caps(newchar);
									}

									goto_mark;
								}
								else
								{
									if ( force_upper )
									{
										newchar = caps(cur_char);
									}
									else if ( force_lower )
									{
										newchar = lower(cur_char);
									}
									else if ( force_proper )
									{
										newchar = caps(cur_char);
									}
									else
										newchar = cur_char;
								}

								cctstr = get_word(word_delimits);
								if ( svl(cctstr)  )
								{
									cctstr = newchar+lower(str_del(cctstr,1,1));
									tl = svl(cctstr);
									if ( tl > 1 )
									{
										for ( lx = 2; lx < tl; lx++ )
										{
											if ( str_char(cctstr,lx) == '_' )
											{
												cctstr = copy( cctstr, 1, lx)+
																caps( str_char( cctstr, lx+1))+
																copy( cctstr, lx+2, tl-lx-1);
											}
										}
									}
								}
								else
								{
									t_x = c_col;
									word_right;
									if ( jx == c_line )
									{
										copyresult = Copy(cctstr3,t_x,c_col-t_x);
										cctstr += copyresult;
									}
									else
									{

										cctstr = '';
										word_left;
										goto_col(tbc2+1);
									}
								}
								cctstr2 += cctstr;
							}

// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
							tstr = copy(cctstr2,1,lcb);
							break;

						case 4 :    // toggle case, column

							 goto_col(tb1);
							 insert_mode = false;  // OVERWRITE
							 while ( c_col <= tbc2 )
							 {
									forward_till_not(word_delimits);
									if ( c_col <= tbc2 )
									{

										 if ( ( ascii(cur_char) > 96 ) &&
												( ascii(cur_char) < 123)
												)
										 {
												text(caps(cur_char));
										 }

										 else if ( ( ascii(cur_char) > 64 ) &&
															( ascii(cur_char) < 91)
													 )
										 {
												text(lower(cur_char));
										 }
										 else
										 {
												right; // let it go
										 }
									}

							 }
							 insert_mode = True;

							break;
					}
					goto_mark;
					insert_mode = false;
					if ( nDirection != 4 )
						text( tstr );
					insert_mode = true;
				}

				else if(  tbs == 3  ) {              // stream
					goto_col(1);
					tstr = get_line;
					tb2 = svl( tstr );
					if ( tb2 != 0 )
					{
						if(  jx == tbl1  ) {
							 goto_col(tbc1);
							 tb1 = tbc1;
						}
						if(  jx == tbl2  ) {
							tb2 = tbc2;
						}
						forward_till_not ('|255|9 ');
						tb1 = c_col;

						mark_pos;
						cctstr3 = get_line;
						tstr = copy( tstr, tb1, tb2 - tb1 + 1);
						lsb  = svl(tstr);
						switch ( nDirection )
						{
							case 1 :
								tstr = lower(tstr);
								break;
							case 2 :
								tstr = caps(tstr);
								break;
							case 3 :

// .................................................................

								cctstr = '';
								cctstr2 = '';

								while ( c_col <= tb2 )
								{
								newchar = cur_char;
								if ( (c_col == tbc1) && (jx == tbl1) )
								{
									mark_pos;


									left;
									if ( c_line == jx )
									{
										prevchar = cur_char;
										if ( !xpos(prevchar,word_delimits+' 1234567890-~+=',1) )
										{
											newchar = lower(newchar);
										}
										else
										{
											newchar = caps(newchar);
										}
									}
									else
									{
										newchar = caps(newchar);
									}

									goto_mark;
								}
								else
								{
									newchar = caps(cur_char);
								}

									cctstr = get_word(word_delimits);
									if ( svl(cctstr) )
									{
										//cctstr = caps(str_char(cctstr,1))+lower(str_del(cctstr,1,1));
										cctstr = newchar+lower(str_del(cctstr,1,1));
										tl = svl(cctstr);
										if ( tl > 1 )
										{
											for ( lx = 2; lx < tl; lx++ )
											{
												if ( str_char(cctstr,lx) == '_' )
												{
													cctstr = copy( cctstr, 1, lx)+
																	caps( str_char( cctstr, lx+1))+
																	copy( cctstr, lx+2, tl-lx-1);
												}
											}
										}
									}
									else
									{
										t_x = c_col;
										word_right;
										if ( jx == c_line )
										{
											cctstr += Copy(cctstr3,t_x,c_col-t_x);
										}
										else
										{
											cctstr = '';
											word_left;
											goto_col(tbc2+1);
										}
									}
									cctstr2 += cctstr;
								}

	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
								tstr = copy(cctstr2,1,lsb);

								break;

							case 4 :    // toggle case, stream

							 insert_mode = false;  // OVERWRITE
							 while ( c_col <= tb2 )
							 {
									forward_till_not(word_delimits);
									if ( ( ascii(cur_char) > 96 ) &&
										 ( ascii(cur_char) < 123)
										 )
									{
										 text(caps(cur_char));

									}

									else if ( ( ascii(cur_char) > 64 ) &&
													 ( ascii(cur_char) < 91)
												)
									{
										 text(lower(cur_char));

									}
									else
									{
										 right; // let it go
									}

							 }
							 insert_mode = True;

								break;
						}
						goto_mark;
						insert_mode = false;
						if ( nDirection != 4 )
							 text(tstr);
						insert_mode = true;
					}
				}

				++jx;
				down;
			}

			if(  tbs == 3  ) {
				goto_line(tbl1);
				goto_col(tbc1);
				str_block_begin;
				goto_line(tbl2);
				goto_col(tbc2 + 1);
				block_end;
			}
			goto_mark;

		}
		else
		{
			// ------------------------------------------------------------
			// convert case of a word

			if(  not(at_eol) & (xpos(cur_char,word_delimits,1) != 0)  ) {
				right;
			} else {
				if(  c_col > 1  ) {
					left;
					if(  xpos(cur_char,word_delimits,1)  ) {
						right;
					} else {
						right;
						word_left;
					}
				}
			}
			tc = c_col;
			tstr = get_word(word_delimits);

			cctstr = tstr;
			if ( force_lower )
				return_int = 1;
			else if ( force_upper )
				return_int = 2;
			else if ( force_proper )
				return_int = 3;
			else if ( force_toggle )
			{
				return_int = 4;
			}
			else
				call CC_GetDirection;         // determine tolower,toupper,toproper
			nDirection = return_int;

			switch ( nDirection )
			{
				case  1:
					tstr = lower(tstr);
					break;
				case  2:
					tstr = caps(tstr);
					break;
				case  3:
					if ( svl(tstr)>1 )
					{
						tstr = caps(str_char(tstr,1))+lower(str_del(tstr,1,1));
					}
					else
					{
						tstr = Copy(tstr,1,svl(tstr));
					}
					tl = svl(tstr);
					if ( tl > 1 )
					{
						for ( jx = 2; jx < tl; jx++ )
						{
							if ( str_char(tstr,jx) == '_' )
							{
								tstr = copy(tstr, 1, jx)+
												caps( str_char( tstr, jx+1))+
												copy( tstr, jx+2, tl-jx-1);
							}
						}
					}

					break;

				case 4 :    // toggle case, word
					tl = svl(tstr);
					for ( jx = 0; jx < tl; jx++ )
					{
						if ( ( ascii(str_char(tstr,jx+1)) > 96 ) &&
								( ascii(str_char(tstr,jx+1)) < 123)
								)
						{
							tstr = copy(tstr,1,jx)+
											caps(str_char(tstr,jx+1))+
											copy(tstr,jx+2,tl-jx+1);
						}

						else if ( ( ascii(str_char(tstr,jx+1)) > 64 ) &&
											( ascii(str_char(tstr,jx+1)) < 91)
									)
						{
							tstr = copy(tstr,1,jx)+
											lower(str_char(tstr,jx+1))+
											copy(tstr,jx+2,tl-jx+1);
						}
						else
						{
						}

					}
					break;

				case  0:
				default:
					tstr = lower(tstr);
					break;

			}

			goto_col(tc);
			del_chars( svl(tstr) );
			text( tstr );

			// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

		}
	}
	goto ccexit; //

cc_GetDirection:        // determine how the word should be converted
	cctstr2 = lower(cctstr);


		jz = 0;
		while ( jz <= svl(cctstr) )
		{
			++jz;
			asval = ascii(copy(cctstr2,jz,1));
			if ( (asval > 96) && (asval < 123) )       // isAlpha
			{
				 break; // the do..while loop
			}
		}
	if ( cctstr == caps(cctstr) )
	{
		return_int = 3;     // upper to proper
	}
	else if ( cctstr == cctstr2 )
	{
		return_int = 2; // lower to upper
	}
	else
	{
		return_int = 1;                  // to lower
	}
ret;


ccexit:

	return_int = sv_return_int;
	return_str = sv_return_str;
	goto_line(sv_y);
	goto_col(sv_x);

	insert_mode = ti;
	pop_undo;
	persistent_blocks = tpb;
	refresh = sv_refresh;
	redraw;


}



#IFNDEF WINDOWS
void ChangeCaseStdDlg()
{
	int dlg;
	int result;
	int mi = 0;
	int ctrl_id = 2000;

	int LowerID, UpperID, ProperID, ToggleID;

	int dlg = menu_create;

// -----------------------------------------------------------------

	return_int = dlg;

	menu_set_item( dlg, ++mi, "Options:", "",
			"/C=3/L=2/HT=4/W=15/QK=1/L=/C=/W=", 10, 0, 0);

	menu_set_item( dlg, ++mi, "lowercase   ", "",
			"/C=5/L=3/L=/C=/W=/QK=1", 12, 0, 0);
	menu_set_int( dlg, mi, 2, 1 );
	LowerID = mi;

	menu_set_item( dlg, ++mi, "UPPERCASE   ", "",
			"/C=5/L=4/L=/C=/W=/QK=1", 12, 0, 0);
	menu_set_int( dlg, mi, 2, 0 );
	UpperID = mi;

	menu_set_item( dlg, ++mi, "Proper Case ", "",
			"/C=5/L=5/HT=4/W=/QK=1/L=/C=/W=", 12, 0, 0);
	menu_set_int( dlg, mi, 2, 0 );
	ProperID = mi;

	menu_set_item( dlg, ++mi, "Toggle case ", "",
			'/C=5/L=6/HT=4/W=/QK=1/L=/C=/W=', 12, 0, 0);
	menu_set_int( dlg, mi, 2, 0 );
	ToggleID = mi;

	return_str = "/#="+str(mi)+"/T=Change Case";


	return_int = dlg;

	rm('USERIN^Data_In /Y=5/HN=1' + Return_Str);


	if(return_int)
	{
		int how;
		int bs;
		bs = 1 + (block_stat>0);
		if ( menu_item_int(dlg,LowerID,2) )
		{
			how = 1;
		}
		else if ( menu_item_int(dlg,UpperID,2) )
		{
			how = 2;
		}
		else if ( menu_item_int(dlg,ProperID,2) )
		{
			how = 3;
		}
		else if ( menu_item_int(dlg, ToggleID,2) )
		{
			how = 4;
		}
		else
		{
			how = 1;
		}
		rm('CASECHG^CHANGECASE /B=0/U='+STR(HOW));
	}
	menu_delete(dlg);
	redraw;

}



#ELSE

#define IDD_LOWER   1000
#define IDD_UPPER   1001
#define IDD_PROPER  1002
#define IDD_TOGGLE  1003

void ChangeCaseStdDlg()
{
	int dlg;
	int result;
	int m = 0;
	int ctrl_id = 2000;


	DlgCreate(dlg);


	DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_122",
			1, 1, 0,0,
			1009, 0, "" );

	DlgAddCtrl( dlg, DLG_GroupBox,    "Options",
			7,DLG_Units | 2,
			18,5,
			2000,
			0,"" );

	DlgAddCtrl( dlg, DLG_RadioButton, "&lowercase",
			DLG_PosOffset+1, DLG_PosOffset+1,
			0,0,
			IDD_LOWER,
			0,"");
	DlgAddCtrl( dlg, DLG_RadioButton, "&UPPERCASE",
			DLG_PosOffset,DLG_PosOffset + 1,
			0,0,
			IDD_UPPER,
			0,"" );


	DlgAddCtrl( dlg, DLG_RadioButton, "&Proper Case",
			DLG_PosOffset,DLG_PosOffset + 1,
			0,0,
			IDD_PROPER,
			0,"" );

	DlgAddCtrl( dlg, DLG_RadioButton, "&Toggle case",
			DLG_PosOffset,DLG_PosOffset + 1,
			0,0,
			IDD_TOGGLE,
			0,"" );


	DlgAddCtrl( dlg, DLG_PushButton, "OK",
			28, DLG_Units | 10,
			10,0,
			2010,
			DLGF_DefButton,"/R=1" );
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel",
			Dlg_PosOffset,DLG_PosOffset|Dlg_Units|Dlg_Units_Line_Half,
			10,0,
			2011,
			0,"/R=0" );
	DlgAddCtrl( dlg, DLG_PushButton, "&Help",
			Dlg_PosOffset,DLG_PosOffset|Dlg_Units|Dlg_Units_Line_Half,
			10,0,
			2012,
			0,"/R=2" );

	DlgSetInt(dlg,IDD_LOWER,  1);
	DlgSetInt(dlg,IDD_UPPER,  0);
	DlgSetInt(dlg,IDD_PROPER, 0);
	DlgSetInt(dlg,IDD_TOGGLE, 0);

	result = DlgExecute( dlg, IDD_LOWER, "Change Case", CHANGECASE_HELPLINK,
			"", 0 );
	if(result)
	{
		int how;
		int bs;
		bs = 1 + (block_stat>0);
		if ( DlgGetInt(dlg,IDD_LOWER) )
		{
			how = 1;
		}
		else if ( Dlggetint(dlg,IDD_UPPER) )
		{
			how = 2;
		}
		Else if ( DlgGetInt(dlg,IDD_PROPER) )
		{
			how = 3;
		}
		Else if ( DlgGetInt(dlg,IDD_TOGGLE) )
		{
			how = 4;
		}
		else
		{
			how = 1;
		}
		rm('CASECHG^CHANGECASE /B=0/U='+str(how));
	}

	DlgKill(dlg);

}

// simple menu-like dialog with single-action trigger
void ChangeCaseBtnDlg()
{
	int dlg;
	int result;
	int m = 0;
	int ctrl_id = 2000;


	DlgCreate(dlg);

	DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_ED_122",
			22, 1, 0,0,
			1009, 0, "" );

	DlgAddCtrl( dlg, DLG_PushButton, "&lowercase  ",
			DLG_Units | 5, DLG_Units | 2,
			14,0,
			IDD_LOWER,
			0,"/R=11");

	DlgAddCtrl( dlg, DLG_PushButton, "&UPPERCASE  ",
			DLG_PosOffset,DLG_PosOffset|Dlg_Units|DLG_Units_line_half,
			14,0,
			IDD_UPPER,
			0,"/R=12" );

	DlgAddCtrl( dlg, DLG_PushButton, "&Proper Case",
			DLG_PosOffset,DLG_PosOffset|DLG_Units|Dlg_units_line_half,
			14,0,
			IDD_PROPER,
			0,"/R=13" );

	DlgAddCtrl( dlg, DLG_PushButton, "&Toggle case",
			DLG_PosOffset,DLG_PosOffset|DLG_Units|Dlg_units_line_half,
			14,0,
			IDD_TOGGLE,
			0,"/R=14" );

	DlgAddCtrl( dlg, DLG_PushButton, "Cancel",
			20,DLG_Units | 20 ,
			10,0,
			2011,
			0,"/R=0" );
	DlgAddCtrl( dlg, DLG_PushButton, "&Help",
			Dlg_PosOffset,Dlg_PosOffset|Dlg_Units|Dlg_Units_line_half,
			10,0,
			2012,
			0,"/R=2" );


	result = DlgExecute( dlg, IDD_LOWER, "Change Case", CHANGECASE_HELPLINK,
			"", 0 );

	if(result)
	{
		rm('CASECHG^CHANGECASE /B=0/U='+str(result-10));
	}

	DlgKill(dlg);

}

#ENDIF



// general purpose menu dialog - works under dos & windows

void CCPushBtnDlg()
{
	str choicetext =
				"lower case()"
			+ "UPPER CASE()"
			+ "Proper Case()"
			+ "Toggle case()";

	RM("USERIN^XMENU /T=1/B=1/S=1/L=Change Case/M="+choicetext +
			"/X=35" +
			"/Y=8");

	if(return_int)
	{
			rm('CASECHG^CHANGECASE /B=0/U='+STR(return_int));
	}

}

//
//
