// $Header: /MeWin/Src/TEMPLATE.SH 31    2/26/96 13:03 Dan $

#define tmp_data_ext      ".TMP"
#define tmp_file_ext      ".TPT"
#define tmp_cursor_save   "!TMP_CURSOR_SAVE"
#define tmp_SavIndent     "!TmpSavIndent"
#define first_column      Dlg_StanBtnWidth + 4
#define second_column     33 + Dlg_StanBtnWidth
#define title_y_offset    Dlg_PosOffset | Dlg_Units | 9
#define _tmpGSLen         ( Max_Line_Length - 64 )

#define bitmap_ctrl           1001
#define frame_ctrl_1          1002
#define set_title_ctrl        1003
#define set_ctrl              2004
#define case_title_ctrl       1005
#define case_ctrl             1006
#define list_title_ctrl       1007
#define list_ctrl             2008
#define insert_ctrl           1009
#define delete_ctrl           1010

#define frame_ctrl_2          1011
#define desc_title_ctrl       1012
#define desc_ctrl             1013
#define keyw_title_ctrl       1014
#define keyw_ctrl             1015
#define min_title_ctrl        1016
#define min_ctrl              1017
#define space_ctrl            1018
#define edit_title_ctrl       1019
#define edit_ctrl             2020
#define id_ted_HelpCtx        1020

#define meta_ctrl             1021
#define Expand_ctrl           2101
#define set_change_ctrl       1022
#define global_ctrl           1122
#define sense_ctrl            1132
#define id_ted_HelpFile       1133

#define id_ted_FirstWord			1103
#define id_ted_Eol						1104
#define id_ted_ExpandComment	1105
#define id_ted_NoShowInList		1106

#define id_ted_CancelBtn			2022
#define id_ted_CopyBtn				2023
#define id_ted_MoveUpBtn			2024
#define id_ted_MoveDnBtn			2025
#define id_ted_PropertiesBtn  2026

#define OK_ctrl               2001
#define Cancel_ctrl           2000
#define Help_ctrl             2002

#define _tmp_xAtEol           0x01
#define _tmp_xFirstWord       0x02
#define _tmp_xSpace           0x04

// Template global fields
#define _gf_tmp_Case          "CASE"
#define _gf_tmp_CaseSense     "CASESENSE"

#define _gf_tmp_Template      "T"
#define _gf_tmp_Name          "N"
#define _gf_tmp_ExCmnt        "CM"
#define _gf_tmp_Space         "S"
#define _gf_tmp_MinMatch      "M"
#define _gf_tmp_Eol           "E"
#define _gf_tmp_FirstWord     "F"
#define _gf_tmp_Special       "X"

// TPT file template header fields
#define _db_tmp_Keyword       "TEMPLATE"
#define _db_tmp_Comment       "COMMENT"
#define _db_tmp_HelpCtx       "HCTX"
#define _db_tmp_MinMatch      "MINMATCH"
#define _db_tmp_SpaceExpand   "SPACEBAR"
#define _db_tmp_CmntExpand    "EXCMNT"
#define _db_tmp_FirstWord     "FIRSTWORD"
#define _db_tmp_EOL           "EOL"
#define _db_tmp_NoListShow    "NOSHOW"

// TTmpHdr Flags constants
#define _db_tmf_SpaceExpand   0x01
#define _db_tmf_CmntExpand    0x02
#define _db_tmf_NoListShow    0x04

// Template header structure
struct TTmpHdr {
  str Name[ 32 ];
  str Comment;
  str HelpCtx;
  str Keyword;
  int MinMatch;
  int ExpandWhere;
  int Flags;
}

prototype TEMPLATE {
	void Template( int SpaceExpand );
	void TmpButtonExpand( str Set, str Name );
/******************************************************************************
	Function: Expand the template Name from the TPT file Set.  Use this macro
						when expanding templates from a toolbar button or menu entry.

	Entry   : str Set 		- The name of the TPT file           				 (/S=)
						str Name		- The name of the template to expand         (/N=)
********************************************************************( ldh )***/

	void Tmp_Init_All( str Set, int Rebuild );
	void Tmp_List( str Set, str TmpStr );
/******************************************************************************
	Function: This is the stand-alone list of templates
	Entry   : str Set     - The name of the template set to list       (/SET=)
						str TmpStr	- The name of the template to start on       (/TMPSTR=)
********************************************************************( ldh )***/

	void Tmp_Edit( str Set, str TmpStr, int Not_Modeless );
/******************************************************************************
  Function: This is the main template editing/configuration macro.
	Entry   : str Set           - The name of the template set to edit (/SET=)
						str TmpSet        - The name of the template to edit     (/TMPSTR=)
						int Not_Modeless	- True for a modal dialog              (/NM=)
********************************************************************( ldh )***/

	void TmpExpand( str Set, str 	Name );

	void TmpGotoField( int Backward, int Scope );
/******************************************************************************
	Function: Position the cursor on the next or previous template field string.
	Entry   : int Backward  - True to search backward for field           (/B=)
						int Scope			- The number of lines to restrict the search  (/LS=)
********************************************************************( ldh )***/

	str  Proper( str T_Str );
  void TmpPutText( str Tmp_Str );

  str  DbTmpHdr2Rec( struct TTmpHdr );
/******************************************************************************
  Function: Convert a template structure to the template header string
  Entry   : struct TTmpHdr    - The template header structure
  Exit    : str               - The template header string
********************************************************************( ldh )***/

  void DbRec2TmpHdr( struct TTmpHdr, str DbRecord );
/******************************************************************************
  Function: Fills a TTmpHdr structure with the data from a TmpHdr Db record.
********************************************************************( ldh )***/
}

global {

	int g_tmp_global        "!TMP_GLOBAL";

	int g_cursor_line       "!TMP_CURS_LINE";
	int g_cursor_col        "!TMP_CURS_COL";
	int g_original_col      "!TMP_ORIG_COL";
	int g_case_flag         "!TMP_CASE_FLAG";
	int g_case_sense        "!TMP_CASE_SENSE";
	int g_tmp_recurs_level  "!TMP_RECURSION_LEVEL";
	str g_template          "!TMP_TEMPLATE";
	int g_list_window       "!TMP_LIST_WINDOW";
	int g_edit_window       "!TMP_EDIT_WINDOW";
	int g_data_window       "!TMP_DATA_WINDOW";
	str g_template_name     "!TMP_TEMPLATE_NAME";
	str g_tmp_last_prompt   "!TMP_LAST_PROMPT";
	str g_set_name          "!TMP_SET_NAME";
	int g_tmp_was_changed   "!TMP_WAS_CHANGED";
	int g_tmp_case          "!TMP_CASE";
	int g_tmp_abort         "!TMP_ABORT";
	int g_cr_flag           "!TMP_CR_FLAG";
	int g_indent_level      "!TMP_INDENT_LEVEL";
	int g_hTmpEditDlg				"!hTmpEditDlg";
	int g_TmpBlkSaved				"!TmpBlkSaved";
	int g_TmpSavedPB				"!TmpSavedPB";
	int	g_hMetaMenu 				"~MetaHandle1";
	int	g_TmpRmChars				"!TmpRmChars";
	int g_TmpCrCol          "!TmpCrCol";
	int g_TmpIndentCnt      "!TmpIndentCnt";
  int g_TmpEditLine       "!TmpEditLine";

	str g_TmpFirstName			"!TmpFirstName";
	str g_TmpFirstSet				"!TmpFirstSet";
}
