// $Header: /MeWin/Src/SEARCH.S 118   4/26/96 16:59 Dan $

macro_file SEARCH;

#include metools.sh
#include windows.sh
#include mew_dlgs.sh
#include mew_btn.sh
#include mewlist2.sh
#include dialog.sh
#include mewhelp.sh
#include mew.sh
#include REGEXP.SH
#include STDDLGS.SH
#include mewlib.sh
//#include TBMGR.SH

#ifdef _DEBUG_
  #include DBUG.SH
  #include MSGLOG.SH
#endif

#define SP_HELPLINK         ""
#define FOUNDLIST_HELPLINK  "FOUND LIST"
#define SEARCH_HELPLINK     "SEARCH"
#define SRCHREP_HELPLINK    "SEARCH AND REPLACE"
#define FILELIST_HELPLINK   "SEARCH, LIST FILES"
#define GHIGHLIGHT_HELPLINK "GLOBAL EXPRESSION HIGHLIGHT"
#define MFSRCH_HELPLINK     "MULTI-FILE SEARCH"
#define MFSRCHREP_HELPLINK  "MULTI-FILE SEARCH AND REPLACE"

#define Repl_Ctrl           1001
#define Skip_Ctrl           1003
#define Cancel_Ctrl         1002
#define NonStop_Ctrl        1004
#define SkipFile_Ctrl       1006
#define AllFiles_Ctrl       1005
#define SearchAgain_Ctrl    1001
#define SkipWindow_Ctrl     1007

#define id_sr_SearchStr			201
#define id_sr_ReplaceStr		202

#define id_sr_TypeGrp				301
#define id_sr_DirectionGrp	302
#define id_sr_OptionGrp			303
#define id_sr_ModeGrp				304
#define id_sr_CursorPosGrp	305

#define id_sr_LiteralRB			401
#define id_sr_RegExpRB			402
#define id_sr_WordSrchRB		403
#define id_sr_ForwardRB			404
#define id_sr_BackwardRB		405
#define id_sr_ReplaceOneCB	406
#define id_sr_PromptSrchCB	407
#define id_sr_PosEndStrCB		409
#define id_sr_PosBegStrCB		410
#define id_sr_ExitNoFindCB  411
#define id_sr_MarkFndTxtCB	422

#define id_sr_CaseCB				501
#define id_sr_GlobalSrchCB	502
#define id_sr_BlockSrchCB		503
#define id_sr_AllWindowsCB	504

#define id_sr_SearchBtn			1101
#define id_sr_CancelBtn			1102
#define id_sr_RegExpHlpBtn	1103
#define id_sr_HelpBtn				1104
#define id_sr_ListPrevBtn		1105
#define id_sr_AllBtn				1106
#define id_sr_ReplaceBtn		1107
#define id_sr_AliasBtn			1108

#define id_sr_ShrinkBtn			1200
#define id_sr_DirSwitchBtn	1201

#define _g_SRDlgPos					"SRDlgPos"
#define _g_CSRDlgPos				"CSRDlgPos"

global {
	int Reg_Exp_Style;  	// TRUE = Unix style expressions
  int Ftype       			"CurrSess_FS_Ftype";
  int SReturn_Int;   		// Added for Modeless Purposes
  int SRCollapsed;
  int SCaretPos;

	int g_hSRDialog				"!hSRDialog";
	int g_RepSearch				"RepSearch";
	int g_FoundCount			"Found_Count";
	int g_ReplaceCount		"Replace_Count";
	int g_SearchMode			"Search_Mode";
	int g_SearchWin				"!FSearchWin";
	int g_TotalFiles			"!FTotalFiles";
	int g_TotalFnd				"!FTotalFnd";

	str g_SearchStr				"Search_Str";
	str g_ReplaceStr			"Replace_Str";
	str g_Switches				"Switches";
	str g_DefSwitches			"Def_Switches";
	str g_ReplSwitches		"Repl_Switches";
	str g_DefReplSwitches	"Def_Repl_Switches";
	str g_FSwitches				"FSwitches";
	str g_FSearchStr			"FSearch_Str";
	str g_FRSwitches			"FRSwitches";
	str g_FSInfo					"!FSInfo";
}

prototype TBMGR {
	void Var_Replace_Str( str &Parm_Str, str Var, str New );
}

prototype Search {
	int Create_SR_Dialog( int Search_Mode, int MultiFile, int prompted, int search_all_windows );
  str Convsl( str Cs );
}

/*******************************************************************************
														MULTI-EDIT MACRO FILE

Name: SEARCH

S_AND_R						- The general purpose search and search/replace macro.
SEARCH_LIST TRANS	- Brings up the list of occurrences created by search.
SRCH_ACROSS_LINE	- Performs Word/Phrase search
REPL_ACROSS_LINE	- Performs Word/Phrase replace
SRCHINTR					- Generates a dialog box for S_AND_R.
SEARCH						- This is the user interface for a SEARCH.
S_REPL						- This is the user interface for a SEARCH AND REPLACE.
REPSRCH						- This repeats the last search or search/replace.
FS								- The interface to multi-file search
FileSrch					- Performs the actual multi-file search

								Copyright 1994 by American Cybernetics, Inc.
*******************************************************************************/

int ListAllAvailable( )
// Function to tell if List all is available
{
	return ( Global_Str( "!SR_LST_WN" ) == "" );

}  // ListAllAvailable

void SetSearchHistory( ) trans2
/* -----------------2/21/96 1:39PM-------------------
 Called by search dialogs to set the first search
 hestory item to the word or block under the cursor
--------------------------------------------------*/
{
  int tr = refresh;
  Refresh = False;
  Mark_Pos;
  if ( ( C_Line == Block_Line1 ) && ( Block_Stat > 0 ) &&
      ( Block_Line1 == Block_Line2 ) ) {
    if ( Block_Stat == 1 ) {
      First_Word;
      Set_Global_Str( "Search_History0", Get_Word( "" ) );
    }
    else {
      Set_Global_Str( "Search_History0", Copy( Get_Line( ), Block_Col1,
          ( Block_Col2 - Block_Col1 ) + 1 ) );
    }
  }
  else {
    Right;
    Word_Left;
    Set_Global_Str( "Search_History0", Get_Word( Word_Delimits ) );
  }
  Goto_Mark;
  refresh = tr;

}  // SetSearchHistory

void SearchGetAlias(
      int Dlg   = Parse_Int( "/DLGHANDLE=", MParm_Str ),
      int Id    = Parse_Int( "/ID=", MParm_Str ),
      int Flags = Parse_Int( "/FLAGS=", MParm_Str )
) trans2
/* -----------------2/21/96 1:39PM-------------------
  Called by search dialogs to get aliases

  Parameters:
      dlg     The window handle of the dialog box
      id      The control id of the text control
      flags   0x01  If true, then set the search
                    type radio buttons.  Only used
                    by the normal search dialog.
              0x02  If true, calculate the caret
                    position.  If false, get the
                    position from SCaretPos.
--------------------------------------------------*/
{

  str WText;

  int CtrlId = GetDlgItem( Dlg, id );

  int xSCaretPos = SCaretPos;

  if ( Flags & 2 ) {
    xSCaretPos = SendMessage( CtrlId, CB_GETEDITSEL, 0, 0 );
  }

  GetWindowText( CtrlId, WText, 254);

  str TStr = ReSelectAlias( );

  if ( Return_Int ) {

    if( flags & 1 ) {
      SendDlgItemMessage( Dlg, id_sr_LiteralRB, BM_SetCheck, False, 0 );
      SendDlgItemMessage( Dlg, id_sr_WordSrchRB, BM_SetCheck, False, 0 );
      SendDlgItemMessage( Dlg, id_sr_RegExpRB, BM_SetCheck, True, 0 );
    }

    int cplo = ( xSCaretPos & 0xFFFF );
    int cphi = ( xSCaretPos >> 16 );

    if ( cplo != cphi )
    {
      wtext = str_del(wtext, cplo + 1, cphi - cplo);
    }

    WText = Str_Ins( TStr, WText, cplo + 1 );
    SendMessageStr( CtrlId, WM_SETTEXT, 0, wtext );
    SetFocus( CtrlId );
    cplo += Svl( TStr );
    SendMessage( CtrlId, CB_SetEditSel, 0, (cplo << 16) | (cplo & 0xFFFF) );
  }
}  // SearchGetAlias

void _SrchInit(
      int hDlg = Parse_Int( "/DLGHANDLE=", MParm_Str ),
      int Id   = Parse_Int( "/ID=", MParm_Str )
) trans2
/******************************************************************************
                               Multi-Edit Macro
                               24-Feb-96  14:49

  Function: `description`
  Entry   : `entry`
  Exit    : `exit`

               Copyright (C) 1996 by American Cybernetics, Inc.
********************************************************************( ldh )***/
{
  if ( hDlg ) {
    Subclass_With_Macro( GetWindow( GetDlgItem( hDlg, Id ), GW_Child ),
        "SrchStringProc", "" );
  }
}  // _SrchInit

void GlobalExpHighlight(
      str SearchStr = Parse_Str( "/S=", MParm_str),
      int ExpOn     = Parse_Int( "/E=", MParm_Str),
      int CaseSen   = Parse_Int( "/C=", MParm_Str),
      int Reset     = Parse_Int( "/R=", MParm_Str)
) trans2
/********************************************************************
                               Multi-Edit Macro
                                2/22/96 10:16AM

  Function:   This macro creates processes the Global Expression Highlight
              feature.

  Entry   :   If no search string is passed on the commandline, and /R=1 is not
              passed, then a dialog is brought up.  If a search string is
              passed, then ExpOn=1 turns on Unix expressions, ExpOn=2 turns on
              Classic expressions, CaseSen=1 turns on Case Sensitivity and
              Reset=1 causes the reset of the commandline to be ignored and the
              highlighting to be turned off.

  Exit    :   Does not return a result.

  By      :   Todd Johnson

              Copyright 1996 by American Cybernetics, Inc.
**********************************************************************/
{
  int dlg,result;
  str tstr;
  int SearchFlags = Global_Int("!GlobalHighlightFlags");

  // If reset was passed on the commandline, then turn highlight off and exit
  if(Reset)
  {
    SetSearchHighlightStr( "", 0 );
    redraw;
    return();
  }

  // If a search string was passed on the command line, then
  // lets process the search without a dialog.
  if(SearchStr != "")
  {
    SearchFlags = (CaseSen != 0) | 0x80000000;
    switch ( ExpOn )
    {
      case 1 : SearchFlags |= 0x02;
               break;
      case 2 : SearchFlags |= 0x04;
    }
    call ProcessSearch;
    return();
  }

  SearchStr = Global_Str("Search_Str");

  if(!SearchFlags)
  {
    SearchFlags = 0x80000000;
    tstr = Global_Str("Def_Switches");
    if(!xpos("I", tstr,1))
      SearchFlags |= 1;
    if(!xpos("X", tstr,1))
    {
      SearchFlags |= 6;
    }
  }

  SetSearchHistory();

  DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SR_117", 1, 1, 0,0,-1,0, "" );
  DlgAddCtrl( dlg, DLG_Static, "Highlight:", 8, 1, 0, 2,-1,0, "" );
  DlgAddCtrl( dlg, DLG_Text, SearchStr, 18,  Dlg_PosOffset, 42, 0, 1000 , 0, "/ML=255/HISTORY=SEARCH_HISTORY");

  DlgAddCtrl( dlg, DLG_GroupBox, 'Options', 1,  Dlg_PosOffset + 1, 32, 3, -1, 0, "");
  DlgAddCtrl( dlg, DLG_CheckBox, "Case sensiti&ve", 2,  Dlg_PosOffset + 1, 0, 0, 1010, 0, "");
  DlgSetInt( dlg, 1010, SearchFlags & 1 );

  DlgAddCtrl( dlg, DLG_CheckBox, "Regular &expressions", 2,  Dlg_PosOffset + 1, 0, 0, 1011, 0, "");
  DlgSetInt( dlg, 1011, (SearchFlags & 6) != 0 );

  DlgAddCtrl( Dlg, dlg_PushButton, "Al&ias",
      35, dlg_PosOffset,
      dlg_StanBtnWidth, 0,
//      122, 0, "/M=SearchGetAlias /FLAGS=2/ID=1000" );
      122, 0, "/M=SearchGetAlias /ID=1000" );

  DlgAddCtrl(dlg, Dlg_PushButton, "Reg Ex &Help",
      46, Dlg_PosOffset,
      Dlg_StanBtnWidth + 4, 0,
      121, 0, "/M=MEWHELP^RegexpHelp");


  DlgAddCtrl( dlg, DLG_PushButton, "Ok", 1, Dlg_Units | Dlg_PosOffset | (15), DLG_StanBtnWidth,0,110,DLGF_DefButton, "/R=1" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Reset", Dlg_PosOffset | (Dlg_StanBtnWidth + 1), DLG_PosOffset, DLG_StanBtnWidth,0,113,0, "/R=10" );
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset | (Dlg_StanBtnWidth + 1), DLG_PosOffset, DLG_StanBtnWidth,0,111,0, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 46, DLG_PosOffset, DLG_StanBtnWidth + 4,0,112,0, "/R=2" );

  Result = DlgExecute( Dlg, 1000, "Global Expression Highlight",
      GHIGHLIGHT_HELPLINK,
      "/INITMAC=_SrchInit //ID=1000", 0 );

  Set_Global_Str( "Search_Str", DlgGetStr( dlg, 1000 ));
  SearchFlags = DlgGetInt(dlg,1010) | 0x80000000;
  if( DlgGetInt( dlg, 1011 ))
  {
    if( Global_Int('Reg_Exp_Style'))
    {
      SearchFlags |= 0x02;
    }
    else
    {
      SearchFlags |= 0x04;
    }
  }

  Set_Global_Int("!GlobalHighlightFlags", SearchFlags);

  switch ( result)
  {
    case 1 :
      SearchStr = DlgGetStr( dlg, 1000 );
      call ProcessSearch;
      break;

    case 10 :
      SetSearchHighlightStr( "", 0 );
      redraw;
      break;
  }
  DlgKill(dlg);
  return();

ProcessSearch:
  if( SearchFlags & 0x06)
    SearchStr = ReTranslate( SearchStr, 0 );
  SetSearchHighlightStr( SearchStr, SearchFlags );
  redraw;
  ret;

}  // GlobalExpHighlight

int Create_SR_Dialog( int Search_Mode, int MultiFile, int prompted, int search_all_windows ) trans2
{
  int X;
  int Ctrl;
	int Dlg;
	int RetVal;
	int TRefresh = Refresh;

	Refresh = True;
	Redraw;
  DlgCreate( Dlg );
	if ( Search_Mode ) {
    X = 1;
    DlgAddCtrl( Dlg, Dlg_PushButton, "&Replace",
				X, 1,
				Dlg_StanBtnWidth, 0,
        Repl_Ctrl, DLGF_DefButton, '/R=101');
    X += Dlg_StanBtnWidth + 2;
		Ctrl = Repl_Ctrl;

		if ( prompted ) {
      DlgAddCtrl(dlg, Dlg_PushButton, '&Skip',
      		X, dlg_PosOffset + 0,
					Dlg_StanBtnWidth, 0,
          Skip_Ctrl, 0, '/R=103' );
    	X += Dlg_StanBtnWidth + 2;
		}

		if ( search_all_windows ) {
      DlgAddCtrl(dlg, Dlg_PushButton, 'Skip &Window',
      		X, dlg_PosOffset + 0,
					dlg_StanBtnWidth + 4, 0,
          SkipWindow_Ctrl, 0, '/R=107' );
      X += Dlg_StanBtnWidth + 6;
		}

    DlgAddCtrl(dlg, Dlg_PushButton, 'Cancel',
    		X, dlg_PosOffset + 0,
				dlg_StanBtnWidth, 0,
        Cancel_Ctrl, 0, '/R=102');
    x += Dlg_StanBtnWidth + 2;

		if ( prompted ) {
      DlgAddCtrl( Dlg, Dlg_PushButton, '&Non Stop',
      		X, 1,
					Dlg_StanBtnWidth + 1, 0,
          NonStop_Ctrl, 0, '/R=104');
      x += Dlg_StanBtnWidth + 3;
		}

		if ( MultiFile ) {
      DlgAddCtrl( Dlg, Dlg_PushButton, 'Skip &File',
      		X, 1,
					Dlg_StanBtnWidth, 0,
          SkipFile_Ctrl, 0, '/R=106');
      X += Dlg_StanBtnWidth + 2;

      DlgAddCtrl(dlg, Dlg_PushButton, "A&ll Files",
          X, 1,
					Dlg_StanBtnWidth, 0,
          AllFiles_Ctrl, 0, '/R=105');
      X += Dlg_StanBtnWidth + 2;
		}
	}
	else {
    X = 1;
    DlgAddCtrl(dlg, Dlg_PushButton, '&Search Again',
    		x, 1, Dlg_StanBtnWidth + 5, 0,
        SearchAgain_Ctrl, DLGF_DefButton, '/R=101');
    X += Dlg_StanBtnWidth + 7;
		Ctrl = SearchAgain_Ctrl;

		if ( Search_All_Windows ) {
      DlgAddCtrl( Dlg, Dlg_PushButton, 'Skip &Window',
      		x, 1, Dlg_StanBtnWidth + 4, 0,
          SkipWindow_Ctrl, 0, '/R=103');
      X += Dlg_StanBtnWidth + 6;
		}
    DlgAddCtrl( Dlg, Dlg_PushButton, '&Cancel',
    		X, 1, Dlg_StanBtnWidth, 0,
    		Cancel_Ctrl, 0, '/R=102');
	}
  RetVal = DlgExecute( Dlg, Ctrl, "Search Options", SP_HELPLINK,
			"/RPOS=" + _g_CSRDlgPos, 0 );

  DlgKill(dlg);

	Refresh = TRefresh;
  return ( RetVal );

}  // Create_SR_Dialog

int SrchStringProc(int &retval, int window, message, wparam, lparam, str parms)
        trans2
{
/*
  Subclassing the search string so we can put the alias in when selected from list
*/

  switch ( message ) {
    case WM_KILLFOCUS :
      SCaretPos = SendMessage( Window, CB_GETEDITSEL, 0, 0 );
      break;
  }
  retval = 0;
  return ( False );

}  // SrchStringProc

int SRProc( int &retval, int dlg, int message, int wparam, int lparam, str parms ) trans2 no_break
{
/*
	Used for Modeless Search and Replace dialog.
*/

	int TRefresh = Refresh;
  int SearchMode = g_SearchMode;
	int CtrlId;
	int Jx;
  int Enable_Flag;
	int Hide_Flag;
	int BlkOn = Block_Stat > 0;
  int ExitNoFind;

	str TStr;
	str TStr2;

  switch ( Message ) {
    case WM_ACTIVATE :
      if ( WParam != wa_Inactive ) {
				if ( !g_RepSearch ) {
					// Add current word to the top of the history list
    			Refresh = False;
    			Mark_Pos;
    			if ( ( C_Line == Block_Line1 ) && BlkOn &&
							( Block_Line1 == Block_Line2)  ) {
      			if ( Block_Stat == 1 ) {
        			First_Word;
							TStr = Get_Word( "" );
      			}
						else {
							TStr = Copy( Get_Line( ), Block_Col1, Block_Col2 - Block_Col1 + 1 );
      			}
    			}
					else {
      			Right;
      			Word_Left;
      			TStr = Get_Word( Word_Delimits );
    			}
    			Goto_Mark;
    			Refresh = TRefresh;

					CtrlId = GetDlgItem( Dlg, id_sr_SearchStr );
					SendMessageStr( CtrlId, cb_GetLbText, 0, TStr2 );
					if ( TStr2 != TStr ) {
						Jx = SendMessage( CtrlId, cb_GetCurSel, 0, 0 );
						SendMessageStr( CtrlId, cb_InsertString, 0, TStr );
						if ( Jx ) {
							SendMessage( CtrlId, cb_DeleteString, 1, 0 );
							if ( Jx != cb_Err ) {
								SendMessage( CtrlId, cb_SetCurSel, Jx, 0 );
							}
						}
						else {
							SendMessage( CtrlId, cb_SetCurSel, 1, 0 );
						}
					}
				}
				else {
					if ( SearchMode ) {
        		EnableWindow( GetDlgItem( Dlg, id_sr_ReplaceBtn ), True );
						if ( !SRCollapsed ) {
							call Hide_All;
						}
					}
				}
        EnableWindow( GetDlgItem( Dlg, id_sr_BlockSrchCB ), BlkOn );
				if ( SearchMode ) {
					if ( XPos( 'R', Caps( g_DefReplSwitches ), 1 ) ) {
						SendDlgItemMessage( Dlg, id_sr_BlockSrchCB, BM_SetCheck, BlkOn, 0 );
					}
				}
				else {
					if ( XPos( 'R', Caps( g_DefSwitches ), 1 ) ) {
						SendDlgItemMessage( Dlg, id_sr_BlockSrchCB, BM_SetCheck, BlkOn, 0 );
					}
				}
      }
      break;

		case wm_ShowWindow :
			if ( WParam && g_RepSearch ) {
  			Enable_Flag = False;
  			Hide_Flag = SW_HIDE;
				call Process_Hide;
				RetVal = 0;
				return ( True );
			}
			break;

		case WM_SysCommand :
        if ( WParam == sc_Close ) {
          call Set_Flags;
          DestroyWindow(dlg);
Done:
					g_RepSearch = False;
          g_hSRDialog = 0;
					//add items to history list
          Return_Str = g_SearchStr;
          Rm( "History_List /M=1/HISTORY=SEARCH_HISTORY" );
					//add items to history list
          Return_Str = g_ReplaceStr;
          Rm( "History_List /M=1/HISTORY=REPLACE_HISTORY");
          RetVal = 0;
          return ( True );
        }
				break;

    case WM_COMMAND :
      switch ( WParam ) {
        case DLG_Wcmd_Init :
          Subclass_With_Macro( GetWindow( GetDlgItem( Dlg, id_sr_SearchStr ),
							GW_Child ), "SrchStringProc", "" );
					if ( SearchMode && !g_RepSearch ) {
          	EnableWindow( GetDlgItem( Dlg, id_sr_ReplaceBtn ), False );
					}
          EnableWindow( GetDlgItem( Dlg, id_sr_BlockSrchCB ), BlkOn );
					if ( SearchMode ) {
						if ( XPos( 'R', Caps( g_DefReplSwitches ), 1 ) ) {
							SendDlgItemMessage( Dlg, id_sr_BlockSrchCB, BM_SetCheck, BlkOn, 0 );
						}
					}
					else {
						if ( XPos( 'R', Caps( g_DefSwitches ), 1 ) ) {
							SendDlgItemMessage( Dlg, id_sr_BlockSrchCB, BM_SetCheck, BlkOn, 0 );
						}
					}
					EnableWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), False );
					ShowWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), sw_Hide );
          g_hSRDialog = Dlg;
          SRCollapsed = 0;
          break;

				case id_sr_DirSwitchBtn :
					Jx = SendDlgItemMessage( Dlg, id_sr_BackwardRB, BM_GetCheck, 0, 0 );
					call SetDirBtn;
					SetFocus( GetDlgItem( Dlg, id_sr_SearchBtn ) );

        case id_sr_SearchBtn :

          int SR_Prompt = False;

          str OrigSwitches;

          SReturn_Int = 1;
          call Set_Flags;
          OrigSwitches = g_Switches;
					// add item to search history list
          Return_Str = g_SearchStr;
          Rm( "History_List /M=1/HISTORY=SEARCH_HISTORY" );
          if ( SearchMode ) {
						// add item to replace history list
            Return_Str = g_ReplaceStr;
            Rm( "History_List /M=1/HISTORY=REPLACE_HISTORY" );
            g_Switches = g_ReplSwitches;
          }
          SR_Prompt = XPos( 'P', Caps( g_Switches ), 1 );
          g_Switches = Str_Del( g_Switches, SR_Prompt, 1 );
          if ( !SRCollapsed && ( SR_Prompt || SearchMode ) ) {
            call Hide_All;
          }
          g_SearchMode = False;
          if ( g_RepSearch ) {
            Rm( "RepSrch" );
          }
					else {
            Rm( "S_And_R" );
          }
          if ( SearchMode ) {
            g_SearchMode = True;
          }
          g_SearchMode = SearchMode;
          g_Switches = OrigSwitches;
          if ( ( !SR_Prompt && !SearchMode ) || ( ExitNoFind && !g_FoundCount ) ) {
						// destroy the dialog if not a prompted search and not in replace
            call Set_Flags;
            DestroyWindow( Dlg );
						goto Done;
          }
          if ( ( g_FoundCount != 0 ) && SearchMode ) {
						//don't enable rep. button till search
            EnableWindow( GetDlgItem( Dlg, id_sr_ReplaceBtn ), True );
						if ( SRCollapsed ) {
							SetFocus( GetDlgItem( Dlg, id_sr_ReplaceBtn ) );
							SendMessage( Dlg, dm_SetDefId, id_sr_ReplaceBtn, 0 );
						}
          }
          g_RepSearch = True;
          break;

        case id_sr_CancelBtn :
          call Set_Flags;
          DestroyWindow( Dlg );
          goto Done;

        case id_sr_AllBtn :
        case id_sr_ReplaceBtn :
          SReturn_Int = 101;
          call Set_Flags;
					Jx = False;
					// add items to search history list
          Return_Str = g_SearchStr;
          Rm( "History_List /M=1/HISTORY=SEARCH_HISTORY" );
          if ( g_SearchMode ) {
						// sets value for replace str
            GetWindowText( GetDlgItem( Dlg, id_sr_ReplaceStr ), TStr, 256 );
            g_ReplaceStr = TStr;
						// add item to replace history list
            Return_Str = TStr;
            Rm( "History_List /M=1/HISTORY=REPLACE_HISTORY" );
						Jx = XPos( 'P', Caps( g_ReplSwitches ), 1 ) == 0;
          }
          if ( WParam == id_sr_AllBtn ) {
            if ( g_SearchMode ) {
              g_ReplSwitches += 'N';
            }
						else {
              g_Switches += 'L';
            }
						Jx = True;
          }
					if ( Jx ) {
            DestroyWindow(dlg);
					}
          else if ( !SRCollapsed ) {
            call Hide_All;
          }
          Rm( "S_And_R" );
					if ( g_FoundCount == g_ReplaceCount ) {
						Make_Message( "No more occurrences." );
					}
					if ( Jx || ( ExitNoFind && ( g_FoundCount == g_ReplaceCount ) ) ) {
						if ( Jx == 0 ) {
            	DestroyWindow(dlg);
						}
            goto Done;
					}
          g_RepSearch = True;
          break;

        case id_sr_ListPrevBtn :
          SReturn_Int = 12;
          DestroyWindow( Dlg );
          Rm( "S_And_R" );
          g_RepSearch = False;
          goto Done;

        case id_sr_AliasBtn :
          SearchGetAlias( dlg, id_sr_SearchStr, 1 );
          break;

        case id_sr_ShrinkBtn :
          if ( SRCollapsed ) {
            call Unhide_All;
          }
					else {
            call Hide_All;
          }
          break;

//        case 408 :
        case id_sr_GlobalSrchCB :
          if ( SendDlgItemMessage( Dlg, WParam, BM_GetCheck, 0, 0 ) ) {
            g_RepSearch = False;
          }
          break;
      }
  }
  return( DlgMessageProc( RetVal, Dlg, Message, WParam, LParam, Parms ) );

Hide_All:
	SendDlgItemMessage( Dlg, id_sr_SearchStr, cb_ShowDropDown, False, 0 );
	if ( g_SearchMode ) {
		SendDlgItemMessage( Dlg, id_sr_ReplaceStr, cb_ShowDropDown, False, 0 );
		if ( IsWindowEnabled( GetDlgItem( Dlg, id_sr_ReplaceBtn ) ) ) {
			SetFocus( GetDlgItem( Dlg, id_sr_ReplaceBtn ) );
			SendMessage( Dlg, dm_SetDefId, id_sr_ReplaceBtn, 0 );
		}
	}
	else {
		SetFocus( GetDlgItem( Dlg, id_sr_SearchBtn ) );
	}
	EnableWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), True );
	ShowWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), sw_Show );
	Jx = !SendDlgItemMessage( Dlg, id_sr_BackwardRB, BM_GetCheck, 0, 0 );
	call SetDirBtn;

  Enable_Flag = False;
  Hide_Flag = SW_HIDE;
  goto Process_Hide;

Unhide_All:
	EnableWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), False );
	ShowWindow( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), sw_Hide );
	TStr = "";
	SendMessageStr( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), wm_SetText, 0, TStr );
  Enable_Flag = True;
  Hide_Flag = SW_SHOW;

Process_Hide:
	if ( Message != wm_ShowWindow ) {
  	SendMessage( Dlg, WM_SetRedraw, False, 0);
	}

  EnableWindow( GetDlgItem( dlg, id_sr_LiteralRB ), enable_flag );
  ShowWindow( GetDlgItem( dlg, id_sr_LiteralRB ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_RegExpRB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_RegExpRB ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_WordSrchRB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_WordSrchRB ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_TypeGrp), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_TypeGrp ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_ForwardRB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_ForwardRB ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_BackwardRB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_BackwardRB ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_DirectionGrp), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_DirectionGrp ),  hide_flag);

//  EnableWindow (GetDlgItem (dlg, id_sr_ReplaceOneCB), enable_flag);
//  ShowWindow( GetDlgItem( dlg, id_sr_ReplaceOneCB ),  hide_flag);

  EnableWindow (GetDlgItem(dlg, id_sr_PromptSrchCB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_PromptSrchCB ),  hide_flag);

  EnableWindow( GetDlgItem( Dlg, id_sr_ExitNoFindCB ), Enable_Flag);
  ShowWindow( GetDlgItem( Dlg, id_sr_ExitNoFindCB ), Hide_Flag );

  EnableWindow (GetDlgItem(dlg, id_sr_OptionGrp), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_OptionGrp ),  hide_flag);

  if ( SearchMode ) {
    EnableWindow( GetDlgItem( Dlg, id_sr_PosEndStrCB), enable_flag);
    ShowWindow( GetDlgItem( Dlg, id_sr_PosEndStrCB ),  hide_flag);

    EnableWindow( GetDlgItem( Dlg, id_sr_PosBegStrCB), enable_flag);
    ShowWindow( GetDlgItem( Dlg, id_sr_PosBegStrCB ),  hide_flag);

    EnableWindow( GetDlgItem( Dlg, id_sr_CursorPosGrp), enable_flag);
    ShowWindow( GetDlgItem( Dlg, id_sr_CursorPosGrp ),  hide_flag);
  }
	else {
  	EnableWindow( GetDlgItem( Dlg, id_sr_MarkFndTxtCB ), Enable_Flag );
  	ShowWindow( GetDlgItem( Dlg, id_sr_MarkFndTxtCB ),  Hide_Flag );

    EnableWindow (GetDlgItem (dlg, id_sr_ListPrevBtn), enable_flag);
    ShowWindow( GetDlgItem( dlg, id_sr_ListPrevBtn ),  hide_flag);
  }

  EnableWindow (GetDlgItem (dlg, id_sr_CaseCB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_CaseCB ),  hide_flag);
  EnableWindow (GetDlgItem (dlg, id_sr_GlobalSrchCB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_GlobalSrchCB ),  hide_flag);
  EnableWindow (GetDlgItem (dlg, id_sr_BlockSrchCB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_BlockSrchCB ),  hide_flag);
  EnableWindow( GetDlgItem( Dlg, id_sr_BlockSrchCB ), BlkOn );
  EnableWindow (GetDlgItem (dlg, id_sr_AllWindowsCB), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_AllWindowsCB ),  hide_flag);
  EnableWindow (GetDlgItem (dlg, id_sr_ModeGrp), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_ModeGrp ),  hide_flag);

  EnableWindow (GetDlgItem (dlg, id_sr_RegExpHlpBtn), enable_flag);
  ShowWindow( GetDlgItem( dlg, id_sr_RegExpHlpBtn ),  hide_flag);
  EnableWindow( GetDlgItem( Dlg, id_sr_AliasBtn ), Enable_Flag );
  ShowWindow( GetDlgItem( Dlg, id_sr_AliasBtn ), Hide_Flag );

  struct TRect Rect;
  struct TPoint Pt;

  int TopPos = 0;
	int BtnHeight = 0;
	int HelpRight;

  if ( SRCollapsed ) {
    GetWindowRect( GetDlgItem( Dlg, id_sr_OptionGrp ), &Rect );
    Pt.X = Rect.Left;
    Pt.Y = Rect.Bottom;
    ScreenToClient( Dlg, &Pt );
    TopPos = Pt.Y + 3;
    SRCollapsed = False;
  }
	else {
    GetWindowRect( GetDlgItem( Dlg, id_sr_ShrinkBtn ), &Rect );
    Pt.X = Rect.Left;
    Pt.Y = Rect.Bottom;
    ScreenToClient( Dlg, &Pt );
    TopPos = Pt.y + 7;
    SRCollapsed = True;
  }
  GetWindowRect( GetDlgItem( Dlg, id_sr_SearchBtn ), &Rect );
  ScreenToClient( Dlg, &Rect );
  SetWindowPos( GetDlgItem( Dlg, id_sr_SearchBtn ), 0, Rect.Left, TopPos, 0, 0,
			SWP_NOSIZE | SWP_NOZORDER);

  GetWindowRect( GetDlgItem( Dlg, id_sr_CancelBtn ), &Rect );
  ScreenToClient( Dlg, &Rect );
  SetWindowPos( GetDlgItem( Dlg, id_sr_CancelBtn), 0, Rect.Left, TopPos, 0, 0,
			SWP_NOSIZE | SWP_NOZORDER);

  GetWindowRect( GetDlgItem( Dlg, id_sr_AllBtn), &Rect);
  ScreenToClient( Dlg, &Rect );
  SetWindowPos( GetDlgItem( Dlg, id_sr_AllBtn ), 0, Rect.Left, TopPos, 0, 0,
			SWP_NOSIZE | SWP_NOZORDER);

  GetWindowRect( GetDlgItem( Dlg, id_sr_HelpBtn ), &Rect );
  BtnHeight = Rect.Bottom - Rect.Top;
	HelpRight = Rect.Right;
  ScreenToClient( Dlg, &Rect );
  SetWindowPos( GetDlgItem( Dlg, id_sr_HelpBtn ), 0, Rect.Left, TopPos, 0, 0,
			SWP_NOSIZE | SWP_NOZORDER);

  if ( g_SearchMode != False ) {
    GetWindowRect( GetDlgItem( Dlg, id_sr_ReplaceBtn ), &Rect );
    ScreenToClient( Dlg, &Rect );
    SetWindowPos( GetDlgItem( Dlg, id_sr_ReplaceBtn ), 0, Rect.Left, TopPos,
				0, 0, SWP_NOSIZE | SWP_NOZORDER );
  }
  GetWindowRect( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), &Rect );
  ScreenToClient( Dlg, &Rect );
  SetWindowPos( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), 0, Rect.Left, TopPos, 0,
			0, SWP_NOSIZE | SWP_NOZORDER);

  GetWindowRect( Dlg, &Rect);
	if ( Message != wm_ShowWindow ) {
  	SendMessage( Dlg, WM_SetRedraw, True, 0 );  // turn refresh of dialog back on
	}
//  SetWindowPos( Dlg, 0, 0, 0, Rect.Right - Rect.Left, TopPos + BtnHeight +
  SetWindowPos( Dlg, 0, 0, 0, HelpRight - Rect.Left + 6, TopPos + BtnHeight +
			GetSystemMetrics( SM_CYCAPTION ) + 10, SWP_NOMOVE | SWP_NOZORDER );
	if ( Message != wm_ShowWindow ) {
  	RedrawWindow( Dlg, 0, 0, RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW );
	}
//  redraw;     // redraw the screen
  ret;

Set_Flags:
	// simply sets the flags depending on what is selected in the dialog

  // sets value for search str
  GetWindowText( GetDlgItem( Dlg, id_sr_SearchStr ), TStr, 256 );
  g_SearchStr = TStr;
  if ( g_SearchMode ) {
    // sets value for replace str
    GetWindowText( GetDlgItem( Dlg, id_sr_ReplaceStr ), TStr, 256 );
    g_ReplaceStr = TStr;

  }
  TStr = "";
	if ( !SendDlgItemMessage( Dlg, id_sr_RegExpRB, BM_GetCheck, 0, 0 ) ) {
    TStr += "X";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_WordSrchRB, BM_GetCheck, 0, 0 ) ) {
    TStr += "W";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_BackwardRB, BM_GetCheck, 0, 0 ) ) {
    TStr += "B";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_PromptSrchCB, BM_GetCheck, 0, 0 ) ) {
    TStr += "P";
  }
//  if ( SendDlgItemMessage( Dlg, 408, BM_GetCheck, 0, 0) ){
//    if ( global_int('Search_Mode') ) {
//      TStr += 'N';     // for search and replace
//    } else {
//      TStr += "L";  // for search only
//    }
//  }
  if ( SendDlgItemMessage( Dlg, id_sr_ExitNoFindCB, BM_GetCheck, 0, 0 ) ) {
    TStr += 'K';
    ExitNoFind = True;
  }
  else {
    ExitNoFind = False;
  }
  if ( SendDlgItemMessage( Dlg, id_sr_MarkFndTxtCB, BM_GetCheck, 0, 0 ) ) {
    TStr += "M";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_CaseCB, BM_GetCheck, 0, 0 ) == 0 ) {
    TStr += "I";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_GlobalSrchCB, BM_GetCheck, 0, 0 ) ) {
    TStr += "G";
  }
  if ( SendDlgItemMessage( Dlg, id_sr_BlockSrchCB, BM_GetCheck, 0, 0 ) ) {
    if ( Block_Stat > 0 ) {
      TStr += "R";
    }
  }
  if ( SendDlgItemMessage( Dlg, id_sr_AllWindowsCB, BM_GetCheck, 0, 0 ) ) {
    TStr += "A";
  }
  if ( g_SearchMode ) {
		// these options only appear on search and replace
    if ( SendDlgItemMessage( Dlg, id_sr_PosBegStrCB, BM_GetCheck, 0, 0 ) ) {
      TStr += "C";
		}
    g_ReplSwitches = TStr;
  }
	else {
    g_Switches = TStr;
  }
  ret;  // Set_Flags

SetDirBtn:
	SendDlgItemMessage( Dlg, id_sr_ForwardRb, bm_SetCheck, Jx, 0 );
	SendDlgItemMessage( Dlg, id_sr_BackwardRB, bm_SetCheck, !Jx, 0 );
	if ( Jx ) {
		TStr = "B&wd";
	}
	else {
		TStr = "F&wd";
	}
	SendMessageStr( GetDlgItem( Dlg, id_sr_DirSwitchBtn ), wm_SetText, 0, TStr );
	ret;

}  // SRProc

macro S_And_R no_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: S_AND_R

Description:  Search and search/replace interface.

Parameters:
							/BC=  Number of boxes to kill after exiting

Returns:      Return_Int 			( Normal search )
									0 					if <ESC> or Cancel was pressed at the prompts.
									1 					if search was carried through.

							Return_Int			File Replace ( /FR=1 )
									0 					Normal s/r occurred
									1 					Non-Stop all files
	 				 	 		 -1 					Abort remaining files

							Global_Int( "Found_Count" ) = # of occurrences found.
							Global_Int( "Replace_Count" ) = # of replaces.

Globals used:

							Global_Str('Switches')  	The search switches:
																				I - Ignore case
																				G - Global, search entire file
																				N - No prompts, search and replace
																						unconditionally
																				P - Prompt for repeated searches/replaces
																				B - Search backwards
																				X - Regular expressions off.  Faster if
																						regs not needed.
																				R - Restrict search to marked block
																				C - Don't move cursor to the right after
																						a replace has occurred between
																						multiple searches and replaces.
																						Applies only to search and replace.
																				W - Word/Phrase search
																				L - List all occurrences
																				A - search all windows
																				K - Kill dialog when no string found

							Global_Str('Repl_Switches') Replace switches - See above.
							GLOBAL_STR('SEARCH_STR')	String to search for.
							GLOBAL_STR('REPLACE_STR')	String to replace with.
							GLOBAL_INT('SEARCH_MODE')	Mode 0=search 1=seach and replace
							GLOBAL_INT('REPSEARCH')		Simply repeat search or search/replace
																				according to previous search.  No box
																				with prompts.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int SavRefresh = Refresh;
	int FoundNum, count, jm, jz, JX, Start_Row, Box_Ofs,t_col, kill_count, tp,
      hl,Back_Search, Search_Mode, Restrict, Restrict_Count, orig_line, orig_row,
			Active_Window = Window_Id,
			first_window = window_id,
			List_Window_Num = 0,
			tpb = persistent_blocks,
			Making_List = false,
			File_Replace = ( Parse_Int( "/FR=", MParm_Str ) > 0 );
	int All_Files = 0;
	int	ev_count = 0,
			#IFNDEF windows
			t_status_row = status_row,
			#ENDIF
			search_all_windows = 0,
			all_windows_count = 0,
			all_windows_foundnum = 0,
			all_windows_global = 0,
			skip_all = 0,
			t_tab_expand = tab_expand,
      MarkFoundText = 0,
			s_flags = 0;  // TMJ - 06-15-93 12:58pm - For Unix style expressions
	int TSearch_Highlight = Search_Highlight;

	int  GLOBALSEARCH, noprompt, S_Prompt,Searching,temp_ins, S_RES ,
					No_Cursor_Movement,New_Line_Num, Across_Lines,
					at_top = 0;
	str  Search_Str,Replace_Str,SpareString[200], Switches_Str[20], help_str[20],
					Interface_Mac ,
					list_File_Name[128];

  if ( !Global_Int( "~SR_MODAL" ) ) {
    if ( SReturn_Int == 0 ) {
      goto S_And_R_Exit;
    }
  }

	Refresh = False;
	persistent_blocks = TRUE;
	kill_count  = parse_int('/BC=', mparm_str );
	start_row   = parse_int('/Y=', mparm_str);
	Box_Ofs = 0;

	Push_Undo;
	help_str = SEARCH_HELPLINK;
	Search_Str  = g_SearchStr;
	Replace_Str = g_ReplaceStr;
	Search_Mode = g_SearchMode;

	if ( File_Replace ) {
		if ( Search_Mode ) {
			SpareString = "FRSwitches";
		}
		else {
			SpareString = "FSwitches";
		}
	}
	else {
		if ( Search_Mode ) {
			SpareString = "Repl_Switches";
		}
		else {
			SpareString = "Switches";
		}
	}
	Switches_Str = Caps( Global_Str( SpareString ) );

	FoundNum = 0;
	Count = 0;

  if ( g_RepSearch == False ) {
//		Jx = XPos( "R", Switches_Str, 1 );
//		if( !TPb && Block_Stat && !Jx ) {
//			Switches_Str += "R";
//		}
//		else if ( !Tpb && !Block_Stat && Jx ) {
//		if ( !Tpb && !Block_Stat && Jx ) {
//      if ( Global_Int( "~SR_MODAL" ) ) {
//        Switches_Str = Str_Del( Switches_Str, Jx, 1 );
//      }
//		}
		Set_Global_Str( SpareString, Switches_Str );
		if ( Search_Mode ) {
			Box_Ofs = 1;
			Help_Str = SRCHREP_HELPLINK;
		}
		Set_Global_Int( "Menu_Result", False );

		// This allows the user to call an alternate search interface
		Interface_Mac = Global_Str( "@Srch_Intr_Macro" );
		if ( Svl( Interface_Mac ) == 0 ) {
			Interface_Mac = "SrchIntr ";
		}
		if ( XPos( " ", Interface_Mac, 1 ) == 0 ) {
			Interface_Mac += " ";
		}
    if ( Global_Int( "~SR_MODAL" ) ) {
      SetSearchHistory();
			// Call the search/replace user interface macro
      Rm( Interface_Mac + "/M=" + Str( Search_Mode ) + "/H=" + Help_Str +
            "/Y=" + Str( Start_Row ) + "/SRG=Search_Str/RPG=Replace_Str/SWG=" +
          	SpareString );
    }
		else {
//    if ( !Global_Int('~SR_MODAL') ) {
      Return_Int = SReturn_Int;
    }
    if ( Return_Int == 12 ) {
			Rm( "Search_List" );
			goto S_And_R_Exit;
		}
		Set_Global_Str( "Search_History0", "" );
		Search_Str    = g_SearchStr;
		Replace_Str   = g_ReplaceStr;
		Switches_Str  = Global_Str( SpareString );
    if ( !Return_Int ) {
			goto S_And_R_Exit;
		}
	}
  Return_Int = True;
//	Refresh = True;

Start_Search:
	Switches_Str = Caps( Switches_Str );
	Ignore_Case  = XPos( "I", Switches_Str, 1 ) != 0;
	GlobalSearch = XPos( "G", Switches_Str, 1 ) != 0;

  if ( g_RepSearch ) {
		GlobalSearch = False;
	}
	if ( Search_All_Windows && All_Windows_Global ) {
		GlobalSearch = True;
	}
	NoPrompt      = XPos( "N", Switches_Str, 1 ) != 0;
	Making_List   = XPos( "L", Switches_Str, 1 ) != 0;
	S_Prompt      = XPos( "P", Switches_Str, 1 ) != 0;
	Back_Search   = XPos( "B", Switches_Str, 1 ) != 0;
	Across_Lines  = XPos( "W", Switches_Str, 1 ) != 0;

	// search_all_windows is not compatible with file_replace
	Search_All_Windows = ( XPos( "A", Switches_Str, 1 ) != 0 ) &&
			( File_Replace == 0 );
	No_Cursor_Movement = False;

	if ( Search_Mode == True ) {
		Making_List = False;
		SpareString = Search_Str;
		Return_Str = Replace_Str;
		if ( Ignore_Case ) {
			SpareString = Caps(SpareString);
			Return_Str = Caps(Return_Str);
		}
		if ( SpareString != Return_Str ) {
			/* Don't allow 'C' switch if search_str = replace_str.  This would cause a
				 continuous loop */
			No_Cursor_Movement = XPos( "C", Switches_Str, 1 ) != 0;
		}
	}
	else {
		if ( NoPrompt ) {
			Making_List = True;
		}
		if ( Making_List ) {
			NoPrompt = True;
		}
	}
  Reg_Exp_Stat = XPos( "X", Switches_Str, 1 ) == 0;
	Restrict_Count = 0;
	Orig_Line = C_Line;
  Orig_Row = C_Row;


	// 06-15-93 12:57pm
	// TMJ - Mods for UNIX style regular expressions
	if ( Reg_Exp_Stat ) {
    if ( Reg_Exp_Style ) {
			S_Flags |= _RegExp;
    }
		else {
			S_Flags |= _OldExp;
    }
    Search_Str = ReTranslate( g_SearchStr, 0 );
	}
	if ( !Ignore_Case ) {
		S_Flags |= _CaseSensitive;
	}
	if ( Back_Search ) {
		S_Flags |= _Backward;
	}
	Mark_Pos;
	Restrict = XPos( "R", Switches_Str, 1 ) != 0;
	if ( Restrict ) {
		Block_End;
		if(  Block_Stat == 0  ) {
			if ( Search_All_Windows ) {
				goto Search_Out;
			}
			Rm( "USERIN^Verify /H=SR/BL=NO BLOCK MARKED/T=Perform search on file?" );
      if ( Return_Int == 0 ) {
				Make_Message( "No block marked." );
        Goto_Mark;
				Error_Level = 0;
				goto S_And_R_Exit;
			}
			Restrict = 0;
//      if ( !Global_Int( "~SR_MODAL" ) ) {
//        if ( g_hSRDialog != 0 ) {
//          SendDlgItemMessage( g_hSRDialog, id_sr_BlockSrchCB, BM_SetCheck, False, 0 );
//          if ( XPos( "G", Switches_Str, 1 ) ) {
//            goto Restrict1;
//          }
//        }
//      }
		}
		else if ( ( ( C_Line == Block_Line1 ) && ( C_Col < Block_Col1) ) ||
					( ( C_Line == Block_Line2 ) && ( C_Col >= Block_Col2 ) ) ||
					( C_Line < Block_Line1 ) || ( C_Line > Block_Line2 ) || !Tpb ) {
      if ( !Global_Int( "~SR_MODAL" ) ) {   // for modeless dialog
        if ( g_RepSearch == False ) {
          goto Restrict1;
        }
      }
			else {
        goto Restrict1;
      }
		}
	}
  if ( GlobalSearch == True ) {

Restrict1:
		if ( Back_Search ) {
			if ( Restrict ) {
				Goto_Line( Block_Line2 );
				Eol;
			}
			else {
				Eof;
			}
		}
		else {
			if ( Restrict ) {
				Goto_Line( Block_Line1 );
				Goto_Col( 1 );
				Goto_Col( Block_Col1 );
			}
			else {
				Goto_Line( 1 );
				Goto_Col( 1 );
			}
		}
	}
//  Make_Message( "" );
	Temp_Ins = Insert_Mode;
	Insert_Mode = True;
	Searching = True;

  if ( NoPrompt && Search_Mode ) {
    Refresh = False;
  }

	Error_level = 0;

	while ( Searching ) {
		Refresh = False;
		if ( NoPrompt ) {
			if ( Search_Mode ) {
				Make_Message( "Searching... Replaces:" + Str( Count ) + " <CtrlBREAK> to abort." );
			}
			else {
				Make_Message( "Searching... Occurrences:" + Str( FoundNum ) + " <CtrlBREAK> to abort." );
			}
		}
		else {
			Make_Message( "Searching...   <CtrlBREAK> to abort." );
		}
		Working;
		Orig_Line = C_Line;
    Orig_Row = C_Row;
		if ( Back_Search ) {
			if ( Restrict ) {

SAgain2:
				Restrict_Count = C_Line - Block_Line1 + 1;
				if ( Restrict_Count < 1 ) {
					goto Search_Out;
				}
				if ( Across_Lines ) {
					Return_Str = Search_Str;
					Rm( "Srch_Across_Line /R=" + Str( Restrict_Count )
						 + "/B=" + Str( Back_Search ) );
          S_Res = Return_Int;
				}
				else {
					S_Res = Find_Text( Search_Str, Restrict_Count, S_Flags );
				}

				/* check to see if the last time we went through this loop we set the
					at_top flag.  If so, consider this find to have failed to avoid a
	 				continuous loop */

				if ( At_Top ) {
					S_Res = 0;
				}
				/* set special flag if we are already at the top of the file so we
					don't get into a continuous loop */

				At_Top = ( C_Line == 1 ) && ( C_Col == 1 );

				if ( S_Res ) {
					if(  block_stat == 2  ) {
						if(  (c_col < block_col1) | ((c_col + length(found_str) - 1) > block_Col2)  ) {
							call searchmove;
							goto sagain2;
						}
					}
					else if(  block_stat == 3  ) {
						if(  ((c_line == block_line1) & (c_col < block_col1))  ) {
							call searchmove;
							goto sagain2;
						}
						else if(  ((c_line == block_line2) & ((c_col + length(found_str) - 1) > block_col2))  ) {
							call searchmove;
							goto sagain2;
						}
					}
				}
			}
			else {
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
          S_Res = Return_Int;
				}
				else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}

/* check to see if the last time we went through this loop we set the at_top
	 flag.  If so, consider this find to have failed to avoid a continuous loop */
				if (at_top)
					s_res = 0;
/* set special flag if we are already at the top of the file so we don't get
	 into a continuous loop */
				at_top = ((c_line == 1) && (c_col == 1));

			}
		}
		else {
			if ( Restrict ) {

sagain:
				Restrict_Count = Block_Line2 - C_Line + 1;
				if(  restrict_count < 1  ) {
					goto search_out;
				}
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
          S_Res = Return_Int;
				} else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}
				if(  s_res  ) {
					if(  block_stat == 2  ) {
						if(  (c_col < block_col1) | ((c_col + length(found_str) - 1) > block_Col2)  ) {
							call searchmove;
							goto sagain;
						}
					}
					else if(  block_stat == 3  ) {
						if(  ((c_line == block_line1) & (c_col < block_col1))  ) {
							call searchmove;
							goto sagain;
						} else if(  ((c_line == block_line2) & ((c_col + length(found_str) - 1) > block_col2))  ) {
							call searchmove;
							goto sagain;
						}
					}
				}
			}
			else {
				if(  (Across_Lines)  ) {
					Return_Str = Search_Str;
					RM('SRCH_ACROSS_LINE /R=' + Str(Restrict_Count)
						 + '/B=' + Str(Back_Search));
          S_Res = Return_Int;
				}
				else {
					S_Res = Find_Text(Search_Str, Restrict_Count, s_flags );
				}
			}
		}
    // This only occurs if user pressed <CTRL-BREAK>
    if ( Error_Level == 1015  ) {
			Make_message('Search aborted by user.');
//      refresh = true;
//      redraw;
			Error_level = 0;
			GOTO S_And_R_Exit;
		}
    if ( S_Res ) {
      if ( FoundNum == 0 ) {
				/* Only after the first successful find will we create a window to put our list */
				++all_windows_count;
				if ( Making_List ) {

					// Mod to handle correct placement of .TMP files
          Rm( "TMP_FILE_NAME /FN=SRLST.TMP" );
          list_file_name = FExpand(return_str);
					if (switch_file(list_file_name)) {
						if (all_windows_count == 1) {
							erase_window;
						}
					}
					else {
						switch_window(window_count);
						Create_Window;
					}
					file_name = list_file_name;
					window_Attr = $81;
//					pad_str (sparestring, 80," ");
//					sparestring = str_ins("",sparestring,7) + "";
//					format_line = sparestring;
					List_Window_Num = Cur_Window;
					Switch_Win_Id(Active_Window);
					Tab_Expand = True;
					Put_Line_To_Win( "\x7F@\xFE=" + File_Name + "\x7F#=\x7FOCC=",
							All_Windows_Count + All_Windows_FoundNum, List_Window_Num, False );
					Tab_Expand = T_Tab_Expand;
				}
				else {
					Pop_Mark;
				}
			}
			++FoundNum;
			if ( Making_List ) {
				int t_col = C_Col - (255 / 2);

				if ( T_Col < 1 ) {
					T_Col = 1;
				}
				Sparestring = Copy( Get_Line( ), T_Col, 255 );
				Tabs_To_Spaces( SpareString );
				Tab_Expand = True;
				Put_Line_To_Win( "\x7F" + "L=" + Str( C_Line ) + "\x7F" + "T=" +
						SpareString, FoundNum + All_Windows_Count + All_Windows_FoundNum,
						List_Window_Num, False);
				Tab_Expand = T_Tab_Expand;
			}
			if ( Search_Mode ) {
				call Do_Replace_Prompt;
			}
			else {
				call Do_Search_Prompt;
			}
		}
		else {
			Searching = False;
			if ( FoundNum == 0 ) {
				Goto_Mark;
			}
		}
	}

Search_Out:
	if ( Making_List && FoundNum ) {
		Switch_Window( List_Window_Num );
		Tab_Expand = True;
		Goto_Line( All_Windows_FoundNum + All_Windows_Count );
		Goto_Col( 1 );
		if ( Find_Text( "\x7F" + "#=", 1, 0 ) ) {
			Rm( "DelEol" );
			Text( "\x7F" + "#=" + Str( All_Windows_Count ) + "\x7F" + "OCC=" + Str( FoundNum ) );
		}
		Tab_Expand = T_Tab_Expand;
		Switch_Win_Id( Active_Window );
	}
	if ( Search_All_Windows ) {
		all_windows_foundnum += foundnum;
		if ( !S_Prompt && FoundNum && !Making_List && !NoPrompt) {
			// we should only get here if we have stop on first occurrence selected
			Search_All_Windows = False;
			goto All_Windows_Found;
		}
		if ( !Skip_All ) {
			if ( All_Windows_Count > 1 ) {
				Goto_Mark;
			}
			Pop_Undo;
      if ( back_search ) {
        Switch_Window( Cur_Window - 1 );
      }
			else {
        Switch_Window( Cur_Window + 1 );
      }
      Rm( "FindWin /HIDDEN=1/B=" + Str( Back_Search ) );
			push_undo;
			active_window = window_id;
			if ( Window_Id != First_Window ) {
				all_windows_global = true;
				foundnum = 0;
				goto start_search;
			}
		}
	}

All_Windows_Found:
	Set_Global_Int( "Menu_Result", True );
	if ( Making_List && ( FoundNum || All_Windows_FoundNum ) ) {
		Switch_Window( List_Window_Num );

		Set_Global_Str("!SR_LST_WN","/SS=" + Global_Str("SEARCH_STR"));

    tof;
		Switch_Win_Id(Active_Window);
    Goto_Mark;
		Rm( "Search_List" );
	}
	else {
		if ( Search_All_Windows ) {
			SpareString = "String found " + Str( All_Windows_FoundNum ) +
					" times in " + Str( All_Windows_Count ) + " files.";
		}
		else {
			if ( Search_Mode ) {
				SpareString = "String replaced " + Str( Count ) + " times.";
			}
			else {
				SpareString = "String found " + Str( FoundNum ) + " times.";
			}
		}
		Make_Message( SpareString );
	}
	Insert_Mode = Temp_Ins;
	goto S_And_R_Exit;


Do_Replace_Prompt:

Replace_Loop:
	if ( NoPrompt == False ) {
		call Highlight_Find;
		if ( !S_Prompt ) {
			Searching = False;
		}
//    Make_Message( "" );

Replace_Loop1:
    if ( Global_Int( "~SR_MODAL" ) ) {
      Return_Int = Create_SR_Dialog( Search_Mode, File_Replace, S_Prompt,
					Search_all_Windows );
    }
		else {
      Return_Int = SReturn_Int;
      if ( Return_Int == 555 ) {
				if ( g_hSRDialog ) {
					if ( GetActiveWindow( ) != g_hSRDialog ) {
						SetActiveWindow( g_hSRDialog );
					}
					SReturn_Int = 0;
					Return_Int = 0;
				}
				else {

					int TSearch_Highlight = Search_Highlight;

        	Rm( "SrchIntr /SRG=Search_Str/RPG=Replace_Str" );
					Search_Highlight = TSearch_Highlight;
				}
      }
    }
    if ( Return_Int == 103 ) {
      call SearchMove;
    }
		else if ( Return_Int == 104 ) {
			NoPrompt = True;
    }
		else if ( Return_Int == 105 ) {
			NoPrompt = True;
			All_Files = 1;
    }
		else if ( Return_Int == 106 ) {
			Searching = False;
    }
		else if ( Return_Int == 107 ) {
      Searching = False;
    }
		else if ( ( Return_Int == 102 ) || ( Return_Int == 0 ) ) { //value of -100 is used because
      All_Files = -1;
      Skip_All = 1;                                           //we subtract 100 from the value
      Searching = False;                                      //in Create_SR_Dialog
    }
		else if ( ( Return_Int == 101 ) || ( Return_Int == 555 ) ) {
      if ( !Global_Int( "~SR_MODAL" ) ) {
        SReturn_Int = 0;
      }
			T_Col = C_Col;
			if ( Across_Lines ) {
				Return_Str = Replace_Str;
				Rm( "Repl_Across_Line " );
			}
			else {
				Replace( Replace_Str );
			}
      if ( No_Cursor_Movement ) {
        Goto_Col( T_Col );
      }
			else {
				if ( Back_Search ) {
					Goto_Col( T_Col );
					Left;
				}
				else {
					while ( !At_Eol && ( Cur_Char == "\xFF" ) ) {
						Right;
					}
					if ( At_Eol ) {
						Right;
					}
				}
			}
			++Count;
		}
		else {
			goto Replace_loop1;
		}
		if ( NoPrompt == True ) {
			goto NonStop;
		}
		ret;
	}
	else {

NonStop:
		T_Col = C_Col;
		if ( Across_Lines ) {
			Return_Str = Replace_Str;
			Rm( "Repl_Across_Line ");
		}
		else {
			Replace( Replace_Str );
		}
		if ( No_Cursor_Movement ) {
			Goto_Col(T_Col);
		}
		else {
			if ( Back_Search ) {
				Goto_Col( T_Col );
				Left;
			}
			else {
				while ( !At_Eol && ( Cur_Char == "\xFF" ) ) {
					Right;
				}
				if ( At_Eol ) {
					Right;
				}
			}
		}
		++Count;
	}
	ret;

Highlight_Find:
	Refresh = False;
	if ( Across_Lines ) {
		// This will scroll the screen to make as much of the phrase as possible visable
		jx = Parse_Int('/L=',Global_Str('@LINE_SEARCH_POS')) - c_line;
		if (jx > (win_y2 - win_y1))
			jx = (win_y2 - win_y1);
		goto_line(c_line + jx);
	}

	if(collapse_mode & 0x01)
	{
		if(line_stat & 0x04)
		{
			rm("Collapse^CollapseMouse /M=2");
		}
	}
	if(  c_line > orig_line  ) {
		if(  (c_line - orig_line) <= ((win_y2 - win_y1) - c_row)  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line < tp  ) {
				down;
			}
		}
		else {
			call Center_Line;
		}
	}
	else {
		if ( ( Orig_Line - C_Line ) < C_Row ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line > tp  ) {
				up;
			}
		}
		else {
			call Center_Line;
		}
	}

  MarkFoundText = ( XPos( "M", Switches_Str, 1 ) != 0 );
	if ( Across_Lines ) {
		// This brings the cursor back to the right place after the scrolling above
		Refresh = True;
		Redraw;
		for ( Jx; Jx > 0; Jx-- ) {
			Up;
		}
		// Highlight the entire phrase
		Jx = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS'));
    if ( MarkFoundText && !Search_Mode )  {
      Mark_Pos;
      Str_Block_Begin;
      Goto_Line( Parse_Int( "/L=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ) );
      Goto_Col( Parse_Int( "/C=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ) +
      		Length( Parse_Str( "/S=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ) ) );
      Block_End;
      Goto_Mark;
    }
		else {
      Set_Highlight( C_Line, C_Col,
					Parse_Int( "/L=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ),
        	Parse_Int( "/C=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ) +
        	Length( Parse_Str( "/S=", Global_Str( "@LINE_SEARCH_STR" + Str( Jx ) ) ) ) );
    }
	}
	else {
    if ( ( C_Line - C_Row ) != ( Orig_Line - Orig_Row ) ) {
      Redraw;
    }
		if ( MarkFoundText && !Search_Mode ) {
			Refresh = True;
			Hl = C_Line;
			Tp = C_Col;
			Goto_Line( Search_End_Line );
			Goto_Col( Search_End_Col );
      Str_Block_Begin;                //mnb block stuff
			Goto_Line( Hl );
			Goto_Col( Tp );
      Block_End;                      //mnb block stuff
		}
		else {
      Search_Highlight = Buffer_Id; //mnb block stuff commented out
    }
		if ( Event_Macro != "" ) {
			Key1 = 0;
			Key2 = 0;
			Rm( Event_Macro );
		}
	}
	ret;


Do_Search_Prompt:
	if ( NoPrompt ) {
		call SearchMove;
		ret;
	}
	call Highlight_Find;
	if ( !S_Prompt ) {
		Make_Message( "String Found " + Str( FoundNum ) + " Times." );
		Searching = False;
		ret;
	}
  if ( Global_Int( "~SR_MODAL" ) ) {
    Return_Int = Create_SR_Dialog( Search_Mode, File_Replace, S_prompt,
				Search_All_Windows );
  }
	else {
    Return_Int = SReturn_Int;
    if ( Return_Int == 555 ) {
			if ( g_hSRDialog ) {
				if ( GetActiveWindow( ) != g_hSRDialog ) {
					SetActiveWindow( g_hSRDialog );
				}
				SReturn_Int = 0;
				Return_Int = 0;
			}
			else {

				int TSearch_Highlight = Search_Highlight;

        Rm( "SrchIntr /SRG=Search_Str/RPG=Replace_Str" );
				Search_Highlight = TSearch_Highlight;
			}
    }
  }

Search_PromptX:
//  Make_Message('');
  if ( ( Return_Int == 102 ) || ( Return_Int == 0 ) ) {  //value of -100 is used because
    Searching = FALSE;                                 //we subtract 100 from the value
    Skip_All = 1;                                      //in Create_SR_Dialog
  }
	else if ( Return_Int == 103 ) {
		Searching = False;
	}
	else {
		call SearchMove;
	}
	ret;

SearchMove:
	if ( Back_Search ) {
		Left;
	}
	else {
		Right;
		while ( !At_Eol && ( Cur_Char == "\xFF" ) ) {
			Right;
		}
		if ( At_Eol ) {
			Right;
		}
	}
	ret;

Center_Line:
	{
		int toldline;
		New_Line_Num = C_Line;
		Tp = ( Win_Y2 - Win_Y1 ) / 2;
		// These 6 lines will center the selected line on the screen if possible
		while ( C_Row > Tp ) {
			toldline = c_line;
			Up;
			if(toldline = c_line)
				break;
		}
		while ( C_Row < Tp ) {
			toldline = c_line;
			Down;
			if(toldline = c_line)
				break;
		}
		Goto_Line( New_Line_Num );
		ret;
	}

S_And_R_Exit:
	Tab_Expand = T_Tab_Expand;
	#IFNDEF windows
	status_row = t_status_row;
	#ENDIF
	persistent_blocks = tpb;

	if ( Search_All_Windows ) {
		g_FoundCount = All_Windows_FoundNum;
	}
	else {
		g_FoundCount = FoundNum;
	}
	g_ReplaceCount = Count;
	Pop_Undo;
	g_RepSearch = False;
	Reg_Exp_Stat = True;
	Rm( "Select_Window /BM=1/VIS=1" );
	Refresh = SavRefresh;
	Redraw;
	if ( Across_Lines ) {
		Jx = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS'));
		while(  (Jx)  ) {
			Set_Global_Str('@LINE_SEARCH_STR' + Str(Jx),'');
			--Jx;
		}
		Set_Global_Str('@LINE_SEARCH_POS','');
	}
	if ( File_Replace ) {
  	Return_Int = All_Files;
	}

}  // S_And_R

macro SrchIntr no_break trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SrchIntr

Description:  Search (and Replace) User Interface.  This macro is called
							by S_AND_R.

Parameters:		/M=n	Mode, 0 = Search, 1 = Search and Replace
							/H=str Help String
							/SRG=str  Name of the global_str to put the search str in
							/RPG=str  Name of the global_str to put the replace str in
							/SWG=str  Name of the global_str to put the switches str in
							/SWONLY=1	Edit switches only

Returns:
						Return_Int > 0 IF START_SEARCH WAS SELECTED

							 (C) Copyright 1991 by American Cybernetics, Inc.
SEARCHķ
Search For:                                                         ݺ
                                                                       
Type:                               Direction:                         
  ( ) Literal                         () Forward  ( ) Backward        
  ( ) Regular expressions           Mode:                              
  ( ) Word/Phrase search              () Stop on first occurrence     
Options:                              ( ) Prompt for next search       
  [ ] Case sensitive                  ( ) Find all occurrences         
  [ ] Global search                                                    
  [ ] Restrict to marked block                                         
                                                                       
                   OK<ENTER> Cancel<ESC> Help<F1> Short form<F5>   
                             
ͼ
SEARCH AND REPLACEķ
Search For:                                                         ݺ
Replace With: ݺ
                                                                       
Type:                               Direction:                         
  ( ) Literal                         () Forward  ( ) Backward        
  ( ) Regular expressions           Mode:                              
  ( ) Word/Phrase search              ( ) Replace first occurrence only
Options:                              () Prompt for each replace      
  [ ] Case sensitive                  ( ) Replace all occurrences      
  [ ] Global search                 Leave cursor at:                   
  [ ] Restrict to marked block        () End of replace string        
                                      ( ) Start of replace string      
                                                                       
                   OK<ENTER> Cancel<ESC> Help<F1> Long form<F5>    
                              
ͼ
*******************************************************************************/

  if ( g_hSRDialog != 0 ) {
		// don't allow multiple occurances, switch to currently active dialog
    SetActiveWindow( g_hSRDialog );
		return ( );
	}

	int TRefresh = Refresh;
  int search_mode = 0,
			sw_pos,
			tsw_pos,
			jx,
			ic,
			gs,
			ps,
			rb,
			bs,
			np,
			cs,
			ml,
			aw,
			opt,
			count,
//    	smode,
			MarkFoundText,
    	SwOnly = Parse_Int( "/SWONLY=", Mparm_Str ),
    	tpb = persistent_blocks,
			leftpos;
  int Dlg;
	int CtrlCol2 = 33;
	int YPos;
	int DefCtrl;
  int ExitNoFind;

  str help_str[40],
			title_str[30] = "Search",
			sparestring;
	str BtnStr;

  Search_Mode = g_SearchMode;
  if ( Xpos( "/M=", MParm_Str, 1 ) )  {
    Search_Mode = Parse_Int( "/M=", MParm_Str );
  }
  persistent_blocks = true;
  if ( !Global_Int('~SR_MODAL') ) {
    leftpos = 13;
    if ( Search_Mode ) {
      Title_Str = "Search And Replace";
      SpareString = "Repl_Switches";
    }
		else {
      SpareString = "Switches";
    }
    Help_Str = Global_Str( SpareString );
  }
	else {
    leftpos = 1;
    help_str = Global_Str(parse_str('/SWG=', mparm_str));
  }

Again:
	sw_pos = 3;
	ic = ( XPos( "I", Help_Str, 1 ) == 0 );
	gs = ( XPos( "G", help_str, 1 ) != 0 );
	ps = ( XPos( 'P', help_str, 1 ) != 0 );
	bs = ( XPos( "B", help_str, 1 ) != 0 );
  rb = ( XPos( "R", Help_Str, 1 ) != 0 );
//  rb = (block_stat != 0);
//  rb = ( CursorInBlock( True ) != 0 );
	np = ( XPos( 'N', Help_Str, 1 ) != 0 );
	cs = ( XPos( 'C', Help_Str, 1 ) != 0 );
	ml = ( XPos( 'L', Help_Str, 1 ) != 0 );
	aw = ( XPos( 'A', Help_Str, 1 ) != 0 );
  MarkFoundText = XPos( 'M', Help_Str, 1 ) != 0;
  ExitNoFind = XPos( 'K', Help_Str, 1 ) != 0;
	if ( !Search_Mode && Np ) {
		Ml = 1;
	}

	if ( !XPos( "X", help_str, 1 ) ) {
		Opt = 2;
	}
	else if ( XPos( "W", Help_Str, 1 ) ) {
		Opt = 3;
	}
	else {
		Opt = 1;
	}

//	smode = 1;
//	if ( ml ) {
//		smode = 3;
//	}
//	else if ( np ) {
//		smode = 3;
//	}
//	else if ( ps ) {
//		smode = 2;
//	}

  if ( !Global_Int( "~SR_MODAL" ) ) {
    Refresh = False;
    Mark_Pos;
    if ( ( C_Line == Block_Line1 ) && ( Block_Stat > 0 ) &&
				( Block_Line1 == Block_Line2)  ) {
      if ( Block_Stat == 1 ) {
        First_Word;
        Set_Global_Str( "Search_History0", Get_Word( "" ) );
      }
			else {
        Set_Global_Str( "Search_History0", Copy( Get_Line( ), Block_Col1,
						( Block_Col2 - Block_Col1 ) + 1 ) );
      }
    }
		else {
      Right;
      Word_Left;
      Set_Global_Str( "Search_History0", Get_Word( Word_Delimits ) );
    }
    Goto_Mark;
    Refresh = TRefresh;
  }

  DlgCreate( Dlg );
	if ( !SwOnly ) {
    DlgAddCtrl( Dlg, Dlg_Static, "Sear&ch for:",
      	7, 1,
				0, 0,
        101, 0, "" );

    DlgAddCtrl( Dlg, Dlg_Text, Global_Str( Parse_Str( "/SRG=", MParm_Str ) ),
      	Dlg_PosOffset + 14, 1,
				42, 0,
        id_sr_SearchStr, 0, "/ML=256/HISTORY=SEARCH_HISTORY" );

		if ( Search_Mode ) {
      DlgAddCtrl( Dlg, Dlg_Static, "Re&place with:",
      		7, Dlg_PosOffset + 1,
					0, 0,
          102, 0, '');

      DlgAddCtrl( Dlg, Dlg_Text, Global_Str( Parse_Str( "/RPG=", MParm_Str ) ),
      		Dlg_PosOffset + 14,
					Dlg_PosOffset, 42, 0,
          id_sr_ReplaceStr, 0, "/ML=256/HISTORY=REPLACE_HISTORY" );
		}
	}
  DlgAddctrl(dlg, Dlg_GroupBox, "Type",
    	1, Dlg_Units | 26,
			30, (Dlg_Units | ((Dlg_Units_Line_Half * 2) + 14)),
      id_sr_TypeGrp, 0, '');

  DlgAddCtrl( Dlg, Dlg_RadioButton, "&Literal",
      Dlg_PosOffset + 1, Dlg_PosOffset + (Dlg_Units | 11), 0, 0,
      id_sr_LiteralRB, 0, "" );
  DlgSetInt( Dlg, id_sr_LiteralRB, Opt == 1 );

  DlgAddCtrl( Dlg, Dlg_RadioButton, "Regular &expression",
      Dlg_PosOffset, Dlg_PosOffset + 1,
			0, 0,
      id_sr_RegExpRB, 0, "" );
  DlgSetInt( Dlg, id_sr_RegExpRB, Opt == 2 );

  DlgAddCtrl( Dlg, Dlg_RadioButton, "Wor&d/Phrase search",
      Dlg_PosOffset, Dlg_PosOffset + 1,
			0, 0,
      id_sr_WordSrchRB, 0, "" );
  DlgSetInt( Dlg, id_sr_WordSrchRB, Opt == 3 );

  DlgAddCtrl(dlg, Dlg_GroupBox, "Direction",
      Dlg_PosOffset + 31, Dlg_Units | 26, 30, 2,
      id_sr_DirectionGrp, 0, "" );

  DlgAddCtrl(dlg, Dlg_RadioButton, "&Forward",
      Dlg_PosOffset + 1, Dlg_PosOffset + (Dlg_Units | 10), 0, 0,
      id_sr_ForwardRB, 0, '');
  DlgSetInt( Dlg, id_sr_ForwardRB, !Bs );

	if ( Search_Mode ) {
		Help_Str = "     ";
	}
	else {
    Help_Str = "";
	}
  DlgAddCtrl(dlg, Dlg_RadioButton,'&Backward',
    	Dlg_PosOffset + 13, Dlg_PosOffset, 0, 0,
      id_sr_BackwardRB, 0, '');
  DlgSetInt(dlg, id_sr_BackwardRB, bs);

  DlgAddCtrl(dlg, Dlg_GroupBox, 'Options',
      1, Dlg_PosOffset + (Dlg_Units | 44), 30,
			Dlg_Units | ((Dlg_Units_Per_Line * 5) + 1),
      id_sr_OptionGrp, 0, '');

  DlgAddCtrl(dlg, Dlg_CheckBox,'Case sensiti&ve',
      Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0,
      id_sr_CaseCB, 0, '');
  DlgSetInt(dlg, id_sr_CaseCB, ic);

  DlgAddCtrl(dlg, Dlg_CheckBox,'&Global search',
      Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0,
      id_sr_GlobalSrchCB, 0, '');
  DlgSetInt(dlg, id_sr_GlobalSrchCB, gs);

  DlgAddCtrl(dlg, Dlg_CheckBox,'Restrict to &marked block',
      Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0,
      id_sr_BlockSrchCB, 0, '');
  DlgSetInt(dlg, id_sr_BlockSrchCB, rb);
	DlgGetXY( Dlg, id_sr_BlockSrchCB, Jx, YPos );

  DlgAddCtrl(dlg, Dlg_CheckBox,'Search all &windows',
      Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0,
      id_sr_AllWindowsCB, 0, '');
  DlgSetInt(dlg, id_sr_AllWindowsCB, aw);

	if ( Search_Mode ) {
    DlgAddCtrl(dlg, Dlg_GroupBox, "Mode",
      	CtrlCol2, Dlg_Units | 54,
        30, 3,
        id_sr_ModeGrp, 0, '');

    DlgAddCtrl( Dlg, Dlg_CheckBox, "Pr&ompted replace",
        Dlg_PosOffset + 1, Dlg_PosOffset + 1,
				0, 0,
        id_sr_PromptSrchCB, 0, "" );
    DlgSetInt( Dlg, id_sr_PromptSrchCB, Ps );

    DlgAddCtrl( Dlg, Dlg_CheckBox, "E&xit when nothing found",
        Dlg_PosOffset + 0, Dlg_PosOffset + 1,
				0, 0,
        id_sr_ExitNoFindCB, 0, "" );
    DlgSetInt( Dlg, id_sr_ExitNoFindCB, ExitNoFind );

    DlgAddCtrl(dlg, Dlg_GroupBox, 'Leave cursor at',
      	CtrlCol2, dlg_PosOffset + 1,
				30, 3,
        id_sr_CursorPosGrp, 0, '');

    DlgAddCtrl(dlg, Dlg_RadioButton,'E&nd of replace string',
        Dlg_PosOffset + 1, Dlg_PosOffset + 1, 0, 0,
        id_sr_PosEndStrCB, 0, '');
    DlgSetInt(dlg, id_sr_PosEndStrCB, cs == 0);

    DlgAddCtrl(dlg, Dlg_RadioButton,'S&tart of replace string',
        Dlg_PosOffset, Dlg_PosOffset + 1, 0, 0,
        id_sr_PosBegStrCB, 0, '');
    DlgSetInt(dlg, id_sr_PosBegStrCB, cs);

    DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SR_101",
        1, 1, 0,0, 1000, 0, "" );

    if ( !Global_Int('~SR_MODAL') ) {
      DlgAddCtrl(dlg, Dlg_BitmapBtn, 'BT_WN_113_S',
        	1, Dlg_PosOffset + (Dlg_Units | 13), 2, 0,
          id_sr_ShrinkBtn, 0, '');
    }
  }
	else {
    DlgAddCtrl( Dlg, Dlg_GroupBox, "Mode",
      	CtrlCol2, Dlg_Units | 54,
        30, 4,
        id_sr_ModeGrp, 0, "" );

    DlgAddCtrl( Dlg, Dlg_CheckBox,"Pr&ompted search",
      	Dlg_PosOffset + 1, dlg_PosOffset + 1,
				0, 0,
        id_sr_PromptSrchCB, 0, '');
    DlgSetInt( Dlg, id_sr_PromptSrchCB, Ps );

    DlgAddCtrl( Dlg, Dlg_CheckBox, "E&xit when nothing found",
        Dlg_PosOffset + 0, Dlg_PosOffset + 1,
				0, 0,
        id_sr_ExitNoFindCB, 0, "" );
    DlgSetInt( Dlg, id_sr_ExitNoFindCB, ExitNoFind );

    DlgAddCtrl(dlg, Dlg_CheckBox,'Mar&k found text',
        Dlg_PosOffset + 0, Dlg_PosOffset + 1,
        0, 0,
        id_sr_MarkFndTxtCB, 0, '');
    DlgSetInt(dlg, id_sr_MarkFndTxtCB, MarkFoundText != 0);

		if ( !SwOnly ) {

    	int Df = 0;

    	if ( Global_Str( "!SR_LST_WN" ) == "" ) {
      	Df = Dlgf_Disable;
    	}
    	DlgAddCtrl( Dlg, dlg_PushButton, "List &previous occurrences",
        	CtrlCol2 - 1, Dlg_Units | ( YPos - dlg_Units_QLine ),
					32, (Dlg_Units | 15),
        	id_sr_ListPrevBtn, Df, "/R=12" );
		}
    DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_SR_100",
    		1, 1, 0,0, 1000, 0, "" );
    if ( !Global_Int('~SR_MODAL') ) {
      DlgAddCtrl(dlg, Dlg_BitmapBtn, 'BT_WN_113_S',
        	1, Dlg_PosOffset + (Dlg_Units | 13), 2, 0,
          id_sr_ShrinkBtn, 0, '');
    }
	}
	if ( SwOnly ) {
		BtnStr = "OK";
	}
	else {
		BtnStr = "&Search";
	}
  DlgAddCtrl(dlg, Dlg_PushButton, BtnStr,
  		1, 13,
			Dlg_StanBtnWidth, 0,
      id_sr_SearchBtn, DLGF_DefButton, "/R=1" );
	Jx = dlg_StanBtnWidth + 1;

	if ( !SwOnly ) {
  	if ( !Global_Int( "~SR_MODAL" ) && Search_Mode ) {
    	DlgAddCtrl(dlg, Dlg_PushButton, '&Replace',
        	Dlg_PosOffset + Dlg_StanBtnWidth + 1,
					Dlg_PosOffset, Dlg_StanBtnWidth, 0,
        	id_sr_ReplaceBtn, 0, "" );
		}
    DlgAddCtrl(dlg, Dlg_PushButton, '&All',
      	Dlg_PosOffset + Dlg_StanBtnWidth + 1, Dlg_PosOffset,
				8, 0,
        id_sr_AllBtn, 0, "/R=3" );
		Jx = 9;
	}
  DlgAddCtrl( Dlg, Dlg_PushButton, "Cancel",
  		Dlg_PosOffset + Jx, Dlg_PosOffset,
			Dlg_StanBtnWidth, 0,
      id_sr_CancelBtn, 0, "/R=0" );

  DlgAddCtrl( Dlg, Dlg_PushButton, "Help",
      50, Dlg_PosOffset,
			Dlg_StanBtnWidth + 4, 0,
      id_sr_HelpBtn, 0, "/R=2");

	if ( !SwOnly ) {
  	DlgAddCtrl(dlg, Dlg_PushButton, 'Reg Ex &Help',
      	Dlg_PosOffset, Dlg_NegOffset + dlg_Units_5QLines,
				Dlg_StanBtnWidth + 4, 0,
      	id_sr_RegExpHlpBtn, 0, '/M=MEWHELP^REGEXPHELP');

  	DlgAddCtrl( Dlg, dlg_PushButton, "Al&ias",
      	CtrlCol2 - 1, dlg_PosOffset + 0,
      	dlg_StanBtnWidth, 0,
      	id_sr_AliasBtn, 0, "" );
	}
  if ( !Global_Int('~SR_MODAL') ) {
		DlgGetXY( Dlg, id_sr_CancelBtn, Jx, DefCtrl );
		DlgAddCtrl( Dlg, dlg_PushButton, "",
				dlg_Units | dlg_Units_Per_Col * 11 + Jx, Dlg_Units | 30,
				6, 0,
				id_sr_DirSwitchBtn, 0, "" );

		if ( g_RepSearch ) {
			if ( g_SearchMode ) {
				DefCtrl = id_sr_ReplaceBtn;
			}
			else {
				DefCtrl = id_sr_SearchBtn;
			}
		}
		else {
			DefCtrl = id_sr_SearchStr;
		}
    Return_Int = DlgExecute( Dlg, DefCtrl, Title_Str,
				Parse_Str('/H=', Mparm_Str), "/HOOK=SRPROC/RPOS=" + _g_SRDlgPos,
				DLG_MODELESS | DLG_NOPARDISABLE );
  }
	else {
		if ( SwOnly ) {
			DefCtrl = id_sr_SearchBtn;
		}
  	Return_Int = DlgExecute( Dlg, DefCtrl, Title_Str,
				Parse_Str( "/H=", MParm_Str ), "/RPOS=" + _g_SRDlgPos, 0 );
    if ( !SwOnly || Return_Int ) {
    	Help_Str = "";
      if ( DlgGetInt( Dlg, id_sr_CaseCB ) == 0 ) {
        Help_Str += "I";
      }
      if ( DlgGetInt( Dlg, id_sr_RegExpRB ) == 0 ) {
        Help_Str += "X";
      }
      if ( DlgGetInt(dlg, id_sr_BackwardRB) != 0 ) {
        Help_Str += "B";
      }
      if ( DlgGetInt( Dlg, id_sr_GlobalSrchCB ) != 0 ) {
        Help_Str += "G";
      }
      if ( DlgGetInt(dlg, id_sr_BlockSrchCB) != 0) {
        Help_Str += "R";
      }
      if ( DlgGetInt(dlg, id_sr_AllWindowsCB) != 0) {
        Help_Str += "A";
      }
      if ( DlgGetInt(dlg, id_sr_WordSrchRB) != 0) {
        Help_Str += "W";
      }
      if ( DlgGetInt( Dlg, id_sr_PromptSrchCB ) != 0 ) {
				Help_Str += 'P';
      }
      if ( DlgGetInt( Dlg, id_sr_ExitNoFindCB ) != 0 ) {
        Help_Str += 'K';
      }
			if ( Return_Int == 3 ) {
				if ( Search_Mode ) {
					Help_Str += "N";
				}
				else {
					Help_Str += "L";
				}
			}
      if ( DlgGetInt( Dlg, id_sr_MarkFndTxtCB ) ) {
        Help_Str += "M";
      }
      if ( Search_Mode  ) {
        if ( DlgGetInt( Dlg, id_sr_PosBegStrCB ) != 0 ) {
          Help_Str += "C";
        }
        if ( !SwOnly ) {
          Set_Global_Str( Parse_Str( "/RPG=", MParm_Str ),
					 	DlgGetStr( Dlg, id_sr_ReplaceStr ) );
        }
      }
      Set_Global_Str( Parse_Str( "/SWG=", Mparm_Str ), Help_Str );
      if ( !SwOnly ) {
//          Set_Global_Str(parse_str('/SRG=', mparm_str), DlgGetStr(dlg, 201));
          Set_Global_Str( Parse_Str( "/SRG=", MParm_Str ),
					 	DlgGetStr( Dlg, id_sr_SearchStr ) );
      }
      if(  return_int == 11  ) {
        set_global_int('SEARCH_INTR_STYLE', 1 );
        goto again;
      }
    }
   DlgKill( Dlg );
  }
  Persistent_Blocks = Tpb;
}

macro Search_List trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SEARCH_LIST

Description: Brings up the list of search occurrences created by S_AND_R

							 (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/

	int SavRefresh 			= Refresh;
	int Active_Window 	= Window_Id,
			t_reg_exp_stat 	= reg_exp_stat,
			t_tab_expand 		= tab_expand,
			t,
			Line_Number,
			srlist_font,
			win_num, win_id;
	int FoundCount = 0;
	int WinCount = 0;

	str F_Name[128] = "";

	tab_expand 		= True;
	reg_exp_stat 	= True;

	F_Name = TempFileName( "SRLST.TMP" );

	Refresh = False;
	Error_Level = 0;
/* *** test code ***
	if ( !Switch_File( F_Name ) ) {
		Switch_Window( Window_Count );
		Create_Window;
		Load_File( F_Name );
		Window_Attr |= 0x81;
	}
	if ( Error_Level == 0 ) {
*/
	if ( Switch_File( F_Name ) ) {
		win_id 	= window_id;
		win_num = cur_window;
		mark_pos;

    tof;
    while (!at_eof) {
			// put font data into list
			/*
			@=C:\MEWIN\SRC\SEARCH.S#=1OCC=18WIN_ID=17
			L=1185T=macro SRCH_ACROSS_LINE TRANS2 {
			L=1187T=                      MULTI-EDIT MACRO
			*/
      put_line(convsl(get_line));    // duplicate slashes to the file is correct
      if ( XPos( "@=", Get_Line, 1 ) != 1 ) {
        put_line("L=/TX=" + parse_str("L=", get_line)
                  + "/FT=" + str(srlist_font)
                  + "/FC=" + str(GetSysColor(Color_WindowText))
                  + "/BC=" + str(GetSysColor(Color_Window))
                  + "T=/TX=" + parse_str("T=", get_line)
                  + "/FT=" + str(srlist_font)
                  + "/FC=" + str(GetSysColor(Color_WindowText))
                  + "/BC=" + str(GetSysColor(Color_Window))
            );
      }
			else {
				FoundCount += Parse_Int( "\x7F" + "OCC=", Get_Line( ) );
				WinCount = Parse_Int( "\x7F" + "#=", Get_Line( ) );
				if ( switch_file (parse_str ("\x7F" + "@=", Get_Line( ) ) ) ) {
					Get_Window_Font_Handle (cur_window, srlist_font, t, t, t);
					switch_window (win_num);
				}
				else {
					Get_Window_Font_Handle (-Global_Int ("Oem_Mode"), srlist_font, t, t, t);
				}
			}
			down;
    }
		Make_Message( "String found " + Str( FoundCount ) + " times in " +
				Str( WinCount ) + " files." );
		goto_mark;

    int dlg;
		DlgCreate( dlg );
    DlgAddCtrl( dlg, DLG_ListBox, "L=/W=9/T=5T=/W=255/T=5",
			1, 1, 85, 15,
			1000, DLGF_LB_HSCROLL, "/HSCROLL=255/WIN=" + str(win_num));
		DlgAddCtrl( dlg, DLG_PushButton, 	"OK",
			1, 17, DLG_StanBtnWidth, 0,
			101, DLGF_DefButton, "/R=1" );
		DlgAddCtrl( dlg, DLG_PushButton, 	"Cancel",
			DLG_StanBtnWidth + 2, DLG_PosOffset, DLG_StanBtnWidth, 0,
			102, 0, "/R=0" );
		DlgAddCtrl( dlg, DLG_PushButton, 	"&Help",
			62, DLG_PosOffset, DLG_StanBtnWidth, 0,
			103, 0, "/R=2" );

		return_int = DlgExecute( dlg, 1000, "Found List", FOUNDLIST_HELPLINK, "", 0 );
		DlgKill( dlg );

		window_Attr = $81;

    mark_pos;
    tof;
    while (!at_eof) { // strip font data from list
      if (xpos("@=", get_line, 1) != 1) {
        put_line( "L=" + parse_str("/TX=", parse_str("L=", get_line))
                + "T=" + parse_str("/TX=", parse_str("T=", get_line))
                );
      }
			down;
    }
    goto_mark;

		if (return_Int) {
			Goto_Col(1);
			line_number = parse_int("L=", get_line);
			if (line_number) {
				mark_pos;
				if (search_bwd("%@@=",0)) {
					F_Name = Parse_Str( "\x7F" + "@=", Get_Line( ) );
					Goto_Mark;
					if ( Switch_File( F_Name ) ) {
						// if not there, look for it by name
						Goto_Line( Line_Number );
						goto Found;
					}
				}
				else {
					Goto_Mark;
				}
				Make_Message("Window for search list not found.");
			}
		}
	}
	else {
		Make_Message( "No search list found." );
		Error_Level = 0;
	}
	Switch_Win_Id( Active_Window );

Found:
	Rm( "Select_Window /BM=1/VIS=1" );
	Refresh = SavRefresh;
	Redraw;      // jkp to fix redraw when calling directly.
	Reg_Exp_Stat = T_Reg_Exp_Stat;
	Tab_Expand = T_Tab_Expand;

}

macro Srch_Across_Line trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: SRCH_ACROSS_LINE

Description: Performs Word/Phrase search

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str
					Current_Word[80],
					T_Delimits[40] = Word_Delimits,
					Punctuation[5] = ',.?;:'
					;
	int
					Restrict_Count = Parse_Int('/R=',MParm_Str),
					Back_Search = Parse_Int('/B=',MParm_Str),
					Word_Index,
					Word_Count = 0,
					Check_Col,
					ret_val = 0
					;

	Reg_Exp_Stat = False;
//  Word_Delimits = ' |9|255';
	if (Global_Str('@PHRASE_SRCH_DELIM') != '') {
		Word_Delimits = Global_Str('@PHRASE_SRCH_DELIM');
	}

	if (Ignore_Case) {
		Return_Str = Caps(Return_Str);
	}
	Ret_Val = 0;

	Rm( "Parse_Phrase /M=0" );
	Word_Count = Return_Int;

	if ( Word_Count < 1 ) {
		goto Exit;
	}


Search_Again:
	Word_Index = 1;

	if (Back_Search) {
		if ((c_line == 1) && (c_col == 1)) {
// if we are at the top of the file already, get out!
			goto exit;
		}
		if (Search_Bwd(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')),Restrict_Count) == 0) {
			Goto EXIT;
		}
	} else {
		if (at_eof) {
// if we are at the end of the file already, get out!
			goto exit;
		}
		if (Search_Fwd(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')),Restrict_Count) == 0) {
			Goto EXIT;
		}
	}
	Set_Global_Str('@LINE_SEARCH_STR1','/S=' + Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR1')) + '/L=' + Str(C_Line) + '/C=' + Str(C_Col));

/* Check to make sure that we found a whole word */
	Mark_Pos;
	if ((C_Col > 1) && (XPos(Cur_Char,Punctuation,1) == 0)){
		Left;
// For the first word, we'll acccept default word delimiters as leading chars
		if (Xpos(Cur_Char,T_Delimits,1) == 0) {
			Pop_Mark;
      if ( !back_search )
				Word_Right;
			Goto SEARCH_AGAIN;
		}
		Right;
	}
	if (word_count > 1) {
		Goto_Col(C_Col + Length(Found_Str));
		if ((At_Eol == 0) & (Xpos(Cur_Char,Word_Delimits,1) == 0)) {
			Pop_Mark;
			Goto SEARCH_AGAIN;
		}
		Goto_Mark;
		Mark_Pos;
		Word_Right;
		if (At_Eol == 0) {
			Word_Left;
		}
	}
CHECK_NEXT_WORD:
	if (Word_Index == Word_Count) {
/* If we found all the words, then...  */
		if (Word_Count == 1) {
			Goto_Col(C_Col + Length(Found_Str));
			if ((At_Eol == 0) & (Xpos(Cur_Char,T_Delimits,1) == 0)) {
				if (back_search) {
					goto_mark;
					left;
				} else {
					Pop_Mark;
				}
				Goto SEARCH_AGAIN;
			}
		}
		Set_Global_Str('@LINE_SEARCH_POS','/L=' + Str(C_Line) + '/C=' + Str(C_Col) + '/#=' + Str(Word_Count));
		Goto_Mark;
		Ret_Val = 1;
		Goto EXIT;
	}
	++Word_Index;
EOL_DELIMITS:
	Word_Right;
	if (((Xpos(Cur_Char,Word_Delimits,1) | (At_Eol == True)) > 0) & (At_Eof == False)) {
/* We would only get here if there are word delimiters at the end of a line */
		Goto EOL_DELIMITS;
	}
	Check_Col = C_Col;
	if (Word_Index == Word_Count) {
/* On the last word, allow trailing chars according to users word delimits */
		Current_Word = Get_Word(T_Delimits);
	} else {
		Current_Word = Get_Word(Word_Delimits);
	}
	if (Ignore_Case) {
		Current_Word = Caps(Current_Word);
	}
	if (Current_Word != Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR' + Str(Word_Index)))) {
		Goto_Mark;
		if (Back_Search) {
			Left;
		} else {
			Right;
		}
		Goto SEARCH_AGAIN;
	}
	Set_Global_Str('@LINE_SEARCH_STR' + Str(Word_Index),'/S=' + Current_Word + '/L=' + Str(C_Line) + '/C=' + Str(Check_Col));

	Goto CHECK_NEXT_WORD;

EXIT:
	Return_Int = Ret_Val;
	Word_Delimits = T_Delimits;
}

macro Parse_Phrase trans2
{
	str Search_Str = Return_Str,
			Current_Word[ 80 ],
			GStr[ 18 ];

	int Copy_Index = 1,
			Word_Count = 0;

	char Ch;

	if ( Parse_Int( "/M=", MParm_Str ) ) {
		GStr = "@Line_Replace_Str";
	}
	else {
		GStr = "@Line_Search_Str";
	}
	do {
		Current_Word = '';
		while ( Copy_Index <= Svl( Search_Str ) ) {
			Ch = Str_Char( Search_Str, Copy_Index );
			++Copy_Index;
			if ( XPos( Ch, Word_Delimits, 1 ) != 0 ) {
				break;
			}
			Current_Word += Ch;
		}
		if ( Svl( Current_Word ) != 0 ) {
			++Word_Count;
			Set_Global_Str( GStr + Str( Word_Count ), "/S=" + Current_Word );
		}
		// Find the beginning next word in Search_Str for next time
		while ( ( Copy_Index < Svl( Search_Str ) ) &&
				( XPos( Str_Char( Search_Str, Copy_Index ), Word_Delimits, 1 ) > 0 ) ) {
			++Copy_Index;
		}
	} while ( Copy_Index <= Svl( Search_Str ) );
	Return_Int = Word_Count;

}  // Parse_Phrase

macro REPL_ACROSS_LINE TRANS2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: REPL_ACROSS_LINE

Description: Performs Word/Phrase replace

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
	str T_Delimits[40] = Word_Delimits;

	int Search_Count = Parse_Int('/#=',Global_Str('@LINE_SEARCH_POS')),
			Done_Count,
			Replace_Count,
			T_line = C_Line,
			T_Row = C_Row
			;

	refresh = false;
	Word_Delimits = ' |9|255';
	if (Global_Str('@PHRASE_SRCH_DELIM') != '') {
		Word_Delimits = Global_Str('@PHRASE_SRCH_DELIM');
	}
	Rm( "Parse_Phrase /M=1" );
	Replace_Count = Return_Int;

	Mark_Pos;
/* Place markers at the beginning of every found word, then at the end of the
found phrase */
	Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_POS')));
	Goto_Col(Parse_Int('/C=',Global_Str('@LINE_SEARCH_POS')));
	Insert_Mode = True;
	Text('|0');

	for (Done_count = 1;done_count <= search_count;done_count++) {
		Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Goto_Col( Parse_Int('/C=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Insert_Mode = False;
		Text('|0');
	}
	Goto_Mark;
	Insert_Mode = True;

	for (Done_count = 1;done_count <= search_count;done_count++) {
		Goto_Line(Parse_Int('/L=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count))));
		Goto_Col(1);
		search_Fwd('|0',1);
		Del_Chars(Length(Parse_Str('/S=',Global_Str('@LINE_SEARCH_STR' + Str(Done_Count)))));
		if (Done_Count <= Replace_Count) {
			Text(Parse_Str('/S=',Global_Str('@LINE_REPLACE_STR' + Str(Done_Count))));
		}
	}

	while (search_count < Replace_Count) {
		++search_Count;
		Text(" " + Parse_Str('/S=',Global_Str('@LINE_REPLACE_STR' + Str(Search_Count))));
	}

/* Get rid of end of found phrase mark */
	if (Search_Fwd('|0',1)) {
		Del_Char;
	}

/* Fix it so the display does not scroll unless neccessary */
	t_row = t_row + (c_line - t_line);
	t_line = c_line;
	while (c_row < t_row) {
		down;
	}
	goto_line(t_line);
	refresh = true;

	for (replace_count;replace_count > 0;replace_count--)
		Set_Global_Str('@LINE_REPLACE_STR' + Str(Replace_Count),"");

	Word_Delimits = T_Delimits;
}

macro Search trans2  {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	SEARCH

Description:	Calls S_and_R in search only mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  if ( g_hSRDialog != 0 ) {
		SetActiveWindow( g_hSRDialog );
	}
	else {
		g_SearchMode =  False;
		g_RepSearch = False;
  	if ( Global_Int( "~SR_MODAL" ) != 0 ) {
    	Rm( "S_AND_R " + Mparm_Str );
  	}
		else {
    	Rm( "SrchIntr /H=" + SEARCH_HELPLINK + "/SRG=Search_Str" );
  	}
	}
}  // Search

macro S_Repl trans2  {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	S_REPL

Description:	Calls S_and_R in search and replace mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

  if ( g_hSRDialog != 0 ) {
		SetActiveWindow( g_hSRDialog );
	}
	else {
		g_SearchMode = True;
		g_RepSearch = False;
  	if ( Global_Int( "~SR_MODAL" ) != 0 ) {
    	Rm( "S_And_R " + MParm_Str );
  	}
		else {
    	Rm( "SrchIntr /M=1/H=" + SRCHREP_HELPLINK + "/SRG=Search_Str" +
					"/RPG=Replace_Str" );
  	}
	}
}  // S_Repl

macro RepSrch trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name:	S_REPL

Description:	Calls S_and_R in repeat mode.

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/

	int Jx;
	int TPersistent_Blocks = Persistent_Blocks;
  int curWindow = Window_ID;
	int tr = refresh;

	Persistent_Blocks = True;
	Push_Undo;
	Mark_Pos;
	if ( g_SearchMode ) {
		Jx = Xpos( 'B', Caps( g_ReplSwitches ), 1 );
	}
	else {
		Jx = XPos( 'B', Caps( g_Switches ), 1 );
	}
	if ( Jx ) {
		Left;
	}
	else {
		Right;
		while ( !At_Eol && ( Cur_Char == "\xFF" ) ) {
			Right;
		}
	}
	if ( g_SearchStr != "" ) {
		g_RepSearch = True;
	}
  if ( !Global_Int( "~SR_MODAL" ) ) {
//    if ( g_hSRDialog == 0 ) {
      SReturn_Int = 555;
//    }
  }
	Rm( "S_And_R " + MParm_Str );

  int newWindow = Window_ID;
	if( newWindow == curWindow )
	{
  	if ( g_FoundCount == 0 ) {   // changed to not look at return_int
			Goto_Mark;
			Make_Message( "No more occurrences." );
			Beep;
		}
		else {
			Pop_Mark;
			if ( !Global_Int( "~SR_Modal" ) ) {
				g_RepSearch = True; // ldh
			}
		}
	}
  else
	{
		refresh = false;
    Switch_Win_ID(curWindow);
    Pop_Mark;
    if ( !Global_Int( "~SR_Modal" ) ) {
      g_RepSearch = True;
    }
    Switch_Win_ID(NewWindow);
	}
	Persistent_Blocks = TPersistent_Blocks;
	Pop_Undo;
	refresh = tr;

}  // RepSrch

#define DIR_ID    3001
#define FILE_ID   3002
#define ABORT_ID  3003
#define SRCH_ID   3004

int FileSrch(
			str &SearchStr,
			str PPath[ 255 ],
			str Mask[ 13 ],
			str &Root,
      int Search_Dirs,
			int Sm,
			int Flags,
			int Sub
) trans2
/*******************************************************************************
																MULTI-EDIT MACRO

Name:  FileSrch

Description:  Called by FS to perform the actual multi-file search.

Parameters:		Return_Str = Search_Str
							path    Path(s) to search
							search_dirs        1 = search subdirectories.
							root         Root path to search if no dir is specified in the
													 paths
							sm           Search files in Memory.  If a file is already loaded,
													 then search there instead.
							flags     Search flags

							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
{
  str Path[ 255 ];
	str TStr[ Max_Line_Length ];
	str FSInfo = g_FSInfo;
	str TStr1;

	int doserror,
			t_undo_stat,
			found_win = window_id,
			found_win_num = cur_window,
			jx,
			pp;
	int hDlg,
			h_list;
	int FileOnly 		 = SearchStr == "";
  int Find_Handle  = 0;
	int SearchWin 	 = g_SearchWin;
	int SavTabExpand = Tab_Expand;
	int FndLn;
	int InMemory		 = 0;


	struct tmsg msg;
  struct WIN32_FIND_DATA new_fd;
  struct DOS_FIND_DATA old_fd;

	hDlg = GetActiveWindow ();
	h_list = GetDlgItem(hDlg, 3100);

//DebugLog( 1, "FileSrch", "Sm=%d F=%d Sub=%d R=%s SS=%s P=%s", Sm, Flags, Sub, Root, SearchStr, PPath );
	if ( Sub == 0 ) {
		T_Undo_Stat = Undo_Stat;
		Refresh = False;
		Undo_Stat = False;
		g_TotalFnd = 0;
		g_TotalFiles = 0;
		if ( FileOnly ) {
			SetDlgItemText( hDlg, srch_Id, Truncate_Path( PPath ) );
		}
		else {
      SetDlgItemText( hDlg, srch_Id, Copy( SearchStr, 1, 100 ) );
			// Save search flags and string
			FSInfo = "\x7F" + "SF=" + Str( Flags ) + "\x7F" + "SS=" + SearchStr;
			g_FSInfo = FSInfo;
			// Translate regular expression aliases
      if ( Flags & _RegExp ) {
        SearchStr = ReTranslate( SearchStr, 1 );
      }
      else if ( Flags & _OldExp ) {
        SearchStr = ReTranslate( SearchStr, 2 );
      }
			// Setup to show all occurrences
			if ( Sm & 2 ) {
				Create_Window;
				SearchWin = Window_Id;
				g_SearchWin = SearchWin;
				Tab_Expand = True;
				Switch_Win_Id( Found_Win );
			}
		}
		call Check_Abort;
		Return_Int = 0;
		Pp = 1;
		while ( True) {
			Path = PPath;
			if ( Pp < Svl( Path ) ) {
				Jx = XPos( ' ', Path, Pp );
				if ( Jx == 0 ) {
					Jx = Svl( Path ) + 1;
				}
				Path = Remove_Space( Copy( Path, Pp, Jx - Pp ) );
				Pp = Jx + 1;
				Mask = Truncate_Path( Path );
				Path = Get_Path( Path );
				if ( Svl( Path ) == 0 ) {
					Path = Root;
				}
				Path = AddTrailingSlash( FExpand( Path ) );
				call Do_Search;
				continue;
			}
			break;
		}
	}
	else {
		Path = PPath;
		call Do_Search;
	}
	goto Exit;


Do_Search:
	Working;
	if ( Search_Dirs ) {
    Find_Handle = FindFirstFile( Path + "*.*", &New_Fd, &Old_Fd );
    if ( Find_Handle ) {
      do {
        call Check_Abort;
        if ( Return_Int == -1 ) {
          goto SearchExit;
        }
				if ( New_Fd.dwFileAttributes & 0x10 ) {
        	if ( ( New_Fd.cFileName != '.' ) && ( New_Fd.cFileName != ".." ) ) {
            if ( FileSrch( SearchStr, Path + New_Fd.cFileName + "\\", Mask,
                Root, 1, Sm, Flags, 1 ) == - 1 ) {
            	goto SearchExit;
          	}
					}
        }
      } while ( FindNextFile( Find_Handle, &New_Fd, &Old_Fd ) );
			call SearchExit;
    }
	}
	SetDlgItemText( hDlg, DIR_ID, Path );

  Find_Handle = FindFirstFile( Path + Mask, &New_Fd, &Old_Fd );
  if ( Find_Handle ) {
		do {
			call Check_Abort;
			if ( Return_Int == -1 ) {
				break;
			}
			Error_Level = 0;
			if ( !FileOnly ) {
      	SetDlgItemText( hDlg, FILE_ID, new_fd.cFileName );
				// Now we are going to do the Search in Memory mode
				if ( Sm & 1 ) {
					if ( Switch_File( Path + New_Fd.cFileName ) ) {
						Jx = 0;
						Mark_Pos;
						Tof;
          	if ( Find_Text( SearchStr, 0, Flags ) ) {
							Jx = C_Line;
						}
						Goto_Mark;
						if ( Jx > 0 ) {
							InMemory = Cur_Window;
							call Put_Success;
							InMemory = 0;
						}
						Switch_Win_Id( Found_Win );
						if ( Error_Level == 1010 ) {
							break;
						}
						continue;
					}
				}
      	Jx = Search_File( Path + New_Fd.cFileName, SearchStr, Flags );
				if ( Jx > 0 ) {
					call Put_Success;
				}
				else {
					if ( Error_Level == 1010 ) {
						break;
					}
				}
			}
			else {
				Jx = 1;
				call Put_Success;
			}
	  } while ( FindNextFile( Find_Handle, &New_Fd, &Old_Fd ) );
	}

SearchExit:
	if ( Find_Handle ) {
  	FindClose( Find_Handle );           // This is IMPORTANT!!!
		Find_Handle = 0;
  }
	ret;


Put_Success:
	Switch_Win_Id( Found_Win );
	Eof;
	if ( C_Col > 1 ) {
		Down;
	}
	if ( SearchWin ) {
		// Setup to search for all strings
		TStr = "\x7F@\xFE=" + Path + New_Fd.cFileName;
	}
	else {
		TStr = "\x7F" + "FN=" + New_Fd.cFileName + "\x7F" + "LN=" + Str( Jx ) +
				"\x7F" + "FP=" + Path;
	}
	if ( C_Line == 1 ) {
		TStr += FSInfo;
	}
	Put_Line( TStr );
	++g_TotalFiles;
	SendMessage( h_List, WM_SETREDRAW, 0, 0 );
	SendMessage( h_List, LB_ADDSTRING, 0, 0 );
	if ( SearchWin ) {
		call AddAllFound;
	}
	SendMessage( h_List, LB_SETCARETINDEX, C_Line - 1, 1 );
	SendMessage( h_List, WM_SETREDRAW, 1, 0 );
	SendMessage( h_List, WM_ML2_REDRAW, 0, 0 );
	Working;
	ret;


AddAllFound:
	FndLn = C_Line;
	if ( Switch_Win_Id( SearchWin ) ) {
		if ( InMemory ) {
			Link_Window( InMemory );
			Tof;
		}
		else {
			Load_File( Path + New_Fd.cFileName );
		}
		if ( !Error_Level ) {
			TStr = "\x7F" + "FP=" + Path + "\x7F" + "FN=" + New_Fd.cFileName +
					"\x7F" + "LN=";
			Goto_Line( Jx );
			do {
				TStr1 = Copy( Get_Line( ), 1, 255 );
				Tabs_To_Spaces( TStr1 );
				Put_Line_To_Win( TStr + Str( C_Line ) + "\x7F" + "T=" + TStr1, ++FndLn,
						Found_Win_Num, False );
				++g_TotalFnd;
				Eol;
				SendMessage( h_List, WM_SETREDRAW, 0, 0 );
				SendMessage( h_List, LB_ADDSTRING, 0, 0 );
			} while ( Find_Text( SearchStr, 0, Flags ) );
		}
		Error_Level = 0;
		Switch_Win_Id( Found_Win );
		TStr = Get_Line( );
		TStr1 = Parse_Str( "\x7F@\xFE=", TStr );
		TStr1 += " -- " + Str( FndLn - C_Line ) + " match(es) found";
		Var_Replace_Str( TStr, "\x7F@\xFE=", TStr1 );
//		TStr = "\x7F" + "OCC=" + Str( FndLn - C_Line ) + TStr;
		Put_Line( TStr );
	}
	ret;

Check_Abort:
	while ( PeekMessage( &Msg, 0, 0, 0, PM_REMOVE ) ) {
		if ( Msg.Message == WM_KEYDOWN ) {
			if ( Msg.WParam == VK_ESCAPE ) {
				Return_Int = -1;
				break;
			}
		}
		if ( Msg.Message == WM_MEW_DLGRETURN ) {
			if ( Msg.WParam == ABORT_ID ) {
				Return_Int = -1;
				break;
			}
		}
		if ( !IsDialogMessage( hDlg, &Msg ) ) {
			Translatemessage( &Msg );
			Dispatchmessage( &Msg );
		}
	}
	ret;


Exit:
	if ( Sub == 0 ) {
		if ( g_TotalFiles ) {
			if ( Switch_Win_Id( Found_Win ) ) {
				Tof;
				TStr = "\x7F" + "#F=" + Str( g_TotalFiles ) +
						"\x7F" + "#S=" + Str( g_TotalFnd ) + Get_Line( );
				Put_Line( TStr );
			}
		}
		if ( Switch_Win_Id( SearchWin ) ) {
			Delete_Window;
			Switch_Win_Id( Found_Win );
			g_SearchWin = 0;
		}
		g_FSInfo = '';
		g_TotalFiles = 0;
		g_TotalFnd = 0;
		Tab_Expand = SavTabExpand;
		Undo_Stat = T_Undo_Stat;
	}
	return ( Return_Int );

}  // FileSrch

macro FS trans2
/*******************************************************************************
																MULTI-EDIT MACRO

Name: fs

Description:  Multi-File search.  Will prompt for a filespec (wild cards are
							allowed), a search string	and search switches, and (using
							MEFIND.EXE) perform a search through all the files matching the
							filespec, and then put up a list of all the matching files.  The
							user may then select one of the files, and the cursor will
							automatically go the the line where the match was found.

Parameters:		/N=		Skips directly to the filename list, using the last
										set of files found by MEFIND.
							/M=  If > 0 will do search and replace


							 (C) Copyright 1991 by American Cybernetics, Inc.
*******************************************************************************/
{
	str Search_Str;
	str Switches_Str[ 10 ];
	str filespec[80], sstr[80];
	str	mode_str[15] = '';
	str	Replace_Str;
	str help_str[30] = MFSRCH_HELPLINK, root[90];
	str  tc[1] , Find_Name[80], bitmap_name[20];

  int  t_win, file_count, str_count, nl, nc, jx, x1, y1, iMenu,
        search_mode = (parse_int('/M=',mparm_str) > 0),
        list_window , already_loaded, leave_files_open;
	int Flags = 0;
	int All_Files = 0;
	int search_dirs, use_reg_exp,
				filespec_item,
				path_item,
				searchdir_item,
				case_item,
				regexp_item,
				memory_item,
				open_item,
				case_sensitive, search_in_mem, result,
			replace_window = 0,
			dialog_start = global_int("!FS_DIALOG_START_" + str(search_mode));

  int bpos, otherpos;
	int FnWidth;
	int TotalFiles = 0;
	int TotalFnd	 = 0;

  if ( UseLongnames ) {								// if longnames use a wider width
    FNWidth = 40;
  }
	else {
    FNWidth = 20;
  }
  if ( btnonright ) {
    otherpos = 1;
    BPos = FnWidth + 48;
  }
	else {
    bpos = 2;
    otherpos = 16;
  }

	int line_height = 0,
			font_height = 0,
			font_width = 0,
			dfont = 0,
			hdlg = 0,
			h_list,
			h_dir,
			h_file,
			habort,
			htemp,
      found_win_num,
			dlg_unit_X,
			dlg_unit_Y,
			button_height,
			y,
			h,
			list_only,
			tempx;        //AJH 21DEC94
	int StrFieldWidth = 38;
	int ShowAllFind = 0;

	struct tmsg msg;


	if (dialog_start < 1) {
		dialog_start = 1;
	}
	t_win = window_id;
	Refresh = False;
	mark_pos;
	if(  (c_line == block_line1) &
			(block_stat > 0) & (block_line1 == block_line2)  ) {
		if(  (block_stat == 1)  ) {
			first_word;
			set_global_str('SEARCH_HISTORY0', get_word('') );
		} else {
			set_global_str('SEARCH_HISTORY0', copy(get_line,block_col1, (block_col2 - block_col1) + 1));
		}
	}
	else {
		Right;
		Word_Left;
		Set_Global_Str( "Search_History0", Get_Word( Word_Delimits ) );
	}
	Goto_Mark;

	Result = 0;

	if ( Search_Mode ) {
		Bitmap_Name = "BT_SR_104";
		Help_Str = MFSRCHREP_HELPLINK;
//		Switches_Str = Caps( Global_Str( "FRSwitches" ) );
		Switches_Str = Caps( g_FRSwitches );
	}
	else {
		Bitmap_Name = "BT_SR_103";
//		Switches_Str = Caps( Global_Str( "FSwitches" ) );
		Switches_Str = Caps( g_FSwitches );
	}

	Use_Reg_Exp = XPos( 'X', Switches_Str, 1 ) == 0;
	Case_Sensitive = XPos( 'I', Switches_Str, 1 ) == 0;

	Search_Dirs = XPos( 'S', Switches_Str, 1 ) != 0;
	Search_In_Mem = XPos( 'F', Switches_Str, 1 ) != 0;
	Leave_Files_Open = XPos( 'O', Switches_Str, 1 ) != 0;
	ShowAllFind = XPos( 'L', Switches_Str, 1 ) != 0;

	if ( Search_Mode ) {
		Switch_Window( Window_Count );
		Create_Window;
		Replace_Window = Window_Id;
		Switch_Win_Id( T_Win );
	}
	// Mod to handle correct placement of .TMP files
	Find_Name = TempFileName( "MEFIND.TMP" );

	if ( XPos( "/N", Caps( MParm_Str ), 1 ) ) {
		if ( !Switch_File( Find_Name ) ) {
			Switch_Window( Window_Count );
			Create_Window;
			Window_Attr = 0x80;
			Load_File( Find_Name );
			if ( Error_Level != 0 ) {
				File_Name = Find_Name;
				Rm( "MEERROR^MessageBox /M=No matched file available." );
				goto Exit;
			}
		}
		goto Load_Find_File;
	}

	Search_Str = g_SearchStr;
	Replace_Str = g_ReplaceStr;

  int Dlg;

  DlgCreate( Dlg );

  DlgAddCtrl( Dlg, DLG_BitmapStatic, bitmap_name,
			1, 1,
			0, 0,
			1000, 0, "" );

  DlgAddCtrl( Dlg, Dlg_Static, "&Search for:",
    	7, 1,
			0, 0,
      101, 0, "" );

  DlgAddCtrl( Dlg, Dlg_Text, Search_Str,
    	Dlg_PosOffset + 14, Dlg_PosOffset,
			StrFieldWidth, 0,
      id_sr_SearchStr, 0, "/ML=256/HISTORY=Search_History" );

	if ( Search_Mode ) {
		Mode_Str = " and Replace";
    DlgAddCtrl( Dlg, Dlg_Static, "&Replace with:",
      	7, Dlg_PosOffset + 1, 0, 0,
        102, 0, "" );

    DlgAddCtrl( Dlg, Dlg_Text, Replace_Str,
        Dlg_PosOffset + 14, Dlg_PosOffset,
				StrFieldWidth, 0,
        id_sr_ReplaceStr, 0, "/ML=256/HISTORY=Search_History" );
		Filespec = Global_Str( "FRFilespec" );
	}
	else {
		Filespec = Global_Str( "FFilespec" );
	}

  DlgAddCtrl( Dlg, Dlg_Static, "&Filespec:",
    	7, Dlg_PosOffset + 1,
			0, 0,
      103, 0, "" );

  DlgAddCtrl( Dlg, Dlg_Text, Filespec,
      Dlg_PosOffset + 14, Dlg_PosOffset,
			StrFieldWidth, 0,
      203, 0, "/ML=80/HISTORY=FILESPEC_HISTORY" );

//  Nl = 5;
  Nl = 6;
  DlgAddCtrl( Dlg, Dlg_Static, "Starting &path:",
    	7, Dlg_PosOffset + 1,
			0, 0,
      104, 0, "" );

  if ( Search_Mode ) {
    DlgAddCtrl( Dlg, Dlg_Text, Global_Str( "FSearch_Repl_Path" ),
      	Dlg_PosOffset + 14, Dlg_PosOffset,
				StrFieldWidth, 0,
        204, 0, "/ML=254/HISTORY=FSPATH_HISTORY" );
//    ++Nl;
	}
	else {
    DlgAddCtrl( Dlg, Dlg_Text, Global_Str( "FSearch_Path" ),
    		Dlg_PosOffset + 14, Dlg_PosOffset,
				StrFieldWidth, 0,
        204, 0, "/ML=254/HISTORY=FSPath_History" );
	}

	DlgAddCtrl( Dlg, dlg_DirButton, "...",
			dlg_PosOffset + StrFieldWidth + 1, dlg_PosOffset + 0,
			4, 0,
			2200, 0, "/SID=204" );

  DlgAddCtrl( Dlg, Dlg_Groupbox, "Options",
    	1, Dlg_PosOffset + 1,
			27, Nl,
      301, 0, "" );

  DlgAddCtrl( Dlg, Dlg_Checkbox, "Search sub-&directories",
			Dlg_PosOffset + 1, Dlg_PosOffset + 1,
			0, 0,
      401, 0, "" );
  DlgSetInt( Dlg, 401, Search_Dirs );

  DlgAddCtrl( Dlg, Dlg_Checkbox, "&Case sensitive",
			Dlg_PosOffset, Dlg_PosOffset + 1,
			0, 0,
      402, 0, "" );
  DlgSetInt( Dlg, 402, Case_Sensitive);

  DlgAddCtrl( Dlg, Dlg_Checkbox, "Regular &expressions",
    	Dlg_PosOffset, Dlg_PosOffset + 1,
			0, 0,
      403, 0, "" );
  DlgSetInt( Dlg, 403, Use_Reg_Exp);

  DlgAddCtrl( Dlg, Dlg_Checkbox, "Search files in &memory",
      Dlg_PosOffset, Dlg_PosOffset + 1,
			0, 0,
      404, 0, '');
  DlgSetInt( Dlg, 404, Search_In_Mem);

	if ( Search_Mode ) {
    DlgAddCtrl( Dlg, Dlg_Checkbox, "&Leave all files open",
      	Dlg_PosOffset, Dlg_PosOffset + 1,
				0, 0,
        405, 0, '');
    DlgSetInt( Dlg, 405, Leave_Files_Open );
	}
	else {
		DlgAddCtrl( Dlg, dlg_Checkbox, "&List all occurences",
				dlg_PosOffset, dlg_PosOffset + 1,
				0, 0,
				406, 0, '' );
		DlgSetInt( Dlg, 406, ShowAllFind );
	}

  DlgAddCtrl( Dlg, Dlg_PushButton, "OK",
    	1, Dlg_PosOffset | dlg_Units_5QLines,
			Dlg_StanBtnWidth, 0,
      id_sr_SearchBtn, DLGF_DefButton, "/R=1" );

  DlgAddCtrl( Dlg, Dlg_PushButton, "Cancel",
    	Dlg_PosOffset + Dlg_StanBtnWidth + 2,
			Dlg_PosOffset, Dlg_StanBtnWidth, 0,
      id_sr_CancelBtn, 0, "/R=0" );

  DlgAddCtrl( Dlg, Dlg_PushButton, "Help",
			Dlg_PosOffset + 36, Dlg_PosOffset,
			Dlg_StanBtnWidth + 5, 0,
      id_sr_HelpBtn, 0, "/R=2" );

  DlgAddCtrl(dlg, Dlg_PushButton, "Reg Exp &Help",
      Dlg_PosOffset, Dlg_NegOffset + ( Dlg_Units | 15 ),
			Dlg_StanBtnWidth + 5, 0,
      id_sr_RegExpHlpBtn, 0, "/M=MEWHELP^RegExpHelp" );

  DlgAddCtrl( Dlg, dlg_PushButton, "Al&ias",
      dlg_NegOffset + dlg_StanBtnWidth + 2 , dlg_PosOffset + 0,
      dlg_StanBtnWidth, 0,
      id_sr_AliasBtn, 0,
      "/M=SearchGetAlias /ID=" + Str( id_sr_SearchStr ) );

  Return_Int = DlgExecute( Dlg, 200 + Dialog_Start, "Multiple File Search" +
      Mode_Str, Help_Str,
      "/INITMAC=_SrchInit //ID=" + Str( id_sr_SearchStr ), 0 );

	Set_Global_Str( "Search_History0", "" );
  Filespec = DlgGetStr( Dlg, 203 );
  Search_Str = DlgGetStr( Dlg, id_sr_SearchStr );
	if ( Search_Mode ) {
    Replace_Str = DlgGetStr( Dlg, id_sr_ReplaceStr );
		g_ReplaceStr = Replace_Str;
		Set_Global_Str( "FRFileSpec", Filespec );
	}
	else {
		Set_Global_Str( "FFileSpec", Filespec );
	}
	Set_Global_Str( "FLast_Choice", "" );
	g_SearchStr = Search_Str;
	Set_Global_Str( "FSearch_str", Search_Str );

  Search_Dirs = DlgGetInt( Dlg, 401 );
  Case_Sensitive = DlgGetInt( Dlg, 402 );
  Use_Reg_Exp = DlgGetInt( Dlg, 403 );
  Search_In_Mem = DlgGetInt( Dlg, 404 );
	if ( Search_Mode ) {
    Leave_Files_Open = DlgGetInt( Dlg, 405 );
    Set_Global_Str( "FSearch_Repl_Path", DlgGetStr( Dlg, 204 ) );
	}
	else {
		ShowAllFind = DlgGetInt( Dlg, 406 ) * 2;
    Set_Global_Str( "Fsearch_Path", DlgGetStr( Dlg, 204 ) );
	}
  DlgKill( Dlg );

  Switches_Str = '';
	Reg_Exp_Stat = Use_Reg_Exp;
	Ignore_Case = ( Case_Sensitive == 0 );
	Flags = 0;

  if ( Reg_Exp_Stat ) {
    if ( Reg_Exp_Style ) {
      Flags |= _RegExp;
    }
    else {
      Flags |= _OldExp;
    }
	}
  else {
    Switches_Str = 'X';
  }

  if ( Ignore_Case ) {
    Switches_Str += 'I';
	}
  else {
    Flags |= _CaseSensitive;
  }

	if ( Search_Dirs ) {
		Switches_Str += 'S';
	}
	if ( Search_In_Mem ) {
		Switches_Str += 'F';
	}
	if ( Leave_Files_Open ) {
		Switches_Str += 'O';
	}
	if ( ShowAllFind ) {
		Switches_Str += 'L';
	}

	if ( Return_Int ) {
		Working;
		Y1 = 5;

		if ( Switch_File( Find_Name ) ) {
			Erase_Window;
    }
    else {
			Switch_Window( Window_Count );
			Create_Window;
			Window_Attr = 0x80;
		}
		File_Name = Find_Name;
    if ( Search_Mode ) {
			Root = Global_Str( "FSearch_Repl_Path" );
    }
    else {
			Root = Global_Str( "FSearch_Path" );
		}
		Set_Global_Int( "@FSearch_Aborted", 0 );

		List_Only = False;
		call Create_Fs_Dlg;

		Set_Global_Int( "@FLast_Choice", 0 );
    FileSrch( Search_Str, FileSpec, "", Root, Search_Dirs,
				Search_In_Mem | ShowAllFind, Flags, 0 );

  	ShowWindow( hAbort, SW_Hide );
		SetWindowText( h_Dir, "" );
		SetWindowText( h_File, "" );

    g_SearchStr = Search_Str;
    if ( Search_Mode ) {
			g_FRSwitches = 'P' + Switches_Str;
			g_SearchMode = True;
    }
    else {
			if ( XPos( 'P', g_Switches, 1 ) ) {
				SStr += 'P';
			}
			else if ( XPos( 'N', g_Switches, 1 ) ) {
				SStr += 'N';
			}
			g_FSwitches = Switches_Str;
			g_SearchMode = False;
		}

		if ( Error_Level != 0 ) {
			if ( hDlg ) {
      	Destroy_MEW_Dlg( hDlg );
			}
			hDlg = 0;
			goto ExitX;
		}
		if ( Return_Int == -1 ) {
			Set_Global_Int( "@FSearch_Aborted", 1 );
		}
		tof;

Load_Find_File:
No_Create:
		Refresh = False;
		Window_Attr |= 0x81;                // make it hidden and invisible
		if ( At_Eof ) {
			Eof;
			Goto_Col( 1 );
			if ( At_Eof ) {
				Rm( "MEERROR^MessageBox /B=2/T=Multiple File Search/M=No matched files found" );
				if ( hDlg ) {
	        Destroy_MEW_Dlg( hDlg );
				}
				hDlg = 0;
				goto ExitX;
			}
		}
		if ( File_Changed ) {
			Save_File;
		}
		// Get original Search_Str and Flags from top line of file
		Mark_Pos;
		Goto_Line( 1 );
		Flags = Parse_Int( "\x7F" + "SF=", Get_Line( ) );
		Search_Str = Parse_Str( "\x7F" + "SS=", Get_Line( ) );
		TotalFiles = Parse_Int( "\x7F" + "#F=", Get_Line( ) );
		TotalFnd = Parse_Int( "\x7F" + "#S=", Get_Line( ) );
		Goto_Mark;

		Goto_Col( 1 );
		List_Window = Window_Id;
    if ( Search_Mode ) {
      if ( hDlg ) {
        Destroy_MEW_Dlg( hDlg );
				hDlg = 0;
			}
    }
    else {
      if ( hDlg == 0 ) {
				// if we are doing a list previous, we need to create the dialog
				List_Only = TRUE;
				call Create_Fs_Dlg;
        SetDlgItemText( hDlg, SRCH_ID, Search_Str );
			}

      str Dlg_Title[ 50 ] = "Multiple File Search";

      if ( Global_Int( "@FSearch_Aborted" ) ) {
				Dlg_Title = Dlg_title + " (incomplete search)";
			}

  		SetWindowText(hDlg,Dlg_Title);

  		button_height = 25;
  		if ( !List_Only ) {
    		Y = 135;
  		}
			else {
    		Y = 80;
  		}

			int lh = 0, fh = 0, fw = 0, df = 0;
			Get_MEW_Dlg_Metrics ( hDlg, lh, fh, fw, df );


			int xbpos = bpos * fw;

  		Create_MEW_Ctrl( "BUTTON", "&Select",
					BS_PUSHBUTTON | BS_DEFPUSHBUTTON | WS_TABSTOP,
          (xbpos), y, Dlg_StanBtnWidth * 6, button_height,
          hDlg, 1001, app_handle, 0);
  		y += 30;

  		Create_MEW_Ctrl( "BUTTON", "Cancel",
          BS_PUSHBUTTON | WS_TABSTOP,
          xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
          hDlg, 1002, app_handle, 0);
  		y += 50;

			Create_MEW_Ctrl( "BUTTON", "&Help",
					BS_PUSHBUTTON | WS_TABSTOP,
          xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
					hDlg, 1003, app_handle, 0);

  		if ( !Search_Mode )  {
    		if ( ( FType < 1 ) || ( FType > 3 ) )  {
      		FType = 0;
    		}
    		Y += 50;

    		Create_MEW_Ctrl( "BUTTON", "File Type",
						BS_GROUPBOX| WS_TABSTOP,
            (xbpos) - 3, Y, (Dlg_StanBtnWidth + 3) * 6, 104,
            hDlg, 1300, app_handle, 0);

    		Y += 15;

    		Create_MEW_Ctrl( "BUTTON", "&Default",
						BS_AutoRadioButton,
            xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
            hDlg, 1400, app_handle, 0);

    		y += 20;

    		Create_MEW_Ctrl( "BUTTON", "D&os",
            BS_AutoRadioButton,
            xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
            hDlg, 1401, app_handle, 0);

    		y += 20;

    		Create_MEW_Ctrl( "BUTTON", "&Unix",
            BS_AutoRadioButton,
            xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
            hDlg, 1402, app_handle, 0);

    		y += 20;

    		Create_MEW_Ctrl( "BUTTON", "&Binary",
            BS_AutoRadioButton,
            xbpos, Y, Dlg_StanBtnWidth * 6, button_height,
            hDlg, 1403, app_handle, 0);

    		SendDlgItemMessage(hdlg, 1400 + ftype, BM_SetCheck, 1, 0);
  		}

			Auto_Size_Mew_Dlg ( hDlg, 10, 10 )
  		SetDefaultButton (hdlg, 1001);

			int MaxLength = 0;
			int J;
			int ListCount = SendDlgItemMessage( hDlg, 3100, LB_GETCOUNT, 0, 0 );

			str TStrVar = "\x7F";

  		Mark_Pos;
			Tof;
			if ( ShowAllFind ) {
				TStrVar = "\x7F" + "T=";
			}
			else {
				TStrVar = "\x7F" + "FP=";
			}
			while ( !At_Eof ) {
				if ( ( J = Length( Parse_Str( TStrVar, Get_Line( ) ) ) ) > MaxLength ) {
					MaxLength = J;
				}
				Down;
			}
			Goto_Mark;

			MaxLength += FnWidth + 20;
			LBSetHscroll( GetDlgItem( hDlg, 3100 ), MaxLength * Fw );

  		int hDlgOwner = GetWindow( hDlg, GW_OWNER );

			SetFocus( h_List );

			// Show totals
			SetDlgItemText( hDlg, 102, "Totals:" );
			if ( ShowAllFind ) {
				TStrVar = Str( TotalFnd ) + " match(es) in " + Str( TotalFiles ) +
						" file(s)";
			}
			else {
				TStrVar = "Matches in " + Str( TotalFiles ) + " file(s)";
			}
			SetDlgItemText( hDlg, dir_Id, TStrVar );

			// goto_line( global_int('@FLAST_CHOICE'));
			int tfl = global_int('@FLAST_CHOICE') - 1;

			if ( tfl < 0 )
			{
				tfl = 0;
			}
  		SendDlgItemMessage(hdlg, 3100, WM_ML2_SETCARET, 1, tfl);
			Return_int = 0;

  		int pmessage 	= 0,
      		pwparam 	= 0,
      		plparam 	= 0,
      		phwnd 		= 0;
			HelpLink_String = FILELIST_HELPLINK;

	KLoop:
			if ( GetMessage ( &msg, 0, 0, 0)) {
    		pmessage 	= msg.message;
    		pwparam 	= msg.wparam;
    		phwnd 		= msg.hwnd;
    		plparam 	= msg.lparam;
    		if ((msg.message == WM_MEW_DLGRETURN)) {
					switch( msg.wparam ) {
						case 998 :
						case 1 :
						case 1001 :
							int firsttime = 1;
          		if ( SendMessage (GetDlgItem(hdlg, 1401), BM_GetCheck, 0, 0) )  {
            		ftype = 1;
          		} else if ( SendMessage (GetDlgItem(hdlg, 1402), BM_GetCheck, 0, 0) )  {
            		ftype = 2;
          		} else if ( SendMessage (GetDlgItem(hdlg, 1403), BM_GetCheck, 0, 0) )  {
            		ftype = 3;
          		} else {
            		ftype = 0;
          		}
							for ( j=0; j<listcount; ++j ) {
								if ( SendMessage (GetDlgItem(hdlg, 3100), LB_GETSEL, j, 0)) {
              		switch_win_id(list_window);
									goto_line (j+1);
									return_int = 1;
									call Replace_Load;
									if ( BriefMode ) {
										Window_Attr &= 0xFF7F;
									}
									if ( firsttime ) {
										t_win = window_id;
										firsttime = 0;
									}
              		switch_window(found_win_num);
								}
							}
							return_int = 0;
							goto kdone;

						case 999 :
						case 2 :
						case 1002 :
							return_int = 0;
							goto kdone;

						case 0xffff :
							beep;
							hdlg = 0;
							return_int = 0;
							goto kdone;
							break;

						case 1003 :
							MewHelp_Context (); // (str(hLIST_FILES_FROM_LAS));
							return_int = 0;
							break;
					}
    		}
				else if ( ( Msg.Message == WM_SYSCOMMAND )/* && (msg.hwnd == hdlg) */) {
					if ( Msg.WParam == SC_CLOSE ) {
						goto KDone;
					}
				}
    		if ( !IsDialogMessage( hDlg, &Msg ) ) {
					TranslateMessage( &Msg );
        	DispatchMessage( &Msg );
    		}
			}
			goto KLoop;

KDone:
			HelpLink_String = "";
    	Set_Global_Int( '@FLAST_CHOICE',SendDlgItemMessage(hdlg, 3100, LB_GETCARETINDEX,0, 0 ) + 1 );

			if ( hDlg ) {
        Destroy_Mew_Dlg( hDlg );
			}
			hDlg = 0;
      Switch_Window( Found_Win_Num );

			Window_Attr = Window_Attr | 0x81;  /* make it hidden and invisible */
			if ( Return_Int != 1 ) {
				Switch_Win_Id( T_Win );
				goto Exit;
			}
		}

Replace_Load:
		Already_Loaded = 0;
		Result = 1;
		Goto_Col( 1 );
		if ( !Parse_Int( "\x7F" + "CM=", Get_Line( ) ) ) {
			Put_Line( "\x7F" + "CM=1" + Get_Line( ) );
		}
		File_Changed = False;

		Return_Str = FExpand( Parse_Str( "\x7F" + "FP=", Get_Line( ) ) +
				Parse_Str( "\x7F" + "FN=", Get_Line( ) ) );
		Nl = Parse_Int( "\x7F" + "LN=", Get_Line( ) );
		if ( Switch_File( Return_Str ) ) {
			Already_Loaded = 1;
			Rm( "Select_Window" );
			Make_Message( Return_Str + " already loaded." );
			Tof;
			goto No_Load;
		}
		if ( Search_Mode ) {
			Switch_Win_Id( Replace_Window );
			Rm( "LdFiles /NB=1/CW=" + Str( Leave_Files_Open ) );
		}
		else {
			Switch_Win_Id( T_Win );
      Rm( "LdFiles /NB=1/FTO=" + Str( FType ) + "/CW=2" );
		}

		if ( Error_Level == 0 ) {
			Make_Message('"' + File_Name + '" loaded.');

No_Load:
			if ( Leave_Files_Open ) {
				T_Win = Window_Id;
			}
			Down; Down; Down; Down;
			Goto_Line( Nl );
			if ( Format_Stat ) {
				Up;
			}
			Goto_Col( 1 );
			Left;
			Switches_Str = '';
			Reg_Exp_Stat = ( Flags & ( _RegExp | _OldExp ) ) != 0;
			if ( !Reg_Exp_Stat ) {
				Switches_Str += 'X';
			}
			Ignore_Case = ( Flags & _CaseSensitive ) == 0;
			if ( Ignore_Case ) {
				Switches_Str += 'I';
			}
			if ( Search_Mode ) {
				g_RepSearch = True;
        Set_Global_Int( "~SR_Modal", True );

				Rm( "S_And_R /FR=1/NG=1" );
        Set_Global_Int( "~Sr_Modal", False );
				/* Return_Int can have 3 values:
						0 = Normal s/r occurred
						1 = Non-Stop all files
	 				 	-1 = Abort remaining files
				*/
				if ( ( Return_Int == 1 ) && !All_Files ) {
					All_Files = 1;
					g_FRSwitches += 'N';
				}
				if ( !Already_Loaded ) {
					if ( File_Changed ) {
						Save_File;
					}
				}
				Refresh = False;
				Switch_Win_Id( List_Window );
				Down;
				Goto_Col( 1 );
				if ( !At_Eof && ( Return_Int != -1 ) ) {
					goto Replace_Load;
				}
				Switch_Win_Id( T_Win );
      }
      else {

				int Jx;

				str TStr = g_Switches;

				// Add/remove regular expression flag from normal search flags
				if ( XPos( 'X', Switches_Str, 1 ) ) {
					if ( XPos( 'X', TStr, 1 ) == 0 ) {
						TStr += 'X';
					}
				}
				else if ( Jx = XPos( 'X', TStr, 1 ) ) {
					TStr = Str_Del( TStr, Jx, 1 );
				}
				// Add/remove ignore case flag from normal search flags
				if ( XPos( 'I', Switches_Str, 1 ) ) {
					if ( XPos( 'I', TStr, 1 ) == 0 ) {
						TStr += 'I';
					}
				}
				else if ( Jx = XPos( 'I', TStr, 1 ) ) {
					TStr = Str_Del( TStr, Jx, 1 );
				}
				// Force forward search
				if ( Jx = XPos( 'B', TStr, 1 ) ) {
					TStr = Str_Del( TStr, Jx, 1 );
				}
				g_Switches = TStr;
				// Set normal search to use the original search pattern
				g_SearchStr = Search_Str;
        if ( Flags & _RegExp ) {
          Search_Str = ReTranslate( Search_Str, 1 );
        }
        else if ( Flags & _OldExp ) {
          Search_Str = ReTranslate( Search_Str, 2 );
        }
        Find_Text( Search_Str, 0, Flags );
				Set_Highlight( C_Line, C_Col, C_Line, C_Col + Length( Found_Str ) );
			}
			Reg_Exp_Stat = True;
    }
    else {
      Switch_Win_Id( T_Win );
		}
    if ( !Search_Mode ) {
			ret;
    }
	}

Exit:
  if ( Error_Level != 0 ) {

ExitX:
    Switch_Win_Id( T_Win );
	}
	T_Win = Window_Id;
	if ( Switch_Win_Id( Replace_Window ) ) {
		Delete_Window;
		Switch_Win_Id( T_Win );
	}
	if ( Result ) {
		Rm( "Select_Window /BM=1/VIS=1" );
	}
	Return_Int = Result;
	Update_Status_Line;

	goto Final_Exit;

// ******************SUBROUTINES

Create_Fs_Dlg:

	int list_count = 0,
			bitmap_offset,
			dc, true_font_height,
			blackframe_offset = 3;

	struct TTEXTMETRIC tm;

  found_win_num = cur_window;
  DlgCreate(hdlg);

  DlgAddCtrl(hdlg, Dlg_BitmapStatic, bitmap_name,
              bpos + 3, 1 + (Dlg_Units | 15), Dlg_StanBtnWidth, 0,
              501, 0, '');

  DlgAddCtrl(hdlg, Dlg_Static, 'Search expression:',
              otherpos + 1, 1 + (Dlg_Units | 5), 0, 0,
              101, 0, '');


  DlgAddCtrl(hdlg, Dlg_BlackFrame, '',
      Dlg_PosOffset + 20, Dlg_PosOffset,
      FnWidth + 24, Dlg_Units | 8,
      201, 0, '');

  DlgAddCtrl(hdlg, Dlg_Static, '',
      Dlg_PosOffset + 1, Dlg_PosOffset,
      FnWidth + 22, 0,
      SRCH_ID, 0, '');

  DlgAddCtrl(hdlg, Dlg_Static, 'In Directory:',
      otherpos + 1, Dlg_PosOffset + (Dlg_Units | 15),
      0, 0,
      102, 0, '');

  DlgAddCtrl(hdlg, Dlg_BlackFrame, '',
      Dlg_PosOffset + 20, Dlg_PosOffset,
      FnWidth + 24, Dlg_Units | 8,
      202, 0, '');

    DlgAddCtrl(hdlg, Dlg_Static, '',
        Dlg_PosOffset + 1, Dlg_PosOffset,
        FnWidth + 22, 0,
        DIR_ID, 0, '');

	if ( !List_Only ) {
    DlgAddCtrl(hdlg, Dlg_Static, 'In File:',
        otherpos + 1, Dlg_PosOffset + (Dlg_Units | 15),
        0, 0,
        103, 0, '');

    DlgAddCtrl(hdlg, Dlg_BlackFrame, '',
        Dlg_PosOffset + 20, Dlg_PosOffset,
        FnWidth + 24, Dlg_Units | 8,
        203, 0, '');

    DlgAddCtrl(hdlg, Dlg_Static, '',
        Dlg_PosOffset + 1, Dlg_PosOffset,
        FnWidth + 22, 0,
        FILE_ID, 0, '');
	}

  DlgAddCtrl(hdlg, Dlg_Static, 'Matched Files:',
      otherpos + 1, Dlg_PosOffset + (Dlg_Units | Dlg_Units_Line_Half),
      0, 0,
      301, 0, '');

	if ( List_Only ) {
		Eof;
		if ( C_Col == 1 ) {
			Up;
		}
		List_Count = C_Line;
	}

	if ( ShowAllFind ) {
  	DlgAddCtrl( hDlg, Dlg_ListBox, "\x7F" + "CM=/T=4/HT=15/W=15" +
						"\x7F" + "LN=/W=9" + "\x7F" + "T=/W=255",
  			OtherPos + 1, Dlg_PosOffset + 1,
				FnWidth + 44, DLG_Units | (DLG_Units_Per_Line + (DLG_Units_HLine * 25 ) ),
      	3100, DLGF_LB_HSCROLL, "/WIN=" + Str( Found_Win_Num ) );
	}
	else {
  	DlgAddCtrl( hDlg, Dlg_ListBox, "\x7F" + "CM=/T=4/HT=15/W=15" +
						"\x7F" + "FN=/IS=1/W=" + Str( FnWidth ) +
						"\x7F" + "LN=/W=12" + "\x7F" + "FP=/W=255",
  			OtherPos + 1, Dlg_PosOffset + 1,
				FnWidth + 44, DLG_Units | (DLG_Units_Per_Line + (DLG_Units_HLine * 25 ) ),
      	3100, DLGF_LB_HSCROLL | DLGF_LB_ExtendedSel,
				"/INCO=1/WIN=" + Str( Found_Win_Num ) );
	}

	if ( !List_Only ) {
    DlgAddCtrl(hdlg, Dlg_PushButton, '&Abort',
				bpos, Dlg_PosOffset,
				Dlg_StanBtnWidth, 0,
        ABORT_ID, Dlgf_DefButton, '' );
	}

  DlgExecute( hDlg, 3100, 'Searching Files', '', '', DLG_Modeless );

  hdlg   = DlgGetWHandle( hDlg );
  h_dir  = GetDlgItem( hDlg, DIR_ID );
  h_file = GetDlgItem( hDlg, FILE_ID );
  h_list = GetDlgItem( hDlg, 3100 );
  habort = GetDlgItem( hDlg, ABORT_ID );
//  EnableWindow( h_List, FALSE );

	RET;
// ****************** END SUBROUTINES

FINAL_EXIT:
}

macro IncSrch trans2 {
/************************************************************************

Module Name:  IncSrch

Description:  Incremental Search such as in Emacs and such.

Creation Date:  02-19-93 04:07pm
 MNB modified to make this usable for MEW 09-09-94

Key Assignments:		<Esc> - cancels search and returns cursor to
														original position prior to the search.
									 <AltP> - searches backwards (previous)
									 <AltN> - searches for next occurrence
							<Backspace> - removes the last char in the search
														string and searches for the new string
									<AltW> - performs a word search
									<AltC> - performs case sensitive searhing

************************************************************************/

	int t_reg_exp_Stat = reg_exp_Stat, // Save system vars so we can restore
			t_ignore_case = ignore_case,  // them to their original state on exit
			t_refresh = refresh,
			orig_line,
			tp,
			New_line_Num,
			newline,
			backward = parse_int('/BWD=', mparm_str),
			case_sensitive = 0;
	int MsgChanged = True;
	int Found = True;
	int Again = 0;
	int Done = False;
	int Kx;

	str Search_Str = "",
			MStr,
			Word_Srch,
			Bwd,
			Cs;

	struct TMsg Msg;
	struct TKeyboardState KState;

	if ( Backward != 0 ) {
		Backward = _Backward;
		Bwd = "Bwd ";
	}
	Reg_Exp_Stat = False;
	Ignore_Case = True;
	Mark_Pos;
	while ( True ) {
		while ( !PeekMessage( &Msg, 0, 0, 0, PM_NOREMOVE ) );
		if ( MsgChanged ) {
			Redraw;
			Orig_Line = C_Line;
			NewLine = 0;
			Make_Message( Bwd + Cs + "I-Search: " + Word_Srch + "\"" + Search_Str +
					"\" " + MStr );
			MsgChanged = False;
		}
		Refresh = False;
		switch ( Msg.Message ) {
			case WM_SYSKEYDOWN :
			case WM_KEYDOWN :
				if ( ( Msg.WParam == VK_Capital ) || ( Msg.WParam == VK_NumLock ) ) {
					PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
					TranslateMessage( &Msg );
					DispatchMessage( &Msg );
					break;
				}
      	if ( Msg.WParam == vk_Escape ) {
					PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
					Done = True;
					break;
				}
				if ( ( Msg.WParam == VK_Shift ) || ( Msg.WParam == VK_Control ) ||
						( Msg.WParam == VK_Menu ) )	{
					PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
					break;
				}
				if ( Msg.WParam == VK_Back ) {
					PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
					MsgChanged = True;
					Search_Str = Str_Del( Search_Str, Svl( Search_Str ), 1 );
					if ( Svl( Search_Str ) == 0 ) {
						break;
					}
					goto Search_Only;
				}
				if ( Msg.Message == wm_SysKeyDown ) {
					if ( Msg.WParam == 87 ) {  			// Alt W
						PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
						MsgChanged = True;
						if ( Global_Int( "Inc_Word_Srch" ) ) {
							Set_Global_Int( "Inc_Word_Srch", 0 );
							Word_Srch = "";
						}
						else {
							Set_Global_Int( "Inc_Word_Srch", 1 );
							Word_Srch = "Word ";
							if ( Svl( Search_Str ) != 0 ) {
								goto Search_Only;
							}
						}
					}
					else if ( Msg.WParam == 67 ) {	// Alt C
						PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
						MsgChanged = True;
						if ( Case_Sensitive ) {
							Case_Sensitive = 0;
							Ignore_Case = True;
							Cs = "";
						}
						else {
							Case_Sensitive = _CaseSensitive;
							Ignore_Case = False;
							Cs = "Case ";
							if ( Svl( Search_Str ) != 0 ) {
								goto Search_Only;
							}
						}
					}
					else if ( Msg.WParam == 78 ) {  // Alt N
						PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
						MsgChanged = True;
						Backward = 0;
						Bwd = "";
						Again = 1;
						Right;
						goto Search_Only;
					}
					else if ( Msg.WParam == 80 ) {	// Alt P
						PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
						MsgChanged = True;
						Backward = _Backward;
						Bwd = "Bwd ";
						Again = -1;
						Left;
						goto Search_Only;
					}
					else {
						Done = True;
						break;
					}
				}
				else {
					Kx = 0;
      		GetKeyboardState( &KState );
					if ( ToAscii( Msg.WParam, MapVirtualKey( Msg.WParam, 0 ), &KState.K,
							&Kx, 0 ) < 1 ) {
						Done = True;
						break;
					}
					PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
					TranslateMessage( &Msg );
				}
				break;

			case WM_CHAR :
				PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
				/*
				* All alphanumeric keys are added to the search string,
				* but only if the new search string finds something.
				*/
				str Jx = Char( Msg.WParam );

//				if ( !Found && Svl( Search_Str ) ) {
//					break;
//				}
				MsgChanged = True;
				Search_Str += Jx;

	Search_Only:
				Mark_Pos;
				if ( Global_Int( "Inc_Word_Srch" ) ) {
					Return_Str = Search_Str;
					Rm( "Srch_Across_Line /B=" + Str( Backward ) );
				}
				else {
					Return_Int = Find_Text( Search_Str, 0, Backward | Case_Sensitive );
				}
				if ( Return_Int ) {
					Pop_Mark;
					call Highlight_Find;
					MStr = "";
					Found = True;
				}
				else {
					Goto_Mark;
					if ( Again > 0 ) {
						Left;
						Find_Text( Search_Str, 0, Case_Sensitive );
						call Highlight_Find;
					}
					else if ( Again < 0 ) {
						Right;
						Find_Text( Search_Str, 0, Case_Sensitive );
						call Highlight_Find;
					}
					Rm( "MEERROR^Beeps /C=2" );
					MStr = " String not found";
					Found = False;
				}
				Again = 0;
				break;

			default:
				PeekMessage( &Msg, 0, 0, 0, PM_REMOVE );
      	if ( ( ( Msg.Message <= wm_MouseFirst ) || ( Msg.Message > wm_MouseLast ) ) &&
          	( ( Msg.Message < wm_NCLButtonDown ) || ( Msg.Message > wm_NCMButtonDblClk ) ) ) {
        	TranslateMessage( &Msg );
        	DispatchMessage( &Msg );
      	}
		}
		if ( Done ) {     // Cancel and return cursor to original
			break;
		}
	}
	if ( Msg.WParam == vk_Escape ) {     // Cancel and return cursor to original
		Goto_Mark;									// position if ESC is pressed
		Redraw;
	}
	else {
		Pop_Mark;
	}
	reg_exp_stat = t_reg_exp_stat; // Restore system variables
	ignore_case = t_ignore_case;
	refresh = t_refresh;

  Make_Message( "" ); // Erase prompt
	goto Done;


/*
 * These subroutines were swiped from MEUTIL2 and modified a bit.
 */
highlight_find:
	if (  c_line > orig_line  ) {
		if(  (c_line - orig_line) <= (win_CHeight - c_row)  ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				down;
			}
		}
		else {
			call Center_line;
		}
	}
	else if ( newline == 0 ) {
//    if(  (orig_line - c_line) <= (win_CHeight - (win_CHeight - c_row))  ) {
		if ( ( Orig_Line - C_Line ) < C_Row ) {
			tp = c_line;
			goto_line(orig_line);
			while(  c_line != tp  ) {
				up;
			}
		}
		else {
			call Center_line;
		}
	}
	Refresh = True;
//	tp = c_col;
//	goto_col(search_end_col);
//	goto_col(tp);
	Search_Highlight = Buffer_Id;
	ret;

/* will center the selected line on the screen if possible */
Center_line:
	New_line_Num = C_line;
//	tp = c_col;
	Tp = Win_CHeight / 2;

	while ( C_Row > Tp ) {
		Up;
	}
	while ( C_Row < Tp ) {
		Down;
	}
	Goto_line(New_line_Num);
//	goto_col(tp);
	ret;

done:
/* Comment out the line below if you want the status of Word search
	 to be restored */
	set_global_int('Inc_Word_Srch',0);
}

// support macro for search list.
// it finds occurrences of the "/" character and duplicates the character
str convsl (str cs[max_line_length])
{
  int position = 0;
  position = xpos("/", cs, 1);
  while ( position )
  {
    cs = str_ins("/", cs, position);
    position = xpos("/", cs, position + 2);
  }
	return(cs);
}
