//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)2 REGEXP.S, 09-Jul-95,20:39:24, LDH"

macro_file RegExp;

//#define _DEBUG_

#ifdef _Debug_
	#include DBUG.SH
#endif

#include DBTOOLS.SH
#include DB.SH
#include REGEXP.SH

#define _ReAliasPg			"REALIAS"
#define _ReSelectAlias  "@ReSelectAlias"

#define _Re_Als_Desc    "DS"
#define _Re_Als_Alias		"AS"
#define _Re_Als_Classic	"CS"
#define _Re_Als_Unix		"US"

// Internal globals
global {
	int Reg_Exp_Style;

	str g_ReAlias				"~ReAlias";
	str g_ReSelectAlias	_ReSelectAlias;
}
// Internal functions
prototype REGEXP {
	void _ReSetAliasGlo( );
}

void _ReSetAliasGlo( ) {
/******************************************************************************
															 Multi-Edit Macro
															 29-May-95  13:50

  Function: Set the ReAlias global string with all defined aliases

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int OrgWin = Window_Id;
	int TRefresh = Refresh;
	int FirstRec = 0;
	int NumRec;
	int CfgWin;
	int Jx;

	str Line;
	str AStr[ Max_Line_Length ];

	Refresh = False;
	DbGetPage( "MECONFIG", _ReAliasPg + ".DB", FirstRec, NumRec );
	if ( NumRec ) {
		CfgWin = Cur_Window;
		while ( NumRec-- ) {
			Line = Get_Line_From_Win( FirstRec++, CfgWin );
			Jx = XPos( "\x7F" + _Re_Als_Alias + "=", Line, 1 );
			if ( Jx ) {
				Jx += Length( _Re_Als_Alias ) + 1;
				AStr += "\xFE" + Copy( Line, Jx, Svl( Line ) - Jx + 1);
			}
		}
		g_ReAlias = AStr;
	}
	Switch_Win_Id( OrgWin );
	Refresh = TRefresh;

}  // ReSetAliasGlobal

void ReEditAlias( ) {
/******************************************************************************
															 Multi-Edit Macro
															 29-May-95  14:42

  Function: Manage the regular expression alias db list.

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	Db( "MECONFIG.DB", _ReAliasPg + ".DB", "MEWHDRS.DB", _ReAliasPg + ".HDR",
			"Regular Expression Aliases",
			"",
			_ReSelectAlias,
			Parse_Int( "/LO=", MParm_Str ),
			Mparm_Str + "/H=" + "/BMP=/NDF=1/NDH=1/MOVE=1/NOALPHA=1" );

	if ( Global_Int( "@DB_FILE_CHANGED" ) ) {
		_ReSetAliasGlo( );									// Create RE alias global
	}
}  // ReEditAlias

str ReSelectAlias( ) {
/******************************************************************************
															 Multi-Edit Macro
															 29-May-95  16:19

  Function: Return the regular expression alias selected from the db list.

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	str Alias;

	Rm( "ReEditAlias /LO=1/FFLD=AS" );
	if ( Return_Int ) {
		Alias = Parse_Str( "\x7F" + _Re_Als_Alias + "=", g_ReSelectAlias );
	}
	g_ReSelectAlias = "";

#ifdef _DEBUG_
	Make_Message( Alias );
#endif

	return ( Alias );

}  // ReSelectAlias

str ReTranslate( str RegExpr[ Max_Line_Length ] = Parse_Str( "/R=", MParm_Str ),
				int Style = Parse_Int( "/S=", MParm_Str ) ) {
/******************************************************************************
															 Multi-Edit Macro
															 09-Jul-95  20:28

  Function: Translate the regular expression aliases in RegExpr.

							 Copyright (C) 1995 by American Cybernectic, Inc.
********************************************************************( ldh )***/

	int Done;
	int Jx;
	int Jy;
	int AStart;
	int AEnd;
	int Passes = 16;
	int ASLen = Length( _Re_Als_SStr );
	int AELen = Length( _Re_Als_EStr );

	str AStr[ Max_Line_Length ];
	str Field;
	str TStr;
	str FndAlias;
	str Alias;

	if ( Length( g_ReAlias ) == 0 ) {
		_ReSetAliasGlo( );
	}
	AStr = g_ReAlias;
	if ( Style == 0 ) {
		Style = Reg_Exp_Style;
	}
	if ( Style == 1 ) {
		Field = "\x7F" + _Re_Als_Unix + "=";
	}
	else {
		Field = "\x7F" + _Re_Als_Classic + "=";
	}
	do {
		Jy = 1;
		Done = True;
		while ( Jx = XPos( _Re_Als_SStr, RegExpr, Jy ) ) {
			Jy = XPos( _Re_Als_EStr, RegExpr, Jx + ASLen );
			if ( Jy ) {
				Jy += AELen;
				FndAlias = Copy( RegExpr, Jx, Jy - Jx );
				// Get translated alias from global into Alias
				if ( XPos( "\xFE=" + FndAlias, AStr, 1 ) ) {
					TStr = Parse_Str( "\xFE=" + FndAlias, AStr );
					Alias = Parse_Str( Field, TStr );
				}
				else {
					Alias = "";
				}
				if ( Svl( Alias ) ) {
					// Check if another alias in Alias
					if ( XPos( _Re_Als_SStr, Alias, 1 ) ) {
						Done = False;
					}
					// Translate this Alias in rest of string
					AStart = Jx;
					AEnd = Jy;
					while ( True ) {
						RegExpr = Str_Del( RegExpr, AStart, AEnd - AStart );
						RegExpr = Str_Ins( Alias, RegExpr, AStart );
						AStart = XPos( _Re_Als_SStr + FndAlias + _Re_Als_EStr, RegExpr,
								AStart + Svl( Alias ) );
						if ( AStart == 0 ) {
							break;
						}
						AEnd = XPos( _Re_Als_EStr, RegExpr, AStart + ASLen );
						if ( AEnd == 0 ) {
							break;
						}
						AEnd += AELen;
					}
				}
			}
			else {
				break;
			}
		}
		--Passes;
		if ( Passes == 0 ) {
			Beep;
			Done = True;

		}
	} while ( !Done );

#ifdef _DEBUG_
	Make_Message( RegExpr + " " + Str( Passes ) + " " + TStr );
#endif

	return ( RegExpr );

}  // ReTranslate
