// $Header: /MEWIN/SRC/MOUSE.S 21    4/23/96 1:12p Todd $
Macro_File Mouse;
#include windows.sh
#include shellapi.sh
#include mew.sh
#include metools.sh
#include dbtools.sh
#include menus.sh
#include language.sh

#DEFINE _MouseLButton   0x00000001
#DEFINE _MouseRButton   0x00000002
#DEFINE _MouseInBlock   0x00000004
#DEFINE _mk_LButton     0x00010000
#DEFINE _mk_RButton     0x0002
#DEFINE _mk_Shift       0x0004
#DEFINE _mk_Control     0x0008
#DEFINE _mk_MButton     0x0010

#DEFINE WINDOWNAME      0x20
#DEFINE WINDOWSTATUS    0x40


void MouseDblClick( int flags )
{
	str tstr;
  int jx,cx,cy,cl1,cl2;
	int obs = block_stat;
	int tr = refresh;
	int tc = c_col;
	int tl = c_line;
	int to = left_offset;

	refresh = false;
	if( flags & _MouseLButton )
	{
		block_off;
    cl1 = c_line;
    cl2 = c_line;
		if(copy(keywords_str,1,4) == "HTML")
		{
			int tpersist = persistent_blocks;
			switch ( cur_char )
			{
				case "<" :
						cx = c_col;
						if(find_text(">", 10, 0 ))
						{
              if(!stream_block_mode)
							{
								right;
							}
              cy = c_col - 1;
              cl2 = c_line;
							goto create_block;
						}
						break;

        case ">" :
						cx = c_col;
            if(find_text("<", 10, _Backward ))
						{
              cx = c_col;
              cy = tc;
              cl1 = c_line;
              cl2 = tl;
							goto create_block;
						}

            break;
			}
		}
    else
    if(keywords_str != "")
    {
      if( xpos(cur_char, "()[]<>{}\\*", 1) )
      {
        mark_pos;
        rm("Match /BL=1/NM=1");
        goto_mark;
        if((block_stat == 3))
        {
          goto done;
        }
      }
    }

		tstr = word_delimits;
		while( jx = xpos( ' ', tstr, 1 ) )
				tstr = str_del( tstr, jx, 1 );
		while( jx = xpos( '|255', tstr, 1 ) )
				tstr = str_del( tstr, jx, 1 );
		while( jx = xpos( '|9', tstr, 1 ) )
				tstr = str_del( tstr, jx, 1 );
		if( xpos( cur_char, tstr, 1) )
		{
			while( xpos( cur_char, tstr, 1) && (c_col > 1) )
					left;
			if( !xpos( cur_char, tstr, 1))
					right;
			cx = c_col;
			forward_till_not( tstr );
		}
		else
		{
			right;
			word_left;
			cx = c_col;
			forward_till(word_delimits);
		}
		cy = c_col - 1;
 create_block:
    goto_line( tl );
		goto_col(tc);
		left_offset = to;
		if( (obs == 3) && (cx == block_col1) && (cy == block_col2) &&
					(c_line == block_line1) && (c_line == block_line2)) {
			block_begin;
			block_end;
		}
		else if( (obs == 1) && (block_line1 == c_line) && (block_line2 == c_line) ) {
			block_off;
		}
		else {
			block_stat = 3;
      block_line1 = cl1;
      block_line2 = cl2;
			block_col1 = cx;
			block_col2 = cy;
		}
done:
		refresh = TRUE;
		display_line;
	}
	refresh = tr;
}


void ContextMenu( int x = parse_int("/X=",mparm_str),
									int y = parse_int("/Y=", mparm_str) )
{
    str passedstr = global_str('ACTIVE_CONTEXT');
    str lang[80];
    str tstr;
		if ( passedstr == '' )
			passedstr = 'CONTEXT';

		struct tpoint tp;

		if((!x) && (!y))
		{
			GetCaretPos( &tp );
			tp.x += 3;
		}
		else
		{
			tp.x = x;
			tp.y = y;
		}

		ClientToscreen( window_handle, &tp );
    tstr = wcmdmapname;
    int Menu = CreateMenuFromDBEx( tstr, passedstr, MENU_Popup, 0 );

		if(Menu)
		{
      lang = Caps(Parse_Str("LS=", Global_Str("." + Get_Extension(file_name))));
      if(lang != "")
      {
        str LanguageRec[Max_Line_Length];
        str macrostr;
        if ( LangGetRecord( Lang, LanguageRec ) == _NoError ) {
          macrostr = Parse_Str( "\x7FMENUMAC=", LanguageRec );
          if(macrostr != "")
          {
            if(!xpos(" ", macrostr,1) )
              macrostr += " ";

            RM(macrostr + "/MENUHANDLE=" + str( menu ) + "/LANGUAGE=" + Lang);
          }
          else
          {
            tstr = wcmdmapname;
            CreateMenuFromDBEx(tstr, lang, MENU_Popup, menu );
          }
        }
      }
			TrackPopupMenu( menu, TPM_LEFTALIGN | TPM_RIGHTBUTTON, tp.x, tp.y,0,frame_handle,0 );
			destroymenu( menu );
		}
}

void MouseRClick( int flags, int x, int y, int ol, int oc )
{
  if ( ((flags >> 16) == 0x06) || ((flags >> 16) == 0x0A) )  // shift or Ctrl with right button
  {
    int opb = persistent_blocks, or = refresh;
    refresh = false;
    persistent_blocks = true;
    while ( ol > c_line ) {
      down;
    }
    while ( ol < c_line ) {
      up;
    }
    while ( oc > c_col ) {
      right;
    }
    while ( oc < c_col ) {
      left;
    }
    rm('MOUSE_SEARCH /D=' + str((flags >> 16) == 0x0A));
    persistent_blocks = opb;
    refresh = or;
  } else {
    ContextMenu( x, y );
  }
}



void ProcDragDrop( int hn )
{

	str fn;
	int file_count = DragQueryFile( hn, 0xffff, fn, 0 );
	int jx;
	int tr = refresh;
	refresh = false;

	for(jx = 0; jx < file_count; jx++)
	{
		DragQueryFile( hn, jx, fn, 253 );
		return_str = fn;
		rm("ldFiles /LC=0/CW=2");
	}

	DragFinish( hn );
	refresh = tr;
}


Macro ToggleCaps
{
	struct TkeyboardState kState;

	int x;

	GetKeyboardState (&kState);
	x = kState.k[VK_CAPITAL];
	if ( x & 0x01 )
		kState.k[VK_CAPITAL] = x & 0xFE;
	else
		kState.k[VK_CAPITAL] = x | 0x01;

	SetKeyboardState (&kState);
	Update_Status_Line;
}

Macro ToggleNum
{
	struct TkeyboardState kState;

	int x;

	GetKeyboardState (&kState);

	x = kState.k[VK_NUMLOCK];

	if ( x & 0x01 )
		kState.k[VK_NUMLOCK] = x & 0xFE;
	else
		kState.k[VK_NUMLOCK] = x | 0x01;

	SetKeyboardState (&kState);
	Update_Status_Line;
}


void StatOp (int option = Parse_Int ("/T=", mparm_str))
{
	Switch (option)
	{
		case 10:  // Case from StatWIN
			if ( ((window_attr & $41) == 0) && (window_handle != 0) )
			{
				RM ("GOTOLINE");
			}
			break;
		case 11:
			RM ("INSTGL");
			break;
		case 12:
			RM ("ToggleCaps");
			break;
		case 13:
			RM ("ToggleNum");
			break;
		case 14 :
			key1 = 0;
			key2 = 0;
			Key_Record;
			break;

		case $21:   // Left Button Letter
			RM ("WINDOW^SWITWIN");
			break;
		case $22:   // rightButton Letter
			break;
		case $25:   // Left Button -Shift
			RM ("WINDOW^LASTWIN");
			break;
		case $26:   // Right Button Shift
			RM ("WINDOW^NEXTWIN");
			break;
		case $29:   // Left Button Control
			break;
		case $2A:   // Right Button Control
			break;

		case $41:   // Left Button Status
			RM ("FILESTAT");
			break;
		case $42:   // rightButton Status
			break;
		case $45:   // Left Button -Shift
			break;
		case $46:   // Right Button Shift
			break;
		case $49:   // Left Button Control
			break;
		case $4A:   // Right Button Control
			break;
	}
}

/********************************MULTI-EDIT MACRO******************************

Name:  MOUSE_SEARCH

Description:  Search for currently marked word

Parameters:   /D=1		search backwards

*******************************************************************************/
macro MOUSE_SEARCH trans2 {
	str save_switches;
	int save_search_mode;
	int pb = persistent_blocks;

	persistent_blocks = TRUE;
//  make_message(str(block_stat) + '  ' + str(block_line1) + '   ' + str(block_line2));
	if(  (Block_Stat > 0) && (block_line1 == block_line2)  ) {
		refresh = FALSE;
		mark_pos;
		goto_line(block_line1);
		set_global_str('SEARCH_STR', copy(get_line, block_col1, block_col2 - block_col1 + 1));
		goto_mark;
		save_search_mode = global_int('SEARCH_MODE');
		Set_Global_Int('SEARCH_MODE', 0);  // set for search only (no replace)
		save_switches = global_str('SWITCHES');  // save search option switches
		if(  parse_int('/D=', mparm_str)  ) {
			set_global_str('SWITCHES', 'IBX');
			if( (block_line1 == c_line) && (c_col > block_col1)) {
				goto_col(block_col1);
			}
			left;
		} else {
			set_global_str('SWITCHES', 'IX');
			right;
		}
		Set_Global_Int('REPSEARCH', 1 );
		RM('S_AND_R');
		Set_Global_Int('REPSEARCH', 0 );
		Set_Global_Str('SWITCHES', save_switches);  // restore search option switches
		Set_Global_Int('SEARCH_MODE', save_search_mode); // restore search mode
	} else {
//    RM('MOUSEINWINDOW');
//    if(  return_int  ) {
			mark_pos;
			right;
			word_left;
			str_block_begin;
			get_word(word_delimits);
			block_end;
			goto_mark;
//    }
	}
	persistent_blocks = pb;
} /* MOUSE_SEARCH */