// mew_btn.sh - CMAC interface file to bitmapped button
// and spinbutton routines in MEWTOOLS.DLL.


// MEWButton's class-specific window styles.
#define MEWBTN_SIZETOBUTTON         0x0001    // default
#define MEWBTN_PUSHBUTTON           0x0002
#define MEWBTN_DEFPUSHBUTTON        0x0004


#define MEWBTN_TOGGLEBUTTON         0x0008    // Can be combined with
																							// mewbtn_pushdbutton to create
																							// a button that can be turned
																							// ON or turned OFF.
																							// Allows the user to create a
																							// group of related buttons
																							// similar to the
																							// standard Windows checkboxes

#define MEWBTN_SIZETOBITMAP         0x0010

#define MEWBTN_TEXTBUTTON           0x0020    // (not available)
#define MEWBTN_TEXTANDBITMAP        0x0040    // combine text and bitmap

#define MEWBTN_ONESHOT              0x0080    // can be combined with
																							// mewbtn_pushbutton to create
																							// a button that can only be
																							// turned ON (via keyb/mouse).
																							// Note: 'owner' of the control
																							//  must reset the state using
																							//  SetStateOfMEWButton(
																							//     NORMAL_MEWBTN);
																							//  This allows the owner to
																							//  create a group of related
																							//  buttons similar to the
																							//  std Windows radio buttons

#define MEWBTN_STATICBUTTON         0x0100    // no border
#define MEWBTN_BORDEREDSTATICBUTTON 0x0200


																							// MEWButton color drawing styles
#define MBCS_BKCOLOR                0x1000    // (not available)
																							//   draw with color background
#define MBCS_TRANSPARENT            0x2000    // draw with transparent bkgrnd
																							// (given the color to mask out)
#define MBCS_DRAW                   0x0000    // draw as is



// MEWBTN_TEXTANDBITMAP orientation & alignment
#define MBT_TOP                     0x0001
#define MBT_BOTTOM                  0x0002
#define MBT_LEFT                    0x0003
#define MBT_RIGHT                   0x0000    // default

#define MBT_TEXTLEFT                0x0000    // default
#define MBT_TEXTCENTER              0x0010
#define MBT_TEXTRIGHT               0x0020


// MEWButton's states
// returned by GetStateOfMEWButton function
#define NORMAL_MEWBTN             0
#define SELECTED_MEWBTN           1
#define DISABLE_MEWBTN            2
#define FOCUS_MEWBTN              3
#define DEFAULT_MEWBTN            4

#define SHOT_MEWBTN               5   // OneShot button has been clicked
#define STUCK_MEWBTN              6   // Toggle button is in the ON state

#define STATIC_MEWBTN             7
#define MOUSEUPDOWN_MEWBTN        8


// MEWButton's class-specific window messages.
//
//
// NONE


// MEWButton's notification codes sent in HIWORD of lParam
// during a WM_COMMAND message.
// (mimic standard BN_ codes + more)
// Use the GetStateOfMEWButton() function to check the button's state
// if the style is ToggleButton or OneShot or PushButton
#define MEWBTN_LCLICKED					0


// MEWButton's creation type codes
#define MEWBTN_RT_RESNAME				0 	// (lpsz) resource name
#define MEWBTN_RT_RESID					1 	// (int ) resource identifier
#define MEWBTN_RT_BMPF					2 	// (lpsz) direct .bmp filename
#define MEWBTN_RT_RESFILENAME 	3 	// (lpsz) res file ^ res name
#define MEWBTN_RT_RESFILEID			4 	// (lpsz) res file % res id
#define MEWBTN_RT_BMHANDLE			5 	// (int ) handle to bitmap already loaded
#define MEWBTN_RT_WIN31OEM      6   // (int)  OEM Windows bitmap resource id



/* RegisterMEWResource ---------------------------------------
 *    A list of instance handles is kept to provide a type
 *    of search path for locating bitmap resources.
 *    The list is search only when the BuildMEWButton routines
 *    use this list when creating buttons of the
 *    _RT_RESNAME and _RT_RESID type styles.
 *
 *    Possible uses are loading resource-only DLL's from the
 *    STARTUP.S macro, using another app's bitmaps (if it is
 *    already loaded).
 */
IMPORT VOID RegisterMEWResource(WORD hInstanceOfResourceFile)
		MEWTOOLS 200;


IMPORT WORD FetchBitmap(
		WORD    iRefType,             // type of reference to button
		ASCIIZ  lpszNewButtonRef    // new name of bitmap to display
)
	MEWTOOLS 203;

IMPORT WORD FetchResource(
							POINTER hInstance,
							WORD iRefType,
							ASCIIZ lpszResourceRef,
							ASCIIZ lpszType)
	MEW_BTN 220;


IMPORT WORD BuildMEWButton(
		WORD		hCurrentWindow,
		WORD     iRefType,         // type of the button reference (see next var)
		ASCIIZ  lpszButtonRef,    // reference to button to load
		DWORD		dwWstyle,					// windows style attributes
		DWORD		dwMEWstyle,				// styles specified to these controls
		WORD   iControlID,         // unique child window identifier
		WORD   iHorzPosition,     // where to put the bitmap
		WORD   iVertPosition,
		WORD   iWidth,            // dimensions of bitmap if changing size
		WORD   iHeight
)
	MEWTOOLS 219;

IMPORT WORD RebuildMEWButton(
		WORD		hCurrentWindow,				// handle of window making call
		WORD     iRefType,             // type of reference to button
		ASCIIZ  lpszNewButtonRef,     // new name of bitmap to display
		WORD		hButtonWindowHandle,	// handle of btn wnd being replaced
		DWORD		dwWstyle,
		DWORD		dwMEWstyle,
		WORD   iControlID,
		WORD     iHorzPosition,
		WORD     iVertPosition,
		WORD     iWidth,
		WORD     iHeight

)
	MEWTOOLS 218;


// ***********************************************************************

// These are the do-all routines
//  (buildmewbutton and rebuildmewbutton are fixed subset)

//      Bitmapped Buttons that combine text and bitmaps
//      (use the MEWBTN_TEXTANDBITMAP to display bitmap and text)

// see below for example:

IMPORT WORD BuildMEWComboButton(
		WORD		hCurrentWindow,
		WORD     iRefType,         // type of the button reference (see next var)
		ASCIIZ  lpszButtonRef,    // reference to button to load
		ASCIIZ  lpszAccelLabel,   // accelerator key  label (e.g. "&Show ME"
		DWORD		dwWstyle,					// windows style attributes
		DWORD		dwMEWstyle,				// styles specified to these controls
		WORD   iControlID,         // unique child window identifier
		WORD   iHorzPosition,
		WORD   iVertPosition,
		WORD   iWidth,            // control width
		WORD   iHeight,           // control height

		// change the background color of bitmap
		// draw bitmap with transparent background
		// OR in MBCS_TRANSPARENT or MBCS_BKCOLOR with dwMEWstyle argument
		// (only MBCS_TRANSPARENT works at the moment)

		WORD   colorIndex,        // index into palette
		DWORD  colorReference,    // rgb color value

		WORD    hFontToUse,       // font to display text in
		INT     iTxtWidthLimit,   // can be 0 for sizetobitmap style
		INT     iTxtHeightLimit,  // can be 0 for sizetobitmap style
															// (control width and height are used)
		INT     iTxtOrientation   // MBT_TOP | MBT_BOTTOM | MBT_LEFT | MBT_RIGHT
)
	MEWTOOLS 217;

IMPORT WORD BuildMEWComboButtonInt(
		WORD		hCurrentWindow,
		WORD     iRefType,         // type of the button reference (see next var)
		INT     intButtonRef,     // reference to button to load
		ASCIIZ  lpszAccelLabel,   // accelerator key  label (e.g. "&Show ME"
		DWORD		dwWstyle,					// windows style attributes
		DWORD		dwMEWstyle,				// styles specified to these controls
		WORD   iControlID,         // unique child window identifier
		WORD   iHorzPosition,
		WORD   iVertPosition,
		WORD   iWidth,            // control width
		WORD   iHeight,           // control height

		// change the background color of bitmap
		// draw bitmap with transparent background
		// OR in MBCS_TRANSPARENT or MBCS_BKCOLOR with dwMEWstyle argument
		// (only MBCS_TRANSPARENT works at the moment)

		WORD   colorIndex,        // index into palette
		DWORD  colorReference,    // rgb color value

		WORD    hFontToUse,       // font to display text in
		INT     iTxtWidthLimit,   // can be 0 for sizetobitmap style
		INT     iTxtHeightLimit,  // can be 0 for sizetobitmap style
															// (control width and height are used)
		INT     iTxtOrientation   // MBT_TOP | MBT_BOTTOM | MBT_LEFT | MBT_RIGHT
)
	MEWTOOLS 217;

IMPORT WORD RebuildMEWComboButton(
		WORD		hCurrentWindow,				// handle of window making call
		WORD     iRefType,             // type of reference to button
		ASCIIZ  lpszNewButtonRef,     // new name of bitmap to display
		WORD		hButtonWindowHandle,	// handle of btn wnd being replaced
		ASCIIZ  lpszAccelLabel,
		DWORD		dwWstyle,
		DWORD		dwMEWstyle,
		WORD   iControlID,
		WORD     iHorzPosition,
		WORD     iVertPosition,
		WORD     iWidth,
		WORD     iHeight,
		WORD    colorIndex,
		DWORD   colorReference,
		WORD    hFontToUse,
		INT     iTxtWidthLimit,
		INT     iTxtHeightLimit,
		INT     iTxtOrientation

)
	MEWTOOLS 216;


/* ----------------------------------------------------------------------

 example usage with mew_dlgs macro functions:

		...
		main_dlg = Create_Mew_Dlg("About Multi-Edit for Windows",
																frame_handle, 0);

		int th =
			BuildMEWComboButton(
					main_dlg,
					MEWBTN_RT_RESNAME, "LOGO",
					"My&Logo is very plain ",       // text with accelerator identfier
					ws_visible | bs_pushbutton,
					MEWBTN_PUSHBUTTON |
					MEWBTN_SIZETOBITMAP |
					MEWBTN_TEXTANDBITMAP,           // make this combined text/bitmap
					100, 3, 3, 1, 1,
					0, 0,
					0, 0, 0,                        // 1st 0:  use current font,
					MBT_RIGHT);                     // position text right of bitmap

		int swin = Create_MEW_Ctrl( "STATIC", "", ... )
		...

*************************************************************************/



IMPORT BYTE DisableMEWButton( WORD  hMEWButton )
	MEWTOOLS 215;

IMPORT BYTE EnableMEWButton ( WORD  hMEWButton )
	MEWTOOLS 214;

/* GetStateOfMEWButton -------------------------------------------- *
	*		Returns current state of button:
	*
	*   see define's of possible button states earlier in file
	*
	* ---------------------------------------------------------------- */
IMPORT INT	GetStateOfMEWButton( WORD hMEWButton )
	MEWTOOLS 213;

IMPORT VOID SetStateOfMEWButton( WORD hMEWButton, INT StateToSet )
	MEWTOOLS 212;

IMPORT BYTE IsMEWButtonEnabled(WORD hMEWButton)
	MEWTOOLS 211;

IMPORT BYTE IsMEWButtonDisabled(WORD hMEWButton)
	MEWTOOLS 210;

IMPORT BYTE IsMEWButtonSelected(WORD hMEWButton)
	MEWTOOLS 209;

IMPORT BYTE IsMEWButtonStatic(WORD hMEWButton)
	MEWTOOLS 208;

IMPORT BYTE HideMEWButton(WORD hMEWButton)
	MEWTOOLS 207;

IMPORT BYTE ShowMEWButton(WORD hMEWButton)
	MEWTOOLS 206;

IMPORT WORD GetBitmapBkColor( ASCIIZ lpszRef, INT iref ) MEWTOOLS 221;



/****************************************************************************/
/*
 *  SpinButton Interface
 *
 *
 *
 */

/**************************************************************************/

//Control-specific messages
#define MSM_HWNDASSOCIATESET  (WM_USER+1)
#define MSM_HWNDASSOCIATEGET  (WM_USER+2)
#define MSM_DWRANGESET        (WM_USER+3)
#define MSM_DWRANGEGET        (WM_USER+4)
#define MSM_WCURRENTPOSSET    (WM_USER+5)
#define MSM_WCURRENTPOSGET    (WM_USER+6)
#define MSM_FNOPEGSCROLLSET   (WM_USER+7)
#define MSM_FNOPEGSCROLLGET   (WM_USER+8)
#define MSM_FINVERTRANGESET   (WM_USER+9)
#define MSM_FINVERTRANGEGET   (WM_USER+10)
#define MSM_CRCOLORSET        (WM_USER+11)
#define MSM_CRCOLORGET        (WM_USER+12)


//Message API Functions
IMPORT HWND     MSHAssociateSet(HWND hWnd, HWND hWndAssociate)
				MEWTOOLS 301;
IMPORT HWND     MSHAssociateGet(HWND hWnd)
				MEWTOOLS 300;
IMPORT DWORD    MSDwRangeSet(HWND hWnd, WORD iMin, WORD iMax)
				MEWTOOLS 311;
IMPORT DWORD    MSDwRangeGet(HWND hWnd)
				MEWTOOLS 310;
IMPORT WORD     MSWCurrentPosSet(HWND hWnd, WORD iPos)
				MEWTOOLS 309;
IMPORT WORD     MSWCurrentPosGet(HWND hWnd)
				MEWTOOLS 308;
IMPORT BOOL     MSFNoPegScrollSet(HWND hWnd, BOOL fNoPegScroll)
				MEWTOOLS 307;
IMPORT BOOL     MSFNoPegScrollGet(HWND hWnd)
				MEWTOOLS 306;
IMPORT BOOL     MSFInvertRangeSet(HWND hWnd, BOOL fInvertRange)
				MEWTOOLS 305;
IMPORT BOOL     MSFInvertRangeGet(HWND hWnd)
				MEWTOOLS 304;
IMPORT TCOLORREF MSCrColorSet(HWND hWnd, WORD iColor, TCOLORREF cr)
				MEWTOOLS 303;
IMPORT TCOLORREF MSCrColorGet(HWND hWnd, WORD iColor)
				MEWTOOLS 302;



//Notification codes sent via WM_COMMAND from the control.
#define MSN_ASSOCIATEGAIN   1
#define MSN_ASSOCIATELOSS   2
#define MSN_RANGECHANGE     3


//Color indices for MSM_COLORSET/GET and MSCrColorSet/Get
#define MSCOLOR_FACE        0
#define MSCOLOR_ARROW       1
#define MSCOLOR_SHADOW      2
#define MSCOLOR_HIGHLIGHT   3
#define MSCOLOR_FRAME       4

#define CCOLORS             5

//Control specific styles.
#define MSS_VERTICAL        0x0001
#define MSS_HORIZONTAL      0x0002
#define MSS_NOPEGSCROLL     0x0004
#define MSS_TEXTHASRANGE    0x0008
#define MSS_INVERTRANGE     0x0010

/****************************************************************************/
