
prototype MEUTIL2 {
	int CheckPersistent( );
	int CheckBlock( );
	int CheckBuffer( );
	int CheckMarking( );
	int CheckNoMarking( );
	int CheckLineMarking( );
	int CheckColMarking( );
	int CheckStrMarking( );
	int CheckNIStrMarking( );

	int UndBlk( int InBlk, int Message, str Misc );
/******************************************************************************
  Function: Undents a marked block of text one tab stop.
  Entry   : int InBlk		 Will only undent when cursor is in block ( /I=1 )
 						int Message	 Show message ( /NM=1 no message )
						str Misc		 Not used use "" ( for future expansion )

  Exit    :	int
 							True 	= Block undented
							False	=	Block not undented
********************************************************************( ldh )***/

	int IndBlk( int InBlk, int Message, str Misc );
/******************************************************************************
  Function: Indents a marked block of text one tab stop.
  Entry   : int InBlk		 Will only indent when cursor is in block ( /I=1 )
 						int Message	 Show message ( /NM=1 no message )
						str Misc		 Not used use "" ( for future expansion )

  Exit    :	int
 							True 	= Block indented
							False	=	Block not indented
**********************************************************************(ldh)***/

	void SwitchToBuffer( int Buf_Num );
	void ShowClipboard( int Buf_Num );

	void Cut( int Buf_Num, str Flags );
/******************************************************************************
  Function: Copies, Moves and/or Appends text to a hidden buffer.
  Entry   : int Buf_Num		The buffer # (0 is the default) ( /B=# )
						str Flags			The operation flags
							/M    			- Move text (else copy text).
							/A    			-	Append text (else erase old buffer).
							/E    			- Erase buffer, perform no move or copy.
							/O=1 	 			- The marked block will be turned turned off after the
													  operation.
   						/I=1	 			- Cut block only if cursor in block (else cut line).
							/NM=1				- Show no messages
							/NEM=1		  - Will not end block marking
            	/NW=1   		- Windows version only.  Do NOT copy block of text
                    			  to Windows clipboard.
	Exit    : None.
********************************************************************( ldh )***/
}
