// $Header: /MeShare/Src/METAGS.S 81    3/29/96 11:16 Dan $

macro_file METAGS;

#include MEW.SH
#include windows.sh
#include mewlist2.sh
#include mew_dlgs.sh
#include dialog.sh
#include mewlib.sh
#include mew_btn.sh
#include mewhelp.sh
#include METOOLS.SH
#include STDDLGS.SH

#ifdef _Debug_
	#include DBUG.SH
	#include MSGLOG.SH
#endif

#define view_win_ctrl 		1003
#define file_list_ctrl 		1001
#define tag_list_ctrl 		1002
#define abort_ctrl 				1005
#define	load_ctrl 				101
#define	go_ctrl 					101
#define Done_ctrl 				102
#define Help_ctrl 				103
#define tag_list_width 		62
#define view_border_ctrl 	1103
#define id_TagPath				1104

#define TAGBROWSE_HELPLINK "BROWSE CURRENT FILE"
#define TAGPROMPT_HELPLINK "PROMPT FOR TAG"
#define METAGS_HELPLINK "MULTI-TAGS"
#define TAGLIST_HELPLINK "LIST TAGS"
#define TAGWILD_HELPLINK "WILDCARD TAG SCAN"
#define TAGCONFIG_HELPLINK "MULTI-TAGS CONFIGURATION"
#define TAGFIND_HELPLINK "FIND TAG UNDER CURSOR"

global {
	int h_tag_list "!mt_h_tag_list";
	int h_file_list "!mt_h_file_list";
	int h_view_win "!mt_h_view_win";
	int h_cur_focus "!mt_h_cur_focus";
	int g_h_main_dlg "!mt_h_main_dlg";
	int g_list_win_id "!mt_list_win_id";
	int g_h_path "!mt_h_path";
	int g_h_line "!mt_h_line";
	int g_h_file "!mt_h_file";
	int g_h_list "!mt_h_list";
  str g_tag_language "!mt_tag_language";
  int g_was_maximized "!mt_was_maximized";
}

/*-----------------09-18-91 03:28pm-----------------
 MULTI-TAGS
 Multiple language tagging.

 01-12-94 01:52pm [scm]
			Fixed wild-card tag scanning problem with navigating file/dir boxes
			and processing the correct files from the mask.  It should be noted
			that the DATA_IN type 20 field requires the /SDD and /MSK args to point
			to the correct fields, if used. They werent in this case.

 05-27-93 11:24am
			Fixed some addition C parsing problems.

 04-13-93 02:45am
			Revamped the C/C++ parsing.
			Added int,str,real,void function types to CMAC.
			Fixed bug with Next Tag.

 12-14-92 02:18pm DKF
			Added 'EVOLVE' as an XBASE type for Multi-Edit 6.xx specific Evolve

 12-01-92 10:22am TMJ
			Fixed several bugs.  Added tag prompt.

 08-31-92 10:45am DPC
			Separated structure type and name tags. Fixed bug in match routine
			that skipped the first character after a closing comment. Fixed a
			bug with subdirectory searches created in previous fix.  Fixed problems
			with '\' line continuation character used within a comment.

 07-17-92 08:42am DPC
			Made possible to parse multiple definitions using ',' separator and
			to parse int declarations using only 'signed' or 'unsigned'.  Fixed
			various little bugs.  Modified #define to accomodate \ line terminator.
			Modified to capture arrays of structures and typeless structures.

 07-15-92 08:11am DPC
			Fixed bug in db, dw and dd that was introduced by yesterdays fixes.

 07-14-92 02:47pm DPC
			Fixed problems created when transferring code from old version without
			checking what changed were made in new version.  Fixed problem with
			re-scanning of files in subdirectories.  Fixed problem with match_else
			routine with regard to #if defined() types.  Fixed problem with Borland
				extrn "C" {
			causing the borland windows.h file not to be scanned.

			All lines added or modified by BPC have //DPC comments.  Not all
			deleted lines are indicated.

 07-14-92 09:42am DPC
			Modified to handle equ, db, dw, dd for assembly code.  Also modified
			assembly to include tag type and have tags in same fields as C code.
			Modified to handle global variables, procedures returning procedure
			pointers, and typedefs of arrays, and procedures in C code.

 02-28-92 06:57pm
			Fixed 2 small bugs with Browse.

 11-03-91 04:21pm
			Added "BROWSE" box feature to "Find tag" and "Tag List".

 10-15-91 11:38am
			Modifed XBASE support to handle PROC and FUNC abbreviations
			Added Cross-Directoried tagging.

 09-23-91 04:40pm
			Added XBASE, PAL and ASM.

 09-20-91 03:31pm
			Added configuration dialog box.


 09-20-91 11:14am
			Added ability to define different tag files
			depending on the language being used.

 09-19-91 12:32pm
			Added ability to Delete single tags, or whole
			files from the tag database via the List
			dialog box.


 GLOBAL VARS:

global_str('TAG_F_' + language )
	This lets you assign tag files based on the
	language you are using.
	For example: set_global_str('TAG_F_C', 'C.TAG' );

		global_str('METAGS_FILE_NAME')
				This lets you change the default tag file name
				(METAGS.TAG).
 --------------------------------------------------*/


#define TG_Start_File "Ĵ "
#define TG_End_File " "
#define metags_version "1.1a"

#define tag_delimits word_delimits + ".->="
//#define tag_language caps( parse_str( '|127LS=', global_str( '.' + get_extension(file_name))))
#define tag_format_line "                                                         "


str Tag_Get_Language( str Ext )
{
	str TStr = Caps( Parse_Str( "\x7F" + "LS=", Global_Str( '.' + Ext ) ) );

	if ( !Svl( TStr ) ) {

		int Active_Window = Window_Id;

		Create_Window;
		File_Name = "______." + Ext;
		Rm( "ExtSetup" );
		Delete_Window;
		Switch_Win_Id( Active_Window );
		TStr = Caps( Parse_Str( "\x7F" + "LS=", Global_Str( '.' + Ext ) ) );
	}
	return( TStr );

}  // Tag_Get_Language

int tag_file_locked() trans {
	int ret_val = 0;
	int dlg;
	DlgCreate( dlg );
	DlgAddCtrl( dlg, DLG_ICON,"IC_STOP", 1,1, 0,0, 1100, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"The tag file " + truncate_path(file_name) + " is locked.", 8,2, 0,0, 1000, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"You cannot add/update tags in",
											8,DLG_PosOffset + 2, 0,0, 1001, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"this file unless you unlock it.",
											DLG_PosOffset,DLG_PosOffset + 1, 0,0, 1002, 0, "" );

	DlgAddCtrl( dlg, DLG_ICON,"IC_QUESTION", 1,DLG_POSOFFSET + 2, 0,0, 1101, 0, "" );
	DlgAddCtrl( dlg, DLG_Static,"Do you want to unlock this tag file?",
											8,DLG_PosOffset + 1, 0,0, 1003, 0, "" );
	DlgAddCtrl( dlg, DLG_PushButton,"&Yes", 1,DLG_POSOFFSET + 2, 8,0, 100, DLGF_DefButton, "/R=1" );
	DlgAddCtrl( dlg, DLG_PushButton,"&Ignore", DLG_PosOffset + 10,DLG_POSOFFSET, 8,0, 101, 0, "/R=3" );
	DlgAddCtrl( dlg, DLG_PushButton,"Cancel", DLG_PosOffset + 10,DLG_POSOFFSET, 8,0, 102, 0, "/R=0" );
	DlgAddCtrl( dlg, DLG_PushButton,"&Help", DLG_PosOffset + 13,DLG_POSOFFSET, 8,0, 103, 0, "/R=2" );

	ret_val = DlgExecute( dlg, 100, "Warning!", "", "", DLG_ScreenCenter );

	DlgKill( dlg );
	if (ret_val == 1) {
		Cur_File_Attr &= 0xFE;
		Read_Only = False;
	}
	RETURN(ret_val);
}

macro Tag_Find_File
/* ************************************************************************
 * Locates and/or loads the correct tag file for the current file
 *
 * Parameters:
 * 							/C=1		Create new tag file and file specifier
 * 											 if old one not found.
 * 							/F=1		Move cursor to file specifier for current file
 *              /TF=str Overide the tag filename to use
 *              /FN=str Overide the current window filename to use
 *              /DT=int Date/time to use.
 *
 * Returns:
 * 							RETURN_INT = 1  if successful
 * 												 = 0  if not
 *
 * ********************************************************************** */
{
	str Fn[128] = Parse_Str( "/FN=", MParm_Str );
	str	Fp[80],
			Tag_File_Name[128] = Parse_Str( "/TF=", MParm_Str ),
			Ls[80], sTime[2];

	int F = Parse_Int( "/F=", MParm_Str ),
			C = Parse_Int( "/C=", MParm_Str ),
			Lft, J1, J2, J3, Jx;

	Rm( "Tag_Init" );

	if ( Svl( Fn ) == 0 ) {
		Fn = File_Name;
	}
	Ls = Tag_Get_Language( Get_Extension( Fn ) );
	if ( ( Tag_File_Name == "" ) && ( Caps( Truncate_Path( File_Name ) ) == "OBJTREE.TMP" ) ) {
		Tag_File_Name = Parse_Str( "/TF=", Global_Str( "@OBJ_TREE_PARMS@" ) );
	}
	if ( Svl( Tag_File_Name ) == 0 ) {
	 	Tag_File_Name = Global_Str( "TAG_F_" + Ls );
	}
	if ( Svl( Tag_File_Name ) == 0 ) {
		Tag_File_Name = Global_Str( "MeTags_File_Name" );
		if ( Svl( Tag_File_Name ) == 0 ) {
			Tag_File_Name = "METAGS.TAG";
		}
	}
	Return_Int = True;
	Tag_File_Name = FExpand( Tag_File_Name );
	if ( !Switch_File( Tag_File_Name ) ) {
		Set_Global_Int( "~OBJ_TREE_BUILD", 1 );
		Switch_Window( Window_Count );
		Create_Window;
		Load_File( Tag_File_Name );
		if ( Error_Level != 0 ) {
			File_Name = Tag_File_Name;
		}
		Error_Level = 0;
		Return_Int = True;
	}

	if ( Read_Only ) {
		if ( Tag_File_Locked( ) == 0 ) {
			Return_Int = 0;
			goto Exit;
		}
		return_int = 1;
	}

	Format_Line = Tag_Format_Line;
	Return_Str = Truncate_Path( Fn );
	Fp = FExpand( Get_Path( Fn ) );

	if ( F || C ) {
		Tof;

	Search_Again:
		if ( Find_Text( "^" + TG_Start_File + Return_Str + " ", 0, _RegExp ) ) {
			Ls = Parse_Str( "\xFE" + "PATH=", Get_Line( ) );
			if ( Svl( Ls ) && ( Caps( Ls ) != Caps( Fp ) ) ) {
				Eol;
				goto Search_Again;
			}
			if ( C ) {
				Block_Begin;
				Down;
				if ( Find_Text( "^" + TG_Start_File, 0, _RegExp ) ) {
					Up;
				}
				else {
					Eof;
				}
				Block_End;
				Delete_Block;
			}
			Return_Int = TRUE;
		}
		else {
			Return_Int = FALSE;
		}
	}
	if ( C ) {
		Eof;
		if ( C_Col > 1 ) {
			Goto_Col( 1 );
			Forward_Till_Not( " " );
			if ( Cur_Char != "\xFE" ) {
				Down;
				Goto_Col( 1 );
			}
		}
		if ( C_Line > 1 ) {
			Put_Line("                                                            \xFE");
			Down;
		}

		Lft = Parse_Int( "/DT=", MParm_Str );
		if ( Lft == 0 ) {
			Lft = GetFileTime( Fn );
		}
		Fn = Return_Str;
		if ( Lft != 0 ) {
			Jx = Lft & 0xFFFF;
			J1 = Jx >> 11;
			J2 = ( Jx >> 5 ) & 0x3F;
			Return_Str = Make_Time_Str( J1, J2, 0 );
			J3 = 6;
			// this code supports all Windows time formats
			GetProfileString( "intl", "sTime", ":", sTime, 2 );
			if ( XPos( sTime, Return_Str, 1 ) == 2 ) {
				J3 = 5;
			}
			Return_Str = Str_Del( Return_Str, J3, 3 );

			Jx = Lft >> 16;
			J1 = ( Jx >> 9 ) + 1980;
			J2 = ( Jx >> 5 ) & 0x0F;
			J3 = ( Jx & 31 );
			Return_Str = Make_Date_Str( J1, J2, J3 ) + " " + Return_Str;
		}
		else {
			Return_Str = Str_Del( Time, 6, 3 );
			GetProfileString( "intl", "sTime", ":", sTime, 2 );
			if ( XPos( sTime, Return_Str, 1 ) == 2 ) {
				Return_Str = Str_Del( Time, 5, 3 );
			}
			Return_Str = Date + " " + Return_Str;
		}
		Pad_Str( Fn, 13, " " );

		if ( Parse_Int( "/SP=", Global_Str( "METAGS_CONFIG" ) )  ) {
			Tag_File_Name = "\xFE" + "PATH=" + Fp;
		}
		else {
			Tag_File_Name = "";
		}
		Put_Line( TG_Start_File + Fn + TG_End_File + "" + TG_Start_File +
				Return_Str + TG_End_File + "\xFE" + "DT=" + Str( Lft ) +
				Tag_File_Name );
		Down;
		Return_Int = TRUE;
	}
	Window_Attr = 0x81;

Exit:

}  // Tag_Find_File

int Tag_Browse_Init( int Src_Win, int Work_Win ) trans2
{

	Working;
	Switch_Win_Id( Src_Win );
	Rm( "Tag_Find_File /F=1" );
	Working;
	if(!return_int) {
		switch_win_id( src_win );
		rm("tag_update");
		make_message("");
		working;
		rm("tag_find_file /F=1");
		if(!return_int) {
			rm("messagebox /B=2/T=ERROR/M=Unable to find or build tag table.");
			RETURN(0);
		}
	}
	block_begin;
	eol;
	if ( !Find_Text( "^" + TG_Start_File, 0, _RegExp ) ) {
		Eof;
	}
	else
		up;
	block_end;

	int tag_win = cur_window;
	switch_win_id(work_win);
	window_copy( tag_win );
	block_off;
	down;
	RETURN(tag_win);
}

void tag_push_backtrk(str tag_language, backtrack_data) {

  return_str = backtrack_data;
  RM("HISTORY_LIST /NOCHECK=1/M=1/HISTORY=!MT_" + tag_language);
}

void tag_store_find(str tag_language, tag_str, backtrack_data) {

  set_global_str('LAST_TAG_FIND', tag_str);

  tag_push_backtrk(tag_language, backtrack_data);
}

str tag_init_backtrk() {
  int t_line, t_col, t_row, t_offset,
      x_line, x_col, x_row, x_offset;

	// "borrow" a random access mark
  Get_Mark_Record(1, 2, t_line, t_col, t_row, t_offset);
  Set_Mark(1);
  Get_Mark_Record(1, 2, x_line, x_col, x_row, x_offset);
  Set_Mark_Record(1, 2, t_line, t_col, t_row, t_offset);

  Return("FN=" + file_name +
         "LINE=" + str(x_line) +
         "COL=" + str(x_col) +
         "ROW=" + str(x_row) +
         "OFFSET=" + str(x_offset));
}

void Tag_Backtrack( ) {

  str Tag_Language = Tag_Get_Language( Get_Extension( File_Name ) );
	str FName;

  int Index = Parse_Int( "/#=", Global_Str("!MT_" + Tag_Language ) );
  int T_Line, T_Col, T_Row, T_Offset;
	int SavRefresh = Refresh;

  str Backtrack_Data = Global_Str( "!MT_" + Tag_Language + Str( Index ) );

//  make_message("[" + backtrack_data + "]");
  if ( ( Index > 0 ) && ( Svl( Backtrack_Data ) ) ) {

		Refresh = False;
		// remove previous tag from history list
    Rm( "History_List /M=2/HISTORY=!MT_" + Tag_Language );

    FName = Return_Str = Parse_Str( "\x7F" + "FN=", Backtrack_Data );
    if ( Switch_File( Return_Str ) ) {
			Rm( "Select_Window /BM=1/VIS=1" );
		}
		else {
      Rm( "LdFiles" );
    }
    if ( Caps( File_Name ) != Caps( FName ) ) {
      Rm( "MessageBox /B=1/T=Tag Backtrack/M=Can't find the file " + FName );
    }
		else {
			// "borrow" a random access mark move to
    	Get_Mark_Record( 1, 2, T_Line, T_Col, T_Row, T_Offset );
    	Set_Mark_Record( 1, 2,
      		Parse_Int( "\x7F" + "LINE=", Backtrack_Data ),
      		Parse_Int( "\x7F" + "COL=", Backtrack_Data ),
      		Parse_Int( "\x7F" + "ROW=", Backtrack_Data ),
      		Parse_Int( "\x7F" + "OFFSET=", Backtrack_Data ) );
    	Get_Mark( 1 );
    	Set_Mark_Record( 1, 2, T_Line, T_Col, T_Row, T_Offset );
    	Redraw;
		}
		Refresh = SavRefresh;
  }
	else if ( Svl( Tag_Language ) ) {
    Rm( "MessageBox /B=1/T=Tag Backtrack/M=No previous tag found for the " +
				Tag_Language + " language." );
  }
	else {
    Rm( "MessageBox /B=1/T=Tag Backtrack/M=No previous tag found for this file." );
  }
}  // Tag_Backtrack

macro Tag_Browse_File trans2
{
	int	Src_Win = Window_Id;
	int Tag_Win;
	int Work_Win = 0;
	int SavRefresh = Refresh;

  str Fn[ 80 ] = File_Name;
  str Backtrack_Data = Tag_Init_Backtrk( );
  str Tag_Language = Tag_Get_Language( Get_Extension( File_Name ) );

  g_Was_Maximized = IsZoomed( Window_Handle );

	Refresh = FALSE;

	Switch_Window( Window_Count );
	Create_Window;
	Format_Line = Tag_Format_Line;
	Work_Win = Window_Id;

	if ( Tag_Win = Tag_Browse_Init( Src_Win, Work_Win ) ) {

		int Dlg;
		int Scan_Ctrl = 110;

		DlgCreate( Dlg );

		DlgAddCtrl( Dlg, DLG_BitmapStatic, "BT_TAGS_100",
				5, dlg_Units + 4 ,
				0, 0,
				1100, 0, "" );

		DlgAddCtrl( Dlg, dlg_ListBox, "\x7F" + "NAME=/W=25" + "\x7F" + "TAG=/W=30",
				17, 1,
				tag_List_Width, 11,
				tag_List_Ctrl, 0, "/INCO=1/WIN=" + Str( Cur_Window ) );

		DlgAddCtrl( Dlg, dlg_PushButton, "Re-&scan file",
				1, 3,
				14, 0,
				scan_Ctrl, 0,
				"/R=/M=tag_brws_rescan /DLG=" + Str( Dlg ) + "/SWID=" + Str( Src_Win ) );
		DlgAddCtrl( Dlg, DLG_PushButton, "&Go", 1, dlg_units + 140, 14, 0, go_ctrl, Dlgf_DefButton, "/R=1");
		DlgAddCtrl( Dlg, DLG_PushButton, "Cancel", DLG_PosOffset + 17, DLG_PosOffset, 14, 0, done_ctrl, 0, "/R=0");
		DlgAddCtrl( Dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 46, DLG_PosOffset, 14, 0, help_ctrl, 0, "/R=2");

		if ( DlgExecute( Dlg, tag_List_Ctrl, "Browsing: " + Truncate_Path( Fn ),
				tagBrowse_Helplink, "/HOOK=Tag_Brws_Proc", 0 ) ) {

			Switch_Win_Id( Work_Win );
      Tag_Push_Backtrk( Tag_Language, Backtrack_Data );
      Rm( "Tag_Goto /SAVEZOOM=1/EB=0/OW=" + Str( Src_Win ) );
			Switch_Win_Id( Work_Win );
		}
		DlgKill( Dlg );
	}
	Switch_Window( Tag_Win );
	Block_Off;

Exit:
	if ( Switch_Win_Id( Work_Win ) ) {
		Delete_Window;
	}
	Switch_Win_Id( Src_Win );
	Rm( "Select_Window /BM=1/VIS=1" );
	Refresh = SavRefresh;

}  // tag_browse_file

int tag_Brws_Proc(int &retval, int window, message, wparam, lparam, str parms )
{
switch (message) {
	case WM_COMMAND :
		switch( wparam ) {
			case DLG_WCMD_INIT :
				// this message is similar to WM_INITDIALOG
				str mstr[16] = "TAG_LIST_XLATE";
				SendDlgItemMessageStr(window, tag_list_ctrl, WM_ML2_SETMACROPROC, 0, mstr);
				break;
		}
		break;
	}
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));
}


void tag_brws_rescan() {

	int main_dlg = parse_int('/DLG=', mparm_str ),
			h_main_dlg,
			src_win = parse_int("/SWID=",mparm_str),
			h_tag_list,
			tag_list_win,
			tag_list_win_id,
			active_window = window_id;
	struct DlgCtrl ctrl;
	Str ls[max_line_length] = menu_item_str( main_dlg, 1, 3 );

	switch_win_id(src_win);

	rm("tag_update");

	str_to_struct( ctrl, ls );
	h_Main_dlg = ctrl.whandle;
	h_tag_list = GetDlgItem(h_main_dlg, tag_list_ctrl);
	tag_list_win = SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0);
	switch_window(tag_list_win);
	tag_list_win_id = window_id;
	erase_window;

	if (tag_browse_init(src_win, window_id)) {
		// reset the display of the tag list
		switch_win_id(tag_list_win_id);
		eof;
		if (c_col == 1) {
			up;
		}
		SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_SETLISTBUF, cur_window ,0);
		ListSetCount (h_tag_list, c_line);
		RedrawWindow(h_tag_list, 0, 0, RDW_INVALIDATE);
		goto_line(2);
		goto_col(1);
		sendmessage(h_tag_list, LB_SETCURSEL, 1, 0);
		SetFocus(getdlgItem(h_main_dlg, go_ctrl));
		SetFocus(h_tag_list);
	}
	switch_win_id(active_window);
	return_int = 0;
}

macro Tag_Locate
/* ---------------08-22-91 10:03am-------------------
 * Grabs the word under the cursor and attempts to
 * locate it in the tag file.
 *
 * Parameters:
 *              /MAN=1   Prompt for tag text
 * 							/NEXT=1  Do not go to the top of the
 * 											 tag file, instead find the
 *                       next occurence of the last
 *                       tag locate.
 *              /FO=1    Just locate the spot in the
 *                       tag file, do NOT locate source
 *              /TF=filename  The tag filename to use
 *                        (do not auto determine)
 -------------------------------------------------- */
{
  str       tag_id = parse_str("/TAGID=",mparm_str),
            tag_language = tag_get_language(get_extension(file_name)),
            backtrack_data;

	int				src_win = window_id,
						tag_win,
            force_tag_id = (tag_id != ""),
						next_tag = parse_int("/NEXT=", mparm_str);
	int SavRefresh = Refresh;

  g_was_maximized = IsZoomed(window_Handle);

  backtrack_data = tag_init_backtrk();

Again:
	Refresh = False;
		// If we are doing a NEXT tag then do not start from the top,
		// and use the last tag instead of the current word
  if ((!next_tag) && (!force_tag_id)) {
		if( parse_int("/MAN=",mparm_str))
		{
			return_str = "";
			rm("USERIN^QUERYBOX /P=Enter Tag:/W=32/ML=80/T=Multi-Tags/H="+TAGPROMPT_HELPLINK);
			if( return_int <= 0 )
				goto exit;
		}
		else
		{
			rm("tag_parse_text");
		}
		tag_id = return_str;
		if( tag_id == "" ) {
			make_message( "No valid tag." );
			switch_win_id( src_win );
			goto exit;
		}
	}

	rm( 'tag_find_file /TF=' + parse_str("/TF=", mparm_str) );
	if( !return_int ) {
			make_message( 'No tag file found.' );
			switch_win_id( src_win );
			goto exit;
	}

  if (!next_tag) {
		tof;
	}
	else {
		tag_id = global_str( 'LAST_TAG_FIND' );
		eol;
	}
	ignore_case = TRUE;
	reg_exp_stat = TRUE;
	if ( Find_Text( "^" + Tag_Id + "[ \t]", 0, _RegExp ) ) {
    if ( !Next_Tag ) {
      mark_pos;
			// check for multiple occurances of the same tag
      eol;
      if ( Find_Text( "^" + Tag_Id + "[ \t]", 0, _RegExp ) ) {
				// There are multiple tags, begin creating a list dialog box
        goto_mark;
        str tag_data;
        int t_tag_window = window_id,
            tag_count = 0;
        switch_window(window_count);
        create_window;
        int list_window = cur_window,
            accept_flag = 1,
            t_line;
        window_attr = 0x81;
        switch_win_id(t_tag_window);
        while ( Find_Text( "^" + Tag_Id + "[ \t]", 0, _RegExp ) ) {
          mark_pos;
          t_line = c_line;
          if( search_bwd( '%' + TG_Start_File, 0 ) ) {
            forward_till_not('Ĵ ');
            Put_Line_To_win("FILE=" + parse_str("PATH=", get_line) +
                            get_word(' ') + "LINE=" + str(t_line),
                            ++tag_count, list_window, 0);
            goto_mark;
          } else {
            goto_mark;
          }
          eol;
        }
        switch_window(list_window);
        tof;
        if (!at_eof) {
					// OK, we now have a list of tags
          int dlg;
          DlgCreate(dlg);
          DlgAddCtrl(dlg,Dlg_ListBox,"FILE=/W=100", 1, 1, 80, 11,
                     tag_list_ctrl,0,'/WIN='+str(cur_window));
          DlgAddCtrl( dlg, DLG_PushButton, "&Go", 1, dlg_units + 140, 14, 0, go_ctrl, Dlgf_DefButton, "/R=1");
          DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + 17, DLG_PosOffset, 14, 0, done_ctrl, 0, "/R=0");
          DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 46, DLG_PosOffset, 14, 0, help_ctrl, 0, "/R=2");


          if (DlgExecute( dlg, tag_list_ctrl, "Select Desired Instance of: " + tag_id, "", "", 0)) {
            accept_flag = true;
            int t_line = parse_int("LINE=",get_line);
            switch_win_id(t_tag_window);
            goto_line(t_line);
            switch_window(list_window);
          } else {
            accept_flag = 0;
          }
        }
        delete_window;
        switch_win_id(t_tag_window);
        if (!accept_flag) {
          switch_win_id(src_win);
          goto EXIT;
        }
      } else {
        goto_mark;
      }

    }

    Tag_Store_Find( Tag_Language, Tag_Id, Backtrack_Data );

		Return_Int = 1;
		if ( !parse_int("/FO=", mparm_str )) {
/*
make_message("tag_locate " + str(g_was_maximized) + " " + file_name);
read_key;
*/
      RM('tag_goto /SAVEZOOM=1/OW=' + str( src_win ));
			if( return_int == 2  )
			{
				next_tag = TRUE;
				goto again;
			}
		}
	} else {
		make_message( 'No tag found.' );
		switch_win_id( src_win );
		return_int = 0;
	}

Exit:
	Refresh = SavRefresh;

}  // Tag_Locate

macro tag_parse_text
{
	str ls[40] = tag_get_language(get_extension(file_name));

	mark_pos;

again:
	return_str = "";
	right;
	while( (c_col > 1) && xpos(cur_char, tag_delimits, 1) )
		left;
	while( (c_col > 1) && !xpos(cur_char, tag_delimits,1) )
		left;
	/*
	if(( ls == "C") || (ls == "C++") ) {
		if( cur_char == "." ) {
			left;
			while( (c_col > 1) && !xpos(cur_char, tag_delimits,1) )
				left;
			if( xpos(cur_char, tag_delimits,1 ))
				right;
			return_str = shorten_str(get_word( tag_delimits )) + ".";
		}
	}
	*/
	if( xpos(cur_char, tag_delimits,1 ))
		right;
	return_str += shorten_str(get_word( tag_delimits ));
	if( return_str == "" ) {
		word_right;
		if( !at_eol ) {
			return_str = shorten_str( get_word( tag_delimits ) );
		}
	}
	if( (ls == 'C') || (ls == 'C++') ) {
		if( xpos( ' ' + return_str + ' ', ' class struct union int void typedef ', 1 ) ) {
			word_right;
			while( at_eol && !at_eof )
				word_right;
			goto again;
		}
	}
	goto_mark;
}

macro tag_goto
{
	int Eb 						 = Parse_Int( "/EB=", Global_Str( "METAGS_CONFIG" ) );
	int Vw 						 = Parse_Int( "/VW=", MParm_Str );
	int Create_Overide = Parse_Int( "/CR=", MParm_Str );
	int NoBrief 			 = Parse_Int( "/NB=", MParm_Str );
	int TWin 					 = Parse_Int( "/OW=", MParm_Str );
	int Jx;
	int SavRefresh = Refresh;

	int old_win = 0,
			result = 0,
      t_win_id = window_id,
      use_path = FALSE,
      create_flag = 0,
      Save_Zoom_State = Parse_Int( "/SAVEZOOM=", MParm_Str ) &&
                        Global_Int( "@Maximize_Windows" );
	str Ls[ 80 ];
	str Fn[ 80 ];
	str Tag_Id[ 80 ];
	str	Tag_Str;
	str	TStr;
	str	SStr;

	Working;
	Mark_Pos;
	if ( XPos( "/EB=", MParm_Str, 1 ) ) {
		Eb = Parse_Int( "/EB=", MParm_Str );
	}
	if ( Find_Text( "^" + TG_Start_File, 0, _RegExp | _Backward ) ) {
		forward_till_not('Ĵ ');
		fn = get_word(' ');
		fn = parse_str("PATH=", get_line ) + fn;
		if ( Get_Path( Fn ) != "" ) {
			use_path = TRUE;
		}
	}
	Goto_Mark;
	First_Word;
	Tag_Id = Get_Word( ' |9|255' );

	goto_col( 42 );
	forward_till( ' |9|255' );
	forward_till_not(' |9|255');
	if( cur_char == '' ) {
		right;
		forward_till('');
		right;
		forward_till_not(' |9|255');
	}
	mark_pos;
	tag_str = shorten_str( get_word('') );		// Get the literal string

	goto_mark;
	sstr = '';																// Now parse the search string
	while( !at_eol ) {
		SStr = SStr + Make_Literal( Get_Word( " \t\xFF" ) );
		if ( !at_eol ) {
			if( cur_char == ' ' ) {
				right;
				if( !xpos( cur_char, ' |9|255', 1 ) ) {
					sstr = sstr + ' ';
					continue;
				}
			}
			forward_till_not(' |9|255' );
			if ( !At_Eol ) {
				sstr  = sstr + '[ |9|255]+';
			}
		}
	}
	goto_col(1);
	jx = 1;
	crunch_tabs( tag_str, jx );
	tabs_to_spaces( tag_str );
	tag_str = remove_space( tag_str );

	switch_win_id( twin );
  if ( Caps( Truncate_Path( File_Name ) ) == Caps( Truncate_Path( Fn ) ) ) {
    if ( !Use_Path || ( Caps( Get_Path( File_Name ) ) == Caps( Get_Path( Fn ) ) ) ) {
			Old_Win = Cur_Window;
			goto Skip_Win_Search;
		}
	}
	for ( jx = 1; jx <= window_count; jx++ ) {
		switch_window( jx );
		if ( !( Window_Attr & 0x80 ) ) {
			if ( Caps( Truncate_Path( File_Name ) ) == Caps( Truncate_Path( Fn ) ) ) {
				if ( !Use_Path ||
						( Caps( Get_Path( File_Name ) ) == Caps( Get_Path( Fn ) ) ) ) {
					Old_Win = Cur_Window;
					break;
				}
			}
		}
	}

Skip_Win_Search:
  if ( ( Vw == 0 ) || Create_Overide ) {
  	Create_Flag = 1;
    Rm( "CreateWindow /NV=1" );
  }
	else {
		Switch_Window( Vw );
	}
	if ( Old_Win != 0 ) {
		if ( Cur_Window != Old_Win ) {
			Link_Window( Old_Win );
		}
		Tof;
	}
	else {
		Make_Message( Str( Use_Path ) );
		Return_Str = Fn;
    Rm( "LdFiles /NB=1/NR=1" );
	}
	Reg_Exp_Stat = False;

	Result = 1;
	call Do_Search;
	if ( Eb ) {

    int Dlg,
        active_window = window_id,
        active_win_num = cur_window,
        list_win_num, list_win_id;

    str t_file_name = file_name;

    switch_window(window_count);
    create_window;
    list_win_num = cur_window;
    link_window(active_win_num);

		DlgCreate(dlg);

		DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_TAGS_100",
				4, 2,
				0, 0,
				1100, 0, "" );

		DlgAddCtrl( dlg, Dlg_ViewTextBox, "",
				DLG_StanBtnWidth + 3, 1,
				90, 15,
				view_win_ctrl, 0,
        "/WIN=" + Str( list_Win_Num ) );

		DlgAddCtrl( Dlg, DLG_PushButton, "N&ext",
				1, 4,
				DLG_StanBtnWidth, 0,
				101, 0,
				"/R=10" );

		DlgAddCtrl( Dlg, DLG_PushButton, "&Load",
				1, 6,
				DLG_StanBtnWidth, 0,
				105, 0,
				"/R=1" );

		DlgAddCtrl( Dlg, DLG_PushButton, "Close",
				Dlg_StanBtnWidth + 3,
				17, DLG_StanBtnWidth, 0,
				102, Dlgf_defButton,
				"/R=0" );

		DlgAddCtrl( Dlg, DLG_PushButton, "&Help",
				Dlg_PosOffset + 70, DLG_PosOffset,
				DLG_StanBtnWidth, 0,
				103, 0,
				"/R=2");

    Return_Int = DlgExecute( Dlg, view_Win_Ctrl, "Browsing: " + T_File_Name,
				TAGFIND_HELPLINK, "", 0 );
		DlgKill( Dlg );

    Delete_Window;
    Switch_Win_Id( Active_Window );
		Result = Return_Int;
		Refresh = FALSE;
		Result = 1;
		if ( Return_Int == 1 ) {
			if ( Old_Win ) {
				Mark_Pos;
				Delete_Window;
				Switch_Window( Old_Win );
				Goto_Mark;
			}
			else {
				Rm( "ExtSetup" );
			}
		}
		else {
			if ( Return_Int == 10 ) {
				Result = 2;
			}
			Delete_Window;
			Switch_Win_Id( TWin );
      if ( Save_Zoom_State ) {
        if ( !g_Was_Maximized ) {
          SendMessage( Client_Handle, WM_MDIRESTORE, Window_Handle, 0 );
				}
      }
		}
	}
	else {
		if ( Old_Win && ( !Vw || Create_Overide ) ) {
			Mark_Pos;
			delete_window;
			Switch_Window( Old_Win );
			Goto_Mark;
		}
	}
	Rm( "Select_Window /VIS=1/BM=" + Str( !NoBrief ) );
	goto Exit;


Do_Search:
		reg_exp_stat = TRUE;

		ls = caps( parse_str( '|127LS=', global_str( '.' + get_extension(fn))));

			// Special processing for Turbo-Pascal files
		if ((ls == "PASCAL") || (ls == "DELPHI")) {
			ignore_case = TRUE;
			if( parse_int("/PI=", global_str("METAGS_CONFIG") ) ) {
				if( ( caps(copy( sstr, 1, 8 )) == "FUNCTION") ||
						( caps(copy( sstr, 1, 9 )) == "PROCEDURE")) {
					if ( Find_Text( "IMPLEMENTATION", 0, 0 ) ) {

						int jy;

						tabs_to_spaces( sstr );
						sstr = remove_space( sstr );
						jx = xpos( " ", sstr, 1 );
						do
						{
							++jx;
							if( (jy = xpos(str_char(sstr,jx)," ;(", 1)) ) {
								sstr = copy( sstr, 1, jx );
							}
						} while((jy == 0) && (jx < svl(sstr)));
						if( search_fwd( sstr, 0 ) ) {
							make_message( "Tag found" );
							ret;
						}
						goto second_shot;
					}
				}
			}
		}
		while( search_fwd( sstr, 0 ) ) {
			jx = c_col;
			first_word;
			if( jx != c_col ) {
				eol;
				continue;
			}

			if( length( tag_str) >= 128 ) {
				make_message("Tag found");
				ret;
			}
			mark_pos;
			tstr = get_word('');
			goto_mark;
			crunch_tabs( tstr, jx );
			tabs_to_spaces( tstr );
			if( length( remove_space( tstr) ) == length( tag_str ) ) {
				make_message("Tag found");
				ret;
			}
			eol;
		}

Second_Shot:
		tof;
		while( search_fwd( tag_id, 0 ) ) {
			if( c_col > 1 ) {
				left;
				if( !xpos(cur_char, '|9|255 ~!@#$%^&*()_+||-=\{}[]:;''",.<>/?', 1) ) {
					right; right;
					continue;
				}
				right;
			}
			mark_pos;
			goto_col( c_col + length(tag_id) );
			if( !at_eol ) {
				if( !xpos(cur_char, '|9|255 ~!@#$%^&*()_+||-=\{}[]:;''",.<>/?', 1) ) {
					goto_mark;
					right;
					continue;
				}
			}
			goto_mark;
			make_message("Tag string not found, found Tag ID instead.");
			ret;
		}
	ret;


Exit:
  if ( Parse_Int( "/SAVEZOOM=", MParm_Str ) )  {
    Rm( "Select_Window" );
  }
	return_int = result;
	reg_exp_stat = true;
	RedrawWindow( Frame_Handle, 0, 0, RDW_INVALIDATE | RDW_ALLCHILDREN);
	Refresh = SavRefresh;

}  // Tag_Goto

macro Tag_Update {

	if ( File_Changed ) {
		Save_File;
		if ( Error_Level ) {
			Rm( "MeError" );
		}
	}

	int ActiveWin = Cur_Window;
	int FileTime 	= GetFileTime( File_Name );
	int TagTime;
	int SavRefresh = Refresh;

	Refresh = False;
	Rm( "Tag_Find_File /F=1" );
	if ( Return_Int ) {
		TagTime = Parse_Int( "\xFE" + "DT=", Get_Line( ) );
		if ( FileTime > TagTime ) {
			Switch_Window( ActiveWin );
			Rm( "Tag_Build" );
			Make_Message( "Tags updated." );
		}
		else {
			Make_Message( "File does not require updating." );
		}
	}
	else {
		Switch_Window( ActiveWin );
		Rm( "Tag_Build" );
	}
	Switch_Window( ActiveWin );
	Refresh = SavRefresh;

}  // Tag_Update

void tag_build_flist(int file_list_num) {
	int f_count;
	str p;

		mark_pos;
		tof;
		reg_exp_stat = true;
		ignore_case = FALSE;
		f_count = 0;
		while ( Find_Text( "^" + TG_Start_File, 0, _RegExp ) ) {
			++f_count;
//			line_changed = FALSE;
//			line_attr = cb_s_color;
/*
 RM("MEERROR^MESSAGEBOX /T=TAG_BUILD_FLIST/M=[" + get_line + "]");
*/
			return_str = get_line;
			p = parse_str('|254PATH=', return_str);
			return_str = shorten_str( copy( return_str, 5, 12 ) );
			put_line_to_win( return_str +
					'                                      |127L=' +
					str(c_line) + '|127P=' + p, f_count, file_list_num, false );
			down;
			goto_col( 1 );
		}
		goto_mark;
}

macro tag_list
/*-----------------09-18-91 12:51pm-----------------
 Brings up a list box of the current tag file.
 --------------------------------------------------*/
//  no_break
	trans2
{
	int active_window = window_id,
			t_undo_stat = undo_stat,
			tag_ctrl = 104,
			delete_ctrl = 105,
			view_ctrl = 106,
			update_ctrl = 107,
			dlg,
			file_List_win = 0,
			tag_list_win = 0,
			view_win = 0,
			file_List_num,
			tag_list_num,
			view_num,
			t_refresh = refresh,
			f_count,
			jx,
			tl;

	str fn = file_name,
      p,
      backtrack_data;

	refresh = false;

  g_tag_language = tag_get_language(get_extension(fn));

  backtrack_data = tag_init_backtrk();

	Rm( "Tag_Find_File" );

	if (return_int) {
		tag_list_win = window_id;
		tag_list_num = cur_window;

		switch_window(window_count);
		create_window;
		file_list_win = window_id;
		file_list_num = cur_window;
/*
		create_window;
		tag_list_win = window_id;
		tag_list_num = cur_window;
*/
		create_window;
		view_win = window_id;
		view_num = cur_window;
		switch_win_id(Tag_list_win);
/*
messagebeep(-1);
make_message("Tag_list_win=" + str(window_id));
read_key;
*/
		TAG_BUILD_FLIST(file_list_num);
/*
		mark_pos;
		tof;
		reg_exp_stat = true;
		ignore_case = FALSE;
		f_count = 0;
		while( search_fwd( "%" + TG_Start_File , 0 ) ) {
			++f_count;
			line_changed = FALSE;
			line_attr = cb_s_color;
			return_str = get_line;
			p = parse_str('|254PATH=', return_str);
			return_str = shorten_str( copy( return_str, 5, 12 ) );
			put_line_to_win( return_str + '                                      |127L=' + str(c_line) + '|127P=' + p, f_count, file_list_num, false );
			down;
			goto_col( 1 );
		}
		eof;
		jx = c_line;
		tof;
		goto_mark;
*/

		ignore_case = TRUE;
		switch_window( file_list_num );
		tof;
		Find_Text( "^" + Truncate_Path( Fn ) + " ", 0, _RegExp );
		switch_window( tag_list_num );
		goto_col(1);

		DlgCreate( dlg );
		switch_win_id(tag_list_win);

		DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_TAGS_100", 6, 3, 0,0, 1100, 0, "" );

		DlgAddCtrl( dlg, DLG_Static, "&Files:", 19, 1, 0, 0, 1101, 0, "" );
		DlgAddCtrl(dlg,Dlg_ListBox,"",
					dlg_negoffset + 2, dlg_posOffset + dlg_units + 9,
					23,6,
					file_list_ctrl,0,
					'/INCO=1/WIN='+str(file_list_num));

		DlgAddCtrl( dlg, DLG_Static, "&Tags:", 44, 1, 0, 0, 1102, 0, "" );
		DlgAddCtrl(dlg,Dlg_ListBox,"NAME=/W=25TAG=/W=30",
					dlg_negoffset + 2, dlg_posOffset + dlg_units + 9,
					tag_list_width,6,
					tag_list_ctrl,0,
					'/INCO=1/WIN='+str(tag_list_num));

		DlgAddCtrl( dlg, DLG_Static, "V&iew:", 18, dlg_units + 88, 0, 0, view_border_ctrl, 0, "" );
		DlgAddCtrl(dlg,Dlg_ViewTextBox,"",
					dlg_negoffset + 1, dlg_posOffset + dlg_units + 9,
					87,8,
					view_win_ctrl,0,
					'/WIN='+str(view_num));

		DlgAddCtrl( Dlg, dlg_Static, "Path:",
				43, dlg_NegOffset | dlg_Units + 10,
				0, 0,
				200, 0, "" );
		DlgAddCtrl( Dlg, DLG_Static, "",
				dlg_PosOffset + 6, dlg_PosOffset + 0,
				tag_list_width - 6, 0,
				id_TagPath, 0, "" );

		DlgAddCtrl( dlg, DLG_PushButton, "&Load", 1, 9, 14, 0, load_ctrl, 0, "/R=1");
		DlgAddCtrl( Dlg, DLG_PushButton, "Ta&g File",
				Dlg_PosOffset, DLG_PosOffset + dlg_units + 20,
				14, 0,
				tag_ctrl, 0,
				"/R=/M=TAG_LIST_TF /DLG=" + str(dlg));

		DlgAddCtrl( Dlg, DLG_PushButton, "&Delete",
				Dlg_PosOffset, DLG_PosOffset + dlg_units + 20,
				14, 0,
				delete_ctrl, 0,
				"/R=/M=tag_list_display /XM=1/DLG=" + str(dlg));

		DlgAddCtrl( Dlg, DLG_PushButton, "&Update tags",
				Dlg_PosOffset, DLG_PosOffset + dlg_units + 20,
				14, 0,
				update_ctrl, 0,
				"/R=/M=tag_list_ut /DLG=" + str(dlg));

		DlgAddCtrl( dlg, DLG_PushButton, "&View",
				1, dlg_units + 198,
				14, 0,
				view_ctrl, Dlgf_DefButton,
				"/R=/M=tag_list_display /XM=2/VMN=3/VW=" + str( view_num ) +
				'/TW=' + str(tag_list_num) + '/FW=' + str(file_list_num) +
				'/DLG=' + str(dlg));
		DlgAddCtrl( dlg, DLG_PushButton, "Close", DLG_PosOffset + 17, DLG_PosOffset, 14, 0, done_ctrl, 0, "/R=0");
		DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 71, DLG_PosOffset, 14, 0, help_ctrl, 0, "/R=2");


		if (DlgExecute( dlg, file_list_ctrl, "Tags: " + file_name, TAGLIST_HELPLINK, "/HOOK=tag_MessageProc", 0)) {

      tag_push_backtrk(g_tag_language, backtrack_data);
			// need to know what dialog had focus right before load was selected
			if ((h_cur_focus == h_tag_list) || (h_cur_focus == h_file_list)) {
				rm('tag_list_display /XM=2/VMN=3/VW=' + str( view_num ) +
							'/TW=' + str(tag_list_num) +
							'/FW=' + str(file_list_num) +
							"/DLG=0"); // /DLG= MUST be 0 here
				switch_window( view_num );
				return_str = global_str("~TAG_VIEW_RO");
				if( parse_int("/BID=", return_str) == buffer_id ) {
					read_only = parse_int("/RO=", return_str );
				}
			}
			switch_window( view_num );
			mark_pos;
			if (link_stat) {
/*
beep;
make_message(str(window_id) + " " + file_name + " " + hex_str(window_attr));
read_key;
*/
				jx = 0;
				tl = buffer_id;
				while (jx++ < window_count) {
					switch_window( jx );
					if ((jx != view_num) && (buffer_id == tl)) {
						break;
					}
				}
//				Make_Window_Visible(1);
				Window_attr &= 0xFFFE;
/*
beep;
make_message(str(window_id) + " " + file_name + " " + hex_str(window_attr));
read_key;
*/
			}
			else {
				rm("CREATEWINDOW");
				link_window( view_num );
				rm("EXTSETUP");
			}
/*
			jx = window_id;
			call cleanup;
			switch_win_id(jx);
*/
			goto_mark;
			active_window = window_id;
			RM("SETWINDOWNAMES");
		}
		DlgKill( dlg );
	}
	if (switch_win_id(file_list_win)) {
		delete_window;
	}
	if (switch_win_id(view_win)) {
		delete_window;
	}
	if (switch_win_id(tag_list_win)) {
		window_attr = 0x81;
//		delete_window;
	}
	undo_stat = t_undo_stat;
	switch_win_id(active_window);
	Rm( "Select_Window /BM=1/VIS=1" );
	refresh = t_refresh;

	h_tag_list =
	h_file_list =
	h_view_win =
	h_cur_focus = 0;

}  // tag_list

str tag_list_xlate(str disp_str)
{
	int t_pos = xpos("\xFE",disp_str,1);
	str t_str;

//	messagebeep(-1);

	if (t_pos) {
		if (t_pos == svl(disp_str)) {
//			disp_str = "\x7F@\xFE=THIS LINE INTENTIONALLY LEFT BLANK";
			disp_str = "\x7F@\xFE=~";
		} else {
			if (t_pos = xpos(" ",disp_str,1)) {
				t_str = remove_space(copy(disp_str, ++t_pos, 12));
				if (t_pos = xpos("\xB4 ",disp_str,t_pos)) {
					disp_str = copy(disp_str, t_pos + 2, 255);
					if (t_pos = xpos(" \xC3",disp_str,1)) {
						disp_str = "\x7F@\xFE=" + t_str + "     " + copy(disp_str,1,t_pos - 1);
					}
				}
			}
		}
	} else if (t_pos = xpos("\t",disp_str,1)) {

/*
		int dc, cur_mname_width;
		str t_str = copy(disp_str,1, t_pos - 1);

		dc = GetDc( g_h_main_dlg );
		Selectobject( dc, g_dlgfont );
		cur_mname_width = 0xFFFF & GetTextExtent(dc, t_str, svl(t_str));
		ReleaseDC( g_h_main_dlg, dc );

int xx = (tag_mname_width - cur_mname_width) / tag_space_width;
		disp_str =
				str(tag_mname_width - cur_mname_width) + " " +
				str(xx * tag_space_width) + " " +
				t_str +
			copy("                                                ", 1,
				(tag_mname_width - cur_mname_width) / tag_space_width)
			+ copy(disp_str, t_pos + 2, 255);
*/
		int t_pos2;
		t_str = copy(disp_str,1, t_pos - 1);
		if (t_pos2 = xpos("\t",disp_str,t_pos + 1)) {
			disp_str = "NAME=" + t_str +
								"TAG=" + copy(disp_str, t_pos + 1, t_pos2 - t_pos - 1);
		}
	}
	return(disp_str);
}

int tag_MessageProc(int &retval, int window, message, wparam, lparam, str parms )
{

	int t_focus = GetFocus();
	int SavRefresh = Refresh;

	if ((t_focus == h_tag_list) ||
			(t_focus == h_file_list) ||
			(t_focus == h_view_win)) {
		// this keeps track of which of the list/view windows was last looked at
		h_cur_focus = t_focus;
	}

	switch (message) {
		case WM_COMMAND :
			Refresh = False;
			switch( wparam ) {
				case DLG_WCMD_INIT :
					// this message is similar to WM_INITDIALOG
/*
// determine optimum width for macro name
		int dc,lh,fh,fw,dlgfont;

		Get_MEW_Dlg_Metrics (0, lh, fh,fw,dlgfont);
		g_dlgfont = dlgfont;
		dc = GetDc( window );
		Selectobject( dc, dlgfont );
		tag_mname_width = 0xFFFF & GetTextExtent(dc, "WWWWWWWWWWWWWWWW", 16);
		tag_space_width = 0xFFFF & GetTextExtent(dc, " ", 1);
		ReleaseDC( window, dc );
*/
/*
beep;
make_message(str(tag_mname_width) +
		" "  + str(tag_space_width) + " " + str(tag_mname_width / tag_space_width));
*/
					// set up global variables
					g_h_main_dlg = window;
					h_tag_list = GetDlgItem(window, tag_list_ctrl);
//				Subclass_With_Macro( h_tag_list, "Tag_Ctrl_Proc", "/ID=" + str(tag_list_ctrl));
					// set up special display macro for the tag list
        	str t_str[50] = "TAG_LIST_XLATE";
        	SendMessageStr(h_tag_list, WM_ML2_SETMACROPROC, 0, t_str);

					SetFocus(h_tag_list);
					// this gets around the problem of the list box "phantom" control
					h_tag_list = GetFocus();

					h_file_list = GetDlgItem(window, file_list_ctrl);
//				Subclass_With_Macro( h_file_list, "Tag_Ctrl_Proc", "/ID=" + str(file_list_ctrl));
					SetFocus(h_file_list);
					h_file_list = GetFocus();

					h_view_win = GetDlgItem(window, view_win_ctrl);
//				Subclass_With_Macro( h_view_win, "Tag_Ctrl_Proc", "/ID=" + str(view_win_ctrl));
					h_cur_focus = h_file_list;

					// this gets the 2 windows in synch
					RM("TAG_LIST_DISPLAY /XM=0" + parms);
/*
make_message("hcf=" + str(h_cur_focus) +
		" htl=" + str(h_tag_list) +
		" hfl=" + str(h_file_list) +
		" hvw=" + str(h_view_win));
*/
					SetFocus(t_focus);

					break;
				case tag_list_ctrl :
//				g_cur_ctrl = tag_list_ctrl;
					switch ( lparam >> 16 ) {
						case LBN_SELCHANGE :
							switch_window(SendDlgItemMessage(window, tag_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0));
							RM("TAG_LIST_DISPLAY /XM=4" + parms);
							break;
					}
					break;
				case file_list_ctrl :
//				g_cur_ctrl = file_list_ctrl;
					switch ( lparam >> 16 ) {
						case LBN_SELCHANGE :
							switch_window(SendDlgItemMessage(window, file_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0));
							RM("TAG_LIST_DISPLAY /XM=0" + parms);
							break;
					}
					break;
				case view_win_ctrl :
					switch_window(SendDlgItemMessage(window, view_win_ctrl, WM_ML2_GETLISTBUF, 0 ,0));
//				g_cur_ctrl = view_win_ctrl;
					break;
			}
			break;
	}
	Refresh = SavRefresh;
	return(DlgMessageProc(retval, window,message,wparam,lparam, parms ));

}

macro tag_list_display
/*-----------------09-18-91 12:51pm-----------------
 Used by "tag_list".
 --------------------------------------------------*/
	trans2
//  no_break
{

	int tw = parse_int('/TW=', mparm_str ),
			tw_id,
			fw = parse_int('/FW=', mparm_str ),
			cw = cur_window,
			dlg = parse_int('/DLG=', mparm_str ),
			hdlg = 0,
//			menu = parse_int('/MENU=', mparm_str ),
			vw = parse_int('/VW=', mparm_str ),
			tr = refresh,
			m = parse_int('/XM=', mparm_str), tx1,ty1,
			tundo = undo_stat,
			ee,
			jx,
			file_list_h,
			tag_list_h
			;
	str tstr[max_line_length], ps[60], fp[80];

	if (dlg) { // dlg will be 0 if we call this macro after we destroy the dialog box
		struct DlgCtrl ctrl;

		tstr = menu_item_str( dlg, 1, 3 );
		str_to_struct( ctrl, tstr );
		hdlg = ctrl.whandle;
		tag_list_h = GetDlgItem(hdlg, tag_list_ctrl);
		tw = SendMessage(tag_list_h, WM_ML2_GETLISTBUF, 0 ,0);
		file_list_h = GetDlgItem(hdlg, file_list_ctrl);
		fw = SendMessage(file_list_h, WM_ML2_GETLISTBUF, 0 ,0);

// we have to do this because h_cur_focus is the "phantom" window handle
//		jx = GetDlgCtrlId(h_cur_focus);
//		cw = SendMessage(GetDlgItem(hdlg, g_cur_ctrl), WM_ML2_GETLISTBUF, 0 ,0);

//beep;
//make_message("jx=" + str(jx) + " cw=" + str(cw) + " tw=" + str(tw) + " fw=" + str(fw));
/*
make_message("hcf=" + str(h_cur_focus) +
		" htl=" + str(h_tag_list) +
		" hfl=" + str(h_file_list) +
		" hvw=" + str(h_view_win));
*/
/*
make_message("hcf=" + str(GetDlgCtrlId(h_cur_focus)) +
		" htl=" + str(GetDlgCtrlId(h_tag_list)) +
		" tlh=" + str(GetDlgCtrlId(tag_list_h)) +
		" hfl=" + str(GetDlgCtrlId(h_file_list)) +
		" flh=" + str(GetDlgCtrlId(file_list_h)) +
		" hvw=" + str(GetDlgCtrlId(h_view_win)));
*/
//read_key;

	}
	Refresh = False;
	jx = window_id;
	switch_window(tw);
	tw_id = window_id;
	switch_win_id(jx);

	undo_stat = false;

	switch( m ) {
		case 0 :
//RM("MEERROR^MESSAGEBOX /B=2/T=TAG_LIST_DISPLAY/M=Case 0 is not implemented yet.");

			switch_window( fw );
			mark_pos;
			goto_col(1);
			tstr = get_word( ' |9|255' );
			jx = parse_int('|127L=', get_line );
			fp = parse_str('|127P=', get_line );

			SetDlgItemText( hDlg ,id_TagPath, Fp );
/*
beep;
make_message("fw=" + str(fw) + " tw=" + str(tw));
read_key;
*/
/*
messagebeep(-1);
make_message("tstr=" + tstr + " jx=" + str(jx) + " fp=" + fp);
read_key;
*/
			forward_till_not( ' |9|255' );
			goto_mark;
/*
beep;
make_message(str(window_id) + " " + str(cur_window) + " [" + get_line + "]");
read_key;
*/

			if( jx == 0 )
				eof;
			RedrawWindow(file_list_h, 0, 0, RDW_INVALIDATE);
			sendmessage(file_list_h, LB_SETCURSEL, c_line - 1, 0);
//      switch_window( tw );
			switch_win_id(tw_id);

			goto_line( jx );
			eol;
		sloop:
			if (search_bwd( '%' + TG_Start_File + tstr + ' ', 0 )) {
				Ps = Parse_Str( "\xFE" + "PATH=", Get_Line( ) );
				if ( ( Caps( Ps ) != Caps( Fp ) ) && ( C_Line > 1 ) ) {
					up;
					eol;
					goto sloop;
				}
			}
			down;
			int xx = c_line - 1;
//		  sendmessage(tag_list_h, LB_SETCURSEL, 0, 0);
			sendmessage(tag_list_h, LB_SETTOPINDEX, xx - 1, 0);
			RedrawWindow(tag_list_h, 0, 0, RDW_INVALIDATE);
//make_message(str(xx - 1));
			sendmessage(tag_list_h, LB_SETCURSEL, xx, 0);
/*
			refresh = true;
			redraw;
			write( '', wherex - 1, wherey, 0, l_color );
			pad_str( ps, 46, " " );
			make_message(ps);
*/
			break;

		case 4 :
//RM("MEERROR^MESSAGEBOX /B=2/T=TAG_LIST_DISPLAY/M=Case 4 is not implemented yet.");

			if( cw == tw ) {
/*
				if(check_key) {
					push_key(key1,key2);
					goto exit;
				}
*/
				call set_file;
			}

			break;

		case 1 :
			if( cw == tw ) {
				sendmessage(tag_list_h, LB_DELETESTRING, c_line - 1, 0);
//messagebeep(-1);
//make_message(str(cur_window) + " " + str(WINDOW_ID));
/*
messagebeep(-1);
make_message("Before[" + get_line + "]");
read_key;
*/
				del_line;
/*
messagebeep(-1);
make_message("After[" + get_line + "]");
read_key;
*/
				sendmessage(tag_list_h, LB_SETCURSEL, c_line - 1, 0);
			}
			else if (cw == fw) {
				goto_col(1);
				tstr = get_word( ' |9|255' );
				forward_till_not( ' |9|255' );
				ee = val( jx, get_word(' |9|255'));
				del_line;
				sendmessage(file_list_h, LB_DELETESTRING, c_line - 1, 0);
				goto_col( 1 );
				sendmessage(file_list_h, LB_SETCURSEL, c_line - 1, 0);

//        switch_window( tw );
				switch_win_id(tw_id);
				goto_line( jx );
				if( ee != 0 )
					eof;
				eol;
				if( search_bwd( '%' + TG_Start_File + tstr + ' ', 0 ) ) {
					block_begin;
					eol;
					if ( !Find_Text( "^" + TG_Start_File, 0, _RegExp ) ) {
						Eof;
					}
					else {
						Up;
					}
					block_end;
					delete_block;
					down;
					mark_pos;
					SendMessage(tag_list_h, WM_ML2_SETLISTBUF, cur_window,0);
					eof;
					if (c_col == 1) {
						up;
					}
					ListSetCount (tag_list_h, c_line);
					RedrawWindow(tag_list_h, 0, 0, RDW_INVALIDATE);
					goto_mark;
					sendmessage(tag_list_h, LB_SETCURSEL, c_line - 1, 0);
				}
				goto_col(1);
			}
			break;

		case 2 :
			{
				call view_tag;
			}
			break;
/*
		case 3 :
			{
				switch_window( tw );
				Set_Global_Int("~OBJ_TREE_MODE", (menu_item_int( menu, 12, 2 ) != 0) +
										((menu_item_int( menu, 13, 2) != 0) * 2));
				rm("objtree^tag_object_tree /BOX=1");
				if( return_int == 10 ) {
					switch_window( tw );
					mark_pos;
					tof;
					if( search_fwd("%" + make_literal(return_str) + "[ \t]",0 ) ) {
						pop_mark;
						call set_file;
						call view_tag;
					}
					else
						goto_mark;
				}
			}
			break;
*/
	}
	switch_window( cw );
	goto exit;


view_tag:
	{

		switch_window( vw );
		fp = global_str("~TAG_VIEW_RO");
		if( parse_int("/BID=", fp) == buffer_id ) {
			read_only = parse_int("/RO=", fp );
		}
//    switch_window( tw );
		switch_win_id(tw_id);
		goto_col(1);

//    tag_store_find(g_tag_language, get_word(' |9|255'), backtrack_data);
    set_global_str('LAST_TAG_FIND', get_word(' |9|255') );
/*
beep;
make_message("Before window_id=" + str(window_id));
read_key;
*/

		Rm( "Tag_Goto /VW=" + Str( Vw ) + "/OW=" + Str( Cw ) + "/EB=0/NB=1/BC=");
/*
beep;
make_message("After window_id=" + str(window_id) + " link_stat=" + str(link_stat));
read_key;
*/
		if( error_level != 0 ) {
			rm('MEERROR');
			error_level = 0;
		}
		switch_window( vw );
		set_global_str( "~TAG_VIEW_RO", "/BID=" + str(buffer_id) + "/RO=" + str(read_only ) );
//		read_only = TRUE;


/*
		if( menu != 0 )
			menu_set_str( menu, parse_int("/VMN=", mparm_str), 1, 'View: ' + file_name );
*/
		if ( hDlg ) {
			RedrawWindow( GetDlgItem( hDlg, view_Win_Ctrl ) , 0, 0, rdw_Invalidate );
			SetDlgItemText( hDlg, view_Border_Ctrl, "V&iew: " + File_Name );
		}
		ret;
	}

set_file:
	{
//RM("MEERROR^MESSAGEBOX /B=2/T=TAG_LIST_DISPLAY/M=SET_FILE is not implemented yet.");

		reg_exp_stat = TRUE;
//    switch_window(tw);
		switch_win_id(tw_id);
		mark_pos;
//		tx1 = wherex;
//		ty1 = wherey;
		if (search_bwd( '%' + TG_Start_File, 0 )) {
			forward_till(" " );
			forward_till_not(" ");
			tstr = get_word(" ");
			Ps = Parse_Str( "\xFE" + "PATH=", Get_Line( ) );
			switch_window( fw );
			goto_col(1);
//			refresh = true;
//			display_line;
//			refresh = false;
			if ( !( ( TStr == Get_Word( " " ) ) &&
					( Caps( Parse_Str( "\x7F" + "P=", Get_Line( ) ) ) == Caps( Ps ) ) ) ) {
//				write( '', wherex - 1, wherey, 0, b_color );
/*
messagebeep(-1);
make_message(get_line);
read_key;
*/
				mark_pos;
				tof;
				while ( Find_Text( "^" + Make_Literal_X( TStr ) + " ", 0, _RegExp ) ) {
					if ( Caps( Parse_Str( "\x7F" + "P=", Get_Line( ) ) ) == Caps( Ps ) ) {
						break;
					}
					eol;
				}
//				jx = c_line;
//				goto_mark;
//        while(( jx < c_line))
//					up;
//        while( (jx > c_line))
//					down;
//				refresh = true;
				goto_col(1);
				sendmessage(file_list_h, LB_SETCURSEL, c_line - 1, 0);
//				redraw;
//				write( '', wherex - 1, wherey, 0, l_color );
//				refresh = false;
				SetDlgItemText( hDlg ,id_TagPath, Ps );
			}
//      switch_window( tw );
			switch_Win_id(tw_id);
		}
		goto_mark;
//		gotoxy( tx1,ty1 );
		ret;

	}
exit:
	refresh = tr;
	undo_stat = tundo;
	return_int = 0;
}

void tag_list_ut() {
	// proc for the update tags button
	int txw,
			txw_id = 0,
			tn,
			main_dlg = parse_int('/DLG=', mparm_str ),
			fw,
			h_list,
			h_dlg,
			h_abort,
			button_height,
			font_height,
			line_height,
			font_width,
			dfont,
			h,
//			abort_ctrl = 1001,
			list_win_id = 0,
			t_win_id,
			t_int,
			dlg_unit_y,
			uo = parse_int("/WU=", global_str("METAGS_CONFIG")),
			h_main_dlg,
			tag_list_h,
			file_list_h,
			tag_list_win,
			active_window = window_id,
			do_break;
  int hFindFile = 0;
	int FileTime;
	int SavRefresh = Refresh;

	str ls[max_line_length],p;

	struct DlgCtrl 				 Ctrl;
	struct tmsg 					 Msg;
  struct WIN32_FIND_DATA NewFd;
  struct DOS_FIND_DATA   OldFd;

	Refresh = False;
	Rm( "AutoSave" );
/*
	put_box( x, y, x + w, y + l, 0, m_b_color, 'SCANNING', TRUE );
	set_vp( x + 1, y + 1, x + w - 3, y + l - 2 );
	gotoxy_vp( 1, 1 );
	text_color_vp = m_s_color;
*/
	ls = menu_item_str( main_dlg, 1, 3 );
	str_to_struct( ctrl, ls );
	h_Main_dlg = ctrl.whandle;
	tag_list_h = GetDlgItem(h_main_dlg, tag_list_ctrl);
	file_list_h = GetDlgItem(h_main_dlg, tag_list_ctrl);
	fw = SendDlgItemMessage(h_main_dlg, file_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0);
	tag_list_win = SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0);
	switch_window( window_count );
	create_window;
	txw = cur_window;
	txw_id = window_id;
	create_window;
	list_win_id = window_id;

	h_dlg = Create_Mew_Dlg ('Scanning', "", frame_handle, 0);
	Get_MEW_Dlg_Metrics( h_dlg, line_height, font_height, font_width, dfont );
	button_height = ((DLG_DefBtnHeight * font_height) /8) + 1;
	h  = font_height + 4;
	t_int = GetDialogBaseUnits();
//	dlg_unit_X = (t_int & 0xffff) / 4;
	dlg_unit_y = (t_int >> 16) / 8;

	h_list =
		ListBoxCreate( cur_window,          // The edit buffer/window number
									 1,                    // The starting line in the buffer
									 0,          // The number of lines
									 1,
									 dlg_unit_y * 4,
									 45 * font_width,
									 h * 15,
									 1000,                   // Ctrl id
									 0,    // Flag bits. See _LB_FLAG_xxxx
									 0,                     // Field number to use for  inc search
									 h_dlg,              // Parent window
									 ""// display string
									 );

	h_abort = Create_MEW_Ctrl( "BUTTON", "&Abort",
									BS_PUSHBUTTON | BS_DEFPUSHBUTTON | WS_TABSTOP,
									Font_width * 17, h * 16, 10 * font_width, button_height,
									h_dlg, abort_ctrl, app_handle, 0);
	SetFocus (h_abort);
	EnableWindow      ( h_dlg, TRUE );
	BringWindowToTop  ( h_dlg );
	ShowWindow        ( h_dlg, TRUE );


	switch_window( fw );
	tof;
/*
SET_GLOBAL_INT("!@#ABORT!@#",0);
*/
	while(!at_eof) {
/*
if (global_int("!@#ABORT!@#")) {
BREAK;
}
*/

		call Check_Abort;
		if ( Do_Break ) {
			if ( VerifyDlg( "Abort tag scanning?", "", "", 0, True ) == id_std_Yes ) {
				break;
			}
		}
		Goto_Col( 1 );
		Return_Str = Get_Word( " " );
/*
		write_vp( return_str );
*/
		t_win_id = window_id;
		switch_win_id(list_win_id);
		eof;
		if(c_col > 1)
			down;
		Put_Line( Return_Str );
		SendMessage( h_List, WM_SETREDRAW, 0, 0);
/*
messagebeep(-1);
make_message(str(txw) + "[" + get_line + "]" + str(fw));
read_key;
*/
		SendMessage( h_list, LB_ADDSTRING, 0, 0 );
		SendMessage( h_list, LB_SETCURSEL, c_line - 1, 0 );
		SendMessage( h_list, WM_SETREDRAW, 1, 0 );
		SendMessage( h_list, WM_ML2_REDRAW, 0, 0 );
  	ProcessMsgQueue( 10 );
		switch_win_id(t_win_id);
		P = Parse_Str( "\x7F" + "P=", Get_Line( ) ) + Return_Str;
		Return_Str = P;
		Rm( "SetFileName" );
		P = Return_Str;
		hFindFile = FindFirstFile( Return_Str, &NewFd, &OldFd );
		if ( hFindFile ) {
			FileTime = OldFd.Time;
			FindClose( hFindFile );
			if ( Uo ) {
				Rm( "Tag_Find_File /F=1/FN=" + P );
				if ( Return_Int ) {
					Tn = Parse_Int( "\xFE" + "DT=", Get_Line( ) );
					if ( FileTime <= Tn ) {
						T_Win_Id = Window_Id;
						Switch_Win_Id( List_Win_Id );
						Put_Line( Get_Line( ) + "  ...file not changed" );
						Sendmessage( h_List, WM_ML2_REDRAW, 0, 0 );
						Switch_Win_Id( T_Win_Id );
//						switch_window( tw );
						goto Skip_Build;
					}
				}
			}
			Switch_Window( Txw );
			Rm( "LdFiles /NB=1/NC=1/NHA=1" );
			T_Win_Id = Window_Id;
			Switch_Win_Id( List_Win_Id );
//			Put_Line( Get_Line( ) + "..." );
//			SendMessage( h_List, WM_ML2_REDRAW, 0, 0 );
			Switch_Win_Id( T_Win_Id );

			if ( Error_Level == 0 ) {
				Rm( "Tag_Build /WW=1" );
			}
		}

	Skip_Build:
		Error_Level = 0;
		t_win_id = window_id;
		switch_win_id(list_win_id);
		put_line(get_line + ".");
		sendmessage( h_list, WM_ML2_REDRAW,0,0 );
		switch_win_id(t_win_id);
		switch_window( fw );
		down;
/*
SET_GLOBAL_INT("!@#ABORT!@#",1);
*/
	}

	// reset the display of the tag list
	switch_window(tag_list_win);
	eof;
	if (c_col == 1) {
		up;
	}
	SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_SETLISTBUF, cur_window ,0);
	ListSetCount (tag_list_h, c_line);
	RedrawWindow(tag_list_h, 0, 0, RDW_INVALIDATE);
	tof;
	sendmessage(tag_list_h, LB_SETCURSEL, 0, 0);

	sendmessage(file_list_h, LB_SETCURSEL, 0, 0);
/*
messagebeep(-1);
read_key;
*/
	Destroy_Mew_Dlg (h_dlg);

	if (switch_win_id(list_win_id)) {
		delete_window;
	}
	if (switch_win_id(txw_id)) {
		delete_window;
	}

	switch_win_id(active_window);
	Refresh = SavRefresh;
	return_int = 0;
	RETURN();

Check_abort:
	do_break = 0;
	while ( PeekMessage( &msg, 0, 0, 0, PM_REMOVE))
	{
		if ( msg.message == WM_KEYDOWN ) {
			if (msg.wparam == VK_ESCAPE) {
				do_break = 1;
				break;
			}
		}

		if ( msg.message == WM_MEW_DLGRETURN )
		{
			if(msg.hwnd == GetWindow(h_dlg, GW_OWNER ) )
			{
				if ( msg.wparam == abort_ctrl )
				{
					do_break = 1;
					break;
				}
			}
		}

		if( !IsDialogMessage( h_dlg, &msg) )
		{
				Translatemessage( &msg );
				Dispatchmessage ( &msg );
		}
	}
	ret;

}

void tag_list_tf() {
	// proc for the tag file button
	int dlg,
			main_dlg = parse_int('/DLG=', mparm_str ),
			active_window = window_id,
			tag_win_num,
			file_win_num,
			h_main_dlg,
			tag_list_h,
			file_list_h,
			t_int;
	str ls[max_line_length];

	struct DlgCtrl ctrl;

	working;
	ls = menu_item_str( main_dlg, 1, 3 );
	str_to_struct( ctrl, ls );
	h_Main_dlg = ctrl.whandle;
	tag_list_h = GetDlgItem(h_main_dlg, tag_list_ctrl);
	tag_win_num = SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0);
	file_list_h = GetDlgItem(h_main_dlg, file_list_ctrl);
	file_win_num = SendDlgItemMessage(h_main_dlg, file_list_ctrl, WM_ML2_GETLISTBUF, 0 ,0);

/*
beep;
make_message("tag_win_num=" + str(tag_win_num) + " file_win_num=" + str(file_win_num));
read_key;
*/
	switch_window( window_count );
	create_window;
	ls = "DEFAULT";
	return_str = global_str('METAGS_FILE_NAME');
	call put_file_in_list;
	ls = "C/C++";
	return_str = global_str('TAG_F_C');
	call put_file_in_list;
	ls = "CMAC";
	return_str = global_str('TAG_F_CMAC');
	call put_file_in_list;
  ls = "DFWIN";
  return_str = global_str('TAG_F_DFWIN');
  call put_file_in_list;
  ls = "DATAFLEX";
  return_str = global_str('TAG_F_DFWIN');
  call put_file_in_list;
	ls = "MODULA_2";
	return_str = global_str('TAG_F_MODULA_2');
	call put_file_in_list;
	ls = "ASM";
	return_str = global_str('TAG_F_ASM');
	call put_file_in_list;
	ls = "PARADOX";
	return_str = global_str('TAG_F_PAL');
	call put_file_in_list;
	ls = "PARADOX";
	return_str = global_str('TAG_F_PARADOX');
	call put_file_in_list;
	ls = "DBASE";
	return_str = global_str('TAG_F_DBASE');
	call put_file_in_list;
	ls = "CLIPPER";
	return_str = global_str('TAG_F_CLIPPER');
	call put_file_in_list;
	ls = "XBASE";
	return_str = global_str('TAG_F_XBASE');
	call put_file_in_list;
	ls = "PASCAL";
	return_str = global_str('TAG_F_PASCAL');
	call put_file_in_list;
	ls = "DELPHI";
	return_str = global_str('TAG_F_DELPHI');
	call put_file_in_list;
	tof;

	DlgCreate(dlg);
	DlgAddCtrl(dlg,Dlg_ListBox,"LANG=/W=20FILE=/W=26",
				1, 1,
				46,4,
				1000,0,
				'/INCO=1/WIN='+str(cur_window));

	DlgAddCtrl( dlg, DLG_PushButton, "OK",
		1, 6,
		DLG_StanBtnWidth, 0, 1100, Dlgf_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel",
		DLG_PosOffset+DLG_StanBtnWidth+2, DLG_PosOffset,
		DLG_StanBtnWidth, 0, 1101, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help",
		30, DLG_PosOffset,
		DLG_StanBtnWidth, 0, 1102, 0, "/R=2");

	Return_int = DlgExecute( dlg, 1000, "Select Tag File", TAGPROMPT_HELPLINK, "", 0);
	working;
	DlgKill(dlg);

	return_str = parse_str("FILE=",get_line);

  g_tag_language = parse_str("LANG=",get_line);

	delete_window;

	if(return_int) {
		switch_window(tag_win_num);
		rm("tag_find_file /TF=" + return_str );
		if( return_int ) {
			eof;
			if (c_col == 1) {
				up;
			}
			SendDlgItemMessage(h_main_dlg, tag_list_ctrl, WM_ML2_SETLISTBUF, cur_window ,0);
			ListSetCount (tag_list_h, c_line);
			RedrawWindow(tag_list_h, 0, 0, RDW_INVALIDATE);
			tof;
			sendmessage(tag_list_h, LB_SETCURSEL, 0, 0);
			tag_win_num = cur_window;

			switch_window(file_win_num);
			tof;
// RM("MEERROR^MESSAGEBOX /T=TAG_LIST_TF/M=1665 File=[" + file_name +
// 		"] line=[" + get_line + "]");
			erase_window;
// RM("MEERROR^MESSAGEBOX /T=TAG_LIST_TF/M=1668File=[" + file_name +
// 		"] line=[" + get_line + "]");
			switch_window(tag_win_num);
			TAG_BUILD_FLIST(file_win_num);
			switch_window(file_win_num);
/*
beep;
make_message("cur_window=" + str(cur_window) + " tag_win_num=" + str(tag_win_num) + " file_win_num=" + str(file_win_num));
read_key;
*/
// RM("MEERROR^MESSAGEBOX /T=TAG_LIST_TF/M=1673 File=[" + file_name +
// 		"] line=[" + get_line + "]");
			eof;
			if (c_col == 1) {
				up;
			}
			SendMessage(file_list_h, WM_ML2_SETLISTBUF, cur_window,0);

			ListSetCount (file_list_h, c_line);
			RedrawWindow(file_list_h, 0, 0, RDW_INVALIDATE);

			tof;
			sendmessage(file_list_h, LB_SETCURSEL, 0, 0);
			RM("TAG_LIST_DISPLAY /XM=0/DLG=" + str(main_dlg));

			switch_window(tag_win_num);
			SetWindowText(h_main_dlg, "Tags: " + file_name);

		}
	}
	switch_win_id(active_window);
	Return();

put_file_in_list:
	{
		if( return_str != "" ) {
//			pad_str( ls, 20, " " );
			put_line("LANG=" +  ls + "FILE=" + return_str );
			down;
		}
		ret;
	}

}


void tag_scan_dlg(str title_str[80],
									int make_list //MUST be either 0 or 1
									) {
	int list_count = 0,
//			list_win_id,
//      list_win_num,
			active_win_id = window_id,
//			h_dlg,
//			h_path,
//			h_line,
//			h_file,
			line_height,
			font_height,
			font_width,
			dfont,
			button_height,
			h,
			y,
			htemp,
			dlg_unit_x,
			dlg_unit_y,
//			h_list,
			h_abort,
			file_ctrl = 1001,
			path_ctrl = 1002,
			line_ctrl = 1003,
			list_ctrl = 1004;
//			abort_ctrl = 1005;
			g_h_path = 0;
			g_h_line = 0;
			g_h_file = 0;
			g_h_list = 0;

	if (make_list) {
		switch_window(window_count);
		create_window;

//    list_win_num = cur_window;
		g_list_win_id = window_id;
	}
	g_h_main_dlg = Create_Mew_Dlg (title_str, "", frame_handle, 0);
	Get_MEW_Dlg_Metrics( g_h_main_dlg, line_height, font_height, font_width, dfont );

	// This is the formula used in DIALOG.S for default button height
	button_height = ((DLG_DefBtnHeight * font_height) /8) + 1;
	h  = font_height + 4;

	htemp = GetDialogBaseUnits();
	dlg_unit_X = (htemp & 0xffff) / 4;
	dlg_unit_y = (htemp >> 16) / 8;
	y  = dlg_unit_y * 4;
/*
	hTemp = BuildMEWButton(g_h_main_dlg, 0, "BT_TAGS_100", 0,
						MBCS_TRANSPARENT | MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
						0, font_width, line_height + (dlg_unit_y * 4), 0, 0);

	hTemp = Create_MEW_Ctrl( "STATIC", "Scanning:", 0,
									(font_width * 7), y, 25 * font_width, h,
									g_h_main_dlg, 0, app_handle, 0);
	hTemp = Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
									(18 * font_width), y - 1, 34 * font_width + 2, h + 2,
									g_h_main_dlg, 0, app_handle, 0);
	g_h_path = Create_MEW_Ctrl( "STATIC", "", 0,
									(19 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
									g_h_main_dlg, path_ctrl, app_handle, 0);
	y = y + line_height + (dlg_unit_y * 2);

	hTemp = Create_MEW_Ctrl( "STATIC", "File:", 0,
									(font_width * 7), y, 25 * font_width, h,
									g_h_main_dlg, 0, app_handle, 0);
	hTemp = Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
									(18 * font_width), y - 1, 34 * font_width + 2, h + 2,
									g_h_main_dlg, 0, app_handle, 0);
	g_h_file = Create_MEW_Ctrl( "STATIC", "", 0,
									(19 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
									g_h_main_dlg, file_ctrl, app_handle, 0);
	y = y + line_height + (dlg_unit_y * 2);

	hTemp = Create_MEW_Ctrl( "STATIC", "At line:", 0,
									(font_width * 7), y, 25 * font_width, h,
									g_h_main_dlg, 0, app_handle, 0);
	hTemp = Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
									(18 * font_width), y - 1, 34 * font_width + 2, h + 2,
									g_h_main_dlg, 0, app_handle, 0);
	g_h_line = Create_MEW_Ctrl( "STATIC", "", 0,
									(19 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
									g_h_main_dlg, line_ctrl, app_handle, 0);
*/

	Create_MEW_Ctrl( "STATIC", "Scanning:", 0,
									(dlg_unit_x * 4), y, 25 * font_width, h,
									g_h_main_dlg, 0, app_handle, 0);
	Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
									(11 * font_width), y - 1, 34 * font_width + 2, h + 2,
									g_h_main_dlg, 0, app_handle, 0);
	g_h_path = Create_MEW_Ctrl( "STATIC", "", 0,
									(12 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
									g_h_main_dlg, path_ctrl, app_handle, 0);
	if (make_list) {
		y = y + line_height + (dlg_unit_y * 2);
		Create_MEW_Ctrl( "STATIC", "File:", 0,
										(dlg_unit_x * 4), y, 25 * font_width, h,
										g_h_main_dlg, 0, app_handle, 0);
		Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
										(11 * font_width), y - 1, 34 * font_width + 2, h + 2,
										g_h_main_dlg, 0, app_handle, 0);
		g_h_file = Create_MEW_Ctrl( "STATIC", "", 0,
										(12 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
										g_h_main_dlg, file_ctrl, app_handle, 0);
	}

	BuildMEWButton(g_h_main_dlg, 0, "BT_TAGS_100", 0,
						MBCS_TRANSPARENT | MEWBTN_STATICBUTTON | MEWBTN_SIZETOBITMAP,
						0, font_width * 47, y + (!make_list * (dlg_unit_y * 2)), 0, 0);

	y = y + line_height + (dlg_unit_y * 2);
	Create_MEW_Ctrl( "STATIC", "At line:", 0,
									(dlg_unit_x * 4), y, 25 * font_width, h,
									g_h_main_dlg, 0, app_handle, 0);
	Create_MEW_Ctrl( "STATIC", "", ss_blackframe,
									(11 * font_width), y - 1, 34 * font_width + 2, h + 2,
									g_h_main_dlg, 0, app_handle, 0);
	g_h_line = Create_MEW_Ctrl( "STATIC", "", 0,
									(12 * font_width), y + dlg_unit_y, 32 * font_width, font_height,
									g_h_main_dlg, line_ctrl, app_handle, 0);

	if (make_list) {
		y = Y + line_height + (dlg_unit_y * 4);
		switch_win_id(g_list_win_id);
		g_h_list =
			ListBoxCreate( cur_window,          // The edit buffer/window number
										 1,                    // The starting line in the buffer
										 list_count,          // The number of lines
										 dlg_unit_x ,
										 y,
										 52 * font_width,
										 h * 15,
										 list_ctrl,                   // Ctrl id
										 0,    // Flag bits. See _LB_FLAG_xxxx
										 0,                     // Field number to use for  inc search
										 g_h_main_dlg,              // Parent window
										 ""// display string
										 );
		y = y + (line_height * 14);

		h_abort = Create_MEW_Ctrl( "BUTTON", "&Abort",
										BS_PUSHBUTTON | BS_DEFPUSHBUTTON | WS_TABSTOP,
										Font_width * 17, y, 10 * font_width, button_height,
										g_h_main_dlg, ABORT_ctrl, app_handle, 0);
		SetFocus (h_abort);
	}
	else {
		SetFocus (g_h_line);
	}

	EnableWindow( g_h_main_dlg, TRUE );
	BringWindowToTop( g_h_main_dlg );
	ShowWindow( g_h_main_dlg, TRUE );

	switch_win_id(active_win_id);
}

int tag_scan_chk_msg() {
	int ret_value = 0;

	struct tmsg msg;

	while ( PeekMessage( &msg, 0, 0, 0, PM_REMOVE))
	{
		if ( msg.message == WM_KEYDOWN ) {
			if (msg.wparam == VK_ESCAPE) {
				ret_value = 1;
				break;
			}
		}

		if( msg.hwnd == GetWindow( g_h_main_dlg, GW_OWNER))
		{
			if ( msg.message == WM_MEW_DLGRETURN )
			{
				if ( msg.wparam == abort_ctrl )
				{
//					beep;
					ret_value = 1;
					break;
				}
			}
		}

		if( !IsDialogMessage( g_h_main_dlg, &msg) )
		{
				Translatemessage( &msg );
				Dispatchmessage ( &msg );
		}
	}

	return(ret_value);
}

macro Tag_Build
/*---------------08-22-91 10:16am-------------------
 *	Determines the correct macro to run (to build tags)
 *  for the given file, based on the language type
 *  setup for its extension.
 --------------------------------------------------*/
	no_break
	trans2
{
	str ls[40] = tag_get_language(get_extension(file_name)),
			mstr = mparm_str;
	int tm = system_timer,
			tkh = keyword_highlighting,
			ww = parse_int( '/WW=', mparm_str ),
			src_win = cur_window,
			work_win,
			sl,
			tundo = undo_stat,
			t_tab_expand = tab_expand;
	int SavRefresh = Refresh;

	tab_expand = true;

	if (!ww) {
		tag_scan_dlg("Scan Tags For Current File", false);
		tag_scan_chk_msg();
	}

//	int h_file = parse_int("/HFILE=",mparm_str);
	mstr = "/HLINE=" + str(g_h_line) + mstr;
	int h_file = g_h_file;

	refresh = false;
	keyword_highlighting = FALSE;
	undo_stat = false;
	reg_exp_stat = true;
	set_global_int("~OBJ_TREE_BUILD", 1 );

	mark_pos;
	tof;
	working;
	if( ww ) {

		if (h_file) {
//			SetWindowText(h_file,truncate_path(file_name));
		}
	} else {
		if (g_h_path) {
			SetWindowText(g_h_path,truncate_path(file_name));
		}

	}
	rm( 'tag_find_file /C=1' + mstr );
/*
messagebeep(-1);
make_message("Tag_build " + str(window_id) + " [" + get_line + "]");
read_key;
*/
	work_win = cur_window;

	switch_window( src_win );

	if( (ls == 'C') || (ls == 'C++') ) {
		rm( 'tag_b_c /TW=' + str(work_win) + mstr);
	}
	else if( ls == 'CMAC' ) {
		rm( 'tag_b_cmac /TW=' + str(work_win) + mstr);
	}
	else if(( ls == 'PASCAL' ) || (ls == 'DELPHI')) {
		rm( 'tag_b_pascal /TW=' + str(work_win) + mstr);
	}
	else if( ls == 'MODULA_2' ) {
	 	rm( 'tag_b_modula2 /TW=' + str(work_win) + mstr);
	}
	else if( ls == 'ASM' ) {
	 	rm( 'tag_b_asm /TW=' + str(work_win) + mstr);
	}
	else if( (ls == 'PARADOX') || (ls == 'PAL') ) {
	 	rm( 'tag_b_pal /TW=' + str(work_win) + mstr);
	}
  if((ls == 'DFWIN') || (ls == 'DATAFLEX')) {
    rm( 'tag_b_dfwin /TW=' + str(work_win) + mstr);
	}
	else if ((ls == 'DBASE') ||
			(ls == 'XBASE') ||
			(ls == 'CLIPPER') ||
			(ls == 'EVOLVE') ||
      (xpos('CLI.',ls, 1) == 1) ||
      (xpos('DBA.',ls, 1) == 1) ||
      (xpos('ARA.',ls, 1) == 1) ||
      (xpos('FXP.',ls, 1) == 1) ||
      (xpos('FXW.',ls, 1) == 1) ||
      (xpos('DBW.',ls, 1) == 1) ||
      (xpos('FXW.',ls, 1) == 1) ||
      (xpos('FIV.',ls, 1) == 1) ||
      (xpos('VIS.',ls, 1) == 1) ||
      (xpos('DB5.',ls, 1) == 1) ||
      (xpos('DBF.',ls, 1) == 1)) {
		rm( 'tag_b_xbase /TW=' + str(work_win) + mstr);
  }
	else {
		if( ww )
	}
	switch_window( src_win );
	rm('tag_b_explicit /TW=' + str(work_win) + mstr);

	if(parse_int("/SORT=",global_str("METAGS_CONFIG"))) {
		switch_window( work_win );
		reg_exp_stat = true;
		eof;
		sl = c_line;
		search_bwd("%" + tg_start_file, 0 );
		qsort_lines( c_line + 1, sl, 1, 1, max_line_length,  0 );
	}
	Switch_Window( Work_Win );
	if ( File_Changed ) {
		Rm( "MEUTIL1^SaveFile /NP=1" );
	}
	Switch_Window( Src_Win );

	if (ww) {
		if (h_file) {
			SetWindowText(h_file,"");
		}
	}
	else {
		make_message( 'Tag scanning took ' + str( ((system_timer - tm) * 10) / 182 ) + ' seconds.' );
		Destroy_Mew_Dlg( g_h_main_dlg );
	}
	goto_mark;
	keyword_highlighting = tkh;
	undo_stat = tundo;
	tab_expand = t_tab_expand;
	Refresh = Savrefresh;

}  // Tag_Build

macro Tag_B_Explicit
/****************************Multi-Edit Macro********************************

 NAME:         tag_b_explicit

 DESCRIPTION:  Scans for explicit tags.  Must be called by TAG_BUILD.

 PARAMETERS:   /TW=int		Tag window

 RETURNS:

*****************************09-23-91 03:14pm*******************************/
{
	int Src_Win = Cur_Window;
	int Work_Win = Parse_Int( "/TW=", MParm_Str );

	str Tag_Id[ 80 ];
	str TStr[ 80 ];

	Tof;
	while ( Find_Text( "\x40" + "METAGS", 0, 0 ) ) {
		Forward_Till( " \t\xFF" );
		Forward_Till_Not( " \t\xFF" );
		Tag_Id = Get_Word( " \t\xFF" );
		First_Word;
		TStr = Get_Word( "" );
		call Process_Tag;
		Eol;
	}
	return ( );


Process_Tag:
//	Mark_Pos;
//	First_Word;
//	TStr = Get_Word( "" );
//	Goto_Mark;
	Switch_Window( Work_Win );
	Goto_Col( 1 );
	Put_Line( Tag_Id + "\t\t" + TStr );
	Down;
	Switch_Window( Src_Win );
	ret;

}  // Tag_B_Explicit

macro Tag_B_C trans2
/*-----------------09-17-91 03:25pm-----------------
 *    Must be called by TAG_BUILD.
 *	Generates tags for C and C++ files.  Tags the
 *  following:
 *
 * 			function
 *      template
 * 			struct
 *      union
 *      class
 *      #define (if "tag_c_defines" is TRUE)
 *      typedef
 *      enum
 *      global variables and types
 *      @METAG tag    (explicit tag)
 *
 *--------------------------------------------------*/
{


#DEFINE _key_string "{=1[=2==3;=4:=5(=6,=7"
#DEFINE _open_curly_brace  1
#DEFINE _open_square_brace 2
#DEFINE _equal_sign        3
#DEFINE _semi_colon				 4
#DEFINE _colon             5
#DEFINE _open_paren        6
#DEFINE _comma             7

#DEFINE _key_string2 "_CLASSDEF=50typedef=51extern=52static=53signed=54unsigned=55struct=100union=101enum=102class=103template=104inline=105volatile=56pascal=57const=58"
#DEFINE _classdef 50
#DEFINE _typedef  51
#DEFINE _extern   52
#DEFINE _static   53
#DEFINE _signed   54
#DEFINE _unsigned 55
#DEFINE _volatile 56
#DEFINE _pascal   57
#DEFINE _const    58
#DEFINE _struct 	100
#DEFINE _union  	101
#DEFINE _enum   	102
#DEFINE _class  	103
#DEFINE _template 104
#DEFINE _inline   105



	int
			src_win = cur_window,
			work_win = parse_int('/TW=', mparm_str),
			jx,
			brace_count = 1,
			parm_pos = 0, parm_line = 0,
			char_pushed = FALSE,
			macro_done = FALSE,
			t_reg_exp_stat = reg_exp_stat,
			t_ignore_case = ignore_case,
			h_line = parse_int("/HLINE=",mparm_str),
			brace_count = 0,
			tte = tab_expand,
			mline,mcol,
			else_count = 0,
			parm_type, is_method,
//			saved_obj_line,                        // fix for format problems
			last_line,                             // formatting stuff
			tag_c_defines = parse_int("/TD=", global_str("METAGS_CONFIG" ))
			;

	char
			Current_Mac_Char;

	str
			current_parm = "",
			member_of[40],
			object_str[40],                        // added [40]
			saved_obj[40],                         // added to get global vars
			keywords[40] = '',                     // added to accumulate keywords
			saved_keywords[40] = '',               // added to accumulate keywords
			base_str,
			operator_set[20] = ":%^<>!-=+/|*&",
			tag_id[80],
			tmp_tag_id[80],  // new line
			tag_str,
			fn[80] = truncate_path( file_name )
			;

	refresh = FALSE;

	tab_expand = TRUE;
	reg_exp_stat = true;
	ignore_case = true;
	current_parm = "";


	while ( !At_Eof ) {
		call parse_next_parm;
	}
	goto exit;


Parse_Next_Parm:
	{
		call Get_Next_Parm;
		if ( XPos( Current_Parm, ';//{})', 1 ) ) {
			if ( h_Line ) {
				SetWindowText( h_Line, Str( C_Line ) );
			}
			if ( current_parm == '//' ) {
				eol;
			}
			else if ( current_parm == '{' ) {
				left;
				call match;
				if (!return_int) {
					++brace_count;
				}
			}
		}
		else if ( str_char( current_parm, 1 ) == '#' ) {
			base_str = "";
			if ( Tag_C_Defines && ( ( Current_Parm == "#define" ) || ( Current_Parm == "# define" ) ) ) {
				if ( Tag_C_Defines ) {                  //
					object_str = current_parm;
					call get_next_parm;
					tag_id = current_parm;
					call process_tag;
				}                                       //
				call process_to_eol;                    //
			}
			else if ( Current_Parm == "#else" ) {
				call match_else;
			}
			if ( At_Eof ) {														//TR This prevents getting
				ret;                                    //   hung in a loop
			}
			call process_to_eol;
		}
		else {
			base_str = "";
			call classify_parm;
			switch ( parm_type )
			{
				case _classdef :
					call process_to_eol;
					break;

				case _struct :
				case _union :
				case _enum :
				case _class :
				case _template :
					object_str = current_parm;
				pstruct:
					saved_obj = object_str;
					call get_search_str;                      // Search string for beginning of structure
					call get_next_parm;                       //
					if ( current_parm != '{' ) {              // If function has a type
						do {                                    //
							tag_id = current_parm;                // Set possible type id
							call get_next_parm;                   //  and get next parameter.
						}                                       //
						while ( !at_eof &&                      // Search to end of definition
										!(xpos(current_parm,"{[=;:",  1))); // TMJ

						if(current_parm == ";")   // Check for forward defined class,
																			// don't tag it
						{
							if ( parm_type == _class )
							{
								ret;
							}
						}
						if( current_parm == ":")
						{
							base_str = "\tBASE=";
							do
							{
								call get_next_parm;
								while(!at_eof && ((current_parm == "public") || (current_parm == "private")
										 || (current_parm == "protected") || (current_parm == "virtual")))
								{
									call get_next_parm;
								}
								base_str += current_parm;  // Set base
								call get_next_parm;
								if(current_parm == ",")
								{
									base_str += ",";
								}
								else
									break;
							}
							while(!at_eof  && (current_parm != "{"));

							base_str += "";

							call process_tag2;                    // Process structure type
							while( !at_eof && (current_parm != "{"))
							{
								call get_next_parm;
							}
						}
						else if ( current_parm == '{' ) {       // type is defined so use
							object_str += '_type';                //
							call process_tag2;                    // Process structure type
							object_str = saved_obj;               // Restore object string
						}
						else if ( current_parm == ';' ) {     // Check for simple declaration
							call process_tag2;                    // Process if true and we are
							ret;                                  //  done.
						}
						else if ((parm_type == _struct) &&
									( current_parm == '=' )) {       // Check for init struct
							call PROCESS_INIT_STRUCT;
							ret;
						}
						else if ((parm_type == _struct) &&
								( current_parm == '[' )) {              // Check for array of
								call process_tag2;                      // structures
								call match_bracket;                     //
								call get_next_parm;                     //
								if ( current_parm == '[' ) {            // Check for doubly
									call match_bracket;                   //
									call get_next_parm;                   //
								}                                       //
								ret;
						}
					}
																									// Here for typeless struct

					if ( parm_type == _enum ) {
						call process_enum;
					}
					else {
						left;                                   // Find closing brace to
						call match;                             //  typeless structure.
					}
					call get_next_parm;                     // Get name of structure
					if ( current_parm == ';' ) {          // If type only, we are
						ret;                                //  done.
					}                                     //
					do {                                    //
						call get_search_str;                  // Search string for beginning of structure
						tag_id = current_parm;                // Set possible struct name
						call get_next_parm;                   //  and get next parameter.
						if(xpos(current_parm,"([=;,",1)) {
							object_str = saved_obj;
							if ( current_parm == '[' ) {              // Check for array of
								object_str += '_[]';                    //  structures
								call match_bracket;                     //
								call get_next_parm;                     //
								if ( current_parm == '[' ) {            // Check for doubly
									object_str += '[]';                   //  dimensioned array
									call match_bracket;                   //
									call get_next_parm;                   //
								}                                       //
								call process_tag2;                      // Process struct name
						//    call process_to_semi;                   // Process to end of struct
							}
							else if ( current_parm == '(' ) {       	// Check for procedure returning struct

								/* This currently does not identify typedefs of procedures
									 returning struct, union, etc.  If this is a typedef then
									 the ; represents a valid definition, otherwise it is only
									 a procedure prototype and is not kept. */

								object_str += '_proc';                  //
								left;                                   // Match parens
								call match;                             //
								call get_next_parm;                     //
								if ( current_parm != ';' ) {            // Use if not proc definition
									call process_tag2;                    //
									while ( ! at_eof && (current_parm != '{') ) { //
										call get_next_parm;                 // Process to end of proc
									}                                     //
									if( current_parm == '{') {            //
										left;
										call match;                         //
									}                                     //
								}                                       //

							}
							else if ((parm_type == _struct) &&
										( current_parm == '=' )) {       // Check for init struct
								call PROCESS_INIT_STRUCT;
							}
							else {
								call process_tag2;                      // Process struct name
			 //         call process_to_semi;                   // Process to end of struct
							}                                         //
						}
					}                                       //
					while ( !at_eof && !(current_parm == ";"));

					break;

				case _typedef :
					{
						object_str = current_parm;
						call get_next_parm;
						call  classify_parm;
						if( ( parm_type == _struct ) ||
								( parm_type == _union ) ||
								( parm_type == _enum ) ||
								( parm_type == _class )
								) {
							object_str += '_' + current_parm;
							goto pstruct;
						}
						while ( !at_eof &&	                      // added to allow typedefs
								( Current_Parm != ';' ) ) {	          // of arrays and
							if ( current_parm == '[' ) {            //
								call match_bracket;                   //
								call get_next_parm;                   //
								if ( current_parm == '[' ) {          //
									call match_bracket;                 //
									call get_next_parm;                 //
								}                                     //
							}
							else if ( !XPos( Current_Parm, '()', 1 ) ) { // procedures and
								Tag_Id = Current_Parm;                //
								call Get_Next_Parm;                   //
							}
							else if ( current_parm == '(' ) {     	//
								while ( !At_Eof && ( Current_Parm != ')' ) ) {
									tmp_tag_id = current_parm;          //
									call get_next_parm;                 //
								}                                     //
								call get_next_parm;                   //
								if ( current_parm == '(' ) {          // procedure pointer
									tag_id = tmp_tag_id;                //
									left;                               //
									call match;                         //
									call get_next_parm;                 //
								}                                     //
							}
							else {                                	//
								call get_next_parm;                   //
							}                                       //
						}                                         //
						call process_tag;                         // The following code allows
				 //   call process_to_semi;                   //  for processing of global
					}
					break;

				case _extern :
					{
						call get_next_parm;                       //  procedures. An additional
						if( copy(current_parm,1,1) == '"')
						{
							call get_next_parm;
						}
						if ( current_parm == '{' ) {              //  adjustment was made for
							call skip_block;                    //  procedures returning a
						} else {                                  //  procedure pointer.
							call process_to_semi;                   // The check for '{' if extern
						}                                         //  is because of name mangling
					}
					break;

				case _static :   // stuff in Borland C
						keywords += '_static';          // Setup up keyword prefix
						break;

				case  _signed :
						keywords += '_signed';          //  signed keyword
						break;

				case _inline :
						keywords += '_inline';
						break;

				case _unsigned :
						keywords += '_unsigned';        //  unsigned keyword.
						break;

				case _pascal :
						keywords += '_pascal';
						break;

				case _volatile :
						keywords += '_volatile';
						break;

				case _const :
						keywords += '_const';
						break;

				default:
						is_method = false;
																											// We have the beginning of
						saved_obj = current_parm + keywords;      //  a declaration at this point.
//						saved_obj_line = c_line;                  // When '-+=([{;,' is not object line.
						while( !at_eof &&                         // Outside while loop is for
									 (current_parm != ';') ) {          //  multiple declarations using ','.
							tag_id = current_parm;                  // We are doing a bunch of
							call get_next_parm;                     //  hocus pocus here because
							if ( (current_parm == ';') ||           //  someone can declare an
									 (current_parm == ',') ) {          //  unsigned or signed int
								if ( str_char(keywords, 1) == '_' ) { //  without including 'int'.
									saved_obj = 'int' + keywords;       // Keywords will start with
								}
								else {	                              //  '_' if no data type
									saved_obj = keywords;               //  was declared in the
								}                                     //  statement.
							}                                       //
							while ( !at_eof &&                      // Pass up all the rest
										!xpos(current_parm, ':-+=([{;,', 1)) { // while keeping
								if ( current_parm == "::" ) {
									is_method = TRUE;
									member_of = tag_id;
								}
								else if ( current_parm == "operator") {
									if ( is_method ) {
										call get_next_parm;
										tag_id = member_of + "::" + current_parm;
										object_str = "operator_method";
										call process_tag;
										call skip_block;
										ret;
									}
								}
								tag_id = current_parm;                //  tag ID one parameter
								call get_next_parm;                   //  behind.
							}
							                            //
							int parm_type2 = parse_int( "" + current_parm + "=", _key_string );

							call get_search_str;
							if ( parm_type2 == _open_paren ) {      //
								saved_obj = saved_obj + '_proc';      //
//								mark_pos;                             //
//								goto_line(saved_obj_line);            //
//								first_word;                           //
//								tag_str = get_word('');               //
//								goto_mark;                            //
								left;
								call match;                           //TMJ 12-04-92 10:43am
								call get_next_parm;                   //
								if ( current_parm == '(' ) {          // returning procedure ptr
									saved_obj = saved_obj + '_*proc';   //
									tag_id = tmp_tag_id;                //
									left;                               //
									call match;                         //
									call get_next_parm;                 //
								}                                     //
								if ( current_parm != ';' ) {          //
									object_str = saved_obj;             //
									call process_tag2;                  //
									call skip_block;
								}
								else {	                              //
									keywords = '';                      //
								}                                     //
								break;                                //
							}
							else if (parm_type2 == _open_square_brace) {  // global variables
								object_str = saved_obj + '_[]';       //
								call match_bracket;                   //
								call get_next_parm;                   //
								if (current_parm == '[') {            //
									object_str = object_str + '[]';     //
									call match_bracket;                 //
									call get_next_parm;                 //
								}                                     //
								if (current_parm == ',') {            //
									saved_keywords = object_str;        //
									call process_tag;                   //
									keywords = saved_keywords;          //
								}
								else if ( current_parm == ';') {    	//
									call process_tag;                   //
									break;                              //
								}
								else if ( current_parm == '=') {    	// initialized array
									call process_tag;                   //
									call process_to_semi;               //
						 //     break;                              //
								}                                     //
							}
							else if (parm_type2 == _open_curly_brace) {  //
								left;                                 //
								call match;                           //
								break;                                //
							}
							else if (parm_type2 == _semi_colon) {   //
								object_str = saved_obj;               //
								call process_tag;                     //
								break;                                //
							}
							else if (parm_type2 == _equal_sign) {   // initialized variables
								object_str = saved_obj;               //
								call process_tag;                     //
								call process_to_semi;                 //
							}
							else if (parm_type2 == _colon) {       	// initialized variables
								object_str = saved_obj;               //
								call process_tag;                     //
								call process_to_semi;                 //
						 //   break;                                //
							}
							else if (parm_type2 == _comma) {       	// multiple declarations
								object_str = saved_obj;               //
								saved_keywords = object_str;          //
								call process_tag;                     //
								keywords = saved_keywords;            //
							}                                       //
							if ( current_parm != ";" ) {
								call get_next_parm;                   //
							}
						}                                         //
						keywords = "";
			}
		}                                           //
		ret;                                        //
	}

PROCESS_INIT_STRUCT:
	{
		call process_tag2;                   // Process struct name
		call get_next_parm;                  // move past init code
		if( current_parm == '{') {
			left;
			call match;
			call get_next_parm;
		}
	}


skip_block:
	while ( !at_eof && (current_parm != '{') ) {
		call get_next_parm;
	}
	if( current_parm == '{') {
		left;
		call match;
	}
	ret;
																							//
match_else:
	{
		eol;
		++else_count;
		while( !at_eof && else_count ) {
			call get_next_parm;
			if( current_parm == "#ifdef" ) {
				++else_count;
			}
			else if ( current_parm == "#ifndef" ) {
				++else_count;
			}
			else if ( current_parm == "#if" ) {      	 // make usable for
				call get_next_parm;                      // "#if defined()" and
				if( (current_parm == "defined") ||       // "#if !defined()" and
						(current_parm == "!defined") ) {     // "#if ! defined()"
					++else_count;                          //
				}
				else if ( current_parm == "!" ) {      	 //
					call get_next_parm;                    //
					if ( current_parm == "defined") {      //
						++else_count;                        //
					}                                      //
				}                                        //
			}
			else if(current_parm == "#endif" ) {
				--else_count;
			}
		}
		ret;
	}

process_to_eol:
	{                                             // Process to end of line
		last_line = c_line;                         //  insuring that multiline
		do {                                        //  comments and line
			if ( current_parm == '/*' ) {             //  extenders allow the
				call do_comment;                        //  line to extend beyond
				last_line = c_line;                     //  an eol character
			}                                         //
			call get_next_parm2;                      //
		} while ( !at_eof && (last_line == c_line) ); //
		goto_line(last_line);                       //
		eol;                                        //
		left;                                       //
		if ( cur_char == '\' ) {                    //
			call next_line;                           //
			goto process_to_eol;                      //
		}
		else {	                                    //
			eol;                                      //
		}                                           //
		ret;                                        //
	}                                             //

process_to_semi:
	{
		while( !at_eof && (current_parm != ";") && (current_parm != ",")) {
			if( current_parm == "{" ) {
					left;
					call match;

        if (parm_type == _extern) {
					// special case for external prototypes
          ret;
        }
			}
			else if ( current_parm == "(" ) {
				left;
				call match;
			}
			else if ( current_parm  == "[" ) {
				call match_bracket;
			}
			call get_next_parm;
		}
		ret;
	}

process_enum:
	do {
		call get_next_parm;
		if( current_parm != "}") {
			tag_id = current_parm;
			object_str = "enum_item";
			call process_tag2;
			object_str = saved_obj;
			do {
				call get_next_parm;
			}
			while(!at_eof && !((current_parm == ",") || (current_parm == "}")));
		}
	} while(!at_eof && (current_parm != "}"));
	ret;

classify_parm:
	parm_type = parse_int( "" + current_parm + "=", _key_string2 );
	ret;

get_search_str:
	{
		mark_pos;
		first_word;
		tag_str = copy( get_line, c_col, 128 );
		goto_mark;
		ret;
	}

process_tag:
	{
		call get_search_str;
process_tag2:
		switch_window( work_win );
		goto_col( 1 );
		put_line( tag_id + "\t"+ object_str + base_str + "\t" + tag_str );
		down;
		switch_window( src_win );
		keywords = '';                     // added keyword support
		ret;
	}

do_comment:
	if (search_fwd( '{@*|47}||{|47@*}', 0)) {
		if( found_str == '|47*' ) {
			right;
			right;
			call do_comment;
		}
	}
	right;
	right;
	ret;

match_bracket:
	while ((current_parm != ']') && !at_eof) {
			call get_next_parm;
			if (current_parm == '[') {
				call match_bracket;
				call get_next_parm;
			}
	}
	ret;

Mac_Get_Next_Char:
	{
		again:
			if ( At_Eol ) {
				Current_Mac_Char = ' ';
				call Next_Line;
				Forward_Till_Not( " \t\xFF" );
				ret;
			}
			Current_Mac_Char = Cur_Char;
			Right;
		ret;
	}


Get_Next_Parm:
	{
		mline = c_line;
		mcol = c_col;
		call get_next_parm2;
		if( current_parm == '|47*' ) {
			call do_comment;
			goto get_next_parm;
		}
		ret;
	}


Get_Next_Parm2:
	{
		int End_Quote;
		char X_Char;

Parm_Again:
		Current_Parm = '';
		Forward_Till_Not( ' |9|255|12' );
		while ( At_Eol ) {
			call Next_Line;
			Forward_Till_Not( ' |9|255|12' );
			if ( At_Eof ) {
				ret;
			}
		}
		Current_Mac_Char = Cur_Char;
		Parm_Pos = C_Col;
		Right;
		Parm_Line = C_Line;
		if ( XPos( Current_Mac_Char, '{}()[];,',1 ) ) {
			Current_Parm = Current_Mac_Char;
			ret;
		}

		if ( Current_Mac_Char == '/' ) {
			Current_Parm = Current_Mac_Char;
			call Mac_Get_Next_Char;
			if ( Current_Mac_Char == '/' ) {
				Eol;
				goto Parm_Again;
			}
			if ( ( Current_Mac_Char == '*' ) || ( Current_Mac_Char == '=' ) ) {
				Current_Parm += Current_Mac_Char;
			}
			else {
				Left;
			}
			ret;
		}
		if ( Current_Mac_Char == '*' ) {
			Current_Parm = Current_Mac_Char;
			call Mac_Get_Next_Char;
			if ( ( Current_Mac_Char == '=' ) || ( Current_Mac_Char == '/' ) ) {
				Current_Parm += Current_Mac_Char;
			}
			else {
				Left;
			}
			ret;
		}
		if ( XPos( Current_Mac_char, Operator_Set, 1 ) ) {
			do {
				Current_Parm += Current_Mac_Char;
				if ( ( Current_Parm == '{' ) || ( Current_Parm == '}' ) ) {
					ret;
				}
				call Mac_Get_Next_Char;
			} while ( ( XPos( Current_Mac_Char, Operator_Set, 1 ) ) && !At_Eof );
			Left;
			ret;
		}
		if ( Current_Mac_Char == "'" ) {
			end_quote = false;
			do {
				Forward_Till( "'\\");
				if ( At_Eol ) {
					break;
				}
				else if(  Cur_Char == "'"  ) {
					right;
					break;
				}
				else if(  Cur_Char == "\\"  ) {
					right;
					right;
				}
			} while( !end_quote && !at_eof );
			if (!at_eof)
					goto parm_again;
		}
		else if ( Current_Mac_Char == '"' ) {
			end_quote = false;
			do {
				forward_till('"\');
				if (at_eol) {
					break;
				}
				else if ( Cur_Char == '"' ) {
					right;
					break;
				}
				else if( cur_char == '\' ) {
					right;
					right;
				}
			} while( !at_eof);
			if (!at_eof) {
				goto parm_again;
			}
		}
		else {
			Current_Parm = Current_Mac_Char + Get_Word( '|9{}, )([];|0|255|12''' + Operator_Set );
		}
		ret;
	}


Next_Line:
	{
		Down;
		Goto_Col( 1 );
		ret;
	}



match: {
	str  Str1[20],Str2[20],  Search_Str ;  /* Strings to match */

	int  Direction,    /* 1 = Search forward, 0 = backward */
					 B_Count,      /* Brace count.  0 = match found */
					 S_Res,        /* Result of last search */
					 pre_count,
					 JX;           /* General purpos */

Find_Match_Str:
		if( current_parm == '(' ) {
			str1 = '(';
			str2 = ')';
		}
		else {
			Str1 = '{';
			Str2 = '}';
		}
Start_Match:

	Search_Str = '[#"''/' + Str1 + Str2 + ']';

	Reg_Exp_Stat = True;
	Ignore_Case = True;					/* Ignore the search case */
	B_Count = 1;								/* Brace count starts at 1 */
	S_Res = 1;									/* Init search result to true */
	pre_count = 0;
															/* Tell the user what we're matching */

MATCH_LOOP:     /* Main loop */

		if(  S_Res == 0  ) {           /* If the last search was a failure then exit */
			Goto Error_Exit;
		}

		if(  B_Count == 0  ) {         /* If brace count is zero then success */
			Goto Found_Exit;
		}

			/*   We are going to search not only for the match brace or paren, but
				 also for comments and double and single quotes */
		Right;
		while(  (NOT (At_EOL)) & ((Cur_Char == '|255') |
					(Cur_Char == '|9'))  ) {
			RIGHT;
		}
		S_Res = Search_Fwd( Search_Str, 0);

										/* If the search result was a failure then exit */
	if(  S_Res == 0  ) {
		Goto Error_Exit;
	}

	if( found_str == "#" ) {
		mark_pos;
		first_word;
		if( cur_char == "#" ) {
			pop_mark;
			found_str = get_word(" \t" );
			if(( found_str == "#ifdef" ) || (found_str == "#ifndef") ) {
				if( pre_count > 0 ) {
					++pre_count;
				}
			}
			else if (found_str == "#else" ) {
				if( pre_count == 0 )
					++pre_count;
			}
			else if( found_str == "#endif" ) {
				if( pre_count > 0 ) {
					--pre_count;
				}
			}
			else if (( found_str == "#define" ) && (tag_c_defines) ) {
				// This handles #define's imbedded in structs
				object_str = found_str;
				call get_next_parm;
				tag_id = current_parm;
				call process_tag;
				call process_to_eol;
//beep;
//make_message("os=[" + object_str + "] cp=[" + current_parm + "]");
//read_key;

			}
			eol;
		}
		else
			goto_mark;
		goto match_loop;
	}


	/* If we found the original string then up the count */
	if(  Found_Str == STR1  ) {
		if( pre_count == 0 )
			B_Count = B_Count + 1;
		Goto Match_Loop;
	}
	/* If we found the matching string then decrement the count */
	if(  Found_Str == STR2  ) {
		if( pre_count == 0 )
			B_Count = B_Count - 1;
		Goto Match_Loop;
	}

	/* If we found a single quote the match it  */
	if(  Found_Str == ''''  ) {
		Quote_Loop:
			RIGHT;
			S_Res = Search_Fwd('[\'']',0);
			if(  S_Res == 0  ) {
				Goto Error_Exit;
			}
			if(  Found_Str == '\'  ) {
				right;
				Goto Quote_Loop;
			}
			Goto Match_Loop;
	}

	/* If we found a double quote then match it */
	if(  Found_Str == '"'  ) {
		Quote_Loop2:
				RIGHT;
				S_Res = Search_Fwd('[\"]',0);
			if(  S_Res == 0  ) {
				Goto Error_Exit;
			}
			if(  Found_Str == '\'  ) {
				right;
				Goto Quote_Loop2;
			}
			Goto Match_Loop;
	}

	/* If we found a opening comment then match it */
	if(  (Found_Str == '/')  ) {
			Right;
			if(  (Cur_Char == '*')  ) {
				S_Res = Search_Fwd('@*/',0);
				right;                          // second right is in loop above
			} else if( cur_char == '/' ) {		// Handle possibility of C++ comments
				eol;
			} else {
				left;
			}
			Goto Match_Loop;
	}



Error_Exit:       /* We go here if no match was found */
	return_int = FALSE;
	Goto Macro_Exit;

Found_Exit:       /* We go here if a match was found */
	right;
	return_int = TRUE;
Macro_Exit:
	ret;
}


exit:
	reg_exp_stat = t_reg_exp_stat;
	ignore_case = t_ignore_case;
	tab_expand = tte;
}

macro Tag_B_CMac trans2
/*-----------------09-18-91 12:49pm-----------------
 Scans CMAC files for tags.    Must be called by TAG_BUILD.
 --------------------------------------------------*/
{
	int	work_win = parse_int( "/TW=", mparm_str ),
			src_win = cur_window,
			ttm = tab_expand,
			jx;

	str	TStr,
			Fn[ 128 ] = Truncate_Path( File_Name ),
			Tag_Id[ 100 ],
			Object[ 40 ];
	str FndStr = "(global)|(prototype)|(macro)|(void)|(int)|(str)|(real)[ \t\xFF]|$";

	int h_Line = Parse_Int( "/HLINE=", MParm_Str );

	Tab_Expand = TRUE;

//	Reg_Exp_Stat = TRUE;
//	Ignore_Case = TRUE;

	Tof;
	while ( Find_Text( FndStr, 0, _RegExp ) ) {
		if ( h_Line ) {
			SetWindowText( h_Line, Str( C_Line ) );
		}
		Jx = C_Col;
		First_Word;
		if ( Jx == C_Col ) {
			Object = Caps( Get_Word( " \t\xFF" ) );
			if ( ( Object == "GLOBAL" ) || ( Object == "PROTOTYPE" ) ) {
				Mark_Pos;
				if ( Find_Text( "{", 0, 2 ) ) {
					Find_Text( '}', 0, 0 );
					Pop_Mark;
				}
				else {
					Goto_Mark;
				}
				continue;
			}
			Forward_Till_Not( " \t\xFF" );
			Tag_Id = Get_Word( " \t\xFF{(" );
			Forward_Till_Not( " \t\xFF" );
			if ( Object != "MACRO" ) {
				if ( XPos( Cur_Char, ";,", 1 ) ) {
					continue;
				}
			}
			First_Word;
			TStr = Copy( Get_Line( ), C_Col, 128 );

SAgain:
			if ( Find_Text( "[{};*]", 0, _RegExp ) ) {
				if ( Found_Str == '*' ) {
					Right;
					if ( Cur_Char != '/' ) {
						Left;
						if ( C_Col == 1 ) {
							Right;
							goto SAgain;
						}
						Left;
						if ( Cur_Char != '/' ) {
							Right;
							Right;
							goto SAgain;
						}
						if ( Find_Text( "*/", 0, 0 ) ) {
							Right;
							Right;
							goto SAgain;
						}
					}
					Right;
				}
				else if ( Found_Str == '{' ) {
					Mark_Pos;
					Eol;
					call Process_Tag;
					Goto_Mark;
					Rm( "C^CMtch " + MParm_Str + "/NM=1/NA=1" );
				}
			}
		}
		else {
			Eol;
		}
	}
	Switch_Window( Src_Win );
	goto Exit;


Process_Tag:
	Switch_Window( Work_Win );
	Goto_Col( 1 );
	Put_Line( Tag_Id + "\t\t" + TStr );
	Down;
	Switch_Window( Src_Win );
	ret;


Exit:
	Tab_Expand = Ttm;
	if ( h_Line ) {
		SetWindowText( h_Line, "" );
	}
}  // Tag_B_CMac

macro tag_b_pascal trans2
/*-----------------09-18-91 01:26pm-----------------
 Build tags for Turbo-Pascal files.     Must be called by TAG_BUILD.
 --------------------------------------------------*/
{
	int				work_win = parse_int('/TW=', mparm_str),
						src_win = cur_window,
						scan_imp = parse_int('/PI=', global_str('METAGS_CONFIG')),
						ttm = tab_expand,
						unit_line = 0,
						interface_line = 0,
						implementation_line = 0,
						jx
						;

	str       sstr,
						tstr,
						object_str[128],
						current_parm[128],
						fn[128] = truncate_path( file_name ),
						tag_id[100],
						seperators[40] = ' |9|255~!@#$%^{}()&*()+=||"'':;<>?,/~`[]'
						;

	int h_line = parse_int("/HLINE=",mparm_str);
	refresh = false;
	tab_expand = TRUE;

	reg_exp_stat = TRUE;
	ignore_case = TRUE;

	tof;
	mark_pos;
	tstr = "{unit}|{program}|{library}";
	call do_search;
	if( found_str == "unit" ) {
		object_str = found_str;
		unit_line = c_line;
		call get_next_object;
		tag_id = current_parm;
		call process_tag;
		pop_mark;
		sstr = "{record}|{object}|{implementation}|{class}";
	} else {
		if((found_str == "library") || (found_str == "program"))
		{
			object_str = found_str;
			unit_line = c_line;
			call get_next_object;
			tag_id = current_parm;
			call process_tag;
			pop_mark;
		}
		sstr = "{record}|{object}|{procedure}|{function}|{implementation}|{constructor}|{destructor}|{class}";
		goto_mark;
	}

	do
	{
		tstr = sstr;
		call do_search;
/*
beep;
make_message("[" + found_str + "]");
read_key;
*/
		object_str = found_str;
		if( (found_str == "object") || (found_str == "class") ) {
			object_str += "\tBASE=";
			mark_pos;
			call get_next_object;
			if( current_parm == "(" ) {
				call get_next_object;
				object_str += current_parm;
			}
			object_str += " ";
			goto_mark;
			goto do_record;
		}
		else if(found_str == "record") {
		do_record:
			mark_pos;
/* this is the old way that did not take into account that the identifier
 and/or the = sign might be on a line above the keyword
			first_word;
*/
			tstr = "=";
			call SCAN_BACK;
			if (svl(tag_id))
				goto UNKNOWN_RECORD;

			tstr = "a-z";
			call SCAN_BACK;
			if (svl(tag_id))
				goto UNKNOWN_RECORD;

			word_left;

			call get_next_object;
			tag_id = current_parm;
UNKNOWN_RECORD:
			call process_tag;
			goto_mark;
			forward_till( seperators );
		}
		else if ((found_str == "procedure") || (found_str == "function") ||
			(found_str == "constructor") || (found_str == "destructor") )
		{
			call get_next_object;
			if( current_parm != ';' ) {
				tag_id = current_parm;
				call process_tag;
			}
		}
		else if( found_str == "implementation" ) {
			if(!scan_imp)
				break;
			sstr = "{record}|{object}|{procedure}|{function}|{constructor}|{destructor}|{class}";
		} else
			break;
	} while ( !at_eof );



	goto exit;

SCAN_BACK:
	do { // find desired stuff while skipping over any comments
		if (!search_bwd("[" + tstr + "})]",0))
			goto BAD_SCAN;
		if (found_str == "}") { // {} comment, skip over it
			if (!search_bwd("@{",0))
				goto BAD_SCAN;
		} else if (found_str == ")") { // (**) comment, skip over it
			if (!search_bwd("(",0))
				goto BAD_SCAN;
		}
	} while (xpos(found_str,"{}()",1));
	tag_id = "";
	RET;

BAD_SCAN:
	tag_id = "UNKNOWN";
	RET;

process_tag:
	mark_pos;
	first_word;
	tstr = get_word('');
	goto_mark;
	switch_window( work_win );
	goto_col(1);
	put_line( tag_id + "\t" + object_str + "\t" + tstr );
	down;
	switch_window( src_win );
	ret;

do_search:
	{
		do {
			if( search_fwd( tstr + "|[@{@']|{(@*}", 0 ) ) {
				if( found_str == "(*" ) {
					search_fwd( "@*)",0 );
					continue;
				}
				if( found_str == "{" ) {
					search_fwd( "@}", 0 );
					continue;
				}
				if( found_str == "'") {
					right;
					search_fwd( "'", 1 );
					continue;
				}
				if( c_col > 1 ) {
					left;
					if( !xpos(cur_char, seperators, 1 ) ) {
						right;
						right;
						continue;
					}
					right;
				}
				goto_col( c_col + length( found_str ) );
				if( xpos(cur_char, seperators, 1 ) ) {
					found_str = lower( found_str );
					break;
				}
			}
			else {
				found_str = "";
				break;
			}
		} while( !at_eof || error_level );
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
		ret;
	}

get_next_object:
	{
		do {
			while( at_eol && !at_eof ) {
				down;
				first_word;
			}
			forward_till_not( '|9|255 ' );
			if( at_eol )
				continue;
			if(cur_char == '{') {
				search_fwd('@}',0);
				continue;
			}
			if(cur_char == '(') {
				right;
				if(cur_char == '*') {
					search_fwd('*)',0);
					continue;
				}
				else {
					left;
					current_parm = cur_char;
					right;
					break;
				}
			}
			if( xpos(cur_char, '+=-);*^[]$%@~!&<>,?/', 1 )) {
				current_parm = cur_char;
				right;
				break;
			}
			current_parm = get_word(seperators);
			break;
		} while( !at_eof );

		ret;
	}

exit:
	tab_expand = ttm;
}


macro tag_b_modula2 trans2
/*-----------------09-18-91 01:26pm-----------------
 Build tags for Modula-2 files.     Must be called by TAG_BUILD.
 --------------------------------------------------*/
{
	int				work_win = parse_int('/TW=', mparm_str),
						src_win = cur_window,
						ttm = tab_expand,
						unit_line = 0,
						interface_line = 0,
						implementation_line = 0,
						jx
						;

	str				tstr,
						object_str[30],
						current_parm[128],
						fn[128] = truncate_path( file_name ),
						tag_id[100],
						seperators[40] = ' |9|255~!@#$%^{}()&*()+=||"'':;<>?,./~`[]'
						;

	int h_line = parse_int("/HLINE=",mparm_str);

	refresh = false;
	tab_expand = TRUE;

	reg_exp_stat = TRUE;
	ignore_case = FALSE;

	tof;

	do
	{
		tstr = "{RECORD}|{PROCEDURE}";
		call do_search;
		object_str = found_str;
		if(found_str == "RECORD") {
		do_record:
			mark_pos;
			first_word;
			call get_next_object;
			tag_id = current_parm;
			call process_tag;
			goto_mark;
			forward_till( seperators );
		}
		else if (found_str == "PROCEDURE" )
		{
			call get_next_object;
			if( current_parm != ';' ) {
				tag_id = current_parm;
				call process_tag;
			}
		} else
			break;
	} while ( !at_eof );

	goto exit;

process_tag:
	mark_pos;
	first_word;
	tstr = get_word('');
	goto_mark;
	switch_window( work_win );
	goto_col(1);
	put_line( tag_id + "\t" + object_str + "\t" + tstr );
	down;
	switch_window( src_win );
	ret;

do_search:
	{
		do {
			if( search_fwd( tstr + "|{(@*}", 0 ) ) {
				if( found_str == "(*" ) {
					search_fwd( "@*)",0 );
					continue;
				}
				if( found_str == "'") {
					right;
					search_fwd( "'", 1 );
					continue;
				}
				if( c_col > 1 ) {
					left;
					if( !xpos(cur_char, seperators, 1 ) ) {
						right;
						right;
						continue;
					}
					right;
				}
				goto_col( c_col + length( found_str ) );
				if( xpos(cur_char, seperators, 1 ) ) {
					break;
				}
			}
			else {
				found_str = "";
				break;
			}
		} while( !at_eof || error_level );
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
		ret;
	}

get_next_object:
	{
		do {
			while( at_eol && !at_eof ) {
				down;
				first_word;
			}
			forward_till_not( '|9|255 ' );
			if( at_eol )
				continue;
			if(cur_char == '{') {
				search_fwd('@}',0);
				continue;
			}
			if(cur_char == '(') {
				right;
				if(cur_char == '*') {
					search_fwd('*)',0);
					continue;
				}
				else {
					left;
					current_parm = cur_char;
					right;
					break;
				}
			}
			if( xpos(cur_char, '+=-);*^[]$%@~!&<>.,?/', 1 )) {
				current_parm = cur_char;
				right;
				break;
			}
			current_parm = get_word(seperators);
			break;
		} while( !at_eof );

		ret;
	}

exit:
	tab_expand = ttm;
}

macro tag_b_dfwin trans2
/****************************Multi-Edit Macro********************************

 NAME:         tag_b_dfwin

 DESCRIPTION:  Builds tags for DFWIN.     Must be called by TAG_BUILD.
               DataFlex 3.0x for Windows
 PARAMETERS:

 RETURNS:

*****************************09-23-91 03:28pm*******************************/
{

	int				work_win = parse_int( "/TW=", mparm_str ),
						src_win = cur_window,
						ttm = tab_expand,
						jx
						;

	str				tstr,
            object_str[40],     // added to hold object string
						fn[128] = truncate_path( file_name ),
						tag_id[100]
						;

	int h_line = parse_int("/HLINE=",mparm_str);
	refresh = false;
	tab_expand = TRUE;

  reg_exp_stat = TRUE;
	ignore_case = TRUE;

	tof;

  while( search_fwd( "{PROCEDURE}|{FUNCTION}|{OBJECT}|{CLASS}|{PROPERTY}|{#REPLACE}|{#COMMAND}[ \t;]|$", 0 ) ) {
		if( c_col != 1 ) {
			left;
      if(!xpos(cur_char,' #|9|255',1) ) {
				right;
				right;
				continue;
			}
			right;
		}
		jx = c_col;
    if(search_bwd('//', 1)) {
			eol;
			continue;
		}
		goto_col(c_col);
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
    object_str = caps(get_word(' |9|255;'));
		first_word;
    if( jx != c_col ) {             //if object_str and first word are not the same
      tag_id = get_word(' |9|255'); //then first word is tag_id
		}
		else
		{
      if ( object_str == "PROPERTY" ) // If PROPERTY, skip the type to get name.
      {
        word_right;
      }
      if ( object_str == "PROCEDURE" )  // If PROCEDURE, check to see if it's a PROCEDURE SET and compensate.
      {
        word_right;
        tag_id = caps(get_word(' |9|255;'));
        if ( tag_id == "SET" )
        {
          word_right;
          tag_id = caps(get_word(' |9|255;'));
        }
      }
      else
      {
        word_right;
        tag_id = caps(get_word(' |9|255;'));
      }
      if ( object_str == "#REPLACE" )
      {
          word_right;
          tag_id = caps(get_word(' |9|255;'));
      }
      if ( object_str == "#COMMAND" )
      {
          word_right;
          tag_id = caps(get_word(' |9|255;'));
      }
    }
		first_word;
		tstr = get_word('');
		eol;
    if ( tag_id != '' ) {                // process only valid tag id's
      call process_tag;
    }                                    //
	}
	switch_window( src_win );

	goto exit;

process_tag:
	switch_window( work_win );
	goto_col(1);
  put_line( tag_id + "\t" + object_str + "\t" + tstr ); // include tag type
  down;
	switch_window( src_win );
	ret;

exit:
	tab_expand = ttm;
}


macro tag_b_pal trans2
/****************************Multi-Edit Macro********************************

 NAME:         tag_b_pal

 DESCRIPTION:  Builds tags for Paradox.     Must be called by TAG_BUILD.

 PARAMETERS:

 RETURNS:

*****************************09-23-91 03:28pm*******************************/
{

	int				work_win = parse_int( "/TW=", mparm_str ),
						src_win = cur_window,
						ttm = tab_expand,
						jx
						;

	str				tstr,
						fn[128] = truncate_path( file_name ),
						tag_id[100]
						;

	int h_line = parse_int("/HLINE=",mparm_str);

	refresh = false;
	tab_expand = TRUE;

	reg_exp_stat = TRUE;
	ignore_case = TRUE;

	tof;

	while( search_fwd( 'proc[ |9]', 0 ) ) {
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
		jx = c_col;
		first_word;
		if( jx == c_col ) {
			forward_till( ' |9|255' );
			forward_till_not( ' |9|255' );
			tag_id = get_word( ' |9|255(' );
			if( caps(tag_id) == 'CLOSED' ) {
				word_right;
				tag_id = get_word( ' |9|255(' );
			}
			first_word;
			tstr = get_word('');
			call process_tag;
		}
		else
			eol;
	}
	switch_window( src_win );

	goto exit;

process_tag:
	switch_window( work_win );
	goto_col(1);
	put_line( tag_id + "\t\t" + tstr  );
	down;
	switch_window( src_win );
	ret;

exit:
	tab_expand = ttm;
}

macro tag_b_asm trans2
/****************************Multi-Edit Macro********************************

 NAME:         tag_b_asm

 DESCRIPTION:  Builds tags for ASM.     Must be called by TAG_BUILD.

 PARAMETERS:

 RETURNS:

*****************************09-23-91 03:28pm*******************************/
{

	int				work_win = parse_int( "/TW=", mparm_str ),
            tag_labels = parse_int('/AL=', global_str('METAGS_CONFIG')),
						src_win = cur_window,
						ttm = tab_expand,
						jx
						;

	str				tstr,
						object_str[40],     // added to hold object string
						fn[128] = truncate_path( file_name ),
						tag_id[100]
						;

	int h_line = parse_int("/HLINE=",mparm_str);
	refresh = false;
	tab_expand = TRUE;

	reg_exp_stat = TRUE;
	ignore_case = TRUE;

  if (tag_labels) {
    tof;
    while (search_fwd("%[~ \t]?*:[ \t;]|$", 0)) {
//      eol;
/*
make_message("found [" + get_line + "]");
read_key;
*/
      goto_col(length(found_str));
      if (h_line) {
        SetWindowText(h_line,str(c_line));
      }
      if (xpos(";",get_line, 1)) {
        if (xpos(";",get_line, 1) < c_col) {
          continue;
        }
      }
/*
make_message("saving [" + get_line + "]");
read_key;
*/
      object_str = 'LABEL';
      tstr = get_line;
      goto_col(1);
      tag_id = get_word(": \t");
      word_right;
      if (xpos("" + get_word(" \t") + "", "DBDWDDEQUPROCSTRUCRECORDUNIONLABELMACRO",1))  {
        eol;
        continue;
      }
      eol;
			call process_tag;
    }
  }
	tof;
	while( search_fwd( "{PROC}|{STRUC}|{RECORD}|{UNION}|{LABEL}|{MACRO}|{EQU}|{DB}|{DW}|{DD}[ \t;]|$", 0 ) ) { // added equ, db, dw, dd
		if( c_col != 1 ) {
			left;
			if(!xpos(cur_char,' |9|255',1) ) {
				right;
				right;
				continue;
			}
			right;
		}
		jx = c_col;
		if(search_bwd(';', 1)) {
			eol;
			continue;
		}
		goto_col(c_col);
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
		object_str = caps(get_word(' |9|255;')); // changed tag_id to object_str
		first_word;
		if( jx != c_col ) {   //if object_str and first word are not the same
			tag_id = get_word(' |9|255');  //then first word is tag_id
		}
		else
		{
			if ( (object_str == 'DB') ||       // ignore blank tag id's if
					 (object_str == 'DW') ||       // tag type is db, dw or dd
					 (object_str == 'DD') ) {      //
				tag_id = '';                     //
			} else {                           // otherwise tag_id is next word
				word_right;
				tag_id = get_word(' |9|255;');
			}                                  //
		}
		first_word;
		tstr = get_word('');
		eol;
		if ( tag_id != '' ) {                // process only valid tag id's
      if (tag_labels) {
        if (object_str == "LABEL") {
          object_str = "LABEL directive";
        }
      }
			call process_tag;
		}                                    //
	}
	switch_window( src_win );

	goto exit;

process_tag:
	switch_window( work_win );
	goto_col(1);
	put_line( tag_id + "\t" + object_str + "\t" + tstr ); // include tag type
//  put_line( tag_id + "\t\t" + tstr  ); // handled in above line
	down;
	switch_window( src_win );
	ret;

exit:
	tab_expand = ttm;
}

macro tag_b_xbase trans2
/****************************Multi-Edit Macro********************************

 NAME:         tag_b_xbase

 DESCRIPTION:  Builds tags for xBase.     Must be called by TAG_BUILD.

 PARAMETERS:

 RETURNS:

*****************************09-23-91 03:28pm*******************************/
{

	int				work_win = parse_int( "/TW=", mparm_str ),
						src_win = cur_window,
						ttm = tab_expand,
						jx, jy
						;

	str				tstr,
						fn[128] = truncate_path( file_name ),
						tag_id[100]
						;

	int h_line = parse_int("/HLINE=",mparm_str);
	refresh = false;
	tab_expand = TRUE;

	reg_exp_stat = TRUE;
	ignore_case = TRUE;

  // mod to create a tag from the .prg file name
  tstr = fn;
  tag_id = truncate_extension(fn);
  call process_tag;
  tstr = "";
  tag_id = "";
	tof;

	while( search_fwd( "{PROC}|{FUNC}|{METHOD}", 0 ) ) {
		jx = c_col;
		first_word;
		if( caps(get_word(' |9|255{')) == "STATIC") {
			word_right;
		}
		else
				first_word;
		if( jx == c_col ) {
			tstr = " " + caps(get_word(' |9|255{')) + " ";
			if( jy = xpos( tstr, " PROC FUNC PROCEDURE FUNCTION METHOD ", 1) ) {
		if (h_line) {
			SetWindowText(h_line,str(c_line));
		}
				word_right;
		 //	if( jy == 2 ) {
		 //		word_right;
		 //	}
				tag_id = get_word(' |9|255(');
				first_word;
				tstr = get_word('');
				eol;
				call process_tag;
			}
		}
		else {
			goto_col(jx);
			right;
		}
	}
	switch_window( src_win );

	goto exit;

process_tag:
	switch_window( work_win );
	goto_col(1);
	put_line( tag_id + "\t\t" + tstr  );
	down;
	switch_window( src_win );
	ret;

exit:
	tab_expand = ttm;
}

#include COMMDLG.SH
#include FPROMPT.SH
#include EXIT.SH

macro TagFilePrompt {

	str tstr[max_line_length];
	int dlg = parse_int("/DLGHANDLE=", mparm_str);
	int tid = window_id;
	int tr = refresh;
	int textid = parse_int("/FIELD=", mparm_str);
	int result;
	int flags = _FP_FLAG_TAG_FILES | _FP_FLAG_FTO;

	refresh = false;
	GetDlgItemText(dlg, textid, tstr, max_line_length );
	result = FileNamePrompt( tstr,"Select Files To Scan", "FILE_HISTORY", TAGWILD_HELPLINK, flags );
	if ( Result ) {
		if ( Flags & _FP_FLAG_TAGS ) {
			Switch_Win_Id( Result );
			tof;
			tstr = Get_Line;
			down;

			while(!at_eof)
			{
				tstr += ";" + Truncate_Path(Get_Line);
				down;
			}
			delete_window;
	//		window_attr=0;
	//		make_window_visible(1);
		}
		SetDlgItemText(dlg, textid, tstr );
	}

	switch_win_id( tid );
	refresh = tr;
	return_int = 0;
}

macro Tag_Scan_Files trans2 no_break {
/*-----------------09-18-91 12:44pm-----------------
 Tag scans multiple files via dos wildcard.
 Parameters:
		/F=str		Wildcard file spec.  If /F= is not
							passed, then the user is prompted
							for the wildcard spec.
 --------------------------------------------------*/

	int jx,
			first_find,
			ow = window_id,
			tw,
			tw_id = window_id,
			scan_level = 0,
			do_break = 0,
			x = 5, y = 4, w = 65, l = 14,
			t_search_attr = file_search_attr,
			big_str_pos,
			uo = parse_int("/WU=", global_str("METAGS_CONFIG")),
			sd = global_int("TAG_SCAN_DIRS");

	str fstr[260] = "",
			big_str[max_line_length],
			path_str,
			tstr,
			search_path[260];            // solve subdirectory problems


	Refresh = False;

	set_global_int("MENU_LEVEL", global_int("MENU_LEVEL") + 1 );
	switch_window( window_count );
	create_window;
	tw = cur_window;
	tw_id = window_id;
	return_str = parse_str('/F=', mparm_str );
	if ( Return_Str == "" ) {
		Jx = Parse_Int( "/#=", Global_Str( "TagHistory" ) );
		Return_Str = Global_Str( "TagHistory" + Str( Jx ) );
		call Prompt;
		if ( !Return_Int ) {
			goto Exit;
		}
	}

  struct WIN32_FIND_DATA NewFd;
  struct DOS_FIND_DATA 	 OldFd;

  int hFindFile = 0;

	int active_win_id = window_id,
			t_win_id = 0;

	Tag_Scan_Dlg( "Wild Card Tag Scan", True );

	// this stuff handles multiple filespecs separated by spaces
	big_str = return_str;

	path_str = "";

	// take care of multiple file specs separated by semicolons
  while (big_str_pos = xpos(" ", big_str, 1))  {
    big_str = copy(big_str, 1, big_str_pos - 1) + ";" +
              copy(big_str, big_str_pos + 1, max_line_length);
  }


	while (big_str_pos = xpos(";" , big_str, 1)) {
		return_str = copy(big_str, 1, big_str_pos - 1);
		if(get_path(return_str) != "")
		{
			path_str = get_path(return_str);
		}
		else
		{
			return_str = path_str + return_str;
		}

		big_str = copy(big_str, big_str_pos + 1, max_line_length);
		call do_scan;
	}

	return_str = big_str;
	if (get_path(return_str) == "") {
		return_str = path_str + return_str;
	}
	call Do_Scan;

	Destroy_Mew_Dlg( g_h_main_dlg );

	if (switch_win_id(g_list_win_id)) {
		delete_window;
	}
	switch_win_id(active_win_id);

	goto Exit;


Do_Scan:
	{
		First_Find = 1;
		++Scan_Level;
		FStr = FExpand( Return_Str );
		//messagebox(0,fstr + " " + return_str,"fstr", mb_ok);

		SetWindowText( g_h_Path, FStr );

		Working;
		// Scan subdirectories
		if ( Sd ) {
			hFindFile = FindFirstFile( Get_Path( FStr ) + "*.*", &NewFd, &OldFd );
			if ( hFindFile ) {
				do {
					call Check_Abort;
					if ( Do_Break ) {
						break;
					}
					if ( NewFd.dwFileAttributes & 0x10 ) {
						if ( ( NewFd.cFileName != "." ) && ( NewFd.cFileName != ".." ) ) {
							Set_Global_Int( "SCAN_REC_" + Str( Scan_Level ), hFindFile );
							Set_Global_Str( "SCAN_NAME_" + Str( Scan_Level ), FStr );
							Struct_To_Str( tstr, OldFd );
							Set_Global_Str( "SCAN_OLDR_" + Str( Scan_Level ), tstr );

							Return_Str = Get_Path( FStr ) + NewFd.cFileName + "\\" +
									Truncate_Path( FStr );
							call Do_Scan;
							hFindFile = Global_Int( "SCAN_REC_" + Str( Scan_Level ) );
							FStr = Global_Str( "SCAN_NAME_" + Str( Scan_Level ) );
							tstr = Global_Str( "SCAN_OLDR_" + Str( Scan_Level ));
							Str_To_Struct( OldFd, tstr );
							First_Find = 1;
						}
					}
				} while ( FindNextFile( hFindFile, &NewFd, &OldFd ) );
				FindClose( hFindFile );
			}
		}
		SetWindowText( g_h_Path, FStr );

		Search_Path = Get_Path( FStr ); // solve subdirectory problems

		hFindFile = FindFirstFile( FStr, &NewFd, &OldFd );
		if ( hFindFile ) {
			do {
			 	call Check_Abort;
			 	if ( Do_Break ) {
			 		break;
			 	}

				if ( NewFd.dwFileAttributes & 0x10 ) {
					continue;
				}
				t_win_id = window_id;
				switch_win_id(g_list_win_id);
				eof;
				if ( C_Col > 1 ) {
					Down;
				}
				SendMessage( g_h_list, WM_SETREDRAW, 0, 0);
				if (first_find) {
					put_line(fstr);
					SendMessage( g_h_list, LB_ADDSTRING, 0, 0 );
					first_find = false;
					down;
				}
				Put_Line( "  " + NewFd.cFileName );
				SendMessage( g_h_list, LB_ADDSTRING, 0, 0 );
				sendmessage( g_h_list, LB_SETCURSEL, c_line - 1, 0);
				SendMessage( g_h_list, WM_SETREDRAW, 1, 0);
				sendmessage( g_h_list, WM_ML2_REDRAW,0,0 );
				switch_win_id(t_win_id);
				SetWindowText( g_h_file, NewFd.cFileName );
				if ( Uo ) {

					int Tt = OldFd.Time;
					int Tn;

					Rm( "Tag_Find_File /F=1/FN=" + Search_Path + NewFd.cFileName );  // because last_file_name
					if ( Return_Int ) {
						Tn = Parse_Int( "DT=", Get_Line( ) );
						if( tt == tn ) {             // because user might have backed

							t_win_id = window_id;
							switch_win_id(g_list_win_id);
							put_line(get_line + "  ...file not changed");
							sendmessage( g_h_list, WM_ML2_REDRAW,0,0 );
							switch_win_id(t_win_id);
							switch_win_id(tw_id);
							goto skip_build;
						}
					}
					switch_win_id(tw_id);
				}
				Return_Str = Search_Path + NewFd.cFileName;
      	switch_win_id(tw_id);
				load_file(return_str);

				t_win_id = window_id;
				switch_win_id(g_list_win_id);
				put_line(get_line + ".");
				sendmessage( g_h_list, WM_ML2_REDRAW,0,0 );
				switch_win_id(t_win_id);

				if ( Error_Level == 0 ) {

					Rm( "Tag_Build /WW=1/DT=" + Str( OldFd.Time ) +
							"/HDLG=" + Str( g_h_main_dlg ) + "/HLINE=" + Str( g_h_line ) +
							"/HFILE=" + Str( g_h_file ) );
				}

Skip_Build:

				Error_Level = 0;
			} while ( FindNextFile( hFindFile, &NewFd, &OldFd ) );
			FindClose( hFindFile );
		}
		Set_Global_Str( "SCAN_REC_" + Str( Scan_Level ), "" );
		Set_Global_Str( "SCAN_NAME_" + Str( Scan_Level ), "" );
		--Scan_Level;
		ret;
	}


prompt:
	{
		{
			str f[max_line_length] = return_str;
			int active_window = window_id;

			int dlg,result;

			DlgCreate(dlg);

			DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_TAGS_104", 1, 1, 0,0,-1,0, "" );
			DlgAddCtrl( dlg, DLG_Static, "&File(s):", 8, 2, 0, 2,-1,0, "" );
			DlgAddCtrl( dlg, DLG_Text, return_str, DLG_PosOffset + 10, DLG_PosOffset, 50, 0, 1000, 0, "/ML=" + str(max_line_length) + "/HISTORY=TAGHISTORY" );
			DlgAddCtrl( dlg, DLG_PushButton, "...", 69, DLG_PosOffset, 0, 0, 120, 0, "/R=120/M=TagFilePrompt /FIELD=1000" );
			DlgAddCtrl( dlg, DLG_CheckBox, "&Scan subdirectories", 10, DLG_PosOffset + 2, 0, 0,2000,0, "" );
			DlgSetInt(dlg, 2000, sd );
			DlgAddCtrl( dlg, DLG_CheckBox, "&Changed files only", DLG_PosOffset, DLG_PosOffset + 1, 0, 0,2001,0, "" );
			DlgSetInt(dlg, 2001, uo );
			DlgAddCtrl( dlg, DLG_PushButton, "OK", 8, DLG_PosOffset + 2, DLG_StanBtnWidth,0,110,0, "/R=1" );
			DlgAddCtrl( dlg, DLG_PushButton, "Cancel", 20, DLG_PosOffset, DLG_StanBtnWidth,0,111,0, "/R=0" );
			DlgAddCtrl( dlg, DLG_PushButton, "&Help", 62, DLG_PosOffset, DLG_StanBtnWidth,0,112,0, "/R=2" );

			result = DlgExecute( dlg, 1000,"Wildcard Tag Scan", TAGWILD_HELPLINK,"", 0 );
			return_int = result;
			switch_win_id(active_window);

			return_str = f;
			if (return_int) {
				return_str = DlgGetStr(dlg, 1000 );
				sd = DlgGetInt( dlg, 2000 );
				uo = DlgGetInt( dlg, 2001 );
				set_global_int("TAG_SCAN_DIRS", sd );
			}
			DlgKill(dlg);
		}
		ret;
	}


Check_Abort:
	if ( Tag_Scan_Chk_Msg( ) ) {
		if ( VerifyDlg( "Abort tag scanning?", "", "", 0, True ) == id_std_Yes ) {
			Make_Message( "Scan aborted." );
			Do_Break = True;
		}
	}
	ret;



exit:
	set_global_int("MENU_LEVEL", global_int("MENU_LEVEL") - 1 );
	delete_window;
	switch_win_id( ow );
}


macro Tag_Configure no_break
{
	int ow = window_id,
			dlg
			;
	int SavRefresh = Refresh;

	str TStr = Global_Str( "MeTags_Config" );

	Refresh = False;


	DlgCreate(dlg);
	return_str = parse_str( "/DF=", tstr );
	if( return_str == "" )
		return_str = "METAGS.TAG";
		DlgAddCtrl( dlg, DLG_BitmapStatic, "BT_TAGS_100", 1, 1, 0,0, 1100, 0, "" );

  DlgAddCtrl( dlg, DLG_BlackRect, "", 1, 3, 61, 7, 1200, 0, "");

	DlgAddCtrl( dlg, DLG_Static, "&Default tag file:", 7, Dlg_Units + 4, 0,0, 1101, 0, "" );
	DlgAddCtrl( dlg, Dlg_Text, return_str, Dlg_PosOffset + 16, Dlg_NegOffset + Dlg_Units + 2, 16,0, 1102, 0, "" );

	DlgAddCtrl( dlg, DLG_CheckBox, "&Tag \"#define\" in C/C++ files",1,DLG_PosOffset + Dlg_Units + 20,0,0,1103,0,"");
	DlgSetInt( dlg, 1103,parse_int("/TD=", tstr));

	DlgAddCtrl( dlg, DLG_CheckBox, "Locate tags in IMPLEMENTATION section of &PASCAL files", Dlg_PosOffset, DLG_PosOffset + 1,59,0,1104,0,"");
	DlgSetInt( dlg, 1104,parse_int("/PI=", tstr));

  DlgAddCtrl( dlg, DLG_CheckBox, "Tag all labels in &ASM files", Dlg_PosOffset, DLG_PosOffset + 1,59,0,1105,0,"");
  DlgSetInt( dlg, 1105,parse_int("/AL=", tstr));

  DlgAddCtrl( dlg, DLG_CheckBox, "&Wild-card scan updates only changed files", DLG_PosOffset, DLG_PosOffset + 1,0,0,1106,0,"");
  DlgSetInt( dlg, 1106,parse_int("/WU=", tstr));

  DlgAddCtrl( dlg, DLG_CheckBox, "&Browse files first", DLG_PosOffset, DLG_PosOffset + 1,0,0,1107,0,"");
  DlgSetInt( dlg, 1107,parse_int("/EB=", tstr));

  DlgAddCtrl( dlg, DLG_CheckBox, "&Store scanned file paths in tag file", DLG_PosOffset, DLG_PosOffset + 1,0,0,1108,0,"");
  DlgSetInt( dlg, 1108,parse_int("/SP=", tstr));

  DlgAddCtrl( dlg, DLG_CheckBox, "S&ort tags", DLG_PosOffset, DLG_PosOffset + 1,0,0,1109,0,"");
  DlgSetInt( dlg, 1109,parse_int("/SORT=", tstr));

	DlgAddCtrl( dlg, DLG_PushButton,
    "Define &language-specific tag files", 10, Dlg_PosOffset + Dlg_Units + 20, 40, 0, 1110, 0,
			"/R=/M=DB /LT=Language Specific Tag Files/DT=Define Tag File/F=MECONFIG/DPT=MULTITAGS.CFG/HF=MEWHDRS.DB/HPT=MULTITAGS.HDR");

	DlgAddCtrl( dlg, DLG_PushButton, "OK", 1, Dlg_PosOffset + Dlg_Units + 24, Dlg_StanBtnWidth, 0, go_ctrl, Dlgf_DefButton, "/R=1");
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + 13, DLG_PosOffset, Dlg_StanBtnWidth, 0, done_ctrl, 0, "/R=0");
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", Dlg_PosOffset + 35, DLG_PosOffset, Dlg_StanBtnWidth, 0, help_ctrl, 0, "/R=2");



	if (DlgExecute( dlg, 1102, "Multi-Tags Configuration", TAGCONFIG_HELPLINK, "", 0)) {

		rm("setconfig /DB=MECONFIG/T=MULTITAGS.CFG/C=1");

		if( return_int ) {
			put_line("\fMULTITAGS.CFG /DF=" + DlgGetStr( dlg, 1102) +
																"/TD=" + str(DlgGetInt( dlg, 1103)) +
																"/PI=" + str(DlgGetInt( dlg, 1104)) +
                                "/AL=" + str(DlgGetInt( dlg, 1105)) +
                                "/WU=" + str(DlgGetInt( dlg, 1106)) +
                                "/EB=" + str(DlgGetInt( dlg, 1107)) +
                                "/SP=" + str(DlgGetInt( dlg, 1108)) +
                                "/SORT=" + str(DlgGetInt( dlg, 1109))
																);
		}
		Rm( "Tag_Init /REINIT=1" );
	}
	DlgKill(Dlg);
	switch_win_id( ow );
	Refresh = SavRefresh;

}

macro Tag_Init trans2
{
	if ( ( Global_Str( "MeTags_Config" ) == "" ) ||
			( Parse_Int( "/REINIT=", MParm_Str ) ) ) {

		int ow = window_id;
		int SavRefresh = Refresh;

		Refresh = False;
		Rm( "SetConfig /DB=MECONFIG/T=MULTITAGS.CFG/C=1" );
		Set_Global_Str( "MeTags_Config", Get_Line( ) );
		Return_Str = Parse_Str( "/DF=", Global_Str( "MeTags_Config" ) );
		Rm( "XlateCmdLine" );
		Set_Global_Str( "MeTags_File_Name", Return_Str );
		Down;
		while ( !At_Eof && ( Cur_Char != "\f" ) ) {
			Return_Str = Parse_Str( "\x7F" + "FILE=", Get_Line( ) );
			Rm( "XlateCmdLine" );
			Set_Global_Str( "Tag_F_" + Parse_Str( "\x7F" + "LS=", Get_Line( ) ),
					Return_Str );
			Down;
			Goto_Col( 1 );
		}
		if ( File_Changed ) {
			Save_File;
		}
		Switch_Win_Id( Ow );
		Refresh = SavRefresh;
	}
}  // Tag_Init

macro tag_install
{
	rm("MEERROR^MessageBox /M=To complete the installation of Multi-Tags, we suggest that you select the buttons to automatically create User menu and keymap entries.  Hit <F1> from the configure dialog for detailed info.");
	rm("tag_configure");
}
