// $Header: /MEWIN/SRC/LANGUAGE.SH 4     4/23/96 1:15p Todd $

// Header file for Language

#define _db_lang_Page				"LANGUAGE.DB"

// Language config field constants
#define _db_lang_Type				"LANG"
#define _db_lang_Case				"CS"
#define _db_lang_ResWord1		"RW1"
#define _db_lang_ResWord2		"RW2"
#define _db_lang_ResWord3		"RW3"
#define _db_lang_ResWord4		"RW4"
#define _db_lang_Symbols		"SYM"
#define _db_lang_Strings		"STR"
#define _db_lang_Numeric		"NC"
#define _db_lang_Literal		"LIT"
#define _db_lang_OpenCmt1		"OC1"
#define _db_lang_CloseCmt1	"CC1"
#define _db_lang_OpenCmt2		"OC2"
#define _db_lang_CloseCmt2	"CC2"
#define _db_lang_EolCmt1		"EOL"
#define _db_lang_EolCol1		"EOC"
#define _db_lang_EolCmt2		"EOL2"
#define _db_lang_EolCol2		"EOC2"
#define _db_lang_CfgMac			"CFGMAC"
#define _db_lang_InitMac		"INIMAC"
#define _db_lang_IndentMac	"INDMAC"
#define _db_lang_MatchMac		"MATMAC"
#define _db_lang_FindTagMAc	"FTMAC"
#define _db_lang_Properties	"PROP"

// Language match construct delimiter constants
#define _mtchBeg    "\x7F" + "B="
#define _mtchMid    "\x7F" + "M="
#define _mtchEnd    "\x7F" + "E="
#define _mtchExp    "\x7F" + "X="

#define _mtchBChars "\x7F" + "B="
#define _mtchEChars "\x7F" + "E="

#define _LangRecGlob				"!LangRec_"

#define LANGUAGES_HELPLINK	"LANGUAGES"

global {
  int g_LangInCmt   "!LangInCmt";
}
// Comment character structure
structure tCommentChars {
	str szOpenComment1;
	str szCloseComment1;
	str szOpenComment2;
	str szCloseComment2;
	str szEOLComment1;
	str szEOLComment2;
}

prototype Language {
	int LangGetRecord( str &Language, str &Record );
/******************************************************************************
	Function: Get the language config record for Language.

	Entry   : str Language	- The language to get the config data for.  If "" then
														use the file name specified in Record or the
														current file name to determine the language.

						str Record		- A variable used to return the record data.  When
														Language is "" Record can contain a file name to
														use to determine the language or "" to use current
														file name.

	Exit    : int
							_NoError					- Record found.
								Language					- The selected language name.
								Record						- The config data for Language.

							_ErrorNoDbRecord	- Error no record found.
								Language					- The selected language or "".
								Record						- "".
********************************************************************( ldh )***/

	int LangDoMatch( str LangPrefix, str MatchStr, str ParmStr );
/******************************************************************************
  Function: Find matching language constructs.

	Entry   : str LangPrefix	- The first three character of the language 	(/LP=)
						str MatchStr		- The string to match, if "" then find string (/MS=)
						str ParmStr			- Additional parameters
 							/HI=1    				- Highlight block
							/RC=1    				-	Restore cursor to original position
							/LS=x    				-	Limit scope of search to x number of lines
							/NM=1						- Display no messages
							/NA=1						- No check for abort
							/IC=1						- Starting match in comment
  															(Only used when MatchStr is passed)

	Exit    : Return_Int
						 -1					- Search aborted
							0         - Match found
							1         - No match found
********************************************************************( ldh )***/

  int Match( );
/******************************************************************************
	Function: Calls the matching macro defined for the language specified by
						the filename extension of the current file.  If no macro is defined,
						the macro name is determined by the first three characters of the
						language type followed by 'MTCH'. For example, the pascal matching
						macro would be named 'PASMTCH', the C macro would be 'CMTCH'
******************************************************************************/

	void LangCloseParen( str LangPrefix, str ParmStr );
/******************************************************************************
	Function: Auto match the opening paren for the specified language.

	Entry   : str LangPrefix	- The first three letters of the language (/LP=)
						str ParmStr			- Additional parameters 		 ( See LangDoMatch )
********************************************************************( ldh )***/

	void GetCommentChars( struct tCommentChars rCC );
/******************************************************************************
  Function: Fill the tCommentChars structure rCC with the comment chars for the
						language specified by the current file.

  Entry   : struct tCommentChars rCC	- Structure to contain comment chars
********************************************************************( ldh )***/

	void Comment( );
/******************************************************************************
  Function: Control function for comment support macros.  Autodetects whether
						to comment or uncomment a code block.
********************************************************************( ldh )***/

	void CommentCode( );
/******************************************************************************
  Function: Translates current block mark into a comment block
							If Block_Stat = 0,  current line using open,close comment string
															1,  current line using eol comment string
															2,  remainder of current line using eol string
															3,  start,end block mark with comment chars
********************************************************************( ldh )***/

	void UnCommentCode( );
/******************************************************************************
  Function: Translates current block mark to uncommented code block.
********************************************************************( ldh )***/
}