// Header file for IdExe

// Base Os Constants
#define _BaseOs_Unknown 0
#define _BaseOs_Dos     1
#define _BaseOs_Os2     2
#define _BaseOs_Nt      3
#define _BaseOs_Windows 4

// Exe Type Constants
#define _Exe_Id_Unknown 0x0000
#define _Exe_Id_Dos     0x0001
#define _Exe_Id_Windows 0x0002
#define _Exe_Id_Os2     0x0004
#define _Exe_Id_Nt      0x0008

#define _Exe_Id_OsMask	0x000F

#define _Exe_Id_Cui		  0x0100
#define _Exe_Id_Gui			0x0200

#define _Exe_Id_Bound   0x8000

global {
	int BaseOs            "&BaseOs";
	int ExeType						"&ExeType";
}

prototype IdExe {
	int IdExe( str Program );
/******************************************************************************
	Function: Determines the Executable type of Program.  Can detect DOS,
						Windows, OS/2, NT and Bound Windows and Bound OS/2 programs.

	Entry   : str Path          - Name of executable to check (Full path neede).
	Exit    : int               - Type of EXE file
							_Exe_Id_Unknown     Error or unknow type.
							_Exe_Id_Dos         Dos program.
							_Exe_Id_Windows     Windows programs (16bit)
							_Exe_Id_Os2         OS/2 programs (16 and 32bit) and Dos PMode
							_Exe_Id_Nt          NT programs ( Win32 )

							_Exe_Id_Cui					Command line interface program ( OS/2, NT )
							_Exe_Id_Gui					Graphical user interface program ( OS/2, NT )
							_Exe_Id_Bound       Specified a Dos bound program with a OS/2 or
																	Windows program.
	Globals : int &BaseOs
						int &ExeType

	Macros  : int IdBaseOs
********************************************************************( ldh )***/

	int GetDosVersion( );
/******************************************************************************
	Function: Returns the version number of the running OS. (Major, Minor).

	Exit    : int     - Version of running OS.
												(Major in High byte, Minor in Low byte)
********************************************************************( ldh )***/

	int IsOs2( );
/******************************************************************************
	Function: Returns True if OS/2 is running.

	Entry   : None.

	Exit    : int
							True  - OS/2 is running.
							False - OS/2 in NOT running.

	Globals : None.

	Macros  : int GetDosVersion
********************************************************************( ldh )***/

	void IdExeGetHdr( str Program );
/******************************************************************************
	Function: Read the header information from Program and write it to the
						IDEXE.BIN file.  This is used to help us identify programs that fail
						the IdExe classification tests and allow us to fix the macro to
						correctly identify Program.

	Entry   : str Program - The name of a program with full path.
********************************************************************( ldh )***/

	int IdBaseOs( );
/******************************************************************************
  Function: Determine the running Operating System.

  Exit    : int
							_BaseOs_Unknown
							_BaseOs_Dos
							_BaseOs_Os2
							_BaseOs_Nt
							_BaseOs_Windows 	- Windows 95
********************************************************************( ldh )***/
}
