macro_file DLG_EXAM;
/********************************* EXAMPLE DIALOGUES *************************************
This file, DLG_EXAM.S contains several samples in creating dialog boxes for user input
and the displaying of results.  There are 5 examples.  Plus, it shows the INCLUDES that
must be in the macro file and how to include the defines for each type.  Only those
defines that will be needed for your macro need be listed.

The first, DLG_EXAMPLE, is a
summary of different styles that can be used.  Some are commented out to make room for
others but needed to be included.  To see them remove the comment markers for the one
you wish to view and comment another to make room.  This dialog is full screen.

The second, DLG_EXAMPLE2, demonstrates attaching a macro to the dialog.

The third, DLG_EXAMPLE3, just displays the current directory in a text box.  In addition,
control of the placement of the dialog on the screen is shown.

The fourth, DLG_EXAMPLE4, shows the use of a 3-state check box.  Although this is not
the type normally used, the use of a 2-state is similar.  In addition, a HOOK is used
to display various messages in the text box depending on the state of the check box.

The last one, DLG_EXAMPLE5, uses the RADIO style, uses a hook to change a text box, and
uses a TEXT LIST box to display files in the current MEW directory.  In addition, a ICON
is displayed within the dialog box.  This window is modeless, will remain on the screen
if the main window is selected.  This action is similar to that of the LINEDRAW.

These are examples only.  Feel free to experiment with to accomplish the type of display
you may need.

*****************************************************************************************/

#include WINDOWS.SH      // Be sure to add these inclusions
#include DIALOG.SH       //header file that contains the def for DlgExecute

// ****************** defines for dlg_example *********************
#define field_width 26
/* defines for dialog control id's.  You can hard code these in the
   DlgAddCtrl() call, but using defines is recommended for clarity.
   Each control in the dialog box MUST have its own and unique
   identifier number.  You can, however, use the same defines for
   more than one dialog box (like for OK, Cancel and Help), even
   if the dialog boxes are active at the same time since Windows
   will assign each dialog box its own handle */

/* We are defining the controls in pairs.  The one with _TITLE_ in
   it is for the static (title) control, and the one without is the
  "action" control.*/

#define text_title_ctrl      1010
#define text_ctrl            1020

#define integer_title_ctrl   1030
#define integer_ctrl         1040
#define realnum_title_ctrl   1050
#define realnum_ctrl         1060
#define choice_title_ctrl    1070
#define choice_ctrl          1080
#define hex_title_ctrl       1090
#define hex_ctrl             1100
#define mbtnint_title_ctrl   1110
#define mbtnint_ctrl         1120
#define mbtnstr_title_ctrl   1130
#define mbtnstr_ctrl         1140
#define keycode_title_ctrl   1150
#define keycode_ctrl         1160
#define static_title_ctrl    1170
#define static_ctrl          1180
#define PushBtn_title_ctrl   1190
#define PushBtn_ctrl         1200
#define Radio_title_ctrl     1210
#define Radio1_ctrl          1220
#define Radio2_ctrl          1230
#define Checkbox_title_ctrl  1240
#define Checkbox_ctrl        1250
#define Checkbox_ctrl2       1252
#define Checkbox_ctrl3       1254
#define Checkbox_ctrl4       1256
#define ListText_title_ctrl  1260
#define ListText_ctrl        1270
#define ViewText_title_ctrl  1280
#define ViewText_ctrl        1290
#define HiddenStr_title_ctrl 1300
#define HiddenStr_ctrl       1310
#define HiddenInt_title_ctrl 1320
#define HiddenInt_ctrl       1330
#define GroupBox_title_ctrl  1340
#define GroupBox_ctrl        1350
#define BlackFram_title_ctrl 1360
#define BlackFram_ctrl       1370
#define GreyFrame_title_ctrl 1380
#define GreyFrame_ctrl       1390
#define WhiteFram_title_ctrl 1400
#define WhiteFram_ctrl       1410
#define ListBox_title_ctrl   1420
#define ListBox_ctrl         1430
#define Dlg_3state_ctrl      1440
#define Dlg_text_ctrl        1450
#define Dlg_icon_ctrl        1460
#define BitmapBtn_ctrl       1470
#define Bitmap_Title_ctrl    1480
#define BitmapStatic_ctrl    1490
#define BitmapDef_Title_ctrl 1500
#define BitmapDef_ctrl       1510
#define Icon_Title_ctrl      1520
#define Icon_ctrl            1530



#define OK_ctrl              101
#define Cancel_ctrl          102
#define Help_ctrl            103

global {
  int radio_hdlg            "!RADIO_HDLG";
}


void dlg_example() trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: DLG_EXAMPLE

Description:  This macro is an example of building and making dialog boxes for
              MultiEdit for windows.  This example has numerous types of boxes
              and controls.  If you run this macro as is, the different styles will
              be shown.  This dialog box doesn't take any action other than display
              the different available types.  Feel free to "play" with this macro's
              settings.

              All selectable items work or give results if a button is pushed and
              that action is appropriate for that type of dialog.  The example will
              stay on "top" until "OKAY" or "CANCEL" is pressed.  The box
              will close.  If "HELP" is pressed, access to the MultiEdit for
              Windows will be displayed.

              For common parameters and settings, the command string is displayed
              vertically with an explanation in the remarks to the right of the
              parameter.  This is for this file only.

              The following variable deceleration is from the DIALOG.SH macro and
              is shown here for reference only in regards to the parameters required
              for the creation of a dialog box.

    int DlgAddCtrl( int dlg,      // the dialog handle create with DlgCreate
									int ctrltype,   // the control type
									str ctrltext,   // the control title
									int x,          // the x coordinate or column number
									int y,          // the y coordinate or row number
									int width,      // the width of the control
									int height,     // the height of the control
									int ctrlid,     // the identifying number for the control
									int flags,			// bit flags
                  str misc        // miscellaneous parameters
               );



*******************************************************************************/

                       /* Variable declarations */
  int dlg,                                   // The MEW dialog box identifier (not the window handle)
      active_window = window_id,             // Store active MEW window so we can switch back to it at the end
      second_column,                         // A var. if more than one column is needed
      listtext_win,
      ViewText_win,
      static_width = 20,
      field_x_offset = static_width + 1,
      listbox_win;

// below are variables to hold the data retrieved from the dialog box controls
  str dlg_text_str,
      dlg_macrobtnstr_str,
      dlg_keycode_str,
      key_name,
      dlg_listtextbox_str,
      dlg_listviewtext_str,
      dlg_listbox_str;

  int dlg_integer_int,
      dlg_choice_int,
      key_1,
      key_2,
      dlg_radio_int,
      dlg_checkbox_int,
      dlg_listtextbox_int,
      dlg_listviewtext_int,
      dlg_listbox_int;

  real dlg_realnumber_real;

  refresh = false;                          /* Don't refresh the screen */

  // Create the window or dialog box to display the list text in.
  switch_window(window_count);
  create_window;

  // Define what is to be displayed in DLG_LISTTEXTBOX control
  listtext_win = cur_window;                /* save cur_window for the list control */
  put_line("DLG_ListTextBox");              /* put in the text */
  down;                                     /* and move down one line */
  put_line("List choice 2");
  down;
  put_line("List choice 3");
  down;
  put_line("List choice 4");
  down;
  put_line("List choice 5");
  down;
  put_line("List choice 6");
  down;
  put_line("List choice 7");
  down;
  put_line("List choice 8");
  tof;                                      /* when done, move to the top */

  // Create the MEW window that will be used with the DLG_VIEWTEXTBOX control
  switch_window(window_count);
  create_window;

  // Initialize what will be displayed
  viewtext_win = cur_window;
  put_line("DLG_ViewTextBox");
  down;
  put_line("View line 2");
  down;
  put_line("View line 3");
  down;
  put_line("View line 4");
  tof;

  // Create the window for the DLG_LISTBOX
  switch_window(window_count);
  create_window;
  // Listbox contents defininition
  listbox_win = cur_window;
  put_line("DLG_ListBox");
  down;
  put_line("Listbox choice 2");
  down;
  put_line("Listbox choice 3");
  down;
  put_line("Listbox choice 4");
  down;
  put_line("Listbox choice 5");
  down;
  put_line("Listbox choice 6");
  down;
  put_line("Listbox choice 7");
  tof;

  DlgCreate(dlg);               // used to create the HANDLE of the dialog.


  DlgAddCtrl(
              dlg,              // the MEW dialog box identifier
                                // (NOT the Windows window handle)

              DLG_GroupBox,     // control type (equates to a
                                // Windows CLASS and STYLE)

              "DLG_GroupBox",   // control name - becomes text of
                                // the control in many cases like
                                // buttons and static (equates to
                                // a Windows window name)

              1,                // x coordinate or column of upper
                                // left corner of the control

              1,                // y coordinate or row of the upper
                                // left corner

              field_width + 2,  // width of the control

                                // height of the control - if the
                                // width or height is 0, it will be
              6,                // automatically determined by
                                // Windows according to the width or
                                // height of the text in the
                                // control name

              GroupBox_ctrl,    // the control id - here is where
                                // we are using the #defines

              0,                // bit flags

              ""                // misc. parameters
              );

// This is the DLG_TEXT type control, the standard text control
  DlgAddCtrl(
              dlg,
              DLG_Text,
              "DLG_Text",

// Here is an example of the use of the relative coordinate flags
// DLG_POSOFFSET and DLG_NEGOFFSET
              Dlg_PosOffset | 1, // Dlg_PosOffset is
                                // a flag that means this control's
                                // upper left coordinate will be
                                // relative to the previously defined
                                // control's upper left coordinate.
                                // You OR it with a numeric value
                                // indicating how many character
                                // widths to the right of the
                                // previous control you wish this
                                // control to be placed.  In this
                                // example, field_x_offset is a
                                // #define declared near the top
                                // of this file.

              Dlg_PosOffset | 1,    // This is the Y coordinate and
                                // it treats Dlg_PosOffset the
                                // same as the X coordinate above
                                // except if you OR it with a
                                // numeric value, it will be the
                                // amount of character heights.

// The character widths and heights are related to the standard
// dialog box font.  If you wish the control to be placed to the
// left (X coordinate) or above (Y coordinate) the previous control,
// use the Dlg_NegOffset instead Dlg_PosOffset.  Also, if you wish
// to have more precision in placement, you can use the flag
// Dlg_Units and you can OR it with Dlg_PosOffset or Dlg_NegOffset.
// If you don't use Dlg_PosOffset or Dlg_NegOffset, the control
// will be relative to the upper left corner of the dialog box
// itself.

              field_width,
              0,
              text_ctrl,
              0,
              ""
              );


// This is the "DLG_CHOICE:" style box.  Has drop down selectable list
// To put items in list, use the CONTROL NAME parameter.
// Notice that each item is separated by a "()".
  DlgAddCtrl( dlg, DLG_Choice, "DLG_Choice()Choice 2()Choice 3()", Dlg_PosOffset, Dlg_PosOffset | 1, field_width, 0, choice_ctrl, 0, "" );
/*
  DlgAddCtrl( dlg, DLG_Static, "DLG_HEX:", 1, Dlg_PosOffset | 1, static_width, 0, hex_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Hex, "FFFF", Dlg_PosOffset | field_x_offset, Dlg_PosOffset, field_width, 0, hex_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "DLG_MACROBTNINT:", 1, Dlg_PosOffset | 1, static_width, 0, mbtnint_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_MacroBtnInt, "", Dlg_PosOffset | field_x_offset, Dlg_PosOffset, field_width, 0, mbtnint_ctrl, 0, "" );
*/

// This is the "DLG_MACROBTNSTR:" type with a button next to the text.
// The text in this control is not directly editable, but rather a
// macro is run when the button is pressed that can change the
// value of the text.  Initialize the CONTROL NAME parameter to the
// default text, then pass the macro command line in the MISC
// PARAMETERS argument.  When the button is pressed, the system
// variable RETURN_STR will be initialized with current text, and
// the macro will be run.  The macro can do just about anything,
// and if RETURN_STR is modified, the text in the control will be
// changed.
  DlgAddCtrl( dlg, DLG_MacroBtnStr, "DLG_MacroBtnStr", Dlg_PosOffset, Dlg_PosOffset | 1, field_width - 1, 0, mbtnstr_ctrl, 0, "/M=MACROBTNSTRTEST" );

// This is the DLG_PUSHBUTTON type control. The text defined in the
// CONTROL NAME parameter will appear inside the button.  Notice
// the & symbol used to denote the hot key (Alt+B).
  DlgAddCtrl( dlg, DLG_PushButton, "DLG_Push&Button", Dlg_PosOffset, Dlg_PosOffset | 1, field_width, 0, pushbtn_ctrl, 0, "" );

// This is the "DLG_STATIC" displays static text such as a label
  DlgAddCtrl( dlg, DLG_Static, "DLG_Static", Dlg_PosOffset,

// here we are using DLG_UNITS to get a more precise placement
              Dlg_PosOffset | DLG_Units | 14,

              field_width, 0, static_ctrl, 0, "" );


  DlgAddCtrl( dlg, DLG_Static, "DLG_BlackFrame:", 1, Dlg_PosOffset | Dlg_Units | 14, static_width, 0, BlackFram_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_BlackFrame, "", Dlg_PosOffset, Dlg_PosOffset | Dlg_Units | 12, static_width + field_width + 3, 3, BlackFram_ctrl, 0, "" );

// This is the "DLG_INTEGER:" style box with UP & DOWN arrows
// called Spin Buttons
  DlgAddCtrl( dlg, DLG_Static, "DLG_&Integer:", 2, Dlg_PosOffset, static_width, 0, integer_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Integer, "", Dlg_PosOffset | field_x_offset, Dlg_PosOffset, field_width - 3, 0, integer_ctrl, 0, "" );

// This is the "DLG_REALNUMBER" type control used for input of real
// numbers with a decimal point
  DlgAddCtrl( dlg, DLG_Static, "DLG_RealNumber:", 2, Dlg_PosOffset | 1, static_width, 0, realnum_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_RealNumber, "0.0", Dlg_PosOffset | field_x_offset, Dlg_PosOffset, field_width, 0, realnum_ctrl, 0, "" );

// This is the "DLG_KEYCODE" type control which allows the user to
// define a keystroke.  This is normally used for command mapping.
  DlgAddCtrl( dlg, DLG_Static, "DLG_Keycode:", 2, Dlg_PosOffset | 1, static_width, 0, keycode_title_ctrl, 0, "" );
// If you wish to have a default keycode displayed, define the scan
// codes in the CONTROL NAME parameter using the /K1=nn/K2=nn
// convention as shown below.  These scan codes are for Shift+F1
  DlgAddCtrl( dlg, DLG_Keycode, "/KL=Shift+F1/K1=112/K2=3", Dlg_PosOffset | field_x_offset, Dlg_PosOffset, field_width - 1, 0, keycode_ctrl, 0, "" );


  second_column = Field_width + 7;
  static_width = 20;
  field_x_offset = static_width + 1;

  DlgAddCtrl( dlg, DLG_Static, "DLG_GreyFrame:", second_column - 1, 1, static_width, 0, GreyFrame_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_GreyFrame, "", second_column - 1, 2, 23, 5, GreyFrame_ctrl, 0, "" );

// This is the DLG_RADIOBUTTON type.  These are normally in groups.
  DlgAddCtrl( dlg, DLG_RadioButton, "DLG_RadioButton", Second_column, Dlg_NegOffset | Dlg_Units | 2, 20, 0, Radio1_ctrl, 0, "");
// Notice the calls to "DlgSetInt" to turn the button ON or OFF.
// You should only turn one button on.
  DlgSetInt(
            dlg,
            Radio1_ctrl,  // the control id of the button
            1             // 1 = on, 0 = off
            );
  DlgAddCtrl( dlg, DLG_RadioButton, "Another Radio", Dlg_PosOffset, Dlg_PosOffset | Dlg_Units | 9, 20, 0, Radio2_ctrl, 0, "" );
  DlgSetInt(dlg, Radio2_ctrl, 0);

// This is the "DLG_CHECKBOX" type which toggles on and off
// Note you can also use DlgSetInt() to turn these on by default
  DlgAddCtrl( dlg, DLG_Checkbox, "&DLG_Checkbox", Dlg_PosOffset, Dlg_PosOffset | 1, 20, 0, Checkbox_ctrl, 0, "" );

// This is a related type called DLG_3STATE
  DlgAddCtrl( dlg, DLG_3State, "&DLG_3State", Dlg_PosOffset, Dlg_PosOffset | 1, 20, 0, Dlg_3State_ctrl, 0, "" );
  DLgSetInt( dlg, Dlg_3State_ctrl, 2);

  DlgAddCtrl( dlg, DLG_BitmapBtn,"BT_HL_106_S DLG_BitmapBtn", Dlg_PosOffset, Dlg_PosOffset | 1, 20, 0, BitmapBtn_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "DLG_WhiteFrame:", 1, 12, static_width, 0, WhiteFram_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_WhiteFrame, "", 1, 13, (field_width * 2) + 11, Dlg_Units | 42, WhiteFram_ctrl, 0, "" );

// This is the "DLG_LISTTEXTBOX" type which uses a MEW window for the
// selection list.  It can scroll HORIZONTALLY if necessary.
  DlgAddCtrl(
              dlg,
              DLG_ListTextBox,
              "",
              Dlg_PosOffset | 1,
              Dlg_PosOffset,
              field_width + 4,
              Dlg_units | 40,
              ListText_ctrl,
              0,
              "/WIN=" + str(listtext_win)// In the MISC. PARAMETERS
                                // argument, we pass the MEW window
                                // number (NOT the window id) of
                                // the window containing the list
              );

// This is the DLG_VIEWTEXTBOX type which like DLG_LISTTEXTBOX but
// adds VERTICAL scrolling.
  DlgAddCtrl( dlg, DLG_ViewTextBox, "", Dlg_PosOffset | field_width + 6, Dlg_PosOffset,field_width + 3, Dlg_Units | 40, ViewText_ctrl, 0, "/DISP#=3/WIN=" + str(Viewtext_win));

// This is the DLG_LISTBOX type that uses a MEW window for the list
// but, unlike DLG_LISTTEXTBOX, displays the selections in the
// standard dialog box font
  DlgAddCtrl( dlg, DLG_ListBox, "", 53, 8, field_width - 6, Dlg_Units | 33, Listbox_ctrl, 0, "/WIN=" + str(listbox_win));

  DlgAddCtrl( dlg, DLG_Static, "DLG_BitmapStatic:", 57, 1, 0, 0, Bitmap_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_BitmapStatic,"BT_HL_106", Dlg_PosOffset | 3, Dlg_PosOffset | 1, 0, 0, BitmapStatic_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Static, "DLG_BitmapDefine:", 57, 4, 0, 0, BitmapDef_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_BitmapDefine, "BT_HL_104", Dlg_PosOffset | 3, Dlg_PosOffset | 1, 0, 0, BitmapDef_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "DLG_Icon:", 65, 13, 0, 0, Icon_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Icon, "IC_EXCLAMATION", Dlg_PosOffset | 1, Dlg_PosOffset | 1, 0, 0, Icon_Ctrl, 0, "" );

// Below are the standard buttons that should appear at the bottom
// of all dialog boxes
// DLG_PUSHBUTTON's that don't run macros will exit the dialog box
// (with 1 exception, the help button)
  DlgAddCtrl(
              dlg,
              DLG_PushButton,
              "OK",
              1,
              17,
              Dlg_StanBtnWidth,
              0,
              OK_Ctrl,
              Dlgf_DefButton,
              "/R=1"            // The /R= parameter determines the
                                // value returned by DLG_EXECUTE if
                                // this button is pressed.
              );
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", Dlg_PosOffset | Dlg_StanBtnWidth + 1, Dlg_PosOffset, Dlg_StanBtnWidth, 0, Cancel_Ctrl, Dlgf_DefButton, "/R=0");
  DlgAddCtrl(
              dlg,
              DLG_PushButton,
              "&Help",
              65,
              Dlg_PosOffset,
              Dlg_StanBtnWidth,
              0,
              Help_Ctrl,
              Dlgf_DefButton,
              "/R=2"            // If /R=2, it will invoke the
                                // Windows help system instead of
                                // exiting the dialog box.  See the
                                // comments with the DLG_EXECUTE
                                // for details on how to define
                                // a help file and chapter
              );



// DLGEXECUTE actually invokes the dialog box
  if (DlgExecute(
                  dlg,

                  OK_ctrl,      // The control ID of the control
                                // that will initially have focus

                  "Example Dialog Box", // The title of the dialog
                                // box.  This normally used proper
                                // case.

                  "",           // Help reference.  Uses the syntax:
                                // help_file^help_chapter.  For
                                // example, you could set it to:
                                // "MEWHELP^CONTENTS" will reference
                                // the MEW main help table of
                                // contents (which is the default if
                                // the string is null).

                  "",           // Misc. Parameters - the most
                                // common is /HOOK= which defines
                                // a macro used as a hook proc

                  0             // Flags.  The most common flag is
                                // DLG_MODELESS for modeless dialog
                                // dialog boxes.

                  )) {
// If we get here, it would indicate that a button with a return
// value of non-zero was pressed, usually the OK button.  The next
// step would normally be to retrieve the values from the various
// controls:
    dlg_text_str = DlgGetStr(dlg, text_ctrl);

    dlg_integer_int = DlgGetInt(dlg, integer_ctrl);

// The real number is actually stored as a string so it must be converted
    if (rval(dlg_realnumber_real, DlgGetStr(dlg, realnum_ctrl))) {
      dlg_realnumber_real = 0.0;
    }

    dlg_choice_int = DlgGetInt(dlg, choice_ctrl);

    dlg_macrobtnstr_str = DlgGetStr(dlg, mbtnstr_ctrl);

    dlg_keycode_str = DlgGetStr(dlg, keycode_ctrl);
    key_name = parse_str("/KL=", dlg_keycode_str);
    key_1 = parse_int("/K1=", dlg_keycode_str);
    key_2 = parse_int("/K2=", dlg_keycode_str);

    if (DlgGetInt(dlg, radio1_ctrl)) {
      dlg_radio_int = 1;
    } else if (DlgGetInt(dlg, radio2_ctrl)) {
      dlg_radio_int = 2;
    }

    dlg_checkbox_int = DlgGetInt(dlg, checkbox_ctrl);

/* For the DLG_LISTTEXTBOX, DLG_LISTVIEWTEXTBOX and DLG_LISTBOX
   controls, you simply switch to the window and the cursor will
   be on the selected line */
    switch_window(listtext_win);
    dlg_listtextbox_str = get_line; // you can retrieve the string
    dlg_listtextbox_int = c_line;   // and/or the number

    switch_window(viewtext_win);
    dlg_listviewtext_str = get_line;
    dlg_listviewtext_int = c_line;

    switch_window(listbox_win);
    dlg_listbox_str = get_line;
    dlg_listbox_int = c_line;

  }

// This disposes of the dialog box data from memory
	DlgKill(Dlg);

// delete temporary list windows
  switch_window(listbox_win);
  delete_window;
  switch_window(viewtext_win);
  delete_window;
  switch_window(listtext_win);
  delete_window;

  switch_win_id(active_window);
  refresh = true;

}

void MacroBtnStrTest() {
/* This is the macro that gets run by the DLG_MACROBUTTONSTR
   control in the macro DLG_EXAMPLE */
  Return_Int = 1;
  Beep;
  Return_Str = "HELLO"; // The text in the button is in RETURN_STR
                        // If we alter it, it will change it on the
                        // button itself

  RETURN();
}


void dlg_example2() trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: DLG_EXAMPLE2

Description:  This macro demonstrates the use of the more advanced DLG features
 involving a special macro that can be run when a selection in a list box has
 changed, giving you the opportunity to perform some action including updating
 other controls.

*******************************************************************************/
  int dlg,
      active_window = window_id,
      list_win_num,
      attr_int,
      dos_error,
      t_refresh = refresh;
  str path = fexpand("");


  refresh = false;
  switch_window(window_count);
  create_window;
  list_win_num = cur_window;
// we are going to fill this list with the file names in the current directory
  dos_error = first_file("*.*");
  while (!dos_error) {
    put_line(last_file_name);
    down;
    dos_error = next_file;
  }
  tof;
  attr_int = file_attr(get_line);

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_Static, path, 1, 1, 41, 0, Listbox_title_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_ListBox, "", Dlg_PosOffset, Dlg_PosOffset | 1, 27, 10, Listbox_ctrl, 0, "/CHANGEMAC=DLG_CHECK_ATTR/WIN=" + str(list_win_num));

// initialize the file attribite checkboxes according to the first entry in the directory list
// The DLGF_Disable flag is used since we are not expecting user input on these controls
  DlgAddCtrl( dlg, DLG_Checkbox, "Read Only", 30, 2, 0, 0, Checkbox_ctrl, Dlgf_Disable, "" );
  DlgSetInt(dlg, checkbox_ctrl, (attr_int & 1));
  DlgAddCtrl( dlg, DLG_Checkbox, "Hidden", Dlg_PosOffset, Dlg_PosOffset | 1, 0, 0, Checkbox_ctrl2, Dlgf_Disable, "" );
  DlgSetInt(dlg, checkbox_ctrl2, (attr_int & 2));
  DlgAddCtrl( dlg, DLG_Checkbox, "Directory", Dlg_PosOffset, Dlg_PosOffset | 1, 0, 0, Checkbox_ctrl3, Dlgf_Disable, "" );
  DlgSetInt(dlg, checkbox_ctrl3, (attr_int & 0x10));
  DlgAddCtrl( dlg, DLG_Checkbox, "Archive", Dlg_PosOffset, Dlg_PosOffset | 1, 0, 0, Checkbox_ctrl4, Dlgf_Disable, "" );
  DlgSetInt(dlg, checkbox_ctrl4, (attr_int & 0x20));


  DlgAddCtrl( dlg, DLG_PushButton, "Close", 2, 13, Dlg_StanBtnWidth, 0, OK_Ctrl, Dlgf_DefButton, "/R=1");

  if (DlgExecute( dlg, listbox_ctrl, "Example #2", "", "", 0)) {
  }
	DlgKill(Dlg);
  delete_window;
  switch_win_id(active_window);
  refresh = t_refresh;
}

void dlg_check_attr(int dlg = parse_int("/DATAHANDLE=", mparm_str)) {
// the /DATAHANDLE= parameter is passed by the DlgCreate() macro
  int attr_int = file_attr(get_line);

// this updates the data structure for the control
  DlgSetStr(dlg, listbox_title_ctrl, fexpand(get_line));
// this updates the dialog box control based on the newly update data structure
  DlgUpdateCtrl(dlg, listbox_title_ctrl, 0);

  DlgSetInt(dlg, checkbox_ctrl, (attr_int & 1));
  DlgUpdateCtrl(dlg, checkbox_ctrl, 0);

  DlgSetInt(dlg, checkbox_ctrl2, (attr_int & 2));
  DlgUpdateCtrl(dlg, checkbox_ctrl2, 0);

  DlgSetInt(dlg, checkbox_ctrl3, (attr_int & 0x10));
  DlgUpdateCtrl(dlg, checkbox_ctrl3, 0);

  DlgSetInt(dlg, checkbox_ctrl4, (attr_int & 0x20));
  DlgUpdateCtrl(dlg, checkbox_ctrl4, 0);
}

global {
/* because modeless dialog boxes involve multiple macros, we must
   store the window id of the list window in a global */
  int dlg_modeless_wid "!DLG_MODELESS_WID";
}
void dlg_example3() trans2 {
/*******************************************************************************
																MULTI-EDIT MACRO

Name: DLG_EXAMPLE3

Description:  This is an example of a modeless dialog box

*******************************************************************************/

  int dlg,
      active_window = window_id,
      t_refresh = refresh;

  refresh = false;
  switch_window(window_count);
  create_window;
/* we need to save the window id in a global integer because another
   macro will be deleting it when exiting the dialog box */
  dlg_modeless_wid = window_id;
  put_line("Mustang");
  down;
  put_line("Camaro");
  down;
  put_line("Porsche 911");
  down;
  put_line("Ferrari");
  down;
  put_line("Celica GT");
  down;
  put_line("BMW");
  down;
  tof;

	DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_Static, "Name:", 1, 1, 0, 0, text_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Text, "", Dlg_PosOffset | 11, Dlg_PosOffset, 18, 0, text_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "Phone:", 1, dlg_PosOffset | 1, 0, 0, text_title_ctrl + 1, 0, "" );
  DlgAddCtrl( dlg, DLG_Text, "", Dlg_PosOffset | 11, Dlg_PosOffset, 18, 0, text_ctrl + 1, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "Hair Color:", 1, dlg_PosOffset | 1, 0, 0, choice_title_ctrl + 1, 0, "" );
  DlgAddCtrl( dlg, DLG_Choice, "Blond()Brunette()Redhead()", Dlg_PosOffset | 11, Dlg_PosOffset, 13, 0, choice_ctrl, 0, "" );

  DlgAddCtrl( dlg, DLG_Static, "Bust size:", 1, Dlg_PosOffset | 1, 0, 0, integer_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_Integer, "", Dlg_PosOffset | 11, Dlg_PosOffset, 4, 0, integer_ctrl, 0, "" );
  DlgSetInt( dlg, Integer_ctrl, 38);

  DlgAddCtrl( dlg, DLG_Static, "Car:", 1, Dlg_PosOffset | Dlg_units | 16, 0, 0, listbox_title_ctrl, 0, "" );
  DlgAddCtrl( dlg, DLG_ListBox, "", Dlg_PosOffset | 11, Dlg_PosOffset, 18, Dlg_Units | 33, Listbox_ctrl, 0, "/WIN=" + str(cur_window));

  DlgAddCtrl( dlg, DLG_PushButton, "Close", 1, 9, Dlg_StanBtnWidth, 0, OK_Ctrl, Dlgf_DefButton, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 19, Dlg_PosOffset, Dlg_StanBtnWidth, 0, Cancel_Ctrl, Dlgf_DefButton, "/R=2");

  switch_win_id(active_window);
  DlgExecute( dlg, OK_Ctrl, "Modeless Dialog", "",
  "/EXITMAC=MODELESS_CLEANUP",    // This is the special macro that will run when the dialog box is exited
  Dlg_Modeless | Dlg_NoPardisable // These are the 2 flags normally used for a modeless dialog box
  );
/* you don't check the return value of DlgExecute and you don't
   retrieve the values of the controls as you would in a modal
   dialog box.  Instead you do that in the /EXITMAC= macro */

  refresh = t_refresh;
}

void MODELESS_CLEANUP(dlg = parse_int("/DATAHANDLE=", mparm_str)) {
  if (dlg) { // it is always wise to make sure dlg has a valid value

// if you need to retrieve data from the dialog box, here is where you do it
    int active_window = window_id;

// This must be done before you get any data from the controls
    DlgSetFields(dlg);

    str name = DlgGetStr(dlg, text_ctrl);
    str phone = DlgGetStr(dlg, text_ctrl + 1);
    int hair_color = DlgGetInt(dlg, choice_ctrl);
    int bust_size = DlgGetInt(dlg, integer_ctrl);
    str car;

// here is where we use that global integer
    if (switch_win_id(dlg_modeless_wid)) {
      car = get_line;
      delete_window;
    }
    switch_win_id(active_window);
  }
}


/*******************************************************************************
  DlgListBoxSample - 6/11/95 11:22AM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

 This sample macro demonstrates mixing text and bitmaps in a listbox.

********************************************************************************/
macro DlgListBoxSample
{
  int dlg,result;
  int tw = window_id;  // Store our current window id
  int jx;

  refresh = false;    // No redraw

  create_window;      // Create a window to build our list in

                      // Now put some data in the list
                      // This data contains two fields, one for the bitmap
                      // and one for text
  put_line("BMP=BT_FL_100_STXT=This is a file bitmap");
  down;

  put_line("BMP=BT_FL_103_STXT=This is also a file bitmap");
  down;

  put_line("BMP=BT_BL_103_STXT=This is block bitmap");
  down;

  put_line("BMP=BT_SR_104_STXT=This is search bitmap");
  down;

  put_line("BMP=BT_HL_100_STXT=This is help bitmap");
  down;

  DlgCreate(dlg);

  DlgAddCtrl( dlg, DLG_ListBox,
                  // This is the display string that the listbox how to
                  // display the fields.  /T=3 means that it is a bitmap
                  // field, /T=0 is a text field.  See MEWLIST2.SH for
                  // other fields.  When using a bitmap field, /H and /W
                  // are in pixel units, when using a text field the width
                  // is in character units, but the hieght is still in
                  // pixels.
              "BMP=/H=25/W=15/T=3TXT=/W=15/T=0",
              Dlg_PosOffset,  Dlg_PosOffset, 50, 8, 1000,
              DLGF_lbincsearch , "/WIN=" + str( cur_window));
  DlgAddCtrl( dlg, DLG_PushButton, "Ok", 1, 10, DLG_StanBtnWidth,0,110,DLGF_DefButton, "/R=1" );
  DlgAddCtrl( dlg, DLG_PushButton, "Cancel", 16, DLG_PosOffset, DLG_StanBtnWidth,0,111,0, "/R=0" );
  DlgAddCtrl( dlg, DLG_PushButton, "&Help", 36, DLG_PosOffset, DLG_StanBtnWidth,0,112,0, "/R=2" );

  result = DlgExecute( dlg, 1000,"Bitmap Listbox", "Helpstring","", 0 );
  DlgKill(dlg);
  delete_window;    // Delete the listbox window
  switch_win_id(tw);  // Return to our original window

} // DlgListBoxSample