macro_file DELPHI;
#include mew.sh
#include metools.sh
#include windows.sh
#include dialog.sh
#include dbtools.sh
#include mewlib.sh
/*******************************************************************************
														MULTI-EDIT MACRO FILE

Name: DELPHI

Description:	Language support for DELPHI.  Also includes DELPHI integration
							package.

							Mostly, this macro file does nothing but call the
							PASCAL support macros with Delphi paramaters.

DELMTCH - Construct matching
DEL_IND - Smart indent
DELSETX - Sets up the template expansion data global string.


							 (C) Copyright 1995 by American Cybernetics, Inc.
***************************************************************************** **/

macro DELMTCH TRANS2
{
	rm("PASCAL^PASMTCH /DELPHI=1" + mparm_str);
}

macro DEL_IND
{
	rm("PASCAL^PAS_IND /DELPHI=1" + mparm_str);
}

macro DELSETX
{
	if ( !Global_Int("@DA_AB_MATCH")  ) {
		#IFDEF windows
		key_to_window( ascii(")"), 'pascal^pas_close_paren /DELPHI=1' );
		#ELSE
		key_to_window( <)>, 'pascal^pas_close_paren /DELPHI=1' );
		#ENDIF
	}
}


global
{
	str DelphiPath "~DelphiPath";
	str DelphiHotKey "~DelphiHotKey";
	int DelphiAutoSave "~DelphiAutoSave";
}

/*******************************************************************************
  DelphiGetConfig - 10/8/95 10:53PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void DelphiGetConfig(  ) trans2
{
	int tw = window_id;
	int tr = refresh;
	int ti;
	str tstr;

	refresh = false;

	if(LocateDbPage( "MECONFIG", "DELPHI_INT.CFG", false  ))
	{
		down;
		goto_col(1);
		while ((!at_eof) && (cur_char != "\f")  )
		{
			tstr = caps(Get_Word("="));
			right;
			switch ( tstr )
			{
				case "DELPHIPATH" :
							tstr = remove_space( Get_Word(""));
							if(  ((SVL(tstr) > 0) &
									(Copy(tstr,SVL(tstr),1) != '\'))  ) {
								tstr += '\';
							}

							DelphiPath = tstr;
							break;

				case "DELPHIHOTKEY" :
							DelphiHotKey = Remove_Space(Get_Word(""));
							break;

				case "DELPHIAUTOSAVE" :
							ti = 0;
							tstr = Remove_Space(Get_Word(""));
							val( ti, tstr );
							DelphiAutoSave = ti;
							break;

			}
			down;
			goto_col(1);
		}
	}
	else
	{
		rm("DelphiWizard");
	}
	switch_win_id( tw );
	refresh = tr;
} // DelphiGetConfig


/*******************************************************************************
  DelphiSetConfig - 10/8/95 11:04PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
int DelphiSetConfig(  ) trans2
{
	int tline;
	int tw = window_id;
	int tr = refresh;
	str tstr[2048];
	int result = FALSE;

	refresh = false;

	if(  ((Length(DelphiPath) > 0) &
			(Copy(DelphiPath,Length(DelphiPath),1) != '\'))  ) {
		DelphiPath += '\';
	}


	if(LocateDbPage( "MECONFIG", "DELPHI_INT.CFG", TRUE  ))
	{
		result = TRUE;
		tline = c_line;
		down;
		goto_col(1);
		block_begin;
		while ((!at_eof) && (cur_char != "\f")  )
		{
			down;
		}
		up;
		if( c_line > tline )
		{
			delete_block;
		}
		block_off;
		goto_line(tline);
		eol;
		cr;
		put_line( "DelphiPath=" + DelphiPath );
		eol;
		cr;
		put_line( "DelphiHotKey=" + DelphiHotKey);
		eol;
		cr;
		put_line( "DelphiAutosave=" + str(DelphiAutoSave));

		WritePrivateProfileString("Multi-Edit", "HotKey" ,
			str(parse_int("/K1=",DelphiHotKey) + (parse_int("/K2=", DelphiHotKey) << 8 )), "DELPHI.INI" );
		WritePrivateProfileString("Multi-Edit", "Path" , me_path, "DELPHI.INI" );
		WritePrivateProfileString("Multi-Edit", "Autosave" , str(DelphiAutoSave), "DELPHI.INI" );
		WritePrivateProfileString("Experts", "ExptMEW", me_path + "DELPHI\\MEWEXPT.DLL", "DELPHI.INI" );

		int count = GetPrivateProfileInt("Transfer", "Count", 0, "DELPHI.INI" );
		int jx;
		for ( jx = 0; jx < count; jx++  )
		{
			GetPrivateProfileString( "Transfer", "Title" + str(jx), "", tstr, 254,"DELPHI.INI" );
			if(copy(tstr,1,10) == "Multi-Edit")
			{
				break;
			}
		}
		if(jx >= count)
			++count;

		WritePrivateProfileString("Transfer", "Count",str(count), "DELPHI.INI" );
		WritePrivateProfileString("Transfer", "Title" + str(jx),"Multi-Edit    " + parse_str("/KL=", DelphiHotKey), "DELPHI.INI" );
		WritePrivateProfileString("Transfer", "Path" + str(jx), me_path + "MEW.EXE", "DELPHI.INI" );
		WritePrivateProfileString("Transfer", "WorkingDir" + str(jx), "", "DELPHI.INI" );
		WritePrivateProfileString("Transfer", "Params" + str(jx), "$EDNAME \"-L $ROW \" \"-C $COL \"", "DELPHI.INI" );

		// Now update the keymap with the latest keyname
		if( global_int("!DelphiActivateWcmd") )
		{
			str sname[40] = "Delphi Integration";
			int flags = _sf_ErrorNoRec | _dbf_NoSwitchWin | _dbf_NoDelWin;
			str kstr;
			int wc = global_int("!DelphiActivateWcmd");
			int k1,k2;
			if(wc)
			{
				str tstr2[2048] = "WCMD=" + str(wc );

				int tr =DbGetCmd( WCmdMapName, sname, tstr2, flags );
				if(!tr)
				{
					var_parse_str( "KEY=", tstr2, kstr );
					if(kstr != DelphiHotKey)
					{
						tstr = tstr2;
				 		var_remove_str( "KEY=", tstr );
				 		tstr += "KEY=" + DelphiHotKey;
						flags = _dbf_NoSwitchWin | _dbf_NoDelWin | _dbf_Update | _dbf_ReplaceRec;
						tr = DbPutCmd( WCmdMapName, sname, tstr2, flags, tstr, "");
						flags = 0;
						RebuildWcmds();
					}
				}
			}
		}
	}
	switch_win_id(tw);
	refresh = tr;
	return(result);
} // DelphiSetConfig


int DelphiCheckActive(  ) {

	int result;
	if( result = findtask("DELPHI" ))
	{
		MessageBox(frame_handle, "The Delphi IDE will not reflect the configuration changes until Delphi is re-started.", "Warning: Delphi is Active", mb_ok );
	}
	return(result);

}  // DelphiCheckActive

/*******************************************************************************
  DelphiIntConfig - 10/8/95 10:21PM

 Delphi Integration configuration

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void DelphiIntConfig() trans
{
	str tstr[255];
	int dlg,result;


	if( (DelphiPath == "") && (DelphiHotKey == ""))
	{
		DelphiGetConfig();
	}

	if ( DelphiPath == "" )
	{
		GetPrivateProfileString( "Library", "ComponentLibrary", "", tstr, 255 , "DELPHI.INI" );
		if ( tstr != "" )
		{
			DelphiPath = Get_Path( tstr );
		}
	}

	DlgCreate(dlg);

	//DlgAddCtrl( dlg, DLG_Icon, "IC_EXCLAMATION", 1, 1, 0,0,100,0, "" );
	DlgAddCtrl( dlg, DLG_BitmapStatic, "MEWDELPHI", 2, 3, 0,0,-1,0, "" );
	DlgAddCtrl( dlg, DLG_BlackFrame, "", 14, 2, 51, DLG_Units | ((DLG_Units_Per_Line * 7) + DLG_Units_QLine), -1, 0, "" );
	DlgAddCtrl( dlg, DLG_Static, "&Delphi binary path:", 15, 2, 0, 1,-1,0, "" );
	DlgAddCtrl( dlg, DLG_Text,  DelphiPath , 15, DLG_PosOffset+1, 43, 1,1000,0, "" );
	DlgAddCtrl( dlg, DLG_DirButton,  "..." , DLG_PosOffset + 44, DLG_PosOffset, 4, 0,1001,0, "/SID=1000" );

	DlgAddCtrl( dlg, DLG_Static, "&Hotkey:", 15, DLG_PosOffset + 2, 0, 1,-1,0, "" );
	DlgAddCtrl( dlg, DLG_Keycode, DelphiHotKey, 15, DLG_PosOffset + 1, 20, 1, 2000, 0, "" );

	DlgAddCtrl( dlg, DLG_GroupBox, "Delphi autosave", DLG_PosOffset + 26, DLG_NegOffset | 1, 21, 4,-1,0, "" );
	DlgAddCtrl( dlg, DLG_RadioButton, "&Off", DLG_PosOffset + 1, DLG_PosOffset + 1, 0, 0,2500,0, "" );
	DlgSetInt( dlg, 2500, DelphiAutoSave == 0 );
	DlgAddCtrl( dlg, DLG_RadioButton, "Whole &project", DLG_PosOffset, DLG_PosOffset + 1, 0, 0,2501,0, "" );
	DlgSetInt( dlg, 2501, DelphiAutoSave == 1 );
	DlgAddCtrl( dlg, DLG_RadioButton, "Active &file only", DLG_PosOffset, DLG_PosOffset + 1, 0, 0,2502,0, "" );
	DlgSetInt( dlg, 2502, DelphiAutoSave == 2 );


	DlgAddCtrl( dlg, DLG_PushButton, "Ok", 28, DLG_PosOffset + 3, DLG_StanBtnWidth,0,110,0, "/R=1" );
	DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + 12, DLG_PosOffset, DLG_StanBtnWidth,0,111,0, "/R=0" );
	DlgAddCtrl( dlg, DLG_PushButton, "&Help", 53, DLG_PosOffset, DLG_StanBtnWidth,0,112,0, "/R=2" );

	result = DlgExecute( dlg, 110,"Delphi Integration Configuration", "Helpstring","", 0 );
	if ( result )
	{
		DelphiPath = DlgGetStr( dlg, 1000 );
		DelphiHotKey = DlgGetStr( dlg, 2000 );
		if(DlgGetInt( dlg, 2500 ) )
			DelphiAutoSave = 0;
		if(DlgGetInt( dlg, 2501 ) )
			DelphiAutoSave = 1;
		if(DlgGetInt( dlg, 2502 ) )
			DelphiAutoSave = 2;
		DelphiSetConfig();
		DelphiCheckActive();
	}
	DlgKill(dlg);
} // DelphiIntConfig


/*******************************************************************************
  DelphiWizard - 10/10/95 12:27PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
#define _frame_x 14
#define _frame_y 2
#define _frame_h 8
#define _frame_w 61
#define _text_x 15
#define _text_y 2
#define _text_w _frame_w - 2
#define _button_y ( _frame_y + _frame_h + 1 )
#define _button_x ( (_frame_x + _frame_w) -  35 )
#define _title "Multi-Edit/Delphi Integration Wizard"

void DelphiWizard(  ) trans
{
	int dlg,result;
	str tstr;
	int on_step1;
	int done = 0;
	if(delphipath == "")
		DelphiAutoSave = 1;

	DelphiCheckActive();

step1:
	on_step1 = DLGF_Disable;
	call create_base;
  DlgAddCtrl( dlg, DLG_Static, "You will now be taken through the steps necessary to integrate Multi-Edit with the Delphi 1.0 IDE." +
                          "\r\n\nIn order for this process to succeed, you MUST already have Delphi 1.0 installed on your system.",
                           _text_x, _text_y, _text_w, 6,-1,0, "" );

  DlgAddCtrl( dlg, DLG_Static, "You may DISABLE the Delphi integration from the Manage Add-On Packages dialog "+
                          "if you do not wish to configure support at this time.",
                         _text_x, _text_y + 4, _text_w, 2, -1, 0, "" );

	result = DlgExecute( dlg, 111,_title, "","", 0 );
	DlgKill(dlg);
	switch ( result )
	{
	case 0 :
		goto exit;
	}
	on_step1 = 0;

step2:
	GetPrivateProfileString( "Library", "ComponentLibrary", "", tstr, 255 , "DELPHI.INI" );
	if ( tstr != "" )
	{
		DelphiPath = Get_Path( tstr );
	}
	else
 	{
		MessageBox(frame_handle, "Delphi does not appear to be correctly installed on your system."
			+"\r\n\r\nMulti-Edit is unable to locate a valid DELPHI.INI ComponentLibrary entry", "Unable To Continue!", mb_ok | mb_iconexclamation);
		goto exit;
	}


	DlgCreate(dlg);

	call create_base;

	DlgAddCtrl( dlg, DLG_Static, "The Delphi binary &directory appears to be:",
													 _text_x, _text_y, 0, 0,-1,0, "" );

	DlgAddCtrl( dlg, DLG_Text, DelphiPath , _text_x, DLG_PosOffset+1, 43, 1,1000,0, "" );
	DlgAddCtrl( dlg, DLG_DirButton,  "..." , DLG_PosOffset + 44, DLG_PosOffset, 4, 0,1001,0, "/SID=1000" );

	DlgAddCtrl( dlg, DLG_Static, "If this is not correct, please enter the appropriate path.",
													 _text_x, DLG_PosOffset + 2,  _text_w, 2,-1,0, "" );

	result = DlgExecute( dlg, 1000,_title, "","", 0 );
	tstr = DelphiPath = DlgGetStr( dlg, 1000 );
	DlgKill(dlg);
	switch ( result )
	{
	case 1 :
		DelphiPath = tstr;

		break;

	case 0 :
		goto exit;

	case 10 :
		goto step1;
	}

step3:
	call create_base;
	DlgAddCtrl( dlg, DLG_Static, "Please enter a hotkey to be used to toggle back and forth between Multi-Edit and Delphi.",
													 _text_x, _text_y,  _text_w, 2,-1,0, "" );
	DlgAddCtrl( dlg, DLG_Static, "&Hotkey:", 15, DLG_PosOffset + 2, 0, 1,-1,0, "" );
	DlgAddCtrl( dlg, DLG_Keycode, DelphiHotKey, 15, DLG_PosOffset + 1, 20, 1, 2000, 0, "" );

	result = DlgExecute( dlg, 2000,_title, "","", 0 );
	tstr = DelphiHotKey = DlgGetStr( dlg, 2000 );
	DlgKill(dlg);
	switch ( result )
	{
	case 1 :
		DelphiHotKey = tstr;
		break;

	case 0 :
		goto exit;

	case 10 :
		goto step2;
	}

step4:
	done = 1;
	call create_base;
	if( DelphiSetConfig() )
	{
		DlgAddCtrl( dlg, DLG_Static,"",
													 	_text_x, _text_y,  _text_w,8,2222,0, "" );
		DlgSetStr(dlg, 2222,  "Multi-Edit/Delphi integration is complete.  The following should be noted: \r\n" +
														"\r\nThe \"Network File-Locking\" feature is incompatible with the Delphi integration and has been " +
														"turned off. Both Multi-Edit and Delphi must always have read/write access to the files\r\n" +
														"\r\nThe \"Save files when switching tasks\" and \"Reload changed files when switching back\" " +
														"features in Multi-Edit must be enabled for Delphi integration to work.  These features have " +
														"now been enabled.  Please do not turn them off.");

		result = DlgExecute( dlg, 112,_title, "","", 0 );
		DlgKill(dlg);
		ActivateFlags |= _SaveOnDeactivate | _ReloadOnActivate | _ChangedOnTime | _ChangedOnAttr;
		File_Locking = false;
		Set_Global_Int('SETUP_CHANGED',Global_Int('SETUP_CHANGED') | $01);

	}
	else
	{
		DlgAddCtrl( dlg, DLG_Static, "Multi-Edit/Delphi integration failed.",
													 	_text_x, _text_y,  _text_w, 2,-1,0, "" );

		result = DlgExecute( dlg, 112,"! Integration Failed !", "","", 0 );
		DlgKill(dlg);
	}

exit:
	return();

create_base:
	DlgCreate(dlg);
	DlgAddCtrl( dlg, DLG_BitmapStatic, "MEWDELPHI", 2, 3, 0,0,-1,0, "" );
	DlgAddCtrl( dlg, DLG_BlackFrame, "", _frame_x, _frame_y, _frame_w, _frame_h, -1, 0, "" );

	if(done)
	{
		DlgAddCtrl( dlg, DLG_PushButton, "&Finish", DLG_PosOffset + 16 + 12 + 12, _button_y, DLG_StanBtnWidth,0,112,0, "/R=0" );
	}
	else
	{
		DlgAddCtrl( dlg, DLG_PushButton, "< &Back", _button_x, _button_y, DLG_StanBtnWidth,0,110,on_step1, "/R=10" );
		DlgAddCtrl( dlg, DLG_PushButton, "&Next >", DLG_PosOffset + 11, DLG_PosOffset, DLG_StanBtnWidth,0,111,DLGF_DefButton, "/R=1" );
		DlgAddCtrl( dlg, DLG_PushButton, "Cancel", DLG_PosOffset + 14, DLG_PosOffset, DLG_StanBtnWidth,0,112,0, "/R=0" );
	}
	ret;
} // DelphiWizard




void DelphiUnInstall(  ) trans2 {
/******************************************************************************
																											 Multi-Edit Macro
																												11/1/95 10:26AM

	Function: Uninstalls the delphi integration

																				 copyright 1995 by American Cybernetics, Inc.
********************************************************************( ldh )***/
	WritePrivateProfileString2("Multi-Edit", 0 , 0, "DELPHI.INI" );
	WritePrivateProfileString1("Experts", "ExptMEW", 0, "DELPHI.INI" );

	int count = GetPrivateProfileInt("Transfer", "Count", 0, "DELPHI.INI" );
	int jx;
	str tstr;

	for ( jx = 0; jx < count; jx++  )
	{
		GetPrivateProfileString( "Transfer", "Title" + str(jx), "", tstr, 254,"DELPHI.INI" );
		if(copy(tstr,1,10) == "Multi-Edit")
		{
			break;
		}
	}
	if(jx < count)
	{
		WritePrivateProfileString1("Transfer", "Title" + str(jx),0, "DELPHI.INI" );
		WritePrivateProfileString1("Transfer", "Path" + str(jx), 0, "DELPHI.INI" );
		WritePrivateProfileString1("Transfer", "WorkingDir" + str(jx), 0, "DELPHI.INI" );
		WritePrivateProfileString1("Transfer", "Params" + str(jx), 0, "DELPHI.INI" );
	}

	MessageBox(frame_handle,"Delphi integration has been removed.", "Please Note", mb_ok);
}  // DelphiUnInstall

/*******************************************************************************
  DelphiInstall - 10/10/95 3:22PM

 by Todd M. Johnson, copyright 1995 by American Cybernetics, Inc.

********************************************************************************/
void DelphiInstall(  ) trans2
{
	rm("Update^Install /A=1/F=" + me_path + "DELPHI\\INSTALL.LST");
} // DelphiInstall