 // $Header: /mewin/src/ddeml.sh 1     3/15/96 6:14p Johnp $
/***************************************************************************
 * DDEML support INCLUDE
 ***************************************************************************/

#define HCONVLIST   INT
#define HCONV       INT
#define HSZ         INT
#define HDDEDATA    INT

// the following structure is for use with xtyp_WildConnect processing.
#define PHSZPair    Pointer
struct HSZPair {
  INT   hszSvc;
  INT   hszTopic;
}
// The following structure is used by DdeConnect() and DdeConnectList()
// and by xtyp_Connect and xtyp_WildConnect callbacks.

#define PConvContext Pointer
struct CONVCONTEXT {
  WORD    cb;                 // set to sizeof(ConvCOnTEXT)
  WORD    wFlags;             // none currently defined.
  WORD    wCountryID;         // country code for topic/item strings used.
  INT     iCodePage;          // codepage used for topic/item strings.
  INT     dwLangID;           // language ID for topic/item strings.
  INT     dwSecurity;         // Private security code.
}

// The following structure is used by DdeQueryConvInfo():
#define PConvInfo Pointer

struct ConvInfo {
  INT     cb;                 // sizeof(CONVINFO)
  INT     hUser;              // user specified field
  INT     hConvPartner;       // hConv on other end or 0 if non-ddemgr partner
  INT     hszSvcPartner;      // app name of partner if obtainable
  INT     hszServiceReq;      // AppName requested for connection
  INT     hszTopic;           // Topic name for conversation
  INT     hszItem;            // transaction item name or NULL if quiescent
  WORD    wFmt;               // transaction format or NULL if quiescent
  WORD    wType;              // XTYP_ for current transaction
  WORD    wStatus;            // ST_ constant for current conversation
  WORD    wConvst;            // XST_ constant for current transaction
  WORD    wLastError;         // last transaction error.
  INT     hConvList;          // parent hConvList if this conversation is in a list
// struct CONVCONTEXT
  WORD    ccb;                // set to sizeof(ConvCOnTEXT)
  WORD    wFlags;             // none currently defined.
  WORD    wCountryID;         // country code for topic/item strings used.
  INT     iCodePage;          // codepage used for topic/item strings.
  INT     dwLangID;           // language ID for topic/item strings.
  INT     dwSecurity;         // Private security code.
}

// conversation states (usState)
#define  xst_NULL             0     // quiescent states
#define  xst_Incomplete       1
#define  xst_Connected        2
#define  xst_Init1            3     // mid-initiation states
#define  xst_Init2            4
#define  xst_ReqSent          5     // active conversation states
#define  xst_DataRcvd         6
#define  xst_PokeSent         7
#define  xst_PokeAckRcvd      8
#define  xst_ExecSent         9
#define  xst_ExecAckRcvd      10
#define  xst_AdvSent          11
#define  xst_UnadvSent        12
#define  xst_AdvAckRcvd       13
#define  xst_UnadvAckRcvd     14
#define  xst_AdvDataSent      15
#define  xst_AdvDataAckRcvd   16

// used in LOWORD(dwData1) of XTYP_AdvReq callbacks...
#define  cadv_LateAck  0xFFFF

// conversation status bits (fsStatus)
#define  st_Connected   0x0001
#define  st_Advise      0x0002
#define  st_IsLocal     0x0004
#define  st_Blocked     0x0008
#define  st_Client      0x0010
#define  st_Terminated  0x0020
#define  st_InList      0x0040
#define  st_BlockNext   0x0080
#define  st_IsSelf      0x0100

// DDE constants for wStatus field
#define  dde_FAck           0x8000
#define  dde_FBusy          0x4000
#define  dde_FDeferUpd      0x4000
#define  dde_FAckReq        0x8000
#define  dde_FRelease       0x2000
#define  dde_FRequested     0x1000
#define  dde_FAckReserved   0x3ff0
#define  dde_FAdvReserved   0x3fff
#define  dde_FDatReserved   0x4fff
#define  dde_FPokReserved   0xdfff
#define  dde_FAppStatus     0x00ff
#define  dde_FNotProcessed  0x0000

// message filter hook types
#define  msgf_DDEMgr        0x8001

// default codepage for windows & old DDE convs.
#define  cp_WinAnsi         1004

// transaction types
#define  xtypf_NoBlock        0x0002 // cbr_Block will not work
#define  xtypf_NoData         0x0004  // dde_FDeferUpd
#define  xtypf_AckReq         0x0008  // dde_FAckReq

#define  xclass_Mask          0xFC00
#define  xclass_Bool          0x1000
#define  xclass_Data          0x2000
#define  xclass_Flags         0x4000
#define  xclass_Notification  0x8000

#define  xtyp_Error           (0x0000 | xclass_Notification | xtypf_NoBlock)
#define  xtyp_AdvData         (0x0010 | xclass_Flags)
#define  xtyp_AdvReq          (0x0020 | xclass_Data | xtypf_NoBlock)
#define  xtyp_AdvStart        (0x0030 | xclass_Bool)
#define  xtyp_AdvStop         (0x0040 | xclass_Notification)
#define  xtyp_Execute         (0x0050 | xclass_Flags)
#define  xtyp_Connect         (0x0060 | xclass_Bool | xtypf_NoBlock)
#define  xtyp_Connect_Confirm (0x0070 | xclass_Notification | xtypf_NoBlock)
#define  xtyp_XACT_Complete   (0x0080 | xclass_Notification)
#define  xtyp_Poke            (0x0090 | xclass_Flags)
#define  xtyp_Register        (0x00A0 | xclass_Notification | xtypf_NoBlock)
#define  xtyp_Request         (0x00B0 | xclass_Data)
#define  xtyp_Disconnect      (0x00C0 | xclass_Notification | xtypf_NoBlock)
#define  xtyp_Unregister      (0x00D0 | xclass_Notification | xtypf_NoBlock)
#define  xtyp_WildConnect     (0x00E0 | xclass_Data | xtypf_NoBlock)
#define  xtyp_Mask            0x00F0
#define  xtyp_Shift           4       // shift to turn xtyp_ into an index

// Timeout constants

#define  Timeout_Async        -1

// Transaction ID constatnts
#define  QID_Sync             -1

// public strings used in DDE
#define  szddesys_Topic         'System'
#define  szddesys_Item_Topics   'Topics'
#define  szddesys_Item_SysItems 'SysItems'
#define  szddesys_Item_RtnMsg   'ReturnMessage'
#define  szddesys_Item_Status   'Status'
#define  szddesys_Item_Formats  'Formats'
#define  szddesys_Item_Help     'Help'
#define  szdde_Item_ItemList    'TopicItemList'

//*****************************************************************************
//  The following constants and functions would never be used in our context.
//
//
//*****************************************************************************
// #define  TCallback = Pointer
// IMPORT HDDEData  (CallType, Fmt: Word; Conv: HConv; hsz1, hsz2: HSZ; Data: HDDEData; Data1, Data2: Longint);

// #define  cbr_Block              0xffffffff

// DLL registration functions

// WORD DdeInitialize (Inst *DWORD, Callback Pointer, Cmd DWORD, Res DWORD) DDEML 2;

// Callback filter flags for use with standard apps.

// #define  cbf_Fail_SelfConnections   0x00001000
// #define  cbf_Fail_Connections       0x00002000
// #define  cbf_Fail_Advises           0x00004000
// #define  cbf_Fail_Executes          0x00008000
// #define  cbf_Fail_Pokes             0x00010000
// #define  cbf_Fail_Requests          0x00020000
// #define  cbf_Fail_AllSvrXActions    0x0003f000

// #define  cbf_Skip_Connect_Confirms  0x00040000
// #define  cbf_Skip_Registrations     0x00080000
// #define  cbf_Skip_Unregistrations   0x00100000
// #define  cbf_Skip_Disconnects       0x00200000
// #define  cbf_Skip_AllNotifications  0x003c0000

// Application command flags

// #define  AppCmd_ClientOnly          0x00000010
// #define  AppCmd_FilterInits         0x00000020
// #define  AppCmd_Mask                0x00000FF0

// Application classification flags

// #define  AppClass_Standard          0x00000000
// #define  AppClass_Mask              0x0000000F

// IMPORT BOOL DdeUninitialize ( Inst DWORD) DDEML  3;


// conversation enumeration functions
IMPORT DWORD  DdeConnectList    ( DWORD Inst, DWORD Service, DWORD Topic, DWORD ConvList, POINTER CC) DDEML 4;
IMPORT DWORD  DdeQueryNextServer( DWORD ConvList, DWORD ConvPrev) DDEML 5;
IMPORT WORD   DdeDisconnectList ( DWORD ConvList) DDEML 6;

// conversation control functions
IMPORT DWORD  DdeConnect        ( DWORD Inst, DWORD Service, DWORD Topic, POINTER cc) DDEML 7;
IMPORT WORD   DdeDisconnect     ( DWORD Conv) DDEML 8;
IMPORT DWORD  DdeReconnect      ( DWORD Conv) DDEML 37;
IMPORT WORD   DdeQueryConvInfo  ( DWORD Conv, DWORD Transaction, POINTER ConvInfo) DDEML 9;
IMPORT WORD   DdeSetUserHandle  ( DWORD Conv, DWORD ID, DWORD User) DDEML 10;
IMPORT WORD   DdeAbandonTransaction (DWORD Inst, DWORD Conv, DWORD Transaction) DDEML 12;

// app server interface functions
IMPORT WORD   DdePostAdvise     ( DWORD Inst, DWORD Topic, DWORD Item) INDEX 13;
IMPORT WORD   DdeEnableCallback ( DWORD Inst, DWORD Conv, WORD Cmd) INDEX 26;

#define  ec_EnableAll       0
#define  ec_EnableOne       st_BlockNext
#define  ec_Disable         st_Blocked
#define  ec_QueryWaiting    2

IMPORT DWORD  DdeNameService ( DWORD Inst, DWORD hsz1, DWORD hsz2, WORD Cmd) DDEML 27;

#define  dns_Register     0x0001
#define  dns_Unregister   0x0002
#define  dns_FilterOn     0x0004
#define  dns_FilterOff    0x0008

// app client interface functions
IMPORT DWORD  DdeClientTransaction  ( POINTER Data, DWORD DataLen, DWORD Conv, DWORD Item, WORD Fmt, WORD DataType, DWORD Timeout, POINTER Result) DDEML 11;
IMPORT WORD   DdeGetLastError       ( DWORD Inst) DDEML 20;


#define  hdata_AppOwned             0x0001
// error codes
#define  dmlErr_No_Error            0       // must be 0
#define  dmlErr_First               0x4000
#define  dmlErr_AdvAckTimeout       0x4000
#define  dmlErr_Busy                0x4001
#define  dmlErr_DataAckTimeout      0x4002
#define  dmlErr_DLL_Not_Initialized 0x4003
#define  dmlErr_DLL_Usage           0x4004
#define  dmlErr_ExecAckTimeout      0x4005
#define  dmlErr_InvalidParameter    0x4006
#define  dmlErr_Low_Memory          0x4007
#define  dmlErr_Memory_Error        0x4008
#define  dmlErr_NotProcessed        0x4009
#define  dmlErr_No_Conv_Established 0x400a
#define  dmlErr_PokeAckTimeout      0x400b
#define  dmlErr_PostMsg_Failed      0x400c
#define  dmlErr_Reentrancy          0x400d
#define  dmlErr_Server_Died         0x400e
#define  dmlErr_Sys_Error           0x400f
#define  dmlErr_UnadvAckTimeout     0x4010
#define  dmlErr_Unfound_Queue_ID    0x4011
#define  dmlErr_Last                0x4011

// data transfer functions
IMPORT DWORD    DdeCreateDataHandle   (DWORD Inst, POINTER Src, DWORD cb, DWORD Off, DWORD Item, WORD Fmt, WORD Cmd) DDEML 14;
IMPORT DWORD    DdeAddData            (DWORD Data, POINTER Src, DWORD cb, DWORD Off) DDEML 15;
IMPORT DWORD    DdeGetData            (DWORD Data, DWORD Dst, DWORD Max, DWORD Off) DDEML 16;
IMPORT DWORD    DdeGetDataWord        (DWORD Data, *WORD Dst, DWORD Max, DWORD Off) DDEML 16;
IMPORT DWORD    DdeGetDataDWord       (DWORD Data, *DWORD Dst, DWORD Max, DWORD Off) DDEML 16;
IMPORT DWORD    DdeGetDataZ           (DWORD Data, *ASCIIZ Dst, DWORD Max, DWORD Off) DDEML 16;
IMPORT POINTER  DdeAccessData         (DWORD Data, *DWORD DataSize) DDEML 17;
IMPORT WORD     DdeUnaccessData       (DWORD Data) DDEML 18;
IMPORT WORD     DdeFreeDataHandle     (DWORD Data) DDEML 19;
IMPORT DWORD    DdeCreateStringHandle (DWORD Inst, ASCIIZ psz, WORD CodePage) DDEML 21;
IMPORT DWORD    DdeQueryString        (DWORD Inst, DWORD Hsz, ASCIIZ psz, DWORD Max, WORD CodePage) DDEML 23;
IMPORT WORD     DdeFreeStringHandle   (DWORD Inst, DWORD Hsz) DDEML 22;
IMPORT WORD     DdeKeepStringHandle   (DWORD Inst, DWORD Hsz) DDEML 24;
IMPORT INT      DdeCmpStringHandles   (DWORD hsz1, DWORD hsz2) DDEML 36;


// MEW added functions

IMPORT DWORD    GetDDEInstance        () MEWLIB 280;
