//+++keyword+++ "@(#)%v %n, %f, %w"
// "@(#)4 DBTOOLS.SH, 01-Apr-95,15:05:54, LDH"

// Db constants
#define _db_Delimit       "\x7F"
#define _db_PageGlob      "~Section_"
#define _db_RecGlob       "~DbRec_"
#define _db_CmdGlob       "~DbCmd_"

// Db search flags
#define _sf_RegExp        0x0001
#define _sf_Contains      0x0002
#define _sf_CaseSensitive 0x0004
#define _sf_Backwards     0x0008
#define _sf_Position      0x0010
#define _sf_FirstField    0x0020
#define _sf_ErrorNoRec    0x0040

// Other db flags
#define _dbf_NoDups       0x0100
#define _dbf_ReplaceRec   0x0200
#define _dbf_InsertBefore 0x0400
#define _dbf_SaveFile     0x0800
#define _dbf_NoSwitchWin  0x1000
#define _dbf_NoDelWin     0x2000
#define _dbf_CreatePage   0x4000
#define _dbf_Update       0x8000

// Return/Error constants
#define _ErrorDupKey     -1
#define _NoError          0
#define _ErrorNoFile      1
#define _ErrorNoDbPage    2
#define _ErrorNoDbRecord  3
#define _ErrorDupRecord   4

// CmdSet db Cmd constants
#define _db_cmd_UserWCmd  10000
#define _db_cmd_CMPage    "WCMDMAP.DB"
#define _db_cmd_Section   "@\xFE"

// CmdSet db Cmd record field names
#define _db_cmd_Name      "NAME"
#define _db_cmd_Cmd       "CMD"
#define _db_cmd_Type      "TYPE"
#define _db_cmd_Key       "KEY"
#define _db_cmd_Key2      "KEY2"
#define _db_cmd_Icon      "ICON"
#define _db_cmd_Icon2     "ICON2"
#define _db_cmd_TBText    "TBT"
#define _db_cmd_HlpCtx    "HNDX"
#define _db_cmd_OffId     "OFFID"
#define _db_cmd_Checked   "CHECKED"
#define _db_cmd_WCmdId    "WCMDID"
#define _db_cmd_WCmd      "WCMD"
#define _db_cmd_XMin      "XMIN"

// CmdSet Cmd Type constants
#define _db_ct_Macro      1
#define _db_ct_Program    2
#define _db_ct_HelpFile   3
#define _db_ct_TextFile   4
#define _db_ct_Command    5

// CmdSet Cmd Flags constants
#define _db_cf_XMin       1

// CmdSet command structure
struct TCmdMap {
	str Name[ 120 ];
	str Cmd[ 120 ];
	int Type;
	str KeyStr[ 50 ];
	str Key2Str[ 50 ];
	str Icon[ 40 ];
	str Icon2[ 40 ];
	str TBText[ 65 ];
	str HlpCtx[ 40 ];
	str OffId[ 128 ];
	str Checked[ 128 ];
	str WCmdId[ 128 ];
	int WCmd;
	int Flags;
}

// CmdSet db Menu constants
#define _db_mnu_SepWCmd   6969
#define _db_mnu_MainPage  "MAIN.MNU"
#define _db_mnu_PageExt   ".MNU"

#define _db_mnu_Menu      "MENU"
#define _db_mnu_WCmd      "WCMD"

#define _db_mnu_Text      "/TX="
#define _db_mnu_Level     "/IN="
#define _db_mnu_Sep       "/SP="

// CmdSet Menu structure
struct TMenus {
	str Menu1[ 128 ];
	str Menu2[ 128 ];
	str Menu3[ 128 ];
	str Menu4[ 128 ];
}

// CmdSet db ToolBox constants
#define _db_tbx_TBPage    "BOXLIST.DB"
#define _db_tbx_PageExt   ".TBX"

// CmdSet db ToolBox record constants
#define _db_tbx_BoxId     "BOXID"
#define _db_tbx_BoxShow   "BOXSHOWN"
#define _db_tbx_BoxStyle  "BOXSTYLE"
#define _db_tbx_UseIcon   "USEICON"

// CmdSet ToolBox Show constants
#define _db_tbs_Hidden    1
#define _db_tbs_Visable   2

// CmdSet ToolBox Position (style) constants
#define _db_tbp_Top       1
#define _db_tbp_Bottom    2
#define _db_tbp_Left      3
#define _db_tbp_Right     4
#define _db_tbp_Floating  5
#define _db_tbp_Roving    6

// CmdSet ToolBox Icon constants
#define _db_tbi_BigIcon   1
#define _db_tbi_SmallIcon 3

// CmdSet ToolBox Button record constants
#define _db_tbb_WCmd      "WCMD"

prototype DBTOOLS {

	void DbToolsExit( int Result, int DbFlags, int OrgWin );
/******************************************************************************
	Function: Support routine for the DbTools routines.  Will check DbFlags for
						the no_delete and no_switch window flags and will delete the
						current if it is not OrgWin window and switch to OrgWin when the
						flags are not set.  Also clears some global strings attached to the
						deleted window by some of the DbTools routines.

	Entry   : int Result    - The exit Result of the calling DbTool routine
						int DbFlags   - The DbFlags when the calling routine started
														(Note: only the following flags are checked)

							_dbf_NoDelWin     - When not set, causes the current window to be
																	deleted and OrgWin to be selected as the
																	current window.

							_dbf_NoSwitchWin  - When not set, causes the current window to be
																	changed to OrgWin

						int OrgWin    - The window_id number of the original window when the
														calling macro was started

	Globals : gstr "~Section_#" - Global set by LocateDbPage where # is WindowId
						gstr "~DbRec_#"   - Global set by DbGetRecord where # is WindowId
						gstr "~DbCmd_#"   - Global set by DbGetCmd where # is WindowId
********************************************************************( ldh )***/

	int DbGetFile( str FName );
/******************************************************************************
	Function: Locate and load the db file FName.

	Entry   : str FName     - The db file to load or create.

	Exit    : int
							_NoError        - FName was already loaded.
							_ErrorNoFile    - FName was not already loaded.
								Error_Level     - 0 when File was found.

	Macros  : int LocateDbPage
********************************************************************( ldh )***/

	int DbGetPage( str FName, str DbPage, int &FirstRec, int &NumRec );
/******************************************************************************
	Function: Locate a DbPage and return the line number of the firt record and
						the number of record in the page.

	Entry   : str FName     - The db file to search for DbPage.
														(Note: use "" to cause the current window to be
														searched instead of trying to locate the file)

						str DbPage    - The DbPage to find

						int FirstRec  - A variable used to return the first record line
														number.  Passing a value > 0 will cause the DbPage
														to be created if it does not exist.

						int NumRec    - A variable used to return the number of records in
														the found DbPage

	Exit    : int
							_NoError        - Success, page found.
								int FirstRec    - Line number the first record is located on.
								int NumRec      - Number of records in DB Page.

							_ErrorNoFile    - Failure, file FName not found.
							_ErrorNoDbPage  - Failure, DbPage not found.

	Macros  : int LocateDbPage
********************************************************************( ldh )***/

	int DbDelPage( str FName, str DbPage, int &Flags );
/******************************************************************************
	Function: Locate a DbPage and delete it and all records under it.

	Entry   : str FName     - The db file to search for DbPage.
														(Note: use "" to cause the current window to be
														searched instead of trying to locate the file)

						str DbPage    - The DbPage to delete

						int Flags			- Other db Flags.

														Other db flags: Defaults - 0
															Db file FName will not be save after changes
															Window with Db file will be deleted upon exit
															Entry window will be current window upon exit

							_dbf_SaveFile     - Save the db file FName after changes made
							_dbf_NoSwitchWin  - Will return with the Db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted
	Exit    : int
							_NoError        - Success, page found and deleted.
								int Flags     - Number of records in DB Page deleted.

							_ErrorNoFile    - Failure, file FName not found.
							_ErrorNoDbPage  - Failure, DbPage not found.

	Macros  : int DbGetPage
********************************************************************( ldh )***/

	int DbGetRecord( str FName, str DbPage, str DbField, str &DbData,
					int &RecNum, int &Flags, str Misc );
/******************************************************************************
	Function: Finds and returns a specified record from DbPage in the db file
						FName.

	Entry   : str FName   - The db file to search
													(Note: use "" to search the current file)

						str DbPage  - The db page header to search
						str DbField - The field name to search
						str DbData  - The field data to find based upon Flags
						int RecNum  - The record number to get (overrides field search)
						int Flags   - Search mode and other db flags. (ORed together).

													Search mode flags: Defaults - 0
														Search forward from start of DbPage
														Find section that exactly matches Section
														Search is not sensitive to case
														Will return first record when record not found

							_sf_RegExp        - Search for the regular expression in DbData
							_sf_Contains      - Search for a match that contains DbData.
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)

							_sf_Position      - Position to last found DbData before doing
																	new search (Default is to search forward)

							_sf_FirstField    - Will search for DbData in first field
							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Defaults - 0
														Window with Db file will be deleted upon exit.
														Entry window will be current window upon exit.

							_dbf_NoSwitchWin  - Will return with the Db window being current.
																	(Note only used when _dbf_NoDelWin is set).

							_dbf_NoDelWin     - Will cause the window the Db is loaded in
																	to not be deleted.

							_dbf_NoDups       - When set will override the _sf_Positon flag
																	and cause the ~DbRec_# global to not be
																	updated.

						str Misc    - Miscellaneous parameters
														/LD=str  Delimit to use, default is ASCII 127
	Exit    : int
							_NoError          - Success, record found and variables updated
								str DbData        - The found record data
								int RecNum        - The record number of the found record
								int Flags         - The total number of records under DbPage

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, DbPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching record found
																		(Note: Variables are not updated when
																		_sf_ErrorNoRec is set).

								str DbData        - The first record data
								int RecNum        - 1
								int Flags         - The total number of records under DbPage

	Globals : str ~DbRec_#  - Contains the data from DbField and DbData that was
														last used to find a record. (# is the Window_Id of
														the window that contains FName).

														Note: Marker 2 of marker set 3 is also used to save
														the position of the last found record in window #.
														Used when _sf_Position flag is passed.

	Macros  : int  DbGetPage
						void DbToolsExit
********************************************************************( ldh )***/

	int DbDelRecord( str FName, str DbPage, str DbField, str &DbData,
					int &RecNum, int &Flags, str Misc );
/******************************************************************************
	Function: Finds and deletes a specified record from DbPage in the db file
						FName.  Returns the deleted record data.

	Entry   : str FName   - The db file to search
													(Note: use "" to search the current file)

						str DbPage  - The db page header to search
						str DbField - The field name to search
						str DbData  - The field data to find based upon Flags
						int RecNum  - The record number to delete (overrides field search)
						int Flags   - Search mode and other db flags. (ORed together).

													Search mode flags: Defaults - 0
														Search forward from start of DbPage
														Find section that exactly matches DbData record
														Search is not sensitive to case
														Will return first record when record not found

							_sf_RegExp        - Search for the regular expression in DbData
							_sf_Contains      - Search for a match that contains DbData.
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)

							_sf_Position      - Position to last found DbData before doing
																	new search (Default is to search forward)

							_sf_FirstField    - Will search for DbData in first field
							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Defaults - 0
														Db file FName will not be save after changes
														Window with Db file will be deleted upon exit
														Entry window will be current window upon exit

							_dbf_SaveFile     - Save the db file FName after changes made
							_dbf_NoSwitchWin  - Will return with the Db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted

						str Misc    - Miscellaneous parameters
														/LD=str  Delimit to use, default is ASCII 127

	Exit    : int
							_NoError          - Success, record found and variables updated
								str DbData        - The found record data
								int RecNum        - The record number of the found record
								int Flags         - The total number of records under DbPage

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, DbPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching record found
																		(Note: Variables are not updated when
																		_sf_ErrorNoRec is set).

								str DbData        - The first record data
								int RecNum        - 1
								int Flags         - The total number of records under DbPage

	Macros  : int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbPutRecord( str FName, str DbPage, str DbField, str &DbData,
					int &RecNum, int &Flags, str Misc, str NewData );
/******************************************************************************
	Function: Insert a new record or replace a specified record in DbPage in the
						db file FName with the record in NewData.  Returns the found and/or
						replaced record data.

	Entry   : str FName   - The db file to search
													(Note: use "" to search the current file)

						str DbPage  - The db page header to search
						str DbField - The field name to search
						str DbData  - The field data to find based upon Flags
						int RecNum  - The record number to find (overrides field search)

						int Flags     - Search modes, placement and other db flags.
														(ORed together)

													Search mode flags: Defaults - 0
														Search forward from start of DbPage
														Find record that exactly matches DbData
														Search is not sensitive to case
														Will return first record when record not found

							_sf_RegExp        - Search for the regular expression in DbData
							_sf_Contains      - Search for a match that contains DbData.
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)
							_sf_Position      - Position to last found DbData before doing
																	new search (Default is to search forward)
							_sf_FirstField    - Will search for DbData in first field
							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Placement and other db flags:  Defaults - 0
														Will allow duplicate records to be added
														Insert NewData
														After found record or as last record in DbPage
														Db file FName will not be save after changes
														Window with db file will be deleted upon exit
														Entry window will be current window upon exit
														DbPage will not be create if it does not exist

							_dbf_NoDups       - Will not insert new record when it is a
																	duplicate.

							_dbf_ReplaceRec   - Replace the found record with NewData
							_dbf_InsertBefore - Insert NewData before found record or as
																	the first record in DbPage

							_dbf_SaveFile     - Save the db file FName after changes made
							_dbf_NoSwitchWin  - Will return with the Db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted

							_dbf_CreatePage   - Create DbPage if it does not exist
							_dbf_Update       - Will update the found record or add NewData
																	when the record not found.

																	Note: When this flag is set the placement of
																	the new added record depends upon the passed
																	parameters values.  The following table shows
																	these values.

																		DbRec DbData  Match   Position
																		 #     ""      #       Top/Bottom DbPage
																		 0     str     str     Top/Bottom DbPage
																		 #     str     str     Before/After DbRec #

						str Misc    - Miscellaneous parameters
														/LD=str   Delimit to use, default is ASCII 127
														/X        Exclude the /F= fields in NewData from the
																			replacement.

														/I        Include the /F= fields in NewData in the
																			replacement. ( default when /F= passed ).

														/F=       A list of field names to replace depending
																			upon /X or /I being present. /I assumed
																			when not /X or /I passed.

						str NewData - The new data record

	Exit    : int
							_NoError          - Success, record found and variables updated
								str DbData        - The found record data
								int RecNum        - The record number of the new record
								int Flags         - The total number of records under DbPage

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, DbPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching record found
																		(Note: Variables are not updated when
																		_sf_ErrorNoRec is set).
								str DbData        - The first record data
								int RecNum        - 1
								int Flags         - The total number of records under DbPage

							_ErrorDupRecord   - Failure, record not added, would be duplicate
								str DbData        - The found record data
								int RecNum        - The record number of the found record
								int Flags         - The total number of records under DbPage

	Macros  : int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbCheckDupFields( str DbPage, str DbLine, str FieldData, ... );
/******************************************************************************
	Function: Searches DbPage in the current window for duplicate fields (one or
						more) that matches FieldData and return True when duplicates found.

	Syntax  : Result = DbCheckDupFields( DbPage, DbLine, FieldData, ... );

	Entry   : str DbPage      - The DbPage to search
						str DbLine      - The original Db record, will not match
						str FieldData   - The FieldData to search for duplicates
						str ...         - One or more optional field names to search
															(Note: must be full field names i.e. NAME=)
	Exit    : int
							True    - Duplicate fields found
												(Note: current line contains record with duplicate)

							False   - No duplicate fields found

	Macros  : int DbGetPage
********************************************************************( ldh )***/

	str DbGetKeyStr( int K1, int K2 );
/******************************************************************************
	Function: Return a command mapping key string suitable for use with the
						command set APIs.

	Entry   : int K1    - The Key1 value of the desired key.
						int K2    - The Key2 value of the desired key.

	Exit    : str       - The CmdMap key string for the passed key.
												Note: values of 0 for K1 and K2 will return "".
********************************************************************( ldh )***/

	int DbCheckWCmd( str &DbRecord );
/******************************************************************************
	Function: Scans the command map db in the current window for a duplicate WCmd,
						creates a unique WCmd and return the updated DbRecord and WCmd.

	Entry   : str DbRecord  - The Db Record that contains the checked for WCmd.

	Exit    : int     - A unique WCmd
							str DbRecord    - Updated DbRecord

	Macros  : int DbCheckDupFields
********************************************************************( ldh )***/

	int DbCheckDupKeys( str DbRecord );
/******************************************************************************
	Function: Check the command map db in the current window for duplicate key
						assignments.  Returns True if duplicates found and the current line
						will contain the record with the duplicate key.

	Entry   : str DbRecord  - The DbRecord which contain the key assignments to
														check for duplicates.
	Exit    : int
							True    - Duplicate keys found
												(Note: current line contains duplicate key assignments)

							False   - No duplicate keys found

	Macros  : int DbCheckDupFields
********************************************************************( ldh )***/

	str DbCmdMap2Rec( struct TCmdMap );
/******************************************************************************
	Function: Converts the data in a CmdMap structure to a DbRecord as stored in
						CmdSet DB files.

	Entry   : struct CmdMap   - The CmdMap structure that contains the data.

	Exit    : str       - The returned DbRecord.
********************************************************************( ldh )***/

	void DbRec2CmdMap( struct TCmdMap, str DbRecord );
/******************************************************************************
	Function: Fills a TCmdMap structure with the data from a CmdSet Db record.

	Entry   : struct CmdMap   - The CmdMap structure to be filled
						str DbRecord    - The DbRecord data to use to fill CmdMap

	Exit    : None
							struct CmdMap   - The filled CmdMap structure.
********************************************************************( ldh )***/

	int DbGetCmdSection( str FName, str &Section, int &Flags );
/******************************************************************************
	Function: Search for and return a command section header from the db file
						FName that matches Section based upon the search Flags.

	Entry   : str FName   - The db file to search
													(Note: use "" to search the current file)

						str Section - The name of the section to find
													(Note: use "" to search for any section)

						int Flags   - Search mode and other db flags. (ORed together)

													Search mode flags: Defaults - 0
														Search forward from start of db page
														Find section that exactly matches Section
														Search is not sensitive to case
														Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in Section
							_sf_Contains      - Search for a match that contains Section
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found Section before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Default - 0
														Entry window will be current window upon exit.
														Window with Db file will be deleted upon exit.

							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, Section found and variables updated
								str Section       - The full name of the found section
								int Flags         - The number of commands under Section

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching section found
																		(Note: Variables updated only when
																		_sf_ErrorNoRec is not set)

								str Section       - The full name of the first section
								int Flags         - The number of commands under first Section

	Macros  : int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbDelCmdSection( str FName, str &Section, int &Flags );
/******************************************************************************
	Function: Delete a command Section header and all commands define under it
						from the db file FName.  Returns the full section name and number
						of command records deleted upon success.

	Entry   : str FName   - The db file to search
													(Note: use "" to search the current file)

						str Section - The section header to delete
						int Flags   - Search mode and other db flags. (ORed together)

													Search mode flags: Defaults - 0
														Search forward from start of db page
														Find section that exactly matches Section
														Search is not sensitive to case
														Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in Section
							_sf_Contains      - Search for a match that contains Section
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found Section before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Default - 0
														FName will not be save after changes
														Entry window will be current window upon exit
														Window with Db file will be deleted upon exit

							_dbf_SaveFile     - Save the db file FName before returning
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, Section and all commands under it
																	deleted

								str Section       - The full name of the deleted section
								int Flags         - The number of commands deleted

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching section found

	Macros  : int  DbGetCmdSection
						void DbToolsExit
********************************************************************( ldh )***/

	int DbPutCmdSection( str FName, str &Section, int &Flags, str NewSection );
/******************************************************************************
	Function: Add or update a section header in the command list in the FName DB
						file.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str Section   - The section header to find
						int Flags     - Search modes, placement and other db flags
														(ORed together)

													Search mode flags: Defaults - 0
														Search forward from start of db page
														Find section that exactly matches Section
														Search is not sensitive to case
														Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in Section
							_sf_Contains      - Search for a match that contains Section
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found Section before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Placement and other db flags:  Defaults - 0
														Insert NewSection
														After found section or as last section in DbPage
														Will not save file FName after each update
														Entry window will be current window upon exit
														Window with Db file will be deleted upon exit
														WCMDMAP.DB will not be created if not found

							_dbf_ReplaceRec   - Replace the found Section with NewSection
							_dbf_InsertBefore - Insert NewSection before found Section or as
																	the first section in DbPage
							_dbf_SaveFile     - Save the db file FName after each update
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)
							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted

						str NewSection  - The NewSection header name to add or update to

	Exit    : int
							_NoError          - Success, section added or updated
								str Section       - The found or replaced section
								int Flags         - The number of commands under section

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, NewSection was blank, already exists
																	or no matching section found when updating

	Macros  : int  DbGetCmdSection
						void DbToolsExit
********************************************************************( ldh )***/

	int DbGetCmd( str FName, str &Section, str &CmdRecord, int &Flags );
/******************************************************************************
	Function: Search for and return data about a command from the FName db file.
						Commands can be searched for in a number of ways depending upon
						Flags and the data in CmdRecord.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str Section   - Name of section header to find
														(Note: use "" to skip the search for Section)

						str CmdRecord - The command data to find
														(Note: Only one of WCmd, Key and Name fields are
														used in searching.  The first of these field that
														contains data is used as the search data.  The
														order for scanning is WCmd, Key and Name)

						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of DbPage or Section
															Find command that exactly matches WCmd or
															Find command that has Key defined or
															Find command that exactly matches Name
															Name search is not sensitive to case

							_sf_RegExp        - Search for the regular expression in Name
							_sf_Contains      - Search for a match that contains Name
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found command before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

														Other Db flags: Default - 0
															Window with Db file will be deleted upon exit.
															Entry window will be current window upon exit.

							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted

							_dbf_NoDups       - When set will override the _sf_Positon flag
																	and cause the ~DbCmd_# global to not be
																	updated.
	Exit    : int
							_NoError          - Success, the command was found.
								str Section       - Name of section the command was found under
								str CmdRecord     - The found command data
								int Flag          - The WCmd of the found command

							_ErrorNoFile      - Failure, FName DB file was not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching command found
								str Section       - The name of section when found otherwise ""
								int Flag          - The line number of the last commands under
																		section when found otherwise invalid

	Globals : str ~DbCmd_#  - Contains the data from CmdRecord that was last used
														to find a section. (# is the  Window_Id of the
														window that contains FName).

														Note: Marker 3 of marker set 3 is also used to save
														the position of the last found command in window #.
														Used when _sf_Position flag is passed.

	Macros  : int  DbGetPage
						int  DbGetCmdSection
						void DbToolsExit
********************************************************************( ldh )***/

	int DbDelCmd( str FName, str &Section, str &CmdRecord, int &Flags );
/******************************************************************************
	Function: Delete the command specified in Section/CmdRecord from the db file
						FName and return the deleted command data.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str Section   - Section name to find command under
						str CmdRecord - Command data searched for to be deleted
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of DbPage or Section
															Find command that exactly matches WCmd or
															Find command that has Key defined or
															Find command that exactly matches Name
															Name search is not sensitive to case

							_sf_RegExp        - Search for the regular expression in Name
							_sf_Contains      - Search for a match that contains Name
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found command before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

														Other Db flags: Default - 0
															Db file FName will not be save after changes
															Window with Db file will be deleted upon exit
															Entry window will be current window upon exit

							_dbf_SaveFile     - Save the db file FName after changes
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, command deleted from FName
								str Section       - The Section the deleted command was under
								str CmdRecord     - The deleted command data
								int Flags         - The WCmd for the deleted command

							_ErrorNoFile      - Failure, FName file not found.
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, command not found or deleted

	Macros  : int  DbGetCmd
						void DbToolsExit
********************************************************************( ldh )***/

	int DbPutCmd( str FName, str &Section, str &CmdRecord, int &Flags,
					str NewCmdRecord, str Misc );
/******************************************************************************
	Function: Update the command specified in Section/CmdRecord or add the
						command in NewCmdRecord to the db file FName and return the
						replaced command data and WCmd for the new command.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str Section   - Section name to find command under
														(Note: use "" to skip seection search)

						str CmdRecord - Command data to find
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of DbPage or Section
															Find command that exactly matches WCmd or
															Find command that has Key defined or
															Find command that exactly matches Name
															Name search is not sensitive to case

							_sf_RegExp        - Search for the regular expression in Name
							_sf_Contains      - Search for a match that contains Name
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found command before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Placement and other db flags:  Defaults - 0
														Will allow duplicate commands to be added
														Insert NewCmdRecord
														After found CmdRecord or as last record under
														Section in DbPage
														Db file FName will not be save after changes
														Window with db file will be deleted upon exit
														Entry window will be current window upon exit
														WCMDMAP.DB will not be created

							_dbf_NoDups       - Will not insert new record when it is a
																	duplicate.

							_dbf_ReplaceRec   - Replace found CmdRecord with NewCmdRecord
							_dbf_InsertBefore - Insert NewCmdRecord before found CmdRecord or
																	as the first command under Section in DbPage

							_dbf_SaveFile     - Save the db file FName after changes
							_dbf_NoSwitchWin  - Will return with the Db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted

							_dbf_CreatePage   - Create WCMDMAP.DB Page if it does not exist
							_dbf_Update       - Will update the found cmd or add NewCmdRecord
																	when the cmd is not found.

						str NewCmdRecord  - The new command data
						str Misc          - Miscellaneous parameters
																	/X        Exclude the /F= fields in NewData
																						from the replacement.

																	/I        Include the /F= fields in NewData
																						in the replacement. ( default when
																						/F= passed ).

																	/F=       A list of field names to replace
																						depending upon /X or /I being
																						present. /I assumed when no /X or
																						/I passed. Left blank will cause
																						all fields to be updated.
	Exit    : int
							_NoError          - Success, command added or updated in FName
								str Section       - Section the added/updated command was
																		under

								str CmdRecord     - The old replaced or found command data
								int Flags         - The WCmd for the added or updated command

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, NewCmdRecord was empty or command
																	not found when updated

							_ErrorDupRecord   - Failure, command not added, would be duplicate
								str Section       - Section the found command is under
								int CmdRecord     - The original found command record
								int Flags         - The WCmd of the found command

							_ErrorDupKey      - Success, but contains duplicate assigned key.
																	Note: current line in FName has duplicate key

								str Section       - Section the added/updated command was
																		under

								str CmdRecord     - The old replaced or found command data
								int Flags         - The WCmd for the added or updated command


	Macros  : int  DbGetCmd
						void DbToolsExit
********************************************************************( ldh )***/

	str DbExpandChar( str TStr, str XChar );
/******************************************************************************
	Function: Makes a regular expressing with XChar and '*' inserted before every
						character in TStr.

	Entry   : str TStr  - The string to expand
						str XChar - The character to insert before all chars in TStr

	Exit    : str   - The expanded string
********************************************************************( ldh )***/

	str DbMenu2Rec( str MenuText, int Level, int WCmd );
/******************************************************************************
	Function: Returns a menu record as stored in the command set db files, for
						MenuText, Level and WCmd.  Can be passed to the DbMenuXXX routines.

	Entry   : str MenuText  - The menu entry text
						int Level     - The level of the menu entry (1-4)
						int WCmd      - The WCmd for the menu entry

	Exit    : str     - The menu record
********************************************************************( ldh )***/

	void DbRec2Menu( str &MenuText, int &Level, int &WCmd, str MenuRec );
/******************************************************************************
	Function: Fills the passed variables with the data from a MenuRec db record.

	Entry   : str MenuText  - A variable to contain the returned menu text
						int Level     - A variable to contain the returned menu Level
						int WCmd      - A variable to contain the returned menu WCmd
						str MenuRec   - The menu record

	Exit    : None
							str MenuText  - The extracted menu entry text
							int Level     - The level of the menu entry (1-4)
							int WCmd      - The WCmd for the menu entry
********************************************************************( ldh )***/

	int DbGetMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
					int &Flags );
/******************************************************************************
	Function: Find and return data about a specified menu entry.

	Entry   : str FName     - The db file to search
														(Note: use "" to search current file)

						str MenuPage  - The menu db page to search
														(Note: "" defaults to MAIN.MNU)

						struct Menus  - A structure containing the hierarchy of menu entries
														to search for. The search algorithm uses each entry
														up to the Level entry to find a matching menu
														entry.  Use "" to match anything at that level.

						int Level     - The Level of the menu entry to get, max of 4 levels
														(Note: using 0 will search for any level menu entry
														and uses Menus.Menu1 as the menu text to find)

						int WCmd      - The WCmd of the menu entry to get
														(Note: overrides Menus/Level search when not 0)

						int Flags     - Search mode and other db flags. (ORed together).

														Search mode flags: Defaults - 0
															Search forward from start of MenuPage
															Find menu that exactly matches text in Menus
															Search is not sensitive to case
															Will return no data if menu not found

							_sf_Contains      - Search for a match that contains text in Menus
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)

							_sf_Position      - Position to last found menu entry before doing
																	new search (Default is to search forward)

														Other Db flags: Defaults - 0
															Window with Db file will be deleted upon exit.
															Entry window will be current window upon exit.

							_dbf_NoSwitchWin  - Will return with the Db window being current.
																	(Note only used when _dbf_NoDelWin is set).

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted.
	Exit    : int
							_NoError          - Success, menu found and variables updated
								struct Menus      - The text of each menu entry to Level
								int Level         - The Level of the found menu
								int WCmd          - The WCmd of the found menu
								int Flags         - The number of submenus

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, MenuPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching menu found

	Macros  : str  DbExpandChar
						int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbDelMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
					int &Flags );
/******************************************************************************
	Function: Find and delete a specified menu entry and all submenus under it.

	Entry   : str FName     - The db file to search
														(Note: use "" to search current file)

						str MenuPage  - The menu db page to search
														(Note: "" defaults to MAIN.MNU)

						struct Menus  - A structure containing the hierarchy of menu entries
														to search for. The search algorithm uses each entry
														up to the Level entry to find a matching menu
														entry.  Use "" to match anything at that level.

						int Level     - The Level of the menu entry to delete, (max of 4)
														(Note: using 0 will search for any level menu entry
														and uses Menus.Menu1 as the menu text to find)

						int WCmd      - The WCmd of the menu entry to delete
														(Note: overrides Menus/Level search when not 0)

						int Flags     - Search mode and other db flags. (ORed together).

														Search mode flags: Defaults - 0
															Search forward from start of MenuPage
															Find menu that exactly matches text in Menus
															Search is not sensitive to case
															Will return no data if menu not found

							_sf_Contains      - Search for a match that contains text in Menus
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)

							_sf_Position      - Position to last found menu entry before doing
																	new search (Default is to search forward)

														Other Db flags: Defaults - 0
															FName will not be save after changes
															Window with Db file will be deleted upon exit.
															Entry window will be current window upon exit.

							_dbf_SaveFile     - Save the db file FName before returning
							_dbf_NoSwitchWin  - Will return with the Db window being current.
																	(Note only used when _dbf_NoDelWin is set).

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted.
	Exit    : int
							_NoError          - Success, menu deleted and variables updated
								struct Menus      - The text of each menu entry to Level
								int Level         - The Level of the deleted menu
								int WCmd          - The WCmd of the deleted menu
								int Flags         - The number of submenus deleted

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, MenuPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching menu found

	Macros  : int  DbGetMenu
						void DbToolsExit
********************************************************************( ldh )***/

	int DbPutMenu( str FName, str MenuPage, struct TMenus, int &Level, int &WCmd,
					int &Flags, str &NewMenuRec );
/******************************************************************************
	Function: Insert or replace a specified menu entry in MenuPage in the db file
						FName.

	Entry   : str FName     - The db file to search
														(Note: use "" to search current file)

						str MenuPage  - The menu db page to search
														(Note: "" defaults to MAIN.MNU)

						struct Menus  - A structure containing the hierarchy of menu entries
														to search for. The search algorithm uses each entry
														up to the Level entry to find a matching menu
														entry.  Use "" to match anything at that level.

						int Level     - The Level of the menu entry to find, (max of 4)
														(Note: using 0 will search for any level menu entry
														and uses Menus.Menu1 as the menu text to find)

						int WCmd      - The WCmd of the menu entry to find
														(Note: overrides Menus/Level search when not 0)

						int Flags     - Search mode and other db flags. (ORed together).

														Search mode flags: Defaults - 0
															Search forward from start of MenuPage
															Find menu that exactly matches text in Menus
															Search is not sensitive to case
															Will return no data if menu not found

							_sf_Contains      - Search for a match that contains text in Menus
							_sf_CaseSensitive - Search will be CaseSensitive.
							_sf_Backwards     - Search Backwards from stored position (Only
																	used when _sf_Position is set)

							_sf_Position      - Position to last found menu entry before doing
																	new search (Default is to search forward)

														Other Db flags: Defaults - 0
															Will allow duplicate menus to be added
															Insert NewMenuRec
															After found menu or as last menu under last menu
															FName will not be saved after changes
															Window with Db file will be deleted upon exit
															Entry window will be current window upon exit
															MenuPage will not be create if it does not exist

							_dbf_NoDups       - Will not insert new menu when it is a
																	duplicate.

							_dbf_ReplaceRec   - Replace found menu with NewMenuRec
							_dbf_InsertBefore - Insert NewMenuRec before found menu or
																	as the first menu under previous menu level

							_dbf_SaveFile     - Save the db file FName before returning
							_dbf_NoSwitchWin  - Will return with the Db window being current.
																	(Note only used when _dbf_NoDelWin is set).

							_dbf_NoDelWin     - Will cause the the window the Db is loaded in
																	to not be deleted.

							_dbf_CreatePage   - Create MenuPage if it does not exist
							_dbf_Update       - Will update the found menu or add NewMenuRec
																	when the nenu is not found.


						str NewMenuRec  - The menu record to insert or replace

	Exit    : int
							_NoError          - Success, menu deleted and variables updated
								struct Menus      - The text of each menu entry to Level
								int Level         - The Level of the found menu
								int WCmd          - The WCmd of the found menu
								int Flags         - The number of submenus deleted

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, MenuPage not found in FName
							_ErrorNoDbRecord  - Failure, no matching menu found

	Macros  : void DbRec2Menu
						int  DbGetMenu
						str  DbMenu2Rec
						void DbToolsExit
********************************************************************( ldh )***/

	str DbTBox2Rec( str TBoxName, int BoxShow, int BoxStyle, int UseIcon );
/******************************************************************************
	Function: Returns a toolbox record as stored in command set db files.

	Entry   : str TBoxName  - The name of a toolbox
						int BoxShow   - A flag used to specify if a toolbox is visable
														(See TBTOOLS.SH for _db_tbs_xxx constants)

						int BoxStyle  - The position of a toolbox
														(See TBTOOLS.SH for _db_tbp_xxx constants)

						int UseIcon   - The size of icon to used in toolboxes
														(See TBTOOLS.SH for _db_tbi_xxx constants)

	Exit    : str     - The toolbox record
********************************************************************( ldh )***/

	void DbRec2TBox( str &TBoxName, int &BoxShow, int &BoxStyle, int &UseIcon,
					str TBoxRec );
/******************************************************************************
	Function: Fills the passed variables with data from a ToolBox db record.

	Entry   : str TBoxName  - The returned toolbox name
						int BoxShow   - The returned toolbox show flag
						int BoxStyle  - The returned toolbox style flag
						int UseIcon   - The returned toolbox icon flag
						str TBoxRec   - The toolbox record

 Exit     : None
							str TBoxName
							int BoxShow
							int BoxStyle
							int UseIcon
********************************************************************( ldh )***/

	int DbGetToolBox( str FName, str &TBoxName, int &Flags );
/******************************************************************************
	Function: Find and return a toolbox record from the BOXLIST.DB page in the db
						file FName which matches TBoxName using search Flags.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The name of the toolbox to find
														(Note: use "" to search for any toolbox)

						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of db page
															Find section that exactly matches TBoxName
															Search is not sensitive to case
															Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in TBoxName
							_sf_Contains      - Search for a match that contains TBoxName
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found DbRecord before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Default - 0
														Entry window will be current window upon exit.
														Window with Db file will be deleted upon exit.

							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note: only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, Section found and variables updated
								str TBoxName      - The found toolbox record
								int Flags         - The number of buttons in toolbox

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching section found
																		(Note: Variables updated only when
																		_sf_ErrorNoRec is not set)

								str TBoxName      - The first toolbox
								int Flags         - The number of buttons in toolbox

	Macros  : int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbDelToolBox( str FName, str &TBoxName, int &Flags );
/******************************************************************************
	Function: Delete a toolbox record matching TBoxName using search Flags from
						the BOXLIST.DB page in the db file FName and also delete all
						associated buttons. Returns the deleted toolbox record in TBoxName
						and the number of deleted buttons in Flags.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The toolbox to delete
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of db page
															Find section that exactly matches TBoxName
															Search is not sensitive to case
															Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in TBoxName
							_sf_Contains      - Search for a match that contains TBoxName
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found Section before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Default - 0
														FName will not be save after changes
														Entry window will be current window upon exit
														Window with Db file will be deleted upon exit

							_dbf_SaveFile     - Save the db file FName before returning
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, toolbox deleted
								str TBoxName      - The deleted toolbox record
								int Flags         - The number of deleted buttons

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, WCMDMAP.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching section found

	Macros  : int  DbGetRecord
						void DbToolsExit
********************************************************************( ldh )***/

	int DbPutToolBox( str FName, str &TBoxName, int &Flags, str NewTBRec,
					str Misc );
/******************************************************************************
	Function: Insert a new toolbox or update a specified toolbox matching
						TBoxName, using search Flags, from the BOXLIST.DB page in the db
						file FName with NewTBRec. Returns the found and/or updated toolbox
						record in TBoxName and the number of buttons in Flags.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The toolbox to delete
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from start of db page
															Find section that exactly matches TBoxName
															Search is not sensitive to case
															Will return first record if record not found

							_sf_RegExp        - Search for the regular expression in TBoxName
							_sf_Contains      - Search for a match that contains TBoxName
							_sf_CaseSensitive - Search will be CaseSensitive
							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found Section before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Placement and other db flags:  Defaults - 0
														Insert NewTBRec
														After found toolbox or as last toolbox in BOXLIST.DB
														Will not save file FName after each update
														Entry window will be current window upon exit
														Window with Db file will be deleted upon exit
														Toolbox page will not be create if not found

							_dbf_ReplaceRec   - Replace the found toolbox record with NewTBRec
							_dbf_InsertBefore - Insert NewTBRec before found toolbox or as
																	the first toolbox in BOXLIST.DB
							_dbf_SaveFile     - Save the db file FName after each update
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note only used when _dbf_NoDelWin is set)
							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
							_dbf_CreatePage   - Create toolbox page if it does not exist
							_dbf_Update       - Will update the found toolbox or add NewTBRec
																	when the toolbox is not found.

						str NewTBRec  - The new toolbox record to add or update
						str Misc      - Miscellaneous parameters
															/X  Exclude the /F= fields in NewTBRec from the
																	replacement.

															/I  Include the /F= fields in NewTBRec in the
																	replacement. ( default when /F= passed ).

															/F= A list of field names to replace depending
																	upon /X or /I being present. /I assumed when
																	no /X or /I passed. Left blank will cause all
																	fields to be updated.

	Exit    : int
							_NoError          - Success, toolbox deleted
								str TBoxName      - The found toolbox record
								int Flags         - The number of buttons in found toolbox

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, BOXLIST.DB page not found in FName
							_ErrorNoDbRecord  - Failure, no matching section found
							_ErrorDupRecord   - Failure, record not added, would be duplicate
								str TBoxName      - The found toolbox record
								int Flags         - The total number of buttons in toolbox

	Macros  : int  DbGetToolBox
						void DbToolsExit
********************************************************************( ldh )***/

	int DbGetTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
					int &Flags );
/******************************************************************************
	Function: Find and return a specified toolbox button record from the TBoxName
						toolbox in the db file FName.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The name or record of the toolbox to search
						int WCmd      - The WCmd of the button to get (0 to get any button)
						int BtnNo     - The button number to get (overrides WCmd search)
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from first button in toolbox
															Will return first button if record not found

							_sf_Backwards     - Search Backwards from stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position to last found button before doing
																	new search. (Default is to search forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Default - 0
														Entry window will be current window upon exit.
														Window with Db file will be deleted upon exit.

							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note: only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, button found and variables updated
								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the found button
								int BtnNo         - The number of the found button
								int Flags         - The number of buttons in toolbox

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, toolbox db page not found in FName
							_ErrorNoDbRecord  - Failure, no matching button found
																		(Note: Variables updated only when
																		_sf_ErrorNoRec is not set)

								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the firt button
								int BtnNo         - 1
								int Flags         - The number of buttons in toolbox

	Macros  : int  DbGetRecord
********************************************************************( ldh )***/

	int DbDelTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
					int &Flags );
/******************************************************************************
	Function: Delete a specified toolbox button record from the TBoxName toolbox
						in the db file FName.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The name or record of the toolbox to search
						int WCmd      - The WCmd of the button to delete (0 for any)
						int BtnNo     - The button number to delete (overrides WCmd search)
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from first button in toolbox
															Will return first button if record not found

							_sf_Backwards     - Search Backwards from BtnNo or stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position BtnNo or to last found button before
																	doing new search. (Default is to search
																	forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Other Db flags: Defaults - 0
														Db file FName will not be save after changes
														Window with Db file will be deleted upon exit
														Entry window will be current window upon exit

							_dbf_SaveFile     - Save the db file FName after changes made
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note: only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted
	Exit    : int
							_NoError          - Success, button found and variables updated
								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the found button
								int BtnNo         - The number of the found button
								int Flags         - The number of buttons in toolbox

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, toolbox db page not found in FName
							_ErrorNoDbRecord  - Failure, no matching button found
																		(Note: Variables updated only when
																		_sf_ErrorNoRec is not set)

								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the firt button
								int BtnNo         - 1
								int Flags         - The number of buttons in toolbox

	Macros  : int  DbDelRecord
********************************************************************( ldh )***/

	int DbPutTBButton( str FName, str &TBoxName, int &WCmd, int &BtnNo,
					int &Flags, int NewWCmd );
/******************************************************************************
	Function: Insert or replace a specified toolbox button record in the toolbox
						TBoxName in the db file FName.

	Entry   : str FName     - The db file to search
														(Note: use "" to search the current file)

						str TBoxName  - The name or record of the toolbox to search
						int WCmd      - The WCmd of the button to replace (0 for any)
						int BtnNo     - The button number to replace (overrides WCmd search)
						int Flags     - Search mode and other db flags. (ORed together)

														Search mode flags: Defaults - 0
															Search forward from first button in toolbox
															Will return first button if record not found

							_sf_Backwards     - Search Backwards from BtnNo or stored position
																	(Only used when _sf_Position is set)

							_sf_Position      - Position BtnNo or to last found button before
																	doing new search. (Default is to search
																	forward)

							_sf_ErrorNoRec    - Will cause no record to be returned on error

													Placement and other db flags:  Defaults - 0
														Will allow duplicate buttons to be added
														Insert new button
														After found button or as last button in toolbox
														Db file FName will not be save after changes
														Window with db file will be deleted upon exit
														Entry window will be current window upon exit
														Toolbox page will not be created

							_dbf_NoDups       - Will not insert new button when it is a
																	duplicate.

							_dbf_ReplaceRec   - Replace the found button with NewWCmd
							_dbf_InsertBefore - Insert new button before found button or as
																	the first button in toolbox

							_dbf_SaveFile     - Save the db file FName after changes made
							_dbf_NoSwitchWin  - Will return with the db window being current
																	(Note: only used when _dbf_NoDelWin is set)

							_dbf_NoDelWin     - Will cause the the window the db is loaded in
																	to not be deleted

						int NewWCmd   - The WCmd for the inserted or replaced button

	Exit    : int
							_NoError          - Success, button found and variables updated
								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the found button
								int BtnNo         - The number of the found button
								int Flags         - The number of buttons in toolbox

							_ErrorNoFile      - Failure, file FName not found
							_ErrorNoDbPage    - Failure, toolbox db page not found in FName
							_ErrorNoDbRecord  - Failure, no matching button found
																		(Note: Variables updated only when
																		_sf_ErrorNoRec is not set)

								str TBoxName      - The toolbox page
								int WCmd          - The WCmd of the firt button
								int BtnNo         - 1
								int Flags         - The number of buttons in toolbox

	Macros  : int  DbPutRecord
********************************************************************( ldh )***/

	void DbUpdateFields( str &NewRecord, str UpdData, str Fields );
/******************************************************************************
	Function: Replace all field data in NewRecord with the data from
						UpdData for the field names specified in Fields.

	Entry   : str NewRecord   - The record to be updated
						str UpdData     - The new data
						str Fields      - A list of field name to update

	Exit    : None
							str NewRecord - The updated record
********************************************************************( ldh )***/
}
