
#DEFINE _COLLAPSE_OFF     0
#DEFINE _COLLAPSE_COLUMN  1
#DEFINE _COLLAPSE_SEARCH  2
#DEFINE _COLLAPSE_TAGS    3

#DEFINE _COLLAPSE_REGEXP  			1
#DEFINE _COLLAPSE_CASESENSITIVE 2
#define _COLLAPSE_INVERT				4
#define _COLLAPSE_BLOCKEX				8

prototype collapse {
  void ExpandLevel( int M, int CLevel );
  void CollapseLevel( int M, int CLevel );
  void CollapseByLevel( int CLevel );
  void CollapseBySearch( str SearchStr, int Flags );
/******************************************************************************
	Function: Collapse using a search string

	Entry   : str SearchStr - The string to use to collapse text ( "/S=" )
						int Flags			- Flags to specify type of search.   ( "/F=" )
							_COLLAPSE_REGEXP  			- Regular expression search
							_COLLAPSE_CASESENSITIVE - Case sensitive search
							_COLLAPSE_INVERT				- Collapse text matching SearchStr
********************************************************************( ldh )***/

	void CollapseMouse( int CMode );
  void CollapseAllOff( );
  void CollapseOff( );
	void NextCollapseLevel( int Back );
/******************************************************************************
  Function: Positions the cursor on the next or previous collapse level.

  Entry   : int Back	- True to search backwards from current line ( "/BACK=1" )
********************************************************************( ldh )***/

	void CollapseModeToggle( );
/******************************************************************************
	Function: Toggle collapse display.
********************************************************************( ldh )***/
}
