macro_file BASIC;
/* ******************************************************************************
															 MULTI-EDIT MACRO FILE

Name: BASIC

Description:	Provides support for the BASIC language

BAS_IND - Smart indent for BASIC
BASSETX - Setup macro for BASIC language files (Templates for BASIC)

								(C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */

macro BAS_MTCH TRANS {
// ******************************************************************************
//																MULTI-EDIT MACRO
//
// Name: BAS_MTCH
//
// Description: Match occurences of /*  */ or () and handles problems with
//	characters embedded in comments or quotes.
//  11/01/88 11:15am  Modified for greater speed.  Also, handles screen
//  updates much better.
//
//	 /HI=1		Highlight block
//	 /RC=1		Restore cursor to original position
//	 /LS=x		Limit scope of search to x number of lines.
//
//							 (C) Copyright 1992 by American Cybernetics, Inc.
// ****************************************************************************** */
	str  Str1[20],Str2[20],  Search_Str ;  /* Strings to match */

	int  Direction,         /* 1 = Search forward, 0 = backward */
					 B_Count,       /* Brace count.  0 = match found */
					 S_Res,         /* Result of last search */
					 T_Row, T_Col, T_Line, /* Holds the original position */
					 JX,            /* General purpos */
					 F_Line, F_Col, /* Found position */
					 OldRefresh = Refresh,
           #IFNDEF windows
           shift_stat = peek( 0, 0x417 ),
           #ENDIF
					 scope = parse_int('/LS=', mparm_str),
					 cmac = (parse_str( '|127LS=', global_str( '.' + get_extension(file_name))) == 'CMAC' )
					 ;

	Refresh = False;      /* Turn screen display off */
	T_Line = C_Line;      /* Store the current position */
	T_Col = C_Col;

	Push_Undo;
	Mark_Pos;

Find_Match_Str:

	if(  (Cur_Char == '(')  ) {    /* If current char is a '(' then setup */
		Str1 = '(';
		Str2 = ')';
		Direction = 1;
		Goto Start_Match;
	}
	if(  (Cur_Char == ')')  ) {    /* If current char is a ')' then setup */
		Str1 = ')';
		Str2 = '(';
		Direction = 0;
		Goto Start_Match;
	}
															/* If nothing matched then  */
															/*   Return to original position */
	Goto_Line(T_Line);
	Goto_Col(T_Col);
	Goto_Mark;
	Make_Message('NOTHING to Match');
	Goto Macro_Exit;            /* Go exit */

Start_Match:

 /*  Search_Str := '{\["'']}||[''"]||{/@*}||{@*/}||[' + Str1 + Str2+']'; */

  //Search_Str = '["''/' + Str1 + Str2 + ']';
  Search_Str = '[' + Str1 + Str2 + ']';



	Reg_Exp_Stat = True;
	Ignore_Case = True;					/* Ignore the search case */
	B_Count = 1;								/* Brace count starts at 1 */
	S_Res = 1;									/* Init search result to true */
															/* Tell the user what we're matching */
	Make_Message('Matching "'+Str1+'"...');


MATCH_LOOP:     /* Main loop */

	if(  S_Res == 0  ) {           /* If the last search was a failure then exit */
		RM('MEERROR^Beeps /C=1');
		Goto Error_Exit;
	}

	if(  B_Count == 0  ) {         /* If brace count is zero then success */
		Goto Found_Exit;
	}

			/* Execute search based on direction */
			/*   We are going to search not only for the match brace or paren, but
				 also for comments and double and single quotes */
	if(  Direction == 1  ) {
		if( scope > 0 ) {
			if( c_line > (t_line + scope)) {
				goto Error_Exit;
			}
		}
		Right;
		while(  (NOT (At_EOL)) & ((Cur_Char == '|255') |
					(Cur_Char == '|9'))  ) {
			RIGHT;
		}
		S_Res = Search_Fwd( Search_Str, scope);
	} else {
		if( scope > 0 ) {
			if( c_line < (t_line - scope)) {
				goto Error_Exit;
			}
		}
		Left;
		while(  (((C_Line > 1) | (C_Col > 1)) & ((Cur_Char == '|255') |
					(Cur_Char == '|9')))  ) {
			Left;
		}
		S_Res = Search_Bwd( Search_Str , scope);
	}

										/* If the search result was a failure then exit */
	if(  S_Res == 0  ) {
		Goto Error_Exit;
	}

										/* If we found the original string then up the count */
	if(  Found_Str == STR1  ) {
		B_Count = B_Count + 1;
		Goto Match_Loop;
	}
										/* If we found the matching string then decrement the count */
	if(  Found_Str == STR2  ) {
		B_Count = B_Count - 1;
		Goto Match_Loop;
	}

Error_Exit:       /* We go here if no match was found */
	Goto_Mark;
	if( scope > 0 )
			make_message('Match NOT found within ' + str(scope) + ' lines.');
	else
			Make_Message('Match NOT Found.');
	Goto Macro_Exit;

Found_Exit:       /* We go here if a match was found */

	F_Line = C_Line;  F_Col = C_Col;


	if(  C_Line > T_Line  ) {
		JX = C_Line - T_Line;
	} else {
		JX = T_Line - C_Line;
	}

	goto_mark;
	mark_pos;
  int highlight_block = parse_int('/HI=', mparm_str);
      #IFDEF WINDOWS
  if( jx < (Win_CHeight * 2)) {
      #ELSE
	if(  jx < Screen_Length  ) {
      #ENDIF
		if( highlight_block ) {
		}
		while(   jx > 0  ) {
			--jx;
			if(  f_line > t_line  ) {
				down;
			} else {
				up;
			}
		}
	}
	else
		highlight_block = false;

	goto_line( f_line );
	goto_col( f_col );
	Make_Message('Match Found.');
	if( highlight_block ) {
    refresh = true;
    if(f_line > t_line)
    {
      ++f_col;
    }
    else
    if(t_line > f_line)
    {
      ++t_col;
    }
    else
    {
      if(f_col > t_col)
      {
        ++f_col;
      }
      else
      {
        ++t_col;
      }
    }
    if( parse_int('/RC=', mparm_str)  ){
			goto_mark;
		}
		else
      pop_mark;
    Set_Highlight( f_line, f_col, t_line, t_col );
    #IFDEF windows
    #ELSE
		while (shift_stat == peek( 0, 0x417 )
			)
		{
			if ( check_key )
			{
				shift_stat = -1;
				push_key(key1, key2);
			}
		}
		goto_line( c_line );
		goto_col( c_col );
    #ENDIF
	} else {
		if( parse_int('/RC=', mparm_str) ) {
			goto_mark;
		}
		else
				pop_mark;
	}
Macro_Exit:
	Refresh = OldRefresh;
	Redraw;
	Pop_Undo;
}




macro BAS_IND {
/* ******************************************************************************
																MULTI-EDIT MACRO

Name: BAS_IND

Discription: Performs semi-smart indenting for BASIC source code.

						 Looks for the beginning keywords:  For If While Sub Do Def
									 If it finds them it will INDENT

						 Looks for the ending keywords:     End Wend Next Then Loop
									 If it finds them it will UNDENT

							 (C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */
	str Temp_String1,Temp_String2,Temp_String3;
	int Temp_Line_Num,Temp_Col1,Temp_Col2,Next_Line_Num,using_lnums,l_num,key_word;

	key_word = 1;                                    /* initialize key word flag */
	using_lnums = 1;                                 /* initialize using line no flag */

	if(  (At_EOL == False)  ) {                          /* If we are not at the end of a line, then */
	 Cr;                                              /* do a carrige return and exit */
	 Goto END_OF_MAC;
	}

	First_Word;                                       /* get to first word */
	temp_col1 = C_Col;                               /* save col first word is on */

	temp_string1 = get_word(' |9|255');

	if(  (length(temp_string1) != 0)                    /* if the line isnt blank convert it to */
		 ) {                                            /* it to an integer to see if they are using */
		 if(  (val(temp_line_num,temp_string1) == 0)       /* line numbers if they are you must get the */
			) { using_lnums = 0;                         /* next word after the line number  */
					while(  ((xpos(cur_char,word_delimits,1) != 0)
						& (c_col < 40))  ) {
							right;
					}
					temp_col2 = c_col;                       /* save col first word after line no is on */
					Temp_String2 = Get_Word(' ');            /* read all letters until you reach a space  */
		 }
		}

	if(  ((using_lnums == 0) & (length(temp_string2) != 0))                       /* if using lnums and tstring2 isn't blank */
			) { temp_string2 = ' ' + remove_space(lower(temp_string2)) + ' '; }  /* remove leading & trailing spaces */
	if(  ((length(temp_string1)) != 0)
			) { temp_string1 = ' ' + remove_space(lower(temp_string1)) + ' '; }  /* if no lnums remove spaces from tstr1 */

			if(  (length(temp_string1) == 0)                /* if str1 is blank just do a cr */
					) {
						Eol;
						cr;
						GOTO_COL(1);
				 }

			if(  ((length(temp_string2) == 0) & (using_lnums == 0))     /* if using line nums & str2 is blank */
					) {                                                   /* you just need to write the next line no */
						call write_next_lnum;
				 }

			if(  (using_lnums == 0)
				 ) {
					 if(  (pos(temp_string2,' for if while sub do def ') != 0)    /* if you find a begin. keyword and  */
						 ) {                                                      /* your using line nos you must write */
									 key_word = 0;                                     /* the next line no and indent        */
									 call write_next_lnum;
									 goto_col(temp_col2);
									 indent;
						}
			} else { if(  (pos(temp_string1,' for if while sub do def ') != 0)    /* if you find a keyword and not using */
						 ) {                                                      /* line nos just indent  */
									 key_word = 0;
									 eol;
									 cr;
									 goto_col(temp_col1);       /* goto where you typed the keyword and go forward */
									 indent;                    /* one tab stop */
						}
			 }

		 if(  (using_lnums == 0)
				) {
					if(  (pos(temp_string2,' next then wend end loop ') != 0)        /* if you find an ending keyword then  */
						 ) {                                                         /* and your using line nos you must write */
									 key_word = 0;                                        /* the line number go back to the col you */
									 call write_next_lnum;                                 /* were at last and undent 1 tab stop */
									 goto_col(temp_col2);
									 undent;
									 if(  c_col == 1                                          /* If you undent and you were only at the first */
											) {                                                /* tab stop put cursor at the of the number */
												while(  ((xpos(cur_char,word_delimits,1) == 0))  ) {
												 right;
												}
												right;
											}
						}
			} else {
					if(  (pos(temp_string1,' next then wend end loop ') != 0)
						) {
										key_word = 0;
										eol;
										cr;
										goto_col(temp_col1);
										undent;
					 }
			}

 if(  (key_word != 0)
		) {
			 if(  (using_lnums == 0)  ) {
						if(  (length(temp_string2) != 0)
							 ) { call write_next_lnum;        /* No keywords - with line no's */
									 goto_col(temp_col2);
								 }
			 } else { if(  (length(temp_string1) != 0)      /* No keywords - no line no's - just text */
							 ) {
								eol;
								cr;
								goto_col(temp_col1);
							}
			 }
	 }

goto end_of_mac;

	write_next_lnum:                                                    /* before writing the next line no go  */
		goto_col(1);                                                      /* down and check the next line to see if */
		Down;                                                             /* another line Number below  */
		Temp_String3 = Get_Word(' ');
		Up;
		eol;
		cr;
		goto_col(1);
		if(  ((Temp_String3 == '') | (Val(Next_Line_Num,Temp_String3) != 0)) /* if there is no line number below */
				) { Text(Str(Temp_Line_Num + 10));                             /* just increment the "standard" 10 */
						} else { Text(Str(Temp_Line_Num + ((Next_Line_Num - Temp_Line_Num) / 2)));/* Otherwise make increment approx. halfway */
					}                                                        /* between the line number above and the below */
		right;
		ret;

END_OF_MAC:
	redraw;
}

/********************************MULTI-EDIT MACRO*******************************

Name: BASSETX

Description:  Initializes stuff for BASIC language editing.

               (C) Copyright 1995 by American Cybernetics, Inc.
*******************************************************************************/
/*
macro BASSETX {

}
*/
