macro_file ASM
/* ******************************************************************************
															MULTI-EDIT MACRO FILE

Name: ASM

Description:  Language support for Assembly language.

ASM_IND - Smart Indenting
PROC		- Creates the shell of a procedure for 8086 assembly language.

ASMFORM - Reformats 8086 assembly language source code.

							 (C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */

macro ASM_IND {
/* ******************************************************************************
														MULTI-EDIT MACRO

Name: ASM_IND

Description:  This macro will capitalize all characters on the current line
up to the end of the line, or	the ";" comment delimiter, whichever comes
first.  Then it will perform a carriage return.  This coding style may not be
to everyones liking, so if you don't like it, simply turn smart indent off.

						(C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */
	int Temp_Integer;
	int  i_col ;
	refresh = false;
	i_col = c_col;
	First_Word;
	set_indent_level;
	Temp_Integer = XPos(';',Get_Line,1);
	if(  Not(Temp_Integer)  ) {
		Temp_Integer = Length(Get_Line);
	}
	if(  (Temp_Integer)  ) {
		Put_Line(Caps(Copy(Get_Line,1,Temp_Integer)) + Copy(Get_Line,Temp_Integer + 1,254));
	}
	goto_col( i_col );
	refresh = true;
	Cr;
}

macro PROC {
/* ******************************************************************************
														MULTI-EDIT MACRO

Name: PROC

Description:  Creates the shell of a procedure for 8086 assembly language.

						(C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */
	str tstr;

	Goto_Col(1);
	tstr = Get_Word('');
	text(' PROC FAR');
	Goto_Col(1);
	Undent;
	CR;
	UP;
	text('PUBLIC ' + tstr);
	down;
	down;
	goto_Col(1);
	indent;
	text('SAVE_BP');
	CR;
	CR;
	Text('RESTORE_BP');
	CR;
	TEXT('RET');
	CR;
	Goto_COL(1);
	Text(TSTR + ' ENDP');
	CR;
	UP;
	UP;
	UP;
	UP;
	GOTO_COL(1);
	INDENT;

}

macro ASMFORM {
/* ******************************************************************************
														MULTI-EDIT MACRO

Name: ASMFORM

Description:  Reformats 8086 assembly language source code.

						(C) Copyright 1991 by American Cybernetics, Inc.
****************************************************************************** */
	str  tstr[10] ;
	int  space_found, t_persistent_blocks = persistent_blocks ;

	persistent_blocks = true;
	working;
	push_undo;
	refresh = false;
	mark_pos;
	if(  block_stat != 1  ) {
		goto exit;
	}

	block_end;
	goto_line(block_line1);
	while(  c_line <= block_line2  ) {
		first_word;

		if(  cur_char == ';'  ) {    /* If first character is a ; then ignore line */
			goto do_loop;
		}

		while(  c_col > 1  ) {        /* Delete all leading characters */
			back_space;
		}

		while(  not(at_eol) & (xpos(cur_char,' |9:',1) == 0)  ) {
			right;
		}

		if(  cur_char == ':'  ) {    /* If this is a label the go on */
			goto do_loop;
		}

		if(  at_eol  ) {
			goto do_indent;
		}

do_indent:
		goto_col(1);
		tab_right;

		space_found = false;

	find_comment:
		tstr = Get_Word('''"; |9');
		if(  (cur_char == '''')  ) {
			right;
			tstr = get_word('''');
			right;
			goto find_comment;
		}
		if(  (cur_char == '"')  ) {
			right;
			tstr = get_word('"');
			right;
			goto find_comment;
		}
		while(  xpos(cur_char,'|9 ',1) != 0  ) {
			del_char;
		}
		if(  not(at_eol)  ) {
			if(  cur_char == ';'  ) {
				while(  c_col < 41  ) {
					tab_right;
				}
				goto do_loop;
			} else {
				if(  space_found == false  ) {
					tab_right;
					space_found = true;
				} else {
					text(' ');
				}
				goto find_comment;
			}
		}

do_loop:
		down;
	}
exit:
	pop_undo;
	persistent_blocks = t_persistent_blocks;
	refresh = true;
	goto_mark;
}