#include windows.sh
#include mew_dlgs.sh
#include dialog.sh
#include fonts.sh
//#include mewhelp.sh

//#define ASCII_Modeless 0
#define ASCII_Modeless ( DLG_Modeless | DLG_NoParDisable ) // parens necessary for proper evaluation
#define ASCII_Paste_Ctrl  2010
#define ASCII_Close_Ctrl  2011
#define ASCII_ANSI_Ctrl   2012
#define ASCII_OEM_Ctrl    2013
#define ASCII_List_Ctrl   1000

global {
	int ascii_active_window   "!ASCII_ACTIVE_WINDOW"; // temporary kludge
	int ascii_window          "!ASCII_WINDOW";
	int ascii_hdlg            "!ASCII_HDLG";
	int ascii_dlg             "!ASCII_DLG";
	int ansi_font             "!ASCII_ANSI_FONT";
	int oem_font              "!ASCII_OEM_FONT";
	str g_ansi_fontname       "!ANSI_FONTNAME";
	str g_oem_fontname        "!OEM_FONTNAME";
}


void Ascii trans2 no_break {

	if (ascii_hdlg != 0) {
		// don't allow multiple occurances, switch to currently active ascii table
		SetActiveWindow(ascii_hdlg);
		return ( );
	}
	ascii_active_window = window_id; // remove this after window switch problem is fixed

	int active_window = window_id,
			t_int,
			ascii_window_num;

			OEM_Font = 0;
			ANSI_Font = 0;

	str t_hex_str[2],
			t_dec_str[3],
			t_char_str2[2],
			OEM_fontname  = "",
			ANSI_fontname = "";
	str CtrlName;
	str CtrlNameStr = "NULSOHSTXETXEOTENQACKBELBS HT LF VT FF CR SO SI DLEDC1" +
					"DC2DC3DC4NAKSYNETBCANEM SUBESCFS GS RS US ";

	int lh,fh,fw,dlgfont,
			fontsize = 0,
			charset = 0,
			selected_char;

	struct TLogFont cur_font;

	ascii_window  = 0;
	OEM_Font      = 0;
	ANSI_Font     = 0;
	Get_MEW_Dlg_Metrics (0, lh, fh,fw,dlgfont);

	if (global_str("ASC_CHRT_FONTS") == "") {
		OEM_fontname  = "Terminal";
		ANSI_fontname = "Fixedsys";
	} else {
		ANSI_fontname = parse_str("/ANAME=",global_str("ASC_CHRT_FONTS"));
		OEM_fontname  = parse_str("/ONAME=",global_str("ASC_CHRT_FONTS"));
	}

	g_ansi_fontname = ansi_fontname;
	g_oem_fontname  = oem_fontname;
	create_window;
	file_name = me_path + "ASCIITBL.TMP";

	ascii_window      = window_id;
	ascii_window_num  = cur_window;

	window_attr = 0x80;

	cur_font.lfHeight           = -15;
	cur_font.lfWidth            = 0;
	cur_font.lfEscapement       = 0;
	cur_font.lfWeight           = fw_normal;
	cur_font.lfItalic           = 0;
	cur_font.lfUnderline        = 0;
	cur_font.lfStrikeOut        = 0;
	cur_font.lfOutPrecision     = OUT_DEFAULT_PRECIS;
	cur_font.lfCLipPrecision    = Clip_Default_Precis;
	cur_font.lfQuality          = Draft_Quality;
	cur_font.lfPitchAndFamily   = Default_Pitch;

	cur_font.lfFaceName         = OEM_fontname;
	cur_font.lfCharSet          = OEM_Charset;

	OEM_font  = CreateFontIndirect(&cur_Font);

	cur_font.lfFaceName         = ANSI_fontname;
	cur_font.lfCharSet          = ANSI_Charset;

	ANSI_font  = CreateFontIndirect(&cur_Font);

	DlgCreate(t_int);
	ASCII_dlg = t_int;
	Working;

	str fstr1[40] = "/FT=" + str(ANSI_font)      // TMJ 8/13/94 8:14AM
				+ "/FC=" + str(GetSysColor(Color_WindowText))
				+ "/BC=" + str(GetSysColor(Color_Window)) ;

	str fstr2[40] = "/FT=" + str(OEM_font)       // TMJ 8/13/94 8:14AM
				+ "/FC=" + str(GetSysColor(Color_WindowText))
				+ "/BC=" + str(GetSysColor(Color_Window));

	int tundo = undo_stat;

	undo_stat = false;

	for (t_int = 0; t_int < 256; ++t_int) {
		t_hex_str = hex_str(t_int);
		if (svl(t_hex_str) == 1) {
			t_hex_str = "0" + t_hex_str;
		}

		t_dec_str = str(t_int);
		t_dec_str = copy("  ",1,3 - svl(t_dec_str)) + t_dec_str;

		t_char_str2 = char(t_int);

		if (t_int == 47) {
			t_char_str2 += t_char_str2;
		}
		if (t_int == 127) {
			t_char_str2 += t_char_str2;
		}
		if ( T_Int < 0x20 ) {
			CtrlName = "\x7F" + "CTRL=^" + Char( T_Int + 0x40 ) +
					"\x7F" + "NAME=" + Copy( CtrlNameStr, ( T_Int * 3 ) + 1, 3 );
		}
		else {
			CtrlName = "";
		}
		put_line( "DEC=" + t_dec_str + "HEX=" + t_hex_str +  // TMJ 8/13/94 8:14AM
//			"AC=/TX=" + t_char_str2 + fstr1 + "OC=/TX=" + t_char_str2 + fstr2 );
				"AC=/TX=" + t_char_str2 + fstr1 + "OC=/TX=" + t_char_str2 + fstr2 +
				CtrlName );
		down;
	}

	undo_stat = tundo;
	tof;
	DlgAddCtrl( ASCII_dlg, DLG_BitmapStatic, "BT_GN_123",
		1,
		1,
		0,0,200,0,"");

	DlgAddCtrl( ASCII_dlg, DLG_Static, "Dec  Hex",
		2, DLG_Units + 22, 0, 0, 110, 0, "");

	DlgAddCtrl( ASCII_dlg, DLG_PushButton, "&Oem",
		DLg_Units + 43,
		Dlg_units + 19,
		Dlg_units + 20,
		Dlg_units + 10,
		ASCII_OEM_Ctrl, 0, "/R=6/M=ASCII_CHANGE_OEM");
	DlgAddCtrl( ASCII_dlg, DLG_PushButton, "&Ansi",
		DLG_PosOffset + 6,
		Dlg_PosOffset,
		Dlg_units + 20,
		Dlg_units + 10,
		ASCII_ANSI_Ctrl, 0, "/R=5/M=ASCII_CHANGE_ANS");

	DlgAddCtrl( ASCII_dlg, DLG_ListBox, "DEC=/W=5HEX=/W=6OC=/W=5/T=5AC=/W=3/T=5" +
					"\x7F" + "CTRL=/W=4" + "\x7F" + "NAME=/W=5",
			2, DLG_Units + 30,
//			23, 10,
			33, 10,
			ASCII_List_Ctrl, 0, "/INCO=1/WIN=" + str(cur_window));

	DlgAddCtrl( ASCII_dlg, DLG_PushButton, "Paste", 1,
			Dlg_PosOffset + 11,0,0,ASCII_Paste_ctrl, DLGF_DefButton, "/R=1");
	DlgAddCtrl( ASCII_dlg, DLG_PushButton, "Close", dlg_PosOffset + 9,
			DLG_PosOffset     ,0,0,ASCII_Close_Ctrl, 0,              "/R=0");
	DlgAddCtrl( ASCII_dlg, DLG_PushButton, "&Help", dlg_PosOffset + 9,
			DLG_PosOffset     ,0,0,103,0,"/R=2");
	return_int = DlgExecute( ASCII_dlg, ASCII_List_Ctrl, "Ascii Table", "ASCII TABLE","/HOOK=AsciiMsgProc",ASCII_Modeless);

	switch_win_id(active_window);

	return ( );

}  // Ascii

void Ascii_Change_Oem( ) {
	int active_window = window_id,
			t_insert_mode = insert_mode,
			lh, fh, fw, dlgfont,
			fontsize = 0,
			ptsize,
			charset = 0,
			fontweight = 0,
			hdlg = parse_int("/DLGHANDLE=",mparm_str);
	str oem_fontname = g_oem_fontname,
			t_str;
	struct TLogFont cur_font;

	int t_int;

	switch_win_id(ascii_window);
	mark_pos;

	Get_MEW_Dlg_Metrics (0, lh, fh,fw,dlgfont);
	insert_mode = t_insert_mode;

	if (SelectFont(0, OEM_fontname, fontsize, charset, fontweight,
					ptsize, 0, 0, "DOS/OEM Select Font", "")) {
		g_oem_fontname = OEM_fontname;

		DeleteObject(OEM_font);
		cur_font.lfFaceName       = OEM_fontname;
		cur_font.lfCharSet        = OEM_Charset;
		cur_font.lfHeight         = -15;
		cur_font.lfWidth          = 0;
		cur_font.lfEscapement     = 0;
		cur_font.lfWeight         = FW_NORMAL;
		cur_font.lfItalic         = 0;
		cur_font.lfUnderline      = 0;
		cur_font.lfStrikeOut      = 0;
		cur_font.lfOutPrecision   = OUT_DEFAULT_PRECIS;
		cur_font.lfCLipPrecision  = CLIP_DEFAULT_PRECIS;
		cur_font.lfQuality        = DRAFT_QUALITY;
		cur_font.lfPitchAndFamily = DEFAULT_PITCH;

		OEM_font  = CreateFontIndirect(&cur_Font);

		tof;
		while (!at_eof) {
			t_str = get_line;
			if (find_text("OC=",1,0)) {
				if (find_text("/FT=",1,0)) {

					right;
					right;
					right;
					right;
					while (cur_char != "/") {
						del_char;
					}
					text(str(oem_font));
				}
			}

			down;
			goto_col(1);
		}
		RedrawWindow(GetDlgItem(hdlg, ASCII_List_Ctrl), 0, 0, RDW_INVALIDATE);

	}
	goto_mark;
	insert_mode = t_insert_mode;
	switch_win_id(active_window);
	SetFocus(GetDlgItem(hdlg, ASCII_Paste_Ctrl));
	SetDefaultButton(hdlg,ASCII_Paste_ctrl); // this does not seem to work
	SetFocus(GetDlgItem(hdlg, ASCII_List_Ctrl));
	return_int = 0;
}

void Ascii_Change_Ans( ) {
	int active_window = window_id,
			t_insert_mode = insert_mode,
			lh, fh, fw, dlgfont,
			fontsize = 0,
			ptsize,
			charset = 0,
			fontweight = FW_NORMAL,
			hdlg = parse_int("/DLGHANDLE=",mparm_str);
	str ansi_fontname = g_ansi_fontname,
			t_str;
	struct TLogFont cur_font;

	int t_int;

	switch_win_id(ascii_window);
	mark_pos;

	Get_MEW_Dlg_Metrics (0, lh, fh,fw,dlgfont);
	insert_mode = t_insert_mode;

	if (SelectFont(0, ANSI_fontname, fontsize, charset, fontweight,
				ptsize, 0, 1,
				"WINDOWS/Ansi Font Select", "")) {
		g_ansi_fontname = ANSI_fontname;

		DeleteObject(ANSI_font);
		cur_font.lfFaceName       = ANSI_fontname;
		cur_font.lfCharSet        = ANSI_Charset;
		cur_font.lfHeight         = -15;
		cur_font.lfWidth          = 0;
		cur_font.lfEscapement     = 0;
		cur_font.lfWeight         = FW_NORMAL;
		cur_font.lfItalic         = 0;
		cur_font.lfUnderline      = 0;
		cur_font.lfStrikeOut      = 0;
		cur_font.lfOutPrecision   = OUT_DEFAULT_PRECIS;
		cur_font.lfCLipPrecision  = CLIP_DEFAULT_PRECIS;
		cur_font.lfQuality        = DRAFT_QUALITY;
		cur_font.lfPitchAndFamily = DEFAULT_PITCH;

		ANSI_font  = CreateFontIndirect(&cur_Font);

		tof;
		while (!at_eof) {
			t_str = get_line;
			if (find_text("AC=",1,0)) {
				if (find_text("/FT=",1,0)) {

					right;
					right;
					right;
					right;
					while (cur_char != "/") {
						del_char;
					}
					text(str(ansi_font));
				}
			}

			down;
			goto_col(1);
		}
		RedrawWindow(GetDlgItem(hdlg, ASCII_List_Ctrl), 0, 0, RDW_INVALIDATE);

	}
	goto_mark;
	insert_mode = t_insert_mode;
	switch_win_id(active_window);
	SetFocus(GetDlgItem(hdlg, ASCII_List_Ctrl));
	return_int = 0;
}

int AsciiMsgProc( int &retval, int window, int message, int wparam, int lparam, str parms ) no_break
{
	int OrgWin 		 = Window_Id;
	int SavRefresh = Refresh;

	switch ( Message ) {
		case WM_DESTROY :
			Set_Global_Str( "ASC_CHRT_FONTS",
				"/ANAME=" + g_ANSI_fontname +  "/ONAME=" + g_OEM_fontname );

			if ( Oem_Font ) {
				DeleteObject( Oem_Font );
			}
			if ( Ansi_Font ) {
				DeleteObject( Ansi_Font );
			}

			Refresh = False;
			if ( Switch_Win_Id( Ascii_Window ) ) {
				Delete_Window;
				Switch_Win_Id( OrgWin );
			}
			Refresh = SavRefresh;

//			RetVal = 0;
//			if (!ASCII_Modeless) {
//				DlgKill(ASCII_dlg);
//			}

			// deallocate globals
			Ansi_Font       = 0;
			Oem_Font        = 0;
			Ascii_Window    = 0;
			Ascii_hDlg      = 0;
			Ascii_Dlg       = 0;
			g_Ansi_Fontname = "";
			g_Oem_Fontname  = "";

			break;

		case WM_SYSCOMMAND :
			if ( WParam == SC_CLOSE ) {
				DestroyWindow( Window );
				RetVal = 0;
				return ( True );
			}
			break;

		case WM_COMMAND :
			switch ( WParam ) {
				case DLG_WCMD_INIT :
					Ascii_hDlg = Window;
					break;

				case 998 :
					WParam = GetDefaultButton( Window );
					if ( WParam ) {
						PostMessage( Window, wm_Command, WParam, LParam );
					}
					return( True );

				case ASCII_Paste_Ctrl :
				case ASCII_Close_Ctrl :

					int Selection = -1;

					Refresh = False;
					if ( Switch_Win_Id( Ascii_Window ) ) {
						Selection = C_Line - 1;
						Switch_Win_Id( OrgWin );
					}
					Refresh = SavRefresh;
					if ( WParam == ASCII_Paste_Ctrl ) {
						if ( Selection > -1 ) {
							Text( Char( Selection ) );
						}
					}
					if ( ASCII_Modeless ) {
						DestroyWindow( Window );
						RetVal = 0;
						return ( 1 );
					}
			}
			break;
	}
	return ( DlgMessageProc( RetVal, Window, Message, WParam, LParam, Parms ) );
}
