 /**************************************************************
 * GEV1_144.ctl - PC installer control file for Gallery Effects
 * 1.5.1 high density for 3 1/2 in. 
 * Copyright (C) 1994 Aldus Corporation.  All rights reserved.
 *
 *  MP 
 **************************************************************/

/* The PRODUCT command is required.  */
 

PRODUCT "Aldus Gallery Effects Vol 1"


VERSIONREQ "2.3"      /* minimum installer version required */

DISK "(1)"
   {
   _C_ALDUS.94          62,
   ALDSETUP.EXE     284720  CHECKDATE,
   GEV1_144.CTL       5060,
   README.TXT         6528,
   image.ti_        126618  "CLASSIC1.GE",
   chalkcha.8b_      83936  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   charcoal.8b_      83392  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   chrome.8b_        81152  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   classic.hl_       28259  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   craquelu.8b_      91776  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   darkstro.8b_      85392  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   drybrush.8b_      82288  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   emboss.8b_        78368  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   filmgrai.8b_      77216  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   fresco.8b_        87792  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   ge2samp1.8b_      81040  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   ge2samp1.hl_       8997  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   ge3sampl.8b_      81600  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   ge3sampl.hl_       9955  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   graphicp.8b_      79280  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   mosaic.8b_        88528  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   postered.8b_      80496  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   ripple.8b_        86848  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   smudgest.8b_      80544  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   spatter.8b_       77056  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   watercol.8b_      89600  "CLASSIC1.GE\PLUG_IN" CHECKDATE,
   msvideo.dl_      124416  "WINSYS"  CHECKDATE
   }

/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/


INITIAL GEDIR "C:\CLASSIC1.GE"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus Gallery Effects Vol. 1 files."
	" "
	"If this is the directory you want, click OK."
	}

DIALOG FoundGE "&Yes" "&No" 
{
	CAPTION "Aldus Gallery Effects found"
	TEXT
	{
	"An installed version of Aldus Gallery Effects was found." 
	"Do you want to install these files into the same directory?"
	""	
	""
	}
}

DIALOG BadMove "&Setup" "&Manual"
  {
	CAPTION "Modify your ULEAD.INI file?"
	TEXT
	{
	"Your ULEAD.INI must be modified in order to use"
	"Aldus Gallery Effects with Aldus PhotoStyler."
    "If you want Aldus Setup to modify the ULEAD.INI,"
    "click ""Setup."""
	"If you prefer to edit this file yourself, click ""Manual."""
	"See the ReadMe file for info about modifying the ULEAD.INI."
	}
  }
 
DIALOG ULEADINIFULL "OK" 
{
    CAPTION "Cannot modify ULEAD.INI"
    TEXT
    {

	"Your ULEAD.INI already contains the maximum"
	"number of PLUGIN entries. You must manually"
	"edit this file in order to use Gallery Effects"
	"with Aldus PhotoStyler. See the Readme file"
	"for more information."
	""
    }
}

DIALOG Successful "OK" 
{
    CAPTION "Setup complete"
    TEXT
    {

	"Aldus Gallery Effects Vol. 1 has been successfully installed."
	"See the Readme file for more info."
	""
    }
}

/*********** INITIALIZATION END *************/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{

    GETALDDIR AldDir
    GETWINDIR WinDir
    SET GEConfirmed "FALSE"
    GETWINSYSDIR WinSysDir
 
}   /* end of Prologue */

PACKAGE DataFiles "Gallery Effects Vol. 1" SELECTED
{  /**** Package Initializations *****/

	GETPERSONAL
	CONFIRMDIR GEDir
	CONCAT GEDir "PLUG_IN" PLUGINDir
    CONFIRMDIR AldDir
    CONCAT AldDir "USENGLSH" EngDir
    CONCAT EngDir "SETUP" SetupDir
	
	CONCAT GEDir "gallery.exe" FullGEName
	FILEEXIST FullGEName IsGeThere
	IF IsGeThere EQS "SUCCESS"
		{
		DISPLAY FoundGE InstallThere
    	IF InstallThere EQS "&No"
			{
			SET GEDir UNCONFIRMED
			CONFIRMDIR GEDir
			}
        }
        
	/**** File Subdirectory Assignments *****/

	FILES SetupDir
        {
        ALDSETUP.EXE
    	gev1_144.ctl
	    }
	
	FILES GEDir
	    {
        image.ti_
        readme.txt
        }

	FILES PLUGINDir
	    {
        chalkcha.8b_
        charcoal.8b_
        chrome.8b_  
        classic.hl_
        craquelu.8b_
        darkstro.8b_
        drybrush.8b_
        emboss.8b_
        filmgrai.8b_
        fresco.8b_
        ge2samp1.8b_
        ge2samp1.hl_
        ge3sampl.8b_
        ge3sampl.hl_
        graphicp.8b_
        mosaic.8b_
        postered.8b_
        ripple.8b_
        smudgest.8b_
        spatter.8b_
        watercol.8b_
  	    }

	FILES WinSysDir
	    {
	    msvideo.dl_
	    }

	
	CONCAT WinDir "ulead.ini" ULEADINI
	CONCAT WinDir "ulead.bak" ULEADBAK

	FILEEXIST ULEADINI TEST
	IF TEST EQS "SUCCESS"
   	{
      DISPLAY BadMove Answer2 
      IF Answer2 EQS "&Setup"
       	{
         COPY "" ULEADINI "" ULEADBAK
	 
    	 SET QUITSEARCH "FALSE"
         CD WinDir
    	 GETINISTRING "PLUG IN" "PLUGINDIR1" P1 "ULEAD.INI"
    	 IF P1 EQS "NOT_SET"
    	    {
       	     WRITEINISTRING "PLUG IN" "PLUGINDIR1" PLUGINDir "ulead.ini"
       	     SET QUITSEARCH "TRUE"
       	    }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR2" P2 "ULEAD.INI"
        	 IF P2 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR2" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR3" P3 "ULEAD.INI"
        	 IF P3 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR3" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR4" P4 "ULEAD.INI"
        	 IF P4 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR4" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR5" P5 "ULEAD.INI"
        	 IF P5 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR5" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR6" P6 "ULEAD.INI"
        	 IF P6 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR6" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR7" P7 "ULEAD.INI"
        	 IF P7 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR7" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR8" P8 "ULEAD.INI"
        	 IF P8 EQS "NOT_SET"
    	        {
                 WRITEINISTRING "PLUG IN" "PLUGINDIR8" PLUGINDir "ulead.ini"
                 SET QUITSEARCH "TRUE"
    	        }
      	     }
         IF QUITSEARCH EQS "FALSE"
            {
             GETINISTRING "PLUG IN" "PLUGINDIR9" P9 "ULEAD.INI"
        	 IF P9 EQS "NOT_SET"
    	        {
       	        WRITEINISTRING "PLUG IN" "PLUGINDIR9" PLUGINDir "ulead.ini"
       	        SET QUITSEARCH "TRUE"
       	        }
       	     IF P9 NES "NOT_SET"
       	        {
       	        DISPLAY ULEADINIFULL
       	        }
       	     }
        }
    }
    
    ONINSTALL
        {

        DISPLAY Successful 
        WINDOWSMENU GEDir "README.TXT" "&README.TXT" 
        } 

}

    /* End GE package */


