! atteasy.cmd 
!*********************************************************************
! usage: atteasy  argfile
!       argfile contains the easylink logon argument info
!*********************************************************************
! Date    Name   Description
! 431492  jackm  Original creation
!*********************************************************************

retries 2			! 3 tries total
! setvar infile "jjm"             ! Outbound edi file name
! setvar sndrloc "62053703"       ! Sender location
! setvar outfile "attedi.in"      ! Inbound edi file name 
! setvar easyid "EDI000052"       ! Easylink user id
! setvar easypwrd "OAKWHIST.USA"  ! Easylink Password
! setvar optionsw "S"             ! Option switch for send or receive
                                ! default is both
fopen 1, "$1"                   ! File containg all of the easylink 
                                ! configuration arguments
repeat
freadln 1, inbuf            ! Loading all of the environment variables
   setvar in_arg left(inbuf,2)
   setvar length  len(inbuf) -2 
   switch
      case in_arg = "1:"        ! Receive file name 
         setvar infile midstr(inbuf, 3, length)
      case in_arg = "2:"        ! Your easylink id
         setvar easyid midstr(inbuf,3, length)
      case in_arg = "3:"        ! Your easylink password
         setvar easypwrd midstr(inbuf, 3, length)
      case in_arg = "4:"        ! File containing list of sender codes and   
                                !  outbound file names 
         setvar filelist midstr(inbuf, 3, length) 
     case in_arg = "5:"         ! file transfer option switch  
                                !       S for send only
                                !       R for receive only
                                !       B for both send and receive
         setvar optionw midstr(inbuf,3, 1)
     case in_arg = "6:"         ! file transfer option switch  
         setvar logfile midstr(inbuf,3, length)
   endswitch
until feof(1)
fclose (1)
on abort
	? "^C operator abort"
	hangup
	quit
endon
DTIMEOUT 40
capture disk $(logfile) on OVERWRITE
capture on
? "Connecting to at&t easy link network"
baud 2400,e,7,1
call 1-800-325-4112
protocol xmodem
!terminal
break
dwait "EASYLINK|ID?", 25
dwait 5
xmit "35 $(easyid) $(easypwrd)\r"
dwait "PTS",20
if _timeout
   ? "\nFailed to logon to easylink check your password\n"
   hangup
   quit
endif
capture off 
setvar optionsw toupper (optionw)  ! Make sure option switch is upper case 
if (optionsw = "S" or optionsw = "B")
   fopen 2,filelist      !* List of desination locations and files to send 
   freadln  2, inbuf    !* Read the input file for sender and file 
   repeat 
       capture on
       setvar sndrloc left(inbuf, 8)
       setvar length len(inbuf) -9
       if length < 1
           ? "\nFile or sender code in error file was not sent:\n" +inbuf + "\n"
       else
           setvar outfile midstr(inbuf, 10,length)
       
           if exists("$(outfile)") !* If outbound file exists send it to network
              ? "\nEasylink outbound file: "+ outfile + " \nAccount: " + sndrloc
              do @attsnd
           else
              ? "Easylink outbound file not sent: "+ outfile  
              ? "Account:" + sndrloc + " File did not exist.\n"
           endif
       endif
       freadln  2, inbuf    !* Read the input file for sender and file 
    until feof(2) 
    capture off
    fclose (2)
endif
if (optionsw = "R" or optionsw = "B")
   do @attrcv
endif

xmit "SCAN\r" , 45
capture on
dwait "MAILBOX", 45
xmit "MMMM\r"
capture off 

!noerror HANGUP
!return
capture close
hangup
quit
!**********************************************
! The send proc
!**********************************************
proc attsnd
xmit "$(sndrloc)+\r" 
capture off
dwait "GA",10
xmit "/XMODEM BIN\r"
dwait "XMODEM:", 10
dwait 5
send  $(outfile)
dwait "PTS" ,16
capture on
endproc attsnd


!*********************************************************************
! The receive only proc
!*********************************************************************
proc attrcv
xmit "MBX XMODEM\r"
dwait "XMODEM" ,16
dwait 2
rcv $(infile)
capture on
dwait "PTS", 15
capture off
endproc attrcv
