
/*************************************************************************
 *  ATTFMT                                                               *
 *     - Program to format X12 data for transmission to the ATT GMS data *
 *       network.  This formatting involves simply adding a header to    *
 *       the front of the file.  In the future, the program may need to  *
 *       split out interchanges containing 841 (binary data) transaction *
 *       sets.                                                           *
 *                                                                       *
 *************************************************************************
*/

#include <stdio.h>

main( argc, argv )
    int argc;
    char *argv[];
    {

    FILE *ifp, *ofp;
    char buf[5120];
    char hdr[] = ">To: !edi\r\nContent-Type: X12\r\n\r\n";
    short x;

    if( argc < 3 )
        {
        puts( "\nattfmt - Program to format X12 data for the ATT GMS network" );
        puts( "\n   Usage:    attfmt infile outfile\n" );
        exit( -1 );
        }

    if( (ifp = fopen( argv[1], "rb" )) == NULL )
        {
        perror( "attfmt: could not open input file" );
        exit( -380 );
        }

    if( (ofp = fopen( argv[2], "wb" )) == NULL )
        {
        perror( "attfmt: could not open output file" );
        fclose( ifp );
        exit( -380 );
        }

    fwrite( hdr, 1, strlen( hdr ), ofp );

    while( (x = fread( buf, 1, sizeof( buf ), ifp )) > 0 )
        fwrite( buf, 1, x, ofp );

    fclose( ifp );
    fclose( ofp );
    exit( 0 );
    }

